﻿// Copyright (c) AlphaSierraPapa for the SharpDevelop Team
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy of this
// software and associated documentation files (the "Software"), to deal in the Software
// without restriction, including without limitation the rights to use, copy, modify, merge,
// publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons
// to whom the Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in all copies or
// substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
// FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

using System;

public class UndocumentedExpressions
{
	public static int GetArgCount(__arglist)
	{
		ArgIterator argIterator = new ArgIterator(__arglist);
		return argIterator.GetRemainingCount();
	}
	
	public static void MakeTypedRef(object o)
	{
		TypedReference tr = __makeref(o);
		UndocumentedExpressions.AcceptTypedRef(tr);
	}
	
	private static void AcceptTypedRef(TypedReference tr)
	{
		Console.WriteLine("Value is: " + __refvalue(tr, object).ToString());
		Console.WriteLine("Type is: " + __reftype(tr).Name);
		__refvalue(tr, object) = 1;
	}
}
