# Documentation for mlpack

<!--
This file contains the landing page for mlpack documentation.  Note that if you
add new documentation, the sidebar in sidebar.html will need to be manually
modified!  In addition, you should modify the pipeline SVGs (see the comment
below.)
-->

mlpack is an intuitive, fast, and flexible header-only C++ machine learning
library with bindings to other languages.  It aims to provide fast, lightweight
implementations of both common and cutting-edge machine learning algorithms.

mlpack's lightweight C++ implementation makes it ideal for deployment, and it
can also be used for interactive prototyping via C++ notebooks (see
[here](https://mybinder.org/v2/gh/mlpack/examples/HEAD) for a BinderHub instance
on the [examples repository](https://github.com/mlpack/examples/)).

In addition to its [powerful C++ interface](quickstart/cpp.md), mlpack also
provides [command-line programs](quickstart/cli.md), and bindings to the
[Python](quickstart/python.md), [R](quickstart/r.md),
[Julia](quickstart/julia.md), and [Go](quickstart/go.md) languages.

_If you use mlpack, please [cite the software](citation.md)._

---

<!-- NOTE: If you are updating the pipeline image, make sure to update *both*
           the wide and narrow versions.  Yes, it is tedious, but we are limited
           by what HTML allows us. -->
<object data="img/pipeline-wide.svg" type="image/svg+xml" id="pipeline-wide">
    (Your browser does not support inline SVG objects.  Browse the mlpack
     pipeline using the navigation sidebar instead.)
</object>
<object data="img/pipeline-narrow.svg" type="image/svg+xml" id="pipeline-narrow">
    (Your browser does not support inline SVG objects.  Browse the mlpack
     pipeline using the navigation sidebar instead.)
</object>

## Changelog

For a list of changes in each version of mlpack, see the
[changelog](HISTORY.md).
