/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQEcChartsDialog_H
#define MvQEcChartsDialog_H

#include <QDialog>
#include <QLineEdit>

using namespace std;

class MvQEcChartsDialog : public QDialog
{
    Q_OBJECT

public:
    MvQEcChartsDialog(int, int, QWidget* parent = 0);
    ~MvQEcChartsDialog();

    // Get info from the user interface
    string getLayerName()
    {
        return leLayerNameSelection_->text().toStdString();
    }

    string getOutputFileName()
    {
        return leOutputFileNameSelection_->text().toStdString();
    }

public slots:
    void accept();

protected:
    void setVisible(bool b)
    {
        QDialog::setVisible(b);
    }

    void readSettings();
    void writeSettings();

private:
    QLineEdit* leLayerNameSelection_;
    QLineEdit* leOutputFileNameSelection_;

    string layerName_;
    string outputFileName_;
};

#endif
