/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MVQMETHODS_H
#define MVQMETHODS_H

#include <QPixmap>
#include <QSettings>
#include <QString>
#include <QTextLayout>

class QAction;
class QButtonGroup;
class QComboBox;
class QLineEdit;
class QStackedWidget;
class QTabWidget;
class QTreeView;

#ifdef __APPLE__
#define MVQ_QSETTINGS_DEFAULT_ARGS QSettings::IniFormat, QSettings::UserScope, "ECMWF"
#else
#define MVQ_QSETTINGS_DEFAULT_ARGS QSettings::NativeFormat, QSettings::UserScope, "ECMWF"
#endif

namespace MvQ
{
void initComboBox(QSettings&, QString key, QComboBox* cb);
void initTabId(QSettings& settings, QString key, QTabWidget* tab);
void saveTabId(QSettings& settings, QString key, QTabWidget* tab);
void initTreeColumnWidth(QSettings& settings, QString key, QTreeView* tree);
void saveTreeColumnWidth(QSettings& settings, QString key, QTreeView* tree);
void initStacked(QSettings& settings, QString key, QStackedWidget* stacked);
void initButtonGroup(QSettings& settings, QString key, QButtonGroup* bg);
void initCheckableAction(QSettings& settings, QString key, QAction* ac);
void showTabLabel(QTabWidget* tab, int index, QPixmap pix);
void hideTabLabel(QTabWidget* tab, int index);
QString formatBoldText(QString txt, QColor col);
QString formatText(QString txt, QColor col);
QString formatTableThText(QString txt, QColor col);
QString formatTableTrBg(QString txt, QColor col);
QString formatTableTdText(QString txt, QColor col);
QString formatTableTdBg(QString txt, QColor col);
QString formatTableRow(QString col1Text, QString col2Text, QColor bg, QColor fg, bool boldCol1);
void toClipboard(QString txt);
QString fromClipboard();
void initSettings(QString path);
QString iconPixmapPath(QString name);
void setLineEditTextFormat(QLineEdit* lineEdit, const QList<QTextLayout::FormatRange>& formats);
void clearLineEditTextFormat(QLineEdit* lineEdit);
bool hasOpenGLSupport();
void changeFontSize(QWidget*, int delta);
void setFontSize(QWidget*, int fs);
void showShortcutInContextMenu(QWidget*);
void showShortcutInContextMenu(QList<QAction*>);
QString formatShortCut(QString);
QString formatShortCut(QAction*);
void addShortCutToToolTip(QWidget*);
void addShortCutToToolTip(QList<QAction*>);

}  // namespace MvQ

#endif  // MVQMETHODS_H
