/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQMemoryWidget_H
#define MvQMemoryWidget_H

#include <QFile>
#include <QLabel>

using namespace std;

class MvQMemoryWidget : public QLabel
{
    Q_OBJECT

public:
    MvQMemoryWidget(QWidget* parent = 0);

    long memTotal();
    long memFree();
    long maxrss();

public slots:
    void slotRefresh();

protected:
    bool parseMemInfoLine(QString, QString, long&, QString&);

    int pid_;
    QFile memInfoFile_;
    long memTotal_;
    long memFree_;
    QString memTotalUnit_;
    QString memFreeUnit_;
    long maxrss_;
};


#endif