/***************************** LICENSE START ***********************************

 Copyright 2018 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MVSCI_H
#define MVSCI_H

#include <string>

class MvSci
{
public:
    static double saturationMixingRatio(double t, double p);
    static double relativeHumidity(double t, double p, double q);
    static double relativeHumidityFromTd(double t, double td);
    static double specificHumidity(double t, double p, double r);
    static double specificHumidityFromTd(double t, double p, double td);
    static double saturationVapourPressure(double t);
    static double vapourPressure(double p, double q);
    static double vapourPPMV(double p, double q);
    static double ozonePPMV(double r);
    static double dewPointFromQ(double p, double t, double q, const std::string& formula);
    static double speed(double u, double v);
    static double direction(double u, double v);
};

#endif  // MVSCI_H
