/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef TemporaryObject_H
#define TemporaryObject_H

#include "IconObject.h"
#include "Request.h"

#include <string>
using std::string;

class TemporaryObject : public IconObject
{
public:
    TemporaryObject(IconObject*, const Request&, const IconClass* = 0);
    virtual ~TemporaryObject();

protected:
    TemporaryObject(const TemporaryObject&);
    TemporaryObject& operator=(const TemporaryObject&);

    virtual void createFiles();
    //virtual Log& log();
    virtual Request request() const;
    virtual void request(const Request&);
    virtual string fullName() const;
    virtual Path path() const;
    // Different implementation of the path() if used by a
    // ShellTask.
    // For TemporaryObject Objects, it will return the PATH of the attached request, (if it exists)
    // This is done to enable the visualisation of the MAGML Objects
    // without possible side effects!
    virtual Path pathForShellTask() const;
    virtual Path dotPath() const;
    virtual Folder* parent() const;

    virtual bool rename(const string&);
    virtual bool renamable() const;
    virtual bool temporary() const;

    virtual Folder* embeddedFolder(const string& n, bool) const;
    virtual Path embeddedPath() const;
    virtual Folder* embeddedFolder(bool) const;

    virtual string relativeName(IconObject*) const;
    virtual string makeFullName(const string&) const;

private:
    IconObjectH ref_;
    Request request_;
};

inline void destroy(TemporaryObject**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(TemporaryObject);
//#endif

#endif
