/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef LAYOUTP_H
#define LAYOUTP_H



typedef struct _LayoutClassPart {
    int         ignore;
} LayoutClassPart;

typedef struct _LayoutClassRec {
    CoreClassPart           core_class;
    CompositeClassPart      composite_class;
    ConstraintClassPart     constraint_class;
    XmManagerClassPart      manager_class;
    LayoutClassPart         layout_class;
} LayoutClassRec;

extern LayoutClassRec layoutClassRec;

typedef struct {

	Pixel   foreground;
	Boolean editable;
	Boolean dont_insert;

	XRectangle     selrect;
	int            lastx;
	int            lasty;
	Boolean        move;

	XmFontList fontlist;
	Pixel     label_color;        /* Color of the normal text */
	GC        label_gc;           /* Gc for the normal text   */

} LayoutPart;

typedef struct _LayoutRec {
    CorePart            core;
    CompositePart       composite;
    ConstraintPart      constraint;
    XmManagerPart       manager;
    LayoutPart          layout;
}  LayoutRec;

typedef struct _LayoutConstraintsPart {
	double top;
	double left;
	double bottom;
	double right;
} LayoutConstraintsPart;

typedef struct _LayoutConstraintsRec {
    LayoutConstraintsPart layout;
} LayoutConstraintsRec, *LayoutConstraints;


#define LAYOUT_CONSTRAINT(w) \
                   ((LayoutConstraints)((w)->core.constraints))

#define LayoutNumChildren(w) (((LayoutWidget)w) -> composite.num_children)
#define LayoutChild(w,i)     (((LayoutWidget)w) -> composite.children[i])

#endif 



