/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File ScaleLine.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef ScaleLine_H
#define ScaleLine_H

#include "UIScaleLine.h"

#ifndef RequestPanelLine_H
#include "RequestPanelLine.h"
#endif

class ScaleLine : public XRequestPanelLine<UIScaleLine_c> {
public:

// -- Contructors

	ScaleLine(RequestPanel&,const Parameter&);

// -- Destructor

	virtual ~ScaleLine(); 

private:

// No copy allowed

	ScaleLine(const ScaleLine&);
	ScaleLine& operator=(const ScaleLine&);

// -- Overridden methods

	// From XD
	virtual void changedCB(Widget,XtPointer);

	// From RequestPanelItem

	virtual void set(Request&);
	virtual void refresh(const vector<string>&);

	// From RequestPanelLine
	virtual void init(Widget);

};

#endif
