/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef EditorFactory_H
#include "EditorFactory.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif

#ifndef Editor_H
#include "Editor.h"
#endif

#ifndef ReplyObserver_H
#include "ReplyObserver.h"
#endif

#ifndef QtOgcClientEditor_H
#include "QtOgcClientEditor.h"
#endif


QtOgcClientEditor::QtOgcClientEditor(const IconClass& name,const string& kind):
    Editor(name,kind)
{
}

QtOgcClientEditor::~QtOgcClientEditor()
{
}



// -----------------------------------------------------------------
// QtOgcClientEditor::edit
// Called to start editing a macro. We call the macroedit service to
// bring up the Qt macro editor.

void QtOgcClientEditor::edit(void)
{
    string path = current_->path().str();

    replyObserver_ = new OgcClientEditorObserver(*this, path);
    replyObserver_->start();


//    replyObserver_->callService("macroedit", r);


//    task_->start();


}




//=================================================================

OgcClientEditorObserver::OgcClientEditorObserver(QtOgcClientEditor &editor, string &path) :
    editor_(editor), path_(path)
{
}

OgcClientEditorObserver::~OgcClientEditorObserver()
{
}


void OgcClientEditorObserver::start()
{
    // Editor::edit will already have set up the path that we need
    MvRequest r;

    r.read(path_.c_str());

    const char *verb=r.getVerb();

    if(!verb) return;	

    if(strcmp(verb,"WMSCLIENT")==0)
    {
    	r("_NAME")=path_.c_str();
    	r("_CLASS")="WMSCLIENT";
    	r("_ACTION")="edit";
    	r("_SERVICE")="wmsclient";
	r.print();

	callService("wmsclient", r);

    }
    else if(strcmp(verb,"WCSCLIENT")==0)
    {
    	r("_NAME")=path_.c_str();
    	r("_CLASS")="WCSCLIENT";
    	r("_ACTION")="edit";
    	r("_SERVICE")="wcsclient";
	r.print();

	callService("wcsclient", r);

    }
		
   /* MvRequest r("OGCCLIENT");

 
    r("PATH")     = path_.c_str();  // path to macro
    //r("LANGUAGE") = editor_.iconClass().name().c_str(); // icon class, e.g. MACRO or MAGML*/
    //callService("ogcclient", r);
//    MvApplication::callService("macroedit", r, NULL);

}


void OgcClientEditorObserver::reply(const Request& r,int err)
{

    editor_.notifyObserverApply();
    editor_.Editor::done();

}

void OgcClientEditorObserver::progress(const Request& r)
{
}

void OgcClientEditorObserver::message(const string& msg)
{
}


void OgcClientEditorObserver::print(ostream& s) const
{
}





static EditorMaker<QtOgcClientEditor> editorMaker("QtOgcClientEditor");

