/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ExternalHelp_H
#include "ExternalHelp.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef Parameter_H
#include "Parameter.h"
#endif

#ifndef HelpFactory_H
#include "HelpFactory.h"
#endif

#ifndef RequestPanel_H
#include "RequestPanel.h"
#endif

#include <mars.h>

ExternalHelp::ExternalHelp(Widget parent, RequestPanel& owner, const Parameter& def):
	DialogHelp(parent, owner, def)
{     
}


ExternalHelp::~ExternalHelp()
{
}

void ExternalHelp::start()
{
        attach(); // Will be decremented by ReplyHandler, so make sure it stays alive.

	Request info = param_.interfaceRequest();

	Request request((const char*) info("help_verb"));
	request.merge(owner_.request());	
	callService((const char*) info("help_module"), request);
}

void ExternalHelp::set(Request& r) 
{
	r.merge(request_);
	request_ = Request();
}

void ExternalHelp::reply(const Request& reply, int error)
{
	 cout << "ExternalHelp::reply" << endl;
	 if ( error == 0 ) reply.print();
}

void ExternalHelp::progress(const Request& progress)
{
	cout << "ExternalHelp::progress" << endl;
	progress.print();
	request_ = progress;
	owner_.changed(*this);
}

void ExternalHelp::message(const string& msg)
{
	cout << "ExternalHelp::message" << msg << endl;
}

static HelpMaker<ExternalHelp> maker("help_external");
