/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef EditorDrawerFactory_H
#include "EditorDrawerFactory.h"
#endif

#ifndef EditorDrawer_H
#include "EditorDrawer.h"
#endif

typedef multimap<int,EditorDrawerFactory*> Map;

static Map *makers= 0;

EditorDrawerFactory::EditorDrawerFactory(int n)
{
	if(makers == 0)
		makers = new Map();

	makers->insert(Map::value_type(n,this));
}

EditorDrawerFactory::~EditorDrawerFactory()
{
	// Not called
}

map<string,EditorDrawer*> EditorDrawerFactory::create(InternalEditor *e)
{
	 map<string,EditorDrawer*> m;
	 for(Map::iterator j = makers->begin(); j != makers->end(); ++j)
	 {
	 		EditorDrawer* d = (*j).second->make(e);
			if(d != 0) m[d->name()] = d;
	 }
	 return m;

}
