/***************************** LICENSE START ***********************************

 Copyright 2013 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Log_H
#define Log_H

#include "inc_iostream.h"
#include "inc_stl.h"

#include "Path.h"

class IconObject;

class Log 
{
public:
	Log(IconObject*);
	~Log(); 

	operator ostream&() ;
	const Path& path();

	static ostream& info(IconObject*);
	static ostream& warning(IconObject*);
	static ostream& error(IconObject*);
	static ostream& syserr(ostream&);

	static ostream& info(const string&);
	static ostream& warning(const string&);
	static ostream& error(const string&);

private:
	// No copy allowed
	Log(const Log&);
	Log& operator=(const Log&);

	Path              path_;
	auto_ptr<ostream> out_;
	auto_ptr<ostream> tee_;
	IconObject* object_;

	static ostream& global();
	static ostream& find(IconObject*);

};

inline void destroy(Log**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Log);
//#endif

#endif
