

/* Copyright (C) 2005-2017 Massachusetts Institute of Technology
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


// 322:  Redundant declarations are ok. The wrappers are created correctly.
// 503:  We don't need to create class-specific wrappers for friend functions
%warnfilter(322,509) meep::component_direction;
%warnfilter(322,509) meep::direction_component;
%warnfilter(322,503) meep::zero_vec;
%warnfilter(322,503) meep::veccyl;
%warnfilter(322,503) meep::zero_ivec;
%warnfilter(322,503) meep::one_ivec;
%warnfilter(322,503) meep::iveccyl;
%warnfilter(322) meep::abort;
%warnfilter(503) meep::one_vec;
%warnfilter(503) meep::volcyl;
%warnfilter(503) meep::volone;
%warnfilter(503) meep::vol1d;
%warnfilter(503) meep::voltwo;
%warnfilter(503) meep::vol2d;
%warnfilter(503) meep::vol3d;
%warnfilter(503) meep::identity;
%warnfilter(503) meep::rotate4;
%warnfilter(503) meep::rotate2;
%warnfilter(503) meep::mirror;
%warnfilter(503) meep::r_to_minus_r_symmetry;
%warnfilter(509) meep::component_name;
%warnfilter(509) meep::coordinate_mismatch;
%warnfilter(509) meep::ivec::ivec;
%warnfilter(509) meep::symmetry::transform;
%warnfilter(509) meep::symmetry::phase_shift;
%warnfilter(509) meep::structure::structure;
%warnfilter(509) meep::fields::get_eigenmode_coefficients;
%warnfilter(451) meep::structure::outdir;
%warnfilter(451) meep::fields_chunk::outdir;
%warnfilter(325) meep::h5file::extending_s;
%warnfilter(509) _get_eigenmode;

// Renaming python builtins
%rename(meep_type) meep::type;
%rename(vec_abs) meep::abs;
%rename(vec_max) meep::max;
%rename(vec_min) meep::min;
%rename(vec_str) meep::vec::str;
%rename(ivec_str) meep::ivec::str;
%rename(print_grid_volume) meep::grid_volume::print;
%rename(symmetry_reduce) meep::symmetry::reduce;

// Operator renaming
%rename(__contains__) meep::volume::operator&&;
%rename(__getitem__) meep::grid_volume::operator[];
%rename(symmetry_assign) meep::symmetry::operator=;

%rename(vec_dim_val) meep::vec::vec(ndim, double);
%rename(vec_dim) meep::vec::vec(ndim);

// ignore methods that conflict with python built-ins
%ignore meep::vec::str;
%ignore meep::ivec::str;
%ignore meep::volume::str;
%ignore meep::grid_volume::str;


// Include the C++ class declarations
%include "meep/vec.hpp"

%extend meep::vec {
    const char *__repr__() { return $self->str(); }
}

%extend meep::ivec {
    const char *__repr__() { return $self->str(); }
}

%extend meep::volume {
    const char *__repr__() { return $self->str(); }
}

%extend meep::grid_volume {
    const char *__repr__() { return $self->str(); }
}
