# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.widget_representation import WidgetRepresentation


class CoordinateFrameRepresentation(WidgetRepresentation):
    r"""
    CoordinateFrameRepresentation - a class defining the
    representation for a CoordinateFrameWidget
    
    Superclass: WidgetRepresentation
    
    This class is a concrete representation for the
    CoordinateFrameWidget. It represents a coordinate frame with an
    origin, 3 axis and 3 axis lockers. Through interaction with the
    widget, the coordinate frame can be manipulated by adjusting the axis
    normals, locking them, or moving/picking the origin point.
    
    The place_widget() method is also used to initially position the
    representation.
    
    @warning
    This class, and CoordinateFrameWidget, are next generation VTK
    widgets.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCoordinateFrameRepresentation, obj, update, **traits)
    
    lock_normal_to_camera = tvtk_base.false_bool_trait(desc=\
        r"""
        If enabled, and a Camera is available through the renderer,
        then lock_normal_to_camera will cause the normal to follow the
        camera's normal.
        """
    )

    def _lock_normal_to_camera_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLockNormalToCamera,
                        self.lock_normal_to_camera_)

    pick_camera_focal_info = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _pick_camera_focal_info_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPickCameraFocalInfo,
                        self.pick_camera_focal_info_)

    interaction_state = traits.Trait(0, traits.Range(0, 8, enter_set=True, auto_set=False), desc=\
        r"""
        The interaction state may be set from a widget (e.g.,
        CoordinateFrameWidget) or other object. This controls how the
        interaction with the widget proceeds. Normally this method is
        used as part of a handshaking process with the widget: First
        compute_interaction_state() is invoked that returns a state based
        on geometric considerations (i.e., cursor near a widget feature),
        then based on events, the widget may modify this further.
        """
    )

    def _interaction_state_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInteractionState,
                        self.interaction_state)

    length_factor = traits.Trait(0.04, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Set/get the length of the axis glyphs relative to screen size.
        The default is 0.04.
        """
    )

    def _length_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLengthFactor,
                        self.length_factor)

    locked_axis = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _locked_axis_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLockedAxis,
                        self.locked_axis)

    origin = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Set/Get the origin of the coordinate frame.
        """
    )

    def _origin_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOrigin,
                        self.origin)

    representation_state = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Sets the visual appearance of the representation based on the
        state it is in. This state is usually the same as
        interaction_state.
        """
    )

    def _representation_state_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRepresentationState,
                        self.representation_state)

    def _get_locked_x_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetLockedXVectorProperty())
    locked_x_vector_property = traits.Property(_get_locked_x_vector_property, desc=\
        r"""
        Get the properties on the locked_x_vector. The properties of the
        locked_x_vector when selected and unselected can be manipulated.
        """
    )

    def _get_locked_y_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetLockedYVectorProperty())
    locked_y_vector_property = traits.Property(_get_locked_y_vector_property, desc=\
        r"""
        Get the properties on the locked_y_vector. The properties of the
        locked_y_vector when selected and unselected can be manipulated.
        """
    )

    def _get_locked_z_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetLockedZVectorProperty())
    locked_z_vector_property = traits.Property(_get_locked_z_vector_property, desc=\
        r"""
        Get the properties on the locked_z_vector. The properties of the
        locked_z_vector when selected and unselected can be manipulated.
        """
    )

    def _get_origin_property(self):
        return wrap_vtk(self._vtk_obj.GetOriginProperty())
    origin_property = traits.Property(_get_origin_property, desc=\
        r"""
        Get the properties of the origin. The properties of the origin
        when selected and unselected can be manipulated.
        """
    )

    def _get_selected_locked_x_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedLockedXVectorProperty())
    selected_locked_x_vector_property = traits.Property(_get_selected_locked_x_vector_property, desc=\
        r"""
        
        """
    )

    def _get_selected_locked_y_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedLockedYVectorProperty())
    selected_locked_y_vector_property = traits.Property(_get_selected_locked_y_vector_property, desc=\
        r"""
        
        """
    )

    def _get_selected_locked_z_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedLockedZVectorProperty())
    selected_locked_z_vector_property = traits.Property(_get_selected_locked_z_vector_property, desc=\
        r"""
        
        """
    )

    def _get_selected_origin_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedOriginProperty())
    selected_origin_property = traits.Property(_get_selected_origin_property, desc=\
        r"""
        
        """
    )

    def _get_selected_unlocked_x_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedUnlockedXVectorProperty())
    selected_unlocked_x_vector_property = traits.Property(_get_selected_unlocked_x_vector_property, desc=\
        r"""
        
        """
    )

    def _get_selected_unlocked_y_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedUnlockedYVectorProperty())
    selected_unlocked_y_vector_property = traits.Property(_get_selected_unlocked_y_vector_property, desc=\
        r"""
        
        """
    )

    def _get_selected_unlocked_z_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedUnlockedZVectorProperty())
    selected_unlocked_z_vector_property = traits.Property(_get_selected_unlocked_z_vector_property, desc=\
        r"""
        
        """
    )

    def _get_selected_x_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedXVectorProperty())
    selected_x_vector_property = traits.Property(_get_selected_x_vector_property, desc=\
        r"""
        
        """
    )

    def _get_selected_y_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedYVectorProperty())
    selected_y_vector_property = traits.Property(_get_selected_y_vector_property, desc=\
        r"""
        
        """
    )

    def _get_selected_z_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedZVectorProperty())
    selected_z_vector_property = traits.Property(_get_selected_z_vector_property, desc=\
        r"""
        
        """
    )

    def _get_unlocked_x_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetUnlockedXVectorProperty())
    unlocked_x_vector_property = traits.Property(_get_unlocked_x_vector_property, desc=\
        r"""
        Get the properties on the unlocked_x_vector. The properties of the
        unlocked_x_vector when selected and unselected can be manipulated.
        """
    )

    def _get_unlocked_y_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetUnlockedYVectorProperty())
    unlocked_y_vector_property = traits.Property(_get_unlocked_y_vector_property, desc=\
        r"""
        Get the properties on the unlocked_y_vector. The properties of the
        unlocked_y_vector when selected and unselected can be manipulated.
        """
    )

    def _get_unlocked_z_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetUnlockedZVectorProperty())
    unlocked_z_vector_property = traits.Property(_get_unlocked_z_vector_property, desc=\
        r"""
        Get the properties on the unlocked_z_vector. The properties of the
        unlocked_z_vector when selected and unselected can be manipulated.
        """
    )

    def _get_x_vector_normal(self):
        return self._vtk_obj.GetXVectorNormal()
    x_vector_normal = traits.Property(_get_x_vector_normal, desc=\
        r"""
        
        """
    )

    def _get_x_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetXVectorProperty())
    x_vector_property = traits.Property(_get_x_vector_property, desc=\
        r"""
        Get the properties on the XVector. The properties of the XVector
        when selected and unselected can be manipulated.
        """
    )

    def _get_y_vector_normal(self):
        return self._vtk_obj.GetYVectorNormal()
    y_vector_normal = traits.Property(_get_y_vector_normal, desc=\
        r"""
        
        """
    )

    def _get_y_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetYVectorProperty())
    y_vector_property = traits.Property(_get_y_vector_property, desc=\
        r"""
        Get the properties on the YVector. The properties of the YVector
        when selected and unselected can be manipulated.
        """
    )

    def _get_z_vector_normal(self):
        return self._vtk_obj.GetZVectorNormal()
    z_vector_normal = traits.Property(_get_z_vector_normal, desc=\
        r"""
        
        """
    )

    def _get_z_vector_property(self):
        return wrap_vtk(self._vtk_obj.GetZVectorProperty())
    z_vector_property = traits.Property(_get_z_vector_property, desc=\
        r"""
        Get the properties on the ZVector. The properties of the ZVector
        when selected and unselected can be manipulated.
        """
    )

    def is_translation_constrained(self):
        """
        is_translation_constrained(self) -> bool
        C++: bool is_translation_constrained()
        Returns true if contrained_axis
        """
        ret = self._vtk_obj.IsTranslationConstrained()
        return ret
        

    def pick_direction_point(self, *args):
        """
        pick_direction_point(self, X:int, Y:int, snapToMeshPoint:bool=False)
             -> bool
        C++: bool pick_direction_point(int X, int Y,
            bool snapToMeshPoint=false)
        Given the X, Y display coordinates, pick a point and using the
        origin define normal for the coordinate frame from a point that
        is on the objects rendered by the renderer.
        
        Note: if a point from a rendered object is not picked, the camera
        focal point can optionally be set.
        """
        ret = self._wrap_call(self._vtk_obj.PickDirectionPoint, *args)
        return ret

    def pick_normal(self, *args):
        """
        pick_normal(self, X:int, Y:int, snapToMeshPoint:bool=False) -> bool
        C++: bool pick_normal(int X, int Y, bool snapToMeshPoint=false)
        Given the X, Y display coordinates, pick a new normal for the
        coordinate frame from a point that is on the objects rendered by
        the renderer.
        
        Note: if a normal from a rendered object is not picked, the
        camera plane normal can optionally be set.
        """
        ret = self._wrap_call(self._vtk_obj.PickNormal, *args)
        return ret

    def pick_origin(self, *args):
        """
        pick_origin(self, X:int, Y:int, snapToMeshPoint:bool=False) -> bool
        C++: bool pick_origin(int X, int Y, bool snapToMeshPoint=false)
        Given the X, Y display coordinates, pick a new origin for the
        coordinate frame from a point that is on the objects rendered by
        the renderer.
        
        Note: if a point from a rendered object is not picked, the camera
        focal point can optionally be set.
        """
        ret = self._wrap_call(self._vtk_obj.PickOrigin, *args)
        return ret

    def reset(self):
        """
        reset(self) -> None
        C++: void reset()
        Reset the origin (by calling update placement) and the axes (to
        be aligned with the world coordinate X, Y, and Z axes).
        """
        ret = self._vtk_obj.Reset()
        return ret
        

    def reset_axes(self):
        """
        reset_axes(self) -> None
        C++: void reset_axes()
        Reset only the axis orientations (not the origin).
        """
        ret = self._vtk_obj.ResetAxes()
        return ret
        

    def set_direction(self, *args):
        """
        set_direction(self, x:float, y:float, z:float) -> None
        C++: void set_direction(double x, double y, double z)
        set_direction(self, d:[float, float, float]) -> None
        C++: void set_direction(double d[3])
        Set the direction of the locked (or absent a locked axis, the
        nearest axis) to point from the frame's origin toward the given
        (x,y,z) location.
        """
        ret = self._wrap_call(self._vtk_obj.SetDirection, *args)
        return ret

    def set_normal(self, *args):
        """
        set_normal(self, x:float, y:float, z:float) -> None
        C++: void set_normal(double x, double y, double z)
        set_normal(self, n:[float, float, float]) -> None
        C++: void set_normal(double n[3])
        Set/Get the normal of one of the axes of the coordinate frame.
        
        1) If 1 arrow tip is constrained, the corresponding normal vector
        is set to the picked normal.
        2) Otherwise, the axis closest to the picked normal (i.e., with
           the largest dot product) is reset to the picked normal.
        
        In both cases, the remaining normals are re-orthogonalized using
        the <a
        href="https://en.wikipedia.org/wiki/Gram%E2%80%93Schmidt_process">
        Gram-Schmidt procedure.
        """
        ret = self._wrap_call(self._vtk_obj.SetNormal, *args)
        return ret

    def set_normal_to_camera(self):
        """
        set_normal_to_camera(self) -> None
        C++: void set_normal_to_camera()"""
        ret = self._vtk_obj.SetNormalToCamera()
        return ret
        

    def set_translation_axis_off(self):
        """
        set_translation_axis_off(self) -> None
        C++: void set_translation_axis_off()"""
        ret = self._vtk_obj.SetTranslationAxisOff()
        return ret
        

    def set_x_axis_vector(self, *args):
        """
        set_x_axis_vector(self, v:(float, float, float)) -> None
        C++: void set_x_axis_vector(const double v[3])
        set_x_axis_vector(self, x:float, y:float, z:float) -> None
        C++: void set_x_axis_vector(double x, double y, double z)
        Force an axis to be aligned with the vector v, regardless of
        whether any axis is locked.
        
        This will normalize v and re-orthogonalize the remaining axes
        using the Gram-Schmidt procedure. Passing in a degenerate
        (zero-length) vector will be ignored.
        """
        ret = self._wrap_call(self._vtk_obj.SetXAxisVector, *args)
        return ret

    def set_x_translation_axis_on(self):
        """
        set_x_translation_axis_on(self) -> None
        C++: void set_x_translation_axis_on()
        Toggles constraint translation axis on/off.
        """
        ret = self._vtk_obj.SetXTranslationAxisOn()
        return ret
        

    def set_y_axis_vector(self, *args):
        """
        set_y_axis_vector(self, v:(float, float, float)) -> None
        C++: void set_y_axis_vector(const double v[3])
        set_y_axis_vector(self, x:float, y:float, z:float) -> None
        C++: void set_y_axis_vector(double x, double y, double z)"""
        ret = self._wrap_call(self._vtk_obj.SetYAxisVector, *args)
        return ret

    def set_y_translation_axis_on(self):
        """
        set_y_translation_axis_on(self) -> None
        C++: void set_y_translation_axis_on()"""
        ret = self._vtk_obj.SetYTranslationAxisOn()
        return ret
        

    def set_z_axis_vector(self, *args):
        """
        set_z_axis_vector(self, v:(float, float, float)) -> None
        C++: void set_z_axis_vector(const double v[3])
        set_z_axis_vector(self, x:float, y:float, z:float) -> None
        C++: void set_z_axis_vector(double x, double y, double z)"""
        ret = self._wrap_call(self._vtk_obj.SetZAxisVector, *args)
        return ret

    def set_z_translation_axis_on(self):
        """
        set_z_translation_axis_on(self) -> None
        C++: void set_z_translation_axis_on()"""
        ret = self._vtk_obj.SetZTranslationAxisOn()
        return ret
        

    def update_placement(self):
        """
        update_placement(self) -> None
        C++: void update_placement()
        Satisfies the superclass API.  This will change the state of the
        widget to match changes that have been made to the underlying
        poly_data_source
        """
        ret = self._vtk_obj.UpdatePlacement()
        return ret
        

    _updateable_traits_ = \
    (('lock_normal_to_camera', 'GetLockNormalToCamera'),
    ('pick_camera_focal_info', 'GetPickCameraFocalInfo'),
    ('need_to_render', 'GetNeedToRender'), ('picking_managed',
    'GetPickingManaged'), ('dragable', 'GetDragable'), ('pickable',
    'GetPickable'), ('use_bounds', 'GetUseBounds'), ('visibility',
    'GetVisibility'), ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('interaction_state',
    'GetInteractionState'), ('length_factor', 'GetLengthFactor'),
    ('locked_axis', 'GetLockedAxis'), ('origin', 'GetOrigin'),
    ('representation_state', 'GetRepresentationState'), ('handle_size',
    'GetHandleSize'), ('place_factor', 'GetPlaceFactor'),
    ('estimated_render_time', 'GetEstimatedRenderTime'),
    ('render_time_multiplier', 'GetRenderTimeMultiplier'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'dragable', 'global_warning_display',
    'lock_normal_to_camera', 'need_to_render', 'pick_camera_focal_info',
    'pickable', 'picking_managed', 'use_bounds', 'visibility',
    'estimated_render_time', 'handle_size', 'interaction_state',
    'length_factor', 'locked_axis', 'object_name', 'origin',
    'place_factor', 'render_time_multiplier', 'representation_state'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CoordinateFrameRepresentation, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CoordinateFrameRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['lock_normal_to_camera', 'need_to_render',
            'pick_camera_focal_info', 'picking_managed', 'use_bounds',
            'visibility'], [], ['estimated_render_time', 'handle_size',
            'interaction_state', 'length_factor', 'locked_axis', 'object_name',
            'origin', 'place_factor', 'render_time_multiplier',
            'representation_state']),
            title='Edit CoordinateFrameRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CoordinateFrameRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

