# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Uniforms(Object):
    r"""
    Uniforms - helper class to set custom uniform variables in GPU
    shaders.
    
    Superclass: Object
    
    This class implements a generic mechanism to declare and set the
    value of custom uniform variables to be used in GPU shader programs
    used by mappers. It allows users who specify custom shader code for
    mappers to change the value of the variable they define without
    triggering a costly rebuild of the shader. This class is used mostly
    as an interface and the implementation is found in graphics api
    specific derived classes (e.g.: OpenGLUniforms).
    
    @sa
    OpenGLUniforms ShaderProperty
    
    @par Thanks: Developed by Simon Drouin (sdrouin2@bwh.harvard.edu) at
    Brigham and Women's Hospital.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkUniforms, obj, update, **traits)
    
    def _get_uniform(self):
        return self._vtk_obj.GetUniform()
    def _set_uniform(self, arg):
        old_val = self._get_uniform()
        self._wrap_call(self._vtk_obj.SetUniform,
                        arg)
        self.trait_property_changed('uniform', old_val, arg)
    uniform = traits.Property(_get_uniform, _set_uniform, desc=\
        r"""
        
        """
    )

    def get_uniform1fv(self, *args):
        """
        get_uniform1fv(self, name:str, f:[float, ...]) -> bool
        C++: virtual bool get_uniform1fv(const char *name,
            std::vector<float> &f)"""
        ret = self._wrap_call(self._vtk_obj.GetUniform1fv, *args)
        return ret

    def set_uniform1fv(self, *args):
        """
        set_uniform1fv(self, name:str, count:int, f:(float, ...)) -> None
        C++: virtual void set_uniform1fv(const char *name, const int count,
             const float *f)"""
        ret = self._wrap_call(self._vtk_obj.SetUniform1fv, *args)
        return ret

    def get_uniform1iv(self, *args):
        """
        get_uniform1iv(self, name:str, f:[int, ...]) -> bool
        C++: virtual bool get_uniform1iv(const char *name,
            std::vector<int> &f)
        Get the name uniform vector to f with.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform1iv, *args)
        return ret

    def set_uniform1iv(self, *args):
        """
        set_uniform1iv(self, name:str, count:int, f:(int, ...)) -> None
        C++: virtual void set_uniform1iv(const char *name, const int count,
             const int *f)
        Set the name uniform array to f with count elements
        """
        ret = self._wrap_call(self._vtk_obj.SetUniform1iv, *args)
        return ret

    def get_uniform2f(self, *args):
        """
        get_uniform2f(self, name:str, v:[float, float]) -> bool
        C++: virtual bool get_uniform2f(const char *name, float v[2])"""
        ret = self._wrap_call(self._vtk_obj.GetUniform2f, *args)
        return ret

    def set_uniform2f(self, *args):
        """
        set_uniform2f(self, name:str, v:(float, float)) -> None
        C++: virtual void set_uniform2f(const char *name, const float v[2])"""
        ret = self._wrap_call(self._vtk_obj.SetUniform2f, *args)
        return ret

    def get_uniform2i(self, *args):
        """
        get_uniform2i(self, name:str, v:[int, int]) -> bool
        C++: virtual bool get_uniform2i(const char *name, int v[2])"""
        ret = self._wrap_call(self._vtk_obj.GetUniform2i, *args)
        return ret

    def set_uniform2i(self, *args):
        """
        set_uniform2i(self, name:str, v:(int, int)) -> None
        C++: virtual void set_uniform2i(const char *name, const int v[2])"""
        ret = self._wrap_call(self._vtk_obj.SetUniform2i, *args)
        return ret

    def get_uniform3f(self, *args):
        """
        get_uniform3f(self, name:str, v:[float, float, float]) -> bool
        C++: virtual bool get_uniform3f(const char *name, double v[3])
        Get the name uniform to v. The following are convenience
        functions and do not reflect the way the data is stored and sent
        to open_gl. Data is converted from one of the basic supported
        types
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform3f, *args)
        return ret

    def set_uniform3f(self, *args):
        """
        set_uniform3f(self, name:str, v:(float, float, float)) -> None
        C++: virtual void set_uniform3f(const char *name,
            const double v[3])
        Set the name uniform to v. The following are convenience
        functions and do not reflect the way the data is stored and sent
        to open_gl. Data is converted to match one of the basic supported
        types
        """
        ret = self._wrap_call(self._vtk_obj.SetUniform3f, *args)
        return ret

    def get_uniform3uc(self, *args):
        """
        get_uniform3uc(self, name:str, v:[int, int, int]) -> bool
        C++: virtual bool get_uniform3uc(const char *name,
            unsigned char v[3])"""
        ret = self._wrap_call(self._vtk_obj.GetUniform3uc, *args)
        return ret

    def set_uniform3uc(self, *args):
        """
        set_uniform3uc(self, name:str, v:(int, int, int)) -> None
        C++: virtual void set_uniform3uc(const char *name,
            const unsigned char v[3])"""
        ret = self._wrap_call(self._vtk_obj.SetUniform3uc, *args)
        return ret

    def get_uniform4f(self, *args):
        """
        get_uniform4f(self, name:str, v:[float, float, float, float])
            -> bool
        C++: virtual bool get_uniform4f(const char *name, float v[4])"""
        ret = self._wrap_call(self._vtk_obj.GetUniform4f, *args)
        return ret

    def set_uniform4f(self, *args):
        """
        set_uniform4f(self, name:str, v:(float, float, float, float))
            -> None
        C++: virtual void set_uniform4f(const char *name, const float v[4])"""
        ret = self._wrap_call(self._vtk_obj.SetUniform4f, *args)
        return ret

    def get_uniform4uc(self, *args):
        """
        get_uniform4uc(self, name:str, v:[int, int, int, int]) -> bool
        C++: virtual bool get_uniform4uc(const char *name,
            unsigned char v[4])"""
        ret = self._wrap_call(self._vtk_obj.GetUniform4uc, *args)
        return ret

    def set_uniform4uc(self, *args):
        """
        set_uniform4uc(self, name:str, v:(int, int, int, int)) -> None
        C++: virtual void set_uniform4uc(const char *name,
            const unsigned char v[4])"""
        ret = self._wrap_call(self._vtk_obj.SetUniform4uc, *args)
        return ret

    def get_uniform_matrix(self, *args):
        """
        get_uniform_matrix(self, name:str, v:Matrix3x3) -> bool
        C++: virtual bool get_uniform_matrix(const char *name,
            Matrix3x3 *v)
        get_uniform_matrix(self, name:str, v:Matrix4x4) -> bool
        C++: virtual bool get_uniform_matrix(const char *name,
            Matrix4x4 *v)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetUniformMatrix, *my_args)
        return ret

    def set_uniform_matrix(self, *args):
        """
        set_uniform_matrix(self, name:str, v:Matrix3x3) -> None
        C++: virtual void set_uniform_matrix(const char *name,
            Matrix3x3 *v)
        set_uniform_matrix(self, name:str, v:Matrix4x4) -> None
        C++: virtual void set_uniform_matrix(const char *name,
            Matrix4x4 *v)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetUniformMatrix, *my_args)
        return ret

    def get_uniform_matrix3x3(self, *args):
        """
        get_uniform_matrix3x3(self, name:str, v:[float, ...]) -> bool
        C++: virtual bool get_uniform_matrix3x3(const char *name, float *v)"""
        ret = self._wrap_call(self._vtk_obj.GetUniformMatrix3x3, *args)
        return ret

    def set_uniform_matrix3x3(self, *args):
        """
        set_uniform_matrix3x3(self, name:str, v:[float, ...]) -> None
        C++: virtual void set_uniform_matrix3x3(const char *name, float *v)"""
        ret = self._wrap_call(self._vtk_obj.SetUniformMatrix3x3, *args)
        return ret

    def get_uniform_matrix4x4(self, *args):
        """
        get_uniform_matrix4x4(self, name:str, v:[float, ...]) -> bool
        C++: virtual bool get_uniform_matrix4x4(const char *name, float *v)"""
        ret = self._wrap_call(self._vtk_obj.GetUniformMatrix4x4, *args)
        return ret

    def set_uniform_matrix4x4(self, *args):
        """
        set_uniform_matrix4x4(self, name:str, v:[float, ...]) -> None
        C++: virtual void set_uniform_matrix4x4(const char *name, float *v)"""
        ret = self._wrap_call(self._vtk_obj.SetUniformMatrix4x4, *args)
        return ret

    def get_uniform_matrix4x4v(self, *args):
        """
        get_uniform_matrix4x4v(self, name:str, f:[float, ...]) -> bool
        C++: virtual bool get_uniform_matrix4x4v(const char *name,
            std::vector<float> &f)"""
        ret = self._wrap_call(self._vtk_obj.GetUniformMatrix4x4v, *args)
        return ret

    def set_uniform_matrix4x4v(self, *args):
        """
        set_uniform_matrix4x4v(self, name:str, count:int, v:[float, ...])
            -> None
        C++: virtual void set_uniform_matrix4x4v(const char *name,
            const int count, float *v)"""
        ret = self._wrap_call(self._vtk_obj.SetUniformMatrix4x4v, *args)
        return ret

    def get_uniformf(self, *args):
        """
        get_uniformf(self, name:str, v:float) -> bool
        C++: virtual bool get_uniformf(const char *name, float &v)"""
        ret = self._wrap_call(self._vtk_obj.GetUniformf, *args)
        return ret

    def set_uniformf(self, *args):
        """
        set_uniformf(self, name:str, v:float) -> None
        C++: virtual void set_uniformf(const char *name, float v)"""
        ret = self._wrap_call(self._vtk_obj.SetUniformf, *args)
        return ret

    def get_uniformi(self, *args):
        """
        get_uniformi(self, name:str, v:int) -> bool
        C++: virtual bool get_uniformi(const char *name, int &v)
        Get the name uniform value. Returns true on success.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniformi, *args)
        return ret

    def set_uniformi(self, *args):
        """
        set_uniformi(self, name:str, v:int) -> None
        C++: virtual void set_uniformi(const char *name, int v)
        Set the name uniform value to v.
        """
        ret = self._wrap_call(self._vtk_obj.SetUniformi, *args)
        return ret

    def get_nth_uniform_name(self, *args):
        """
        get_nth_uniform_name(self, uniformIndex:int) -> str
        C++: virtual const char *get_nth_uniform_name(IdType uniformIndex)
        Get number of all uniforms stored in this class. Valid range is
        between 0 and get_number_of_uniforms() - 1.
        """
        ret = self._wrap_call(self._vtk_obj.GetNthUniformName, *args)
        return ret

    def _get_number_of_uniforms(self):
        return self._vtk_obj.GetNumberOfUniforms()
    number_of_uniforms = traits.Property(_get_number_of_uniforms, desc=\
        r"""
        Get number of all uniforms stored in this class
        """
    )

    def get_uniform2fv(self, *args):
        """
        get_uniform2fv(self, name:str, f:[float, ...]) -> bool
        C++: virtual bool get_uniform2fv(const char *name,
            std::vector<float> &f)"""
        ret = self._wrap_call(self._vtk_obj.GetUniform2fv, *args)
        return ret

    def get_uniform3fv(self, *args):
        """
        get_uniform3fv(self, name:str, f:[float, ...]) -> bool
        C++: virtual bool get_uniform3fv(const char *name,
            std::vector<float> &f)"""
        ret = self._wrap_call(self._vtk_obj.GetUniform3fv, *args)
        return ret

    def get_uniform4fv(self, *args):
        """
        get_uniform4fv(self, name:str, f:[float, ...]) -> bool
        C++: virtual bool get_uniform4fv(const char *name,
            std::vector<float> &f)"""
        ret = self._wrap_call(self._vtk_obj.GetUniform4fv, *args)
        return ret

    def _get_uniform_list_m_time(self):
        return self._vtk_obj.GetUniformListMTime()
    uniform_list_m_time = traits.Property(_get_uniform_list_m_time, desc=\
        r"""
        
        """
    )

    def get_uniform_number_of_components(self, *args):
        """
        get_uniform_number_of_components(self, name:str) -> int
        C++: virtual int get_uniform_number_of_components(const char *name)
        Get the number of components stored in each tuple of uniform
        name. for example, a uniform with tuples of matrix type and 9
        components contains 3x3 matrices
        """
        ret = self._wrap_call(self._vtk_obj.GetUniformNumberOfComponents, *args)
        return ret

    def get_uniform_number_of_tuples(self, *args):
        """
        get_uniform_number_of_tuples(self, name:str) -> int
        C++: virtual int get_uniform_number_of_tuples(const char *name)
        Number of tuples of uniform name that contains a variable-size
        vector. For example, for 3 components uniforms of type vector,
        this is the number of triplets.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniformNumberOfTuples, *args)
        return ret

    def get_uniform_scalar_type(self, *args):
        """
        get_uniform_scalar_type(self, name:str) -> int
        C++: virtual int get_uniform_scalar_type(const char *name)
        Get type of scalars stored in uniform name
        """
        ret = self._wrap_call(self._vtk_obj.GetUniformScalarType, *args)
        return ret

    def get_uniform_tuple_type(self, *args):
        """
        get_uniform_tuple_type(self, name:str) -> TupleType
        C++: virtual TupleType get_uniform_tuple_type(const char *name)
        Get the tuple type stored in uniform name. This can be a scalar,
        a vector of a matrix.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniformTupleType, *args)
        return ret

    def remove_all_uniforms(self):
        """
        remove_all_uniforms(self) -> None
        C++: virtual void remove_all_uniforms()
        Remove all uniform variables
        """
        ret = self._vtk_obj.RemoveAllUniforms()
        return ret
        

    def remove_uniform(self, *args):
        """
        remove_uniform(self, name:str) -> None
        C++: virtual void remove_uniform(const char *name)
        Remove uniform variable named name
        """
        ret = self._wrap_call(self._vtk_obj.RemoveUniform, *args)
        return ret

    def scalar_type_to_string(self, *args):
        """
        scalar_type_to_string(scalarType:int) -> str
        C++: static std::string scalar_type_to_string(int scalarType)
        Convert between scalar types an string
        """
        ret = self._wrap_call(self._vtk_obj.ScalarTypeToString, *args)
        return ret

    def string_to_scalar_type(self, *args):
        """
        string_to_scalar_type(s:str) -> int
        C++: static int string_to_scalar_type(const std::string &s)"""
        ret = self._wrap_call(self._vtk_obj.StringToScalarType, *args)
        return ret

    def string_to_tuple_type(self, *args):
        """
        string_to_tuple_type(s:str) -> TupleType
        C++: static TupleType string_to_tuple_type(const std::string &s)"""
        ret = self._wrap_call(self._vtk_obj.StringToTupleType, *args)
        return ret

    def tuple_type_to_string(self, *args):
        """
        tuple_type_to_string(tt:TupleType) -> str
        C++: static std::string tuple_type_to_string(TupleType tt)
        Convert between tuple_type and string
        """
        ret = self._wrap_call(self._vtk_obj.TupleTypeToString, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Uniforms, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Uniforms properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit Uniforms properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Uniforms properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

