# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class OpenGLVertexBufferObjectCache(Object):
    r"""
    OpenGLVertexBufferObjectCache - manage vertex buffer objects
    shared within a context
    
    Superclass: Object
    
    This class allows mappers to share VBOs. Specifically it is used by
    the V..B..O..Group to see if a VBO already exists for a given
    DataArray.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLVertexBufferObjectCache, obj, update, **traits)
    
    def get_vbo(self, *args):
        """
        get_vbo(self, array:DataArray, destType:int)
            -> OpenGLVertexBufferObject
        C++: OpenGLVertexBufferObject *get_vbo(DataArray *array,
            int destType)
        Returns the vertex buffer object which holds the data array's
        data. If such a VBO does not exist a new empty VBO will be
        created you need to append to. The return value has been
        registered, you are responsible for deleting it. The data array
        pointers are also registered.
        """
        my_args = deref_array(args, [('vtkDataArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.GetVBO, *my_args)
        return wrap_vtk(ret)

    def remove_vbo(self, *args):
        """
        remove_vbo(self, vbo:OpenGLVertexBufferObject) -> None
        C++: void remove_vbo(OpenGLVertexBufferObject *vbo)
        Removes all references to a given vertex buffer object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveVBO, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLVertexBufferObjectCache, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLVertexBufferObjectCache properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit OpenGLVertexBufferObjectCache properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLVertexBufferObjectCache properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

