/************************************************************************/
/*                                                                      */
/*                  Copyright 2008 by Ullrich Koethe                    */
/*                                                                      */
/*    This file is part of the VIGRA computer vision library.           */
/*    The VIGRA Website is                                              */
/*        http://hci.iwr.uni-heidelberg.de/vigra/                       */
/*    Please direct questions, bug reports, and contributions to        */
/*        ullrich.koethe@iwr.uni-heidelberg.de    or                    */
/*        vigra@informatik.uni-hamburg.de                               */
/*                                                                      */
/*    Permission is hereby granted, free of charge, to any person       */
/*    obtaining a copy of this software and associated documentation    */
/*    files (the "Software"), to deal in the Software without           */
/*    restriction, including without limitation the rights to use,      */
/*    copy, modify, merge, publish, distribute, sublicense, and/or      */
/*    sell copies of the Software, and to permit persons to whom the    */
/*    Software is furnished to do so, subject to the following          */
/*    conditions:                                                       */
/*                                                                      */
/*    The above copyright notice and this permission notice shall be    */
/*    included in all copies or substantial portions of the             */
/*    Software.                                                         */
/*                                                                      */
/*    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND    */
/*    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES   */
/*    OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND          */
/*    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT       */
/*    HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,      */
/*    WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING      */
/*    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR     */
/*    OTHER DEALINGS IN THE SOFTWARE.                                   */
/*                                                                      */
/************************************************************************/

#ifndef VIGRA_LARS_DATA_HXX
#define VIGRA_LARS_DATA_HXX

#include "vigra/array_vector.hxx"
#include "vigra/matrix.hxx"

namespace larsdata {


// Data from file x1.txt and y1.txt
double x0[5000] = {
-4824.85609148439, 5492.68670002464, 10677.6814107257, -6577.76436526851, 3006.52263630013, 1232.75930288669, -13874.8715790338, -12013.7032176346, 7763.15613936006, 3154.84616282376, -9720.70147471624, 1050.31817626143, 1105.76477821089, 14008.3129836710, 59.6625008434368, -9001.37338256055, -3315.94876129626, 2959.22173007536, 2067.03735437843, -7026.54280114668, 2016.87450797157, -1500.93226203831, -13486.8751042545, 4018.70107849734, 729.667410769464, -3461.59203658467, -15940.4352192333, 9316.70530679643, -7882.72242413646, -1719.82757242342, 4815.54511236175, -2336.44867143662, 2393.21447548416, -2291.49389805986, -12535.1487594275, 16851.4581400554, -10122.066175755, 8608.49993856802, 15389.6733955255, 1148.41892989359, -12541.0461773519, 8821.0521224434, -10055.6851799449, -1877.15873262335, -24.8020574952552, -474.704128248417, 589.043046664104, 4370.15465786575, 1414.023008813, 18685.1969211606,
10503.8128130289, -1975.96432576903, -10882.6707132376, -15496.8179537946, -2683.96070749656, 20364.3600367006, 12060.9162634738, -3863.9069736504, -2204.42301752556, 3498.54907646087, -10328.4817762828, -5183.6907866054, 23715.4647323558, 3910.7424355139, -974.076602220367, 5545.33415522038, -546.959719392361, -10517.1756427108, 4038.22915100764, 1519.35693087274, 278.379572073084, 8950.68784307226, 3071.62136041175, 1773.43305514849, -8810.50056996015, 6208.37949084252, 7104.41463126623, -7437.17044774198, 17534.7335852806, -8337.4276357325, -6506.50224305541, 14313.4610226849, -266.237465584579, -1356.09466136511, 11222.7323160741, -5580.94135077411, 11829.7754709251, -1280.58274592151, 1431.70186736710, 5939.95400865264, -18762.7505687286, 5167.38532725056, -9590.1139082247, -6713.47207845775, 2861.52451614523, 12043.599821336, 14462.6204730617, 3568.04093927063, -1693.23876927496, 1804.96063840160,
-25410.1944551726, -8607.6172702845, 10784.4299911228, -19796.7021284725, 19080.2870309262, 6086.60008471648, 17369.2242211683, 7958.25148938802, -11165.5235658922, -6882.9837503392, 39.3952313900356, 10436.4613948821, -17997.3873162621, -4858.3648132209, 6867.65626485278, -3503.36484183816, 6879.05370745725, 2748.5660816116, 6486.67616855507, 3293.18033529253, -1213.36604532598, 1781.93751889423, 6973.55968552688, -8708.25640431769, 13697.6906048666, 9647.7526027641, -10134.6719555600, -5509.33416404932, 15243.6884668758, 10212.7411510941, 6712.39320080382, -12522.0516285228, -24783.929184132, -3563.96307311020, -15014.8435733765, 7292.74316177345, 16340.1881661309, -12732.4006063756, -4628.10208870712, 1738.85832920012, 3146.04892218716, 9206.0794407349, -8476.70520593014, -9732.43825680021, 16624.4699177751, 2550.89823885589, 24860.0566267381, 851.362661735271, 2855.63350526166, -10450.7483442721,
8391.62537594225, -3538.07411618347, 14562.5447430808, 2188.67183459842, 12031.3584588355, 1782.78901970306, 10040.5315089185, 5502.23456412132, -5488.64570159822, 1337.27074170818, 12160.3412642307, 16335.3729432636, -1629.51338234909, -914.281285957799, 18627.1309174643, 3048.87618671333, 10606.3934419140, -8036.60956403262, -5097.81053406837, -8830.48979960146, 13072.5027144019, -9405.8632558346, -8365.79977952925, 11284.1469515193, 15224.9459773680, 10911.7908759297, -5457.15395207287, 791.886346781468, -8150.90541378072, -12144.8144320453, -23402.9361424713, 3033.46236958155, -7689.6563563094, 13997.7257202765, -24964.3626568731, 29444.0634826293, 8207.87751601622, 13566.7309893665, 10146.1902753354, -10132.0519967438, 3456.05526537233, 4702.51338889230, 10742.6750381316, 558.398791248126, -13908.8574728258, 18531.1293712591, 4823.51985463126, 7341.84635543076, -2878.29987957494, -4033.00309885980,
3971.91281065321, 5137.77630454473, 4386.10219794586, 17220.1012112582, -8071.44723595137, 21775.6566595257, 13350.4159019676, 6109.79440823346, 8351.28001540748, 22748.2360364964, 1247.07685572059, 12108.8442905456, 12497.4570896021, 14493.6005299090, -10282.1589071261, 13334.7568876448, 3641.36472419559, -8569.1122413144, -4328.73196021228, 3817.88898783385, 4749.21612683583, -7517.36372326186, 7357.39251238079, 5333.62221318679, -6716.91319369655, 18782.5656746495, -4843.12889948442, -9087.3688356442, 2534.93503860997, 5602.68308845466, 2606.04355370279, -3247.50049310275, -2994.1652237633, 2552.44421384032, 1253.72480455013, -5074.1127751969, 2997.60073575661, -3320.40742695679, -7767.43502164198, 17110.2734215388, -2896.82643076336, -7010.89089325246, -11163.6076744196, -3566.39400449607, 1148.05301444567, 1164.19711714349, -5753.16267622588, 9223.03761924169, -9992.71930765127, -2950.56482269359,
-10222.8028382756, -23174.3418660024, 22786.6607074203, -4897.3994688443, -11525.3277957892, 2739.50354065979, -4393.51378220903, 7299.44910522972, -468.192055381877, -14786.4736575303, 6815.16177574024, -278.166287127477, 2225.61162185042, 9545.59509280576, -14106.9164029350, 14481.5791318834, -7864.88421030937, 7269.82399986671, 4825.81855277675, -10323.7242377048, 6552.02129626765, 3132.89176919866, 23595.121598137, 10141.7748340406, 6411.70795857581, 19711.9877701657, 13766.9553654605, 9004.24237442288, -8503.08178535529, -7008.2199609922, -5545.02286904986, 7360.19712494293, -2741.02452009473, 20199.0293152298, -7433.20010674328, 19803.5221379508, 4732.83661837145, 4771.55429472719, 12408.6594941980, 16351.3936246236, -2616.13222739099, 2850.41893890457, 4306.31292041539, 1287.01165310703, -10832.1965265015, -4761.77342446853, -2713.44919110731, -19714.2605910569, -17859.2970857464, -3496.60041764462,
-8791.58641745136, -3634.73952064475, -2898.70862013585, -957.044674560697, 2606.50223201647, -618.890697352841, -9819.40051079775, 7728.49421101888, -4676.04574156576, 8513.80111019302, 349.605545822288, 20983.5866041862, 9821.41890345264, 13977.8697774532, 2235.87581018277, 10719.5652664215, 6795.34348686544, -18920.8440434330, -3499.76327541941, 3148.39386326094, 19046.1280436337, 9657.11847365912, 15726.0686245592, 12257.5050185458, -1751.64471951930, -1905.96529847711, -5992.58593147915, 3315.78307590346, -8653.40970900465, 16939.5726290199, 2335.51086012488, 231.638210398647, -9247.69091123868, 14279.6665615668, 6020.0625345505, 4880.83194310393, -3526.68285967244, -9503.7263505984, -4688.94314181112, 413.908424607574, -2520.43804000103, -1078.58890300354, -4245.94378947487, -2898.95318102089, -21462.9202031512, 8287.9711802554, -2179.58699333328, -3749.00595217243, 3443.09251971818, -11382.7416695556,
4806.05369198179, -1167.97627761998, -22738.2054421141, 5243.44835818554, 10777.0361568215, 7117.53547006903, -7863.19584597646, -2939.82023501363, -2246.00511366296, 4609.76494369509, -4317.09714191309, 336.843479693964, 13305.4652208912, -13344.9013560647, 7431.54612273091, 9723.49254416922, -22220.7239017123, -1500.96506156070, -9382.3891867843, 10370.4227380919, 1253.97226347699, -492.821377612752, 13608.8966512116, 6141.50364301481, -7572.33682941791, -7451.53264297602, -11397.7217413967, 4743.45737956262, 1006.46945117394, 6844.66586037917, -5629.1532200947, 6868.33938719235, 9474.05766877667, 1904.9536908354, -11935.0564545474, 16490.9359631553, 2607.99071644638, 5418.08767230136, -4066.64020484684, 4118.47056854368, -14919.1734188491, -12737.6607599303, 2432.30159615878, -18462.9485009485, 10240.2391157580, 3453.34367008372, -17553.9170182487, 25235.3517326962, -8687.10534670911, 737.696683299746,
13553.8881543861, 1893.15865617829, -3555.07233584128, 21226.0441505095, -9091.95814349642, -14675.163092321, -24883.7639726919, 2957.17452521401, 12976.1160923964, -26285.4408028390, -11734.0763814492, -365.128773943433, 109.657220564343, 3894.74351335176, -33939.853798569, 7469.89038872013, -2650.55003336111, 294.493169263204, 3027.94168201182, -6829.84319289845, -3892.22042906797, -1155.61729194143, 3957.06964705125, 10640.0529362767, 9239.99825721938, -12314.8950643457, 3001.08477982063, 5262.76973040148, -3732.18611039425, -18730.4085216114, 3067.00909254435, 6808.2589949481, -369.788772505741, 8711.2089360534, 6339.63829717885, -220.838520286702, -11342.3511030982, 3252.23307721596, 675.852261157456, 1085.59655833561, 6009.88212802125, 6871.5265668551, -1514.83831195942, -3383.97448111228, -17843.3034261559, 9098.55577588106, 3638.18226036326, -9836.51432151465, 2033.91386264337, -14074.8452538013,
1804.64493321438, 5680.60809245673, -19799.7288133307, 8481.7426629902, -1382.55677936705, -20533.2594830072, 15255.0908255019, -7086.29737607512, 15724.1692987392, 6993.6203967993, 2146.31766905143, -2088.11143346794, 8451.63630372608, 5431.9289200047, 4008.06761229044, 10419.8069301054, -4792.6298887994, -742.282713932987, -3897.83870644958, 12876.3299843787, -2187.45072346789, 18791.9077599508, 25022.7830150519, -1867.43193463396, 98.89130623306, 1562.16177531646, 4945.02196234184, 9242.90081969447, 2265.87363280170, 9319.97742137502, 1946.60976297935, -10824.0803300532, -10563.1673733574, 13617.8427238211, -6072.15063858642, 13112.7226310682, -4294.35718191421, -206.074884286223, 4672.86532845049, 14656.7361171152, -10648.1719457404, 17435.1750522929, -14705.0029994880, 13979.9918604823, -398.047554605824, 8917.21592966391, 15816.0176264724, -1933.97434971655, 3090.24733172923, 6937.69651637037,
-1164.39740106653, 22338.1016649186, -8661.97933908767, 3485.01202955175, 25262.5630986758, 7085.92094219246, 30018.3262344347, -2053.59176824007, 13839.1494102145, 8359.57207266262, -3129.85774930115, -2387.44953057414, -1102.87463335674, -970.688682306271, 13269.4612794143, -17495.3314960931, -883.174965298747, 1860.09788589645, 14025.1603445487, -1310.86071097947, 10403.2329471069, 3600.75397352298, -1326.62987073955, -4792.11473370489, -9954.80982073105, -13373.0761254585, -11545.7021394922, 13039.437824754, 5137.19957060504, -6008.76709792821, 679.964612710363, -781.071131221474, -12766.6472024968, -6160.92665095633, -271.93421856644, 10376.9314081489, -568.974427367238, -10496.9450891582, 1111.51345620429, 13357.7658730202, 15390.9944682152, -2224.22862871425, -18510.5581960914, 7233.55719712309, 15396.7620958445, 1211.54586776211, -3707.22982826614, 17173.5983153084, 788.161977389038, -6579.0877341657,
5184.00912872932, 2048.04366009304, 9812.88983856197, 11030.0178225529, -3350.68411124609, -1651.81016109354, 3404.8504392251, -3903.61661595423, 3005.62741245755, 7633.82990785147, 9632.09101506813, -7232.45927457797, -2167.64912996164, -16574.3480631209, 17845.6975792498, 11872.6264973417, -512.366409982419, 3160.08849702186, 4760.63225946374, 1752.02135983167, -9564.75830205253, -10867.8968032245, -10899.1274152788, 13793.5048515752, -16823.2178358861, 5747.83460896412, -11512.5934448098, -219.256678842625, 4796.21661329231, -20950.0825902218, 7097.68600385468, 13044.4293040603, 6753.55649713147, 2449.55482880626, -10566.2583289245, 6341.29880881667, 19368.1722406760, -8022.5037966769, 2210.45282935872, 6628.22663636785, 8070.8762703924, 5496.03829234548, 10713.6724020796, 8620.98798052638, -7123.80161999447, -2198.75125073512, 14297.4622919402, -5977.42287179585, 15246.8738057337, -7919.26419708405,
-4761.45761383895, 4635.95323449235, 2284.93972802302, -4088.22792233849, -22019.0634758780, 11487.5276135778, -2446.12179435328, 331.349711286565, -3968.46326146169, 5812.66913119542, 14614.8986398500, -6849.52368130914, 15296.4554882958, 3030.68303980318, -2270.45619173159, 4226.52033785159, -8814.07789526021, 1047.99179802261, -8115.94296176556, 800.162396432455, -878.745652640845, 13069.6705507101, -12379.1338986065, 13122.7024438335, 4286.80745240244, -4569.82743598502, -2660.73884783577, 8294.91871383203, 138.464328305436, 2118.72726588398, 3476.81365938617, 2059.46071146201, -12074.178695548, -9430.73539210339, 11438.0668560733, 809.222400190415, -10148.9811723625, -2505.99702864779, -10593.0716887903, -4089.87369705081, -14520.8297834070, -587.131452455139, -5831.17869795785, 842.85011320765, 6654.07725656725, -11088.8961633581, -23762.0506542430, 5351.26075876251, -3234.97298607993, -5954.61362194009,
-8163.28238227322, -2846.33729430954, -1847.95763525237, 13784.2345987643, 459.866693383869, 9167.2036087145, -6385.36932251463, -1543.25933709673, 7801.83145840204, -1692.04476788548, 11516.6015376493, 623.720792810618, 15543.7364517478, -9690.29474046038, -723.015536477439, -5973.43791929899, -8648.1387914708, 10405.3351335259, 9539.44036783994, -3777.93179491656, 8131.20040750354, -7901.91675598824, -1085.38560813678, -3828.55356736649, 106.729573631947, 4545.21659703984, 5334.73502288066, 19915.0973524638, 14411.8295578677, -36858.2644970598, -7786.95803123541, 11427.871501915, -16167.4131066716, 2809.27864266773, 1007.51060014326, -1148.52687455216, 3358.58487710926, 7260.15344731228, 19186.4183437408, 7507.91159926691, 4815.7543020328, 7599.83385467388, 7374.77864440937, -1026.92429172817, 8903.68578550456, 8410.80091587987, -2874.38654290380, 9543.96209020786, 5348.69396609874, -7190.34836558238,
951.098634847252, 1327.31699301869, 8021.53000068268, 3566.01311480221, 6466.42473123153, -6379.06807700168, 12849.7282070894, 8613.7882993374, -7080.48725085868, 14379.2233878282, -3007.93438033794, -1015.04369508374, -3189.57226077769, -9279.59403099261, 3806.9401471939, 1652.29245263551, 12029.7103330733, -9132.77187166128, -1486.91517287111, -13806.2783507678, -1202.70761129167, -12313.2731930383, 1602.218426137, 8308.3730021539, 353.641127382601, -3256.14238188096, 5484.61711872388, 10891.4627946987, 9768.88200368385, -3186.22441467172, 10008.7349382369, 18616.3928419827, -1172.67238174948, 8443.97101088133, -5967.30949607642, 2148.28715395326, -7122.37352312286, 4476.0025483948, 4474.92217044931, -22922.6398310877, 579.249363377729, -12050.7931881257, -8018.37243055992, -4450.37131442062, 6990.76798027641, 17837.5260145959, -21028.9969958901, -8925.7099800875, 12086.2807111405, -22047.6086391137,
-1527.62441538694, 20661.2665636579, 1540.93186814551, 5634.73964135377, -9106.67705173826, -53.781697646746, 31.0864089765304, -8364.58500017263, -14291.629558555, 2942.67402025496, -61.4905859499793, 3392.55205069357, 1806.90872767595, 4756.5147385043, -22184.0735349075, 15823.4395249394, 7858.59765951906, 11857.3864604558, -1181.00409992289, 3858.92651898401, 2875.19903782331, -20781.6126520632, -2003.88220633766, -3026.63553635995, 18056.5746453325, -4163.15323453536, -13582.0036705048, -8528.09331572026, 19466.8642247026, -4587.58763523597, 14417.0314516123, 2990.52635470593, 11576.3711721074, -13060.0354931096, -2999.77212226323, -773.188138683528, 1312.62946130381, 19807.4966021473, 4033.03521604524, -9559.10056316996, -14993.5429217218, 5648.50251312226, 10627.2480509119, 9255.29814350355, -23384.9410448495, 10927.6007962132, 1568.82827194237, 380.914776421338, 939.467440329093, -14065.5147156258,
11456.5298881470, -9739.61108385849, 10717.9925874970, -6960.33330866798, -4387.92436134847, 2504.69332004430, 8206.88405586308, 4629.97538725424, 4468.8656626506, 9019.50844398417, 6810.45923366842, 11874.8312312245, 7127.56426235128, -19509.0003750572, 257.057679634302, -6809.02520232946, 883.873605507108, 8681.3651358931, -16042.8219510072, 4088.01991796025, 2209.69327447178, -145.273422952063, -16220.7907002456, 6449.68073363522, 2255.42918971335, 17334.4720859625, 6072.99379730343, 9648.21799221514, -4695.29224031778, 18402.6935584094, 7310.33152562549, 3024.44343802407, -6114.03362436907, 1216.12382264605, 3138.70454145289, -4913.09561689357, -4975.57695389734, 23679.7903465628, 2697.37634016732, 4305.65962641347, 9828.95084659113, -3419.87073897773, 677.412859217949, -11953.3689344122, 10756.6893006176, -3541.05589970958, 3033.08155065679, -11749.5652688334, 7243.86127513166, 14561.6809349929,
11562.8529806538, 7207.047098654, 8398.86334252775, 8028.84586817969, -4487.47062992083, 12757.2628492482, -2545.93247147323, -9232.36709625594, 14385.3332060094, -13665.2527063403, 10186.8685153309, -22877.4563717562, 21376.1092029609, 9977.30528690112, 9003.33658348488, 9180.38957893759, 13472.8603548464, 1326.47928010877, -15380.4724030317, -4996.21832682545, 6648.75812189012, -15598.3683284986, 125.473352624358, 8717.5279833547, -828.2841704852, -446.499204881674, 7966.66145744788, 7632.86180203814, -1909.18987612962, -2651.27819011448, 8626.83706781583, 5398.27702979495, 6357.49126821457, 9477.75483390962, -3028.72507314664, 6829.67115845936, -45.3216890529431, -3269.49998838929, -18299.2948674168, 7684.00343029067, 3426.4007830625, 11653.3590170081, -11073.7500946389, 6105.80143940152, -1487.37828082389, -7442.09940346299, -7615.08871048519, 14904.0267890504, 22440.7966111001, -3941.12283333893,
-6010.26767533545, -9292.30032517972, 2552.68319707619, 15649.8604855021, -440.20278143756, 614.340640072097, -7356.79004217763, -10618.7472663112, 2207.91677310437, 17373.5641802437, -8358.89825035036, 1403.39968460752, 13747.4319245988, 10602.0417113762, -11100.5936367786, 12695.3918684317, 10536.1946768026, 7744.00807127985, -25850.3244449546, 9395.70596072066, 1906.66379151568, 21266.8307509735, -18183.9781631291, 12106.0156824092, 2573.00611805989, 28727.7325489775, -1015.98723876399, 6941.96073135946, 3731.33718805668, 5455.38080621262, -3374.14985113405, 4078.66377599941, -2061.55232830785, 5885.37996929058, 4507.36897772688, 7390.9214239088, 10853.5404989243, -4708.19317988094, 10073.9069616110, -1128.22943009442, 10907.5331233423, 7106.70481743719, 19986.8528423631, 6905.3220778102, -14277.9791774136, 20860.3155852416, 19346.6538170394, 5713.46925998346, -5895.55560137674, -18592.3338178117,
-9700.45826128302, 4202.44145540171, -7331.70712871278, 13895.7810932697, 5367.40437490942, -10910.8877290345, 7399.41976022675, 19464.7622810525, 3454.46727427057, 7188.924870479, -2997.94416742258, -13682.2004916015, -3823.43009755215, 297.140020794265, 1285.53829269865, -16635.0110760469, -6455.16842505229, -3823.46159780881, 12536.2234059467, -3212.56834604651, 10954.9967404167, -5339.32453358863, -9992.93315846257, 5970.13388972311, 4837.25534056856, -11248.8598421303, 9496.08856326142, -5483.79318848983, 7126.39653688894, -5900.28917387819, -7100.72006957672, 4578.26924973792, -9715.80679710965, -12942.1368057395, -1325.86217509802, 453.336329680583, -7802.65504340438, 15731.1038949631, 2654.44302720170, -17021.7729954022, 2115.06585892695, 22672.2359812677, -4483.03774996023, 7181.05609183254, 15434.6709708402, -9860.07258074817, 12983.7065076748, 6689.81583491822, 5125.17584334474, -7199.62312983417,
-9916.18512837253, 8993.25403581071, 12258.6619747396, -3096.39557523355, -2289.01157826236, -11997.7989745403, 13185.2622253589, 10137.3313940583, 9722.2896373784, 6540.65457973578, -5791.70981271927, -13180.8592396066, 68.1180957735234, 10141.9661144276, -4098.35467684728, -5131.0988189861, 3854.61765191059, -9321.8283908739, -29.0458415392876, -1936.38920655955, -20387.2874856425, -2471.36737709437, 5886.97219271367, 19468.0870907998, -17424.4938922676, -17450.1555813509, -5754.99879898838, 14518.8165948569, -3140.28843276156, 7771.92118282399, 8005.50597141322, 622.613458310011, 1157.07260884994, -2520.47646702305, -5849.78427220339, 8558.51862650659, -1172.85165778417, -5541.68340014698, 6715.03416720177, -7420.4962784437, 3172.87934375595, 8280.48947517388, -17422.1130873187, -669.971396608879, 17443.1537091515, 13766.8881223696, -5693.59898672991, -17083.3178381841, 277.488999352621, -7998.68016632033,
5907.53805979406, 13391.4952932841, 3407.03779409858, 3583.02423982365, -9250.35881480299, -7452.73890935147, 8540.10802599838, 160.850016016636, -148.326279518587, 11792.3121132674, 4969.00907574298, 488.198363836627, -3469.35129203196, 775.901117211781, -858.24783403498, -22255.6526058983, 12583.6896594865, -4063.47523118302, 8208.37980947471, -4110.25042825939, 3441.54844713004, 6320.26648912106, 17590.3714906978, 7416.66904690148, -7030.36779700298, 10034.8249174049, -30529.7938034983, 11687.9666370382, 1417.50679414848, 4591.66990780349, -7512.40456806283, -11582.9560066213, 5567.19127875349, -18077.7114860964, -6667.75034643823, -4574.09580448625, 5596.63734515398, 15031.1427417890, 6756.34972973969, -3295.47810130822, 8420.86853738308, -3656.73169919499, -18024.9134174816, 8066.73705128258, -709.372538413342, -16214.2857052409, 1450.27332457908, 19210.1158408934, -12326.0614678029, 4539.75820136555,
1774.39956169349, 1138.03132019224, -3766.19942960475, -3567.39431742306, -4956.13072195059, 5266.48610430315, -12322.3073483239, 8614.3274593628, 1684.82349088582, 15551.8726760613, -923.583367304518, -11157.5972408683, 10759.5862103033, 6493.04119076034, -8609.0295943423, -452.798490755927, -6297.44033446193, -6395.32747797579, -17334.4566811780, -2116.66267290296, -6175.68857087696, -15651.5292921657, -2493.41331123250, 7755.72710797622, 6992.1532459495, -475.878213117065, -3374.80540920955, -13852.4533042225, 3517.49341835423, 6222.30913943599, 3150.48041130454, -753.755909105827, 9943.13274273606, 822.03754537047, 4963.21222215742, -12679.0887650450, -16284.5421590851, 6000.91813343648, 4059.4035486938, 20651.7715857031, 2264.69612565495, -21081.1472442796, -11996.2892159268, -7331.25115641728, 5543.03799442354, -5039.61107909052, -8404.24644977427, -2485.77707232368, -10438.2881139823, 7178.33206968547,
-9512.76304020336, 9743.6831624421, -1488.57028902389, -14134.9430312023, 6169.96997687961, 2074.05961828822, 5578.61134196343, -469.771131205848, 1469.08189895578, -2591.23019950543, 8145.40484860913, -7524.95452380146, 2505.5638522305, 4565.91172660633, -7982.6432358739, 3381.68677524175, -6547.84160547134, -5453.97361206009, -10515.4825288194, 1268.36507726799, 15830.4953138404, 10918.5270745380, 6515.68638302463, 19964.4072180938, 12441.0360402267, 7664.82419935336, 40.5576683685638, 6673.90700116623, 7119.43039993955, 1419.99501578079, -5717.96206864448, 8927.82027549322, -8241.34424421884, 23590.5428367214, 3026.22823325459, 3783.12319134971, 998.414777538312, 21241.7921067080, 13264.0376924593, -9552.36441143862, 15210.2941582543, 3527.79913399136, -13039.0798864620, -3727.23376619760, -2729.42419751026, -1071.05450574503, -3948.82190889444, 875.791760468634, -1611.62846513095, -7124.1596992709,
-5876.37400427761, -21180.2216512963, -981.07665100796, 9154.41282693216, 4111.58633364548, 6600.21537137221, 4850.65343750806, 7951.80878820103, -2763.25162072124, 8744.81581568888, 23757.0069666339, -6968.49446015862, 10630.7442649398, 18970.3466618638, 12036.0012297407, -10195.0532171385, -1966.29071835242, 11226.8412020283, -13958.5075626461, 11871.8461623488, 2700.26942082396, 424.409226394301, 3793.7317271612, -4240.43165970141, 7875.2202808738, -6067.85361453415, -9018.4032137098, 7758.73136377706, -13438.6711800353, 13171.2884053060, -2874.01931909054, -4266.12876522403, 4403.19493016736, 2894.14844119223, -15611.9218787168, 3564.51853484279, -3319.89371922359, -11386.6508228216, 6234.32003463605, -8744.39301570029, -7624.29064783762, 17684.3947505965, -11798.1783082222, 11772.9877571204, 595.07886786441, 3745.79987664271, 2729.39597449674, 3616.88539818732, 10481.0339096370, -4309.07793222491,
-709.40472383053, 15907.6147564127, -5807.9875710387, -16499.7085707429, -1361.45262204922, 5895.70859165384, 6161.81942083547, 6877.5318800545, 17577.5088687095, 24126.1303093394, -7140.20039576603, 401.387759025087, 14319.4455530612, 4987.40764167988, -6801.79786045557, 319.448889274223, 10760.1770347074, 16394.4622850763, 3130.77219058093, -874.226486015664, -8144.61795207004, 7245.90904187284, 2325.81750641151, -1662.81692403745, -13210.5739652531, 15643.7127972196, 12258.3499112285, 25906.4351450804, 12194.065522211, -1297.49999893733, -290.57215332116, 8091.79488198895, -11340.9948765358, 10781.2961565143, 16401.2149704172, -2389.52302258024, 10814.4140522666, 68.9194756562707, -123.962066951106, 4562.4199544806, -6812.54968301376, 5115.38153224664, -1008.93657930686, 5552.68766135139, 5385.51981265597, 11559.3160428324, 2932.12108881945, 2205.47203127606, 2575.0634678607, 8428.3962318566,
-4120.13460134216, -510.627573020775, 10736.7277135466, 13444.5601889644, 5414.08794068912, -5882.99025483752, -71.223801125205, -6847.54697707565, 22242.2070162443, -21017.3517713852, 2126.91482723250, -14993.9101033140, 10637.3170942479, 4541.92608987509, 2864.88813311507, -15263.2258755284, -5942.88705941216, 20335.9403688677, -8103.17076101, 18430.9003634245, -4378.11982640782, -8974.42643215296, 9475.59133521844, -1576.78379757865, 9067.1022956277, 21391.4171816223, 18552.4312440091, 1836.80710200047, 6620.77963258244, -5892.56369823635, -5319.62420790955, -646.551768129733, 3152.82670295368, 5963.85079795, -7495.11577815066, 4858.26502689363, 6992.78704778039, 6550.52733181005, 14519.6235071011, -429.218809839137, -4565.58291430457, 10399.6143473369, 1857.23174358462, -8866.59426326194, 4768.98670992544, 1249.91320654813, -2638.62979898210, -4185.00596210714, 15323.3460466371, -6251.04943915288,
-4768.70037694761, -17647.9111013430, -817.794066654996, 8099.13945165725, 13835.9777497985, 13332.1924091396, 11865.7928968444, 958.203795014972, 8049.6666809136, -9554.55203089675, 2230.09903914232, 3540.01007643135, 11459.3879560829, 3986.95493192382, -9164.83318274846, 1748.25951057377, 16110.3014074343, 11288.4764222186, -6361.9829105993, -6397.52664398506, 3345.14201406428, 2068.8163548545, -4577.717654487, -878.229993636366, 1242.21560039523, 20637.6451348872, -4612.7072121637, 1929.00061533627, -624.246220407934, 2545.81879612334, 4179.86559952035, 1858.28650885403, -10094.5218634316, 11481.0586118634, -4533.87647732915, 229.81858263425, -12584.5516541903, -13043.2610633539, -5400.30433398287, -8080.75540254752, -6018.04493163118, 1310.62400178330, 7482.9378279198, -6309.42119645773, 3564.06209653724, -787.282607519895, 5551.4701698332, 6271.53740559438, -9879.65479493862, 15485.1384067648,
10818.7555598753, -15568.5374145466, 117.611747547657, -2016.07444395494, -7693.56681615861, -2875.30490987236, 7919.57534599016, -8102.43671763125, -548.342368164859, -25284.9254914776, -30971.1879200918, 17105.4452793528, -18094.8649260013, -1730.18690784657, 6149.23269181016, 13427.9054715673, 251.234495233434, -9686.80634690475, 763.948285604306, -6765.44219635876, -6924.28923543938, 4351.2128540198, 13470.9282793082, -16934.6274101511, 7108.91781096736, -11901.6206054643, -5754.54099283446, -7358.53061603949, -6566.10371822874, -7097.66458056525, 2181.58388784241, -2596.09994652245, -6322.07575795109, -10906.2900342583, -10856.5892199986, -18249.0466221950, -13598.8236647292, 118.209646223774, -1150.62980124366, 17219.499731045, 4475.33626750355, -14399.4896160713, 622.195245460515, 6228.2939828488, -8225.08135205716, 317.079167728322, 8162.0757721728, 14138.4194921406, 16841.2280772572, 7858.197733183,
-6249.91453626662, 6026.88814677233, -9.904415446787, -2468.94740153740, 13876.9607367912, 27438.6325735332, -8601.42928721941, -11565.0837790560, -6150.84584249366, 7563.85559769436, -5842.28817171399, -541.739210672082, -6954.88559107189, -2499.84986966314, 8819.64846365021, -23307.6504624936, -7459.997725058, 6522.54602365648, -2960.82910477031, -7949.68375898257, 2469.35650152794, -6997.36853414099, -7281.25852350411, -21609.4023426549, -9727.59620659824, 4998.91782331428, -4665.46756577378, -5007.78932029572, 4164.20697096545, 3786.78063585195, 7354.01726457434, 15153.5515530101, -4881.3751107362, -8759.0777076563, 5863.42899877267, 8312.351773698, -14561.6216485818, -5229.21712595698, 1692.12784667675, -11112.4775198528, 4982.30224222102, -5131.61162890964, 8560.46863846544, -9096.17332715429, -2723.97512904675, -746.580287193764, -738.117893283918, 6443.11875824588, 15682.4033149392, 10230.5508751298,
1553.21552030719, -14910.3414130293, 16922.7668834461, 14240.5238595389, -7992.61595797125, 2365.33467955880, 9162.44087098933, -2861.21237083508, -18275.4865289382, 2706.39327501875, 11374.6242047425, 11099.3131665419, 8056.66418629152, 1436.74336236156, 8070.21505399675, -15556.8688208798, -5507.90577406097, 4729.71551166834, -8746.06552149525, 64.2847307067655, 4616.42300653668, 9698.21255674279, 3923.01654309753, -16815.0652161126, 3624.9225649092, 7428.19228707702, -515.751791914086, -4600.34337749157, -3718.87650918938, -23906.6603297557, 21588.4570028556, 3808.84933472759, -10575.9760356311, -15072.7190550721, 8635.43834248042, 6645.60690114489, -12101.8276659415, 41954.8550452824, -1753.81511858404, 7525.06639520747, -1288.7163461049, -7149.94780633501, -1052.19138824911, -3493.9584948065, -15803.4707217826, -21851.5124325531, -1763.44481690242, 1781.17481276704, 2663.21719292457, -3881.64373286557,
-8600.76713249462, -8575.33295593712, -9816.08852515728, 13739.6608134169, 12919.8962340073, 8213.86107187795, 204.000257799153, -5651.72023914428, -2768.42033988729, 12090.6327749762, -9123.83274804015, 12609.3703327335, 7981.80874930728, 5368.9679014326, 1480.88644845351, 14012.2965484729, 1986.66923228551, 94.1170597266779, -2663.04881220572, 15976.9361432522, 4091.9108792577, 5920.81635575405, 19182.8566614837, 918.714408172356, -3639.44005873442, 859.578530298104, -12422.3396362302, -4769.39883297646, -7356.46824417933, 8752.404718589, 6725.18862980604, -2619.05694044534, -2707.61004687101, -4549.28464328311, 5550.37122147032, -2118.0384896264, -533.024016272752, 11030.6934419221, 19590.3097665907, -1431.02984818548, 341.484356050477, -15646.1815505824, -7973.02546361105, 7021.64270008083, -7398.53023454603, 6497.5642728947, -14826.0677728205, -15155.0395905193, 3454.47279224449, 1274.65538804940,
15136.4250063966, 2634.61627264064, -131.047130933474, 14350.8138825273, 3843.57917517211, 1456.04545325364, 3309.68954366319, 1309.41161672202, 17519.0350691211, 731.388709922945, 11128.026516854, 15230.1429460437, 5579.53237695697, 6712.15943367919, -12693.7224891183, -5893.15893320199, 2179.41172605898, -16580.1304254549, 15574.7223698664, -1235.58230593523, -4281.49526911827, 5348.31328981326, -2841.97504234001, -2241.09415200301, -16694.0827374272, 17307.1893395951, 11856.4076649615, 10832.3184580022, 12790.9236618419, -8298.73938877459, 4888.97111413225, 6282.21342134412, 11272.4909704968, -553.414887288863, -2212.81296482911, 8954.80223710969, 7550.41125469524, -21253.4651895671, -2944.33955324913, -17275.3272155466, 2178.83463282863, -14099.6421914634, 7086.75997009859, -7246.2717659521, 251.777791744718, -4463.09692923034, 8285.0220779598, 6139.99095691414, -2595.20363553081, 6927.075829964,
876.477938467214, -5237.35621810869, -3185.03340360349, -5212.06644762613, 8155.34657895837, 9137.67851641079, 11764.2312935305, -3081.69693741023, -372.911275286354, 11592.2897713017, -13186.0344854695, -2128.87517871824, -11461.4933256472, 3206.15744386194, -18657.4062104784, -9256.5509762841, -13342.5912965447, 5008.86441663507, 8667.04907922854, -15067.9648654486, -20713.4070371867, 17331.7079709014, 12450.6806836023, 3813.58592354743, -5314.19204138884, -9481.7643847975, -1625.47133426748, 5980.91029386191, -4570.67409665119, 14482.1593127935, -5945.73979617658, 1415.67782188863, 7687.0321979746, -8152.97356953995, -1602.58665350903, 664.991615919301, 4747.60354932635, -5947.66654154802, 1793.48610139241, 978.800485223829, 11073.623681651, 3526.06891572629, 6998.09737757346, 7330.24840882622, -9741.17760225018, 8438.2368197684, -9804.82676827193, 4488.13175000715, 7187.54100179748, -3318.85671929687,
-10540.3699555848, 12331.7454771781, -8672.12463027416, 11001.9400898818, 218.430454969114, 29014.2391462534, 10349.1891524431, -16568.5041438234, 14263.7207918010, -8753.00254753358, 15922.7344226545, -9094.80711549415, 20014.8461263217, -9656.45350445213, -3969.04210684058, 2547.14826554641, 18753.7317507468, 5483.16540392872, 5257.7676308545, -7918.51482221627, -8828.24271751857, -8420.9308896897, 6799.10562106068, -3770.01642463745, -2935.91675223561, -3411.47014622246, -7513.39690875234, -16038.9995932401, -5722.2632189767, 9088.81612562505, -5921.50368570464, 1157.1845319658, 14897.0901560995, -709.528076494835, 6607.67271517277, 8028.6192914867, 15277.4630795883, -5668.66588186667, 8124.27679199023, 8067.47813908132, -4422.39556996262, -1768.71418933449, 389.516254682528, -3308.85445729094, -2572.83789885432, -4102.71666926085, 7670.03929905919, 14038.9450588019, 128.467440635118, 13838.8737733869,
-13010.9885299761, 6941.38135637678, -9132.31656273503, 366.142410117724, -5127.02916036904, -7551.12792977528, 2011.12362567406, -2800.73013852151, -14301.9366454713, -4937.59261473466, 14052.3497884575, -7774.84997173226, -16859.1368052546, 2795.41909100985, 3456.39752833561, -1833.61912516418, 7749.95539740631, 14913.7275583030, -9207.88162217859, 11456.6824479260, 6450.62195623838, -8264.02862461315, 3622.60247104048, 13360.8852712495, 6933.18433740629, 2549.56804484152, 10512.6117472670, 3786.8455264566, -10018.9500545201, -868.136992233374, 7473.0224881486, -10299.1007217730, 9398.15960594206, 6383.4845797855, 8164.45168502041, 8831.4908008409, -8318.09844329576, 9343.43415400935, -13869.2840666871, 5499.52271697066, -3456.71197251457, 8638.43609335265, -7722.17673542273, -1548.89402075551, 20457.7348168467, 3447.2717564847, -6200.45961384291, -24.7413255547692, 5295.54307314597, 9567.09766851132,
11102.8662079696, 594.386855224411, 7625.0413139489, -8040.3329996603, 6766.258963667, 2527.50586429668, 8426.26012095692, -12857.1094022565, 15314.9370216362, 6827.1029380996, -19914.5051257726, 614.198268980164, -3129.72733416676, -13221.2473585420, -5364.85630916316, -10475.0095590568, -1255.51853580065, -10620.7549044712, -1949.45917716556, -3378.75249188721, 8056.25710561136, -15407.8628725591, -10212.8412805955, -2582.64419585255, -28734.6999070995, 15774.3841677429, 7098.39585205655, -3283.31641224847, -0.302268215359277, 8248.11952245557, 871.510429977167, 8409.4498052794, 22304.9131842808, 4221.89012609788, 4478.91758045931, 12899.7851022605, 20216.5532388328, -7772.3450286363, 2063.78933258242, -13929.0553833276, 20150.9767698615, -6945.33968488719, -8839.46897564442, 19309.4887545566, 6146.17092481796, -1757.51694913154, 809.442078245282, 10725.1854579041, -801.984328917082, -1370.79118875129,
-7530.16487247282, 2118.14323338065, -8045.60703313338, -1680.69467922360, 13333.0332710061, -2665.25422986077, 6354.51197265106, -24659.8683274987, 11736.6205715524, -14502.6881876177, -2687.27922860697, 7549.25741711665, -4238.31961020543, 24039.2615707739, -1233.31894603607, 4205.18025387764, -10408.7405643688, -6112.0069324865, 9045.95165878989, 222.696059418771, 4336.2589009708, -659.718745185551, 109.125640600962, 9028.32300816694, -82.307975178742, 2250.20075209263, 6120.97289765568, 762.183769138171, 5573.48539350800, -5651.64395995863, 4912.34295661037, 2760.43720416822, 29900.2654381736, -11978.9158413282, -14228.8068766523, -13799.0884896885, -1536.33267353946, 29269.2268791004, -11523.2684491511, 12441.3758958451, 18147.0826146205, 9888.53964298319, -783.147004128852, -8361.02073835902, -10743.9296497044, -10773.8583673646, 9884.15478280487, 1836.93748866317, -193.203030211243, -4472.69067041223,
-1083.12967651474, 7435.2918000411, -861.29312935799, 1374.04308433799, 12568.2280166065, 1770.72478695433, 13781.2135762500, -3831.97749471555, 15308.6494809410, 12326.1009698078, -7551.88013188934, -3157.43356379652, 8471.91460070194, -8474.11750221512, -5229.48658321032, 574.349098349991, -9669.18389721024, 14590.5111372966, 140.540701026542, -5673.75374940299, 4330.20761834588, -9064.67716701743, -1111.55233254291, 13364.2056781319, -2397.13488182518, 7114.5535922283, 1962.72281810089, -6555.29577666267, -1211.22205116837, 9908.6534603378, 9266.46123523272, 2454.34646095318, 2767.66517598743, 6026.25042979215, -1041.03153738125, 16980.0474016884, 5922.06049331694, 2877.88970676134, -7304.90110898131, 3139.82532338905, -4781.50823909546, 10444.6985518573, -1372.55272342338, -9546.59270795264, -8179.06285180077, -1113.93250706838, -330.677630592916, -269.242514033429, 8258.31085022016, 18343.9660925681,
8318.10480380688, -6777.82325962813, 3451.81368751099, -4382.64378065906, -11315.0552168084, 2843.3277777772, 12892.17823615, -8003.8256717294, 6991.43813114445, 6954.03034831808, 1020.98688919508, 5616.40791416262, -7414.37394327857, 2056.24464668181, -5842.27338285397, 13856.7704098370, 70.0131499513393, -4510.18713794246, -14746.037781864, -9416.55052156447, 2003.58280370399, 4010.5642139311, 4952.16775415689, 17026.2083314205, 2215.55091430398, 579.64404116588, -2893.25673961483, -16978.5450161520, 9769.1390127309, 8415.35406604213, -8195.82365633994, 14540.4927997918, -7198.14789527603, -1539.61662428771, 13239.5906651512, 1661.32512311422, 6069.80981346717, -8370.4646049379, -29605.5369150196, -11081.5667065194, 148.192191808901, -3467.18231382864, 7479.98113301295, -7433.76934973533, -6829.32384049654, 10354.8534597145, 8679.57686282158, 2691.54120499770, 7865.24940503867, -5364.4643362838,
-360.342100874971, 5277.17131934326, -13125.0823287071, -2832.38048622805, 12216.5964091710, -5624.0523380809, -4244.90489953177, -5409.32784744764, 20279.1068239727, 9701.49059187926, -904.10182118892, -8113.6439321167, 3866.82201389498, 10060.6456768263, 13283.8393923858, 6603.23137162653, -18768.7075974230, 1281.21439961364, 23212.8202881072, -4313.50163784195, -9462.81590616787, -11490.9188062610, -3016.24952574545, 2822.09634220427, 6633.64936951001, 252.532890069648, 5411.17646380375, -332.692901496583, -8693.30246013268, -11798.9495654136, 17779.7472476281, -11192.7309126272, 3057.03585465994, 7069.64101256002, 10650.2160110915, 3561.74877531763, 5639.43683552086, 1777.28495683392, 5152.10534946012, -10936.5780840232, -4189.62644477761, -294.400581505862, 1497.00872167089, 948.254434011772, 22426.8354208346, 6719.42444315684, 17373.8312541224, -7526.25289890477, 13244.6069559466, -27107.1524600339,
-5495.56074632106, -16233.4644203965, -1985.96354077756, 4124.03044115942, -10965.4777716633, -1010.30480657005, 9641.86916843932, -10812.4847460162, -13206.2909191514, 8179.36953753785, 7572.58401597548, 626.786973883652, 6389.26950277156, -6736.37896751648, -4399.51691660717, -12469.9332134867, -8407.63036516757, -1387.37115062335, -17597.3662327143, -10934.8955359536, 4775.10006864655, -5746.92977625092, -11726.5513161471, 4101.88062859755, -7747.63450516724, 1055.99661508595, -12191.6296470096, 1404.39048245373, -1954.89339402678, 13568.7543224881, -3033.00867716692, 4439.37269006595, 5689.49393671043, -5015.21813632725, -156.832126585204, -16818.3982408572, -20201.5856611655, 1474.16543565359, -14459.9958834113, 10470.8588153675, -3358.12718458131, -3008.71979354795, 2287.72208329353, -4158.73153381961, -7211.67050273611, -3512.42528408844, -14810.0985989623, -8983.38551812654, 15171.6626007554, 1799.93892023967,
23472.8871621336, 6203.97466957064, -6457.74022525885, -19694.0662992365, -4282.21058114158, 11351.5109878552, -1744.59777714166, 4629.82292897089, -3016.90968578588, 2065.27780756137, -5841.30605609023, -6333.68658864157, 1335.64731608412, -162.101732909273, -633.929131077479, 1801.65766561693, -1923.67193765637, 8887.89292761052, 10800.7392321290, -22919.0564292216, -2512.03004592118, -7865.8071901461, 8456.630149648, 3806.12317399226, 6845.10140219325, 7358.36506328308, 4859.52037835933, 115.559764597173, -15020.5613601695, -3260.97033726255, -7928.83140858978, 6150.99196745013, 6678.75457882788, -11430.6786710545, -5322.03516301041, -11782.0009630349, -4480.36450995146, -3042.84259358905, 2852.36217032902, -12689.7740989169, 6970.07089567367, -10715.1216642529, -836.431279846362, -13977.8313792282, 8570.17437835896, 3621.58937710958, -10808.8048597078, -9278.61453261708, 7936.7780469195, -1688.85029293014,
15590.9780882341, 7519.9361389498, -9151.15806657458, 3227.44663502638, 4436.36395209976, 1602.23551969854, -6123.96159584697, -7778.98429249122, 8429.7092192012, -14244.9701465841, -5725.86087558552, -10002.7976445878, -4824.28279586166, 21534.0462829978, 11145.1401849305, 14551.7614690140, -6821.46075629471, 13238.6590196188, -17533.398175041, 1749.71266647208, -1048.77124083890, 52.019795117569, 11366.6474803708, -515.920956581153, 1206.05218156084, 5395.45461470166, 30620.1820634963, -13680.0030504068, -1311.33851059894, -12561.1537204512, -11084.9128603182, -6317.61274655112, -12284.843297828, -6954.60259401979, 13532.6877812474, -4042.08656102336, 6143.05226551939, 12098.4769833628, 2857.67525783073, 3729.78099060871, -6575.98880727851, 4137.99728432685, -4897.13948500797, 2203.2517699032, 4305.43326358875, 9316.39069403751, 24654.6884760792, -11192.6979027310, 16696.8222718227, 7821.80205523764,
-13466.8466673653, 6439.36305052308, 2789.31899566824, 20514.3203232925, -2037.92326835505, -16049.5008254556, -5284.56169638816, 3002.13644289119, -14953.8981442902, -18046.4589947806, 11808.2348337624, 754.402419293955, -2883.4653372912, 3273.47474925218, -1598.30941521789, -450.152880945994, -2705.59917801875, 3769.5358311248, 3342.90318971359, -13424.8710518407, 11241.7766040175, -9581.19873793995, -18386.1430989744, -20812.924805159, -11240.1023315598, -5346.34373639239, -14901.4853730860, -4243.45224799587, -12600.0291708249, 3709.43302860431, -5365.0773000463, 12844.0296723962, -7325.0053684982, 1595.42205891350, 5658.35649005755, 12942.8237526743, 6613.86837919184, 8151.41262867774, -1919.48366251129, -5486.25320074757, -4911.69882342392, 13755.2058553851, -7014.86882096909, -5125.96927638222, 15451.5616214467, -21501.2686881068, -4672.00917772558, 13662.1137289853, -2517.22930081278, 12699.9021079073,
-10994.1650372605, 1082.59260405213, 10888.0083024988, 12667.5308427691, 9086.02780657668, -1401.30071864777, 14188.0906239169, -13371.3287851099, -8368.1738282937, 18652.0453509996, -7421.57421771541, 4845.79360690297, -18421.7409780635, 7752.90356500328, 6659.20084142545, 2919.80171260193, 3969.24730620773, -2594.27204702894, 5352.80319523581, 5433.81445444908, -8815.7776353296, 4608.09117999654, -7847.91081396033, -8153.94915428886, 18416.0475735382, -6951.484818104, 8511.1887511771, -6626.81532993452, -4642.76127158485, 98.6700629495318, -14133.0281606498, 11903.2198271946, -21.3617355865664, 8183.20943575022, 1877.52867758506, -6280.66532213553, 14168.6906790028, -16762.2407106765, 8404.27536486882, -8841.41906535129, 757.782919564178, -5576.29051108749, 1725.59809940213, -3644.47276848084, 2435.39737648295, 29403.8896980715, -3021.00821106345, 26881.5981595751, -1117.79022250152, 12954.6355816805,
-7877.6931986383, 2792.02302766424, 3738.40540922395, 12463.7068617216, -5891.38988655154, -9159.78395950459, 999.902159797344, 18156.2872525491, 171.125547462974, -5728.16721702951, 16915.6725174082, -6502.92748504254, 21265.4093914948, -9053.0814631274, -11157.2255643595, 4960.01885589786, -1936.26745040668, -11193.0400005781, -5671.96280772193, 2966.07219541576, 11139.7780370972, -7999.89041292808, 10006.8152374248, 15430.7404217504, 9943.38384030973, 402.325463676895, 6130.27614937257, 11122.3677175464, -8483.98758059015, 4010.53271300210, -2429.16532533731, 19906.1293933824, 9454.74743420476, -11152.3605465037, -2202.47107397826, -5266.57679887959, -11751.0505371343, 20474.8030118344, 2233.16986353603, 3017.89753794419, 4943.37764528922, 6780.64896743411, -13507.8249496032, 9402.82522801273, -882.349492617404, 210.905021026170, 4769.34179161077, 7777.09780140877, -4981.42868032901, -9667.73895406918,
-3761.47521344569, -12758.3920333787, 6639.12503656351, -10051.5884839444, -6702.91571076933, 15948.2769331193, -1675.08872363852, 756.29680506233, 4358.38903765645, 6987.35419027094, -4536.90190651473, 14946.9656387871, 932.14991993351, -8995.29827349452, 129.918556306859, -4602.23564544512, -6453.99552915667, 17130.0544919784, 9581.14693324637, 8912.20650360101, -4337.38100633724, -2781.11434583356, 1563.65688222339, 20038.5783749391, -544.360193487994, -4068.15537585061, -11348.1863958922, -11079.0791053410, -2718.62644195650, 407.949640636499, -2354.87283124025, -1220.33198488608, 6719.46046335485, -10973.930815611, -11280.7475006172, 4.22515478589708, -2727.99713240365, 10584.7683919118, -17647.1396104223, 19888.338127563, 7356.20938665239, 3904.51138632106, -1055.80647095718, 18545.3506648193, 2770.00747048435, 9373.5337436826, -541.356786861238, 7426.29910968973, 14550.7859327437, 1935.91026104827,
3521.83437395218, -7757.14643219915, -4441.78009873056, -4296.34048677635, 8669.06351687276, 14044.9013174006, 1575.46706447004, 7131.04982578448, -12751.8565719407, -4509.63739087397, 376.696173405827, -8000.37199996768, -3146.96673479856, 300.909853220674, -307.735239264786, 9875.56523553797, 16454.9678912822, 10355.7773112277, -9067.5535187168, -1314.82991627572, 9632.8925719968, 1988.63205913349, -2237.57888300717, -5054.17364066997, 2512.85495638666, -16010.1557560335, -3666.65374018546, 8574.21791340236, -9297.92147158755, 13069.5771201089, 2363.14539178722, 1250.18577373733, -6755.50320646073, 7732.85037602937, 10947.7009652844, -545.49593648292, 10730.1507930515, 11069.7194927970, 2958.96213910181, 1827.10858534762, 11084.5996404916, -2554.30789605401, 2143.00763919388, -6620.04166581413, 14900.0494580381, -2669.58527998612, 14759.9767160502, -1215.78816718145, -10848.3875114322, 6149.4112438946,
1280.5133410862, 25059.4115522934, 2970.37236525642, 7498.30399165342, -3995.89206851315, -4055.6582635772, -6023.12839354748, 17435.0090927124, -2504.19260773296, 13024.8730157854, -4732.82166216199, -1472.31938234297, 30620.5823865672, 1926.20456656951, 5241.15439694431, -738.179445427535, 10094.7838737116, 5683.93515122341, -7938.74997509891, 2722.03111550069, 6678.92636261568, 2477.88770434279, 13684.4960220865, 10732.4680555461, 14747.3592112661, -7937.21425052153, 15127.0012880096, 1542.23782135196, -2252.24333362495, -1612.82115001277, -3288.80180458694, -7079.12435800266, -5284.05947937328, 22085.0510733532, -24579.9835291228, 21910.4525715977, 10637.0618032796, 6494.07722334982, -5810.55223330194, -10354.5004061825, 108.227111605805, -984.835650131283, 8634.128875237, 747.347273416992, -18160.5268309023, -15438.3067708214, 4130.34435879483, -8135.67276541616, 1193.34058401546, -845.340708611074,
-4698.83644164109, -3294.78462633624, -10260.6053796036, 15713.7596688237, 1685.83500280335, 6334.96840386087, -10896.0765724291, 17789.5306768606, -3000.31815424563, -18107.0652492443, -8725.37337996408, -3899.30582472221, 18326.0495451576, 4852.58046070106, 3942.1320643398, -4792.15848775285, -11507.4054753719, -21447.0818288148, 11416.4060483293, 14506.5311160027, 12666.2654918468, -9491.06780047113, 2868.72086635851, 7856.72483454954, 5557.12880952764, -11351.5304449190, -4547.95265772707, -16772.3773726298, 5141.09169473421, -5343.5871308672, 24655.8100825707, 13843.3452442951, -7915.74682064663, 5239.06620437969, -10615.6929618137, -6073.45884500137, -27501.3551311624, 12145.7235217777, 1487.90834009621, 3481.77471427423, -5317.3203492169, -17816.2180826334, -3735.93984378984, 12417.2389640786, 9070.59605166533, 4921.46962699169, -1810.43611858284, 514.785518127376, 10248.8152835366, 20003.5237973597,
-3828.1832765269, -21951.7712396335, -3030.91518249315, 10776.9498493762, 2998.52109254516, 12802.3808955365, 14864.2045086299, -15114.2836816863, 17758.8281812521, 3538.73528658134, -22144.4817365270, -7976.92009992644, -7452.35761751997, -22113.3782089824, 4604.57384907743, 4186.44348587885, 6621.5764049734, 12674.9940961623, 209.137542504326, 432.519833094448, 14777.2302755756, -14009.2461485554, 9120.95104010261, -6582.44033351724, -11649.3194654489, -8989.95658598463, 7185.40659292145, 3223.04645012505, 10674.4000057963, -2472.94032201289, 6002.04417946942, 2875.06392102021, -9682.0639984454, -9930.71578039595, -190.160568684129, 6085.82390502005, 882.436263129706, -11074.1150134059, 10184.4321500449, 20543.5685128102, -6099.03692846458, -15531.1322091390, 3865.15108435778, -3454.55334718075, -3290.13393457419, -14482.6503237852, -6797.85021947463, 2105.51385090056, -21872.7759535038, 5786.43320411764,
7091.72874497572, 7392.91824295724, 4024.15079979619, -8973.44560569921, 11730.7440686319, -4368.34450097087, -12719.6225091051, 10037.4282654745, 3512.27393472789, -2240.69005374955, 12973.8569515753, 14218.0627359009, -5617.24113729045, -12073.2782373664, 4984.50355505512, -9378.88849630672, -14064.4186625511, -2556.62392131922, -6856.54697603532, 14168.8126076529, 3319.67398712474, 11048.6993505116, -23612.1428247742, 3127.10372965534, -3948.85326798672, 2887.40644526507, -21259.2716171746, -14997.7464959741, -3668.08026753328, 7976.95680958098, -9993.33248018508, 2821.29552458397, 3606.24193073149, 11526.9943009081, 17161.6517551435, -12840.6011182369, -12770.2953684117, 6631.98549295715, 8589.11107253154, -4659.46230600728, -9014.3989089779, 9057.84033287887, 15858.5208124402, -8017.87447894669, -5979.52485732506, 21474.9534322251, -1489.93448797866, -3895.54844329577, 7134.9491027093, -6479.90597038212,
-4996.8819231772, 10443.6141062952, -2662.3898591467, -3041.84651886356, 1462.66299554295, -4580.40875660864, -1557.40640649097, -8584.65930445318, -5108.00242033754, -1133.40428137833, 14694.1033425642, 13293.5482324996, -3115.49283697146, 927.191081570306, 6420.1812752164, -13270.3518454222, -10994.0439771162, -2629.52701677372, 16731.5576860456, 3314.85797251524, 16207.7759036648, -1299.11630518918, 6228.16379582732, -13496.3721706199, -441.443381093076, 9265.4933751111, -1899.92144656155, -2969.95447889413, -1403.06228332866, 8562.84035642814, -12423.6044165961, -4418.94869029437, -9210.39132537437, 2670.92223713358, -6201.39015177586, -12049.6445646231, 2804.02026762465, 1005.15439826286, 722.290758668093, -11110.0233558525, 5187.74220736861, 6097.30974499396, 12232.9067519479, 11597.4286104480, 162.283722724777, -1066.66235165245, -13119.9624821139, -2709.29539393471, -16685.9934963995, -8656.66400915334,
-5363.72866154285, 8335.63646529664, -4475.23403593852, -7980.7738407945, 7541.6834103499, 4636.38159776186, -6493.590688195, -20638.834668788, -6403.73482345636, 19280.9193205238, -6702.15449850397, -15067.6821397329, 11070.2707346351, -1906.88504879459, -6725.62556952798, 899.27039934782, 15288.6350495574, -12379.9858502416, -9016.19014179858, -10412.1155631880, -7438.78675027975, -4149.48640416019, -10429.6005176145, -9570.4544782674, 3258.087177403, -4897.63582485236, 5738.26448858165, 1363.50764917562, -16450.8234542622, 16083.5408150504, 6801.66300294812, 14950.8185573603, -7426.99707284611, 2110.43882353464, 6044.59658273411, -12132.7358261314, -236.346988695653, 12362.3433610869, -6775.51768601788, -3503.57864327006, 1929.53476989526, 1359.13870404343, 1832.90473470117, 4370.81979193189, -2498.55656152361, 1852.98881227282, 19763.5139465147, 542.290104227634, 5081.73806353132, 11079.3677149553,
7858.72336050382, 1600.76436220972, -13987.389905561, -219.399821078662, -5450.9369740892, 5652.32778722041, 3614.15468815554, -8336.64275819142, 364.578617414275, -22019.8793857586, -9109.63729832342, -13668.5142796147, 3890.17371826226, -4196.46454983520, 17906.1594001559, 852.688509139237, -5978.7629822349, -8851.73155487656, -4818.19050645472, 2810.68068418934, 6170.41725019772, -14227.0984790449, 190.663646192463, -4166.74265291695, -6248.32941338851, -8762.13105811527, -5259.82659854215, -3584.45067883192, -442.453301351340, 7081.7552542153, 13550.4915118534, -11678.5780882260, 2874.10838401326, 3815.82407616303, 1756.75803807904, 6856.35347320079, 7616.97456492031, -11762.3757365533, 9077.54878478507, 2308.52976457555, 1283.36616573795, -10079.6983129436, 7372.8471136687, 11282.724396132, -6237.13508604002, -4309.43762098959, -3531.83230677238, -9416.98139882314, 11116.4244586173, 17279.3932296780,
6758.63029436768, 10771.0885454808, 3810.2668139746, -7043.66069594739, 12102.2944521006, 11954.9998175580, 12080.5356664133, -1174.86018372835, -4800.83556903892, -2811.68709450537, 6880.52567923966, -13781.6927883705, 20964.5190341327, 2022.30089574333, 8214.50394317405, -21747.6720589077, 3478.50393874018, 1652.09037130015, -12239.6783040935, 13341.8800569775, -4753.22233608194, 4014.08737820059, 4256.36769854610, 10384.8466941727, -10175.7935573676, 10036.9002808119, -4087.72543159042, 4607.41713345553, -6729.60199352426, 1112.07481227969, 16074.1980494498, 23124.4229333026, -17983.4418282583, -4857.84479073261, -3146.00617696961, -6909.71777292443, 9581.43839126476, -3055.03332722542, 6668.61646164918, -415.555578519042, -13842.3159041138, 1581.38044963274, -24911.4056882663, 10270.9841188136, -2339.50268088854, 12234.1709818982, 34971.2191003414, 6876.64724277941, 13713.8242915961, -4158.16762546959,
1980.70044151966, 16913.6334945936, -13729.0090672246, -1589.01364897623, 1883.63277076650, 15269.4616785642, -2218.31319041127, 1101.79400663992, -7995.52745550003, -9368.93559121668, -11297.0492007325, -2069.84207903401, 11514.625160192, -9782.57223828835, -4537.72488241988, 713.170154003584, 12565.1503199539, -12412.3196024492, -2180.91155859484, -2709.85005683046, 9537.57239052799, -12008.0912903545, -13600.4573159884, 4172.65310885798, -14733.5761305490, 3297.78602577477, 2359.54375552482, 5388.05186170468, 7220.79776227385, -12877.8779813086, -13741.9364555812, -2246.64944443678, -10651.0128701839, -12428.4813788406, -2580.24317685258, 6529.79570443251, -14880.0447338742, -2597.33483869701, 6272.70649233375, 5841.69127229281, 5610.72941384472, -7698.8887947398, -13524.7125334188, -3574.05503113262, -3778.27856694315, 11990.1666699900, 26934.3497676749, -13271.1157189104, 378.377638021876, -10429.7305368423,
-8164.32987817601, -2972.96021736828, -2445.41847285054, 3638.79741916176, 10620.7226982122, 3611.0049464241, -989.967458119005, -3261.92665841297, 3075.35841263000, 8637.00595516144, -3729.48545612927, 10360.5829123865, 9378.02971846865, 3065.45068392145, 15993.3927091204, 8833.19045444387, 10387.0310593231, -6528.49465498448, -24489.5373823419, 16893.5689029536, -15642.2919754732, -18587.7101315684, 12223.1628372279, 1694.97242687839, 6989.04936818395, -5788.97010518993, 2924.53362250661, 1963.51005319821, 1896.83732838787, -31289.1177841899, 10428.6691109428, 14473.4889694400, 5820.5259749587, 3596.67960472859, 42.7949965875848, 6254.8777297729, 5468.2432483075, 6133.3618292936, 3205.84774310957, -9960.35703498093, 4449.72385493599, 6598.43392878229, 229.178235345487, 326.576314407747, 3630.01905536162, -5178.9247653503, 9546.76663192934, 6884.056359861, 4482.42195238016, -14965.4481003979,
-9058.27402422854, -3455.65256338419, 11600.6529872598, -10015.1186627615, -7520.86184753665, -7048.5517363287, -18686.4016530713, -25298.7007177402, -5553.48632704884, 3607.74931037788, 9229.13747024325, -9531.98535696342, -6318.46940504992, -7217.61251517955, -746.109802086927, 6271.3479161998, 16855.2123674553, -2111.28514846973, -21075.2843210073, 931.750779691117, 3536.93568537398, -3782.09350681817, -21835.1452069759, 495.40966462482, 7723.99398363152, 1098.43670989990, 7466.58023605397, 12166.587479735, -1707.67290693935, -18179.7772411005, -2419.64777852557, 13492.9401416818, 2881.25671116020, -19809.7019137126, 26489.923477204, -8166.75935339406, 2425.85829009280, 3844.0228959495, 13519.0512226406, 16547.5055217325, 2945.52472990355, -11295.3768199490, -9053.32920034083, 6547.61956244768, -16838.8507437334, -10913.2758805492, -1278.98050144487, 3038.23285604696, 7959.20485933006, -6153.35836918206,
3648.18804131241, 6320.74089837219, 1803.70028269538, -1427.92975173518, 8878.99765771074, 915.390953602496, -14651.564462072, 3832.53047604967, -5275.86887879710, 13167.3873813578, 8422.71498664639, 11429.3621659629, -2471.50700147899, 3635.71565568741, 14365.6190488101, -1.05212983073762, 2253.76478503437, 3731.84683043434, -823.853883278859, 12577.6905288763, 1962.61943794608, 7993.67237527144, -11394.2291860505, -4303.46551340010, 3669.96107542671, -14338.4305193353, 8794.6163802845, -9115.44099930936, -3591.55619271326, 8644.51670395217, 2793.30262868562, 9436.98194343518, -1042.26202275585, -6959.63719614882, 4929.68686850232, 92.1860431368678, -17810.3289169552, -7718.42710005584, -23510.5782607657, -15637.9361690893, 1572.40309620780, -4248.17938568229, 6441.06364501323, 16493.281092541, 4419.61147198449, -8577.89844035548, -1985.49688034663, 21252.6254712892, 6867.65300770444, -11918.2652824823,
-21081.0174051601, -187.332279347855, 13791.3315374303, 16024.3094879744, 2670.97584063561, 2613.19219625988, -4453.3944516161, -1788.54977207549, -17008.2029842721, 12000.9480830462, 12420.6344057738, -12804.4560795243, 867.095733126103, -3450.45824804521, 1023.56265162025, -7759.3134983636, -3788.84706250786, -11223.3224065716, 13342.4314124636, 7056.52752856997, -3194.34782900327, -4236.28772828393, -8711.62188655431, -4394.07179679363, -522.181535153239, 4259.9997262971, 8857.99978114938, 347.255370906969, -5145.67661074412, 4372.89138122496, 156.671081401318, 2928.76499770647, 6565.2589840498, 413.107622658541, -462.979160570391, -3757.43281403936, -1434.75290770670, 9462.4913923339, -8247.26144932864, -7128.38036727991, 8098.73590326028, -12671.0111390140, -8010.03954660855, 10291.7591785456, -12225.3113315759, -4805.03593507209, 5215.5593547815, -20379.415695385, -10367.3050959078, 2547.05065920137,
328.251743805354, 14925.8963424979, -8018.74135370715, -3944.33085162701, -18713.4193700233, -12014.5870071474, -4254.16846679176, -6989.58171919215, 5163.52253729991, 6437.54844029624, 6744.53495762136, -12652.6398855025, -9539.90634457723, 6090.6258360667, 1819.04159683925, 6418.6015883616, -359.663183830177, 13944.8603220351, 16064.8014693000, -7238.92234809932, -19183.4211634466, 18823.4722384114, -9604.39277635367, -12324.9378272815, -7778.95309864735, 28577.3829165219, -1042.4609923085, 8143.71166800969, 5368.67142053143, -417.036043634724, -6188.89439324856, -764.078775541366, -5812.86126399761, -17344.0568981464, -2630.25827752083, 16404.6700838282, -8726.33937262922, -25144.3458902848, -2590.16461664035, 10342.0545192546, -9832.03114566203, -2425.60160366625, -12685.3214296096, -1325.44864542224, -4353.29320216283, 14878.4058070053, -8997.5714366531, 2766.40678453702, 5535.80040883513, -1068.11385881175,
-1770.34475748782, 6432.80654144173, 4472.15943195105, -12455.2077029846, 2038.95513932132, -3257.78077512111, 2275.39570156116, 13698.2925583505, -15055.5570275299, -1173.34415286674, 8140.01523246278, -11902.2680823381, -4250.05518819965, 18435.1806002916, 28285.6913653518, -7036.56142924373, 12277.8502188718, -12435.1120983421, 14375.4725241798, 18679.1449413604, -12938.8601588104, -3164.72202404174, 15192.1621360240, 5644.83785391433, 2212.78345568562, 5501.1938199925, 2386.20545630544, 5441.33726801008, -14909.5302487767, 28914.7067652965, -15646.5815330857, 951.613600871355, -3803.99719379852, 4465.59402620573, 15362.9087256947, -5656.72473026021, 1053.05562023571, 7413.54606381624, -7623.8446333577, 683.626597056637, 1083.83396340621, -4452.19202690611, -174.812167219322, -8225.54070413436, -22900.9710206900, 523.216344843653, -9620.46298680126, -6246.94285814465, -9485.39084316268, 12639.4858525386,
-12158.8981855102, -18578.6274457522, -16739.9896635051, 7735.51690726691, 8480.37893373285, 6066.1920789342, 10158.8305579039, 16674.5572245439, -7936.83138320614, -3278.84698111439, 5607.01493488326, -11084.2961160655, -17183.2375974604, 13659.1537315801, -6548.57356353482, -9967.27468053422, -13167.7534494016, 17104.8790925511, 2034.28375664260, 2247.40945145081, 11006.8382846253, -4147.28864375517, 8004.36726595098, -8827.81021914280, 6841.27914756382, -3992.98210904529, 16211.3004298917, -3471.49709723975, -7274.50710716749, -18043.9286606615, 15688.2435438775, -9713.50602115808, -2648.77901280101, 3376.40746731916, -1923.41931440190, -8955.66140007967, 8631.88665518713, 3219.21005651568, -1219.02661242699, 528.354408920299, 2357.77615474704, -12199.3699973078, -10198.5304746699, 5170.34340541758, 6108.66171399186, -16984.3618476038, 11652.1373447719, 6925.92117775194, -6423.62961844266, 699.007018063886,
851.153956924956, -1992.25231842745, 9966.53891877332, -3579.94505371603, -2659.92645503138, 4460.17614289051, -2294.54335226914, -9574.56775049583, 7545.36637093599, 6197.59104934783, 11388.1180859253, -872.304524117423, -6266.35512040948, 8933.87076372838, 5141.9893269689, -12647.621553985, -10591.9817886771, -6122.86434461601, 16452.7025981356, 2072.1447218245, -2357.05851914926, -7844.00708119588, 6290.15026959932, 7059.21068311395, -9286.78888540416, 5182.99340707969, 5627.95448998866, 8935.63700187668, -2486.68066416427, -899.328041427335, 2242.98962652780, -5855.32946165859, -19723.7306648493, 21639.2029068374, -9356.52732798066, 9003.92056761238, 1174.97676377338, -582.691616680593, 3823.59045539268, 2565.18366101537, 6202.59821205295, -5961.31619185315, 11874.7200187900, 15559.1027937603, 2849.43536285179, -4083.03937894938, -13832.1953640980, 11867.2842963367, -20051.0976606596, 8952.88317066591,
12587.0304414902, 13606.4547525132, 4512.2403244391, -19809.8936598684, -4268.97213562258, 18969.8999924370, 12517.6851852282, -850.934400428425, -14854.1208951986, 2888.1409537399, -9737.53276526467, 5666.45574053879, -3522.24263192380, 12162.5850488367, -4762.57561996328, -1321.57219214247, -1741.91132226665, -15762.9024018699, 9293.94092389933, 8313.25536401047, -1662.43396203933, 15216.724289894, 9349.035279425, -10477.0854029222, 6583.94017568949, -1970.65404909634, -1452.88079490402, 9955.78124307235, 6221.74803364341, 9415.83713042729, -17507.3789906759, -11054.9466553578, -318.805717291873, 23253.6172477231, 5070.69322349647, -1424.85177328990, 6621.81784850591, 7550.14726496552, 8892.40029750348, 465.764216616685, -14883.7449978086, -1249.71877847812, -16313.5909819120, -1995.31528286781, 3834.66114458747, -7883.3306997432, 8387.48785525282, 20611.7623585967, -19113.2922444371, 14448.3119337663,
529.086598759555, 6580.2329252336, -8648.18385479381, -2463.13558970540, -14746.6502015659, -8454.81246270534, -12305.0921575843, -5321.09315563727, 1044.00422238266, 6329.64585979454, 3200.7367423372, 3164.91765944538, 569.396511988699, -1186.21013671247, 29558.4188613918, 23217.3292240889, 21756.8898565148, -5288.88996835778, 9463.1797398039, 3383.85841060793, 5754.19348765956, -19378.6251436432, -16213.3163791925, -7123.41093692241, 2724.44590804818, -3826.69481803253, -7484.28390798752, -17336.0600636026, -5884.93873023603, -3405.35763915975, 469.756266784035, 5627.86751286229, 11155.4664051694, -6397.26446152958, 17685.6050946224, -3648.49869506595, -4453.61119343444, 1943.35210423089, 5309.01165728323, -11917.3312407608, -12681.3121291536, 2685.43853604819, 19284.2185121848, -7885.36452367672, 9506.05193885686, -10524.8096862273, 3335.66117294982, 12468.1384454938, -1731.50106934448, -19088.1797003507,
-1398.70743723807, -2093.39130904644, -94.2870051400672, 1393.32562696120, -10635.2803650332, -15274.893536963, 3187.959311548, 9007.6403107394, 2093.36699848986, 2444.88132396997, -10522.3332375191, -1497.67241137985, 18783.4621174899, 10946.6244904614, -1729.09799194673, -3323.67207672829, 1439.30333037998, -13307.7965379810, 13330.0658614106, 4146.04311316799, -4920.63796281113, -10526.1896400085, -12025.6558424824, -5894.99152867849, 4200.56167241659, -9849.29775445111, -1145.55402079933, 22074.6750047229, -7009.09126797407, 3279.51970187808, -7532.40039733256, -9172.11823062606, -8825.35447140098, 11608.8783068400, 6691.15728961822, -2886.40864059959, 4642.98735003464, -778.751622582741, 19510.5642779360, -3152.99431361218, 4997.539640866, -11852.7377342243, -6262.18389136936, -8440.35261876916, 7212.37077259871, -8048.48609125212, -5810.51994883212, 21793.3523122178, 1259.50851250616, -2982.43413556437,
-1069.46030298556, 9758.49832679154, -3908.07077922033, 1320.99374600299, 6840.44127262085, -4118.42294455477, -10291.2396630256, 15775.2835029083, 4531.43699063607, 484.216039597413, -1452.40633102103, -9007.57229031525, 2532.22304309091, -1624.44930638343, -5864.44122441694, -8255.36840003812, -2375.77765577063, 24226.4524782108, 7559.95641371435, -9273.59122289261, 4921.96698863886, 14337.6089211855, 25101.6909823347, 9183.99237264343, -4081.38793272373, 2071.99111909967, 10722.2188711345, -17598.3114656462, -7126.58115181857, -4974.60102423919, -18864.7054703764, -12775.4767863914, 4285.9414672963, -9209.67876538554, -5400.75943540013, 5067.77860380034, -25964.9585539955, -412.731204974459, -11974.5310851191, 5281.65127180779, -15857.7351226414, 3062.72273588173, -4808.87028774837, -3930.59196840407, -5594.01806165652, 9155.67237157994, 9778.4584494631, 9603.5251452568, -2084.91971550607, 4616.89795154247,
2887.05683083313, 2214.67983292177, -8138.39582438432, -6430.24101022376, -8138.33111299527, 28805.3948978265, -8990.20063601434, -10224.3959966424, 2067.31175644786, 5318.42911503692, -8286.5297881894, -2315.04185012002, 7633.35719590727, -5572.92691154325, -2205.04653000039, -8890.77402527985, 971.932732038222, -786.511013736179, 6175.01258357475, -19464.8613587248, -4084.83401006874, 2673.1893069102, 12645.3076794401, -6531.02232298258, -1418.93986278358, -10355.3565085494, 23194.3976576529, -7568.56690572485, 24789.3195102202, 745.469177163366, 2404.79227450158, 5365.34237034964, 9688.7630775103, -6488.60443618561, -3183.44912646415, -2027.0308565884, 7748.95068478664, 59.4212336004029, 12036.3392037480, -1339.55242674404, 6871.50283463159, 96.0219279730151, -1224.97864843387, -11998.6412271888, 4062.28444379809, 12508.6562885322, 2283.51299497916, -5661.63568037693, -21075.6995816769, 15555.3568087916,
-5863.19626211692, -7720.63350729686, 4097.69000379121, 2955.21550148742, 2275.37926405776, -3485.54786860116, -3376.80175120822, 3873.41699149116, -18042.3164092100, -5945.65483487155, 7740.2650351972, -985.570199050552, 8696.0208990437, 4743.15667133767, 24665.2061955362, 9452.0001068856, -6050.0876461255, 10650.7752688701, 7961.64701294977, -5227.18070741001, 10364.2248479695, 19717.5781951997, 1983.59714104482, 1809.93695502795, -7808.7764943428, 3515.6671978837, 13085.9195465074, 3551.70544635301, -4368.48476461785, 20333.5628134032, 4482.89921824406, 17543.3317373806, 9454.1995700158, 12536.4397162946, 12791.4712830680, -6371.00537628945, 6316.46480099784, -7362.49802765246, -7340.72146096596, -9889.08062739139, -10295.9045232520, -13972.3820389722, -3854.30392283752, -24667.4829049193, -4156.84398318785, 6484.43119639838, -7052.92407927627, 5786.71458750405, 6656.07421324335, 74.9228985612971,
-4737.1449877747, -677.099190516198, -3728.83004220666, 4352.80765499313, -1987.57638726001, 850.609765279381, -4436.42791793939, -196.211385186121, -6510.43466765689, 3502.70309567312, 24355.9302237796, 9825.20828992563, 15028.8296988165, -1035.14339702042, 6404.31406190151, -14467.7034591687, 418.235288742969, 6977.3513136535, 5275.18573314824, 4501.12054022185, 14469.4124686328, 5498.18434074371, -8821.94659290086, 8873.49913635219, -13026.8573129455, -5463.65752917363, 22221.6933934934, -17276.6923390740, 35075.3568590123, -3069.75452257077, 899.774518126699, 990.35252562149, -5021.92591386533, 3309.79317939582, -20864.6284626929, 10332.1148332042, -11820.2071841088, -6617.20453356791, -547.722587366006, -7442.43864655895, -13075.0381405048, 17873.7673974151, 3728.96445745855, -17384.0231332554, 10281.5756339450, -5494.66868034424, -4101.18686086503, 4118.20796994897, 2194.98379620244, -1752.66830256084,
726.879436917596, -5580.15260143472, -13667.8944091658, 11056.5309504209, -9192.83171982899, 6281.04652266824, -17863.7993945390, 7407.64379367348, 3542.01167150378, -6133.67742305791, -15118.0549369925, 6687.98217040297, 7971.4214380952, -10782.3816836785, 13953.3549944342, -5267.03810007737, -12077.2758494046, 5807.96341917963, 2826.74749845427, 1574.93244300989, -5966.03111363501, 13354.9060415424, 12956.5841647995, 4725.80191595835, 336.438456881131, -6340.2151074686, -4191.82407352058, 20736.8569480218, 7755.537035059, 10886.7627739182, 11938.6121109076, 16351.6933569702, -2146.29669557316, 6046.49949888173, 9746.65564396431, -3839.95250690229, 4598.72360541908, 5757.32159248821, 6944.32453371706, -14856.0699387038, -224.630398146851, 8973.21853720913, 13272.3253998985, -13445.5422531680, -2566.42848400258, -7998.12052043384, 1886.14261601923, -6616.20739131288, 447.011156742712, -5158.44672809788,
-10084.5974840253, -1605.11742826467, -4830.22133676771, 5395.70196384489, -915.312250681838, 6888.32271441858, 8140.64848429746, -15412.1094262354, -1958.53086857358, -7334.47965566987, -8230.0175518831, 2894.31952789788, -5300.17351618974, -8097.59123200719, 5088.86822686245, 11406.7166170077, -807.773555963248, 2041.51515818584, 12517.8981146127, -13098.8302397369, 8179.71670365038, -16077.1297384529, 4868.95730623276, 4568.26616761989, 11654.7835565453, 5967.93488426115, 8816.19068868565, -1085.83868737460, 11972.6464461467, 898.501277131997, 13495.1565748653, -3801.29127526523, -20232.0053153211, -3728.43994943784, -3265.76378998868, 13831.2235691317, -2033.08164435529, 8869.67830057863, -8945.6432553919, 1655.41542357588, -5237.77867327425, 21194.6212380948, 7496.38487138053, -2534.58291443739, 7894.16522306491, -411.833044587009, 1941.13227577919, -835.202789330707, -13175.4311923443, -633.579071187666,
-7216.86310943319, 4892.7356365574, -16356.4049005272, -22065.1947972293, 4549.59531183912, 2965.23340291187, 7193.90771431912, -7688.45146034638, -5394.98839463856, 6276.2907038032, -16055.8433581785, -12333.1806525465, 6919.34413700972, 10662.4187126883, -3918.47455028046, 10648.0748128335, -23494.7169593063, 5929.96228393813, -12029.8210338684, 8505.71432821114, -15534.7570998859, -6470.77851185093, 7939.3781845564, 3555.24241810137, -27705.8065357442, 1369.85142622644, -13309.6177746570, -987.620317231878, 4315.35010971494, -3237.36224698637, 2770.22746146170, 8104.06423141218, 13433.3002282524, -8673.20485272461, -1569.91030656079, 831.594240252013, 8654.35896200142, 3103.23923307718, -1504.26140331611, 6983.83958647377, -3508.17769938026, -6168.32963183532, -13515.4333638551, 14300.9032188029, -2892.993311635, -2738.23641611687, -5292.63645062433, 18.276890905918, -2937.36307866520, -7701.63319367714,
-8231.35501627282, -4904.44488145935, -5788.37203928754, 3762.87914012076, -5191.78068965296, -12280.7305131397, 2050.00750882016, -7958.06306794485, -5985.61920886675, -4769.57964432112, 23949.7654007804, -10656.9050085556, -8272.19741209448, -11482.8502837001, 4346.32656043411, 10673.5246624738, 7703.9939117932, -4254.99054069772, -7239.97879740124, -7024.18076472046, 9602.67707923016, -1736.43552098692, 1378.84026371565, 1114.51594728836, -9701.67868251545, 9337.71561197576, 9280.89427374223, 162.860244491303, -20112.6730820033, 10788.3645423493, 6224.61730299933, 10994.5345668304, 1905.20165610085, 6748.45516499758, 15173.9622706927, -2239.02983129014, -5654.96533132531, 8580.11343707533, -14139.1514453977, 7844.64761742387, -13300.3745479853, -3543.00746665179, 3286.35778076361, -4272.56181403075, -4333.13046541734, 9540.34860628654, -15020.9822741556, 9104.56375413315, -10240.0146657455, -16485.982091719,
-2147.09899882104, -4167.8544820226, 4913.09533840534, 6944.88743892773, 14506.3588266583, 622.960565317762, 11561.0604179070, 10216.9810453117, 13740.1907435929, 8811.82744286671, 16441.4849103172, -14442.6013012307, 7414.37519601885, 7141.56362556873, 2213.12269210017, -555.089079506994, -9968.9471347185, -12510.9999619631, -14573.0010758804, -7746.8935292431, 10467.5177885604, 5641.17471430818, 421.013486166145, -4859.24867435105, 13463.5603468691, 20630.7028362060, 7286.47123257527, -6925.03870767731, -7273.83781861462, 13736.9959431036, 3244.20018075907, -2263.85410354030, 12659.9907182544, -2008.59666689935, -1771.12700724168, 7605.45468198941, 4051.86374323382, 5106.2565530223, 14998.7454335991, -5255.20946052196, 2146.36191638861, 15128.6790397255, 3243.13712278358, -3190.21119642722, 2423.67597880239, 18814.7700747730, 3800.63257211669, -10993.7450365076, 2349.93141877593, -7417.46579962627,
-686.316762649096, 3892.70793723231, 4305.46470915774, 3677.64168548138, -8888.60602441446, 2586.76022692734, -6361.97206560332, -536.269570836826, -12988.1435116130, 3973.21257267965, -8771.6489552965, -3806.91223658372, -8117.58554586808, 19874.1202784676, -7074.84999963197, 1845.97776660672, -8783.29096853744, -9213.24782185591, 1952.96376413942, 28612.1605034938, 3032.19066815205, 9158.25432308955, -9944.46399142012, -2213.45745542143, -5644.58790035514, -5340.40928454661, 1095.48940215730, 8698.9404587463, 8461.08443610477, -9013.64123180462, 2331.63220559641, 2334.64356415894, 7507.75630420932, -13748.6141910212, -1663.53876250092, -5826.5886197731, 1482.00378585978, -3928.85905059878, 12884.3736720856, -12704.3515479976, -13968.7832605823, -12380.7781327824, -3087.48878351505, -275.715018010608, 3190.68274661464, -15149.7468165634, -5979.80388377228, -4903.17578384227, 4649.00423181774, 5338.88346833139,
-9107.76304251484, -6057.97527378124, 12801.8207292003, 7730.16030125723, 2753.06558387889, 7128.28355019567, -16376.0135549846, -11579.8305615360, 5908.73268447345, 6152.25990016628, -4935.96166534765, -13952.6497545544, -5266.72840449777, -9172.15475096494, -11950.2415908319, -23227.467185525, 25343.1012379351, 21894.8917649566, 9219.65291257388, 3336.28057201696, -10253.7523944212, -855.523019477605, -6321.18835187538, 7178.16445151751, -6607.61466325018, 19703.9072461377, -11226.9196989145, 1996.18702430404, -18512.1467516655, -11893.3203765068, 13005.1193428831, 8800.42113677496, 3886.22273071517, -1675.45531975321, 4310.85331816146, -571.743921985318, 2630.82518337252, -16316.3568361388, 6511.34879970428, 3874.15940875158, -15728.1913801147, -453.202205356111, -6371.10565569342, -23125.4243641766, 6246.53424275291, 325.03080403702, -14262.8673804208, 1348.88585636101, 9553.09947756676, 7682.90988447338,
7702.60987201496, 12631.4647640854, 2014.08878658247, 4177.32340235659, 6745.44309021972, 5254.12316043746, 5980.09284597262, -2124.14602789867, 23059.4592093700, 711.714469537971, -4176.83512300217, 6191.91242968774, -7854.1411161041, 7072.43391789103, -2533.87092336940, 635.772020360041, -15558.0423912002, -4981.6820914699, -2465.07545376002, 16919.7804511905, 4098.41229618822, -2308.97135121485, 6909.02606976512, 16337.8136760394, 1260.22386625425, 11910.3184950000, -3625.12009840876, -17264.7107245811, -13016.4199483152, 7525.74945773104, 18412.1142456265, -1699.25283817020, -8237.60494470169, 7203.62712977716, 21525.5146969616, -12170.6074566121, -5399.57063332927, 3509.79480337337, -10421.56267954, 3284.78109585178, -2666.43393276463, 308.00465218797, 4402.55151044526, -5436.01477433932, -3717.04722239592, -11015.0484024141, -1796.79120936375, 5624.65453010711, 10842.8622456077, 912.348529100834,
-5683.43873262308, 19895.6282979148, -6889.77007691614, 2565.63253352238, -1720.52850232648, 14775.6512607148, -7012.149117954, -1614.39840566771, -20723.105012471, -984.306874706967, -9479.28165103427, -1782.44795364309, 11101.8785536079, 13191.2445707016, 2017.80150650678, 9221.31342533081, -980.012514794165, -4813.02972782876, -6871.30839850576, -4479.92917450659, 10719.9081335213, -12436.3035297200, -9774.45568973892, -7031.79684106384, -2939.58567639146, 4144.28608135736, -20670.9810895196, -10646.5145464746, 1482.25143376517, 10158.5382022709, -19012.1833882970, -3844.90792729483, -6593.58459642845, 26094.1897626602, -6207.53655521174, 3581.73970822108, -14656.5454695658, 2559.28682851197, -10111.6324583814, 10236.2374713165, -15433.4438645939, 11737.4500192054, -6545.31950754287, -4247.19241604287, 7720.61116533318, 15842.3773469658, 847.380160702194, -5624.36550560983, -3149.51848297336, -193.386936927703,
11910.8479975243, -24103.1333388311, 5502.12237276774, 7870.17119658337, -2813.5311873177, -11604.1254642639, 7316.19143394093, -14590.9086390203, 4903.39481104629, 2033.17076310717, 5241.82889047789, -18465.9028380239, 4531.014663028, 21892.4562627062, -8264.85923452528, -16650.7974335453, -4586.63583124641, -19717.3896517579, -15540.2314479162, 5287.82224909941, 11530.9947546759, -2179.07851803024, 6695.2682143098, -9153.50176364406, -4393.95633963678, 10972.2970517423, 7213.98908763214, 4498.62878513722, -3845.55072350872, 12486.1098457387, 2865.71405070110, -2748.63958915356, -2216.05474804096, -2188.26696436651, 9747.22480354642, 13933.7283253031, 482.880528302885, -1321.76589999121, 2316.91171384311, 8931.90032613878, 6869.06596944867, 15668.624757367, -19750.7585568188, -669.576395639308, 15431.4773454328, 11768.0183324072, -11022.5755484177, 6529.00145590507, -8606.22533681582, -4779.01127082851,
8179.2020253707, -5359.9203552593, 9772.50039838626, -3309.34559697327, 8248.57390650957, 10811.7906660900, -8427.11173180718, 5005.22928644525, -6117.3925653074, 11000.7299266127, -1936.39833078005, 1422.44212464422, -13002.963015064, 12149.6678087043, -1013.39139914660, 23011.3328042587, -2901.97298661737, 414.900935690629, 6353.74270483133, 17229.1085017347, -2623.22480519604, -4734.92838434599, -11931.1306618232, -4038.45600716627, 577.941179180243, 12065.0233759077, 16204.6088431369, 9752.33560573738, -18793.4223786624, 15473.9771307103, -7307.69949832938, 1375.30815458732, 21163.5310631548, 3929.05560154190, -9703.00644797056, -2370.52323165269, -7022.97004903515, -9046.3426786182, -9509.77047210428, -6023.05122563759, 6602.99579450364, -2164.36060502598, -6464.79075196962, 29188.8221205901, -7871.89473118129, 1830.30053131648, -5685.11339147205, 10003.1908932479, -18194.0455184167, 3486.06904360043,
-8683.8934838666, -2459.67012181272, 1173.31995671848, 9527.09092142303, -2639.03353902972, 20634.4115842801, -15792.0839586123, -12333.1807348315, 10507.7541788692, 5295.62681597934, 3819.65646531608, -18821.7760808016, 23470.6902772661, 12113.6661984995, 1761.66487901323, -4979.44043463584, -23150.0729308694, 19763.7124418869, -9603.6139488522, -3722.54165775771, -2979.41044977805, -10011.5949902023, 3010.24212011476, -3724.80752374849, 2964.84275414036, 40.7594863981976, -13052.8057689613, -13341.4152839231, -6692.11595694392, 11029.4033393719, 8614.03815612597, -2495.38605697546, 18002.4467379492, 11102.7783329134, 7732.51585839191, 22768.5502051246, 15695.1459927492, 293.028441736075, -734.459538011504, -16620.6762677656, 6921.41897436254, 7548.60523029205, 8191.43288305924, 1622.47277857483, -5401.08086479804, 10746.1612039051, 14826.7531688527, -5160.41387156575, 10351.0795824360, 11233.2091967538,
13607.6229507570, -1482.90851785033, 1178.45523959058, -9992.07140009776, -1638.85105445075, -534.500171086086, 2299.13610584071, -13250.4748591714, -3958.67838577909, 9119.1771971194, -719.928927482014, -8606.49848957195, 13407.6615089204, -6951.47110457894, -4185.48634941225, 7512.36048955413, 640.590329885941, -528.932149677451, 20120.7783395021, 7407.99803031561, -284.872518425303, 8882.52041884342, 21977.4691157522, -6339.61736281464, 11080.5664650948, 23797.0638962404, 10648.1947503149, 2791.74587658885, 15117.104953394, -2391.58623703215, -87.592928058219, 2111.60204678432, -11672.5004472279, 1566.39723099225, -3439.60397252712, -11983.4768424156, 13763.7629207776, 15355.5007166776, 2706.47753485181, 5208.75481617193, -9634.95019411776, -11834.0836656496, 2189.66770971446, -4223.08911107065, 10375.3862076985, -9654.20581081532, 2054.22441980450, -2040.74546145569, -36.0400488551915, 7637.32609120373,
4408.77005758327, 4468.03203445801, -9210.4309746287, 22338.6299342918, 2640.35712585595, -6993.39916937378, 6816.85114828286, 6405.03417317658, 10558.3348479436, 2893.43690561396, -15644.9111813502, 2364.01949152678, -1733.74473947748, 7777.35653688649, -10477.1485358545, 3822.75930712094, 12444.4762823661, 8793.58644014563, 11749.1102673534, -9095.84289580509, 11584.8101743227, 3787.13274243599, -7977.60514711722, 11087.6999246800, 7299.23058329821, 6678.08604740606, -9629.75912952476, 5589.86209287102, 10061.7533494115, 529.967553800226, 19674.7990614039, 4911.97505362269, -1871.33551529996, 954.350738725968, 410.436528661807, 28772.5840900249, 2990.67132006011, 12802.0365235763, 1040.20015307631, 8302.19866448303, -1939.61999336853, 6958.40354458797, -1865.31169643163, -22249.0834675010, -8773.02452714147, 1971.43529198380, 5261.51534544632, -2382.52402275689, 7198.3913107299, 8511.10965457258,
-7808.53236098579, 1424.88241190044, -12176.0307874088, -574.596211366644, -5152.32522340258, -10086.2459893900, 22462.3912946882, -4634.83015237711, -15500.5602610441, -14530.9959241919, 19506.1947841569, -8377.6901864232, 4235.67145658982, 234.618628509637, 8782.26287599298, -11608.3047561985, 13577.6182161562, 11343.5282304273, 10002.4949947037, -150.927702320332, -4676.53403920204, -106.937553347030, 6618.53479380028, -4171.22754599242, -12763.5140777626, 3847.20172068878, 1006.75309674139, 17973.9661990831, -18877.1443320551, -4195.1828168789, 2970.41337610523, -4826.7721533503, 14812.0273609374, 20882.3119069455, -829.596246285544, 1997.7540364724, -3851.74324786277, -4426.40392934509, -14499.7639334982, -13057.5822541192, 7654.592893998, 9350.13901264082, 13673.8427551849, -749.743030345643, -1414.26276655125, -2789.28894993484, -7559.84023883908, 7384.9796515914, -872.096957783704, 4120.55050752646,
1820.19946294428, 1254.17180684127, -1824.72608675663, 6568.71700148, -3139.60063456663, 11984.6609512417, 874.619579598934, -9355.44868764078, -826.206045489028, -7956.98811291737, -3225.91468824075, 11434.381765886, 16760.9071997997, 7941.20146699572, 9055.8944663037, -10071.8432178143, -2394.75441642553, -10247.0879512960, 12667.4131967604, 10364.0630181367, -5872.36385961997, -8059.72547068219, -11096.7096513743, -9675.8753588202, 32091.3209248539, 10610.4927821381, -2687.46733991051, 7983.50603676294, 13816.6430486238, 2281.07623870830, 15039.2969262989, 5977.86393285341, 9890.32182528247, 14531.6131247321, 26063.5428806871, 1280.18591326641, -9148.5557457354, 6984.6979607012, 6417.8594987865, -1966.56899833723, -1252.10500153876, -3140.25781698418, -8607.8998807931, 2685.93947451762, -11366.3666088513, 6529.60135432791, 2622.57031307169, -8264.4382148911, 7760.29696100648, 516.984783359351,
19745.3507486497, -13563.6901748028, 11279.8090514382, -10518.955537655, -294.445166051541, -5948.67821738272, -301.69968606719, -17723.5737472365, -1321.49953991001, -4421.63109694673, -13125.3107800732, -32277.7847403167, 6227.14247875785, 14225.1887780516, -10885.6762563794, -2032.27218378306, -9965.8449188243, 3837.50881871055, -24718.3239955421, -7388.73577276734, 6452.36465754738, 3903.90926633336, -5836.30471581236, 6464.08716239171, 8584.35724178568, -1106.34128030584, -11474.7089479516, -1915.74843590581, 8362.32673949593, 12909.2873421734, -1441.81241078039, -8978.02327369177, 5835.27005840825, 17156.3267752056, -8741.94270868383, -5204.55349694816, -3796.81739995493, 7440.29779787027, 15660.3837625607, -23220.2878159618, -22378.4589018320, -5993.35783207428, 16704.3966193514, -8389.80124116559, -965.634054415732, 8080.7062909163, 1658.19988984857, -9024.38784073541, -17585.3262027094, -4026.9522795593,
-4847.09136024644, 3952.22817875172, 16870.4920546086, 9113.46635937356, -9738.5496285101, -1678.43486404832, -9872.15684145089, 1056.06477109596, -4622.94779072534, -15081.4001048515, -1005.58106495869, 6868.75499042741, 6207.59375733168, -3215.69303523415, -10209.5129165981, -3857.48651930284, -16504.0660331169, 6861.44887816554, 9171.19027647992, 2109.09644148060, 6466.98738692035, 7234.2607606375, 4217.55782546834, -8964.80948133332, -1980.08942609505, -21610.7362309589, 15646.9327762413, -6447.95200198259, -1238.39986856946, -6588.17217871254, -9535.8484498451, -1282.32300449387, 605.442063353517, -3372.90467806267, 5687.68251179512, -1989.62690380583, 7350.0881370311, -6287.69911408199, -4906.35133698183, -650.416783106826, 6359.86038722362, 14464.8322278254, 14619.9928484313, -1356.19514917669, 316.770763820895, 10986.5355119039, 6054.7810340313, -3848.09249186997, 2275.05096160619, 1299.93135356109,
9697.80041736407, 2684.01293951249, 212.511047747819, -13726.6533998110, 9207.54066158457, 4641.97706621692, -0.241160769659885, -5962.29081509903, -12485.9508472745, 4537.53629015213, 429.599049371582, 6614.8963108324, -3455.97317875935, 16096.3473897250, 19014.4817573203, -11529.2157985744, 5326.18947893432, -3575.80768076626, -14637.2730985565, -10082.2985634396, -10476.0743345894, -10012.6121602980, -13739.5543254500, 996.740491860702, -2675.83648585496, 946.322862504347, 7256.21698687362, -4834.65847968313, 7309.61843686376, -860.051756950286, -10940.3509672129, 7843.4035439314, -2577.17296329100, 232.096266373914, -14665.1106368596, 7243.23886714058, 12776.7896109803, -7209.47030035086, -2087.19427470714, -15415.1428338182, -10954.0719815360, 5313.97988854158, -8804.17239999468, 3592.35434828592, -5461.22724009895, -10216.8234086317, -2294.02237012970, 341.847354263916, -11532.7407109827, -5283.17579155321,
-9915.00907289945, -6930.7770848835, 15608.6543389669, 9852.86592579898, 2318.1058523209, 20717.0854080694, -880.986477752934, -14441.8408696264, 16495.6256417791, 3152.47425907219, -8532.6495292423, -8496.46030976805, -1313.78547424769, -7314.40186797094, -818.443162491996, 19688.9093082116, 6009.21997719322, 4638.56454147549, -10301.5746052556, -10534.8223441248, 9494.3914182345, -4213.27447873057, -19177.1770327065, 3387.37163683394, 5494.90411765995, -2079.08311488286, -3468.63074453921, -12707.0762218820, 13407.9380518545, 17891.5652907427, -11795.0264213239, -4343.9043318088, 7234.53779442459, -7688.05121873389, 12819.4656578627, -10764.9200279225, -2968.01299333214, -6412.94239856847, 4491.52844218263, 7118.71439617908, -3278.82214508625, -12233.3403623601, -619.83580823093, 8710.96776189364, 9115.39478370404, 6147.13954937945, -934.233086063814, 4906.62692579285, 3912.56162691743, 1083.93357070414,
305.530197238026, -1562.76967820089, -19592.4722581862, -15353.3586307429, 9229.7846394253, 6867.27589445876, -11876.8580002364, -6994.10479960623, 19830.7097478344, 6464.65072974247, 9069.60951562874, 4445.69232399863, -1066.02818256066, -2455.72717113097, 9382.90988637206, -6990.41110637196, -2059.87605515241, 559.490209581068, 4239.59325382831, 6499.37648758687, 3696.95755224207, 71.6159489419087, 3867.48456572436, 12019.4828706972, -9856.91362570257, 13923.7283750374, 12095.4291890421, -5802.08584317882, 7183.44410996416, -5046.57632257717, -6440.15523995526, 7107.2499896959, -315.443767342517, 2216.93678499243, 7159.96546993325, 7889.63736997913, -5493.90015884047, -161.356918680943, -9143.81939759046, -15921.2763622478, 19362.2156042359, -7650.56798592568, -3483.88519852648, -1064.07641080773, 5701.48115169213, -583.729956597293, 3421.17828006279, -17395.9657687752, -2449.86493699252, -5591.79145969962,
-10077.2161638232, -4336.44793316305, -348.134127234342, -5183.97766564894, 9191.88868970031, 1494.72986089728, 8456.6729675495, 11493.9008544875, -177.968965111052, 9033.30148543038, -9776.2119182365, 19173.5687403651, 6737.04215389899, 13625.8332513427, -6980.14190309085, -5195.17825456214, 6678.94783072969, -11424.2302905623, -3290.21190235017, 8768.29253384606, 18721.208975569, -1976.05478079694, 1808.73651711345, 2357.41987721487, 4011.92532510421, 2945.83118265104, -14968.4259699599, 466.68366648061, 3940.08988706722, 1535.27575132348, -4167.72936902865, -20543.2479912947, -10482.3514021838, 15150.7679098292, 7789.04442206854, 13902.5480247042, -5414.3252882761, -6087.86337747, -2429.91693885450, -6632.02927597895, -8368.17711669248, 16059.7977807825, -4180.47257507368, 13245.9311763305, -16029.9103073286, 84.7538421955927, -793.068546085388, -5058.6921717027, -15603.3944049744, 15793.8694480641,
4189.73065056335, -7954.3420849428, -10334.6047773677, -3470.7250631918, -3889.99365721765, -2723.63252657222, 8381.1829338195, -6375.59368882704, 14571.2220308849, 18769.122774409, -8488.24218632707, -1080.57844057456, -11434.8305848687, -9318.47725318146, 12182.7077769320, -1627.07753864518, 16055.0302473087, 1912.4528173136, 4951.01950414273, 7253.76006103736, -3562.12895566958, 10126.1404582128, 2381.899405811, 301.773505895726, -19419.4625085341, 5552.21570786584, 1564.45451156676, -6604.29767410231, 8039.9084211747, -13388.1754414066, -14520.5933548617, 12091.5619279671, 2992.89150744123, -7017.63386698544, 22121.7114164984, -3260.24355158824, 1361.91266690698, 473.022133225127, -7516.73003415633, -1868.58373128704, -5808.48448252714, 17706.1541774460, -19051.616042329, 7082.39490584184, 13328.4897977479, 1004.81450473917, -4330.00442263822, 10732.0256518382, 5810.94435300529, -369.190533110403,
5751.67600554383, 555.364899015684, -26204.9225780051, -6037.97895848485, -3416.74519426252, -8533.96692846126, 8841.94283189786, -14726.2080871776, -5492.84354038682, 530.717920466712, 3732.53242952378, 97.6697365780837, -6999.08784653104, 17965.9363950697, 2927.12627107304, 1003.62201722129, 10367.7027180710, -7164.85489271599, -5875.73266663738, 18855.7858708005, -11285.1004148661, 8865.13910679787, -15086.6616325901, 2468.41919279055, -15255.6490486945, -23904.7954170811, 4038.30782158241, -21758.1012292259, -25464.7553102106, 14090.5566765765, -5387.26776466178, 13212.2956670508, -7995.60877665762, -787.250278599146, -380.672725669178, 17906.1267526626, 23997.8416261082, -560.537121597083, -2002.53318840309, -15736.6839730771, -1170.27396595841, 26373.7907473165, -3038.61217665862, 24157.3928387221, 270.973568296916, 14175.0594192408, -5618.09637871757, -8155.27400198152, -2709.26383403776, 11085.7539500926,
-12478.4673069310, 4482.02940489219, 8581.9315920528, -4852.28680884133, 13595.9767546739, 11381.0817766081, 4447.20808073019, 725.036643920251, -11754.4439397823, 5832.8011337391, -7141.30192171884, -21221.2126854112, 6808.62465190517, 1356.67654450099, 7526.69729539175, -18391.1392915166, 12991.1254470229, 17918.3874546027, -6856.08222516611, -1875.83154843294, 3582.17379034696, -3671.67097583703, -3996.05993934718, -3088.33021833657, 10433.2265154945, 10070.6163034205, -25399.1251677093, 6035.1361287189, -15645.8958446292, 7167.29470616541, -5945.51436063992, -5512.0792007627, -727.235198502752, 5685.08393409605, 8444.50447764814, 7413.50112077509, -4119.72120951146, 13714.9462777284, -4259.05281193508, -6016.25420422955, 7091.740266387, -9575.48401478197, -5996.07742071292, 132.970811459650, -14390.4010676539, 20471.8861027185, 11925.4054096808, -982.014007132522, 12890.5040565101, -4206.37848466183,
-22129.7127065242, -13979.1508378578, 3583.98321140996, 12295.1797316585, 4357.93375799366, 8425.34332321918, 4376.58280219881, 3586.20687425877, 17723.7429273968, 13094.1700964668, -14446.8721954365, 14204.1760466729, 3854.89580432167, -6158.14553956297, 10782.1940679317, -20044.8268518234, -7627.50993490719, 11444.3685176607, -5493.94612956247, 936.577517513047, -6265.2134788742, 9498.28535118705, -2022.42220737226, -8648.3189646463, -11172.4230565974, 7864.61889210125, -3590.93882743538, 7966.77140286637, -7966.33415188534, -13304.4821666574, 3070.22937108839, -6039.89990325968, 10034.3887595915, 14878.6870295447, 9150.53418384473, 2027.06290946039, -69.6874912947051, -4372.18513797857, -3304.73854077133, 6467.80715780918, -1442.31435115737, 9881.05036272721, -12661.7552073274, -2577.71305664217, -16186.9492813662, -5911.8992058015, -3874.76257566144, -12644.6205418113, 4878.00028030418, 11493.3517852573,
6252.18125314295, -10798.9024827298, 14153.1649155778, -3916.34929737669, 9609.93031578474, 7128.69178733727, 8695.26168101816, 8130.24652676019, 6272.03183012953, -164.366443634124, 24610.2008580558, -1150.42502288010, 4627.65317375373, 2851.4961204206, 6853.08715340243, 16253.9795824004, 5974.72669354246, -1970.29419698169, -7363.59071323533, -10609.4308020301, -9690.3668490724, -8429.13174598708, 7654.631058448, -10254.1174537611, -10678.7025811818, -3629.30062652774, 891.967984511137, -96.5738238917764, -1380.38746319238, 8146.40846965223, -10879.9579168545, 6913.9648286013, 1559.27541523832, 2107.19216990900, -18322.9766002857, 20908.3055327280, 7634.18788545303, -8702.70620937747, 4981.31835804516, -4965.33119747722, 9554.7969475303, -9473.85005944196, 7486.06941819753, -5588.98250362027, 9822.13087373358, -1508.00407592458, 5557.72996465207, 12520.0630155174, 4478.64377092929, -1513.88002250606};

double yy0[100] = {
71043200.4687874, 74466502.1571648, 34943440.1365317, 135794322.831266, -8982557.01490107, -66051625.8324929, 12436670.5589970, 46205561.1086465, -19205538.6316236, 62758931.9112128, 128000583.810878, 25103579.2540299, -1682872.15766174, 6332945.22139147, -15836271.8896985, 25243992.2241364, -48541985.3091064, -59350041.2040099, -86939022.9698905, 23403142.1524314, 120995918.311852, 150494865.60286, 8369268.02337636, 139539257.893322, 60966020.1122705, -95624184.8902574, -29144172.3057557, -56449642.4066433, -28407679.1754271, -90782623.8188788, -3362834.7911189, 119897672.679302, -83939064.5623876, -55007988.5331562, 24810459.4554853, -73260564.8550074, -37717243.1087808, -38153796.5290577, -65282689.2567997, -106916109.00811, -14728856.5172521, -90318637.413663, -52467490.8815354, -31120754.5451565, 30245584.4058181, -17560951.5292323, 52871653.6739315, 4107274.61234340, 31170891.4360145, 40096199.569235, 220577571.207051, -165633301.186643, 154983900.197497, 97787355.3972883, -33535480.3574666, 107869778.856191, 229210433.232572, 63950973.212795, 37238009.2621509, -141767464.953135, -98011118.660399, 22169800.0571857, -167734012.940163, 90882688.2153475, -68285145.5970884, 69928949.7555077, 166380566.474027, -100046083.18253, 32490590.5790392, -106916828.705643, -44107170.7180099, -133102708.013713, -67394379.5794713, -20822487.9877982, -72640310.855137, 92310619.7114513, -141452097.909215, 25889473.9092541, 49558662.6958374, -119941003.603929, 21607032.5543412, 142022636.311363, 15856008.0580097, -83538649.207385, 22302558.7058920, 7113330.41468328, -82015565.3825126, -33730491.2915456, 72521270.8016128, 104323994.58586, -19370732.3755744, 58271264.6633394, -108717395.055140, -41777433.6025353, 138126551.025356, -70949289.0961138, 213786384.183232, 74330768.1224643, -75262198.2466316, -42611951.2606567};

double lars0[2500] = {
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 102.55880487827970000, 235.96097283412280000, 264.24319006968642000, 312.41461343302922000, 388.33259219337322000, 414.61140553246582000, 434.95908327549523000, 474.94064473504289000, 483.51581293381389000, 768.62247318362040000, 784.24082748408330000, 819.78986666540095000, 855.75752880742175000, 871.95034678628917000, 994.42437015050848000, 1028.85201926607560000, 1066.69551999943700000, 1069.61197539617140000, 1164.77706263853180000, 1167.03155480825420000, 1176.70827375619480000, 1228.55922897373920000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 104.86097902724276000, 260.79474009237180000, 275.60673890053454000, 341.56290166173665000, 348.59436019009257000, 428.34248173123177000, 526.65636168686672000, 552.74684843464490000, 578.47714214642792000, 823.02808048284703000, 857.92838821000271000, 879.08059230687456000, 900.56122838253543000, 926.97185475790320000, 950.16285310519856000, 956.18636353583599000, 957.18559463859810000, 1005.99019446000470000, 1050.02049357885450000, 1063.62021886458770000, 1115.20667947688840000, 1129.87916565402820000, 1163.89604565090890000, 1176.44082209313840000, 1212.56009503628570000, 1260.38875250443490000, 1269.53043320710530000, 1284.71441722900770000, 1309.83030190338950000, 1319.59245463943260000, 1327.52843269986280000, 1343.75950942512260000, 1346.79199529219410000, 1441.16022032088990000, 1444.11342842517710000, 1448.44098219921310000, 1457.25019193967250000, 1462.14013152138890000, 1526.04795030337780000, 1543.44147172878210000, 1560.92468926665670000, 1562.89947820659880000, 1633.98985220629360000, 1635.44906647601240000, 1645.19031432604790000, 1683.50097102175980000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 4.06641266360061590, 128.64115765971923000, 131.21108632665340000, 143.28327366811956000, 206.02172578157709000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -55.59418890659734600, -112.06027882712141000, -125.62369490770651000, -127.49839886249895000, -201.56715209874642000, -269.21834815741795000, -285.97337212221788000, -359.06653064926422000, -381.22126878088028000, -428.15594856808514000, -447.45335702893431000, -482.56062214854688000, -510.27358489571674000, -513.64591525996252000, -512.25510996611365000, -509.58251684108478000, -506.15411618695379000, -500.48052212469054000, -481.64931564350405000, -478.88048949181575000, -392.25892032173670000, -391.17972642527792000, -378.37541360442594000, -367.55866891383437000, -360.88514256378824000, -294.74633562625058000, -280.69308208469744000, -266.42953940393500000, -265.55630747185165000, -250.47984247907038000, -250.46408626554307000, -250.08961387637163000, -243.65964023715190000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 25.40337833776978400, 53.84065437336426600, 96.77270772445157800, 129.14976179932103000, 138.37554467146560000, 139.38576898485945000, 180.89346056466692000, 222.49135961579572000, 235.16597084185406000, 282.17421180448594000, 288.22652657547235000, 303.55943871892032000, 306.10686904153107000, 341.16766940550667000, 396.33163719014044000, 409.31625491772866000, 440.08876646862666000, 495.54939997591168000, 509.80140588571300000, 516.88156069806973000, 537.07572435874897000, 541.34422273154678000, 687.67272321500445000, 698.94585852604359000, 734.21920398756902000, 763.36833741390080000, 776.84183772918539000, 895.17395981733512000, 928.05376546046034000, 964.14224015778689000, 967.30903043258934000, 1137.99885218015150000, 1140.78249507964670000, 1153.67302974362180000, 1233.17130061972600000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 15.23195944137116900, 26.58414143633723400, 46.55692670727612600, 51.14819470109880200, 206.82620845361950000, 212.13912652256931000, 224.75249789672245000, 245.68498879247934000, 253.32025553614085000, 343.04062022200873000, 357.76506468616026000, 379.58370744617093000, 380.60359767993901000, 429.30312612074829000, 429.57215744679797000, 430.58903203826151000, 443.16689235617730000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1.51871474881506340, 72.67696892248271500, 110.59674680810579000, 123.79798729752423000, 174.08503750273675000, 192.65335337306789000, 230.41212018974176000, 248.45460835711000000, 303.56970294668946000, 370.98829616184537000, 386.44354853429263000, 416.04138500913461000, 464.55551898836279000, 482.79518322877306000, 495.82524578164885000, 515.64812330296388000, 518.82759680420440000, 615.37112746099751000, 622.45209140728264000, 640.11505417055571000, 665.09120644010454000, 674.32553404194027000, 757.19888607971086000, 778.62597584370485000, 801.80633275680384000, 803.67025237200369000, 850.22984181757613000, 851.23903685284392000, 855.86705699368110000, 863.30766192117812000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 53.16892259155555700, 72.24111818241250700, 111.41644765332559000, 124.28438795187202000, 165.01545352531795000, 211.89477661624340000, 219.96010731537359000, 225.51348075340655000, 237.34301796855971000, 242.42069757803711000, 246.76308430723211000, 251.69835478692514000, 251.96355232594880000, 261.88738209013434000, 262.52175200244460000, 264.52011164816656000, 262.98370077647769000, 262.89839894358016000, 256.59480052707016000, 250.61855577004130000, 250.28578360613963000, 249.77970024637096000, 276.58789608805114000, 276.86274233211731000, 279.68341667794658000, 296.28788119283314000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -4.03450479444792260, -4.71822545941632490, -45.06399919639462600, -87.06442150831863100, -98.71366597693787500, -139.98862652815669000, -153.95713449164154000, -188.26462510407376000, -200.46070796353700000, -266.18118938227821000, -316.76650287678711000, -327.01202728780748000, -362.77217697499475000, -424.99924675900667000, -444.82165921529838000, -458.01946651044881000, -495.31790002160210000, -500.47342907429919000, -684.71500299806883000, -696.50791867124406000, -729.62233818128493000, -761.22151584158451000, -769.65229236673520000, -835.59034131610429000, -852.47434638814514000, -866.62215237634416000, -867.70954974414155000, -886.25831180848979000, -887.54226179074772000, -893.00103002838625000, -931.90068378039496000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -34.00838844359564900, -93.62564000319503100, -158.48365111350512000, -174.84836637178378000, -177.23612651013775000, -271.88471020611121000, -381.37831432729575000, -410.18886123398579000, -530.69756913419155000, -564.00422741853379000, -635.51326052047273000, -668.81123801148794000, -765.39595157930955000, -901.94829709310034000, -930.90945120098968000, -981.08389629369901000, -1067.77118813348330000, -1099.72985773391000000, -1124.21051437705890000, -1167.64166326787540000, -1174.83445118344180000, -1395.24912020259670000, -1404.26936176773870000, -1430.57153848695520000, -1456.20398217626940000, -1466.61728765232620000, -1582.43740554790770000, -1608.23422500701920000, -1634.43617966530270000, -1636.39864613158620000, -1740.84548095298350000, -1742.43294804775380000, -1751.29378810249200000, -1801.47676330379520000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 6.63928441157022940, 213.66035146401902000, 227.85290113257062000, 259.32352868777787000, 287.83106361302509000, 303.50592918874918000, 425.81627563199970000, 453.62364117359738000, 484.76558935998867000, 486.50211967681173000, 520.87211050500184000, 521.30358202742286000, 522.98270246921618000, 537.98423381811074000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -25.77578633655108600, -27.43415352313963500, -109.49440381710716000, -111.68943991827855000, -121.35300813675399000, -175.84533955645708000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 180.53184546622649000, 206.47280589217624000, 226.99493898097168000, 248.21854952173814000, 291.98783948612169000, 335.45919032525410000, 347.01416451998290000, 348.81805241535693000, 423.66866418387480000, 500.91444773654041000, 521.21465793705806000, 599.26289634650618000, 622.81035416783243000, 673.61370041906218000, 696.10103901759794000, 764.58689910063117000, 865.20048271770054000, 887.45205558922100000, 924.36991907944991000, 988.33955559110211000, 1005.35873668263230000, 1018.24219881875760000, 1043.92189101701800000, 1047.16216143773590000, 1146.43323864716830000, 1154.83067410522970000, 1177.32426604812600000, 1204.29845320450480000, 1217.31678546193330000, 1337.67497429298240000, 1372.12038684005850000, 1404.81044662342520000, 1407.82981209455510000, 1538.61835656873700000, 1541.82393867861110000, 1556.37775716016040000, 1638.45153728738730000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 4.91168079897419310, 44.35749946087132400, 100.37839838266956000, 117.23234477539086000, 135.14098531920791000, 334.02531142665686000, 357.78793707180779000, 373.40492047279150000, 385.48408447552862000, 402.77155323406527000, 417.72944172488241000, 421.17173008653344000, 421.74994994196169000, 436.66446146759245000, 446.27292115923859000, 448.79151790061979000, 460.48072958958704000, 462.15539351231331000, 465.50441553235055000, 463.00147879055174000, 448.57062483618671000, 420.28944146214093000, 414.35227557314738000, 407.80294953202821000, 394.60217801973147000, 391.34070100089195000, 391.87773793882394000, 400.06495373621328000, 400.97639526171849000, 418.98449809435760000, 421.28924650071627000, 421.68799557131553000, 418.72630211431527000, 417.66328088791266000, 404.99756300781968000, 393.26501963630784000, 375.92342531451266000, 374.82115359708610000, 339.49576874564974000, 338.71164562305751000, 334.63705072819124000, 292.95350803775182000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 21.78657257339212400, 59.64867943956332400, 65.26130962594493200, 243.06136650454042000, 252.57711107490189000, 272.38052296756138000, 292.33405342134625000, 305.22479484611875000, 434.54379646091644000, 466.64029303757513000, 503.75587958058304000, 506.83734544818338000, 604.55723990248271000, 606.67839015526511000, 617.97771458494913000, 675.11249830087468000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -101.47573482470388000, -127.10817288571036000, -155.06926000136787000, -449.08523239460095000, -487.81129674570877000, -508.98867437047443000, -528.66789825363310000, -559.77089010761313000, -599.83211658546736000, -609.72752653017483000, -611.08752605849429000, -658.60284681749147000, -721.61565757924222000, -737.79453318734261000, -803.51462250269856000, -825.48946989485603000, -875.78002492983376000, -892.35258027178600000, -950.57758473387844000, -1018.11152766197530000, -1032.33470027234580000, -1060.36137755710370000, -1096.42461603843620000, -1109.78349421638630000, -1119.60974129074770000, -1141.28958525865260000, -1143.97337726726980000, -1218.64003175920970000, -1219.27538861291780000, -1218.79080511043680000, -1216.68826352502200000, -1212.83026106179820000, -1181.88459056523930000, -1180.19900451330950000, -1174.74824727829170000, -1173.68097223623480000, -1125.67736301068130000, -1123.55830864212360000, -1114.42983528606120000, -1050.21641075949150000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -56.62849111949727600, -121.91808370284191000, -138.18221296904022000, -199.97756692474766000, -214.57253517895907000, -244.44017771104583000, -259.26567932810718000, -305.46412011560113000, -363.28562533266768000, -376.33504821115486000, -401.29998187450093000, -448.14933511347709000, -464.29472354008317000, -478.16867792088067000, -497.56149319321071000, -501.49485134372270000, -630.73560005878710000, -639.47038082041524000, -660.71497002322201000, -687.91119664211908000, -699.98215953445890000, -772.71812036797644000, -793.67648581484605000, -817.34262639575900000, -819.15031347389925000, -843.13712433670264000, -843.90068944133952000, -847.83691088346518000, -866.91927957248413000,
-22.17288470348218600, -778.32629818663145000, -1192.89078499792000000, -1367.79620805705760000, -1444.52567898733880000, -1544.27942162885120000, -1554.29011544399690000, -1599.32715059251810000, -1603.53292958236120000, -1646.06768549352640000, -1712.04196284820770000, -1728.48738970539580000, -1742.25844931773370000, -1881.96626626389660000, -1898.69318067471500000, -1910.06043770187400000, -1921.33076586031050000, -1935.46329073744890000, -1951.96794943498280000, -1955.81620898296050000, -1956.18190162927730000, -1970.94733720982710000, -2002.93091048738780000, -2011.76672486299570000, -2048.54971616383680000, -2056.26733139795670000, -2075.19562401201980000, -2080.54123072086030000, -2078.62551968341130000, -2043.21943077407650000, -2035.93636723983830000, -2022.39544274020320000, -2004.84268817783690000, -2000.11412258893070000, -1994.83424990865210000, -1989.06998196968680000, -1988.00422871309520000, -1963.63169204707810000, -1965.01381840300910000, -1969.28890879841470000, -1976.75603049257730000, -1977.40519854233000000, -2010.12528095543260000, -2021.08114595025900000, -2042.65933325041780000, -2043.80015455316990000, -2097.31520359468780000, -2097.34524276183170000, -2098.48142291345630000, -2117.69048175234550000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -6.57988211739865840, -40.76477496462017300,
0.00000000000000000, 0.00000000000000000, 465.61849855319929000, 678.55954006253239000, 780.66425855304078000, 895.99472089040250000, 909.77118282340109000, 971.06358802947625000, 976.79314144821944000, 1032.94170396963450000, 1094.47505903944170000, 1110.92915067443140000, 1129.17195906511710000, 1315.47343754905110000, 1343.67163060345430000, 1359.37858797050540000, 1374.17450713936710000, 1401.76923986370500000, 1438.46366069482770000, 1447.24101956966160000, 1448.61758103161450000, 1502.43976844811660000, 1556.15953544433300000, 1571.24825853670000000, 1626.27643353512330000, 1639.55819483739010000, 1667.10833450861900000, 1680.56246590439420000, 1724.40650027416720000, 1796.63361286643730000, 1813.11165551549650000, 1832.27525734892900000, 1862.73875752702570000, 1876.05515913159370000, 1880.84533175978710000, 1885.41067394990360000, 1886.62604721353730000, 1921.58112965566010000, 1922.55731029630810000, 1920.20308003917720000, 1922.51729545108220000, 1919.97208432013370000, 1870.54280743300960000, 1858.58211650080740000, 1850.57138036306260000, 1850.27838960308740000, 1829.33565078718950000, 1829.63381718392590000, 1830.07009389646960000, 1826.20099763662280000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -44.83713720113890100, -86.47953447988405200, -101.55083220540395000, -230.17212569684358000, -260.14149979061250000, -292.09613505790139000, -294.11955362236608000, -369.50163927631075000, -371.04244538211128000, -379.04489298073008000, -438.24852458983872000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 172.02965545429316000, 218.48503327192034000, 276.41591520937146000, 280.65273650289265000, 458.95020530832375000, 462.41408352186170000, 480.31208888180430000, 572.38935930861555000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 17.89772150703757700, 28.03678893424504900, 59.64896134645639600, 71.71085644693874900, 74.87656096640330400, 82.02927788817353900, 94.77388266226219600, 98.85178853582921500, 101.25739858621358000, 113.54302115480317000, 116.07363261474035000, 204.89615227828298000, 210.14508662694041000, 218.30749242857030000, 225.16968486358581000, 226.62713733799109000, 213.76202786053059000, 209.56941481821610000, 203.56595910428229000, 203.81183961657018000, 188.53803309728301000, 188.27876468906166000, 187.71889002819600000, 174.33070331815665000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 44.94080671125541900, 132.24225672087010000, 163.35500529340428000, 191.21715452329062000, 249.93054500392438000, 259.46082818537559000, 565.49556545497762000, 582.18893217158382000, 626.30723159182673000, 672.01760637769246000, 691.58740058619048000, 860.44075758306190000, 903.39638816216495000, 946.16331140351667000, 948.97589469438685000, 1009.24324860652150000, 1010.26212018213140000, 1014.54987744180230000, 1045.48443318462110000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 43.01657331911651000, 91.42476097582732600, 94.03998231516268900, 203.43390922283385000, 205.33520003592730000, 215.52427844898077000, 246.87555702046077000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -25.78817695897400200, -305.52390406906221000, -351.15180618241271000, -380.85430870618524000, -401.99904966551793000, -438.52682543808044000, -480.77099014789786000, -490.72483932302754000, -492.20093008585280000, -547.88515465664443000, -606.79844784400916000, -624.37641268811285000, -689.37838384501651000, -703.07777177943592000, -732.59313557628946000, -743.37402311790277000, -785.63806056822864000, -848.07754586870487000, -861.97302337366807000, -882.21439237188895000, -911.57859550423018000, -922.45353098554438000, -929.15633361288167000, -935.64066815015519000, -938.85130550837914000, -1033.99842367323750000, -1040.04522543419600000, -1048.95520015325060000, -1057.38775576841840000, -1061.92136457670360000, -1100.04902808243920000, -1109.75307635475770000, -1120.96852408893940000, -1122.39744668086750000, -1150.32780548413510000, -1150.55990700943580000, -1150.86022454886260000, -1149.49586913534400000,
0.00000000000000000, -710.77181256316487000, -1158.28715328331260000, -1353.48186365661350000, -1440.24263573404300000, -1568.34693070917910000, -1580.56167130278980000, -1635.76948318674640000, -1642.04719647752900000, -1711.74586424011980000, -1789.71269021599890000, -1811.89942463169520000, -1834.19357562044680000, -2071.44328620751230000, -2107.37030335824510000, -2129.32226911017140000, -2151.53343715934030000, -2186.82403998920200000, -2220.46176344815600000, -2228.46698513230690000, -2229.46969108796930000, -2272.40311798401440000, -2332.15777116117530000, -2350.00375863130920000, -2423.52340268302710000, -2442.54583260697650000, -2486.65999462308670000, -2507.82149503035180000, -2582.52099620848280000, -2683.61986776048070000, -2705.95576356873020000, -2739.24333338456060000, -2795.97719214444760000, -2815.31665680880360000, -2830.56224798848830000, -2864.31945455198460000, -2871.46925670510340000, -3096.95030771069240000, -3114.65526723942730000, -3151.89011274187990000, -3187.63172989251370000, -3207.31077280495040000, -3384.50073035314060000, -3431.07311643076130000, -3487.53173661536130000, -3491.53191213303940000, -3622.86315021063500000, -3625.71709740147430000, -3639.67345293461450000, -3699.17166685979240000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -40.48513257437959800, -130.63795716425227000, -169.92394577298981000, -290.95246595531552000, -425.24838828414960000, -452.70658139954031000, -500.52890987088432000, -573.17420522639020000, -596.26921138208388000, -611.84155207818321000, -636.15541367774802000, -639.96191560213538000, -757.01487883791287000, -762.92112943316067000, -783.81842990152086000, -807.12055330440489000, -816.23000386748254000, -920.99114841044877000, -944.03748041709082000, -970.25590167055850000, -972.18921491217316000, -1061.07194995242750000, -1063.97469944805130000, -1077.37841964523910000, -1144.98522319931520000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -28.78393637480098400, -41.99859334241904200, -174.50963538348637000, -208.94285607983855000, -244.99153133220767000, -247.42077070019275000, -309.21474394554758000, -310.02420339047842000, -313.85760046817796000, -327.74073905680768000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -22.85740654866574300, -69.86671701299870600, -125.45982928652626000, -153.09229856627846000, -412.63343981940574000, -478.62230114260376000, -558.73795883447804000, -564.65703086377835000, -783.09025327850225000, -787.51028112572976000, -810.12934872922915000, -931.37919706532944000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -11.75040987403866300, -33.96709302975742900, -72.55309465183548000, -87.53325264069658800, -96.56861663540513500, -118.56187609493490000, -121.82006420271871000, -217.50127365808353000, -222.62040734087768000, -237.23461302803460000, -251.82221895163619000, -254.81844626737612000, -259.47153872023046000, -263.78791833334162000, -268.24250971103913000, -268.05075949988520000, -250.60777628929927000, -249.58796757157654000, -243.95251604920284000, -200.36244079037655000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -79.63482720037622200,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -24.46265064384541100, -50.16569612229420000, -334.23118950251944000, -376.22356425450812000, -402.47034251024348000, -425.22853707411485000, -458.82165295013095000, -493.65985590747010000, -502.07305378723510000, -503.03906012010299000, -548.14470826953948000, -608.09065083188909000, -623.88018130660669000, -680.59583901156054000, -696.68729110935146000, -730.87531117888943000, -749.20812131480284000, -807.07429137483848000, -876.71693908208988000, -891.97972423122246000, -917.58156255208360000, -964.16700680026713000, -981.31193056794939000, -993.21817184845202000, -1007.13805270728820000, -1010.38780229642580000, -1106.14218956120820000, -1109.07162435239870000, -1122.74976146375370000, -1140.85551603255480000, -1151.73023011160350000, -1210.07106236185840000, -1216.10067560746320000, -1225.26191226554670000, -1225.75928322792630000, -1260.19838439973570000, -1261.47748541918080000, -1267.22085536849290000, -1308.84664026230260000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 80.04048809215778700, 184.43407544595041000, 210.45047388799674000, 240.80000666280816000, 518.30285569894147000, 568.71636072264062000, 596.71190246845219000, 618.83633832082887000, 650.17872856076258000, 677.70334200500008000, 684.51219525570014000, 685.34779676115181000, 720.06523334478129000, 746.80510409792635000, 752.87689956332247000, 767.01397954875335000, 780.47642336345564000, 809.62634663694280000, 821.25016327581022000, 867.14325139347250000, 887.03102394117798000, 890.93001103982681000, 895.35769718630377000, 890.89690215591349000, 890.59288673579715000, 887.27014358879092000, 880.83620766083698000, 879.76630212350608000, 842.58420529039483000, 840.38122253128631000, 839.74710561159793000, 834.75611312477008000, 834.49493100965844000, 850.10203959864282000, 846.50964144737986000, 844.18681844850414000, 843.63712538166112000, 804.18636433378185000, 803.71655206953744000, 800.68761175858447000, 777.59083920408295000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -15.91789294680389200, -92.72980766698069000, -100.75330642636234000, -186.76737268879467000, -288.51047688545862000, -315.52843831208122000, -342.06366593104116000, -609.76392965626997000, -653.46064421924302000, -676.98374236411348000, -694.91580695228515000, -723.61488201253792000, -758.99937051324309000, -767.23724677895711000, -768.17394171434569000, -801.81630974482005000, -844.92654546954884000, -856.77533220409168000, -896.17067643492908000, -907.03464387437884000, -927.66966389454581000, -937.33954397120999000, -958.11217526460337000, -971.35152091720670000, -973.32135521110320000, -964.66775248587612000, -948.06997471698446000, -943.98920374169677000, -940.19479255441399000, -926.66267245850418000, -924.29597608219592000, -841.56485185354484000, -833.60004290307836000, -811.46114879605841000, -794.14615065377780000, -794.35041850695620000, -815.61997992685826000, -817.20896016085953000, -823.61255956846492000, -823.33923114078243000, -826.86775729530257000, -826.85811308363918000, -827.30754597143039000, -825.84762429908847000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -25.89966584915783400, -231.77015378738295000, -274.35295829550313000, -323.32066489073128000, -326.66205771755642000, -451.10342840417542000, -453.82054298047387000, -467.71574218760861000, -549.87574828251252000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 107.48394421888969000, 136.78443604851236000, 266.13804557306588000, 302.09167667098211000, 379.45354281361654000, 409.45684010273010000, 505.22215164737906000, 615.38284148046807000, 638.23981004105224000, 674.11574347503915000, 735.26876873302967000, 756.47428252258464000, 771.76079980720419000, 800.18138141737518000, 805.20391381115542000, 952.88751499064347000, 960.33712260322295000, 968.43276303338268000, 975.30459217393661000, 984.53113974748271000, 1064.45512756246900000, 1088.35785241123490000, 1115.21768812080950000, 1116.43895307390040000, 1218.70268041363370000, 1219.46264308165380000, 1224.36987593312780000, 1261.69309798778800000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 59.70897134237968400, 66.38605894481136700, 144.32228169557351000, 242.18976312282911000, 268.89437690529661000, 296.92797314851987000, 573.14416743629522000, 616.39791850410484000, 644.04901614487528000, 665.01757587999771000, 697.77621789040450000, 742.05484598879980000, 752.38198781524363000, 753.79939771771501000, 803.82691928313238000, 873.92542388672518000, 889.99495948126298000, 955.34432707928499000, 972.73911598309269000, 1008.49311032047790000, 1025.76263349212100000, 1073.77642078066580000, 1131.24174445122840000, 1144.08459984742310000, 1154.61568527059130000, 1175.46866322909480000, 1186.08294120243430000, 1194.64980193261910000, 1208.57601765515620000, 1211.20037246379390000, 1281.87577900533600000, 1282.89188864690070000, 1289.05718089010360000, 1293.81397682888560000, 1294.01938531969520000, 1315.84433255657900000, 1303.94885585903150000, 1292.76887131878020000, 1291.79365002225270000, 1285.33079991632670000, 1284.23979139659040000, 1278.36234128867200000, 1262.28713053323420000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 206.11524969721657000, 315.08254832002370000, 490.93820323296507000, 505.92596408680396000, 570.76965883556886000, 577.90511322833595000, 657.05795131074535000, 749.41059827969946000, 773.34947232093396000, 799.07444175358137000, 1049.47092061501420000, 1088.32807575648530000, 1111.34787240105310000, 1130.81290728904810000, 1163.00904218628880000, 1189.37418272177800000, 1196.77064064368760000, 1197.97445795806270000, 1251.11133991149130000, 1269.57634561249820000, 1273.20673334660390000, 1288.20497617156300000, 1305.98294996580130000, 1347.36111711083480000, 1365.10655503079670000, 1419.51621735529720000, 1450.49930186176330000, 1456.23785642050510000, 1479.33599951364640000, 1519.14084592949190000, 1532.62254768526370000, 1544.22955211684050000, 1563.70123066035030000, 1567.80868404065790000, 1713.98282318745240000, 1716.16507942881070000, 1725.46205596139480000, 1737.75824612768160000, 1741.24767279416660000, 1771.36301087525750000, 1768.41646055881730000, 1759.11290681686610000, 1758.13830160570840000, 1699.83685771631080000, 1699.56326606220820000, 1697.37687314850400000, 1685.10405054198400000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -21.37705248186028200, -73.97366990329734900, -145.95023874769669000, -161.77589003641970000, -185.07400686158789000, -239.16904156025402000, -260.71007557131207000, -275.09157584836697000, -290.92210324424644000, -294.00566504662066000, -388.12208127428767000, -395.34951030456244000, -411.02763015331664000, -432.03212389896669000, -444.91435749478421000, -537.45776769376891000, -552.66845450936023000, -571.41920613351874000, -572.90838857053336000, -614.12488336518879000, -615.32021666629782000, -621.00410260780245000, -671.26723925570150000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 4.17679411313471590, 24.41644762308412100, 133.47271107504082000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 57.66845745036796000, 60.28476421434680100, 69.91553104128219300, 82.39924329728619100, 93.06473549282915800, 160.57506641336940000, 174.97802324213473000, 195.86563044431767000, 197.69832048499660000, 282.71942850367435000, 285.41252177062711000, 297.84334321957891000, 372.54557647634198000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -34.59383139175611200, -54.50120561194716400, -74.65260262985191300, -101.46306527023867000, -132.23574970968244000, -140.09316749960445000, -140.81529687085037000, -177.09931480812855000, -233.01142385935782000, -247.87956330512711000, -298.97643718326742000, -321.05825282704785000, -366.99924319060108000, -395.90195177952035000, -495.20776905028197000, -626.14725004897969000, -653.92589569134429000, -694.69925834320691000, -762.07869703825702000, -786.42551746173876000, -805.57321056630371000, -823.63453638682233000, -828.31406381955492000, -975.98585056290381000, -982.60275764869868000, -998.21957226096367000, -1015.23136022709050000, -1028.15357346000380000, -1119.68421937327300000, -1141.83157860619870000, -1163.42942536265900000, -1164.99945950663800000, -1210.12149208338020000, -1211.80990419249040000, -1218.80552611667510000, -1270.09797024264750000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 125.54661711429884000, 134.64668537872009000, 180.19936205533190000, 184.93184313922765000, 251.06270909263210000, 342.06245685537260000, 366.94057297435404000, 390.15162020708721000, 650.63326407324041000, 686.69716218259828000, 709.70834217775030000, 735.45154237786062000, 773.42353417253219000, 808.80355830284043000, 818.27668848973826000, 819.52251733342007000, 869.32510290330822000, 915.20280344271202000, 927.70168874152159000, 983.61106798062042000, 1002.00078803925610000, 1044.84356189425470000, 1062.79936742147150000, 1126.47490860112860000, 1188.32634817040090000, 1200.76306610900680000, 1227.60332784465800000, 1276.01199239699440000, 1292.21589099192350000, 1305.85671125207680000, 1341.73495507339110000, 1347.41419303765930000, 1525.15417089372230000, 1533.13597094514720000, 1552.88134126054070000, 1565.05045936904680000, 1569.01872032330060000, 1636.46790345860380000, 1655.70680075698170000, 1673.83431036043070000, 1675.02684076988070000, 1740.85517537280820000, 1740.93342973677640000, 1741.96498847887410000, 1738.47133502968180000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 41.46836725346273100, 47.65043087530159500, 239.52204896608109000, 250.35775163753635000, 274.73425327926151000, 300.87649026940829000, 308.75580578513166000, 424.40439824153930000, 460.56643576992013000, 494.63879655268704000, 497.60529736712300000, 586.86323913926867000, 587.98007707642853000, 595.01859402835123000, 613.61756163939594000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 57.47326640718755900, 71.71894148140411600, 73.70681154822824500, 154.41782999220391000, 252.68149959819849000, 275.94721374756779000, 371.67538059638707000, 393.77876293527441000, 442.19898878651929000, 463.41018027962161000, 522.85614045240504000, 617.90966475610776000, 635.25947626412676000, 654.95450153455261000, 694.70767913979569000, 709.47670658996901000, 724.24760110790396000, 747.77734588426381000, 752.57318588090550000, 890.84054149483688000, 902.61750517997154000, 920.40321024004277000, 940.22784349427616000, 952.60832028522191000, 1039.61079171976460000, 1054.06651987104440000, 1070.16392318691810000, 1071.48720076069750000, 1125.65669615704950000, 1126.55375906253220000, 1131.50273470429970000, 1169.10470030660740000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -183.11007200429935000, -186.76305626191976000, -205.38888587054112000, -314.54695297310809000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -18.42457195396903600, -87.90537536875460500, -105.39712920465668000, -143.94896296603397000, -158.89257403366750000, -221.75424298572702000, -307.95572816568381000, -328.86342804894383000, -357.54355149365324000, -403.73457251163825000, -420.42649441341803000, -433.35509047894755000, -467.84421664648863000, -474.87031463659559000, -693.31924691832262000, -706.83443579690947000, -733.70954460543874000, -762.94593706754597000, -776.95350627787934000, -917.74254750336240000, -958.51963031517937000, -1002.46142459199420000, -1005.87054650797020000, -1125.55363706479780000, -1127.17969429738880000, -1135.24093531903580000, -1155.54006424789050000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -150.94618826133609000, -180.53616809857459000, -227.95969928281804000, -304.14535106135492000, -329.59466206852579000, -355.27686879929462000, -398.22279748542650000, -405.87468626165281000, -644.05006746526749000, -660.99526963233529000, -705.39135147997627000, -755.75830864807028000, -782.81817641967882000, -1022.13882639714300000, -1084.75151097842490000, -1155.13371375796560000, -1160.69339985816990000, -1328.72568956247870000, -1332.51950210572180000, -1352.35659693099180000, -1444.73770757897320000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 48.90444923116051300, 62.82822055811576000, 75.65300792965584300, 101.02462995053241000, 106.68382706689096000, 290.12916338574331000, 308.44504011853292000, 345.89119261050411000, 382.58184161555187000, 403.25973234156118000, 556.20991707096846000, 594.68843534370137000, 639.46230534737253000, 642.91356990405291000, 752.91496796925082000, 755.54270195582421000, 769.46806733134508000, 843.58574832186446000};

double larslsq0[2500] = {
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 942.71419325757893000, 1059.20750439148510000, 1052.76073081458890000, 1077.57770853889000000, 1013.25056128139240000, 994.20574896681455000, 1018.38697065877310000, 1062.73292315611270000, 1168.21666976081130000, 1200.84899001711850000, 1223.88196326892600000, 1233.84723543808810000, 1210.52737168923340000, 1209.48598405297320000, 1167.85542410398880000, 1205.05566062765140000, 1198.89015767782480000, 1216.58241200181960000, 1218.14938150420130000, 1235.03383292037890000, 1225.92716579036280000, 1228.55922897373920000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 2128.83781024428940000, 2108.73778041186140000, 2135.32438706946100000, 2044.04719942726750000, 1993.82336055508740000, 2021.69623604157820000, 1980.96791292565040000, 1944.64459830614900000, 1856.21841591627070000, 1725.87012520253530000, 1658.71569621917140000, 1631.22645163549780000, 1726.18590196130570000, 1549.45860790768890000, 1449.25574434015020000, 1462.48153770079220000, 1557.82897155116050000, 1658.74104775607180000, 1556.91298253352760000, 1627.15305429732690000, 1598.32227872442760000, 1591.72595116316070000, 1613.71612555113850000, 1544.47619994572010000, 1508.44694574153050000, 1555.54719687643500000, 1524.40350507081850000, 1525.89940615084220000, 1516.57141776094200000, 1534.90234829949960000, 1555.07631175465370000, 1582.38204494616430000, 1588.92668272575860000, 1584.22404481441340000, 1527.24329858949610000, 1498.84615685837640000, 1544.14051979015720000, 1564.06981881018010000, 1616.54551103319390000, 1632.46299628797780000, 1621.99693583697220000, 1662.41603279964150000, 1673.86012626728870000, 1679.46336642668300000, 1694.73742102495860000, 1683.50097102175980000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 208.98723718823405000, 198.50756776040512000, 208.72787981310128000, 204.68628522322331000, 206.02172578157709000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1365.92457087512750000, -1327.26557758709350000, -1265.67187542775760000, -1254.39337941808570000, -1192.22053424839310000, -1048.04301746928150000, -980.25255528574894000, -1043.59585604882700000, -1078.58737745204580000, -1048.79374409513410000, -1013.59569102512740000, -770.15716733556906000, -681.29479699728984000, -607.66759762122672000, -490.16332174337123000, -487.58309726796983000, -430.53876778745223000, -337.80185975249498000, -204.80075448379512000, -257.79822095536053000, -260.93915707162284000, -360.80149186588346000, -229.23720346875990000, -260.86686339082394000, -221.77699151073685000, -201.08955291167194000, -208.76733314125747000, -216.60423730043877000, -221.55108165561077000, -242.02436873046182000, -249.98883138168728000, -248.18492736108050000, -243.65964023715190000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 928.71566400816130000, 1146.84910447973170000, 1108.66216906251910000, 825.93552694433470000, 913.83188360343138000, 746.63722598880190000, 736.04976132764045000, 701.38119246467033000, 760.36478568271309000, 722.41403893500501000, 478.73562558723899000, 506.31324112823592000, 380.84271512477642000, 628.38357818725399000, 736.75747765079893000, 771.33167799410580000, 928.88458229631328000, 952.07296687850430000, 824.13759379970361000, 719.89046504023668000, 833.96191478251035000, 882.17071446592615000, 909.50920371678444000, 1016.27340255893350000, 1145.06543066378210000, 1050.88309010946570000, 1057.69391184424190000, 1062.73981653185640000, 1096.33541205595500000, 1090.20623382983880000, 1126.89472128435640000, 1233.72840865325290000, 1224.74555388221050000, 1219.23841789865720000, 1233.17130061972600000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 351.18158615099878000, 352.08465516363378000, 340.18850417075333000, 417.74684984389626000, 442.83670913028732000, 361.69248465682955000, 371.66671788158482000, 452.15424656324302000, 412.47566810153199000, 470.09039764531343000, 433.12602595599782000, 455.80042943011512000, 431.99945071255081000, 456.61573451389904000, 437.68695300945501000, 435.76118191662351000, 443.16689235617730000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 914.42660239708619000, 1024.40306238277340000, 547.14273849370602000, 670.81877837451282000, 645.03144681094477000, 777.12941922153163000, 729.71280584838792000, 777.78041823961746000, 755.06915007291752000, 787.03942844348330000, 817.34108004004997000, 886.17846181307982000, 863.89905491242121000, 885.08146927492169000, 869.43553997360027000, 807.07581941494334000, 772.69879560706170000, 761.73275206152982000, 821.77418206468440000, 845.84438061418905000, 911.44543378667515000, 866.81300940803965000, 874.55285546655637000, 888.29164681424743000, 882.77978457812139000, 897.59971206835257000, 876.34228836864304000, 881.67940048742616000, 879.40664979050428000, 863.30766192117812000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 551.10453581795309000, 672.57783821030637000, 629.44896075681629000, 501.80066269533296000, 498.68182431205980000, 501.19472374405865000, 444.82418622413456000, 313.72421050646471000, 334.71771751214334000, 354.41184198207384000, 371.27210924907439000, 324.25464758749672000, 273.13876171996770000, 276.93207578078415000, 280.37863393702429000, 287.79600196263641000, 247.82919222380355000, 261.12030148304757000, 247.66850181453671000, 220.03162593577730000, 249.12334633728369000, 224.27638124230103000, 291.62298530129976000, 285.15293334633594000, 294.03026986628549000, 296.28788119283314000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -343.14744086323196000, -415.70652229710123000, -584.67990282176095000, -570.58824553167744000, -581.42428167863397000, -526.53534952364350000, -593.64475275946700000, -641.92757625878767000, -558.26620447234848000, -804.55930968475809000, -628.93672109903355000, -612.66062566081428000, -930.79248664512841000, -937.22065605758792000, -882.01636753944319000, -836.43949682270477000, -1043.66394791769040000, -912.12659761321527000, -964.02834377803572000, -1028.46676279964780000, -1115.32247879066150000, -1072.90247106947250000, -945.38992684045661000, -928.96283787333073000, -938.88812284073811000, -916.04316391889802000, -922.50732449768634000, -896.66118614139077000, -926.27006264459555000, -920.76607373517504000, -931.90068378039496000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1341.14680412106350000, -1498.77782487001220000, -1554.29127440059820000, -1550.35463589002030000, -1612.53203432707260000, -1537.78882573811390000, -1641.90769133178310000, -1604.01365163082820000, -1659.28123121765070000, -1612.40003975476430000, -1581.10847637953910000, -1645.69861293346070000, -1556.61195331980910000, -1744.63508804136430000, -1738.35597578150990000, -1778.06332978022400000, -1781.33663398483580000, -1804.59669799337830000, -1826.14308709831970000, -1806.14834057228380000, -1749.15648599425030000, -1729.40148467449080000, -1658.18018812382230000, -1736.92609366369650000, -1709.03159116648040000, -1683.68029079980600000, -1746.44610358758810000, -1740.26454485210390000, -1725.96465444680730000, -1735.29422797266530000, -1799.42336843393080000, -1790.31573971240730000, -1796.36285875882460000, -1801.47676330379520000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 536.76576356002056000, 527.50778892771382000, 627.35905497746421000, 625.87760551307895000, 569.01735941516586000, 630.24496547486842000, 599.01555259202689000, 595.94410716459072000, 593.55041310305000000, 574.01198494963865000, 540.14815136251229000, 534.31806345219343000, 531.52324686051315000, 537.98423381811074000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -115.81557307943203000, -111.00510397837816000, -155.51701538401744000, -177.89834382252067000, -170.50501134866863000, -175.84533955645708000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 847.02587573457697000, 801.68795496964970000, 956.73626317758840000, 1063.96425012218510000, 1323.61059656741300000, 1271.00503666100830000, 1318.24642845628480000, 1433.14510554043270000, 1424.77923327827420000, 1390.19542628664790000, 1362.39598872315150000, 1330.19735127602850000, 1364.01518955799680000, 1345.40856438138760000, 1355.82871101907900000, 1325.61883043836660000, 1486.10331368013390000, 1507.83324325276390000, 1510.77955202327010000, 1514.90488286825460000, 1380.72656487377620000, 1387.64902701747220000, 1421.45403922086350000, 1305.88780762795730000, 1296.92986993227150000, 1391.21012813980770000, 1439.31833701634630000, 1470.36045360772320000, 1488.68098410822360000, 1508.10987115943980000, 1548.41494295751840000, 1519.00312238022710000, 1559.98624900108920000, 1611.96970948533140000, 1638.51395564759990000, 1630.40313956322480000, 1638.45153728738730000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1154.15257561766090000, 832.47817292847515000, 929.06952978259403000, 1016.37118749864510000, 1024.46659645531710000, 1068.27369692469760000, 903.02121038199687000, 928.72527131939103000, 849.75598972717034000, 810.22952657908536000, 739.63778313626335000, 710.50699490548129000, 769.32112301914947000, 636.14279261824288000, 556.88893207873048000, 553.15479974360983000, 569.95209945713304000, 514.86889688055908000, 509.78999824243243000, 389.57097377110222000, 330.35396149788119000, 245.76164721574193000, 248.82213319460445000, 303.77233896274259000, 285.94017912878365000, 319.40694939010535000, 407.27616964692317000, 520.42999331430644000, 473.75220315206121000, 446.28508642614611000, 486.16562128239042000, 426.33242464099521000, 389.51340753542286000, 395.50484326759806000, 387.06209603545170000, 333.21686306443712000, 315.34589591818053000, 319.27380809348335000, 319.68390539347587000, 315.06012916503744000, 313.91235599516074000, 292.95350803775182000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 646.47181529948602000, 616.28161843084990000, 513.41260049150537000, 512.60925854641130000, 520.43585408140143000, 503.04072672647493000, 489.14725846300678000, 573.92939137336339000, 617.66777761379262000, 630.91289709404475000, 633.40777277735663000, 662.12323956942646000, 659.36239500155614000, 670.65867420525751000, 675.44969782179021000, 675.11249830087468000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1602.55913619800140000, -1494.56954705397310000, -1543.58955702342380000, -1534.54408813035410000, -1376.38056278068230000, -1262.02967279114020000, -1285.05391669310370000, -1292.85461698528660000, -1461.98876244552890000, -1441.46814673512590000, -1428.59081136566870000, -1294.10987450687230000, -1447.04158295932920000, -1408.19981373451560000, -1418.99395477964730000, -1517.19314625845570000, -1540.79402639425390000, -1378.55388448364810000, -1427.55322125083330000, -1434.87450183156600000, -1428.88144181342020000, -1505.54189412572170000, -1393.27874886030580000, -1404.42123628864150000, -1401.35720377278810000, -1460.01762929968750000, -1358.26593051526400000, -1331.83594225244200000, -1237.16005196599420000, -1213.14661965258480000, -1195.94968048993860000, -1132.41107017728650000, -1138.06354099005810000, -1171.57203148993270000, -1155.70770230247190000, -1119.89723219169760000, -1098.75505344809650000, -1059.64124277663790000, -1067.99949593591960000, -1050.21641075949150000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -814.02218012393996000, -873.55513250135800000, -812.12015573324720000, -778.70111381423203000, -673.97928407182951000, -639.39307613814287000, -694.21237723191905000, -683.91889060947244000, -720.11156263776672000, -740.15726025986726000, -797.84724116712641000, -833.78924751959005000, -820.39055191185321000, -875.97583784671519000, -782.66659308919441000, -815.56142513395730000, -826.66676000124801000, -885.34576954558918000, -908.16128386322237000, -956.16330061448332000, -951.59865751558766000, -875.71689513805052000, -900.94318579568255000, -900.01301414298939000, -910.24601801240885000, -856.58987003407844000, -866.93211412294932000, -867.85779391466997000, -866.91927957248413000,
-3778.94975614819940000, -3647.86906533646380000, -3277.60519293438850000, -3085.87426724283160000, -2925.52149721334080000, -2726.44313781864590000, -2811.18084299265550000, -2761.83937004769500000, -2587.60608244407690000, -2495.90479400482170000, -2687.96879723661280000, -2605.83218052826170000, -2426.11582954542750000, -2397.74466389768530000, -2282.49211067431450000, -2314.26584654464390000, -2354.51444692820410000, -2268.56063570551170000, -2307.16429350090540000, -2279.27464082452250000, -2176.00178652741440000, -2168.43181018494350000, -2371.13719999193060000, -2377.89702704397680000, -2393.02841606877930000, -2299.19519956169730000, -2325.49271465682840000, -2237.36924547262290000, -2062.93213331253450000, -1824.72268265323920000, -1832.88215478986650000, -1807.30909117891610000, -1860.35739085924870000, -1895.82288871455690000, -1843.44473989131960000, -1904.32611350667070000, -1902.90710279797280000, -1926.68251442941300000, -2003.91930032702570000, -2019.08301635104430000, -2050.40856814590780000, -1990.93696007095240000, -2056.45901134553830000, -2077.15419641833200000, -2118.03609799528700000, -2101.29014913433960000, -2127.32854508705400000, -2098.25131457073620000, -2104.26039908451680000, -2117.69048175234550000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -40.04727011079783200, -40.76477496462017300,
0.00000000000000000, 0.00000000000000000, 2807.06747311878550000, 2770.25758417437420000, 2751.44105750928930000, 2262.75534897620080000, 2639.47219873258700000, 2553.16529114746980000, 2317.40084120815940000, 2154.78032742203230000, 2004.70939324414050000, 1988.73619752349190000, 2035.09201933941090000, 2003.26800874529340000, 1990.67896599117220000, 1917.89830025077690000, 1942.86697467439100000, 2052.16485462390760000, 2228.16336704372950000, 2185.00589794344210000, 2276.07633681836480000, 2222.29975891919910000, 2174.60063041113240000, 2196.48080762511020000, 2141.62424814217000000, 2057.62904454169890000, 2031.41587915442640000, 2075.27626209879140000, 2083.57411896638950000, 2242.35890232103610000, 2272.52491713161090000, 2136.67317355009300000, 2113.49870890435070000, 2169.75605594591530000, 2018.19369809243650000, 1952.52843498120980000, 1983.66987139108050000, 1974.57362557402440000, 1950.03582418639010000, 1892.78218742993840000, 1945.34373979529210000, 1866.91773255849310000, 1800.54778847949000000, 1797.36628127546670000, 1822.58833596324120000, 1835.51355556404700000, 1817.59014026024690000, 1838.62741428169470000, 1832.28913699643230000, 1826.20099763662280000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -567.07761065281579000, -497.22257030657642000, -415.70863283394789000, -412.30810750208622000, -413.52730975175734000, -403.71983131865403000, -396.08672589193884000, -411.77887380492746000, -417.51780099907882000, -419.74790466108266000, -438.24852458983872000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 415.63465541388888000, 456.24761487649471000, 478.77964477204614000, 494.16105074838447000, 558.94642906830506000, 566.89508939404300000, 571.34707689553341000, 572.38935930861555000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 254.56711973127088000, 325.49410344513888000, 318.61392317509791000, 146.14677797384891000, 163.13744665376535000, 195.64425199837575000, 199.68095029369331000, 188.79234813716911000, 170.23332828632596000, 294.16113154849052000, 318.13518928059375000, 339.55259368484252000, 357.89736668857290000, 313.37909905736342000, 292.85545555344731000, 257.00740532941114000, 195.54420962761759000, 188.11126406281642000, 182.59473187788296000, 216.20262271725974000, 179.97188246933433000, 180.45844815022599000, 184.87118817449308000, 174.33070331815665000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 758.78823655295037000, 850.86313848419320000, 849.56457071963962000, 990.10708527811482000, 1113.11037852181380000, 1020.42468439040570000, 1029.44940085186430000, 1052.09059800484240000, 1140.17504330674000000, 1122.88545585919930000, 1099.51534542963030000, 1099.54791568191260000, 1123.24696522634780000, 1095.55641227819180000, 1090.71185085260530000, 1043.04354789061470000, 1040.99435743522940000, 1036.35878423839560000, 1045.48443318462110000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 263.17906051892470000, 260.52388510376306000, 225.83017615557165000, 264.78632026003032000, 262.68386080325928000, 267.34919483207887000, 246.87555702046077000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1306.40387629209140000, -1338.26243111485880000, -1398.08368968055270000, -1437.03806065179580000, -1214.71333759284080000, -1299.47030391812450000, -1389.90659470832570000, -1327.37746236841490000, -1379.48730253948570000, -1292.64948500100080000, -1285.02926648215070000, -1352.75585871460110000, -1298.13242269548690000, -1134.29428168570460000, -1122.88769823466600000, -1059.66088866994570000, -1131.86244218712860000, -1233.40179129520130000, -1249.38351733988930000, -1203.73174582515070000, -1153.28969589164030000, -1162.30648815110730000, -1121.34543871870760000, -1030.97065608883760000, -1195.21084262531120000, -1178.24306332882790000, -1210.25667940119590000, -1152.73411437892080000, -1140.56292625552580000, -1156.42341729040640000, -1154.04023932009700000, -1159.41922218397920000, -1160.14624340373870000, -1194.40587768464120000, -1165.99224776309940000, -1157.56078848762970000, -1152.38773574646420000, -1149.49586913534400000,
0.00000000000000000, -3408.09497141716930000, -3408.70104123548570000, -3270.85951436616780000, -3114.85786603433280000, -3086.48795877982960000, -3114.18106622366030000, -3060.81346560772770000, -3110.91399279310780000, -3104.31326023407560000, -2943.03972482507700000, -2995.53643411883970000, -2941.29935533175470000, -2947.33039288839200000, -2931.71545165471480000, -2909.90665023747400000, -3005.23666576981580000, -3018.60790077441700000, -2944.37836265092530000, -2901.33128137251830000, -2832.20182141743590000, -2846.62831691753540000, -3020.07462573069820000, -3089.48927829043900000, -3112.04683443097430000, -3041.31607555575970000, -3070.00085024059670000, -3128.65207213796980000, -3194.45469120948700000, -3307.51748970238800000, -3328.68790250827490000, -3267.98876315352620000, -3262.98129807138820000, -3241.85967379635300000, -3267.69827727908480000, -3360.60385753019590000, -3442.35901034112840000, -3438.78339292416970000, -3613.03226436048450000, -3585.58290755321790000, -3540.17196035854250000, -3617.51598223276460000, -3635.41304827518660000, -3669.43455627892630000, -3684.75257228042210000, -3693.11481410050560000, -3696.51886701620380000, -3711.80074550421750000, -3710.65994741395250000, -3699.17166685979240000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1314.83823910653860000, -1322.76818086397360000, -1322.48602836673420000, -1282.41062012778530000, -1254.01042381647430000, -1218.25005800578790000, -1260.14692224101960000, -1171.15311850424770000, -1105.64285610099360000, -1058.34645296547180000, -993.60768880418163000, -943.89940915651880000, -934.46914995213524000, -929.17620791141371000, -1027.21969884295440000, -1036.96286626351230000, -1006.11444553604000000, -1069.33963254106420000, -1061.99057114270660000, -1061.84189744092530000, -1069.61566331036830000, -1110.92087894189880000, -1151.53037213665970000, -1145.55403379614880000, -1144.98522319931520000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -312.69653944827081000, -317.45513627686933000, -362.15375003229354000, -385.17501326656344000, -370.91649787664210000, -369.83867941642626000, -343.87123131500022000, -334.43993968529651000, -333.35548584714161000, -327.74073905680768000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -666.27066141722980000, -617.40757457039240000, -673.80683134391950000, -729.08488612982228000, -780.16030335648918000, -816.35891555447677000, -838.59738345706819000, -862.93987154106969000, -905.59618413404542000, -920.83164146007618000, -925.17717147571318000, -931.37919706532944000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -339.35571109387246000, -386.86067307190547000, -390.17332325428055000, -417.92925348220803000, -355.63913041812049000, -441.89762426731261000, -381.97638270185087000, -362.55560473920661000, -366.71892778943351000, -407.45354701000105000, -395.70820856928577000, -317.27412864051104000, -266.06061537562573000, -285.87951694281946000, -283.80325546046373000, -258.38779250094478000, -240.82506617090294000, -218.82746328812522000, -215.28880456437798000, -200.36244079037655000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -79.63482720037622200,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1329.51719854187060000, -1326.55384921817650000, -1382.95450507164330000, -1339.73829877910570000, -1335.77287189948040000, -1299.95714808245020000, -1250.59649890187370000, -1243.41194415408110000, -1209.22904444585470000, -1083.71084294260300000, -1151.42289159157210000, -1298.20969694926340000, -1278.15213839559870000, -1211.74720380035800000, -1203.19895762691160000, -1182.95845110002350000, -1287.05132135443730000, -1281.11037865678080000, -1306.49307429784990000, -1317.51120609744660000, -1324.24552392668600000, -1347.63455538369660000, -1359.45308580722210000, -1334.60519815610430000, -1211.78234839452600000, -1269.87033098602960000, -1251.30745943852210000, -1191.53229940369490000, -1282.06583842304740000, -1319.44303941027870000, -1378.41119148318880000, -1292.68541394231690000, -1246.96074991318160000, -1257.26387659845140000, -1250.82355390998440000, -1279.51318505249740000, -1300.05902694146680000, -1296.43347453913130000, -1308.84664026230260000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1679.23567581432390000, 1728.67991369774290000, 1598.39569703829030000, 1747.92818407061510000, 1542.79796229576030000, 1725.45386833557950000, 1592.19826915341420000, 1469.20594862441770000, 1388.90496924569970000, 1270.05985457450060000, 1256.81792662670000000, 1187.63251207901700000, 1184.40335797123000000, 1054.64402210757790000, 1004.47434310667120000, 899.41003439930239000, 1204.23462806394810000, 1195.08852944641740000, 1162.26666273081630000, 1243.09659169595670000, 1009.76171131441080000, 999.63505678697686000, 965.68781823009624000, 854.17791916363285000, 883.88765177930952000, 791.99730513236398000, 786.24715910320413000, 794.33762933789353000, 786.21551790631111000, 778.36944947910774000, 832.36122995062044000, 785.52706917455055000, 829.05064874933862000, 872.20270402855613000, 828.12344164186129000, 836.07275027888852000, 815.93615998254415000, 782.06082797212855000, 789.54559832540804000, 785.28145116378209000, 777.59083920408295000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -2014.48586599585810000, -2075.42669629389870000, -1978.10105584326040000, -1905.31362499200210000, -1793.54894916293030000, -1756.90590586866300000, -1659.77717194111210000, -1598.06949543251220000, -1656.08144336197690000, -1513.43562166786820000, -1384.14842185506150000, -1400.03935596294290000, -1520.50805617732410000, -1459.65689919379360000, -1331.22648038470490000, -1251.77562749667570000, -1341.22693686469550000, -1347.75439572675240000, -1265.11448668551610000, -1249.00044157287130000, -1200.53555738817430000, -1221.03196242070270000, -1128.28028645382710000, -1053.05368180114670000, -1028.24098474938090000, -827.21245258519059000, -811.44555789138792000, -853.98545267393604000, -831.39784133385911000, -727.71907414280997000, -735.32253566154111000, -716.14306890488228000, -609.39859466287930000, -553.59842022174269000, -623.35831500907170000, -798.60833581854513000, -845.73903989447240000, -825.34149637739813000, -845.98156579466888000, -809.56525112441943000, -828.84669335790818000, -826.56721459549919000, -829.59350559264112000, -825.84762429908847000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -565.77235686554877000, -523.29593795195092000, -492.29537976412934000, -494.37429644842729000, -495.04658476342161000, -520.89503695335350000, -535.77690706166675000, -538.39117600443797000, -549.87574828251252000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1344.87740050030990000, 1350.91111091913600000, 1477.55565086203020000, 1433.80642149895930000, 1402.44332943431030000, 1289.68574696875130000, 1289.72566267745790000, 1295.20242169205520000, 1275.49962910545510000, 1243.97518190406280000, 1238.64919286747570000, 1224.17408629422270000, 1210.07030113930660000, 1218.00894514563170000, 1206.23770740549280000, 1176.77835105637520000, 1170.03616572511620000, 1062.72672012022710000, 1043.08541526104090000, 1176.85644217925230000, 1177.63260848588720000, 1210.69403466632890000, 1209.04426813902680000, 1177.98278589504480000, 1276.05619546971620000, 1242.38540741838410000, 1249.32963400842250000, 1261.69309798778800000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1600.93850760536410000, 1628.69893005076410000, 1701.47460976181330000, 1689.89794832040800000, 1693.55510456187560000, 1689.04900267886500000, 1592.88915525721430000, 1608.85492345879150000, 1627.28738228150860000, 1470.96020373091640000, 1469.88288483690080000, 1694.97408588527990000, 1620.41104327292120000, 1605.81237843485360000, 1472.93408355887030000, 1680.92438100496320000, 1555.86950969567900000, 1567.35179013904050000, 1520.27599847478200000, 1481.28381279142100000, 1532.41139802602580000, 1467.10239756875380000, 1485.86962735243610000, 1502.14764238765360000, 1321.89324019016570000, 1347.11971147950270000, 1420.18694710271960000, 1440.28694639892680000, 1413.31344587229980000, 1420.74704775230320000, 1389.02089013138490000, 1311.49436418981080000, 1360.86741100391190000, 1340.73300484797120000, 1298.30107896534970000, 1346.74985437907570000, 1243.06679264281570000, 1253.71503177148790000, 1242.64882171516160000, 1281.70617972598260000, 1251.33168651240630000, 1248.46774748532400000, 1262.28713053323420000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 2230.76423984689250000, 2418.31761076944800000, 2574.97203514615060000, 2387.71138193729170000, 2244.53853042025730000, 2247.46718920732840000, 2238.51804448505390000, 2115.54039943326920000, 2050.46113507246040000, 2076.55131701787240000, 1973.89374435766100000, 1979.90521902682740000, 1929.90298133927790000, 1878.96640791138590000, 1921.85766589209170000, 1756.77770803002110000, 1818.46641006242950000, 1921.59574525916170000, 1961.80551963058130000, 1482.15206927681040000, 1423.63938184039580000, 1428.66596116715690000, 1865.58136775317420000, 1894.52271608789510000, 1885.71758226661020000, 1865.23680698268710000, 1641.70096857935280000, 1616.23064943249460000, 1846.23083936584590000, 1846.79398143478310000, 1829.96923441294230000, 1877.03657608708250000, 1849.96574555060440000, 1895.77622749674810000, 1935.58528929328190000, 1777.59342162590930000, 1833.74857310153400000, 1859.04267757372900000, 1813.98398435553010000, 1814.00825661881160000, 1753.33576499726410000, 1726.61380149613550000, 1709.02452000548740000, 1667.13911799092990000, 1691.31091726220280000, 1686.25617848507410000, 1685.10405054198400000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -648.53144010821256000, -504.84190778487454000, -590.12938187950112000, -603.00026544284026000, -555.14526354048860000, -684.45169757446399000, -735.80997081518365000, -687.45157240466028000, -523.65592921164318000, -540.21860912242812000, -530.80415936847646000, -598.79444736685844000, -593.63850238441830000, -639.21158739961004000, -713.44161024704033000, -668.50515820472810000, -630.51804556104253000, -636.91919342639403000, -647.95352493660675000, -637.24071256737511000, -651.37507135612816000, -649.91416706193093000, -671.26723925570150000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 130.16149200341675000, 127.36180816052128000, 133.47271107504082000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 145.09481386411736000, 133.93119681212258000, 182.08987002369358000, 205.53331351171079000, 315.38451390839981000, 256.17401484897806000, 248.69358340376334000, 268.83006588373962000, 290.05401217258657000, 330.40260538059863000, 366.64433076988860000, 361.07048271629884000, 372.54557647634198000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -828.34904210505442000, -762.38247515947364000, -849.18695656899160000, -733.37378189843025000, -794.49391634587437000, -800.53407720588700000, -574.89128080874752000, -662.39012256473234000, -876.69154157060700000, -863.97177130534533000, -777.50697698594240000, -1016.12897568618450000, -974.49704892481850000, -1243.84207454471220000, -1308.71488408014990000, -1434.19613881801320000, -1428.40369439795270000, -1342.35029678676050000, -1316.71177177438130000, -1323.40864588442990000, -1354.59400189895130000, -1089.16463245596130000, -1201.95996422260850000, -1199.85877574371830000, -1168.86210934590990000, -1180.11639186231170000, -1183.02845863317500000, -1297.51419272712020000, -1249.29747085088180000, -1255.18365008469640000, -1238.87486437529920000, -1244.11899752004910000, -1235.42770027735540000, -1262.73750170361310000, -1254.38749992935750000, -1270.09797024264750000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1613.37706349930840000, 1277.20399787052020000, 1356.02150689273730000, 1292.24337623086850000, 1572.34603848484540000, 1688.17944858522580000, 1694.15973073886060000, 1542.78957253263430000, 1612.28886662318520000, 1514.18304308325810000, 1527.95705386537910000, 1724.91112761665930000, 1668.40654392579360000, 1570.21616636407090000, 1614.52335446510280000, 1568.39716870833190000, 1535.42379741275450000, 1443.36323567515710000, 1445.61893517118050000, 1507.21150371616450000, 1580.85518210414260000, 1611.37229587485900000, 1589.58210462601010000, 1648.10100490314080000, 1570.02166750050040000, 1547.50286243432060000, 1653.93861771551020000, 1674.48735794652000000, 1649.60219478036020000, 1696.97922887119900000, 1869.20196515538030000, 1800.88391049651570000, 1794.61098212176260000, 1757.81570177388740000, 1782.86550585452480000, 1685.08150565496130000, 1651.73622457626990000, 1731.98026271759180000, 1754.17311625752790000, 1737.15719322276850000, 1735.12263895648180000, 1777.77429105517670000, 1743.29381718612060000, 1747.21182665071230000, 1738.47133502968180000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 651.11904572874698000, 541.26923352907443000, 530.40266569359278000, 555.37200204189764000, 558.65951151690808000, 558.73248527271301000, 472.99835994067502000, 588.17020528377725000, 645.64682479577141000, 613.66011596657734000, 647.09769844304969000, 636.92259880153540000, 621.66727503120228000, 630.81874569143929000, 613.61756163939594000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1294.35398496517700000, 1269.11315634204700000, 1268.62657185182980000, 1233.91005721033640000, 1383.92786987503720000, 1240.01035381083560000, 1268.18524274048600000, 1089.52834203519610000, 1082.48080955289740000, 1085.69858149723500000, 1009.83377065997500000, 1204.50046304979580000, 1118.97794107699130000, 967.79363814131898000, 1021.93550342481810000, 1035.21610196110760000, 1147.77267813111920000, 1093.70186178282890000, 1135.50628745859130000, 1100.45619009604730000, 1234.12731671472420000, 1127.56217736088730000, 1135.76966094749200000, 1210.67656564875010000, 1162.81185838659690000, 1128.05216815734640000, 1126.39525373686460000, 1138.17180803656790000, 1156.03707687086650000, 1153.61187973465530000, 1156.67480998129550000, 1169.10470030660740000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -285.80539266995351000, -296.94807032498227000, -300.12582113604958000, -314.54695297310809000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -781.88494021206191000, -738.60440723702175000, -655.98618306350284000, -653.73671964546247000, -597.30433617911490000, -736.71314832076337000, -839.91914957711572000, -911.77699374527811000, -813.10351818692743000, -783.95543081166488000, -788.57643293927686000, -804.05604144754727000, -974.88899705812548000, -1035.88267060019530000, -1024.49152126434680000, -1087.27355727032110000, -1046.73732524338560000, -1051.32137607321330000, -1068.93812601099280000, -1117.10883869004490000, -1167.22021429713370000, -1155.95857630346200000, -1177.66818037334520000, -1192.67661521916920000, -1176.22648081628770000, -1176.24298918051550000, -1155.54006424789050000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1082.45972992343490000, -1005.51456132763710000, -981.24314760621257000, -931.26666752031463000, -890.89385445310290000, -1091.66142361199970000, -1029.59596926289050000, -1016.85451545939680000, -1005.12797186402640000, -1137.98585285995500000, -1222.49463350937640000, -1252.55672191173970000, -1346.87501473912200000, -1361.03218041877130000, -1405.20856517958050000, -1400.99230546182480000, -1440.86552059498740000, -1422.96479768189970000, -1446.95232167176300000, -1453.25441505810820000, -1444.73770757897320000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 451.46086066276644000, 369.92500595106259000, 443.37745770774666000, 474.02765860858142000, 558.55334434106987000, 568.23539449579323000, 824.01874876849593000, 782.04518519533826000, 744.48292185132061000, 834.28569907836857000, 772.79716562665089000, 791.62477018010247000, 795.86605785160907000, 816.83491953445309000, 814.60807269213319000, 834.80307808818304000, 840.29693594284720000, 843.58574832186446000};

double lasso0[2500] = {
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 102.55880487827970000, 235.96097283412280000, 264.24319006968642000, 312.41461343302922000, 388.33259219337322000, 414.61140553246582000, 434.95908327549523000, 474.94064473504289000, 483.51581293381389000, 768.62247318362040000, 784.24082748408330000, 819.78986666540095000, 855.75752880742175000, 871.95034678628917000, 994.42437015050848000, 1028.85201926607560000, 1066.69551999943700000, 1069.61197539617140000, 1164.77706263853180000, 1167.03155480825420000, 1176.70827375619480000, 1228.55922897373920000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 104.86097902724276000, 260.79474009237180000, 275.60673890053454000, 341.56290166173665000, 348.59436019009257000, 428.34248173123177000, 526.65636168686672000, 552.74684843464490000, 578.47714214642792000, 823.02808048284703000, 857.92838821000271000, 879.08059230687456000, 900.56122838253543000, 926.97185475790320000, 950.16285310519856000, 956.18636353583599000, 957.18559463859810000, 1005.99019446000470000, 1050.02049357885450000, 1063.62021886458770000, 1115.20667947688840000, 1129.87916565402820000, 1163.89604565090890000, 1176.44082209313840000, 1212.56009503628570000, 1260.38875250443490000, 1269.53043320710530000, 1284.71441722900770000, 1309.83030190338950000, 1319.59245463943260000, 1327.52843269986280000, 1343.75950942512260000, 1346.79199529219410000, 1441.16022032088990000, 1444.11342842517710000, 1448.44098219921310000, 1457.25019193967250000, 1462.14013152138890000, 1526.04795030337780000, 1543.44147172878210000, 1560.92468926665670000, 1562.89947820659880000, 1633.98985220629360000, 1635.44906647601240000, 1645.19031432604790000, 1683.50097102175980000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 4.06641266360061590, 128.64115765971923000, 131.21108632665340000, 143.28327366811956000, 206.02172578157709000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -55.59418890659734600, -112.06027882712141000, -125.62369490770651000, -127.49839886249895000, -201.56715209874642000, -269.21834815741795000, -285.97337212221788000, -359.06653064926422000, -381.22126878088028000, -428.15594856808514000, -447.45335702893431000, -482.56062214854688000, -510.27358489571674000, -513.64591525996252000, -512.25510996611365000, -509.58251684108478000, -506.15411618695379000, -500.48052212469054000, -481.64931564350405000, -478.88048949181575000, -392.25892032173670000, -391.17972642527792000, -378.37541360442594000, -367.55866891383437000, -360.88514256378824000, -294.74633562625058000, -280.69308208469744000, -266.42953940393500000, -265.55630747185165000, -250.47984247907038000, -250.46408626554307000, -250.08961387637163000, -243.65964023715190000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 25.40337833776978400, 53.84065437336426600, 96.77270772445157800, 129.14976179932103000, 138.37554467146560000, 139.38576898485945000, 180.89346056466692000, 222.49135961579572000, 235.16597084185406000, 282.17421180448594000, 288.22652657547235000, 303.55943871892032000, 306.10686904153107000, 341.16766940550667000, 396.33163719014044000, 409.31625491772866000, 440.08876646862666000, 495.54939997591168000, 509.80140588571300000, 516.88156069806973000, 537.07572435874897000, 541.34422273154678000, 687.67272321500445000, 698.94585852604359000, 734.21920398756902000, 763.36833741390080000, 776.84183772918539000, 895.17395981733512000, 928.05376546046034000, 964.14224015778689000, 967.30903043258934000, 1137.99885218015150000, 1140.78249507964670000, 1153.67302974362180000, 1233.17130061972600000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 15.23195944137116900, 26.58414143633723400, 46.55692670727612600, 51.14819470109880200, 206.82620845361950000, 212.13912652256931000, 224.75249789672245000, 245.68498879247934000, 253.32025553614085000, 343.04062022200873000, 357.76506468616026000, 379.58370744617093000, 380.60359767993901000, 429.30312612074829000, 429.57215744679797000, 430.58903203826151000, 443.16689235617730000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1.51871474881506340, 72.67696892248271500, 110.59674680810579000, 123.79798729752423000, 174.08503750273675000, 192.65335337306789000, 230.41212018974176000, 248.45460835711000000, 303.56970294668946000, 370.98829616184537000, 386.44354853429263000, 416.04138500913461000, 464.55551898836279000, 482.79518322877306000, 495.82524578164885000, 515.64812330296388000, 518.82759680420440000, 615.37112746099751000, 622.45209140728264000, 640.11505417055571000, 665.09120644010454000, 674.32553404194027000, 757.19888607971086000, 778.62597584370485000, 801.80633275680384000, 803.67025237200369000, 850.22984181757613000, 851.23903685284392000, 855.86705699368110000, 863.30766192117812000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 53.16892259155555700, 72.24111818241250700, 111.41644765332559000, 124.28438795187202000, 165.01545352531795000, 211.89477661624340000, 219.96010731537359000, 225.51348075340655000, 237.34301796855971000, 242.42069757803711000, 246.76308430723211000, 251.69835478692514000, 251.96355232594880000, 261.88738209013434000, 262.52175200244460000, 264.52011164816656000, 262.98370077647769000, 262.89839894358016000, 256.59480052707016000, 250.61855577004130000, 250.28578360613963000, 249.77970024637096000, 276.58789608805114000, 276.86274233211731000, 279.68341667794658000, 296.28788119283314000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -4.03450479444792260, -4.71822545941632490, -45.06399919639462600, -87.06442150831863100, -98.71366597693787500, -139.98862652815669000, -153.95713449164154000, -188.26462510407376000, -200.46070796353700000, -266.18118938227821000, -316.76650287678711000, -327.01202728780748000, -362.77217697499475000, -424.99924675900667000, -444.82165921529838000, -458.01946651044881000, -495.31790002160210000, -500.47342907429919000, -684.71500299806883000, -696.50791867124406000, -729.62233818128493000, -761.22151584158451000, -769.65229236673520000, -835.59034131610429000, -852.47434638814514000, -866.62215237634416000, -867.70954974414155000, -886.25831180848979000, -887.54226179074772000, -893.00103002838625000, -931.90068378039496000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -34.00838844359564900, -93.62564000319503100, -158.48365111350512000, -174.84836637178378000, -177.23612651013775000, -271.88471020611121000, -381.37831432729575000, -410.18886123398579000, -530.69756913419155000, -564.00422741853379000, -635.51326052047273000, -668.81123801148794000, -765.39595157930955000, -901.94829709310034000, -930.90945120098968000, -981.08389629369901000, -1067.77118813348330000, -1099.72985773391000000, -1124.21051437705890000, -1167.64166326787540000, -1174.83445118344180000, -1395.24912020259670000, -1404.26936176773870000, -1430.57153848695520000, -1456.20398217626940000, -1466.61728765232620000, -1582.43740554790770000, -1608.23422500701920000, -1634.43617966530270000, -1636.39864613158620000, -1740.84548095298350000, -1742.43294804775380000, -1751.29378810249200000, -1801.47676330379520000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 6.63928441157022940, 213.66035146401902000, 227.85290113257062000, 259.32352868777787000, 287.83106361302509000, 303.50592918874918000, 425.81627563199970000, 453.62364117359738000, 484.76558935998867000, 486.50211967681173000, 520.87211050500184000, 521.30358202742286000, 522.98270246921618000, 537.98423381811074000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -25.77578633655108600, -27.43415352313963500, -109.49440381710716000, -111.68943991827855000, -121.35300813675399000, -175.84533955645708000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 180.53184546622649000, 206.47280589217624000, 226.99493898097168000, 248.21854952173814000, 291.98783948612169000, 335.45919032525410000, 347.01416451998290000, 348.81805241535693000, 423.66866418387480000, 500.91444773654041000, 521.21465793705806000, 599.26289634650618000, 622.81035416783243000, 673.61370041906218000, 696.10103901759794000, 764.58689910063117000, 865.20048271770054000, 887.45205558922100000, 924.36991907944991000, 988.33955559110211000, 1005.35873668263230000, 1018.24219881875760000, 1043.92189101701800000, 1047.16216143773590000, 1146.43323864716830000, 1154.83067410522970000, 1177.32426604812600000, 1204.29845320450480000, 1217.31678546193330000, 1337.67497429298240000, 1372.12038684005850000, 1404.81044662342520000, 1407.82981209455510000, 1538.61835656873700000, 1541.82393867861110000, 1556.37775716016040000, 1638.45153728738730000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 4.91168079897419310, 44.35749946087132400, 100.37839838266956000, 117.23234477539086000, 135.14098531920791000, 334.02531142665686000, 357.78793707180779000, 373.40492047279150000, 385.48408447552862000, 402.77155323406527000, 417.72944172488241000, 421.17173008653344000, 421.74994994196169000, 436.66446146759245000, 446.27292115923859000, 448.79151790061979000, 460.48072958958704000, 462.15539351231331000, 465.50441553235055000, 463.00147879055174000, 448.57062483618671000, 420.28944146214093000, 414.35227557314738000, 407.80294953202821000, 394.60217801973147000, 391.34070100089195000, 391.87773793882394000, 400.06495373621328000, 400.97639526171849000, 418.98449809435760000, 421.28924650071627000, 421.68799557131553000, 418.72630211431527000, 417.66328088791266000, 404.99756300781968000, 393.26501963630784000, 375.92342531451266000, 374.82115359708610000, 339.49576874564974000, 338.71164562305751000, 334.63705072819124000, 292.95350803775182000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 21.78657257339212400, 59.64867943956332400, 65.26130962594493200, 243.06136650454042000, 252.57711107490189000, 272.38052296756138000, 292.33405342134625000, 305.22479484611875000, 434.54379646091644000, 466.64029303757513000, 503.75587958058304000, 506.83734544818338000, 604.55723990248271000, 606.67839015526511000, 617.97771458494913000, 675.11249830087468000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -101.47573482470388000, -127.10817288571036000, -155.06926000136787000, -449.08523239460095000, -487.81129674570877000, -508.98867437047443000, -528.66789825363310000, -559.77089010761313000, -599.83211658546736000, -609.72752653017483000, -611.08752605849429000, -658.60284681749147000, -721.61565757924222000, -737.79453318734261000, -803.51462250269856000, -825.48946989485603000, -875.78002492983376000, -892.35258027178600000, -950.57758473387844000, -1018.11152766197530000, -1032.33470027234580000, -1060.36137755710370000, -1096.42461603843620000, -1109.78349421638630000, -1119.60974129074770000, -1141.28958525865260000, -1143.97337726726980000, -1218.64003175920970000, -1219.27538861291780000, -1218.79080511043680000, -1216.68826352502200000, -1212.83026106179820000, -1181.88459056523930000, -1180.19900451330950000, -1174.74824727829170000, -1173.68097223623480000, -1125.67736301068130000, -1123.55830864212360000, -1114.42983528606120000, -1050.21641075949150000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -56.62849111949727600, -121.91808370284191000, -138.18221296904022000, -199.97756692474766000, -214.57253517895907000, -244.44017771104583000, -259.26567932810718000, -305.46412011560113000, -363.28562533266768000, -376.33504821115486000, -401.29998187450093000, -448.14933511347709000, -464.29472354008317000, -478.16867792088067000, -497.56149319321071000, -501.49485134372270000, -630.73560005878710000, -639.47038082041524000, -660.71497002322201000, -687.91119664211908000, -699.98215953445890000, -772.71812036797644000, -793.67648581484605000, -817.34262639575900000, -819.15031347389925000, -843.13712433670264000, -843.90068944133952000, -847.83691088346518000, -866.91927957248413000,
-22.17288470348218600, -778.32629818663145000, -1192.89078499792000000, -1367.79620805705760000, -1444.52567898733880000, -1544.27942162885120000, -1554.29011544399690000, -1599.32715059251810000, -1603.53292958236120000, -1646.06768549352640000, -1712.04196284820770000, -1728.48738970539580000, -1742.25844931773370000, -1881.96626626389660000, -1898.69318067471500000, -1910.06043770187400000, -1921.33076586031050000, -1935.46329073744890000, -1951.96794943498280000, -1955.81620898296050000, -1956.18190162927730000, -1970.94733720982710000, -2002.93091048738780000, -2011.76672486299570000, -2048.54971616383680000, -2056.26733139795670000, -2075.19562401201980000, -2080.54123072086030000, -2078.62551968341130000, -2043.21943077407650000, -2035.93636723983830000, -2022.39544274020320000, -2004.84268817783690000, -2000.11412258893070000, -1994.83424990865210000, -1989.06998196968680000, -1988.00422871309520000, -1963.63169204707810000, -1965.01381840300910000, -1969.28890879841470000, -1976.75603049257730000, -1977.40519854233000000, -2010.12528095543260000, -2021.08114595025900000, -2042.65933325041780000, -2043.80015455316990000, -2097.31520359468780000, -2097.34524276183170000, -2098.48142291345630000, -2117.69048175234550000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -6.57988211739865840, -40.76477496462017300,
0.00000000000000000, 0.00000000000000000, 465.61849855319929000, 678.55954006253239000, 780.66425855304078000, 895.99472089040250000, 909.77118282340109000, 971.06358802947625000, 976.79314144821944000, 1032.94170396963450000, 1094.47505903944170000, 1110.92915067443140000, 1129.17195906511710000, 1315.47343754905110000, 1343.67163060345430000, 1359.37858797050540000, 1374.17450713936710000, 1401.76923986370500000, 1438.46366069482770000, 1447.24101956966160000, 1448.61758103161450000, 1502.43976844811660000, 1556.15953544433300000, 1571.24825853670000000, 1626.27643353512330000, 1639.55819483739010000, 1667.10833450861900000, 1680.56246590439420000, 1724.40650027416720000, 1796.63361286643730000, 1813.11165551549650000, 1832.27525734892900000, 1862.73875752702570000, 1876.05515913159370000, 1880.84533175978710000, 1885.41067394990360000, 1886.62604721353730000, 1921.58112965566010000, 1922.55731029630810000, 1920.20308003917720000, 1922.51729545108220000, 1919.97208432013370000, 1870.54280743300960000, 1858.58211650080740000, 1850.57138036306260000, 1850.27838960308740000, 1829.33565078718950000, 1829.63381718392590000, 1830.07009389646960000, 1826.20099763662280000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -44.83713720113890100, -86.47953447988405200, -101.55083220540395000, -230.17212569684358000, -260.14149979061250000, -292.09613505790139000, -294.11955362236608000, -369.50163927631075000, -371.04244538211128000, -379.04489298073008000, -438.24852458983872000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 172.02965545429316000, 218.48503327192034000, 276.41591520937146000, 280.65273650289265000, 458.95020530832375000, 462.41408352186170000, 480.31208888180430000, 572.38935930861555000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 17.89772150703757700, 28.03678893424504900, 59.64896134645639600, 71.71085644693874900, 74.87656096640330400, 82.02927788817353900, 94.77388266226219600, 98.85178853582921500, 101.25739858621358000, 113.54302115480317000, 116.07363261474035000, 204.89615227828298000, 210.14508662694041000, 218.30749242857030000, 225.16968486358581000, 226.62713733799109000, 213.76202786053059000, 209.56941481821610000, 203.56595910428229000, 203.81183961657018000, 188.53803309728301000, 188.27876468906166000, 187.71889002819600000, 174.33070331815665000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 44.94080671125541900, 132.24225672087010000, 163.35500529340428000, 191.21715452329062000, 249.93054500392438000, 259.46082818537559000, 565.49556545497762000, 582.18893217158382000, 626.30723159182673000, 672.01760637769246000, 691.58740058619048000, 860.44075758306190000, 903.39638816216495000, 946.16331140351667000, 948.97589469438685000, 1009.24324860652150000, 1010.26212018213140000, 1014.54987744180230000, 1045.48443318462110000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 43.01657331911651000, 91.42476097582732600, 94.03998231516268900, 203.43390922283385000, 205.33520003592730000, 215.52427844898077000, 246.87555702046077000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -25.78817695897400200, -305.52390406906221000, -351.15180618241271000, -380.85430870618524000, -401.99904966551793000, -438.52682543808044000, -480.77099014789786000, -490.72483932302754000, -492.20093008585280000, -547.88515465664443000, -606.79844784400916000, -624.37641268811285000, -689.37838384501651000, -703.07777177943592000, -732.59313557628946000, -743.37402311790277000, -785.63806056822864000, -848.07754586870487000, -861.97302337366807000, -882.21439237188895000, -911.57859550423018000, -922.45353098554438000, -929.15633361288167000, -935.64066815015519000, -938.85130550837914000, -1033.99842367323750000, -1040.04522543419600000, -1048.95520015325060000, -1057.38775576841840000, -1061.92136457670360000, -1100.04902808243920000, -1109.75307635475770000, -1120.96852408893940000, -1122.39744668086750000, -1150.32780548413510000, -1150.55990700943580000, -1150.86022454886260000, -1149.49586913534400000,
0.00000000000000000, -710.77181256316487000, -1158.28715328331260000, -1353.48186365661350000, -1440.24263573404300000, -1568.34693070917910000, -1580.56167130278980000, -1635.76948318674640000, -1642.04719647752900000, -1711.74586424011980000, -1789.71269021599890000, -1811.89942463169520000, -1834.19357562044680000, -2071.44328620751230000, -2107.37030335824510000, -2129.32226911017140000, -2151.53343715934030000, -2186.82403998920200000, -2220.46176344815600000, -2228.46698513230690000, -2229.46969108796930000, -2272.40311798401440000, -2332.15777116117530000, -2350.00375863130920000, -2423.52340268302710000, -2442.54583260697650000, -2486.65999462308670000, -2507.82149503035180000, -2582.52099620848280000, -2683.61986776048070000, -2705.95576356873020000, -2739.24333338456060000, -2795.97719214444760000, -2815.31665680880360000, -2830.56224798848830000, -2864.31945455198460000, -2871.46925670510340000, -3096.95030771069240000, -3114.65526723942730000, -3151.89011274187990000, -3187.63172989251370000, -3207.31077280495040000, -3384.50073035314060000, -3431.07311643076130000, -3487.53173661536130000, -3491.53191213303940000, -3622.86315021063500000, -3625.71709740147430000, -3639.67345293461450000, -3699.17166685979240000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -40.48513257437959800, -130.63795716425227000, -169.92394577298981000, -290.95246595531552000, -425.24838828414960000, -452.70658139954031000, -500.52890987088432000, -573.17420522639020000, -596.26921138208388000, -611.84155207818321000, -636.15541367774802000, -639.96191560213538000, -757.01487883791287000, -762.92112943316067000, -783.81842990152086000, -807.12055330440489000, -816.23000386748254000, -920.99114841044877000, -944.03748041709082000, -970.25590167055850000, -972.18921491217316000, -1061.07194995242750000, -1063.97469944805130000, -1077.37841964523910000, -1144.98522319931520000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -28.78393637480098400, -41.99859334241904200, -174.50963538348637000, -208.94285607983855000, -244.99153133220767000, -247.42077070019275000, -309.21474394554758000, -310.02420339047842000, -313.85760046817796000, -327.74073905680768000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -22.85740654866574300, -69.86671701299870600, -125.45982928652626000, -153.09229856627846000, -412.63343981940574000, -478.62230114260376000, -558.73795883447804000, -564.65703086377835000, -783.09025327850225000, -787.51028112572976000, -810.12934872922915000, -931.37919706532944000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -11.75040987403866300, -33.96709302975742900, -72.55309465183548000, -87.53325264069658800, -96.56861663540513500, -118.56187609493490000, -121.82006420271871000, -217.50127365808353000, -222.62040734087768000, -237.23461302803460000, -251.82221895163619000, -254.81844626737612000, -259.47153872023046000, -263.78791833334162000, -268.24250971103913000, -268.05075949988520000, -250.60777628929927000, -249.58796757157654000, -243.95251604920284000, -200.36244079037655000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -79.63482720037622200,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -24.46265064384541100, -50.16569612229420000, -334.23118950251944000, -376.22356425450812000, -402.47034251024348000, -425.22853707411485000, -458.82165295013095000, -493.65985590747010000, -502.07305378723510000, -503.03906012010299000, -548.14470826953948000, -608.09065083188909000, -623.88018130660669000, -680.59583901156054000, -696.68729110935146000, -730.87531117888943000, -749.20812131480284000, -807.07429137483848000, -876.71693908208988000, -891.97972423122246000, -917.58156255208360000, -964.16700680026713000, -981.31193056794939000, -993.21817184845202000, -1007.13805270728820000, -1010.38780229642580000, -1106.14218956120820000, -1109.07162435239870000, -1122.74976146375370000, -1140.85551603255480000, -1151.73023011160350000, -1210.07106236185840000, -1216.10067560746320000, -1225.26191226554670000, -1225.75928322792630000, -1260.19838439973570000, -1261.47748541918080000, -1267.22085536849290000, -1308.84664026230260000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 80.04048809215778700, 184.43407544595041000, 210.45047388799674000, 240.80000666280816000, 518.30285569894147000, 568.71636072264062000, 596.71190246845219000, 618.83633832082887000, 650.17872856076258000, 677.70334200500008000, 684.51219525570014000, 685.34779676115181000, 720.06523334478129000, 746.80510409792635000, 752.87689956332247000, 767.01397954875335000, 780.47642336345564000, 809.62634663694280000, 821.25016327581022000, 867.14325139347250000, 887.03102394117798000, 890.93001103982681000, 895.35769718630377000, 890.89690215591349000, 890.59288673579715000, 887.27014358879092000, 880.83620766083698000, 879.76630212350608000, 842.58420529039483000, 840.38122253128631000, 839.74710561159793000, 834.75611312477008000, 834.49493100965844000, 850.10203959864282000, 846.50964144737986000, 844.18681844850414000, 843.63712538166112000, 804.18636433378185000, 803.71655206953744000, 800.68761175858447000, 777.59083920408295000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -15.91789294680389200, -92.72980766698069000, -100.75330642636234000, -186.76737268879467000, -288.51047688545862000, -315.52843831208122000, -342.06366593104116000, -609.76392965626997000, -653.46064421924302000, -676.98374236411348000, -694.91580695228515000, -723.61488201253792000, -758.99937051324309000, -767.23724677895711000, -768.17394171434569000, -801.81630974482005000, -844.92654546954884000, -856.77533220409168000, -896.17067643492908000, -907.03464387437884000, -927.66966389454581000, -937.33954397120999000, -958.11217526460337000, -971.35152091720670000, -973.32135521110320000, -964.66775248587612000, -948.06997471698446000, -943.98920374169677000, -940.19479255441399000, -926.66267245850418000, -924.29597608219592000, -841.56485185354484000, -833.60004290307836000, -811.46114879605841000, -794.14615065377780000, -794.35041850695620000, -815.61997992685826000, -817.20896016085953000, -823.61255956846492000, -823.33923114078243000, -826.86775729530257000, -826.85811308363918000, -827.30754597143039000, -825.84762429908847000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -25.89966584915783400, -231.77015378738295000, -274.35295829550313000, -323.32066489073128000, -326.66205771755642000, -451.10342840417542000, -453.82054298047387000, -467.71574218760861000, -549.87574828251252000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 107.48394421888969000, 136.78443604851236000, 266.13804557306588000, 302.09167667098211000, 379.45354281361654000, 409.45684010273010000, 505.22215164737906000, 615.38284148046807000, 638.23981004105224000, 674.11574347503915000, 735.26876873302967000, 756.47428252258464000, 771.76079980720419000, 800.18138141737518000, 805.20391381115542000, 952.88751499064347000, 960.33712260322295000, 968.43276303338268000, 975.30459217393661000, 984.53113974748271000, 1064.45512756246900000, 1088.35785241123490000, 1115.21768812080950000, 1116.43895307390040000, 1218.70268041363370000, 1219.46264308165380000, 1224.36987593312780000, 1261.69309798778800000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 59.70897134237968400, 66.38605894481136700, 144.32228169557351000, 242.18976312282911000, 268.89437690529661000, 296.92797314851987000, 573.14416743629522000, 616.39791850410484000, 644.04901614487528000, 665.01757587999771000, 697.77621789040450000, 742.05484598879980000, 752.38198781524363000, 753.79939771771501000, 803.82691928313238000, 873.92542388672518000, 889.99495948126298000, 955.34432707928499000, 972.73911598309269000, 1008.49311032047790000, 1025.76263349212100000, 1073.77642078066580000, 1131.24174445122840000, 1144.08459984742310000, 1154.61568527059130000, 1175.46866322909480000, 1186.08294120243430000, 1194.64980193261910000, 1208.57601765515620000, 1211.20037246379390000, 1281.87577900533600000, 1282.89188864690070000, 1289.05718089010360000, 1293.81397682888560000, 1294.01938531969520000, 1315.84433255657900000, 1303.94885585903150000, 1292.76887131878020000, 1291.79365002225270000, 1285.33079991632670000, 1284.23979139659040000, 1278.36234128867200000, 1262.28713053323420000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 206.11524969721657000, 315.08254832002370000, 490.93820323296507000, 505.92596408680396000, 570.76965883556886000, 577.90511322833595000, 657.05795131074535000, 749.41059827969946000, 773.34947232093396000, 799.07444175358137000, 1049.47092061501420000, 1088.32807575648530000, 1111.34787240105310000, 1130.81290728904810000, 1163.00904218628880000, 1189.37418272177800000, 1196.77064064368760000, 1197.97445795806270000, 1251.11133991149130000, 1269.57634561249820000, 1273.20673334660390000, 1288.20497617156300000, 1305.98294996580130000, 1347.36111711083480000, 1365.10655503079670000, 1419.51621735529720000, 1450.49930186176330000, 1456.23785642050510000, 1479.33599951364640000, 1519.14084592949190000, 1532.62254768526370000, 1544.22955211684050000, 1563.70123066035030000, 1567.80868404065790000, 1713.98282318745240000, 1716.16507942881070000, 1725.46205596139480000, 1737.75824612768160000, 1741.24767279416660000, 1771.36301087525750000, 1768.41646055881730000, 1759.11290681686610000, 1758.13830160570840000, 1699.83685771631080000, 1699.56326606220820000, 1697.37687314850400000, 1685.10405054198400000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -21.37705248186028200, -73.97366990329734900, -145.95023874769669000, -161.77589003641970000, -185.07400686158789000, -239.16904156025402000, -260.71007557131207000, -275.09157584836697000, -290.92210324424644000, -294.00566504662066000, -388.12208127428767000, -395.34951030456244000, -411.02763015331664000, -432.03212389896669000, -444.91435749478421000, -537.45776769376891000, -552.66845450936023000, -571.41920613351874000, -572.90838857053336000, -614.12488336518879000, -615.32021666629782000, -621.00410260780245000, -671.26723925570150000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 4.17679411313471590, 24.41644762308412100, 133.47271107504082000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 57.66845745036796000, 60.28476421434680100, 69.91553104128219300, 82.39924329728619100, 93.06473549282915800, 160.57506641336940000, 174.97802324213473000, 195.86563044431767000, 197.69832048499660000, 282.71942850367435000, 285.41252177062711000, 297.84334321957891000, 372.54557647634198000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -34.59383139175611200, -54.50120561194716400, -74.65260262985191300, -101.46306527023867000, -132.23574970968244000, -140.09316749960445000, -140.81529687085037000, -177.09931480812855000, -233.01142385935782000, -247.87956330512711000, -298.97643718326742000, -321.05825282704785000, -366.99924319060108000, -395.90195177952035000, -495.20776905028197000, -626.14725004897969000, -653.92589569134429000, -694.69925834320691000, -762.07869703825702000, -786.42551746173876000, -805.57321056630371000, -823.63453638682233000, -828.31406381955492000, -975.98585056290381000, -982.60275764869868000, -998.21957226096367000, -1015.23136022709050000, -1028.15357346000380000, -1119.68421937327300000, -1141.83157860619870000, -1163.42942536265900000, -1164.99945950663800000, -1210.12149208338020000, -1211.80990419249040000, -1218.80552611667510000, -1270.09797024264750000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 125.54661711429884000, 134.64668537872009000, 180.19936205533190000, 184.93184313922765000, 251.06270909263210000, 342.06245685537260000, 366.94057297435404000, 390.15162020708721000, 650.63326407324041000, 686.69716218259828000, 709.70834217775030000, 735.45154237786062000, 773.42353417253219000, 808.80355830284043000, 818.27668848973826000, 819.52251733342007000, 869.32510290330822000, 915.20280344271202000, 927.70168874152159000, 983.61106798062042000, 1002.00078803925610000, 1044.84356189425470000, 1062.79936742147150000, 1126.47490860112860000, 1188.32634817040090000, 1200.76306610900680000, 1227.60332784465800000, 1276.01199239699440000, 1292.21589099192350000, 1305.85671125207680000, 1341.73495507339110000, 1347.41419303765930000, 1525.15417089372230000, 1533.13597094514720000, 1552.88134126054070000, 1565.05045936904680000, 1569.01872032330060000, 1636.46790345860380000, 1655.70680075698170000, 1673.83431036043070000, 1675.02684076988070000, 1740.85517537280820000, 1740.93342973677640000, 1741.96498847887410000, 1738.47133502968180000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 41.46836725346273100, 47.65043087530159500, 239.52204896608109000, 250.35775163753635000, 274.73425327926151000, 300.87649026940829000, 308.75580578513166000, 424.40439824153930000, 460.56643576992013000, 494.63879655268704000, 497.60529736712300000, 586.86323913926867000, 587.98007707642853000, 595.01859402835123000, 613.61756163939594000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 57.47326640718755900, 71.71894148140411600, 73.70681154822824500, 154.41782999220391000, 252.68149959819849000, 275.94721374756779000, 371.67538059638707000, 393.77876293527441000, 442.19898878651929000, 463.41018027962161000, 522.85614045240504000, 617.90966475610776000, 635.25947626412676000, 654.95450153455261000, 694.70767913979569000, 709.47670658996901000, 724.24760110790396000, 747.77734588426381000, 752.57318588090550000, 890.84054149483688000, 902.61750517997154000, 920.40321024004277000, 940.22784349427616000, 952.60832028522191000, 1039.61079171976460000, 1054.06651987104440000, 1070.16392318691810000, 1071.48720076069750000, 1125.65669615704950000, 1126.55375906253220000, 1131.50273470429970000, 1169.10470030660740000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -183.11007200429935000, -186.76305626191976000, -205.38888587054112000, -314.54695297310809000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -18.42457195396903600, -87.90537536875460500, -105.39712920465668000, -143.94896296603397000, -158.89257403366750000, -221.75424298572702000, -307.95572816568381000, -328.86342804894383000, -357.54355149365324000, -403.73457251163825000, -420.42649441341803000, -433.35509047894755000, -467.84421664648863000, -474.87031463659559000, -693.31924691832262000, -706.83443579690947000, -733.70954460543874000, -762.94593706754597000, -776.95350627787934000, -917.74254750336240000, -958.51963031517937000, -1002.46142459199420000, -1005.87054650797020000, -1125.55363706479780000, -1127.17969429738880000, -1135.24093531903580000, -1155.54006424789050000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -150.94618826133609000, -180.53616809857459000, -227.95969928281804000, -304.14535106135492000, -329.59466206852579000, -355.27686879929462000, -398.22279748542650000, -405.87468626165281000, -644.05006746526749000, -660.99526963233529000, -705.39135147997627000, -755.75830864807028000, -782.81817641967882000, -1022.13882639714300000, -1084.75151097842490000, -1155.13371375796560000, -1160.69339985816990000, -1328.72568956247870000, -1332.51950210572180000, -1352.35659693099180000, -1444.73770757897320000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 48.90444923116051300, 62.82822055811576000, 75.65300792965584300, 101.02462995053241000, 106.68382706689096000, 290.12916338574331000, 308.44504011853292000, 345.89119261050411000, 382.58184161555187000, 403.25973234156118000, 556.20991707096846000, 594.68843534370137000, 639.46230534737253000, 642.91356990405291000, 752.91496796925082000, 755.54270195582421000, 769.46806733134508000, 843.58574832186446000};

double lassolsq0[2500] = {
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 942.71419325757893000, 1059.20750439148510000, 1052.76073081458890000, 1077.57770853889000000, 1013.25056128139240000, 994.20574896681455000, 1018.38697065877310000, 1062.73292315611270000, 1168.21666976081130000, 1200.84899001711850000, 1223.88196326892600000, 1233.84723543808810000, 1210.52737168923340000, 1209.48598405297320000, 1167.85542410398880000, 1205.05566062765140000, 1198.89015767782480000, 1216.58241200181960000, 1218.14938150420130000, 1235.03383292037890000, 1225.92716579036280000, 1228.55922897373920000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 2128.83781024428940000, 2108.73778041186140000, 2135.32438706946100000, 2044.04719942726750000, 1993.82336055508740000, 2021.69623604157820000, 1980.96791292565040000, 1944.64459830614900000, 1856.21841591627070000, 1725.87012520253530000, 1658.71569621917140000, 1631.22645163549780000, 1726.18590196130570000, 1549.45860790768890000, 1449.25574434015020000, 1462.48153770079220000, 1557.82897155116050000, 1658.74104775607180000, 1556.91298253352760000, 1627.15305429732690000, 1598.32227872442760000, 1591.72595116316070000, 1613.71612555113850000, 1544.47619994572010000, 1508.44694574153050000, 1555.54719687643500000, 1524.40350507081850000, 1525.89940615084220000, 1516.57141776094200000, 1534.90234829949960000, 1555.07631175465370000, 1582.38204494616430000, 1588.92668272575860000, 1584.22404481441340000, 1527.24329858949610000, 1498.84615685837640000, 1544.14051979015720000, 1564.06981881018010000, 1616.54551103319390000, 1632.46299628797780000, 1621.99693583697220000, 1662.41603279964150000, 1673.86012626728870000, 1679.46336642668300000, 1694.73742102495860000, 1683.50097102175980000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 208.98723718823405000, 198.50756776040512000, 208.72787981310128000, 204.68628522322331000, 206.02172578157709000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1365.92457087512750000, -1327.26557758709350000, -1265.67187542775760000, -1254.39337941808570000, -1192.22053424839310000, -1048.04301746928150000, -980.25255528574894000, -1043.59585604882700000, -1078.58737745204580000, -1048.79374409513410000, -1013.59569102512740000, -770.15716733556906000, -681.29479699728984000, -607.66759762122672000, -490.16332174337123000, -487.58309726796983000, -430.53876778745223000, -337.80185975249498000, -204.80075448379512000, -257.79822095536053000, -260.93915707162284000, -360.80149186588346000, -229.23720346875990000, -260.86686339082394000, -221.77699151073685000, -201.08955291167194000, -208.76733314125747000, -216.60423730043877000, -221.55108165561077000, -242.02436873046182000, -249.98883138168728000, -248.18492736108050000, -243.65964023715190000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 928.71566400816130000, 1146.84910447973170000, 1108.66216906251910000, 825.93552694433470000, 913.83188360343138000, 746.63722598880190000, 736.04976132764045000, 701.38119246467033000, 760.36478568271309000, 722.41403893500501000, 478.73562558723899000, 506.31324112823592000, 380.84271512477642000, 628.38357818725399000, 736.75747765079893000, 771.33167799410580000, 928.88458229631328000, 952.07296687850430000, 824.13759379970361000, 719.89046504023668000, 833.96191478251035000, 882.17071446592615000, 909.50920371678444000, 1016.27340255893350000, 1145.06543066378210000, 1050.88309010946570000, 1057.69391184424190000, 1062.73981653185640000, 1096.33541205595500000, 1090.20623382983880000, 1126.89472128435640000, 1233.72840865325290000, 1224.74555388221050000, 1219.23841789865720000, 1233.17130061972600000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 351.18158615099878000, 352.08465516363378000, 340.18850417075333000, 417.74684984389626000, 442.83670913028732000, 361.69248465682955000, 371.66671788158482000, 452.15424656324302000, 412.47566810153199000, 470.09039764531343000, 433.12602595599782000, 455.80042943011512000, 431.99945071255081000, 456.61573451389904000, 437.68695300945501000, 435.76118191662351000, 443.16689235617730000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 914.42660239708619000, 1024.40306238277340000, 547.14273849370602000, 670.81877837451282000, 645.03144681094477000, 777.12941922153163000, 729.71280584838792000, 777.78041823961746000, 755.06915007291752000, 787.03942844348330000, 817.34108004004997000, 886.17846181307982000, 863.89905491242121000, 885.08146927492169000, 869.43553997360027000, 807.07581941494334000, 772.69879560706170000, 761.73275206152982000, 821.77418206468440000, 845.84438061418905000, 911.44543378667515000, 866.81300940803965000, 874.55285546655637000, 888.29164681424743000, 882.77978457812139000, 897.59971206835257000, 876.34228836864304000, 881.67940048742616000, 879.40664979050428000, 863.30766192117812000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 551.10453581795309000, 672.57783821030637000, 629.44896075681629000, 501.80066269533296000, 498.68182431205980000, 501.19472374405865000, 444.82418622413456000, 313.72421050646471000, 334.71771751214334000, 354.41184198207384000, 371.27210924907439000, 324.25464758749672000, 273.13876171996770000, 276.93207578078415000, 280.37863393702429000, 287.79600196263641000, 247.82919222380355000, 261.12030148304757000, 247.66850181453671000, 220.03162593577730000, 249.12334633728369000, 224.27638124230103000, 291.62298530129976000, 285.15293334633594000, 294.03026986628549000, 296.28788119283314000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -343.14744086323196000, -415.70652229710123000, -584.67990282176095000, -570.58824553167744000, -581.42428167863397000, -526.53534952364350000, -593.64475275946700000, -641.92757625878767000, -558.26620447234848000, -804.55930968475809000, -628.93672109903355000, -612.66062566081428000, -930.79248664512841000, -937.22065605758792000, -882.01636753944319000, -836.43949682270477000, -1043.66394791769040000, -912.12659761321527000, -964.02834377803572000, -1028.46676279964780000, -1115.32247879066150000, -1072.90247106947250000, -945.38992684045661000, -928.96283787333073000, -938.88812284073811000, -916.04316391889802000, -922.50732449768634000, -896.66118614139077000, -926.27006264459555000, -920.76607373517504000, -931.90068378039496000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1341.14680412106350000, -1498.77782487001220000, -1554.29127440059820000, -1550.35463589002030000, -1612.53203432707260000, -1537.78882573811390000, -1641.90769133178310000, -1604.01365163082820000, -1659.28123121765070000, -1612.40003975476430000, -1581.10847637953910000, -1645.69861293346070000, -1556.61195331980910000, -1744.63508804136430000, -1738.35597578150990000, -1778.06332978022400000, -1781.33663398483580000, -1804.59669799337830000, -1826.14308709831970000, -1806.14834057228380000, -1749.15648599425030000, -1729.40148467449080000, -1658.18018812382230000, -1736.92609366369650000, -1709.03159116648040000, -1683.68029079980600000, -1746.44610358758810000, -1740.26454485210390000, -1725.96465444680730000, -1735.29422797266530000, -1799.42336843393080000, -1790.31573971240730000, -1796.36285875882460000, -1801.47676330379520000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 536.76576356002056000, 527.50778892771382000, 627.35905497746421000, 625.87760551307895000, 569.01735941516586000, 630.24496547486842000, 599.01555259202689000, 595.94410716459072000, 593.55041310305000000, 574.01198494963865000, 540.14815136251229000, 534.31806345219343000, 531.52324686051315000, 537.98423381811074000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -115.81557307943203000, -111.00510397837816000, -155.51701538401744000, -177.89834382252067000, -170.50501134866863000, -175.84533955645708000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 847.02587573457697000, 801.68795496964970000, 956.73626317758840000, 1063.96425012218510000, 1323.61059656741300000, 1271.00503666100830000, 1318.24642845628480000, 1433.14510554043270000, 1424.77923327827420000, 1390.19542628664790000, 1362.39598872315150000, 1330.19735127602850000, 1364.01518955799680000, 1345.40856438138760000, 1355.82871101907900000, 1325.61883043836660000, 1486.10331368013390000, 1507.83324325276390000, 1510.77955202327010000, 1514.90488286825460000, 1380.72656487377620000, 1387.64902701747220000, 1421.45403922086350000, 1305.88780762795730000, 1296.92986993227150000, 1391.21012813980770000, 1439.31833701634630000, 1470.36045360772320000, 1488.68098410822360000, 1508.10987115943980000, 1548.41494295751840000, 1519.00312238022710000, 1559.98624900108920000, 1611.96970948533140000, 1638.51395564759990000, 1630.40313956322480000, 1638.45153728738730000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1154.15257561766090000, 832.47817292847515000, 929.06952978259403000, 1016.37118749864510000, 1024.46659645531710000, 1068.27369692469760000, 903.02121038199687000, 928.72527131939103000, 849.75598972717034000, 810.22952657908536000, 739.63778313626335000, 710.50699490548129000, 769.32112301914947000, 636.14279261824288000, 556.88893207873048000, 553.15479974360983000, 569.95209945713304000, 514.86889688055908000, 509.78999824243243000, 389.57097377110222000, 330.35396149788119000, 245.76164721574193000, 248.82213319460445000, 303.77233896274259000, 285.94017912878365000, 319.40694939010535000, 407.27616964692317000, 520.42999331430644000, 473.75220315206121000, 446.28508642614611000, 486.16562128239042000, 426.33242464099521000, 389.51340753542286000, 395.50484326759806000, 387.06209603545170000, 333.21686306443712000, 315.34589591818053000, 319.27380809348335000, 319.68390539347587000, 315.06012916503744000, 313.91235599516074000, 292.95350803775182000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 646.47181529948602000, 616.28161843084990000, 513.41260049150537000, 512.60925854641130000, 520.43585408140143000, 503.04072672647493000, 489.14725846300678000, 573.92939137336339000, 617.66777761379262000, 630.91289709404475000, 633.40777277735663000, 662.12323956942646000, 659.36239500155614000, 670.65867420525751000, 675.44969782179021000, 675.11249830087468000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1602.55913619800140000, -1494.56954705397310000, -1543.58955702342380000, -1534.54408813035410000, -1376.38056278068230000, -1262.02967279114020000, -1285.05391669310370000, -1292.85461698528660000, -1461.98876244552890000, -1441.46814673512590000, -1428.59081136566870000, -1294.10987450687230000, -1447.04158295932920000, -1408.19981373451560000, -1418.99395477964730000, -1517.19314625845570000, -1540.79402639425390000, -1378.55388448364810000, -1427.55322125083330000, -1434.87450183156600000, -1428.88144181342020000, -1505.54189412572170000, -1393.27874886030580000, -1404.42123628864150000, -1401.35720377278810000, -1460.01762929968750000, -1358.26593051526400000, -1331.83594225244200000, -1237.16005196599420000, -1213.14661965258480000, -1195.94968048993860000, -1132.41107017728650000, -1138.06354099005810000, -1171.57203148993270000, -1155.70770230247190000, -1119.89723219169760000, -1098.75505344809650000, -1059.64124277663790000, -1067.99949593591960000, -1050.21641075949150000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -814.02218012393996000, -873.55513250135800000, -812.12015573324720000, -778.70111381423203000, -673.97928407182951000, -639.39307613814287000, -694.21237723191905000, -683.91889060947244000, -720.11156263776672000, -740.15726025986726000, -797.84724116712641000, -833.78924751959005000, -820.39055191185321000, -875.97583784671519000, -782.66659308919441000, -815.56142513395730000, -826.66676000124801000, -885.34576954558918000, -908.16128386322237000, -956.16330061448332000, -951.59865751558766000, -875.71689513805052000, -900.94318579568255000, -900.01301414298939000, -910.24601801240885000, -856.58987003407844000, -866.93211412294932000, -867.85779391466997000, -866.91927957248413000,
-3778.94975614819940000, -3647.86906533646380000, -3277.60519293438850000, -3085.87426724283160000, -2925.52149721334080000, -2726.44313781864590000, -2811.18084299265550000, -2761.83937004769500000, -2587.60608244407690000, -2495.90479400482170000, -2687.96879723661280000, -2605.83218052826170000, -2426.11582954542750000, -2397.74466389768530000, -2282.49211067431450000, -2314.26584654464390000, -2354.51444692820410000, -2268.56063570551170000, -2307.16429350090540000, -2279.27464082452250000, -2176.00178652741440000, -2168.43181018494350000, -2371.13719999193060000, -2377.89702704397680000, -2393.02841606877930000, -2299.19519956169730000, -2325.49271465682840000, -2237.36924547262290000, -2062.93213331253450000, -1824.72268265323920000, -1832.88215478986650000, -1807.30909117891610000, -1860.35739085924870000, -1895.82288871455690000, -1843.44473989131960000, -1904.32611350667070000, -1902.90710279797280000, -1926.68251442941300000, -2003.91930032702570000, -2019.08301635104430000, -2050.40856814590780000, -1990.93696007095240000, -2056.45901134553830000, -2077.15419641833200000, -2118.03609799528700000, -2101.29014913433960000, -2127.32854508705400000, -2098.25131457073620000, -2104.26039908451680000, -2117.69048175234550000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -40.04727011079783200, -40.76477496462017300,
0.00000000000000000, 0.00000000000000000, 2807.06747311878550000, 2770.25758417437420000, 2751.44105750928930000, 2262.75534897620080000, 2639.47219873258700000, 2553.16529114746980000, 2317.40084120815940000, 2154.78032742203230000, 2004.70939324414050000, 1988.73619752349190000, 2035.09201933941090000, 2003.26800874529340000, 1990.67896599117220000, 1917.89830025077690000, 1942.86697467439100000, 2052.16485462390760000, 2228.16336704372950000, 2185.00589794344210000, 2276.07633681836480000, 2222.29975891919910000, 2174.60063041113240000, 2196.48080762511020000, 2141.62424814217000000, 2057.62904454169890000, 2031.41587915442640000, 2075.27626209879140000, 2083.57411896638950000, 2242.35890232103610000, 2272.52491713161090000, 2136.67317355009300000, 2113.49870890435070000, 2169.75605594591530000, 2018.19369809243650000, 1952.52843498120980000, 1983.66987139108050000, 1974.57362557402440000, 1950.03582418639010000, 1892.78218742993840000, 1945.34373979529210000, 1866.91773255849310000, 1800.54778847949000000, 1797.36628127546670000, 1822.58833596324120000, 1835.51355556404700000, 1817.59014026024690000, 1838.62741428169470000, 1832.28913699643230000, 1826.20099763662280000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -567.07761065281579000, -497.22257030657642000, -415.70863283394789000, -412.30810750208622000, -413.52730975175734000, -403.71983131865403000, -396.08672589193884000, -411.77887380492746000, -417.51780099907882000, -419.74790466108266000, -438.24852458983872000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 415.63465541388888000, 456.24761487649471000, 478.77964477204614000, 494.16105074838447000, 558.94642906830506000, 566.89508939404300000, 571.34707689553341000, 572.38935930861555000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 254.56711973127088000, 325.49410344513888000, 318.61392317509791000, 146.14677797384891000, 163.13744665376535000, 195.64425199837575000, 199.68095029369331000, 188.79234813716911000, 170.23332828632596000, 294.16113154849052000, 318.13518928059375000, 339.55259368484252000, 357.89736668857290000, 313.37909905736342000, 292.85545555344731000, 257.00740532941114000, 195.54420962761759000, 188.11126406281642000, 182.59473187788296000, 216.20262271725974000, 179.97188246933433000, 180.45844815022599000, 184.87118817449308000, 174.33070331815665000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 758.78823655295037000, 850.86313848419320000, 849.56457071963962000, 990.10708527811482000, 1113.11037852181380000, 1020.42468439040570000, 1029.44940085186430000, 1052.09059800484240000, 1140.17504330674000000, 1122.88545585919930000, 1099.51534542963030000, 1099.54791568191260000, 1123.24696522634780000, 1095.55641227819180000, 1090.71185085260530000, 1043.04354789061470000, 1040.99435743522940000, 1036.35878423839560000, 1045.48443318462110000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 263.17906051892470000, 260.52388510376306000, 225.83017615557165000, 264.78632026003032000, 262.68386080325928000, 267.34919483207887000, 246.87555702046077000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1306.40387629209140000, -1338.26243111485880000, -1398.08368968055270000, -1437.03806065179580000, -1214.71333759284080000, -1299.47030391812450000, -1389.90659470832570000, -1327.37746236841490000, -1379.48730253948570000, -1292.64948500100080000, -1285.02926648215070000, -1352.75585871460110000, -1298.13242269548690000, -1134.29428168570460000, -1122.88769823466600000, -1059.66088866994570000, -1131.86244218712860000, -1233.40179129520130000, -1249.38351733988930000, -1203.73174582515070000, -1153.28969589164030000, -1162.30648815110730000, -1121.34543871870760000, -1030.97065608883760000, -1195.21084262531120000, -1178.24306332882790000, -1210.25667940119590000, -1152.73411437892080000, -1140.56292625552580000, -1156.42341729040640000, -1154.04023932009700000, -1159.41922218397920000, -1160.14624340373870000, -1194.40587768464120000, -1165.99224776309940000, -1157.56078848762970000, -1152.38773574646420000, -1149.49586913534400000,
0.00000000000000000, -3408.09497141716930000, -3408.70104123548570000, -3270.85951436616780000, -3114.85786603433280000, -3086.48795877982960000, -3114.18106622366030000, -3060.81346560772770000, -3110.91399279310780000, -3104.31326023407560000, -2943.03972482507700000, -2995.53643411883970000, -2941.29935533175470000, -2947.33039288839200000, -2931.71545165471480000, -2909.90665023747400000, -3005.23666576981580000, -3018.60790077441700000, -2944.37836265092530000, -2901.33128137251830000, -2832.20182141743590000, -2846.62831691753540000, -3020.07462573069820000, -3089.48927829043900000, -3112.04683443097430000, -3041.31607555575970000, -3070.00085024059670000, -3128.65207213796980000, -3194.45469120948700000, -3307.51748970238800000, -3328.68790250827490000, -3267.98876315352620000, -3262.98129807138820000, -3241.85967379635300000, -3267.69827727908480000, -3360.60385753019590000, -3442.35901034112840000, -3438.78339292416970000, -3613.03226436048450000, -3585.58290755321790000, -3540.17196035854250000, -3617.51598223276460000, -3635.41304827518660000, -3669.43455627892630000, -3684.75257228042210000, -3693.11481410050560000, -3696.51886701620380000, -3711.80074550421750000, -3710.65994741395250000, -3699.17166685979240000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1314.83823910653860000, -1322.76818086397360000, -1322.48602836673420000, -1282.41062012778530000, -1254.01042381647430000, -1218.25005800578790000, -1260.14692224101960000, -1171.15311850424770000, -1105.64285610099360000, -1058.34645296547180000, -993.60768880418163000, -943.89940915651880000, -934.46914995213524000, -929.17620791141371000, -1027.21969884295440000, -1036.96286626351230000, -1006.11444553604000000, -1069.33963254106420000, -1061.99057114270660000, -1061.84189744092530000, -1069.61566331036830000, -1110.92087894189880000, -1151.53037213665970000, -1145.55403379614880000, -1144.98522319931520000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -312.69653944827081000, -317.45513627686933000, -362.15375003229354000, -385.17501326656344000, -370.91649787664210000, -369.83867941642626000, -343.87123131500022000, -334.43993968529651000, -333.35548584714161000, -327.74073905680768000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -666.27066141722980000, -617.40757457039240000, -673.80683134391950000, -729.08488612982228000, -780.16030335648918000, -816.35891555447677000, -838.59738345706819000, -862.93987154106969000, -905.59618413404542000, -920.83164146007618000, -925.17717147571318000, -931.37919706532944000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -339.35571109387246000, -386.86067307190547000, -390.17332325428055000, -417.92925348220803000, -355.63913041812049000, -441.89762426731261000, -381.97638270185087000, -362.55560473920661000, -366.71892778943351000, -407.45354701000105000, -395.70820856928577000, -317.27412864051104000, -266.06061537562573000, -285.87951694281946000, -283.80325546046373000, -258.38779250094478000, -240.82506617090294000, -218.82746328812522000, -215.28880456437798000, -200.36244079037655000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -79.63482720037622200,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1329.51719854187060000, -1326.55384921817650000, -1382.95450507164330000, -1339.73829877910570000, -1335.77287189948040000, -1299.95714808245020000, -1250.59649890187370000, -1243.41194415408110000, -1209.22904444585470000, -1083.71084294260300000, -1151.42289159157210000, -1298.20969694926340000, -1278.15213839559870000, -1211.74720380035800000, -1203.19895762691160000, -1182.95845110002350000, -1287.05132135443730000, -1281.11037865678080000, -1306.49307429784990000, -1317.51120609744660000, -1324.24552392668600000, -1347.63455538369660000, -1359.45308580722210000, -1334.60519815610430000, -1211.78234839452600000, -1269.87033098602960000, -1251.30745943852210000, -1191.53229940369490000, -1282.06583842304740000, -1319.44303941027870000, -1378.41119148318880000, -1292.68541394231690000, -1246.96074991318160000, -1257.26387659845140000, -1250.82355390998440000, -1279.51318505249740000, -1300.05902694146680000, -1296.43347453913130000, -1308.84664026230260000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1679.23567581432390000, 1728.67991369774290000, 1598.39569703829030000, 1747.92818407061510000, 1542.79796229576030000, 1725.45386833557950000, 1592.19826915341420000, 1469.20594862441770000, 1388.90496924569970000, 1270.05985457450060000, 1256.81792662670000000, 1187.63251207901700000, 1184.40335797123000000, 1054.64402210757790000, 1004.47434310667120000, 899.41003439930239000, 1204.23462806394810000, 1195.08852944641740000, 1162.26666273081630000, 1243.09659169595670000, 1009.76171131441080000, 999.63505678697686000, 965.68781823009624000, 854.17791916363285000, 883.88765177930952000, 791.99730513236398000, 786.24715910320413000, 794.33762933789353000, 786.21551790631111000, 778.36944947910774000, 832.36122995062044000, 785.52706917455055000, 829.05064874933862000, 872.20270402855613000, 828.12344164186129000, 836.07275027888852000, 815.93615998254415000, 782.06082797212855000, 789.54559832540804000, 785.28145116378209000, 777.59083920408295000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -2014.48586599585810000, -2075.42669629389870000, -1978.10105584326040000, -1905.31362499200210000, -1793.54894916293030000, -1756.90590586866300000, -1659.77717194111210000, -1598.06949543251220000, -1656.08144336197690000, -1513.43562166786820000, -1384.14842185506150000, -1400.03935596294290000, -1520.50805617732410000, -1459.65689919379360000, -1331.22648038470490000, -1251.77562749667570000, -1341.22693686469550000, -1347.75439572675240000, -1265.11448668551610000, -1249.00044157287130000, -1200.53555738817430000, -1221.03196242070270000, -1128.28028645382710000, -1053.05368180114670000, -1028.24098474938090000, -827.21245258519059000, -811.44555789138792000, -853.98545267393604000, -831.39784133385911000, -727.71907414280997000, -735.32253566154111000, -716.14306890488228000, -609.39859466287930000, -553.59842022174269000, -623.35831500907170000, -798.60833581854513000, -845.73903989447240000, -825.34149637739813000, -845.98156579466888000, -809.56525112441943000, -828.84669335790818000, -826.56721459549919000, -829.59350559264112000, -825.84762429908847000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -565.77235686554877000, -523.29593795195092000, -492.29537976412934000, -494.37429644842729000, -495.04658476342161000, -520.89503695335350000, -535.77690706166675000, -538.39117600443797000, -549.87574828251252000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1344.87740050030990000, 1350.91111091913600000, 1477.55565086203020000, 1433.80642149895930000, 1402.44332943431030000, 1289.68574696875130000, 1289.72566267745790000, 1295.20242169205520000, 1275.49962910545510000, 1243.97518190406280000, 1238.64919286747570000, 1224.17408629422270000, 1210.07030113930660000, 1218.00894514563170000, 1206.23770740549280000, 1176.77835105637520000, 1170.03616572511620000, 1062.72672012022710000, 1043.08541526104090000, 1176.85644217925230000, 1177.63260848588720000, 1210.69403466632890000, 1209.04426813902680000, 1177.98278589504480000, 1276.05619546971620000, 1242.38540741838410000, 1249.32963400842250000, 1261.69309798778800000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1600.93850760536410000, 1628.69893005076410000, 1701.47460976181330000, 1689.89794832040800000, 1693.55510456187560000, 1689.04900267886500000, 1592.88915525721430000, 1608.85492345879150000, 1627.28738228150860000, 1470.96020373091640000, 1469.88288483690080000, 1694.97408588527990000, 1620.41104327292120000, 1605.81237843485360000, 1472.93408355887030000, 1680.92438100496320000, 1555.86950969567900000, 1567.35179013904050000, 1520.27599847478200000, 1481.28381279142100000, 1532.41139802602580000, 1467.10239756875380000, 1485.86962735243610000, 1502.14764238765360000, 1321.89324019016570000, 1347.11971147950270000, 1420.18694710271960000, 1440.28694639892680000, 1413.31344587229980000, 1420.74704775230320000, 1389.02089013138490000, 1311.49436418981080000, 1360.86741100391190000, 1340.73300484797120000, 1298.30107896534970000, 1346.74985437907570000, 1243.06679264281570000, 1253.71503177148790000, 1242.64882171516160000, 1281.70617972598260000, 1251.33168651240630000, 1248.46774748532400000, 1262.28713053323420000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 2230.76423984689250000, 2418.31761076944800000, 2574.97203514615060000, 2387.71138193729170000, 2244.53853042025730000, 2247.46718920732840000, 2238.51804448505390000, 2115.54039943326920000, 2050.46113507246040000, 2076.55131701787240000, 1973.89374435766100000, 1979.90521902682740000, 1929.90298133927790000, 1878.96640791138590000, 1921.85766589209170000, 1756.77770803002110000, 1818.46641006242950000, 1921.59574525916170000, 1961.80551963058130000, 1482.15206927681040000, 1423.63938184039580000, 1428.66596116715690000, 1865.58136775317420000, 1894.52271608789510000, 1885.71758226661020000, 1865.23680698268710000, 1641.70096857935280000, 1616.23064943249460000, 1846.23083936584590000, 1846.79398143478310000, 1829.96923441294230000, 1877.03657608708250000, 1849.96574555060440000, 1895.77622749674810000, 1935.58528929328190000, 1777.59342162590930000, 1833.74857310153400000, 1859.04267757372900000, 1813.98398435553010000, 1814.00825661881160000, 1753.33576499726410000, 1726.61380149613550000, 1709.02452000548740000, 1667.13911799092990000, 1691.31091726220280000, 1686.25617848507410000, 1685.10405054198400000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -648.53144010821256000, -504.84190778487454000, -590.12938187950112000, -603.00026544284026000, -555.14526354048860000, -684.45169757446399000, -735.80997081518365000, -687.45157240466028000, -523.65592921164318000, -540.21860912242812000, -530.80415936847646000, -598.79444736685844000, -593.63850238441830000, -639.21158739961004000, -713.44161024704033000, -668.50515820472810000, -630.51804556104253000, -636.91919342639403000, -647.95352493660675000, -637.24071256737511000, -651.37507135612816000, -649.91416706193093000, -671.26723925570150000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 130.16149200341675000, 127.36180816052128000, 133.47271107504082000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 145.09481386411736000, 133.93119681212258000, 182.08987002369358000, 205.53331351171079000, 315.38451390839981000, 256.17401484897806000, 248.69358340376334000, 268.83006588373962000, 290.05401217258657000, 330.40260538059863000, 366.64433076988860000, 361.07048271629884000, 372.54557647634198000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -828.34904210505442000, -762.38247515947364000, -849.18695656899160000, -733.37378189843025000, -794.49391634587437000, -800.53407720588700000, -574.89128080874752000, -662.39012256473234000, -876.69154157060700000, -863.97177130534533000, -777.50697698594240000, -1016.12897568618450000, -974.49704892481850000, -1243.84207454471220000, -1308.71488408014990000, -1434.19613881801320000, -1428.40369439795270000, -1342.35029678676050000, -1316.71177177438130000, -1323.40864588442990000, -1354.59400189895130000, -1089.16463245596130000, -1201.95996422260850000, -1199.85877574371830000, -1168.86210934590990000, -1180.11639186231170000, -1183.02845863317500000, -1297.51419272712020000, -1249.29747085088180000, -1255.18365008469640000, -1238.87486437529920000, -1244.11899752004910000, -1235.42770027735540000, -1262.73750170361310000, -1254.38749992935750000, -1270.09797024264750000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1613.37706349930840000, 1277.20399787052020000, 1356.02150689273730000, 1292.24337623086850000, 1572.34603848484540000, 1688.17944858522580000, 1694.15973073886060000, 1542.78957253263430000, 1612.28886662318520000, 1514.18304308325810000, 1527.95705386537910000, 1724.91112761665930000, 1668.40654392579360000, 1570.21616636407090000, 1614.52335446510280000, 1568.39716870833190000, 1535.42379741275450000, 1443.36323567515710000, 1445.61893517118050000, 1507.21150371616450000, 1580.85518210414260000, 1611.37229587485900000, 1589.58210462601010000, 1648.10100490314080000, 1570.02166750050040000, 1547.50286243432060000, 1653.93861771551020000, 1674.48735794652000000, 1649.60219478036020000, 1696.97922887119900000, 1869.20196515538030000, 1800.88391049651570000, 1794.61098212176260000, 1757.81570177388740000, 1782.86550585452480000, 1685.08150565496130000, 1651.73622457626990000, 1731.98026271759180000, 1754.17311625752790000, 1737.15719322276850000, 1735.12263895648180000, 1777.77429105517670000, 1743.29381718612060000, 1747.21182665071230000, 1738.47133502968180000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 651.11904572874698000, 541.26923352907443000, 530.40266569359278000, 555.37200204189764000, 558.65951151690808000, 558.73248527271301000, 472.99835994067502000, 588.17020528377725000, 645.64682479577141000, 613.66011596657734000, 647.09769844304969000, 636.92259880153540000, 621.66727503120228000, 630.81874569143929000, 613.61756163939594000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1294.35398496517700000, 1269.11315634204700000, 1268.62657185182980000, 1233.91005721033640000, 1383.92786987503720000, 1240.01035381083560000, 1268.18524274048600000, 1089.52834203519610000, 1082.48080955289740000, 1085.69858149723500000, 1009.83377065997500000, 1204.50046304979580000, 1118.97794107699130000, 967.79363814131898000, 1021.93550342481810000, 1035.21610196110760000, 1147.77267813111920000, 1093.70186178282890000, 1135.50628745859130000, 1100.45619009604730000, 1234.12731671472420000, 1127.56217736088730000, 1135.76966094749200000, 1210.67656564875010000, 1162.81185838659690000, 1128.05216815734640000, 1126.39525373686460000, 1138.17180803656790000, 1156.03707687086650000, 1153.61187973465530000, 1156.67480998129550000, 1169.10470030660740000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -285.80539266995351000, -296.94807032498227000, -300.12582113604958000, -314.54695297310809000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -781.88494021206191000, -738.60440723702175000, -655.98618306350284000, -653.73671964546247000, -597.30433617911490000, -736.71314832076337000, -839.91914957711572000, -911.77699374527811000, -813.10351818692743000, -783.95543081166488000, -788.57643293927686000, -804.05604144754727000, -974.88899705812548000, -1035.88267060019530000, -1024.49152126434680000, -1087.27355727032110000, -1046.73732524338560000, -1051.32137607321330000, -1068.93812601099280000, -1117.10883869004490000, -1167.22021429713370000, -1155.95857630346200000, -1177.66818037334520000, -1192.67661521916920000, -1176.22648081628770000, -1176.24298918051550000, -1155.54006424789050000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1082.45972992343490000, -1005.51456132763710000, -981.24314760621257000, -931.26666752031463000, -890.89385445310290000, -1091.66142361199970000, -1029.59596926289050000, -1016.85451545939680000, -1005.12797186402640000, -1137.98585285995500000, -1222.49463350937640000, -1252.55672191173970000, -1346.87501473912200000, -1361.03218041877130000, -1405.20856517958050000, -1400.99230546182480000, -1440.86552059498740000, -1422.96479768189970000, -1446.95232167176300000, -1453.25441505810820000, -1444.73770757897320000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 451.46086066276644000, 369.92500595106259000, 443.37745770774666000, 474.02765860858142000, 558.55334434106987000, 568.23539449579323000, 824.01874876849593000, 782.04518519533826000, 744.48292185132061000, 834.28569907836857000, 772.79716562665089000, 791.62477018010247000, 795.86605785160907000, 816.83491953445309000, 814.60807269213319000, 834.80307808818304000, 840.29693594284720000, 843.58574832186446000};

double nnlasso0[1200] = {
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 85.63725683745056500, 141.75705237535723000, 301.04490780354325000, 316.50050741447836000, 342.35775666390754000, 477.69270149639942000, 606.24269821852465000, 655.54871101505887000, 656.08803081531426000,
0.00000000000000000, 0.00000000000000000, 37.78033308833145300, 351.83964317289218000, 395.50104605569373000, 497.86196023093891000, 769.08314528771189000, 837.97053529697553000, 960.31253150511395000, 1110.47469794233550000, 1409.55457648868490000, 1450.32019910342910000, 1664.65914313155210000, 1699.10628271111000000, 1704.49109412902410000, 1760.11724257557400000, 1800.77141754271790000, 1924.68975567719530000, 1933.46597067798670000, 1951.29191761745620000, 2062.30756216817370000, 2174.12437385490690000, 2223.98269869774280000, 2224.92912628278010000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 254.21739515884227000, 285.81565020246779000, 430.97385649134662000, 455.81462453289987000, 458.07236091688691000, 500.01802937532165000, 509.21879442111543000, 543.36076949339940000, 546.16610749417850000, 551.73025252753325000, 573.81324554134096000, 574.90365350328716000, 575.68860129421353000, 575.52826775471715000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 58.42025256818439500, 254.89255649166836000, 273.80451893152730000, 303.67802020020940000, 472.83027855336240000, 627.60434189212606000, 688.14582373320491000, 689.06125679835407000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 156.52660748021799000, 350.07472430361628000, 698.14170638229064000, 740.08937895721522000, 982.77758823689283000, 1019.37931121425460000, 1025.25384258470310000, 1090.55225157337780000, 1137.84835167560550000, 1292.87512216212460000, 1303.42297017387860000, 1322.65966231514240000, 1416.74965513995560000, 1509.16552862360340000, 1535.83263225997870000, 1536.39727168378950000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 119.62045290751925000, 350.03791639988907000, 381.22240289260719000, 565.21580914440801000, 599.84348658631507000, 605.94993864829507000, 682.26633874403262000, 740.41274083685641000, 896.81945716356029000, 909.99259039371589000, 928.32657208855198000, 1009.45489956987070000, 1072.94119344207430000, 1089.75179737814320000, 1090.08772680619680000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 28.12527954532683700, 267.30744958721056000, 469.34399071101814000, 553.64275917145631000, 554.85957402777024000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 39.65042062783857800, 123.86548570008634000, 220.03287448616862000, 451.54427028961300000, 480.68480022677517000, 641.12471924503495000, 667.97858293187187000, 672.75907767619969000, 726.72134389499354000, 743.60972484229717000, 780.38066762348535000, 781.83311786952891000, 790.21395181640787000, 871.25338623505843000, 935.95914531029143000, 959.04706428924214000, 959.07043708357071000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 31.07841690684126600, 110.79003699605899000, 264.22892479600063000, 308.05704583335091000, 382.74985648779477000, 475.67083990318071000, 671.00167868962933000, 691.48716866125687000, 803.63953659564095000, 822.03017153074200000, 826.22188809873740000, 866.70129070814494000, 899.18710181550148000, 1026.79147352350610000, 1034.64717270432630000, 1052.96007466447650000, 1200.14966204530360000, 1343.80910544321700000, 1399.22232470834460000, 1400.47439783250890000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 8.33799728388278540, 104.62328225640765000, 168.52750066444810000, 418.17688290202813000, 437.11642472777157000, 472.24998591063849000, 682.64857244860650000, 883.06502467220355000, 966.04191205051950000, 967.16159615381412000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
429.02139665452466000, 668.71490684001958000, 704.98170480954536000, 929.41126432812541000, 955.38566898203669000, 1013.40245420004210000, 1140.42682683789710000, 1174.44631208885430000, 1244.83449846464210000, 1322.21646825634980000, 1463.67237118101020000, 1482.77288491699510000, 1611.95836661366370000, 1631.98909733930510000, 1633.36861089725610000, 1654.64340348051840000, 1675.66813758995860000, 1712.14967254878620000, 1715.78745660017830000, 1716.23764449036090000, 1697.00390665300940000, 1691.76127943543750000, 1687.68891334214960000, 1687.62709060572050000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 140.33613649393953000, 203.17803445976725000, 204.53961192208351000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 42.96746290369154100, 43.96105262187621300,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 235.77382674918255000, 253.22471184530187000, 288.63441895560919000, 537.22910661292644000, 762.23508756645901000, 850.41213982024385000, 851.53406951006616000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 40.45183264701477600, 242.22508707753198000, 265.90856699009754000, 269.52052836738778000, 310.64750806491736000, 338.38711127219807000, 426.01581453940287000, 434.21075388117271000, 452.29759951116233000, 570.98134608248665000, 666.57362796716336000, 708.34200676124362000, 709.07466349875676000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 2.25218593225976040,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 268.98276397169110000, 333.51136523423861000, 428.35123629387317000, 532.09934244250280000, 718.41938740515548000, 736.72403709512821000, 821.95700620109903000, 830.88128475176768000, 831.67267054674846000, 844.02814744318744000, 858.67762164702265000, 888.41852939099022000, 889.71480196850791000, 889.07431880104082000, 899.99855483638851000, 895.77688167504596000, 891.41555373333188000, 891.56868418615682000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 89.91916785933365500, 336.49804695868477000, 400.07215659014116000, 506.97639375306102000, 636.98251490516532000, 911.69130311615220000, 951.76132490488658000, 1206.35304946736730000, 1250.11945179064760000, 1257.98337343609250000, 1350.80384343165930000, 1420.61515347241490000, 1621.35027663712570000, 1636.17763627621230000, 1662.51875537206800000, 1855.37959443090650000, 2004.80476064094520000, 2060.16927437130790000, 2060.83571700946870000,
0.00000000000000000, 240.42662670366386000, 280.37978834143149000, 640.15018794377306000, 691.36507998205957000, 809.81571699314202000, 1115.21286970308670000, 1194.40234190637120000, 1331.17915300008240000, 1511.78645730677040000, 1861.53866118616680000, 1916.53056993130370000, 2201.08689241458750000, 2244.93849212347640000, 2252.90744232728370000, 2341.51838771852230000, 2403.23605430469570000, 2650.06691456460610000, 2671.12592899697170000, 2714.13198332598310000, 2969.85019612930860000, 3202.89625580172110000, 3300.01223331144000000, 3301.63453963993740000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 14.43092790465246400, 37.82084759158136900, 139.42477555584821000, 224.19995439754291000, 260.75295721663474000, 261.35143797989110000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 257.98154946163061000, 292.26178828121135000, 381.42124120094843000, 655.64497548113286000, 734.17120922457502000, 844.44816180555461000, 993.53339691400618000, 1306.05666705540850000, 1348.76502722316950000, 1577.68506030701590000, 1616.76251165560640000, 1623.71414812551980000, 1706.87795441360530000, 1759.73802137113600000, 1942.34846658995730000, 1955.35876448536900000, 1980.85727287292660000, 2180.13805321874360000, 2359.63522517238060000, 2435.27353038711500000, 2436.53467732219040000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 232.14120223275694000, 436.73171911577242000, 522.76325530431552000, 524.08531578201757000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 180.59417945012899000, 219.39275621384303000, 226.99781080078154000, 311.89337750460481000, 367.82839932583067000, 522.85717623320363000, 532.07925938062010000, 549.73453936481019000, 684.42191507809343000, 823.58566515859479000, 881.06171019862597000, 881.76566744098830000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 45.19208878808579800, 53.63259976813373000, 151.11116205841705000, 198.71339246660341000, 392.97817850638336000, 407.35069167917050000, 435.15144126490327000, 622.75379580099150000, 800.01938954756145000, 869.64034993880614000, 870.87068417633145000};

double nnlassolsq0[1200] = {
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 739.95332606746956000, 731.33860104305484000, 660.26054422357186000, 751.21625184551283000, 712.89036594696233000, 650.23911123778123000, 658.97921305478883000, 656.27366892213456000, 656.08803081531426000,
0.00000000000000000, 0.00000000000000000, 2626.82440346584640000, 2577.69285964830940000, 2504.21503764279850000, 2391.46307164972630000, 2417.35999845274410000, 2286.82204513069560000, 2405.14049653480790000, 2362.08540874883740000, 2320.26361231856120000, 2347.56969670371560000, 2288.46030753426430000, 2280.53623020132090000, 2249.57379872098410000, 2185.13182316913570000, 2227.87474547174090000, 2204.14235159187360000, 2180.31235214458410000, 2206.73651532804480000, 2203.84787842618740000, 2219.99624549102870000, 2224.71577737878580000, 2224.92912628278010000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1028.31854820720040000, 981.29180497324103000, 853.43491934761767000, 875.09955310177111000, 686.61389355909307000, 820.50616643748526000, 605.87989684731053000, 620.35553642813625000, 625.07114049765653000, 631.46406944480600000, 601.96814053607216000, 575.35098385823892000, 575.70014256626939000, 575.52826775471715000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 672.16986894807644000, 697.96414850391875000, 805.73650718504666000, 731.76324561334002000, 688.49235248857815000, 691.09905130995048000, 689.03597938517146000, 689.06125679835407000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 2005.06616681430610000, 1963.30994739737660000, 1758.01824235580600000, 1663.35574235968560000, 1689.08501277850250000, 1637.17626412606890000, 1619.90891944803910000, 1589.46825932853430000, 1634.73020373757160000, 1642.48143629549050000, 1600.09962562572720000, 1598.32014206376310000, 1536.71047142881780000, 1547.07833459287740000, 1536.22472495909390000, 1536.39727168378950000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1116.66414002806160000, 1051.66741764024660000, 1067.59153069772010000, 1100.70086335478600000, 1184.32071524723850000, 1224.08141012971830000, 1265.36590045945540000, 1351.28534767280980000, 1249.53773562009930000, 1280.50997974071720000, 1191.05127301880730000, 1112.89013318636830000, 1098.98589172338260000, 1089.99896764308550000, 1090.08772680619680000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 431.15860749978134000, 572.25473992645641000, 552.22771937788445000, 554.88222379830279000, 554.85957402777024000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 873.58493004183651000, 1118.42405809883210000, 1021.59385812630840000, 1156.50483494060220000, 1122.06653731002760000, 1108.06090181359130000, 1121.24235879013330000, 1156.66924690832050000, 1139.02294278955400000, 921.03513592875936000, 863.30411195891361000, 822.68581888742813000, 910.31072778624889000, 974.57528490444929000, 962.50411855396226000, 959.38653139421342000, 959.07043708357071000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1532.07216059729310000, 1585.39598019345250000, 1196.71422119012350000, 1229.85767334443490000, 1264.85301783076220000, 1250.17283904683610000, 1265.79114003241120000, 1142.37187018647230000, 1130.04208572274090000, 1132.44392533261200000, 1250.53242127075050000, 1175.98634464723840000, 1240.47549459776770000, 1314.55657319072040000, 1255.60243832859460000, 1315.38270444165550000, 1387.81024656995710000, 1402.74413898118040000, 1400.03707830905750000, 1400.47439783250890000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 852.35977588496394000, 840.29618345054462000, 839.89038953958914000, 981.16997161725681000, 969.82413139840753000, 975.71150932774628000, 950.89799440478919000, 965.28412599950889000, 967.26194074879754000, 967.16159615381412000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
3328.60184092859480000, 3243.83605031792330000, 3190.30490233266120000, 2520.02565112050840000, 2209.87102447717730000, 2086.67001784914780000, 1912.38471487293260000, 1889.95001404340930000, 2076.10113817552110000, 1967.19985197103260000, 1894.41070634118640000, 1903.17432255678950000, 1987.93322396732170000, 1970.08586984786260000, 1773.01119497879380000, 1817.19460106484390000, 1896.54911510880110000, 1794.42046314099730000, 1818.10648929959260000, 1722.68880609721960000, 1672.48169316373150000, 1689.61053734994290000, 1687.62903638531630000, 1687.62709060572050000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 197.90781236316857000, 204.10201367126774000, 204.53961192208351000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 43.59922362033184800, 43.96105262187621300,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 767.47566302054088000, 744.06134688420332000, 796.05309458370414000, 854.17696430882052000, 854.54182856509067000, 851.70862776620288000, 851.53406951006616000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 930.79482734513999000, 829.45570739152640000, 665.65974081819343000, 635.14478586045857000, 624.88040959361410000, 629.81294526920533000, 623.63038049720933000, 664.70774178218664000, 711.48085757283718000, 722.29817257460115000, 705.78952777570817000, 708.95613706209474000, 709.07466349875676000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 2.25218593225976040,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1903.65618987714220000, 1690.68807571967890000, 1548.38607431995820000, 1396.84606235482100000, 1285.77065599750380000, 1139.60854331966990000, 1070.01470572409810000, 981.51332190885466000, 911.78145728507241000, 938.43083355077079000, 1012.58159805104710000, 955.48829484322960000, 926.17473317185033000, 879.89623891504323000, 913.92650012354034000, 894.04497708551685000, 891.35142810245316000, 891.56868418615682000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1753.35718585883390000, 1835.01763647291730000, 1737.17383388527060000, 1769.48833748803170000, 1720.59137301530020000, 1748.18948835548510000, 1833.70067999696560000, 1947.30385964086670000, 1988.84833654721140000, 2054.01639047696880000, 2060.00363934364400000, 2154.03657623130680000, 2074.03510201587910000, 2053.22303378326480000, 2039.98518638613270000, 2101.26911986353980000, 2066.10513166919780000, 2060.98331184308380000, 2060.83571700946870000,
0.00000000000000000, 2823.42392771753480000, 3018.32537471966410000, 3189.97461738642600000, 3164.88980177469240000, 3001.06478603177170000, 2971.18535846328130000, 2859.92902754848550000, 2946.47862301666780000, 3017.15922784844360000, 2926.54675842938200000, 3126.89997750682050000, 3029.24514479421900000, 2985.10541533679630000, 3059.57207600400120000, 3018.55508436566970000, 3051.62753715417470000, 3206.70385539115200000, 3263.44750605650780000, 3330.40579388412380000, 3295.88025125889270000, 3298.50136896258210000, 3301.44015237862550000, 3301.63453963993740000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 420.32599020059041000, 372.99679337437448000, 268.96554573575531000, 258.97823203838948000, 261.29040461742977000, 261.35143797989110000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 2086.39116261995650000, 1947.89386743897030000, 2030.80509540587240000, 2322.16904773563830000, 2385.74854878472340000, 2146.79101974114840000, 2236.16782016504790000, 2257.70131599747540000, 2288.77408990816090000, 2243.92228490617210000, 2276.34704502991460000, 2327.40022258201320000, 2342.29549161839300000, 2315.07361803146890000, 2354.15969425632150000, 2321.29612552258730000, 2346.24915019630730000, 2434.21273601180430000, 2433.27237424413400000, 2436.38565818518920000, 2436.53467732219040000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 528.11155229930989000, 520.66319405997308000, 524.02819722276115000, 524.08531578201757000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 706.18629681430468000, 874.27019235975649000, 996.82676136108682000, 960.54252335636954000, 955.46875820497746000, 872.46801511669605000, 791.46646153081304000, 802.73349130511576000, 856.14270120306821000, 880.67637972823104000, 881.90679401205773000, 881.76566744098830000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 807.98499791610220000, 908.03142566515578000, 895.90136281224295000, 698.81137848185949000, 831.07151941862571000, 811.60273757407288000, 833.53427714423651000, 861.93897280237388000, 872.74105312552854000, 870.66400330015426000, 870.87068417633145000};



// Data from file x5.txt and y5.txt
double x1[5000] = {
-7054.67658600709, 8484.51549339579, 3228.24264248921, -11909.7160575963, -6593.21459226395, 9418.91755847784, 4515.55863251987, -20400.4208212937, 7933.67363555387, -9425.5560631482, 9188.2199226505, 4453.43570598148, -4856.41276605415, 1861.83476190500, 8636.66188882458, -14553.4354695762, 5680.4621684432, 3342.46270232118, 7653.23901452694, 4004.28088591436, -1271.08219037372, 18061.0756715459, 15374.4039664115, 18093.8869508444, 9159.37742970751, 10990.0660302707, 4569.12677317348, -8542.06745413277, 3768.67365762526, -2718.79119886434, 1938.20801990239, -5356.88621911721, -1493.11886895940, -290.656715904368, -12376.3786995926, -4148.75786373936, 2451.09374314205, -659.881936880076, 5628.76910996819, -6366.27120707989, 1190.97319793175, 13176.8282709685, 1975.36044280438, 9446.59454513556, 12478.0096030164, 2108.43344554212, 1099.9462454417, 1467.34347211775, -3664.52606190634, -3618.73068931287,
9577.18025281376, 4475.7913187288, 3292.28529970623, -17749.9552239435, 15846.7027097015, 5060.06239213793, 684.840758022536, -726.48476430495, 1369.25947049597, -2652.39182885904, 9084.73516695335, 25522.4853506547, 442.051098954115, -15904.4474822468, -12010.9666019956, -27783.1653618319, 9057.94799249308, 2966.43982430354, -5268.54456875361, 9995.26690535702, 19025.4995679264, 480.864775783722, -14752.0978790698, 2002.40588137369, 5431.25865963568, -9846.17951481933, -9328.87671435456, 6512.45240410994, 7398.99001901394, 16136.5067499266, 4029.75668725584, 18448.9945790697, -5855.12562647399, 10523.5305071805, -7470.97591455584, -1408.24024106768, 859.12209575757, 19857.3336186238, -3105.39267101858, -11833.6839543989, 11376.1703348404, 10726.3699054968, 12876.7465552840, 4648.24915719496, -22537.6548086505, 5086.53308185992, -7194.62648340338, -4531.81215774414, 4266.93336128303, -8185.91182327919,
6196.84779415505, 7993.77897511089, -11870.7233247089, 1482.29619127955, 19644.5370807348, -4753.18087285877, -14983.8028230422, 6177.08875724147, -23445.7835236651, -9250.02638337182, 1816.09151520825, 4597.52161193633, 8226.94372875153, -3505.63071332173, 5354.76731744755, -2964.08935434417, 19480.7872007669, 4563.03619438228, 126.584148766589, -11065.1883931865, -14.8602341401534, -1377.13571609124, -3081.23555344787, 2553.17137238609, 6000.98388475136, -19181.5675146383, 2638.16791315885, 2843.78890189921, 6242.04237419718, 2627.26268561053, -11917.4725802246, 15924.3231723496, 1338.15448723082, 20364.3902394803, 863.756729852897, -17427.5546022094, -1458.71300866059, 2212.38820435000, -15779.7676768386, -2182.50068872086, -321.004570881208, 13977.0557427182, 2714.13818969707, 4922.42549805402, -9847.37921873104, 1104.89090516314, -4025.11015677089, -2463.30556556757, -10263.5355269003, -9210.25021457257,
-2926.32615104349, -5440.44097183076, -7659.54541465252, -4559.44733631566, 10481.6450728483, -4401.38925116699, 3590.5922154555, -4202.16976587417, -12141.2588585049, -1277.97337308430, -15056.9849938174, 5579.44516248833, -484.174408937609, 29303.0268767858, 1995.50931329148, -1659.95082933387, 2655.07040991112, 1562.03119721000, -7321.2960692452, -126.545195994981, -5755.0764150246, 9445.85398052727, 2630.57693169091, -3723.61186482221, -947.978382357656, -554.330346305584, 17229.9408647008, 1387.72286471251, -1411.47472604384, 17246.3271639074, 153.773700629217, 416.757286879773, -4021.57623154691, 11883.7520471536, 4360.84667953018, -4494.58684532911, -6825.49415967836, -4726.60834638183, -8231.33956290486, 6327.40392506544, 2403.94895841144, -7067.12957487783, 1875.70894913029, -5313.03833114155, -25449.4397209807, 11943.8890669411, 884.808875487476, 8514.29921926177, 7043.53131409192, -21074.1999583042,
7612.76702537207, -8587.75346224458, 11750.4572968809, -2967.79984201979, -6824.55097779311, -6513.14146867636, 874.517590735211, 14222.7137897355, -15785.2584350247, -12114.5734024135, -3097.79798214869, 12906.7301639958, -3772.93776455896, -2497.425632748, -58.0991198509348, 22019.6931467889, -6390.34910784964, 23680.6488342803, 1273.16026603663, 8366.04045538804, 2319.28547739490, 2691.03093258443, -4949.30383434823, -3001.09820858773, -298.378370146992, 1881.73216044378, 3866.80050316019, 3692.62215023787, -9344.35635116926, -7793.94697170855, -18618.7588499542, 2102.88471126078, 16410.0477800793, 8361.95005659292, -4413.20347750152, 3551.7065034054, -4961.88974572549, -8889.10931225768, 1801.26925857519, -4624.48897671020, -7343.8571722106, -4912.94672030052, -7575.9012877895, 2813.44445507889, -12295.9234851144, -12964.918432709, 8568.4536709657, -2753.86061880586, 5994.62513775683, -1460.78569682780,
9886.41520132672, -4941.37674269898, -5987.73794638949, 4613.02867882296, -3193.41681928324, -21729.6155734947, 1006.65079320462, 7334.10633245095, 2681.7050218353, -4272.52614565611, 8869.79573667571, -1.31525908441807, 6483.20729123114, -9770.50958367618, -530.271637037295, 6550.93889952071, -2272.40613127707, -6305.31099371149, 27895.9492512216, -17574.4451439312, 8590.08191867085, -10696.8172981074, -6446.52741869196, 6467.12521371059, -2862.3187620102, 5429.31660601166, 10214.7289883206, 7043.0356669478, -3410.29599191692, 8887.20752613302, 645.862677635097, -12625.1579197043, -9418.41465715207, 1699.27846952225, -6603.68360358177, 3688.5315055784, 7418.73993156868, 3424.60579656583, 2905.26809911843, 9792.62710676802, -26817.6764972516, -7833.76471983518, 7609.34842452967, -11325.2316450586, -4989.63631170035, -1733.76139958153, 928.610966993975, -1651.51253379326, 3205.53833702143, 3307.00924195114,
-8920.67810218429, -8834.87407867868, -19580.0236225465, 10211.3405487206, -7257.01725597896, 11080.5608707781, 4081.7097315025, -17605.4824344382, 4042.81662075097, -6139.39059818738, 2397.77686485365, -13994.2211319675, -727.955037968634, 2110.56608943556, -686.204886717925, -15602.0791613855, 11382.3463053056, 10600.1637551132, 2868.51040247577, 2615.91946390013, -3983.26559415618, -1234.51606888785, 5164.6072268089, -16478.8279992226, -9051.52576598068, -16736.6278871872, 3363.62622025468, -5190.20766171199, 10344.1209382785, -6042.80698817564, 1526.58669560499, -13171.5773354453, 5777.61357654862, 17943.5802899468, 12691.6270307529, 8946.2585628526, 21090.8922608628, 11424.0163515065, -22719.7620380923, 15220.5564357592, -20012.6828228028, 8529.69181630292, -9805.62733365874, 14267.0099129071, 8068.53909705191, -5197.11502264947, -5682.26634776643, -12064.7928479805, -11462.5427024669, 21541.0599074328,
12395.8535507637, 3522.90489890719, 21753.3397003005, 13233.2694665280, 168.813487222035, 7748.12192207605, -6314.10060701192, -2151.45894683404, -6203.8567169948, 3080.08155688784, 13151.2051020626, 3558.87845293574, 809.996977098513, -2884.08645458395, 4298.35683288929, 17136.5524660285, 15962.0626117012, 2611.33776059397, 2756.32612687514, -13087.799424433, -3808.65850688687, -7329.26937156573, -14109.4248079563, -15673.8144705759, 10160.3512834705, -650.615817450004, -139.694301280537, -17600.9056927723, 5613.50639158781, -10532.6612742591, 2117.59747454570, -4876.13768050453, 3482.16026831831, -13579.339041229, 12703.3331276618, -161.565158829391, -8038.13879174995, 2518.60044655215, -2136.54362777260, -12073.8147533754, -20971.0024339643, -4692.10099651958, -8680.6597573456, -18296.3904285608, 1007.74097846647, 2487.76775925551, 14649.5543319012, 23324.6064440664, 11641.5719481149, 1345.73922151709,
3243.57749355541, 5114.95706545062, -12489.1606834822, -3204.24851876784, 5236.27605366104, 11307.9799800459, 3737.12604773602, -6757.29371773126, 961.736537710892, -5546.8447562916, -9601.19099908254, 10201.6104607509, 2851.00706303951, 12788.2462823544, 4736.14636281564, -5334.67849239148, 1503.70406347764, -3124.88772753961, -7993.84545967612, 11058.4194869767, -1218.56325564472, -7622.6329541314, 8893.69524691647, 4625.5070394984, 1396.15794884015, -1772.79009022727, -3762.23138686808, -10458.8743328745, 13775.1396817310, 4488.87918290821, 1554.25776795493, 3177.99938681165, -12706.6577876524, -25823.2513260603, -11113.9808137534, 2088.02244818069, 3200.98357299655, 10681.0176501971, -6329.53863725723, -7708.40780956218, -10430.7702605509, -9698.63726893706, -3557.58657068996, 6568.15922463433, -7947.31228541604, 1379.57541175790, -9354.95201453684, 1572.77571706478, 909.62696710713, 4901.90101767871,
8519.35350886881, 6594.87326625043, 3879.56457896309, 8012.45942999462, 8324.92590403547, -5386.60865312981, 5023.99849628765, -1293.26662242651, -18687.2067083037, -16699.8218777985, -7596.26487108897, 281.549861446825, -6429.43182675608, 4391.5102842123, -11022.7927143965, 687.473899003513, 10636.5390214193, 18479.4274645099, -4410.25278203831, 4753.37419808167, 6269.33386774853, 2420.09338555152, -12352.6167293539, -2085.33293762319, 4832.76431329723, 4216.47265017608, 10782.9612899115, 2290.27804670114, 4580.89731807499, -11683.3883651090, 5232.37728667987, 6105.80250368652, 2562.94072286548, -5435.88113361223, 4524.13296650282, 84.245769760449, -21138.0145751651, 787.848581610707, 17766.9585123732, -9337.9842423292, 8792.15667203096, -12940.1880323156, -2322.92808561221, -439.289302912351, 1865.65579271025, 10378.5499555531, -1299.7387775117, 5525.17317718181, -3472.77096028617, -3431.44316455257,
11536.3837434685, -4056.57890897398, -8192.96724050554, 379.523448898178, 20575.6677224249, 48.2445687490131, 14239.9808524248, -4531.01470020162, -1407.03826195042, 13375.7446853035, 5601.77565061187, -12514.7537641701, 13998.6813552309, -4665.44601388165, -2217.20666351709, -783.225121613593, 200.327148907508, 87.5118325553658, 2795.14766456163, 4112.04821587802, -1206.17410934132, 12979.6403639706, -9729.66813725587, 3024.8166837736, -5825.34029646915, 6033.86023955525, 9740.81100330486, -6480.29630972472, 6130.49580512967, -7170.39581168561, 13161.7228484165, 5364.47319980744, 4630.21893352537, 23608.6035175881, -8476.23646251341, 9537.20261621154, 10896.3215055561, -983.55433207144, 1233.82428062412, -3882.8715409155, -2075.16662560080, 3680.29667414385, 1799.86128186337, -1593.43123687744, -13857.8158795862, 13089.4482913810, 5043.01842188841, -839.91106295318, -3680.67524504307, -10438.7645292364,
13832.0789148715, 12098.0104988730, 975.578674072825, -7164.89717794207, 3922.66401022957, -20857.7921476374, -14648.1388951931, 14918.7717588671, 3500.08921053554, 6681.85504594808, -834.092268094308, 20803.1317348393, 11572.7773696299, 18180.8046516354, 26463.2625162827, 28599.8004730028, 4874.07452521633, 5688.07942074163, -1456.56327346738, 12019.9268921578, -3956.66281336822, 2167.69347747079, 11238.6001239928, 2426.33086332965, 14964.8652300121, -4461.44792788199, 13168.1565366521, 3264.13176694863, 15505.7809290861, -9435.65346160192, 477.832483005889, 7365.27890034469, 7788.5247915938, -7668.00684089792, 14264.1122565407, 550.706788409024, -10229.150298835, 3690.86864040789, -4669.54057600131, 1724.16150458908, -17369.8251524068, 1344.41202561079, -5520.88851657628, 15057.4122604118, 11388.2841415067, -9470.18876185252, 9934.64509653354, -5156.69281514127, -15257.8155215697, -3453.06625939247,
-19763.6333226368, 6200.73581993822, 2814.06100223425, -13969.8221644442, -7018.46148533869, 5217.31140331343, 1908.90922649457, 11773.9828230993, -13863.4090135306, -8763.87101318625, 9204.87371152288, -16916.6611656473, -4516.43239632052, 17954.2436170630, -2852.87936188754, 1205.78037193308, -7053.08004154441, -2610.33990707564, 9566.42496475683, 12890.0547811740, 1406.56841494219, 13374.3546197778, 625.768213011898, 4028.96738253672, -2937.21094200861, 4919.67882006948, 814.017308297238, 18903.8031936589, -11602.2611086379, 1385.08889251723, 1263.16126377425, -18492.7427456985, -12301.8838368735, 9193.31869074269, 6159.24477939234, 17854.5577363481, -2225.19749086795, 8965.71492258764, 15835.7202626335, 9056.97849052654, -21010.5678827373, 21421.8031046288, 10392.3421948105, 1683.92941098280, -18399.1338820157, 8278.27295353824, -7663.01384339979, 11551.7324202126, 1179.25899705343, 8912.18385592966,
25349.8956322645, -16228.4047128303, -2415.59027661629, 1162.92834830575, 6687.78714711376, -1016.63415084870, -5563.68808636981, -11160.9267130969, 5867.7697798458, -10570.8999994160, 9940.8237135569, -12068.3547384855, -2183.80615469505, -16987.3496673810, -1830.00290373335, 1288.42528560977, -8474.09296561063, 15365.6055514539, -972.237239173834, -2565.18708941698, -90.7358996553297, -4951.26642120519, 4371.22819954248, -924.630347028547, 6602.39754938756, 16124.3138289618, 11474.7911793431, -4088.4778376545, 31.0490113238884, -511.402667463176, 9345.09710849343, -6317.20433061695, 7851.34046073113, 5350.61482435141, 6008.16086878115, 15793.6266549175, 11639.2535233702, 12154.4792773765, 2313.24997738809, 2069.07872155378, 6406.5162218273, 9851.55380319222, -2198.04129474318, 20795.7839122512, -232.489234939028, 22329.1311705246, 17245.4622320770, -14031.5901303829, -11588.9584473741, 8120.34903096329,
-6601.89822068388, 18413.5635803933, -1249.95758965871, -4614.84808579614, -14358.5240635132, 4660.85604113319, 27592.0801370292, 16075.8618604139, 9434.01741809666, 9484.23798240408, 13996.7258042388, 1384.53573620836, 2749.54812567756, 8196.38586819566, -15970.4734651937, 13580.4055385487, 8839.33884457856, -20311.7868128557, -17764.6390499773, 5913.41437879687, -9656.77861935059, 6018.42387982523, 4359.78346794444, 14663.7686864427, 10832.3754785981, 15164.5728404898, -25997.8590266289, -7994.17789673818, -4342.51038495438, -14835.4362489851, 2227.92716955099, 199.494226388321, 3964.44932029809, 207.812296874922, 76.5506246525601, -10741.9201646948, -17512.4522984080, -8764.8741500701, -6527.61445802415, -3542.8439766105, 811.1768643152, -11379.4860960435, 8865.89658535757, 1475.14184036809, -4362.38677928813, -6933.85336118885, -19315.9782816217, 5323.48594339862, -4633.46001174093, -725.622249832534,
8041.03304098651, 3215.27165824492, 7924.85419466224, -10057.3679792007, -8454.4524606082, 7129.41546260748, -3528.15513372362, 51.270295280484, -206.797894436491, 404.924377258728, 19775.4470892705, -14123.5822946049, -7224.53205015561, -3030.83171706993, 736.338892137124, -454.391667222248, 17368.2923062446, 12904.3147780382, -3618.56370788667, 5411.72312053745, 17280.8797375318, -1155.6139247902, -2232.55739128969, -1300.98090871674, -4624.28330822127, 25264.7047637654, 552.122089969104, -10777.8385024556, 2133.31502135457, 13702.4001314132, -332.4206231161, 6.23732943532311, 3703.56825357445, 6576.69639982692, -4593.02267372228, 3255.60350957751, -3933.41006259092, 16235.9590572551, -8519.00042571894, 11841.9237069722, 16104.1047722879, -7812.49500448091, 5833.94653698727, 2696.71006946534, 9307.0060336979, 7183.3879560503, -20055.5641139981, -1030.89992682542, -1137.00294933016, -5623.87246152129,
-6713.60261286514, -6416.44017826462, 7373.08101872237, 1039.45589174163, 3257.36166165077, 16131.2014767206, -802.460596890295, -8381.17412175822, 1581.3576524177, 7219.84327038406, 10567.2989736948, 1384.04866214056, -1400.94154683639, 2651.18869082404, 15395.3563513130, 3151.00069942522, -2267.06312824007, -9966.2228932496, 4463.4502404277, 15008.5689438440, 17489.7513148344, 484.332392160751, -18560.8686176272, 5513.07773367902, -7041.80194834938, -4235.59601152183, -20112.6042175356, 1467.11008794357, 1021.55518011086, -3579.15829809478, -8203.98394769705, -2904.16071604398, -6034.39986234321, -411.336745807279, 2533.40899655805, -11949.1113560113, 2569.32375923815, -7220.81045397215, 3198.29379380739, -5762.9614102034, 3607.04293104792, 14094.4282168758, -6840.81100282362, -20369.2332848777, 18462.2271176510, -12748.502761506, -201.321601855191, -12698.6421154904, -3031.97244700187, 235.816688590732,
5536.95103806201, -10405.8570516991, 3854.78752057459, -277.580971191826, -1134.47728534705, -7381.09414341605, 1723.36270479698, -11385.4399917933, -10764.4717821574, -17725.8179228446, 25630.2046913593, -3174.12271743948, -17390.7481490425, -19520.0510468245, 12136.1387421065, -8495.23481533012, 15132.2691937239, 5005.46751740004, -12182.9203485240, -4285.20044007775, 13908.1840469507, -4413.23110981671, 10569.8547944761, -8510.43855273157, -13451.5893056403, 3081.40291989479, 1805.54235197675, -2243.34597142519, 3757.98367343564, -6395.36625590382, 2882.89482920824, -9446.88842725056, 16016.9268128158, -5309.36147477373, 8040.29115976783, -9375.62227126003, -12883.5101751284, 7154.54659377426, -13431.5685712724, -114.483139920204, -3599.81079672538, -3229.65673960684, 7083.68129007993, 11993.5700950753, -9883.10477343658, -9736.05988303216, -3009.73901610921, 28363.8128166755, -3640.82495192333, -5093.42228853184,
4167.84303612958, -14435.8599148526, -7599.94999334583, -372.755182875022, -9799.27820220518, -881.18320050586, 7153.33994920041, 9424.8419344432, 8915.03933783208, 7138.08364640927, 9255.7506031436, 2121.27249147548, 2295.34047224723, -10595.1638234412, -9144.8284804017, -16364.8529533400, -750.315506031741, -12716.4399030001, -881.817234761322, -3060.41436652169, -5738.6417155273, 8686.90615612141, -6075.10659980318, 11073.5247512562, -4047.74541928726, -6260.34070126081, -7156.38714140477, 1401.78129686889, -9894.69507318098, -468.650175333047, 4317.48124616622, -10674.1662849307, 3528.5570636771, -9094.35934478148, 6109.63877453305, 3603.5758755149, -15696.0612960026, 4192.79361711968, -5844.29648958595, 8836.16403502342, -6755.99016189038, 28166.2331814588, -1887.63949833494, -4858.51015687075, -8920.25841943268, 2836.18558845524, -2131.73501604216, 202.384686527669, 4608.80166388598, 16871.9189246457,
-1877.54262069336, 2420.34974614852, 10167.1696144917, 20197.9589605606, 8882.4672699098, -259.779123948245, 5806.66243878115, -9888.41601287722, 15264.1137240713, -2763.87219040052, 14384.3654292233, -7048.26786908288, 11176.6221272853, -935.386494450344, -2479.05862003347, 18024.6169073288, -5434.15753172822, 10494.7269005287, -21203.4798189913, 7002.81277778321, -7098.28114002897, -8750.04538119194, 12717.8102713759, 7440.24304073634, 6878.29327289433, -7827.87334131842, 1495.61695488562, -14229.0830871991, 503.022036029296, -1197.68221680440, 4411.74512744694, -1175.68247200365, 21448.2023404542, 7443.33070286276, -1400.20295106198, 3104.3292835723, 5971.9561744488, 5093.58738570418, 4636.426313061, 2053.86338525802, 7699.04827045086, -10032.0218025257, 7296.48555079775, 9066.7153792334, -28829.9638015546, 10508.8164289288, -27317.2030444631, -6316.28932449132, -3040.97211030216, -723.082451586077,
12695.0472661077, -2047.69848259142, -1846.94777228669, -8630.2519584244, 7164.27694247641, -3705.28535945395, -2054.49406074497, -10229.9002379336, 3294.59084250747, -9235.62053697562, -19981.6151311956, 1585.22864917048, -5981.4518759224, 14647.3354802136, -9862.66524585641, 1142.65196000029, -6326.3043906197, 221.862280328297, 21092.6801253004, 21299.2497137519, 2680.46010825618, 13045.9987881708, 3203.02375676736, -4277.3912673181, -12222.7115946315, 4625.86027708673, -8970.40846218513, 32380.8897220149, -7619.23748383212, -14212.6370385089, -7766.52561965638, -12525.9924080928, 573.092373487525, 2346.59626054549, 4652.35348385865, 10036.3564936015, -8403.97855207962, 12101.4150824230, -5929.15350912217, 13380.4045491659, -12707.5926197716, -20849.0799123222, 12263.4824829224, 12284.1963761764, -1036.03662930580, 4028.79297156639, -501.17348821269, 4777.55705118804, -4395.79014088983, -14975.2029999225,
-9624.18306638911, 7761.93448945395, 3442.29962462523, -480.755634845905, -1401.00826394683, 20102.0160494953, 14566.7280943968, 21650.1135043824, -6096.04966615581, -9433.26856341313, -18191.3288789299, -23427.9074752490, 15369.8552996733, -4160.34296001845, -3770.12829807098, 2252.58882473683, -11212.3231563460, 16188.0100070584, 3795.87209564778, 16391.7915985442, 13765.0309172110, -10480.6943973326, -9115.20094000085, 11159.6404401417, 11582.6610536576, 23989.2864431042, -898.26698958124, 9322.72322794516, -2184.93643825876, -6053.20444822371, 7218.29809677887, -9880.53511233386, -15666.1953849088, 786.114134425361, 6766.9624530138, 8846.20912533056, 12599.8684167267, 12860.7213739455, -1797.18485730201, 20706.7303029519, 6588.98633072565, -3656.5356907531, -11717.6466022279, -7582.82477115695, 8986.48358144253, -9033.02473397297, -306.273542249412, -3794.98799130741, 10091.8084011085, -2026.82912735090,
2770.11431972903, -19928.7947196957, 5527.87201370937, -1107.69806616331, -3798.67323545031, 236.81918077506, 6942.42254738572, 11187.3689371588, 14033.8505059746, 5696.13840123759, 20323.8553638286, 5190.08204502331, 18227.5565546030, -15473.6193369967, -10943.8235189431, 9650.61042011288, -7868.92085891557, 9383.29471571666, 23030.9015174829, -1239.72245754084, 14830.1954538909, -2345.85802176022, -7145.81057253734, 15899.5223481322, -7120.37559826714, 10443.8808249107, -4427.79564523963, -6568.30107857173, -16697.2377098501, -256.369249682968, -2056.36247976613, 15500.8013064194, -2538.58964712427, -2168.38641745656, 7822.49251976934, -9275.78834706032, 1308.35729735815, 8220.97120410368, 12771.9865151641, -7278.48516861647, -5514.4633549574, -10069.8263725838, 1886.43908195591, -1648.85346274209, 14066.6982466297, -7360.95386383331, 15963.2664013286, 5371.33041187789, 13830.7438717464, -8046.30372500411,
18712.7386427901, 25318.6379347035, 19217.3145035193, 7779.06352643464, -15893.4652112126, -372.257347361756, -4415.54525218563, -8372.52511019805, 4427.22317371222, 3984.88185029189, 7298.61477556252, -2085.76377365745, 16013.8719375699, 1818.97918618434, 2300.59888451472, 2627.99661508676, 2841.54244066663, -11524.5721498359, 17152.3979879796, 11757.797595823, 5228.44680144534, 12669.2112131835, 5130.7440298025, -10147.1281129816, 10659.8891004434, 1945.20732535915, -5616.21711580648, -22415.6039232498, -1206.12755152528, -4561.94736608087, -5667.4182970495, 1448.38111008512, 513.253575317569, 13506.5994234422, 11452.9873419981, -4819.69811708607, -7018.57523016906, -691.382982728526, 19358.8783719918, 6200.06470744379, -9812.30124304419, 3989.17974973593, -4275.06752836833, 10778.8717494424, 3747.57413880465, -10850.2390823383, -5631.77431119591, -12591.7826604586, 16877.5078754981, -3442.57456520768,
-5656.24724921922, -4798.5572225267, 1666.87579457511, 3797.63590866937, -1918.92428617331, -2628.67644587203, -15532.825356426, 5460.95618202462, 6360.64939520117, -19685.2079208319, 14991.1989829984, 4509.59575250167, 5523.33942953747, 7899.14239809887, -1559.53735399995, -15429.0535470103, -9193.75474335859, -10878.5738512703, 3351.71697194952, -2747.87557587985, -14992.4620203274, 10800.5284477617, 1075.30016629156, 135.345710879563, -7644.96375742097, 23498.3597155104, 18938.3401967167, 4986.95030934244, -4128.49043329164, -7797.59497103763, -21992.2202641649, -1241.84269370279, 1982.23155092847, -4290.50480674087, 15551.7483515975, -9704.88914144985, 6198.7077871883, -5211.75434288384, 5329.19818402571, -7784.36589490168, -7595.59180370888, 4068.51002297112, 3138.32802919605, -8663.71394710582, 1987.82272932548, 10197.9564850097, -15720.9804064256, -15028.9986829846, 5998.21129363604, 5110.41036002803,
1140.09690781192, 2724.15294157216, -2535.71308900262, -2143.94650502453, -4050.90705264292, -14267.3624044591, -13363.6690775577, -7524.30307790414, 7976.83672520536, 18940.2451116037, 17743.5209398026, -6824.02153886538, 231.769040731775, -317.82410466603, 2848.56301581957, 7657.34619855385, -1742.40115376577, -11242.2960883380, 11403.6609395824, -1548.1247403414, 6231.18333933731, -3534.30370946796, -8030.98501512005, -3654.89863226280, -13487.2714485923, 19580.537007354, 16079.0289953496, -3711.92928765302, 438.892444719873, -5767.8918106624, 2406.51349067964, 14687.8540535761, -11184.4810281661, 5035.69191921787, 1958.20408745156, 6749.18838985501, 15762.3363677815, -6333.0869738144, -18175.2192532309, -7326.25054888088, -11242.2214135874, 10046.7316380574, -8132.9171780906, -1228.00742694601, -1569.67622226463, -1732.57239491819, 19905.1589426237, -3753.14723351769, 16448.9467813948, 10551.7077302897,
7398.38290022854, 18352.2824286097, 18516.3774899817, 140.612324006926, 9811.45367858223, 2829.22500471913, -7549.51411294757, 12011.6195860166, 25109.4042469001, 6697.47263656298, -1823.01506072784, -9686.42818170283, -4482.84837067396, -240.590760664426, 4285.89658241811, 10755.4607421407, -5942.77929174052, 14313.8703499587, -4209.3674403771, -14273.4334935188, 8947.84629088592, 11631.2308585356, 18356.1554604588, -8254.28134333943, 4017.0917863427, 16400.0912614551, -9009.19611841559, -1198.98593598990, -2916.38350997256, -19704.2159255517, -6776.60337230423, -2816.54720490134, 15894.5000407727, 1573.95086935075, -16106.1671999909, 14141.8379686082, -2899.84325696775, -6552.30748561611, -1670.18253504043, 4553.83995729644, 20683.7564020124, 25433.9265409657, -1743.87986352819, 5171.34817310997, -4125.08639030765, 4484.96031495376, -1595.71893395604, -2787.17490095486, -6842.36640244657, 12651.9307403319,
11764.4336104825, 2990.78213240013, -7721.03902739293, -875.448885941855, 9230.21771135985, 3222.62272932633, 1341.96943570658, -2144.98543673871, 8166.70989049187, -11526.5917890043, -5553.02089071176, -5414.08513134374, -227.494547391124, 3312.19795993551, -5385.08351296601, 5864.75594656232, 4442.40819061046, -5202.81554024891, 7071.95074476983, -7459.55873632772, -13999.4742087773, 4977.90842590764, 1624.96644520327, -7844.35635470543, -8667.0633077821, 4669.13699750321, -14423.4461698875, -491.327601368789, -2427.86884492749, 16975.0568699613, 20858.1495852491, 732.336586900266, 8170.90744001126, 5968.84099196614, -3649.51426826787, -10297.5167542703, -4934.74917893455, 4287.88202813617, 6269.97625992728, 1006.76972859125, -18604.0674961180, 9270.91509270182, -17820.254134895, -13788.8934410766, 11865.8365402553, -24882.9678359911, -7775.19255298321, -606.138877329366, -3783.55217889897, -11650.4372118086,
10136.1863609215, -5794.37598910309, -9614.08169052826, -5944.16642488027, 3800.02671413711, 12652.0101320771, -11854.2052646217, 7994.75304033867, 10358.8690250035, -13693.7301620621, 12153.1423093334, -23926.4361173740, 6077.01819030876, -336.141988555298, 3952.37388338953, -6869.31201305302, 1380.89056827562, -13665.7812240744, 9803.21329524401, 7478.37436961391, 3979.23866274179, 7035.41395716296, 16049.9487173406, -897.085704570118, -1765.83189538625, 2665.40661383425, 10660.1290703742, 4688.68478208703, -12424.4128374441, 6401.04238320866, -10619.1483982257, -11894.5938287978, -2536.69217306479, -4135.40437008514, 6351.01014225544, -26332.1628128770, 4070.56697739549, -10708.0693846451, 1309.46745044102, -9111.00341653795, 1057.99640067874, 13978.5088466865, 19449.8349554932, 20480.0592308686, 4149.15331112082, -5916.47601933515, 642.645670702906, -8784.33417342302, 343.850476219148, 4353.55114516418,
20962.9209929710, 13644.6782181397, -12096.4475799631, 12415.7053458003, 731.957668636457, 19162.3282957246, -1647.26923917597, 7270.73973633409, -13299.9990630529, 9258.98265546489, 19278.4197259428, -12557.1534706868, 3984.09664469558, -14151.7198786145, -3040.82333479591, -2865.96252451552, 3834.40118640170, 23425.2895542654, 6334.89949393481, 2240.7263342665, -11939.7303338090, -13132.2971172965, -8689.43426343527, -4584.33277390995, -4391.03841182788, -16059.9671170663, -5198.0330220186, 2169.45743830536, 3952.22165334521, -1705.36819875890, 19403.2556457680, 8810.62201986568, 1544.01805825443, -9052.60870041064, 21960.6459459575, 7406.07355666029, -11823.7534431417, 4852.07471555378, -10959.0507178704, 10648.6959043711, 5099.88333955725, 2637.50353851818, -3185.21740708864, 4272.17380059528, 21537.975327086, -11119.8074749307, 9635.63480113963, -9424.5989960279, 14808.7639158178, -852.827994125894,
9323.31392207409, 3544.10414603403, -2641.91470668187, 1014.92827867206, 3323.85293919047, 10348.0172993844, -336.657722034469, -1730.10916778903, -359.651738649788, -8374.37881395987, 15706.0587755846, -4929.27583990137, -18881.7894706766, 6784.51978520975, -8810.22760499496, 4787.79200975066, -13895.7020088106, -12821.4677409698, -5884.76245231681, -21365.9439372684, 623.338574573493, -12195.0604095120, 7099.13261548436, 12804.5736665124, 788.192140027866, -3230.67317424976, -28218.4844400186, -9573.49831542196, 11058.2230196748, 9015.2518865685, 8232.69240400022, -11349.5466812730, 6228.86506059566, -8424.0449777079, -9780.8837855919, -3335.87895712084, -2115.6715189305, 5607.2690330409, 992.624568668208, -8066.2435097324, -6371.2646799348, 14097.0312077363, 7244.91168583017, -18735.6850999535, 6362.61151052195, 4726.79638518395, 4506.97987019613, 11733.6572440264, -4242.42201085141, -2108.71386613458,
7032.42704770666, -10460.3796894458, 5912.88859004561, 17069.8220293451, 8100.25386786556, -409.448096385608, 19288.8254521129, -2315.35156983379, 8777.41228188421, -17244.8811363527, 1050.19441825777, 11889.8966465751, -5844.27078718144, 4629.5935716835, 1883.6798901552, -6753.62638086544, -12656.4516368697, 565.694550624649, 18550.0705407131, -11930.2625276559, 8502.3396255124, 18585.9375381646, 8225.93572312762, 21053.0144739591, 7159.13657469739, -9339.50436769654, 6023.0163544818, -11440.4842899795, 7111.78475770742, 4554.35949135916, -1510.39699515952, -14758.5835751800, -4382.98779954876, 12865.9754216636, -6071.31377877779, 594.944036731958, 1036.83877525410, -739.334360477936, -2031.80840480527, -22218.2056468286, -7432.55111868376, 14065.7902674067, -7215.4267150424, 5786.2323405998, -5763.90980107181, -1821.22744458978, -2587.99004071063, -10364.7281634803, 342.610401701673, 20071.2972108044,
188.890688972113, -1849.22167634933, -18215.5593711538, 9404.67127489963, 2464.37395518196, 8095.71885228352, -9205.76846972312, 6168.01623945159, -7963.67071254628, 18223.1777140564, -591.724430470447, -2565.21724083723, -4376.8132687342, 4459.84437530694, 6487.14987732046, -2267.02239454353, 18554.2486085233, 12050.4498628782, 2038.73600215498, 7120.83945402286, 5755.70081947738, -779.860270286214, -8303.78794834005, 6482.51828313068, 252.925372572961, -4328.33695490259, -18237.8869285095, -872.363845152004, 8225.03032851185, -62.453228629582, 6465.00722944095, 321.859834291934, 13005.6335323745, 4304.46027309927, -19483.0548175194, -15475.5207561510, -2785.05014505254, -1291.31938591596, 24900.1744610555, 17589.2832449951, -10153.5029509897, 12832.7918782460, -15061.9981213846, -16220.2127320549, 9715.46709266182, 9250.92634820379, 8414.14570857214, 1523.22963252828, 11432.1489901686, 16503.0906192098,
-16714.0223759167, 5926.30930570225, 10847.2903445611, 7056.46455145718, 1299.35951927732, -798.178249874121, -301.759097330653, -6582.48057667928, 5114.02648338284, -12671.9945068220, 3211.17381858793, 1825.31950019233, -287.686787534736, 886.03551854129, -12405.1840076936, -2305.61880195947, 3796.49930134046, -8449.43141804634, -18897.0916956768, 23047.2300062633, -3209.81219865975, -1571.44941004616, 25130.6807285091, -1131.79410326959, -14683.3621111768, 4991.86399576447, -8768.68686852587, 15169.2453222744, -82.9532301772087, -24242.1374748982, -2703.66393492308, 4398.4499455053, 21754.6869687199, -366.906645001467, 15039.0397840923, -647.577257070998, -2121.50585432459, -9524.84741800995, -5586.26251473186, -1479.80760741524, 4365.4764511256, 18.0606299137109, 14097.7895012770, -12082.7227662501, 614.063946890139, -10023.7620710561, -13070.0123595415, -1175.06087679749, -272.910153619974, -16711.1834158964,
-4624.59912667131, 6052.70206696465, -4596.17926006583, -6119.56114138252, 5386.70654810354, -4593.70147574025, -3983.46667074906, -13113.8644872145, 8026.23014508046, 2475.57566752918, -1298.73651685640, -1858.85279924355, 2860.05404029503, 23099.5621220007, -762.63586975026, -25093.5200743484, 2479.80670710942, -5654.25426050569, -8372.93633942557, -6978.66208340463, -10563.0007303973, -12108.7898759491, 15678.8924857607, -9075.38967690837, 4478.15723921652, 4680.53861220637, 10058.4294445413, -4569.03565528368, 17948.234263387, 3339.59690539231, 15467.5884463103, -5876.34316015545, 5708.1011884731, 23337.8304213289, -11544.6486597254, -7866.69913294393, 16404.4677269558, 15636.0718375681, 11665.0624033389, 6563.22121646495, -14572.2212623593, 1750.20553701901, 10150.0579889820, -7428.17844000765, -3400.39356773351, -5884.01886152746, -7089.79519569241, -248.846084725548, 22591.5317599183, -11292.6694034445,
-9158.98247232457, 5938.56906190562, -587.784951515445, -3310.57237946123, 7993.67266283175, -1237.16237986119, -88.5731116816052, 10126.315620657, 5748.46731135564, 4164.1793279064, 15477.0258876483, -2758.52964705087, 5156.88820246199, 118.770019969649, 11490.7024376221, 17037.1543996409, -3780.91825723108, -6432.43197114192, 1478.22353370629, -5970.11360259869, -364.726140656284, -12290.8846050477, -2897.47241938333, 3869.02384905485, 11544.9878082675, 3328.38933268596, 4776.39253948218, -16299.6542671023, -758.81525066371, 5126.96164270644, -1196.50275281431, -1804.16700964712, 14127.4727764222, -3419.10789079245, -5666.80761238563, 7361.59901805633, -941.708832301008, -1387.82177583051, 3734.33132484912, 6888.88374358146, 4670.77881790794, -11784.5101654434, -9360.44242357841, -118.253248838122, -3319.47100638875, 10190.2910201619, -6836.74987388547, 8946.65283877363, 5297.03732245711, 1510.48752912216,
7213.18774618022, -2936.49674038573, -2555.88839780092, 5034.73157488339, -3647.21746983585, -18213.1974547117, -14535.6533708432, -12458.3422048056, 16518.7976739433, 4490.6647950183, -2635.43348520034, 2776.04271705691, 3336.92977591733, -1517.48042508731, -2808.31619598868, -13713.9709299004, -17397.8040792135, 12703.8420586026, 9232.65073790827, 2513.03546136155, 3171.04776086617, -17111.3681821258, -1807.40979307686, 2686.9882499354, 3857.93638603780, 11635.9432440648, -1840.46052202526, 3775.60197991670, 4602.96670863805, 14352.6196608345, -18394.5850336825, 1846.89223332655, -14704.9056433963, -92.5162409613116, 8094.343598902, 3036.63457422763, -8589.66320897462, -14855.8605835359, 1376.52596087461, 7179.74753864119, 3906.63812429822, 6049.16426660286, 20570.3916663557, 1484.70601770749, 9632.49646765638, 9351.6833697139, -240.233234826088, -1510.57895486316, -6807.75202488356, -18935.8410768572,
404.886592373373, -8800.58432195165, 14618.2587520278, 967.6951104311, 2397.18088617108, -11772.8051706811, -3154.60485275802, 13290.3912647336, 5431.04189245681, -8481.81265727786, 1670.00361536791, 10196.1964054635, 440.107397814174, 21149.0647746890, 2059.80356119691, 16030.3071570796, -2645.36901373849, 1908.90716678441, -3960.10270047042, -6158.90075289659, -60.7420612824971, -1918.15898269145, 12431.8864487976, -11688.2187978121, 3719.50615140241, -2185.66367538792, -11884.1562154810, -14868.4919300458, -471.705920928169, -1901.05679192338, -6367.1260553738, 3624.21254027515, 8796.18864684924, 7135.01092344029, -4255.30260110083, -10852.6514021555, -1394.19451934100, -2511.61061570598, -1600.44572339096, -10637.4552737199, 7249.99438693911, -19046.2715411205, -838.380702889137, -14655.1246589466, 1844.00616477938, -10258.9135677703, -4428.72707314283, -3139.53985467712, -10375.8560521060, 22.6391020176393,
9771.88584586733, 9286.03197290702, -2187.82453156443, 2424.81719375148, -6877.33595812952, 5096.02652491647, 552.317632962544, -6030.92832073761, 7351.30738921762, 14055.6042795115, -597.818211503469, 6046.62340290092, -5850.53197721093, -3477.99843804662, -453.074834409006, -3997.3903044152, 2301.50532070822, 12195.8055671055, -3016.19264374203, -6379.58895965012, -19292.4175862141, -8466.25643558187, -16797.1382438041, 22546.1365297558, 3370.27946879191, -9576.2531763784, -17754.6308176939, -4228.21235036975, 3924.8303422826, -9975.62365518662, -17412.0737472620, 17374.0182826760, 2440.07181457814, -6683.18951373899, 2184.37509788637, -834.01518962866, -18631.0012401515, 3876.66681983003, 8880.38635374669, -868.33327134574, 21896.8601318464, 20726.2497899072, -6135.91675650848, 14959.8677056149, 1469.86022183457, -7059.67032626988, 11603.6640680328, 823.262735493009, -1544.51953357878, -5132.37748524619,
-10069.2059789463, 301.386612753376, -34954.5896712522, 807.38762021397, 4971.64344385697, 13056.9503956977, 15995.4658718051, 5914.79191849127, -2643.67272967988, -568.856775329229, 11004.9236976826, 12793.8331038297, -21472.7382669887, -1806.49553411537, 1455.51020134194, 7076.99678680155, -13521.1188938813, 3254.81455906819, -4253.50382920539, -12028.4050421359, 28007.2683389741, 10756.7371290034, 27604.090309097, -16012.9094499587, 9089.71221439568, -6534.19525455089, -7928.63531587972, -12444.0487003254, 5450.43316426465, 674.433354464429, -4674.52488291432, -1591.27264374451, -6719.48697299532, -22033.8295677387, -7807.1755184868, -4105.73747345614, -9973.22112441996, -9584.65535004727, 2563.01601346683, -5814.02288066083, 11575.3986043178, 5788.25784211437, -2449.18734605332, -1280.07907787114, -3310.62419093958, -15043.9209195604, -2779.69416036276, -7739.79155170749, -5102.95925243473, 1617.76185368182,
-3904.07942373386, 8652.8741863041, -8258.50882237451, -20604.9950279008, 8732.52114513826, 6426.44864330513, 21912.8171016107, 21900.9461816305, 11150.2764359910, 265.921436715738, -1990.75439947974, -4806.64723355356, 12316.5143516940, 28990.5948512443, -23919.9337574354, 1384.62298480509, -575.50903366789, 20237.8260155231, 12531.1472594404, 809.504035690498, 5746.09282568375, 23070.2142602366, -9913.7829554526, 3957.34016505114, 3723.51100216161, -4050.90607883887, 16485.5490746343, 11298.8566980872, 6841.50555207381, 18627.1116650932, -4611.94316625962, -6035.41653019077, 12647.8504113305, 13095.6154697676, -7718.12397989345, -1945.42545137847, -945.749253330725, -18671.9043541219, 5584.02463015231, 4395.98793250628, -21122.6675269204, 8605.52885774927, -14121.7942259240, -4430.08598524039, 6909.79868963745, 14689.4323720086, -3517.4245871837, 5717.61067387554, 8873.36955094818, -2511.27446060442,
8418.21804225873, -10368.4350002557, -11254.5782064452, -10710.2870967360, 5930.36735929855, -6321.96634928607, 8490.4496691227, 1280.32819144245, 1316.23967330887, -6607.162460637, 11595.8398872062, -10596.7637605621, 14366.0871403337, 3345.5320038218, -2870.74660092077, -1823.76343681718, 2538.20185326485, 11305.2659615544, -15693.1278913122, 7155.89771629726, -7342.42315254194, 13961.1262252546, -13999.2295899293, 16673.3606357407, 3298.7488639834, 2148.84608281381, -2650.06379470172, 16064.7227940234, -13877.2006721278, 16604.9348771422, 8815.3183484371, -2733.18561234724, -10796.7588866091, -8252.73164755653, 756.677021838419, 10227.1633598411, -2004.79212396715, 1727.95156028912, -1743.99734011705, 11938.1097911595, -11215.9547233138, -12564.7392571038, 540.406541968593, 13767.6463711671, 673.126772956075, 5891.90179685608, 1924.10589352674, -5342.91977503499, -12512.7917504503, -21346.7553321376,
21454.7936522427, 20785.6569278385, -10099.4030143552, -9180.54207464842, 6733.24851637874, -691.729466751101, 8731.99825243759, -9024.4306460385, 3038.97349162314, -3156.11391128162, -5720.79891494759, -28095.8826028346, 4436.52465481308, -1953.12082059300, -920.663753847148, -15825.048385367, -10080.7391342517, -461.795054154195, 3634.74339350254, 9093.6684044947, 14091.4481201032, 5485.79690344376, -3823.86508483395, -7211.43942085054, 13098.9441905698, -3870.85877811987, 10960.8116491529, 9013.05033933194, 5215.68654234064, 18031.6430314265, 17625.6600629552, 3179.87697207650, 7557.80530907918, -4953.69684650896, -3326.62416096416, 13050.6260298701, 3010.53786608647, 5247.72017046808, -1025.96846087850, -22547.5625015957, -2559.44347911946, 7772.75915823263, -11996.9072537265, -7564.90734806238, -6657.75467140629, -3088.90630783326, -222.420174647056, -2931.60515836250, -2519.97506282018, -2314.76015728288,
-3917.5863839467, 7843.04614456168, -9139.87949724772, 1069.85835221553, 8701.73652027748, -5444.2010275244, -9817.79324751833, 6821.75982745104, -1601.31912163358, -3091.15707194547, 18355.1247005745, 4594.32990250475, 987.334997292204, -11959.1374102455, 9390.93713997927, 9138.29675483534, -6744.69487064268, 13562.3535249935, -3017.73916245908, -6331.8278747754, -2755.11071740156, 4211.34995745869, -9841.68766384414, 1866.17187426157, 3895.39747983615, 10141.2537594049, -294.761000237341, -6517.47488428781, -20550.0374030278, 15190.0592869990, 9510.8007504447, 15045.1744644093, -5495.63510303985, 3807.1742219872, 5850.19432768234, 3226.13772662052, -198.532397374249, 6295.04591934044, -856.489837883878, -7185.54429932324, -3163.34944038353, -3607.34530820042, -16713.7058156326, -11891.5955635895, -4046.93917437801, 2249.05202602615, 10785.4595539378, -7789.89710481515, 7616.69278123415, -424.973542254777,
2877.51514792078, 12593.9195330701, 1554.24559978594, -4320.78512436644, -17450.9413097521, 3649.57336249734, 3500.23677405955, -1653.22205816413, -2045.20364674897, -17797.2721476115, 7445.24463261399, -2437.72154787268, 9319.40886478483, 301.8441548442, -4817.70340058741, 6614.7857875752, 4319.23346654254, 10470.0082461002, 7400.89635935028, 7948.71061737132, 3261.99057181609, -3909.12064349884, 21426.9367410136, -11825.7797002494, -17923.5131679566, -1621.24326009166, 1389.28382798488, 10079.6829338704, -9206.90739289273, -170.851065712997, -3830.08166753059, -9442.23928958613, -8609.61558763283, 11812.7414367700, -1582.69091209668, -7066.52365662097, -5456.76981499809, 3530.15495182892, 11647.7307444776, -5678.71626270879, -8265.6281734361, -29248.141097884, -17042.1864803117, -12627.3196124525, -4030.59236435743, 13032.5153369093, 5749.52780239463, -492.616457840924, 19275.0232014057, -11512.7598526625,
-10055.7897584851, -7686.4146280999, -14936.0908128713, 16744.5640544338, 155.952263355087, 8902.84211745211, -10837.5391193704, -4565.18433131186, -2935.89123284998, 3200.18752901867, -8497.237676158, -3881.76962751205, 25748.2891601355, 8840.23028672647, 12147.7807744245, 15514.6145917953, 5158.47302382121, 1813.59860368161, -204.742704918474, -621.362977783496, 4847.49380412401, 5361.6862287225, 16228.4236308609, 7122.91704429877, -1901.12392778880, 2718.29757583906, 795.865406404306, -12412.3811798076, 851.902531960925, -1406.09648663136, 7993.82972739986, -9934.41209703339, 11540.3967349021, -1529.90006893786, 3959.2348795693, 3643.88067007559, 22444.7221998907, 2037.96060687732, 9787.71740613464, -4134.51312096498, 5016.88569498143, -2953.42216905492, 910.543878839861, 14849.2976006682, 7372.92842017195, 8344.27057333836, 19717.4316103894, 11043.8651450356, -13345.2580728597, 4897.25938137117,
2372.04854497014, -16470.6066679903, 1956.83154685602, 6454.39920012491, 19479.0923352714, -15319.1691908751, 21775.4503873950, -4282.96366707651, -3715.33477142599, 11586.2453196718, 8850.35912213074, 13779.9580647629, -11560.3269432809, 1774.93983233405, 7752.80909548296, 4069.24245772124, 1249.48938953937, 1033.46652524876, 7018.59778602250, 6947.34774436135, 333.798938092502, -18370.0140651060, 633.56004756906, 9336.4490165216, 4487.88510852877, 6573.0034336825, -2648.99894914637, 22839.5954986045, 9076.49763851923, 4647.07794698614, 4959.62549130744, 9482.29414359928, 21715.4301354234, 6419.52172460352, -13323.8649346202, 3381.41156012106, -11181.7276878407, 15781.8431623538, 4956.46788473816, -1430.99708808496, 6474.79891439514, 15345.0740461815, 7256.10571143002, -2905.60497977348, -8679.75555100358, -6615.51993797949, -17897.0113288007, -10165.7198305547, 8931.75129198818, -2330.53963054971,
-2938.63365903864, -8781.5988873102, 276.633245519496, 7183.8868107644, 15716.7061220358, 10988.565179458, -12819.0402227833, -1585.44570449588, -7146.32270019909, 12639.8366129296, 17536.5479210150, 1330.52593178694, -8680.61979758047, 10204.7045853233, -5676.7039497011, -5101.57443122134, -8509.28080137483, -9746.3020167854, 8984.1687497405, 2307.7184067385, -1627.91009558963, 9043.41198110376, -7557.94464898764, -5987.06317633685, 13917.8529490979, -6464.00337726357, 27259.0946081802, 15550.0924643353, 337.329424409908, 4902.50956043172, -11036.4480714411, -9108.83377955956, 10274.1479891481, -316.339907858100, -7143.68945648803, -8106.3051721274, -10953.7091823428, 3974.85132877866, -4885.32768428148, -13840.5076620500, 12759.5509207108, -8630.82977833009, 1483.1184671141, -7805.74635187326, 25611.9300199482, 11553.5839648630, 3701.9816093229, -11945.9727302881, 4395.34289823333, -4540.18616844338,
16056.1635126023, -2248.24073397517, 7045.98127248997, 209.448858520636, 9678.70087767337, -10049.0352355776, -944.177898188802, 9707.8792183105, -9571.08602068524, 10313.7492977556, 5777.64140876095, 11106.9729517157, 4142.62449978068, 828.730091712075, 10360.3030258868, -223.585089533165, -9795.17271523132, -11839.3424322677, 7745.59246707185, -2606.01420754604, 11882.7764141493, 18679.0390061084, -3216.96543271528, 3750.60469778413, -12051.5089948274, 543.985072020545, 14559.6745587385, -24322.5319801762, -1998.70250525742, -19328.2798713299, -13843.4203657113, 22266.6079372121, 5698.04587320563, 103.662165511319, -10346.6702828533, -1890.97772875762, -3712.33661936918, 4559.12445087954, 15672.9570468219, -720.726938514612, 325.444705089215, 17299.3772815133, -20642.1907300756, 6009.29067534613, -1770.43504803810, -6479.43578169795, -6142.07567996671, -9111.63612936803, 10536.5517446148, -4584.48139987404,
2988.87024112363, -7116.69168491516, -26957.8429125979, -458.60616106683, -4186.38155003555, -1620.87691813109, 6147.34170041965, -13730.9132899838, -2018.76319002855, -5308.65011235276, 2575.39027375496, 9137.31092221083, -8821.72926055862, -17910.0777246777, 7700.93822139277, 12432.2356837751, -379.820273729768, -804.11067316022, -800.79615084272, -17868.6801911296, 8183.02612814045, -908.980822150842, -12627.7945866486, -8797.48017931434, 11257.1318914754, -6090.57124295557, 6727.99531792828, -6500.28417146929, 16228.3578787564, -10401.5200655029, -12780.2955691819, -7232.0671133983, 10041.6269388877, -2963.77236284879, 8968.17103709742, 1168.92079298721, 10755.8974867953, 13893.7187421922, 1229.79213731552, -1909.29411740532, 8246.46217609391, 14794.6865130915, 4229.79032044428, 2666.11646644699, 999.454097267566, 2345.66241347250, 11551.8000119765, 12120.1924863155, -5517.1393893255, 10271.8949838051,
19451.5127322634, 6894.04799386543, -2082.4275540677, -7914.32749573652, -9944.23899958232, 2003.62585510313, -10199.2841252666, 13271.3710736045, -9337.91135254478, 1159.79315690368, 11021.4784221818, -2073.02726668726, 2751.14562759201, -8180.60793791949, -6626.12988754885, 12213.1968030724, 2512.10447741053, -3191.68413773633, 12707.0962893093, 1316.63277328273, 14010.6532935114, -276.779293083664, -8241.41092836957, -9476.57141614781, 3631.11860494632, -7924.45550056039, -11248.3772083057, -4242.53064168793, 10449.2528004464, 4577.52438907290, -749.133175439692, 16007.7397678513, -4598.06668645008, -20532.5253034976, 21847.9937577766, 7987.94424338367, 4639.78341914109, 5453.08752810495, 725.152166291473, 2559.03126715804, -9074.72659823269, 11652.3682327682, 14521.2968142591, -777.720091975287, 1300.41636347468, -9970.9687239389, -9434.76183717292, -8180.5339447232, -8111.1523368373, 10669.2475368157,
3379.39817784899, -4969.35754045776, -8326.74371084275, 4610.0596850894, 9555.66853222798, 10919.7071970135, 24174.0366421604, 10930.4134992298, 7027.54523330656, -3159.98765524728, 1448.64894363877, 7282.82914036594, -1877.94179401102, -4516.33433421064, -14734.1349808955, -20827.0156017956, 7790.15126684602, -4823.28201010496, -11101.5388605123, 5116.18897836916, 5748.86271580356, 3847.12040880750, -2113.53004372681, -15101.8958765502, 3012.00357205179, -13922.2270899464, -14915.9321360100, 13604.2414992312, 1020.47453860794, -4210.91979233161, 6066.48473234879, 1874.02809076323, 7889.7286015768, 4879.24504019662, 9028.66134706324, 7884.05333278548, 4898.19303566604, -3709.54504913889, -17186.3798147371, -11528.0856156680, -171.606524463020, -11104.6447824354, -1166.92544540467, 3839.21170575283, 12634.4140421605, 33089.8754216672, -23284.5185846439, 11556.7725991338, 10148.6543103848, 8992.63243969104,
7437.04049022023, -1093.27077644614, -11579.0142771098, 10619.8613396527, 8961.55972716045, -13997.4013753634, -2779.07648989595, 3837.66891173972, -15721.3065532363, 16776.9872680179, -1005.16129318055, -2061.67318762239, 12659.7213587072, -2150.51468912177, 14263.0641426409, 15607.1955514796, -11555.7407081852, 5219.95015083993, 3478.8368165754, -9355.01121584221, 12001.2254713471, 10903.9162225344, 17637.2579982372, -6473.51596735273, -5397.62585500489, -4248.58441428316, 11192.6843804653, 2804.92043156474, 1820.39199229667, 3445.0914830061, -2088.88495010254, -12466.0028506538, -6617.27530580519, 14395.1247288274, -11804.9596824289, -22809.6393100556, 6368.41597951063, -17224.5211679661, 16775.3871340642, -6148.43030816438, -7829.75741567913, -6812.83787702744, -905.145157497632, -16593.9471944088, -6982.2787350987, -8522.32346434266, 9414.36264196673, 13673.0224115423, -3055.85560464213, -10135.4268994513,
10134.2315335525, 4780.19376143495, 4431.14329179547, 3484.9021626536, 14491.5772860089, 19150.7835953709, -26296.9071440465, -2524.76644824904, -3039.36122398278, 12826.3757539781, -15923.3824913259, -12573.5928220330, 87.3309447580241, -18.0820416544169, 11996.3206973043, -4161.08661789272, -9473.15004012553, 5150.11694276108, 10772.2796441312, -6555.45429098726, -5938.68379204974, -6954.53373515199, 10913.2473356182, -676.993104495305, 26249.1025360922, 11318.8321484198, 5186.83716625563, -10922.1492847355, -8568.9833797143, -5429.01930663665, -4875.87812977681, 4562.11159053767, 25726.4074180684, -2063.81088664508, 7811.93688498016, 13631.1422715018, 15624.8823437137, -7619.10322605429, 6888.37039836457, 4377.30049134034, -7943.56436458686, -979.640987407064, 7944.84555500103, -4529.77772732915, -17470.6898719274, -14967.4196253100, 1230.08299991263, 5833.34905920975, -22853.6848543414, -5397.46965127269,
-866.203811386139, 3361.87613210585, 7180.63428827448, -9438.33063527773, -2391.49770764552, 11906.3701557733, 10125.8984278477, -2498.60998138146, -8214.18392353417, 15383.0726440874, -11222.9668313922, 19486.5041026556, 5743.2367637507, -16385.3475370755, -10425.1438222009, 5248.72031281046, 616.489430191878, -997.545529982913, -5159.90619284051, 1039.82526510795, -20998.9844323, -10503.2431359578, 1009.34860552513, -1535.82294514417, 16360.4470575376, -10459.2179496471, -14040.13508409, 1064.46480454151, -7654.83623079278, -18044.5886021299, -21745.097145083, -3161.38647317454, 1174.56155573929, 8723.02228623524, -1519.83145638743, 4287.66853103472, -5911.5402643373, 13899.9618181396, 5919.59641967209, 6822.38395411377, -21635.8318843150, 10973.4618451521, -2937.58110396611, 17.0213090722352, 5579.58813954483, -18714.0020621170, -14786.8226534618, 3760.68560664995, -105.536723754965, 6405.27560969305,
14095.0619112323, 253.961984000068, 24925.3122242193, 10782.8192881722, -11506.6603577056, -8932.46706223232, 3372.62324394064, 12438.7068780557, -7559.47808521244, 7231.53405621025, 2906.72822793127, -19596.5857866073, 7424.81967298277, 9504.85422107678, 6604.86542721916, 1968.95990521584, 5835.44783979496, 15417.1246736777, 32.6880205956889, -19402.3777256053, 802.390965675175, 10538.0479627278, -7232.63495507945, 9580.86149239978, -3486.78081916518, -5018.07674308296, -1351.05907756201, 2078.87319287471, 47.4113762048971, -4404.05050418322, -5962.87511365103, 857.235872284254, 9271.19839396252, -3328.92884840718, 6055.82728229872, 11169.6194688149, 9380.20393877396, 9174.2411714071, -7873.6248829507, 3542.30197715461, -5471.0396955531, -13371.2720181227, -5087.25674773135, -3799.9847384717, 13947.7040670709, -5123.4579543592, 2149.43223638919, -11772.9144102529, 10368.9397170212, -2007.62036577864,
-9409.022444368, -1976.25721193536, 18703.4637563273, -1838.78709041467, 8313.7711277129, 2091.29372694980, 2840.73938381406, -8982.28850167702, 2226.47195044806, -5671.24870136134, 14146.4530729395, 5035.39431122904, 12342.6955959325, 1873.69278935454, -9605.38623258041, -6672.67967846336, -4751.90763624025, 4415.57344152756, 2990.64741473162, 3912.538199267, -13686.3065830452, -5152.87875960623, 11238.5786461838, 9912.97430567048, -12288.9861652076, 3982.55921542976, -16681.7339793900, 24864.1872798193, -3116.72521063153, -2389.83052357033, 13408.7741172447, -12943.7194178133, 8876.4097106277, 139.201547613537, -783.815208105617, -20328.7213519807, -5184.12774075649, 9512.4434406538, 19860.2822571289, 7035.21995917512, 5445.06989330438, -1211.02236366139, 1358.12796328590, 6940.80251077219, -4581.89163056167, -9896.98191407948, 2817.16915484511, 1674.85591883606, 1371.78833015291, -68.7696243517741,
4219.15846193908, -2164.72781259945, 2333.33610353471, -1969.61884065392, 5280.75216247442, -1409.37684285359, 1161.97931905394, -6128.75153262444, 6000.47282890826, -9368.28759927633, 13766.2407329111, -3462.67779092855, 7873.15186940069, -5702.76824026557, -2074.08086003311, -6400.75765967194, -3460.82464186769, -5321.61788874168, -9393.46055514238, 849.894455682846, -12510.8428586559, 6106.0051774081, -8481.59343471012, -5661.15437115212, -1150.30522678560, 14821.3339579621, 2498.65626959530, 5841.81257874637, -15208.6517222184, 2110.46468284117, 609.821317186753, -4527.98311177338, 411.233393565153, 6639.92470643595, 10403.8774461802, 9775.84972498362, 2719.58511983216, 6793.79034462642, 21545.6464018851, -5640.30648701843, 20186.4895821288, 11189.4517594098, -3109.25504175574, 7270.85509799893, -6589.45290005521, 647.150491683149, -3390.58463300909, -6677.57246270354, 3406.7126002953, 2140.39293454623,
9629.82430010348, -3413.06124549144, -3900.42221730845, -233.758433702750, -1920.36826458710, -4152.49116497539, 3559.66777597103, -9324.04635439901, 11787.9654184254, -6539.16047188779, -5145.12539662753, 14461.0999379900, 14603.9758720134, 17448.7072619620, -22867.0015270217, -5520.53114938229, -13992.3861172460, 12460.1337730863, 4463.92525707162, 5817.78588155639, -1701.32269474623, -14245.1254084701, 9619.58044667973, 15821.7067001151, 10079.7141945005, -1948.13424459729, -2692.37542787822, -7203.819352635, -7701.63200102877, 9574.36690213215, -9731.85744481594, 10233.9525471919, -6252.599936834, -8558.24459859848, 4914.77491285012, 23849.7617925645, 2591.46528874737, 14466.6810483746, -2673.19078836262, 19077.8030619039, 3544.72154311625, -20145.5908916310, 14282.7604118247, -25821.486247278, 13469.2345485935, 3542.20948714853, 1151.08446485991, -609.846600771736, -18475.2122235242, -10311.8449155632,
-7572.03332637205, 8653.91473391137, 9227.44493997604, 17431.3271059441, -2416.8321025247, -1502.43146472893, -2040.03574745676, 12482.0778868348, -12781.6380249684, 9420.53119314646, -880.500871899352, -6918.08919772604, 5524.62506716336, -12724.4183310759, -7649.42459755924, -1656.53584742166, -11802.0756661207, -3580.87886986316, -6225.61529313421, -6075.40886024049, -2166.21233679431, 1364.11096364126, 2980.97977191951, -6794.99934232727, 6585.932173997, -1216.22289024042, -3457.99142797672, -2223.01850653888, -4184.14213041612, -3611.4011411538, 4405.86488336142, -8890.37614027329, 1929.3082683674, -16912.7181664679, 5531.41503742794, 4349.73169935262, 1408.93189765618, -9841.20149850872, 5019.32152653812, 23124.0024779434, 12422.9842840233, 4584.81987960047, 11806.7996769319, 23995.9450176730, 15368.8396947058, -359.673110391674, 1319.42892212338, 7827.99106701172, 6622.32594308971, 26067.2038003323,
8961.28682859116, -5983.81770401536, -989.752337859401, 20448.3437919248, 2702.63548583711, 7047.54824997788, 1490.90359103624, 9126.93725960195, 14347.7494943450, 13673.6218261407, -1691.16371519793, -8777.25801981263, -11279.6244979148, -5186.89160735091, -969.12714608803, -846.313878397238, 2985.25737363788, -18135.9741438458, -5727.1550209284, -11164.0273591252, 6720.61690673988, -7238.6349899516, 4793.67930343892, 10378.3691322435, 12373.8253061583, -13694.4974045599, 12290.3409122552, -4628.80929749717, -5279.78698024503, -8928.76373712965, 8542.44004183479, 18134.9407068524, -11753.3304628323, 7646.99476907909, 4111.39362311301, 3917.12987006984, 6028.75381781078, 8133.69856925801, -10183.4756508918, -9175.49718970044, -9662.8234733082, 21031.1985029118, -8720.22727190495, -15912.3335237912, 6356.55139672405, -3367.04225142890, -8855.56972443362, 9621.7104725427, -13935.3160167879, -2080.69637757167,
-7956.03190738818, 7548.53030228856, -11237.3053336604, 3786.59233427118, -4132.49789864084, -9280.1350055257, -16265.1131810504, -2418.85344328921, -6422.15134788163, -10019.6287209303, -7688.49421787479, -8903.3486646519, -10011.4809561677, -4240.87975823159, -11546.6065024296, 21271.4142746236, 2805.70050590397, -5436.4796708823, -12523.5717762121, 13319.5780179519, 4700.71305412202, 6384.43053991547, -15511.6796618228, -5236.13293923625, -1838.87207470016, -7358.80673857023, -1952.59570735176, -10144.8495724802, -12000.4402660346, 22593.7603338118, 6920.205599421, 9233.86673820398, -1037.13749937733, 21311.76058354, 16760.1153441485, -5039.62944253769, -6151.47408008796, 2804.27830256489, -545.988256224842, -619.823029830303, 28668.0796861371, 9034.73732385317, 866.001421674461, 1530.98196437453, 1869.54844928128, 12876.1160427290, 8056.81925845269, 13377.5028667869, -12786.8006893974, 19032.9725236575,
4389.82838557675, 4802.3847320514, 3288.63804508181, 9701.24456699527, -3455.0560987482, 11587.8661460405, -8735.87015672351, 5339.08475416595, 2597.60547708583, 2384.81342277023, 17520.4439618955, -13253.2159095174, 1794.68920641432, 8429.37645922248, -4882.93320063237, -4899.15454885756, 7467.34544571338, -2813.59709577415, 10428.8882966593, 10025.2415917047, -4433.30619749371, -1842.59958514779, -15846.1465863456, 8888.45772278264, -2530.80461281384, -5360.28134062754, 9653.96846375102, -1342.52888750139, 19698.1081776647, -5058.97836156806, -1921.40850076240, -6786.10707371623, 22103.6108544724, 7599.1150057432, 6881.24762850111, -429.225705659358, -8974.48387658544, -5799.73622784822, 9098.66055933951, 13519.1206406379, 7765.83584309627, 227.377116625600, -9129.22941912808, -6460.90738777432, 993.963673575663, 22951.4166376345, 27732.9620876858, 11528.5007526202, -5133.34572569127, -10720.5834602610,
-2905.67804354979, 9326.13803460467, 2252.96884754588, -3831.94137350649, 4508.37680897326, -10002.2156683925, -9060.2343936963, -1084.14815544092, -7134.38852694368, 15233.9047676548, -2729.88541710245, -2387.98679364825, -18076.0783729529, -780.704514371902, -2272.28019006279, 9668.01311087194, 12050.3873071001, 4832.8211858025, -5007.46631237692, -25360.1839218393, 8606.17625109465, -1689.171571021, -18026.4190508141, 13729.6932552922, -15888.9313134966, 4258.74806617452, -2548.34344819528, 30858.0875501822, -1828.8445178087, 22004.2005352836, 7137.44271810183, -2087.01090159694, 6320.81271173001, -2921.46388974158, 10272.6805427360, -18984.3132977833, -5270.47442803465, -8179.66536141463, -10166.0214107974, -5425.35075446329, -21204.5979960123, 7579.16312454233, 19043.442288924, 5373.32312855482, -3219.82014885716, -7497.49087771975, 400.304794298787, -13950.2722128989, -5280.98072653521, -4401.59776418530,
-5133.64282862798, -163.719483519123, 6235.7157609372, -5070.54021804521, -3188.16745060335, -4947.11626563926, -7395.999578687, -12382.2317139725, 5862.51199273438, -6774.83920889631, 22444.8180507183, 8017.78952443926, -12710.6117748084, 1158.74223719046, -7790.38199122767, -4274.69520445988, -4096.25473707636, -3342.46309868389, -782.357304864733, 1512.88351873857, 2882.42815370182, -885.50650030384, 3736.44912785591, 13724.7747140453, 9104.8099621597, -16806.5217807366, 16968.1141861935, -18582.8270611584, 10700.1619068072, 8943.63087939884, -15115.869083094, -5467.7515117607, 17415.8842865550, 12247.0837600948, -2000.04498795217, -596.68632548925, 4179.46300519331, -1387.90829219684, -10182.8269517704, 2326.04051047367, -235.038014188892, 9246.68623158033, -8249.95196233418, 4192.69463397215, 599.62091581805, -7487.72088789343, 3087.94684367130, -2875.91075465776, -6199.59803992413, 16922.2449183706,
-3989.40123173722, -18537.5662799481, -8717.57616669514, -19564.5949708220, 2842.24094829520, 714.605003802216, 15314.5250269628, 24131.0017113683, 11018.9299287603, 5888.16057712456, -7091.15448653664, 4283.91074222162, 4546.53765421889, 16971.6327969546, 12624.3016851336, -3605.36972577048, 11585.3413042611, -9272.77812517114, 11021.0947547791, 618.485838302798, 1143.15619873639, -8947.16828264884, -1235.81138534910, -754.205938988973, 9148.07057331403, 941.632432815092, -2716.02953438525, -11251.9465178763, 10380.4857005486, -17179.6166921354, -8253.91965008722, 6273.64819499406, -6290.08853204012, -1576.57366615903, -8118.43455420017, -287.044723826816, 9452.49547936679, 867.589961502604, -4792.05591368191, -12808.8625027609, 744.49443029962, 11514.6254126978, -4936.2721545179, -794.475947664994, 3826.35856242283, 7153.77510807145, -6682.6937113411, -24436.6688338289, -16261.3995335305, -13748.9091959733,
12698.598223898, 4824.12322257651, -1418.52832203472, -1676.12569419520, -6308.13497409789, 14927.3043799455, -13341.1192871152, 12164.9817455770, -5980.59002602856, -10547.272392048, -7140.3188697396, -16665.2678814081, -344.42186423163, 3184.45677130097, -21034.5174203694, 1302.05163906914, 3851.08674618622, -1801.12302227019, 11190.6761756342, -7675.02156707789, 14207.3886141335, -11558.3978751224, -2497.96946642127, 85.880047484674, 20488.6492892018, 1292.55020504623, 7865.15004575473, 12720.8218770357, 8149.45603471254, 511.442926902067, -10419.8884069590, 19606.500222005, 4365.21105991672, 8322.33198500549, -2058.42229993435, 8562.65799576267, -8663.01601163483, 4277.75154757975, -12040.2149986333, -12104.3534083851, 13413.3986044539, -13002.9048822237, 19364.4043448856, 7921.41254077214, -6537.13062189854, -1497.10147004838, 2818.93937332369, 9708.83560148864, -626.778929630014, -14509.8341530764,
17696.0084874192, -14466.5551142931, 15012.0137372473, -5259.49918069927, -3172.92752245789, -3933.48850534298, -16211.3602570629, -824.751013754979, -3775.09359800258, 6304.85809930561, -9595.98392211654, 5557.49429118206, -3695.83740829859, 5104.06196008509, 6038.1966597403, 3959.52597752848, 557.94131456263, 7183.50021704622, -6165.72143589337, 1237.51159169266, 4357.18053178149, 10835.5191361294, -3770.62051041811, 5483.3474633482, 3458.62585875108, -9513.82576685376, -8716.18503310856, 16190.7932142802, -14384.0826924337, 10270.6939072568, 13113.5954653172, -3778.48338230007, 17533.1939432080, 28785.5462279046, -2024.38860208427, -35.0308763569453, -14156.1526388817, 5563.93449602417, -7416.50842450986, -14725.5313511749, 5687.32194671394, -4439.29777945331, -9863.79567292516, 8487.80202016253, -3422.6424504192, 7732.11267981698, -4223.34061714173, -12830.3268888708, -13724.3032437683, -10350.2068325643,
17513.5596979072, 4561.39611246206, -109.649756359668, 3698.00857710652, 567.886179249834, -9359.8742023145, 14218.8523986663, 2619.29881201951, -6447.84417963876, -1451.34764925568, -13133.9531881471, 2933.02767811755, 7013.94387757725, 13638.2115223216, 18110.7091192703, 320.295014607949, 16507.4357970566, -5358.33613743169, -9017.52276262102, 257.565186773208, 4121.69204309532, 2735.67357245969, -3606.01849432881, 1107.93994974064, 11537.6209216445, 8763.54452953312, -8677.20622643813, -15410.6115144499, 15753.4986633922, 673.913268026319, -5380.7722616405, 1586.24193568839, -3510.34499774687, -4265.53273959193, -2931.09125182614, 21782.4442365860, 9792.1826699231, -18093.5840975127, 8631.29467440496, -4641.35570868442, -2143.59098143242, 1876.28300240798, 992.10317512317, -9631.5994121779, 23956.2471388594, 2995.29831930143, -11899.5781979772, -1237.96393867646, 3174.90676530627, -7758.3751259405,
-22574.5962343155, -4336.05323217874, 6948.26774965781, 8392.02025573505, -10459.5016560958, -5144.81410537949, 10558.1741936192, 3641.26093473596, -15689.3478932836, -11347.9043994900, -8684.56631007005, 1365.03167417111, 22689.8058550947, 18082.2888067351, -2481.48782835972, -11487.4592637429, 9816.52466613727, 17963.1554908135, 13165.7465949147, 2204.98262286412, -4526.94431820387, 21298.7136922876, 2996.79680776436, 7450.95763581684, 2315.28725507747, 241.914017524301, 17649.1387852847, 7786.89993669832, -6570.13437888567, -13059.6177602052, 7010.02925791194, -5090.05834802325, 17189.1203920473, -13005.3304911987, 14704.7032170385, -9643.25812664298, 8193.95978003908, 2292.36645333001, -1505.09718862790, -6330.37035279093, 6842.26994125255, 247.725956647054, 13300.9739422779, 1474.77715096847, 4841.80302663986, 3127.63026232616, 5117.39755471068, 20598.5199847246, 7952.2805433831, -21604.9837738699,
16548.8453082413, -6336.67573727098, -6743.52224254342, 8533.80365450262, -9626.2669192816, -527.244712460308, 6608.40861072748, 14017.6139066184, 8130.24454578231, 14093.5285110365, -25712.4664823626, 3439.34011557986, 20188.6138647807, 10383.8037481297, 687.982028346944, 2875.95863841907, -4519.60473497445, -1343.37841768272, -7527.93222145741, 4114.08319957963, 2319.16348394623, 6687.3600434902, 13440.7840570214, 3406.31392036055, -331.299651600719, -21056.0348126449, -12802.5222223893, 10414.8344912779, -2724.10917030261, -25728.6293052016, 8968.44508761203, -9934.18196584823, -22316.8956661505, -9732.87810604742, 2021.77689425135, -28660.1827321155, -10807.1063115689, -6354.36788208069, 4053.22677585727, 9951.01163603828, 18317.2732808930, -6533.60765348225, -4544.42917560793, 1650.31457758697, 9480.42760453016, -1444.37476982978, -4693.91039872527, 5536.92014562804, -3204.36911673880, 12492.0710106016,
2735.07230011679, 6032.33166298734, -5198.93658177951, 5938.69344320251, 4030.26340769996, -2901.91303034600, -11099.6520396960, 1443.80418181353, -13758.8687749580, 8576.37923091632, 1415.36521687756, 11040.2288640543, 872.881024703941, 1810.63039476970, 19306.860718943, 8341.39010017183, 3660.60677585052, -37.0250021183099, -14707.5353517661, -3829.97830594562, -13768.36270722, 9133.29528915883, -9597.46431505655, 529.862985013084, -10603.2038565038, -8496.74612763182, 21099.7620092148, 13613.9644747287, -13306.7982725506, -13192.3571539282, -6061.21946916095, -6475.19263324238, -41.6879948850019, -2008.03799211068, 13435.9990684922, 1676.34527554801, 8016.20760709165, 7513.23648099084, -935.435066811514, 11255.5481319382, -5114.57978466991, -6815.11316985273, -5659.58587051633, 9621.25757168474, -10077.2319709922, 2428.37724308805, 12926.5189534129, 24155.0854720959, 10042.0379090456, -1706.58336568083,
-3406.42412124595, 32.5849293156646, -6184.07263101853, -10252.0746392741, -249.360037829524, 1685.39268835026, 15298.2695532821, 7803.64669937405, 19244.8226992501, -14666.4402912831, 11489.6554668932, -11812.6949662168, -8633.89288119586, 12475.6521120740, 2033.04509739349, -11260.0686983374, 1600.53393163318, 12426.6094313525, 8545.17646305638, 6750.5428302956, -3147.75959487325, -8374.94113718382, -392.570270022391, -291.576770537284, -1627.33380660914, -15906.2031943093, 1158.71584574740, 463.143281144458, -22309.5680857638, -11347.7154223641, -3345.58402613727, 16205.3681184472, -14652.9232946219, 13823.3705678317, 3206.60533464393, -10005.9441360768, -21980.077105057, 7214.6111169977, -5871.55560133752, 2417.20569831216, 12892.2432431104, -2620.95385398642, 13754.53900108, -7342.34642790412, 1000.15067631795, 9672.3437137232, -3785.09534777442, 14622.4740768566, 2633.8327812803, 2432.05619584685,
24251.4080435174, 864.005753223559, 12488.6692205174, 1544.33815206155, 13493.925247181, -15385.4368162430, 9753.55252905616, -7051.63664322823, -9682.84250037758, -1021.56259966581, 1986.05040673803, -18383.9775422578, -10619.2750916737, 2714.89434203402, 2761.52082635148, 20513.7621282739, -2605.95176667471, -3262.75099308952, -6344.21917366274, -6146.15418838999, 13993.9584517780, 1378.10315937051, -5617.7507607028, 10644.9861248361, 5177.05120231841, 3117.07225128685, -731.646121246346, 1364.45650089804, 2942.28722498474, -21471.0034613337, -14039.8962761378, 3196.19431676621, 4.3566754374475, -1849.50831887180, 10513.2114937914, -297.702525985505, -8540.37330665554, -15658.1378812902, -7592.12679659576, -24267.0850536907, -264.049325079018, 7966.51630352655, -3899.77373752454, -18916.9887490316, -18720.7187263462, -2709.4107030389, -870.926097656665, -9434.4855639307, 10064.9027720122, -11185.3289750252,
-5616.57607005445, 2962.09002611579, 16721.2950610965, -5942.49793175146, -7771.26088011573, 2753.84519110999, 2077.4571557169, -203.545156090249, 24510.5782860325, -8248.98626884043, -8751.74925163663, -3463.36306548615, 14420.2424632953, 7700.04759810622, 13368.4874971635, 3793.86986564605, -15762.6003969883, 10121.024777518, -3797.75595014285, -3819.00250254031, 817.7791484853, 9089.69975445233, 21731.7734223997, 1487.7592266369, -13511.2753848688, 3712.40130690509, 17274.9817181974, 4348.56236916283, -10119.3599105931, -9280.3981786248, 11222.0592568785, 7901.65688325131, -6462.95616940291, -9195.6753465958, 1337.06252933996, 12157.7022905603, -2609.21480709626, -3939.47118912227, -10227.0232428384, -12925.7354558383, -12679.2892666423, -16065.0355896125, -6887.1421202969, -15611.9842640693, -2722.77755576984, 3892.51318558985, 8208.57780389823, -12656.5497474657, -2113.50040515769, 5122.48223495868,
150.890237369702, -18581.8850565517, 4128.34689735951, -9762.78559145493, -16426.7407445834, 1070.87526751707, -124.029622718288, 9639.88819872073, -17118.8915083873, 1066.79277826187, 556.46086227373, -3212.83821006404, 1045.34426563444, -11799.9975155515, -10473.5890805015, 5431.42293322374, 21615.9271300843, 9601.98317238446, 17231.9968829261, 5766.48835944666, -8601.71698190236, -6349.0065067075, 6685.40560990506, 10711.1945263336, -2241.79573277122, -10605.8429083181, -9974.79212492385, 1363.20172483936, -3628.55254908385, -28728.4459960821, -10595.7072616111, -10395.1452328220, -10813.7974409290, 5234.87042811085, -15754.3934620679, -16536.7226625434, -7476.20629504093, -4219.04560181313, -615.09884383529, -5341.64652663204, -3611.04727078445, 346.180289492305, 11839.0530156246, 8402.96038967998, 1047.64854946275, -6716.74860237512, -5760.60074517148, -18042.3670229595, -8276.48834129689, 8373.31481009688,
-12325.2243029756, -16739.5832628577, -9132.95241925506, -17529.6760612182, -14274.5644105758, 11028.7380047482, 12586.3231936097, -11010.0685033821, 4345.94013388659, 1969.51758508925, 1767.04210069963, 7322.50614270313, 4534.09100183648, 3653.15419076119, 2227.86334701087, 4338.45741010862, 7841.74944277544, -13224.5873036625, 1690.1337006547, -9617.99965669876, -10266.1988164460, -9562.85095268387, -14986.6835355311, 6988.00088696342, 2042.59371938147, 11129.6825854189, -6945.66650124912, 4752.59080824857, 6935.66926217826, -7653.7541213688, 9017.03408678893, -11080.2320918782, -2286.57220232681, -8070.05037185002, 2498.05788424536, -3141.97761276439, 2168.63435286516, 12552.6257578232, 8895.57947703734, -20782.0764501564, -6502.70940089625, 10152.2819204057, -10623.2640115029, -551.0971505319, 4615.25895934833, -1513.01037843688, -13025.0805109433, -16964.5802281699, 2167.11750319545, 1220.45579590692,
-8237.4441255871, 5043.99820445746, -159.987021285183, -12049.8005140029, -2968.54271833005, -6564.73760906383, 3315.17603464266, 6716.66868822095, 20580.3140506811, -2859.51879860716, -8041.87850620498, 8337.24320515073, -6919.5787239798, -2191.89856124130, 2280.55776039617, 10209.8126219705, 12800.8301221555, -529.770229742053, 49.9893961171719, -10521.3965307656, 2818.99332269518, -1271.37195941907, -2823.10918552077, 4218.78130278065, 9376.6470043118, 8949.52563612163, 1762.90267150164, -21711.8594901111, 7927.48146758475, 2773.76222375207, 6079.53775734846, -7542.85872710156, 4068.00743715702, 10943.3339027017, -2719.88597806663, 709.255795659818, -14918.6369994902, -628.345402620211, -23006.9220014678, 13195.6826066268, 6851.26770548359, -10191.1783950218, 13782.0515044568, 8321.89370164819, 5120.61013162114, -6044.7929870433, 20143.876175944, -1942.66833229575, -8925.30653182773, -6437.86660536741,
4408.80938071573, 12857.9202734358, 13323.3291458459, -6142.99387582404, 1352.49194823780, 10113.1283766867, -13198.5460387800, 5408.3929147589, -12685.6606238645, 6345.93699363864, 15153.5760454470, 9694.66252481762, 3827.67859890875, -4633.02977829871, 12877.7941838887, 12141.4039704517, 2990.20461180809, 18658.3720646040, -9433.83203011168, 4896.46502534849, -8192.70096964336, -8122.06684385589, 1637.70126087389, -12684.4833946854, 14338.9781522486, 3805.56125669659, 10000.6139044671, -12983.8445823866, -9109.76827632162, 5222.54598644391, 3864.33075164553, -5307.66296640062, 7803.07592877149, 4259.63152383704, 15240.2493284929, -3286.47781498795, 871.015772333745, -9330.17846547197, -5560.75145654578, 4848.33099570679, -696.055055931665, 1031.82264931575, 13895.3811427042, 8408.59109315329, 7266.31154415897, -8176.49078762724, -914.752337812879, -1825.20883677332, 6143.99443848570, -2743.85599780582,
-18909.3765709720, -9177.98141386066, -11931.7662054294, -3226.77413771853, 11182.9050310233, 6908.34480020061, 7982.59707015866, -970.578118484238, 6169.87225096739, -4276.06875077581, 5678.68306342598, -8676.8735928244, 7578.28515686656, -1930.42099587316, 2027.49675158100, 2271.12462219816, 9740.63439359005, -11063.5796046845, -4807.02941036491, -6688.33098041736, -4705.70735216284, 5012.42238191569, -21230.5714747499, 9675.0912283074, -23580.2256193035, -4205.72588282377, -2168.05220231785, -25193.6281651089, 9532.6330540533, -14358.1196560721, 3339.82930802453, 6893.50411608455, 3054.27168186757, -612.30422137085, 11732.3315804185, 14973.3219211402, 2505.75380360708, 153.193003505256, 367.034757326491, 1944.52046338428, 13632.6995971237, -9167.9978596399, 12260.3972013584, -6810.46592653426, -3797.24530470197, -4472.54244526066, -2287.71312317881, -10870.3982256821, -14124.8098666797, 2085.55970820839,
-3494.04234438437, 12713.5467076059, -3981.11879685007, 9736.44953222091, -4152.83060966196, -1857.56733178975, -8185.13845942615, 10182.8659263439, 1980.13310795802, -15422.9343604382, 3420.04516833866, -2064.08981350548, 11270.6338519312, 7084.63441094949, 5812.25507215939, 23339.1675494892, 6839.55379003755, -5664.10367396216, 12580.8852925103, 18616.473955091, -227.607749529353, 5682.56652384097, 11332.8757859493, -6780.14364293494, -9565.22744286997, 710.044259451685, -577.74900070305, -2218.56466497504, 6019.3025324296, -1162.04007850530, 9800.71328141789, 4445.62969882535, 3130.52097596696, -1742.59149939137, -4074.43509570975, 6572.02302258214, 2336.71420448764, 1700.61183574803, 7059.88189209136, 8219.8521948497, -22107.3856340590, 8834.60075123603, -6448.88013699078, 538.706928205872, -8944.30853785814, -1508.65892357758, 7044.09352260116, 17964.7115491862, 8965.70612552295, 14678.8045398662,
-263.334685749672, -9058.60320573829, 1376.20484359357, -5788.03557827914, -6397.07489074011, -6126.21980503471, 12301.1205681324, -3681.93921751724, 22.2086307614247, 6623.93757414929, 7466.7065084958, -4533.29058996945, 6346.93918498392, 22671.672710231, -23326.6552148679, 5562.05841186903, -1374.31340664848, 543.738303116193, 3854.74801470479, -14913.1970271318, 3039.56275715272, -8451.89775693653, 3899.33881407645, 18935.4559023428, -2705.56970355955, 21083.6502243532, -19161.6542348435, -8091.11025333402, 8474.13986662452, 2182.44603483893, 7534.31262322254, -738.921671153896, -10991.2814136863, 11448.5745612473, 14394.2936521686, -1740.65984472077, -10268.9665994818, -7376.25257523369, 5513.74421473777, -11497.2115834854, -19202.6110163458, 7546.33174296892, 407.037234860781, 2406.82822408062, 316.674919682906, -2065.95731397573, 545.706221749026, 11255.3653784927, -21747.1487534102, -7702.2242157843,
-8809.72081664667, -11143.3276723686, -1044.04100905834, -13170.7981370723, -13199.4993767207, -7240.95793155048, -7943.82118318523, -22136.3318107195, 4062.63116119255, -1339.52000564621, 7065.32668953251, 365.291257518291, -3292.98288774505, -14967.2123491975, -1229.94531668337, 10652.3983590575, 3530.35868465625, 7538.96354939715, 2643.80301474587, 811.51126232125, -18094.9005981129, 14159.2575570016, -9667.65952963135, -15678.8646118393, -3301.6185525711, -15702.5213216075, 7047.85427899477, 30746.7582992867, 4271.76481497368, -4986.90789676042, -440.105957924878, -4983.68724797739, 12234.0675399397, 5903.99843372096, -856.39011921676, -9886.48226304767, 3818.91173788213, -9589.56724070715, 2851.1293090164, 2858.49739356328, 2365.81158723193, -4201.96412820176, -17324.8039399628, -12161.2457488782, -956.795177897049, -4468.74957329866, -10334.3882797625, -2191.25926613351, -5964.98813155076, -1924.37253532268,
-4632.32866201082, -9347.72194493129, 3498.40762647744, -11807.6966845699, -22134.5414794404, 6288.29816946763, -9424.51244420246, -6529.69623200576, -17672.6264714199, 7593.12358569385, 9862.4632200485, -3537.36125177691, 6356.22010847739, 570.373276318709, -5217.11346317544, -11840.5922734233, -2350.00702208518, 8028.52454338627, -5197.0160196949, 18225.8768977629, -7580.60422176552, -4660.19789391, -8230.02967937897, 701.83048581247, 1335.96328592534, 9798.46115311363, 3774.08847877903, -9868.22215252864, -19760.9018872280, -12855.0327821175, -8145.86540745483, -1614.11942187904, -1124.59333567301, -5047.03952766062, 12386.2491870940, -3790.85556720325, 18823.3161334569, -2773.40849905398, -2202.89781982315, -5102.48671755771, -18990.2793213918, 18620.6284392185, -12550.8665989899, 748.159597833308, -2374.612908024, -21836.5020574583, 6692.29173605622, -14974.5997667810, 5699.7281807797, -7007.27432255175,
393.121165927477, 3008.28497368697, 5137.33738362637, -3195.16917667534, -12147.4224001850, -16723.6498489469, 6374.08772793945, 5304.47357747026, -6746.1613296988, -11578.5221047756, 2093.53325882686, 9097.2696680261, -8703.58411218009, -4735.09217944241, -20.5919973861466, 9328.1180067957, -2285.36402272017, -472.687964234225, 7725.45210956025, -13762.0293483832, -4730.43919813698, -14530.9119843367, -14568.4863618349, -13252.5609028587, 13092.5395477754, 4532.67741302674, 6956.88387491233, -13209.9495594379, 5016.86356731851, 10649.6837190835, -3102.37729351252, 3798.08614479747, -16371.4893261209, 7002.58454896769, -575.932452744249, -10344.4862873253, 5076.6149905431, -3362.56760595034, -11226.4233324017, 4797.27291371262, 5945.61456070971, 4090.47127350726, -8350.69719440606, -396.774302741431, -11244.5438540254, 458.462166070102, 4591.39280589877, -8116.79321964723, -9713.41779623546, 10497.2089693674,
1074.75827647062, -2720.92393941046, -2723.01760675558, 17.0424905985961, 3366.11551627436, 10043.9457509403, 5944.45094157816, 1218.56298238693, 9177.99506944504, -4219.25446597741, 2185.17816846564, 12383.7359855997, -12481.5261549367, -5772.83778101938, -2119.82787868073, -13883.3768447605, 6093.1995498204, 4395.79304416298, -11688.5769063096, -6111.99632120435, 22574.8276592079, -14532.0339480976, 3645.70512455156, -2016.45740665007, 13901.9510768599, -6572.16110467819, -4010.141300328, 6220.73504761792, 5994.59760731508, 5625.83727845931, 20148.9351644947, -2098.38794963476, 110.246369594733, 6624.17158352097, -3799.7054935973, -14299.7656734108, -1510.02467569315, 5322.11224675631, 25677.311202528, -3937.123543415, -21572.2064436983, -6504.10724903182, -34291.9902470237, 10874.149835484, -5404.84120848499, 26276.1755300693, -7387.25901304099, -1445.51366154449, -4229.57374918724, 2562.35279892753,
-14571.9779433380, -7534.02637692702, 5491.6858803302, 10416.6848108655, 5755.12099805928, 19780.525956094, -10464.2414987443, 12821.9969349204, -11.0691955011543, 3576.57517884969, 3703.59470095541, 13344.2304657970, -7326.78650504705, -7679.80778500485, -4795.50118559746, 12365.2892696652, -6688.42386235193, 30041.2153512799, -2766.05894064739, -959.055335481475, 1267.33615256896, -6416.01525027559, -2907.01888653112, 16457.3138091917, -23886.4842921892, 4395.95225207226, -4623.09251061989, 8868.610283436, -12406.0061877683, 6855.78149495018, -12841.275892875, -6665.59533459276, 19229.0466131821, 13407.3398441811, -22286.9116293151, 4452.38394026031, 20871.8657162942, -13911.2918472963, 27387.3994882911, -823.755200749845, -9332.42699788602, 23764.7277373475, 2162.155844191, -17708.4115503269, 13955.6416517307, 20988.3121377950, -10899.4883489412, 20321.1248470307, -7420.41742838178, -4209.806166577,
-4701.622962059, -13151.3975267064, 1283.10617101074, -3876.13882203445, -3733.51545923322, -15001.1589430719, 5157.06257476291, -3443.98810476754, -2304.84774334130, 6338.16146243093, 9556.44687023447, -3740.64024012569, -10560.4991287279, 11889.1408192537, 4790.2199098899, 2880.08552792184, 5362.55818676102, 2574.89264494249, 18885.3090885330, -19649.6267572696, 13464.7628944951, 14173.5566947665, 5961.32040757151, 14068.3271379194, -12946.2645998368, 12053.4494476613, -2476.07024921075, 13259.1704079713, 10107.7332638162, 13388.8186998428, 12573.6753601437, -3621.22138845568, 732.223262404302, -17259.5772025124, 6755.87083550815, 7156.56445825067, 1023.55538215849, 4552.70030987061, -17240.6729320362, 1580.90902880049, 12737.4255829566, 8528.25152700735, -13600.7394809797, -5993.14365741926, 5890.63106698479, 1084.49600618603, 14840.6345994570, -3543.35668982666, 6839.12077016006, -154.675329699272,
6081.1596447436, -3013.40160216537, 9747.4545879996, 9328.86312056355, 3174.21875621798, 5797.80237675382, 4241.04491968171, 227.411932249348, 7968.38520388865, 11123.7690594575, 9709.16653637119, -10263.3524732725, 15049.1515323009, -5402.20686892802, -13221.4144231873, 11883.0915355580, -9596.78677091973, 13048.7729708026, 10930.9224211422, -9036.87449408012, -20235.1729245942, -8313.31116401826, 9474.92710373633, -2182.04496711928, 15669.3236111777, -26025.3280267448, 17956.8868041952, -13794.3821829102, 7699.1251106652, -9260.33778897544, 9927.273171527, 14425.1246302589, 5340.24838745469, -8870.64985660439, 2268.85998513685, -4812.57842232205, 1933.58370363304, 16041.5212549705, -10198.6621459855, 12443.4416490972, -226.413864172861, -23814.5748018663, -4222.92734942461, -7738.23513717336, -11767.3983706686, -20498.7113670659, 1016.30084190266, 4411.02187818912, 14086.6852111669, 344.079848410192,
-12697.4909214183, 11373.6602717986, 15304.2757885963, 18028.6717834053, -7608.68998698382, 2598.28627708207, -4403.61455879139, 9727.0862152567, 157.192959242496, 1113.46302039128, 7112.1830608542, 2292.71698135828, 2758.96905497467, -17325.4146143709, -1395.19701541633, 14521.4212521746, -8055.95351889727, -9271.27756838354, -19783.7152965398, -16257.3493975979, -12247.8034396810, 9680.18958222103, 1838.31269806073, -4195.22409904596, 4907.2458389342, -196.299016524385, 9928.36491743488, 16657.7938389292, 7113.4281699899, -3182.64358566482, 6791.8045913787, 3099.54775040589, -8650.97975850097, 4133.56780375792, 9118.35181733296, -9788.78024745765, -9381.60090983134, 15136.5336256715, 211.827785751028, 13323.1127754978, 3938.60521697811, 697.542157149301, -15118.7982450765, -2626.09885958859, -10533.9967815647, 17099.8997752309, 6602.97643724835, 8684.03513889513, -10091.4481379497, -2050.42064418499,
4398.68876780578, -5469.22937578445, 5683.16911167911, -4397.70136119325, 7048.3883010574, 12860.0209465345, -8666.42516709954, -8929.23755370856, -2492.88698837315, -10776.1981895730, -3028.16744142927, -340.635891735201, 10719.3763092466, -3997.75020646446, 2019.42717634637, 14191.4025797665, 889.575075158737, -630.897442683087, 19361.0275292363, -15783.806754329, -2368.89098709159, 9237.13851362177, 1927.76569323948, 10336.3975964851, 16635.1305428664, -18482.2996723832, 7440.37508184132, -10809.4786484744, -217.811855867582, -6488.99074908048, -2983.14234746178, -2356.78015670372, -7758.75527753784, -3789.29234042123, 16419.4652970082, -5096.93240754525, -8151.3059604485, 20558.4239522917, 4225.23954891346, 10301.3186211912, -4482.55064756452, 4193.11729015376, -12864.0165319867, -6417.74059650545, 7008.6225948594, 19557.6400889693, 8500.72051297811, 249.544568837257, -16667.5743084687, 9079.99876415002,
-6422.12622211442, -1804.62392085795, 14133.6878088311, -4665.29898405624, -11943.1521073738, 6522.68980601259, -204.129067032893, 4837.11882022793, -2665.47733299602, -2500.27337800661, 15304.9586173983, 14341.4060352808, -2808.03544800521, -11434.7172390184, -10073.3041191449, 11246.9062272519, 16716.502749914, -23648.099678056, 1143.06325890941, 2291.59233532907, 7292.50471130268, -3398.27227213672, 1618.46623612370, 648.135524861123, -76.1713942480302, 307.285576559509, 13369.8272336354, 1176.48343314453, -1125.70717434704, 136.338432092699, 9499.55979939447, 3845.53731001761, 6093.26153975422, 22490.7841595700, 21689.685472338, -10096.4066551050, -7225.2720297566, 418.804722993955, 3814.34748537728, -15054.4568354342, -1713.44675201249, -12893.3100448092, -13706.5519436634, 10974.3553240572, 20677.4978243013, 8402.29065533121, 10210.6291199659, -6921.31132397285, -18146.6233651057, -6894.9273635563,
-1706.96830394205, 19267.5321842898, 1214.81873930835, 8227.94230334938, 17128.4643707938, -2882.21329652531, 5278.94400250907, 5871.86839460806, -6074.73659363054, 8566.65262652954, 2697.64395954454, 4726.72894146741, -3091.02204350344, 10395.1764599673, 15667.3644266537, -1710.34008600062, -21178.2512625479, 9698.66447971267, -11341.9907341698, -5965.10879716482, 6480.45981061882, 16533.9530964496, 11479.7518952944, -9963.28083869032, 3417.43260324289, -5356.27068228249, 7117.29100646362, -2809.95359323233, 12916.3604765643, -1098.18139569764, -3146.12036126338, -26253.7932559083, -1800.32732148863, -1193.20420853888, 1212.66088426784, -6959.22356810565, -5101.65622831569, 5160.78654696395, 26027.7748709442, -3418.18873142559, -7760.23283045004, 26560.5753395234, 1434.24465076576, -1626.96235866185, -4441.48654927176, 8730.4747831548, 10922.1090782289, -8044.8083636315, 5943.02504744304, -8925.72283878844,
-130.353236720249, -1886.11449582653, 6475.18456932585, 3372.22621417427, -9126.23758487704, -19588.5928187986, -2266.44000988985, 7527.91982097985, -6661.71002404392, -32967.0454241942, 12136.8880732727, 2436.58086836989, -854.712739269061, 8132.5801635806, -7034.89416993864, 9834.3631188363, 4291.18762081321, 23404.9454203223, 16783.2841814771, 2348.82672781735, -20156.6195084287, -15534.0427723275, -4507.03107217462, -5478.98828991136, -11989.2666927461, -1979.41530698889, 10329.2829591551, 2195.58095594353, -7990.14073444081, -7646.92883434816, 1542.56221321487, 5841.52335270537, 6800.08192769089, -2361.73378504109, 250.581840159174, -6635.93796046423, 994.9676427322, -826.799109529857, 9218.10140916496, 4605.63361705190, 3232.78514253835, -3914.63243850177, -17416.8955889467, 6555.80447008687, -6973.15780321019, -6353.36775943815, 275.523768275176, 6992.08934918221, -16922.1436079281, 10164.2722136913,
11391.3685350554, 9478.70896601249, -973.769421690026, 4805.22129518411, -1610.79850976261, -14417.5897286307, 3577.47203428785, -9330.18486103112, 4382.59105969050, -11555.7745476512, 14789.4174585077, -3036.2508238717, 15623.9859896645, 23609.6179276462, -21182.5439011940, -1119.81610241935, -3998.38440310842, 4896.49001372628, 13685.2257659837, -15513.5133863473, -5841.54447606876, 18138.9032918805, -25864.7842460844, 1560.96954733029, -8855.49285187702, 12408.2571115470, -16608.9425350126, 6603.1047354668, 1887.11099399252, 11827.2108564915, 3224.20241408277, 8356.60827473715, 982.990011813884, -1188.35504273299, 21030.8126098579, -10793.7559348831, 16026.1383473528, -14263.7858562815, -1341.88664344856, 4064.20973708879, 3043.95020575764, 508.086791505699, 6870.30689650363, -16813.2371120349, 8181.23643110756, 10213.0009423598, 3428.81013212255, 1469.09089708407, -10342.3878426974, 10139.1545541889,
-9438.94894033582, -1060.7549368109, -1851.7120125243, -28508.5193986197, -13361.1718304897, -8276.6891470734, 13474.4421148781, -18437.1831026966, -5235.81886193892, -10806.0442275446, -9811.1445476419, 2237.68765394152, 8923.75350948745, 15269.7546284911, 9547.847275969, -6999.39946458845, 9123.03707012553, -5662.14741076465, -724.61292843431, 3563.17548248937, -14863.1625564397, 7674.08902455305, 17598.8907888651, -4464.0339458706, 667.540381801158, -8816.66169742873, 16527.3894077065, 7409.1997315439, -4486.24539460841, -7291.03046591164, -17221.8960323889, -16681.1152785405, 4595.4229388615, -11845.6747610385, 7279.77088895096, 26119.9409871899, 4020.57448563284, 962.519659820843, -11745.4352842401, 6048.77777254083, 3880.55263524562, 2539.90758049984, 9241.87319917877, 11487.43387889, 288.358733767208, 4573.09750197629, -5354.20298663899, -7930.9497466298, -1199.26273153132, -2176.56802640104,
7742.25560468884, 7383.2475450937, 6276.07347211091, -4914.54829827997, 15678.3277208477, -3161.23505123586, 3284.00756158020, -1807.61911600062, -5422.0117174405, -132.008786037379, -557.966556878101, -6277.67877560195, -3961.91205033905, -6215.8705464239, 2320.71919017975, -1066.87790495342, -46.1332786798307, -7893.07050903027, 3496.80834411311, 5053.49384789034, 12306.2445080443, -2209.92968003065, 7646.67099852437, -4175.12613312591, 2818.96421174593, -2751.64863910827, -6781.34992919245, -562.251400902083, 5494.62592973092, -13383.5949859581, 2598.04831765883, -17243.5546550671, 11089.5081281017, 24808.7453133051, 6143.70595281824, 3339.01693586740, -9189.19353586829, 8757.58247619126, -4726.26573752378, -553.275414703728, 1706.46335878033, 9331.32499886289, 1787.29671826222, 7552.2699127388, 6052.57073556701, 7056.49295448555, 9037.80467780566, -6082.09087594286, -310.395950632568, -20170.6872654233,
-23310.3628772942, -11129.2453727411, -5142.79544079978, 72.8186245150859, 3243.83808545221, -8579.34356684334, 1458.98097121530, -3985.79841356638, -9532.54537231324, 8240.1003268036, 216.275393273686, 4246.35191514642, 3345.80613477687, -17521.6246638025, 924.663046611991, 16872.3060823493, -8191.52219070745, 11613.6174327593, 25399.4725163012, -3215.03162193284, 10913.9934994871, -6634.65318943403, 7269.9040392357, 14195.3666334284, -1066.27568536934, 182.336010368007, -7831.0915607208, -9599.10863901393, 12757.1098373626, -7262.37408737912, -3320.47641442260, 4027.08335465465, 17065.9043978614, -8203.06001461581, -15162.7733894258, -24131.2726020686, 4171.56009413886, -13450.6200333958, -13080.8073324431, -1552.50911431697, -6990.06310204511, -6807.40958945224, 2169.85333785559, -8639.42447657159, 2975.79575926143, 5685.24670480874, -21040.5612182937, -4674.15750992476, 10451.9714931143, -6665.4339037432,
-19711.5315038499, 5736.88712665837, -9188.18024271568, -8394.62238551787, 9428.84040482599, 141.038712879043, 1946.87509964046, -12721.3794558829, -7242.14091646052, 5318.98821945541, 1517.81438729282, 396.890424451562, -5795.6022640407, 1717.95660519651, 2286.36840111800, -992.928062603114, -10286.4983128473, 1982.08631777723, 21213.0431754637, -5546.3667848054, 12897.6522645054, 16939.2179204092, 1805.35761432942, -22261.2894698372, -13978.9584249299, 23.1304694687083, 7615.93778129385, 27874.8598286350, 18392.1406501456, -17449.5115618657, -6002.41890043109, -1681.42622827672, -9114.31981794821, 30366.9019510915, 8528.67508827367, -9991.79516916524, 3893.0832840242, 8303.47806411384, 16840.9006878853, 5604.64684389347, -16375.5797955120, 12141.4040478886, 462.198752195128, -15971.6199636387, 459.798097946567, -9555.7571377302, 8170.68615324846, 2821.70914585596, 4603.62665574094, 20826.7144230303,
5264.57838805882, 7743.71047340444, -7302.71704036285, -13756.6686927819, 2263.0683621902, -719.302342347699, -2464.42652669558, 13760.1735327218, 2704.61912934300, -5484.81780154758, 8816.44355018442, 587.974916261113, -9899.99947256402, -10219.5297580181, -8458.49536258033, -2893.36602415202, 3790.37026668229, -10363.4859339269, -6646.23853862054, 8525.90111984176, 905.700805785874, -5832.52758854512, 12843.9981578544, 20516.8840339982, 18952.9487613886, -10.7655970831381, -12703.9356659839, 4640.30699903349, 3610.10708730053, 6720.83421194904, 1031.71544606390, -5035.90122201311, -7735.12370677061, -4683.29513355807, -9220.27747702918, -24760.2130269305, 1387.21593074622, -2337.28145154179, 1865.41195039963, -12911.7105874985, 1535.80467436241, 5401.06292385417, 5930.37985769704, -18799.7344516555, -11105.4882880273, 10201.5393401827, -11453.9176326855, -20023.9755434576, -5213.02355987601, -16269.5872105004};

double yy1[100] = {
58013524.9935325, 80574348.3926748, -29503767.1012542, 24210223.4821499, 3431577.64118068, -38652734.082556, 42878071.9574764, -71175155.4499453, 53568036.1357632, 103184208.336666, -23644802.9219393, 8055534.68288158, -5601889.00061195, 109257764.837792, -62326779.8249833, -52281772.2729535, -174284271.288372, 67652817.9657768, -11096241.7598387, 62178279.4956061, 85627066.0295197, -162953356.395025, 6062630.72379463, -8571934.75244369, -44265323.2443962, -84597967.5653845, -36834699.7796381, -29351857.4838073, 12316083.0650735, -48021005.4106043, -1230041.52086049, 73727843.2336405, 4321177.68875798, -30142614.1241389, -6177015.40546335, -15795856.0205987, 84453448.019763, -45063301.5794998, 58813496.1741974, -3770288.9807012, 110676161.256099, 37640238.2860112, 121924420.902476, 2387166.50082277, 39697585.7682771, 96864292.230747, -76398699.6491508, -95773616.2687342, -83157232.5014637, 37330438.7987722, -24697451.8096167, 102803280.501464, -33906118.4793819, 59928493.5825972, -74403241.8638511, -91056526.141524, 31950198.8416452, 15514375.3329104, 79977759.2226435, 14939172.9295314, -104694614.876098, 146095113.119950, 40316937.0304508, 43402144.9115654, 102123786.100276, -153731388.24516, -5049747.18503408, 57835601.050226, -59206758.5705374, 43812049.7853916, -53780984.8805659, 9601990.54223845, 25449092.5566594, -109126005.346650, -15532662.4034862, -120158011.165693, -105298709.965788, -5364226.57934042, -37419041.9687914, -64542173.7035687, 9170636.04236379, 74849512.2013523, -46219639.3212286, -66777772.5132738, -61797102.0284318, 194058135.167378, 60356407.6836476, -43438584.3196583, -88040476.3130942, -116068775.491830, -10435631.5608568, 32038777.7462712, 16070992.8516589, 92969662.1523649, 80650033.571066, 20584363.0999619, -15834281.3112404, -65868336.9446101, -56279548.0678929, -42609551.5767967};

double lars1[2500] = {
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 38.23740324743330600, 43.10537614002905100, 69.87845270767906000, 80.17097332676398500, 93.24532081516629500, 101.86021756666102000, 103.86551922079182000, 134.14706417487375000, 165.84286281083286000, 175.20027763222481000, 203.85277327394832000, 205.52629811762193000, 223.14573980221675000, 234.77545499979112000, 239.34045495042167000, 253.66242460947683000, 286.70289226177658000, 302.29867457902884000, 337.32487150684398000, 365.42029756699787000, 376.26893260634586000, 398.08828085816629000, 399.71757762979860000, 400.42260854195695000, 400.81346236372218000, 409.04874599745835000, 410.19383747836588000, 452.03863762221317000, 461.64903906139347000, 466.83265166983199000, 467.37243303415363000, 467.88691990588507000, 468.25161505436608000, 474.63795324272576000, 479.60678670964489000, 483.89853529790855000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 12.77390603082450800, 28.40525457939803300, 37.98205596755769900, 40.75683976124865600, 79.57435563940001100, 138.76506616059424000, 153.49211456355951000, 202.16134701631233000, 205.34106948138481000, 282.82615644229162000, 329.02958305357896000, 342.56968689473109000, 370.52893411168520000, 466.42422223224690000, 526.73432212476257000, 652.15349681684631000, 750.04789681529928000, 816.36244660154796000, 956.48761219162907000, 973.50502254025423000, 976.49756779545999000, 979.98025013888014000, 1056.91251975244290000, 1099.21131326367390000, 1228.19907855331030000, 1260.24431158660560000, 1280.68849816519290000, 1283.08705510169900000, 1288.42289390033560000, 1289.78463675617510000, 1310.88762595450450000, 1334.99987298357110000, 1468.13280918176270000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -90.04830212005545300, -127.03739399278913000, -131.38808982480180000, -154.02529135943018000, -165.23517454337318000, -178.86325883224873000, -187.65660628004426000, -189.76111104411402000, -220.51564596763188000, -263.80402912670036000, -274.36971940583476000, -310.20354608312971000, -312.37774651924201000, -363.73815955507769000, -409.80436728103615000, -424.91723217719766000, -453.74090480641848000, -541.64009780690924000, -594.54621366965534000, -705.91804073023491000, -787.38254829555149000, -843.03417677426035000, -981.23359414431798000, -998.24877331201685000, -1000.66958876290900000, -1003.54562375749360000, -1066.28933752755760000, -1093.76986225472020000, -1168.31780874835930000, -1187.84955492452760000, -1200.54936789094700000, -1201.80233640111170000, -1205.63017894307040000, -1206.24544063214010000, -1216.28111371836280000, -1225.10617227653620000, -1254.38005058313550000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -205.98087526602851000, -257.19942958403209000, -296.49153501244234000, -300.19402103262104000, -308.96618918348122000, -311.12643743031987000, -346.41195085338921000, -371.53974027411033000, -529.50400487514025000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 131.19675302809580000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -79.82675688003155300, -141.66205563987415000, -158.41463792333337000, -193.49232817786074000, -282.40695007385978000, -333.86922711882784000, -459.13233134813055000, -535.72107126560218000, -601.97099006876806000, -793.56235977714573000, -817.65988550283930000, -820.98892595642758000, -825.50088356632966000, -923.17046714485002000, -978.19815249223836000, -1161.10385255021450000, -1206.69748709898070000, -1238.51979577018410000, -1241.32788883524970000, -1248.83663519833500000, -1250.62751062650410000, -1278.27159933867850000, -1300.34292602323970000, -1451.01850759114470000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -4.38818567871125700, -5.11063761951886790, -19.10549094005647300, -29.50841676545992300, -105.62064934991560000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -33.68558078818011800, -330.61395149424897000, -388.40048442225230000, -465.89122627891169000, -502.27645679748122000, -528.94218847853620000, -777.69186462367645000, -824.53704512417119000, -886.02261892135380000, -908.83538518178841000, -912.00197497809222000, -926.28501429350956000, -933.33887156257470000, -943.06207195804905000, -949.58879358750710000, -951.88716297717235000, -984.51135458047406000, -1025.02295112299230000, -1037.53497001577670000, -1074.09131484405220000, -1076.29529950465580000, -1107.08879964568250000, -1117.86070707547650000, -1121.10145903589500000, -1126.19247867846430000, -1163.47419687596110000, -1180.40071090656690000, -1210.65208784210950000, -1232.79311425659580000, -1248.53428511856350000, -1252.21442449913460000, -1252.03082763184080000, -1251.56273474332830000, -1250.95313795956300000, -1234.36582525267520000, -1228.79284702097990000, -1182.04589336654930000, -1170.83386992631680000, -1164.77079493405590000, -1164.45588081452840000, -1163.02520517602780000, -1162.49843774331270000, -1155.08434853936410000, -1146.54511276395810000, -1095.45145233732320000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 69.54981373838141700, 172.81455449060053000, 208.84596563059421000, 214.33202382610537000, 239.81782971204473000, 250.09474030353178000, 264.13103161019257000, 272.46353345156075000, 274.92314042082177000, 307.44589608692490000, 354.38833031579946000, 367.43506134122197000, 412.70406968103867000, 415.77452563436299000, 484.75845883713640000, 544.18959965761815000, 564.87430631950565000, 600.56363499232998000, 673.41348019309464000, 709.38119187347604000, 792.30635102522638000, 829.87329415309910000, 852.39692208621670000, 934.75491104862238000, 944.46173270729923000, 945.80361280243767000, 947.39302128274278000, 975.67007301766762000, 993.56433445168022000, 1029.35246056282430000, 1036.08056628939330000, 1038.29095699164940000, 1038.36523805727170000, 1039.47014007437110000, 1039.88979465518100000, 1045.69943734460660000, 1051.71411198942090000, 1099.97906621115890000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -201.01830046555924000, -505.66573342661439000, -525.31388992661221000, -671.43061386684803000, -691.02550497367565000, -724.09024998436098000, -736.01007049544489000, -745.80126488012365000, -850.31879516875688000, -869.86809748453231000, -904.52870499568655000, -920.61403854157868000, -923.12884646090231000, -935.67103531391240000, -940.48665969832336000, -947.57679326453297000, -951.40747479277218000, -952.53582730638766000, -966.90078185331151000, -977.65717482463776000, -982.04018400176142000, -1001.00888426726700000, -1002.37039963989800000, -1017.49058898827460000, -1018.78181259286760000, -1018.28568982051730000, -1011.95194349671020000, -990.51023859127270000, -966.44137516407886000, -899.68480491042021000, -872.18574397637337000, -848.55431448109505000, -759.56041746821631000, -748.56053524818572000, -746.46104992857727000, -744.01539831302227000, -694.43692608476749000, -664.27999808622781000, -542.60734658496960000, -512.51902011701748000, -493.12325515231765000, -491.48366647985944000, -487.82218841625269000, -486.90229759386131000, -474.60395139801784000, -457.99372891281649000, -354.83924095078743000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -10.47267359991118400, -15.20852776934026300, -16.22034978051193800, -29.73983224383573500, -51.29963218123113900, -57.18002720286105500, -83.58142702119336300, -85.26119925266269200, -122.18502084599396000, -157.23459316911132000, -168.79979734023104000, -196.45788779109463000, -250.28054804916562000, -277.45914955220132000, -339.12360231659193000, -380.73733793482114000, -419.16497532915042000, -565.17295012333227000, -581.97918887205446000, -585.18630253540391000, -588.96820752942529000, -671.52873964652133000, -718.88915649299599000, -890.87763792927728000, -931.52506741427146000, -962.04609904049130000, -964.75318067809167000, -970.63025040008608000, -971.93798677731866000, -991.41640437192461000, -1007.81577295943670000, -1103.12685175751810000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 22.87555446674134500, 34.29352336385176900, 48.77807298244163500, 58.03940806028131000, 60.68859895135889100, 98.51271960646154500, 140.79005481569405000, 152.65881575808936000, 198.09414367299317000, 200.76348818301281000, 237.01792796166345000, 267.79956246973808000, 280.05978368134197000, 307.73885717123642000, 379.95731652038154000, 417.94173683232350000, 499.48485126645613000, 552.18999302695488000, 583.23227675756414000, 621.67751435754269000, 626.90952959162632000, 627.87221094025381000, 628.77353172824735000, 645.96772497994186000, 652.05373778395551000, 649.58655113615259000, 648.73832466294823000, 645.38146699402887000, 645.27383825885954000, 645.21179458877737000, 645.25522728088617000, 648.64992036962246000, 655.53309800946249000, 681.57533324836504000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -240.31515913696219000, -270.35037539585346000, -275.15778409311542000, -280.88630234786319000, -407.21756881249581000, -475.71092839326394000, -702.14425814530330000, -755.91396559698433000, -796.71449500044093000, -799.61738298127602000, -806.14467318067386000, -808.51775011208792000, -846.05634395297750000, -883.77229686522480000, -1101.77659892993760000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 5.13900894187759240, 7.08872401437782160, 33.89129426509484900, 65.78028328311788200, 72.92090770421663100, 92.96719187214732500, 93.93085576985480100, 99.64469100891111000, 98.55120612540480400, 99.40168063601713300, 104.30834760476949000, 134.43045758694694000, 146.85802609242731000, 165.08349312708268000, 165.88511110987869000, 163.83869273755425000, 159.05168504719845000, 157.78830813902886000, 157.34631138714425000, 156.82928997890747000, 146.01377227118545000, 140.72692835182420000, 88.73568756581737200, 76.19973528337492000, 67.67879581129460600, 67.45451036691481800, 67.19051406370918800, 67.17255119422716800, 68.26481908111485100, 67.54870504076697600, 52.87696143938891400,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -45.40471629268547800, -113.09605909424697000, -144.08054675530227000, -167.10720402149249000, -396.24827427963316000, -434.71304118765551000, -497.34289943859392000, -520.41219111819021000, -523.52994921043626000, -540.09774256841274000, -547.76971526581326000, -558.84907110612983000, -566.18647410871688000, -568.61769683671571000, -605.13208751227114000, -654.10580833115057000, -666.89265315921125000, -719.91708753563319000, -723.24225554919906000, -799.78557298208864000, -849.98603784390139000, -866.73929249050605000, -901.68267815785737000, -984.54026718033606000, -1021.09397112637960000, -1098.69059795971790000, -1125.90658423126520000, -1155.33967552651980000, -1229.29960497808040000, -1238.94604005938120000, -1240.55952182088160000, -1242.12426802499660000, -1269.77624212018710000, -1292.03920616155190000, -1340.86356333472900000, -1354.54777597064640000, -1361.66381256214390000, -1362.29244765815660000, -1364.80512600361820000, -1365.49318639126340000, -1376.99187947084120000, -1384.00594125814270000, -1461.67802090289770000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -29.08907919776519400, -296.95548126865555000, -340.87638313882724000, -386.98338079251033000, -401.27969308415089000, -403.07284661034163000, -412.38827671276204000, -417.07942630063809000, -422.43134645633023000, -425.09249707060695000, -425.73109029366316000, -434.86889639297482000, -447.52399660903535000, -452.09684585971729000, -476.62272417549775000, -478.25825378293717000, -529.07645572214290000, -567.28712546350027000, -580.36197559707989000, -613.00482073877731000, -684.82533015086062000, -744.53330627687490000, -878.27629456087459000, -965.76892874073087000, -1032.26469409417880000, -1203.33028073085390000, -1224.54264772414920000, -1227.89930670537860000, -1232.29509157697500000, -1330.36321141709710000, -1381.47755803656970000, -1556.23739177809630000, -1601.15212107726760000, -1634.19175346946370000, -1637.14031077965070000, -1644.26390625361340000, -1645.63667791134780000, -1666.26451205551330000, -1684.75284649254600000, -1787.50589201825460000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -38.32176945495339000, -53.98881574462206600, -156.36011270000026000, -182.17373546069109000, -203.68496974250900000, -205.73737020279881000, -210.21110505680460000, -211.13660528723702000, -227.33240250136328000, -237.63513132052228000, -246.36702282311751000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 224.35045061025036000, 266.79264863697318000, 320.97036265695937000, 349.12438840767078000, 377.76845595337323000, 618.43452544302568000, 672.69655367306495000, 753.58508169972072000, 779.53476863695778000, 782.97551540713084000, 799.81004080826756000, 807.81152952298191000, 816.87570158814117000, 822.78898831625042000, 824.63404790187701000, 851.29603806467253000, 898.33827047935313000, 909.93613955679132000, 943.50048433157326000, 945.66235025863125000, 994.76380239544744000, 1040.13506822976410000, 1055.26131803521620000, 1089.00297312879680000, 1148.24721570205790000, 1177.63482242347140000, 1247.48136296594590000, 1288.83801043864700000, 1321.87157084408750000, 1424.94861827786120000, 1437.15859293824430000, 1438.99819309928940000, 1441.28820231174520000, 1487.91393441986930000, 1511.34235285086740000, 1592.58028219437530000, 1611.56765452826040000, 1623.27408756439740000, 1624.01323008844320000, 1626.35086694354100000, 1626.83368910524840000, 1634.23416266585010000, 1640.62454697285470000, 1683.36280524305290000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 22.10497768885608800, 153.82492792134107000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 61.44275137295257100, 100.65553584270330000, 133.06610186390358000, 256.01550429511548000, 270.61792277847849000, 272.89908750052234000, 275.64828540207429000, 339.41179865488300000, 376.69933771292307000, 487.46564735444701000, 513.52399534756967000, 531.34747152561613000, 532.57177135712391000, 534.96624293633261000, 535.66976642183204000, 545.64608511484971000, 555.99840905373969000, 624.35196093369188000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 3.23418614787750200, 47.66356911600042400, 91.77516407397023100, 103.63017416153563000, 140.70163665872161000, 143.11422635022038000, 191.55456047464523000, 230.31648479100599000, 244.65066728898100000, 270.59810525785156000, 361.20314524598717000, 411.71944309447377000, 513.96101043165595000, 577.84343797117299000, 622.17202737078605000, 666.25338523831135000, 671.51139992832668000, 671.87577121466040000, 672.20959915179731000, 674.44236761284856000, 679.48687545664188000, 668.96530710795423000, 667.50506161244482000, 665.07567733211386000, 665.54749713647834000, 667.08241194826064000, 667.24673139102435000, 671.23782035726845000, 669.18168556410660000, 645.11712034142124000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -2.09319073614563230, -6.37681742513716810, -7.12282763649592890, -19.00727041012643400, -28.46956653026922300, -86.22110716923883400,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 9.97042236767525840, 22.55595774854374700, 25.64975931726121100, 43.64040157789246900, 44.49720508172434600, 65.17879549966059500, 94.84001966961248800, 104.13307616126662000, 128.26548781053830000, 173.49621466436327000, 192.49745248614911000, 238.77054880058913000, 276.64689780657523000, 302.72293188476550000, 388.52849469163920000, 399.83672497367638000, 401.85265070404813000, 404.37947751054287000, 449.74134880845889000, 470.07892296365662000, 566.33775644625007000, 592.57999923574289000, 614.82468054984395000, 616.66278921693697000, 620.58788513653963000, 621.56295387146338000, 635.20137679442269000, 647.88045903476700000, 735.48337561200935000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 106.11958425360564000, 174.49321538329349000, 374.07509781696569000, 399.04333302109399000, 402.86641322664997000, 407.15359267566055000, 499.79699293735302000, 539.53775482920116000, 699.22464405733444000, 740.22943996062281000, 769.89745163387022000, 772.58756292458304000, 779.51242990547382000, 781.21829515294530000, 808.81501505433982000, 831.09648298831553000, 959.00053383080046000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -2.67875437548409100, -5.52518306272378630, -72.26270902476250100, -111.01119626377704000, -270.17839729506903000, -308.68131909202930000, -335.47020333012995000, -338.29652785845161000, -344.37753972284787000, -345.69243581239971000, -365.30446523999359000, -383.13948000176009000, -482.32178983186839000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -4.04503615923393940, -18.12259916778914700, -23.69844903490367500, -30.69939429029375000, -35.65733028651085600, -37.51813832118887900, -63.11049214680064500, -98.35296353237052400, -109.47480309679146000, -148.62591383553482000, -151.13603015684876000, -211.72606317149331000, -255.16395876744195000, -269.26647556010982000, -288.99551948335017000, -344.55693881367108000, -370.12423263665943000, -422.91342454597748000, -456.36421866676665000, -483.20654619291781000, -549.59040403660140000, -559.64506872136224000, -561.25207189886555000, -563.51514809434457000, -613.26474591155318000, -642.14045758420662000, -745.97780601768284000, -768.93458548839203000, -786.14304652092676000, -787.95242536070737000, -792.59276923214168000, -793.93106475799812000, -816.18022638696857000, -834.54032595825242000, -936.48727404828730000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1.81811278311459510, -46.67253819508451300, -66.65200056734384800, -128.22206133083480000, -144.35305522524610000, -158.92166279360723000, -159.88081311881433000, -162.84358757971339000, -163.68786561741805000, -175.56217345220475000, -187.17381422068348000, -262.40493246415906000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -39.75266802854046200, -177.15089797668296000, -193.26634785958089000, -196.36248707701975000, -200.14140524386349000, -286.01851801438579000, -334.09415366458245000, -516.89016608600105000, -560.19173776234027000, -590.18691434972197000, -592.59407159145030000, -598.33316643464207000, -599.56040225354764000, -619.10627509561459000, -636.83628000044337000, -745.53379977627094000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -121.77770097579864000, -186.25891667825772000, -309.28444853675433000, -375.43090135869278000, -428.86091039351169000, -546.11236823932484000, -559.89317405474515000, -561.55060064656664000, -563.71971592848138000, -604.63981235100130000, -631.16952856275122000, -673.64079492514622000, -683.37463320519873000, -690.05707227683808000, -691.19767412902991000, -692.92310351488027000, -693.32303717807815000, -700.61077496190990000, -709.05181799748902000, -762.98659706035903000,
197.39805776885407000, 324.11108420782347000, 360.71622910444682000, 574.25699630587371000, 946.25864515499711000, 972.60425969796245000, 1175.36740730566290000, 1208.14627921151440000, 1257.69197435326420000, 1280.58623578375020000, 1301.54177486071650000, 1509.09783115728310000, 1548.44086511148630000, 1587.72259414903280000, 1596.33641372988250000, 1598.23237791392810000, 1605.31401660292070000, 1606.32592337875280000, 1609.70483449848760000, 1611.29402204867260000, 1611.22834902680570000, 1612.10617671888710000, 1616.09858822145040000, 1617.51019605704300000, 1623.24710434542840000, 1623.34944205801370000, 1618.74327645449560000, 1624.99581202942090000, 1627.11154128724640000, 1634.52547235968790000, 1630.48653897496090000, 1628.64499008646790000, 1637.82697980041440000, 1639.41234448932100000, 1643.03636779105200000, 1660.84118773354070000, 1663.32236310486970000, 1664.16964420983250000, 1665.28576590584700000, 1687.11561733282660000, 1700.59454373189400000, 1754.29596412084790000, 1767.40701689556090000, 1777.61834292171810000, 1778.32703789123480000, 1778.99640875283310000, 1779.08943425342430000, 1776.43765383158670000, 1775.97910025419310000, 1778.34540562128110000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 8.85007776146016840, 18.66767996454239800, 49.56173034197129800,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 14.65128941064675900, 15.55538845560227800, 16.11579055637157200, 16.33917925398209500, 19.30157645586948300, 16.11377543905073400, -27.69140896351865400,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 51.22218545292967200, 75.53482486250209100, 102.08693115435599000, 346.05052645984028000, 392.49208684420637000, 476.64201470431755000, 509.77112077514738000, 514.18113911218165000, 535.28846978042782000, 544.80015516995525000, 558.60509798731721000, 567.07838604420272000, 569.55417658889485000, 604.45964412633089000, 645.48934226321524000, 655.30171418735381000, 696.82645529762340000, 699.69346803366352000, 765.83335403733588000, 822.76161338212842000, 841.84997821631873000, 885.23273059817802000, 1006.59801779433310000, 1078.34353816743990000, 1233.98571890636530000, 1336.36099630983090000, 1409.12194191548500000, 1568.83064440349450000, 1587.29879562475180000, 1590.07043932108990000, 1593.61306897560100000, 1674.39391281248480000, 1719.65018795363040000, 1896.90309758893340000, 1939.48479253990920000, 1971.57042386567880000, 1974.72391489190520000, 1981.01681896007540000, 1982.25443578419620000, 2000.88728227456550000, 2014.75285991006940000, 2057.15676910570850000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -26.84018213822632900, -102.42278691843823000, -120.42389182044649000, -133.42829592172177000, -134.62206420789113000, -137.12423093479251000, -137.74831365304138000, -146.92048185484566000, -155.05566011332323000, -220.44836737880578000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 71.96266327193194500, 98.45975924954096600, 153.98803260389133000, 252.60775176934797000, 304.47078455299720000, 424.27365152111918000, 519.84575198272023000, 589.94464172856487000, 837.89817200786661000, 868.18896829293362000, 872.96339702866931000, 878.85802422502366000, 1004.35292834318090000, 1063.97607434149150000, 1310.29873668421460000, 1372.51500003589850000, 1417.03843062836840000, 1420.98374445861620000, 1430.40138550925670000, 1432.73705589976070000, 1468.19270954918080000, 1502.67530614557560000, 1720.69212291213080000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 6.37772053351587690, 7.37101787337114000, 8.83967063646052330, 34.85600570663974200, 43.79664978935660700, 56.48065604781439200, 60.83987461416081300, 63.29857368993045000, 63.50751594673028000, 65.36711164633293000, 65.53182810821284900, 69.46726630922007900, 75.10657842125753800, 115.06828427583227000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1.73060056041315400, 29.03081653194620800, 54.68673266897801700, 209.17638837438366000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -11.97183822010104700, -56.14166125952052500, -58.91460949821880200, -97.44953588765653800, -123.98954384304461000, -135.33596468094049000, -156.03619875338993000, -189.39332775292519000, -210.10081791373281000, -252.40377239165625000, -281.56283372421899000, -296.09338816393551000, -333.55634774118573000, -340.17665748826556000, -340.81575095272711000, -341.64930658978506000, -355.37135270576380000, -357.62672000309266000, -368.63388787545387000, -374.01996183391623000, -380.53537779952950000, -381.39373078539882000, -383.20752135160711000, -383.49705352792478000, -391.04257006704211000, -397.53294453670509000, -439.06995221028586000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 338.47237247948533000, 406.51067552945096000, 504.16698425051567000, 539.45364364200941000, 544.91084100031242000, 566.98127757556836000, 575.01532954773677000, 585.96502495032632000, 592.77740006832664000, 594.72985335247347000, 622.25069861274642000, 658.87498695042973000, 668.97722656170481000, 703.82119678463346000, 705.68588397944529000, 755.30673312786519000, 803.84852157015530000, 820.03598794256834000, 849.96560724643405000, 906.59930390756642000, 948.88659410309833000, 1038.36348025129910000, 1095.01893350212460000, 1137.60136172934130000, 1302.41618721336160000, 1324.39350880210330000, 1327.68402225740280000, 1331.67228848376860000, 1410.14109119239720000, 1453.59322965737010000, 1616.53157028044690000, 1652.75361818540980000, 1681.06694335422120000, 1683.45861560727740000, 1689.01860759059970000, 1690.46000511904960000, 1712.97761979649910000, 1731.21727108903750000, 1836.04132905010990000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -55.22891133608180800, -67.52587338297750800, -111.57227315160335000, -114.29517355405908000, -184.37038734231010000, -241.13863811366946000, -257.55420707941522000, -298.21388244141127000, -381.17746899175523000, -435.81667082414947000, -571.54795139853024000, -651.40156410941211000, -711.01378149837990000, -861.18484611994688000, -880.55615888106377000, -883.86064660061515000, -888.12516106276939000, -984.02448944452306000, -1034.62993982872400000, -1204.21953604735290000, -1243.09366936579200000, -1268.69201848400640000, -1270.98493000627630000, -1277.22579463311400000, -1278.53978877222720000, -1297.58609180003080000, -1316.83599059865720000, -1435.14106948796580000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -2.61924418278335080, -59.07108767472670500, -97.02400073145624000, -109.00688828864297000, -131.13623254555935000, -187.67846716876366000, -221.13982656527546000, -296.63084853787558000, -341.71137794206135000, -378.92295102578106000, -488.59572058002709000, -501.76661348861273000, -503.60979022781964000, -506.09378033013263000, -564.59079756940946000, -598.66243588044370000, -689.36702483778026000, -707.57032539778038000, -723.78038930362106000, -724.94076299942208000, -727.08353898607186000, -727.34838590407560000, -730.88805853357724000, -728.11212773558202000, -707.14474338176706000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -50.93214401419026400, -163.47117968072723000, -247.29580857366292000, -303.40243586447315000, -496.28704878937276000, -520.72938177445792000, -524.58227471124519000, -529.46689314504545000, -639.47039433115015000, -693.72324774328467000, -891.49963680520887000, -938.93099347558700000, -973.64231354118658000, -976.41709492330676000, -983.21974699913574000, -984.95484257086719000, -1010.99160479595210000, -1034.21153473801090000, -1174.66078302770420000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -19.69024652111306800, -32.76988245979131200, -34.23963301181465400, -38.67980305321753300, -39.63364037658546800, -53.05728653871259600, -66.94468639932982500, -178.65090601389139000,
0.00000000000000000, 0.00000000000000000, 44.22512649424554400, 308.11155237410668000, 770.18525695657661000, 804.34739954643817000, 1082.88468924307540000, 1138.18882511465340000, 1214.30720507874140000, 1247.75439502523300000, 1275.74039247487940000, 1564.49181373203710000, 1625.69798750261270000, 1712.02213605994580000, 1738.60878190836590000, 1742.44912939404050000, 1759.08908080693750000, 1765.32470942191840000, 1773.93895586976920000, 1780.15535872206060000, 1782.14373857221930000, 1809.69919821322420000, 1853.74349378938720000, 1866.50070644339710000, 1905.42288008081070000, 1908.13946582058520000, 1963.16733713257240000, 1994.56615066720840000, 2004.17483345037910000, 2017.15084186237780000, 2039.39622491616820000, 2052.00446653908970000, 2070.25956662546560000, 2074.92053952588000000, 2077.71764821358780000, 2096.54488177423720000, 2099.13415811776390000, 2099.62841058138840000, 2100.37658736655790000, 2124.54573494141500000, 2138.08337842392850000, 2161.65811128209820000, 2169.16035587567830000, 2177.42771461474290000, 2178.24351647866390000, 2180.35376821673440000, 2181.03372476258850000, 2191.63500830214980000, 2201.21220384528490000, 2264.29421246255650000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -11.68803314312464500, -37.79130287108535700, -88.88218449658280900, -120.57900295477546000, -193.34827408202895000, -239.71790767564121000, -271.09032039780936000, -340.88451676595588000, -349.43033663501438000, -350.86068540453886000, -352.84161211398185000, -390.67959754341376000, -412.80863076165537000, -468.08955445860352000, -482.09973937396313000, -490.86378953775136000, -491.69322468480414000, -493.76900840971444000, -494.23163535019614000, -500.81284411578326000, -511.35279038044780000, -559.56470417935361000,
0.00000000000000000, 130.39442125586311000, 164.06444129950825000, 348.96000763867863000, 589.20839852963479000, 609.88084329771095000, 790.29824162037812000, 822.16281836844155000, 868.34700864960882000, 888.77045041465340000, 903.51429179178797000, 998.09335571825034000, 1007.92862327569800000, 1019.03051908521580000, 1024.60139441901970000, 1025.24128823187860000, 1028.39098618229540000, 1030.61685959697820000, 1033.29514721326060000, 1034.96242926379550000, 1035.03753641287900000, 1037.75256221344900000, 1039.08065222798610000, 1039.39545033601730000, 1039.46467760947190000, 1039.85837700626670000, 1048.59333377581580000, 1056.71067480076640000, 1059.32967488111380000, 1066.39950515540070000, 1089.96792286623990000, 1097.29329438121980000, 1113.56129020460460000, 1119.48920427178610000, 1130.65346233142420000, 1160.27460112521570000, 1162.85793373943100000, 1163.37523820924300000, 1164.28389786967640000, 1187.37765808700030000, 1204.05533124410020000, 1276.15050211984180000, 1291.09075890936110000, 1305.18953173847560000, 1306.53498812315980000, 1308.92113302906660000, 1309.47036391550020000, 1317.70813286579510000, 1326.02543446071630000, 1356.13141747709800000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 50.89065340953038700, 54.16843963972261400, 120.40505960843410000, 154.39218236701359000, 167.01503512764810000, 193.47881280470571000, 259.71946408800511000, 298.48738167113925000, 392.71549444020451000, 444.24919171252969000, 479.51471154903084000, 575.37467889893298000, 587.43021457486918000, 589.09119145934608000, 591.77938924893363000, 647.00360252197902000, 678.52527114522422000, 767.49279083330714000, 785.35326192701609000, 800.98064181860548000, 802.34384495812037000, 804.04180185873065000, 804.59891391725228000, 811.73598861617938000, 811.98473385491548000, 815.88494992956510000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 412.61183063150389000, 445.06073587733692000, 692.43177367773535000, 735.48081178477173000, 792.49878184885756000, 821.24871671264225000, 853.56857607113477000, 1119.39365385185900000, 1176.85562652165030000, 1247.47340635847290000, 1274.74145413417090000, 1278.20224250828690000, 1295.15577774923050000, 1300.34523607870280000, 1306.69361842777020000, 1310.46259761712870000, 1311.51597273000580000, 1326.40229231678090000, 1356.33905350974690000, 1364.66770310257830000, 1383.54187127545470000, 1384.58235378845100000, 1409.61956354366200000, 1425.57711517175380000, 1429.44315602648230000, 1437.46964676914220000, 1442.28767526422280000, 1442.49815552267960000, 1452.86471042400350000, 1460.66492632277140000, 1465.53516344912050000, 1472.50883211980200000, 1473.42343313538230000, 1473.43572136818600000, 1473.39553526302010000, 1476.10754882127370000, 1475.54402595544680000, 1525.35511015652900000, 1540.90607255915280000, 1551.54810414854460000, 1552.42981756761560000, 1555.06961112753650000, 1555.75865881199890000, 1566.08409393478020000, 1576.35900174059410000, 1646.25994589766720000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -28.35381112078047400, -62.60201432322905600, -403.00464369678616000, -458.63399730197563000, -524.36508576059680000, -545.69006923003462000, -548.34148064942974000, -559.18515151539339000, -565.88897760826762000, -572.15171340232098000, -576.11506925839069000, -577.34484140734583000, -595.14774928831264000, -618.78334808855334000, -624.13918459203194000, -639.50703610552171000, -640.78601767493490000, -675.42508227586859000, -691.32075147117996000, -696.38039297876560000, -708.25122323881737000, -745.84814804689063000, -778.54610038974442000, -859.91037977521262000, -894.28625529890689000, -916.35728486627795000, -932.67831699164321000, -934.37944905338816000, -934.90008683899623000, -935.34365064354006000, -948.47770538268639000, -960.88015603751171000, -986.07614991744526000, -993.24679400353966000, -996.71087254720567000, -997.03506320215172000, -996.68384436215399000, -996.48313689988777000, -992.08985431700512000, -991.64974558718814000, -981.48397571869077000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 36.73637780013713400, 122.85697980914861000, 189.01815006060036000, 348.88733096603664000, 468.63542755147461000, 547.10118475694571000, 740.96817546307875000, 764.37039420161204000, 767.89067268705696000, 772.15735181993534000, 861.52073565230717000, 905.13791690934784000, 1091.14360335528950000, 1133.21629687528250000, 1164.86751703651540000, 1167.82890976112570000, 1174.14413982437850000, 1175.30076055193740000, 1192.51035991400480000, 1202.85258260949880000, 1274.36334491738260000};

double larslsq1[2500] = {
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 900.25399348292717000, 825.36128293231400000, 969.97443921964873000, 894.56280590924018000, 868.29193084863118000, 904.94646637624123000, 781.09493675915394000, 814.45185144284221000, 675.48811446961554000, 723.11707225183272000, 664.52789555753543000, 636.94888281545707000, 427.14740420820613000, 409.92738126737999000, 441.18756109184733000, 550.44879339342492000, 556.81384201318212000, 516.77327053513068000, 517.95566345976806000, 581.34588641085168000, 484.04386708954451000, 463.13555621785491000, 437.24896278520339000, 505.41253625709425000, 447.32443197745476000, 445.92999659959372000, 418.74664805667345000, 507.35678201377237000, 504.58258489466027000, 493.03321847286304000, 497.13440648719154000, 479.59989974437087000, 504.90974472936102000, 509.14177613729743000, 507.60564930058428000, 483.89853529790855000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1023.50442838603750000, 955.03074878246616000, 930.73767733668285000, 977.85535983939167000, 951.64815246187720000, 1090.50838412868370000, 1015.82399886921100000, 984.66577148157342000, 1025.05049279181500000, 1179.96506638223540000, 1024.88662113633880000, 941.26208705859869000, 949.91317056732862000, 1250.38308212225370000, 1356.12422020064130000, 1298.94266714560330000, 1502.40900779913930000, 1475.15926597776000000, 1374.22512321923360000, 1365.50664757382810000, 1422.13350319931740000, 1394.41378930077580000, 1401.44932518625640000, 1415.14551994016140000, 1398.71880383597090000, 1403.40331382803900000, 1384.02362689643910000, 1415.33650383842110000, 1409.90038089533640000, 1426.66319519406060000, 1424.90191401278250000, 1470.86989072924670000, 1468.13280918176270000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -825.12350599270974000, -960.91229511284905000, -830.52047785125148000, -915.07545291619306000, -1052.21297590710580000, -986.73535636620079000, -1007.37814445218120000, -900.49335057614235000, -911.44661961495979000, -959.84955813810939000, -893.03622732343001000, -886.34018328457773000, -872.87087295513754000, -958.40000704428712000, -1103.59478965762060000, -1093.15120321484600000, -1051.03815778831630000, -1260.22963938357220000, -1322.11585990131310000, -1280.26476083392500000, -1413.47277836552120000, -1395.90102052206590000, -1393.23011450182530000, -1390.19900236166040000, -1361.16617808659590000, -1345.78911427019690000, -1347.28350047085970000, -1299.02483664126790000, -1266.86898007796440000, -1275.10575592353280000, -1264.74056487024970000, -1270.88737342138800000, -1292.77611984528130000, -1268.08981359931180000, -1270.50140030230550000, -1274.83446435401150000, -1254.38005058313550000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -478.28423818557508000, -486.01340403057918000, -495.09345820262951000, -504.33832449758540000, -508.67629713059176000, -528.26850990545745000, -537.05094772216023000, -513.13223434516806000, -529.50400487514025000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 131.19675302809580000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1004.07802199798080000, -1072.94639967757050000, -899.15073669268270000, -920.38817866495697000, -1009.29778042939570000, -1041.58307254682150000, -1105.11664320622070000, -1124.33890286855440000, -1260.12573789016600000, -1364.72958430324910000, -1372.75428883685890000, -1316.73416287518810000, -1362.41650676492600000, -1360.57815683377930000, -1389.20581186801590000, -1402.90220959970040000, -1410.38267246743040000, -1399.36563575622650000, -1396.15796778986850000, -1419.78326104159120000, -1430.64126718735790000, -1427.62584787271730000, -1424.71256874824010000, -1451.01850759114470000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -104.29108545400338000, -77.72947294097943400, -94.71625976646635100, -88.12782767314739400, -105.62064934991560000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1704.29902929860830000, -1790.22458982157330000, -1857.00891201779400000, -1731.34081680994970000, -1703.39364371819330000, -1419.36927947834400000, -1430.45725504191300000, -1424.59882763021980000, -1387.93680975122110000, -1423.12195580499700000, -1420.85517264370330000, -1406.47287505411400000, -1491.47268161074770000, -1519.45286407010490000, -1558.01400652073740000, -1728.09126166960140000, -1717.44601039570530000, -1676.41978299165340000, -1770.16737082395370000, -1661.84460637527040000, -1644.46658331102190000, -1463.62253062922420000, -1280.09342764099260000, -1264.39530613488910000, -1231.69090306387310000, -1468.25802792410060000, -1413.17564863082680000, -1366.65903843382940000, -1402.95654783184390000, -1404.91374227461850000, -1263.18556061590970000, -1247.80161361772960000, -1181.85651664513600000, -1178.41211134688750000, -1160.08048622044000000, -1187.16767735772530000, -1120.24718186041810000, -1120.74523155868340000, -1134.12498604241250000, -1147.09243278749340000, -1130.45396608341320000, -1109.54925830546020000, -1115.02783833389710000, -1098.42740250077420000, -1095.45145233732320000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 960.44584101222324000, 1015.77714872243860000, 1021.13109836526640000, 1095.91076781875560000, 1096.63648979368830000, 1063.25143530868190000, 1096.20161901960140000, 1049.22474603628870000, 1105.58030949794100000, 1038.10169348255680000, 1109.18832702289210000, 1131.37715220284350000, 1140.53965557094510000, 1207.31583354600960000, 1283.46919227324020000, 1439.26558545293820000, 1479.47413682104640000, 1340.13413495128540000, 1268.97226838874940000, 1204.01238594841900000, 1219.95304076640950000, 1118.59161786109170000, 1076.15617991093110000, 1180.27841268029280000, 1168.06155113794760000, 1145.63016191030740000, 1136.53004749222460000, 1102.30724517929750000, 1127.21848439133100000, 1076.66378050972340000, 1066.13773272627800000, 1049.46337546308000000, 1042.46087982862170000, 1064.62470817100050000, 1082.07229175205660000, 1077.08751553972210000, 1085.60618143198420000, 1099.97906621115890000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1802.51878152217610000, -1671.77624091211810000, -1499.75083651628350000, -1389.69651817757450000, -1189.01735115620700000, -1264.04853444862580000, -1129.49668791748080000, -1072.75065586785400000, -1124.59222346701700000, -1120.28423568747760000, -1187.46744490266860000, -1283.23867302068150000, -1327.24435670362800000, -1357.33246896140370000, -1321.52113245684970000, -1367.87952654049790000, -1308.50608521594650000, -1333.60244339363160000, -1289.62366016014470000, -1150.61210382879290000, -1238.68418076332140000, -1305.98784399347730000, -1353.35920233785010000, -1192.55537528621130000, -1038.22857442189430000, -996.34900921312271000, -880.70117164125918000, -815.22097400684618000, -635.44420851604423000, -555.41984865981499000, -660.84348092885807000, -613.78968682421100000, -494.25411878692870000, -495.17464297120591000, -433.81545078758126000, -452.98683048904326000, -472.40255057999809000, -439.03468179868889000, -381.75808261160245000, -378.10231009368556000, -395.08737283614596000, -401.08151892714977000, -404.46375675449923000, -394.43746170416944000, -408.15899553724728000, -364.39684343369015000, -354.83924095078743000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -631.29219662377136000, -456.68791742959593000, -357.93234601147708000, -333.46834593529883000, -397.96544082695777000, -401.50239110863112000, -508.06340729439677000, -518.29431527941654000, -549.69692480463561000, -685.10651461819361000, -680.16957151795066000, -769.60141677629338000, -690.28914700260304000, -651.22171288108495000, -657.12840772354753000, -700.55702488742998000, -800.92139791103466000, -1000.44813944321700000, -969.11640688793318000, -1062.77476834957930000, -1039.00875584632330000, -1041.27139943574050000, -1072.62916849323850000, -1118.24360973631790000, -1113.11355649484040000, -1116.31463498748580000, -1114.01378350516800000, -1104.42958123907650000, -1103.38796601881200000, -1096.65352948624880000, -1100.22451853661690000, -1103.12685175751810000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 791.93900941644438000, 937.73602871529465000, 907.42138881199821000, 921.38705588210712000, 955.37195016520320000, 948.26891252484631000, 820.57867253259883000, 847.62570306514078000, 928.60381741721631000, 888.90117093992308000, 656.77958609740006000, 731.39325209669141000, 822.16059397251172000, 881.31720623413787000, 970.35442741064105000, 940.30688872460894000, 920.00430899977619000, 957.25196807472355000, 891.61946861542265000, 736.28946002946770000, 747.43071536223067000, 771.23024455566292000, 736.02924076357147000, 722.97094410641978000, 697.51081746516365000, 646.32497056329930000, 644.94895432344958000, 628.41423193105175000, 639.33950304349605000, 643.79928768780724000, 649.62095922465164000, 666.99061665919214000, 694.31909198772269000, 681.57533324836504000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -956.73648158343781000, -962.22142630880569000, -991.05475104663583000, -962.57066525108792000, -972.98497945520842000, -987.29514688903771000, -1001.48543284862300000, -996.12497175813587000, -1002.94074626274450000, -959.67417770100678000, -954.74714042772871000, -1047.05276282846760000, -1048.86818313150820000, -1096.29779004322450000, -1101.77659892993760000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 484.20074732142365000, 665.54547050693202000, 636.03748199422887000, 578.53189493667026000, 491.03511115351102000, 415.27155676472410000, 342.35642955240201000, 165.80069752574803000, 82.08253252189602700, 137.00646062959268000, 205.98653204132466000, 380.68338056081166000, 317.76306180719092000, 259.07258794563518000, 172.04589452681151000, 143.50870604314184000, 144.78078181994272000, 128.68600697295355000, 91.52620870735475500, 95.30458260992767800, 97.57708973407675000, 101.23892642944527000, 20.00411386944880800, 20.19657191002558200, 24.60971238878280300, 55.08806372249787100, 61.18028611274745300, 65.36697412102054700, 74.16607526439888400, 63.51347650098367800, 52.87696143938891400,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1199.33705348795870000, -1218.51820344774980000, -1166.91316667323100000, -936.01764271575166000, -997.55703779590692000, -927.42619434251912000, -1008.59802294936330000, -1040.48182095448190000, -1024.53616625788300000, -1097.09776717123670000, -1154.81167668520150000, -1215.63268443818720000, -1250.18392913676170000, -1389.68895491755730000, -1425.46390408309910000, -1441.56740720338440000, -1415.61729187808190000, -1572.44449372798750000, -1580.44648791551640000, -1686.02047389373730000, -1606.04136428119980000, -1607.50512062604160000, -1625.79540790891560000, -1661.91391396089260000, -1523.78378334914510000, -1498.85794089641850000, -1335.07329517801780000, -1447.74046829710260000, -1449.78702930879600000, -1461.15483388777060000, -1480.83172916427070000, -1428.32652344649250000, -1393.61403953018230000, -1458.32366249736170000, -1405.40856846430920000, -1415.68068224042260000, -1397.63181522206990000, -1396.95355727739750000, -1422.00959985530950000, -1434.65507960422200000, -1439.11650516948270000, -1423.52945386819190000, -1461.67802090289770000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1000.43704293398460000, -999.88671413470149000, -903.47971573160248000, -763.36039071159769000, -723.57297996965519000, -691.22254846707835000, -725.56787064679486000, -788.26487748203772000, -739.69288302773509000, -673.16667903524024000, -641.39645694982232000, -640.15872701141666000, -651.00874890879663000, -719.85679361627638000, -870.95005026648619000, -899.88594174870570000, -1117.46046716229010000, -1142.76746143675970000, -1158.48260894590000000, -1289.44470345113220000, -1271.96913855810230000, -1565.64274435985680000, -1567.99153660318070000, -1638.18793795371700000, -1692.86178565314960000, -1713.30657287762390000, -1713.17647401324280000, -1727.75736643889970000, -1755.38634770943420000, -1769.55572314639330000, -1763.25607246919050000, -1787.26704620411010000, -1801.80436241789810000, -1801.19055546907480000, -1799.71517940415860000, -1806.44205840601310000, -1783.62382046859760000, -1777.71165359683890000, -1788.93269854115370000, -1787.50589201825460000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -209.94364013291244000, -171.00765788195173000, -291.69330026599403000, -297.49361704238089000, -312.41349044617971000, -318.90075829219103000, -312.06164590999651000, -304.16528308221359000, -314.83433275165254000, -295.68994246278402000, -246.36702282311751000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1327.18984465525180000, 1345.43444542693780000, 1205.71045392255060000, 1278.52029241134050000, 1334.25650751666900000, 1249.98702933119850000, 1367.76420063766590000, 1413.88793950241440000, 1364.53946957248060000, 1335.88419919176680000, 1365.77744877908140000, 1440.92632218915110000, 1354.19933002110340000, 1374.02940286779150000, 1447.74659853660930000, 1450.28395540329350000, 1654.74294899630970000, 1589.04114565317740000, 1483.14836795170620000, 1502.97572958930960000, 1563.27091743187040000, 1723.45916285049200000, 1724.08711935445760000, 1788.21289539342000000, 1632.57809131702170000, 1581.77582346319630000, 1607.68135725479600000, 1606.68186299425970000, 1650.04094842295580000, 1732.23923989984110000, 1718.41936120053790000, 1712.94290190876110000, 1713.79557710128030000, 1696.72463079264210000, 1686.33171250522420000, 1699.97550191216460000, 1696.39191764662700000, 1682.44424628521010000, 1664.76739766942160000, 1679.57028780324780000, 1675.36561361138390000, 1674.21711088121170000, 1676.63370149701630000, 1683.36280524305290000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 146.66424034206889000, 153.82492792134107000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 378.30423830902049000, 402.02286726204676000, 455.04638941427078000, 622.54907546101742000, 606.98941865423421000, 612.59953913108870000, 602.79836796680377000, 624.97307573290095000, 655.20394962561136000, 633.89690498756386000, 629.93716341158370000, 621.43622111792183000, 600.07610087336332000, 589.47958209446972000, 606.38596670105449000, 599.54569443261107000, 614.33268356537747000, 624.35196093369188000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1095.48182710796730000, 1045.81349754300410000, 801.05733650421951000, 797.79188990726459000, 736.73699541657777000, 765.06237636213029000, 752.40710975859599000, 814.09911355779775000, 878.45423517722884000, 808.29271552110777000, 1101.91340579691250000, 1106.42409784379220000, 1041.22280013391110000, 1068.80772353536550000, 1062.55100601168350000, 797.66758654006958000, 792.63149168793586000, 726.13625022904000000, 711.93458116751367000, 684.44169451049549000, 717.16484334664767000, 655.05596508367546000, 660.98155504447948000, 652.79635595238221000, 691.56226796830083000, 702.02679485097553000, 683.76365920333046000, 692.80069767227883000, 657.59557869909202000, 645.11712034142124000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -117.50563592051499000, -103.89929234255436000, -82.10967399506425600, -83.21600733693506400, -81.78862635114953200, -86.22110716923883400,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 233.96579902690939000, 224.92215839591671000, 206.80511804363931000, 332.89413455143153000, 265.37494322745732000, 304.63467289620797000, 541.55951886297328000, 515.03703680426020000, 628.34829722065899000, 543.26442487862403000, 453.80417770154230000, 477.40182386070467000, 567.74314047832900000, 561.77329666941409000, 644.32981409292370000, 660.32551592362256000, 702.05494405153343000, 705.06776113861417000, 652.89191623599913000, 621.98243658847275000, 693.59036683626823000, 709.81469964868404000, 727.26040883583619000, 718.01075150269435000, 709.94792889376515000, 719.57411819801109000, 708.88643937892107000, 719.32577588631545000, 735.48337561200935000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 921.69481948103157000, 853.74582077127968000, 969.06343173225400000, 974.19481457595691000, 972.18175459473491000, 917.32098001502322000, 914.69520575522245000, 836.36575011673688000, 910.32811128370804000, 923.41442920782856000, 919.85439874303563000, 920.91247021465358000, 937.16626285639575000, 952.68706766154298000, 957.91334149191664000, 956.65024991595180000, 959.00053383080046000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -401.58640991031416000, -344.24557111460348000, -371.14293331835842000, -400.42778618427968000, -480.59484518779470000, -480.68942594853826000, -470.87460255479465000, -494.13183663628854000, -482.81988544408802000, -477.86208918097782000, -471.26346240150042000, -483.63794326213042000, -482.32178983186839000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -654.05963126143740000, -491.40246044381871000, -464.88547790168440000, -445.71504933794887000, -497.83933152165628000, -665.94924686776710000, -638.06797372247092000, -665.02611806204163000, -760.70623835174547000, -778.09787860376616000, -798.22583902777978000, -913.25042487748487000, -909.37009858999602000, -892.82665840691698000, -697.82974026076135000, -798.78016297570798000, -721.72794836116077000, -695.14833377081402000, -713.44814408442460000, -749.86959458701062000, -747.49224009333398000, -791.25756526742828000, -800.55951861430071000, -832.81753763249696000, -836.06549765924797000, -857.81623228677347000, -883.24908976461415000, -871.49179392837107000, -873.12320243116881000, -887.71630858352682000, -898.23638658402740000, -928.45276359234674000, -936.38700369136200000, -937.99758780347076000, -936.48727404828730000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -218.17057935969953000, -247.55053800759671000, -215.88073903541505000, -209.61667905641792000, -216.41672187691938000, -232.55868096132264000, -212.76557054678452000, -230.29509982085432000, -248.55231724732766000, -239.71615378382529000, -252.60420879850057000, -262.40493246415906000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -434.67250603295344000, -586.75893916210146000, -564.49101793715852000, -657.42515401705271000, -649.82652598050367000, -670.61429612488837000, -693.17621130246232000, -758.54351786610596000, -753.63735228571818000, -741.79751632005969000, -725.31771612787486000, -728.99131513191139000, -722.91869198847019000, -724.70784440989439000, -736.74302357959095000, -745.53379977627094000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1117.32930197821610000, -1073.01037314381140000, -943.72955531860896000, -883.79520752472706000, -959.65724581069219000, -895.65937472175733000, -877.33855283139087000, -808.36686794433376000, -821.84090944833417000, -787.89814296150394000, -829.32281259166916000, -729.78711745628141000, -726.85962127515506000, -723.83345653415029000, -754.08714065977006000, -732.20480479753121000, -733.52324315276746000, -739.98463935476855000, -756.61622232918000000, -762.98659706035903000,
2677.88291006687950000, 2263.85679908056320000, 2424.07454608089940000, 2275.52320244851760000, 2370.18343358526770000, 2279.19707878907500000, 2172.09010714461100000, 2041.20071402222420000, 2066.78965657289560000, 2036.35143210368640000, 2001.29304828602490000, 2053.76350558833250000, 2052.40415080115830000, 1908.38410914625770000, 1790.52468891005330000, 1902.90317513471700000, 1843.39478202350030000, 1686.39266738357670000, 1810.00650242326360000, 1759.43911364382320000, 1589.04929070148500000, 1631.82744200521940000, 1680.29364411257440000, 1700.16589266779100000, 1715.48517534379880000, 1649.73136321222520000, 1565.41210589482560000, 1719.16352219254100000, 1720.66112128492300000, 1788.16032383510610000, 1597.46763185742410000, 1603.31984475175500000, 1685.17868278866060000, 1651.59656277636510000, 1679.03894991249130000, 1713.92045537079070000, 1720.47705101735100000, 1790.34280971274170000, 1798.10243392280970000, 1784.87936863674460000, 1801.27008469287740000, 1825.28836740383460000, 1825.97938650861760000, 1829.23148416231130000, 1817.40241592983220000, 1794.23552919916320000, 1788.44009569756280000, 1762.11073293705160000, 1773.39519828011660000, 1778.34540562128110000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 56.66488284666346000, 73.98885280856542600, 49.56173034197129800,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 88.70622290032810000, 65.40477851133492500, 28.87409182393774600, 38.79358227810560300, 35.30668382453364300, -1.84915353238552790, -27.69140896351865400,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 887.69751211086316000, 878.12226592157731000, 988.71982194319162000, 986.25635106763389000, 987.38371088887527000, 1163.56807462237340000, 1256.62725187614410000, 1222.84632055853810000, 1244.90522123832350000, 1297.40869315644180000, 1376.96135949813420000, 1356.96378072482280000, 1405.67685422941960000, 1388.64541481777910000, 1305.21686869736870000, 1229.85819959596690000, 1364.46167381282020000, 1438.78858790586380000, 1531.61510069554920000, 1680.14239304051330000, 1685.86558488042620000, 1784.22985555889590000, 1998.77807215635900000, 2064.99436341398090000, 2036.63553059135670000, 2123.15960221340950000, 2131.95998717580820000, 2044.95008794413250000, 2012.71871215650960000, 2002.81074093394140000, 2015.18024073697300000, 2036.16633959269100000, 2057.67414081304880000, 2131.22855774939810000, 2129.71442690072170000, 2133.74722805041120000, 2148.59823218127080000, 2124.28317331419790000, 2106.65619493988020000, 2101.55599357101120000, 2092.88395557771810000, 2057.15676910570850000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -227.31236933291305000, -202.34175965456922000, -200.84209986834350000, -199.15904860844853000, -200.44297317295738000, -194.08939376995133000, -200.47935164128364000, -196.47546279386214000, -200.89654806587063000, -220.44836737880578000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1155.77244513603730000, 1270.06155597972630000, 1304.67016683537510000, 1058.83925818521520000, 1017.69585881082990000, 1042.09941157381240000, 1254.35897933265730000, 1286.33669679372020000, 1577.09080848540180000, 1565.94738887815330000, 1583.94914134361600000, 1580.30908123589230000, 1566.37473766037420000, 1509.30772016091740000, 1635.93328519553320000, 1650.46018381293920000, 1642.08208370519670000, 1638.51686664654930000, 1644.80654492769350000, 1667.51206842672240000, 1659.75093243826340000, 1696.98117095449810000, 1720.69212291213080000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 153.29060339469723000, 155.28824265402741000, 183.60696273732543000, 151.36868652575615000, 110.57527539483570000, 73.24870577577992500, 80.31426507535923100, 75.72606668552639100, 75.02798388268709600, 107.70328800761395000, 82.08866316442377800, 90.72947615391386500, 106.88351882056121000, 115.06828427583227000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 175.68569709373000000, 176.52720477243068000, 199.25516615499794000, 209.17638837438366000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -712.97434248724790000, -766.30453448228116000, -773.76058318958133000, -543.61515577110822000, -523.70126829807714000, -637.03196379605515000, -584.99586349166384000, -462.09303315244824000, -494.87207819166213000, -470.56094729258700000, -505.66292300163974000, -440.44606912932989000, -445.23995163650227000, -492.67766239531221000, -435.98658031625888000, -440.84107278887780000, -416.82475784463048000, -374.47229924299410000, -383.18518456255123000, -398.08173018151695000, -413.46754386816770000, -428.72081628210515000, -424.50088275797697000, -412.60001283172488000, -431.80915001238560000, -434.10553328408105000, -439.06995221028586000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1226.68679668015220000, 1278.04505688204130000, 1301.34726808175970000, 1334.94923764520670000, 1421.85181052725030000, 1308.97711551219340000, 1210.70667774333810000, 1235.06237456598230000, 1227.83141601452230000, 1254.11134723885360000, 1240.53364317898420000, 1247.76674705602250000, 1260.50670900328150000, 1264.04291164003780000, 1186.38873836478980000, 1329.82753785726690000, 1534.92298089261730000, 1535.78478933781750000, 1470.18079019539100000, 1369.58856162791470000, 1530.42519821225370000, 1499.79755600150610000, 1530.44077327802510000, 1560.63323584791280000, 1793.75787225767340000, 1830.64831492001670000, 1817.69199759564090000, 1806.26948809211650000, 1761.55917293167430000, 1778.14189298231740000, 1831.93340330446610000, 1814.57213989277530000, 1824.17662834374730000, 1815.32846293571610000, 1815.59924080218180000, 1835.34522701250420000, 1834.63478324817040000, 1833.99581934315640000, 1836.04132905010990000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -943.26939707998258000, -787.56577295983584000, -819.75074574565576000, -816.23917751852184000, -995.71620080856030000, -1096.10957287215570000, -983.38884612318691000, -1140.78216696444160000, -1059.41766200962120000, -1187.21987061126470000, -1271.51685620033050000, -1265.11136544822100000, -1303.22679264603310000, -1308.87093090855570000, -1326.78069750511800000, -1375.94960444382150000, -1395.59545179908200000, -1413.50419165355240000, -1412.60745392481040000, -1428.41422065998290000, -1416.76012805828900000, -1398.07885866323700000, -1397.40939807165430000, -1419.30740169702560000, -1410.61878062177830000, -1400.48860762130380000, -1425.30717904571410000, -1435.14106948796580000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -677.84142541475535000, -712.68260597907010000, -668.62233451859709000, -638.84504881307782000, -589.71056847341742000, -649.92000853742695000, -681.30343943963044000, -685.93954546402324000, -688.17488542368346000, -748.59847578706899000, -815.54933799889420000, -805.16244855031312000, -778.08710643958420000, -801.68456577446386000, -826.56637099606485000, -853.14714162285713000, -809.27701441044553000, -788.89182313702020000, -805.71414753913734000, -788.92039144294529000, -775.86669227735013000, -753.97005253343048000, -750.01204381448429000, -712.47004484178524000, -707.14474338176706000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -751.35555249800632000, -743.83721770531156000, -891.52459921637478000, -860.78943048714041000, -1071.30965646630580000, -1083.76653334313100000, -1098.33718949800320000, -1110.72854877662210000, -1132.11483437654870000, -1098.94360463472530000, -1152.95680256436710000, -1150.82602600144830000, -1149.09065987779420000, -1129.41046463038330000, -1138.09119463061050000, -1159.36176498802680000, -1151.66186153241100000, -1165.05343800309290000, -1174.66078302770420000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -107.65453259516394000, -98.88089442329771800, -115.27740089934152000, -139.76619618000086000, -135.51068298192084000, -125.58196282686170000, -145.19874804811710000, -178.65090601389139000,
0.00000000000000000, 0.00000000000000000, 2537.10646404782980000, 2410.47853593795390000, 2538.88226158635920000, 2498.59560620283810000, 2452.09030016303630000, 2543.70869118935020000, 2457.34566941063350000, 2351.88357399057120000, 2210.25404452370460000, 2322.22921927049130000, 2409.71643594809670000, 2416.69662304044410000, 2337.97296079235280000, 2359.57140412432450000, 2318.51501919910470000, 2258.71648418716310000, 2284.59101811011620000, 2359.65245447885900000, 2453.65833339339360000, 2428.75978899784200000, 2561.94354140015050000, 2613.49025420676250000, 2531.21399175794980000, 2608.45559547794440000, 2600.29180096725620000, 2467.45500303183140000, 2429.03460006353040000, 2286.04558955318770000, 2221.25568306536020000, 2225.39413515491830000, 2164.40147967921620000, 2110.74214678509910000, 2105.50531039105950000, 2152.67214238471620000, 2158.77898735616330000, 2173.23019106233140000, 2189.40840894004580000, 2232.78589134558430000, 2239.19748355274940000, 2192.82352423084150000, 2202.67591338378770000, 2219.21507437516270000, 2223.22445695162010000, 2228.39646360947340000, 2249.38104261177930000, 2248.91114979601480000, 2255.17871002909030000, 2264.29421246255650000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -528.48884189207081000, -578.71512971715629000, -506.55806925480562000, -556.47649072584841000, -568.62084793987174000, -596.08874244203287000, -582.75715345543267000, -548.95316562159860000, -546.28609831004462000, -563.86157845767525000, -588.56867133483070000, -560.13486890602280000, -578.09274347438395000, -541.17003539420671000, -544.68889550888491000, -535.16167580487638000, -537.42586471142602000, -541.02699351069896000, -540.73359307012504000, -536.36950506648463000, -570.74429728945256000, -559.56470417935361000,
0.00000000000000000, 2126.49558766746850000, 2061.97567989776370000, 1822.01165393965830000, 1508.81625572186200000, 1635.11666928219960000, 1677.17595325469120000, 1631.98101618756600000, 1622.55019834701350000, 1562.97112388709160000, 1395.84339585053000000, 1246.28640081522490000, 1133.91315613246750000, 1109.65664010495680000, 1150.19012566203330000, 1128.06863051025450000, 1134.28208452998430000, 1206.73825846198700000, 1192.06389185122880000, 1190.38754070687950000, 1060.40268320861540000, 1098.74829583551420000, 1060.43536795729510000, 1057.82823049988020000, 1040.57771443051300000, 1141.35123025026180000, 1149.72853155341590000, 1178.96370443536670000, 1175.13199534538830000, 1212.90374339736260000, 1282.64339462426440000, 1198.03245987762970000, 1197.45566717966610000, 1165.04780633147560000, 1241.56392955305250000, 1248.58037219363220000, 1222.36584722501360000, 1240.40981634714420000, 1272.41292079893130000, 1290.80175321246970000, 1328.62265339949450000, 1371.45914402346030000, 1357.83492185540990000, 1376.45177050003510000, 1380.71953736841620000, 1363.24490436367820000, 1364.67750648445800000, 1362.21478323790390000, 1372.89256857458800000, 1356.13141747709800000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 869.11110707179569000, 899.15799140064928000, 887.30681280407543000, 666.26284457375596000, 725.15004685561871000, 741.87324932788795000, 801.24706649887071000, 831.62725824560732000, 878.65174006752568000, 840.30810553726508000, 829.85731926968765000, 861.14992847173460000, 865.13343021126036000, 836.43615184397618000, 911.67055762113728000, 894.32210903769464000, 913.96398092685922000, 885.10640311836687000, 865.14320193714821000, 879.96922405551550000, 877.50689861472711000, 842.69805537311004000, 860.59824971826572000, 850.29585721912281000, 813.38638754403348000, 815.88494992956510000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1991.98174862367020000, 2054.34210270330910000, 1908.43345626856170000, 1829.54506794362620000, 1723.62119907872510000, 1770.31624756473090000, 1932.79935414693640000, 1816.96807231761930000, 1912.91285542238390000, 1823.93490189427140000, 1889.46702568729390000, 1834.33149949903550000, 1865.12423053441260000, 1710.95917949046860000, 1683.02537977994190000, 1661.80927608990190000, 1667.26126056417680000, 1660.83815069324990000, 1837.70027009473480000, 1852.34587870099650000, 1687.00094303531500000, 1652.81121025669400000, 1699.50573324055520000, 1665.90938975382690000, 1600.38492320957470000, 1603.79823831771300000, 1481.67580579647760000, 1445.39269889799430000, 1506.32523956762380000, 1520.61298361311310000, 1513.91816143054070000, 1493.29855237421910000, 1494.49156730032810000, 1475.26562790357680000, 1468.61345405469480000, 1488.25314770126850000, 1471.33501348061440000, 1591.20455234918680000, 1610.37850420415090000, 1605.33824639874340000, 1601.04492936302790000, 1615.16803237795490000, 1625.01979232167970000, 1621.86989391562110000, 1634.25704435056880000, 1646.25994589766720000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -964.34485381850811000, -1206.22441007367500000, -1296.28442080400740000, -1171.21635321021450000, -1060.93592731932110000, -1026.43635365213530000, -974.40840623010752000, -923.74335239485663000, -1096.32670216009000000, -943.40635161826401000, -945.58166635907401000, -992.66284327813298000, -995.10764159492055000, -998.82648367904426000, -937.74639614623709000, -886.59151222716321000, -970.49820362964670000, -1076.48358109512720000, -930.72103183676268000, -920.09868596103024000, -954.24396663943628000, -1053.20884204523780000, -1228.21127105372060000, -1279.50758161715590000, -1158.47983430299310000, -1135.62023886672160000, -981.33415485446210000, -973.56558366138370000, -1012.43104687791080000, -988.12702254897613000, -1007.29782449458310000, -1053.51538468619810000, -1019.38484353642850000, -1025.28095807802560000, -1014.22005545692300000, -1014.90999239380610000, -988.68787902693111000, -976.30858780282767000, -968.35402328289558000, -989.16977842120002000, -981.48397571869077000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 798.00430596423359000, 826.90626405702869000, 1098.87249202368030000, 1173.33586631022310000, 1388.95171721302900000, 1326.61324423005040000, 1318.91942231408940000, 1303.44817319149300000, 1292.11418877735720000, 1279.88523485461520000, 1261.72958095242260000, 1230.91930247649750000, 1337.04009192964490000, 1321.17201620719650000, 1324.84859025209790000, 1331.11148578084180000, 1317.91877523414470000, 1291.56102009264400000, 1285.48961515570410000, 1261.12993765951210000, 1274.36334491738260000};

double lasso1[2600] = {
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 38.23740324743330600, 43.10537614002905100, 69.87845270767906000, 80.17097332676398500, 93.24532081516629500, 101.86021756666102000, 103.86551922079182000, 134.14706417487375000, 165.84286281083286000, 175.20027763222481000, 203.85277327394832000, 205.52629811762193000, 223.14573980221675000, 234.77545499979112000, 239.34045495042167000, 253.66242460947683000, 286.70289226177658000, 302.29867457902884000, 337.32487150684398000, 365.42029756699787000, 376.26893260634586000, 398.08828085816629000, 399.71757762979860000, 400.42260854195695000, 400.81346236372218000, 409.04874599745835000, 410.19383747836588000, 452.03863762221317000, 461.64903906139347000, 466.83265166983199000, 467.37243303415363000, 467.88691990588507000, 468.25161505436608000, 474.63795324272576000, 479.60678670964489000, 481.18551018576591000, 482.97986723940846000, 483.89853529790838000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 12.77390603082450800, 28.40525457939803300, 37.98205596755769900, 40.75683976124865600, 79.57435563940001100, 138.76506616059424000, 153.49211456355951000, 202.16134701631233000, 205.34106948138481000, 282.82615644229162000, 329.02958305357896000, 342.56968689473109000, 370.52893411168520000, 466.42422223224690000, 526.73432212476257000, 652.15349681684631000, 750.04789681529928000, 816.36244660154796000, 956.48761219162907000, 973.50502254025423000, 976.49756779545999000, 979.98025013888014000, 1056.91251975244290000, 1099.21131326367390000, 1228.19907855331030000, 1260.24431158660560000, 1280.68849816519290000, 1283.08705510169900000, 1288.42289390033560000, 1289.78463675617510000, 1310.88762595450450000, 1334.99987298357110000, 1383.97294013754250000, 1445.91954278502750000, 1468.13280918176270000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -90.04830212005545300, -127.03739399278913000, -131.38808982480180000, -154.02529135943018000, -165.23517454337318000, -178.86325883224873000, -187.65660628004426000, -189.76111104411402000, -220.51564596763188000, -263.80402912670036000, -274.36971940583476000, -310.20354608312971000, -312.37774651924201000, -363.73815955507769000, -409.80436728103615000, -424.91723217719766000, -453.74090480641848000, -541.64009780690924000, -594.54621366965534000, -705.91804073023491000, -787.38254829555149000, -843.03417677426035000, -981.23359414431798000, -998.24877331201685000, -1000.66958876290900000, -1003.54562375749360000, -1066.28933752755760000, -1093.76986225472020000, -1168.31780874835930000, -1187.84955492452760000, -1200.54936789094700000, -1201.80233640111170000, -1205.63017894307040000, -1206.24544063214010000, -1216.28111371836280000, -1225.10617227653620000, -1235.87459404432520000, -1247.32434131326950000, -1254.38005058313550000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -205.98087526602851000, -257.19942958403209000, -296.49153501244234000, -300.19402103262104000, -308.96618918348122000, -311.12643743031987000, -346.41195085338921000, -371.53974027411033000, -429.64703332379986000, -510.44714171150986000, -529.50400487514014000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 48.26084047949663600, 110.29885653913907000, 131.19675302809580000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -79.82675688003155300, -141.66205563987415000, -158.41463792333337000, -193.49232817786074000, -282.40695007385978000, -333.86922711882784000, -459.13233134813055000, -535.72107126560218000, -601.97099006876806000, -793.56235977714573000, -817.65988550283930000, -820.98892595642758000, -825.50088356632966000, -923.17046714485002000, -978.19815249223836000, -1161.10385255021450000, -1206.69748709898070000, -1238.51979577018410000, -1241.32788883524970000, -1248.83663519833500000, -1250.62751062650410000, -1278.27159933867850000, -1300.34292602323970000, -1355.76907063709930000, -1427.40909134806720000, -1451.01850759114470000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -4.38818567871125700, -5.11063761951886790, -19.10549094005647300, -29.50841676545992300, -57.50636816681918600, -88.06885247842370700, -105.62064934991561000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -33.68558078818011800, -330.61395149424897000, -388.40048442225230000, -465.89122627891169000, -502.27645679748122000, -528.94218847853620000, -777.69186462367645000, -824.53704512417119000, -886.02261892135380000, -908.83538518178841000, -912.00197497809222000, -926.28501429350956000, -933.33887156257470000, -943.06207195804905000, -949.58879358750710000, -951.88716297717235000, -984.51135458047406000, -1025.02295112299230000, -1037.53497001577670000, -1074.09131484405220000, -1076.29529950465580000, -1107.08879964568250000, -1117.86070707547650000, -1121.10145903589500000, -1126.19247867846430000, -1163.47419687596110000, -1180.40071090656690000, -1210.65208784210950000, -1232.79311425659580000, -1248.53428511856350000, -1252.21442449913460000, -1252.03082763184080000, -1251.56273474332830000, -1250.95313795956300000, -1234.36582525267520000, -1228.79284702097990000, -1182.04589336654930000, -1170.83386992631680000, -1164.77079493405590000, -1164.45588081452840000, -1163.02520517602780000, -1162.49843774331270000, -1155.08434853936410000, -1146.54511276395810000, -1127.75026503754110000, -1105.65910710861730000, -1095.45145233732320000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 69.54981373838141700, 172.81455449060053000, 208.84596563059421000, 214.33202382610537000, 239.81782971204473000, 250.09474030353178000, 264.13103161019257000, 272.46353345156075000, 274.92314042082177000, 307.44589608692490000, 354.38833031579946000, 367.43506134122197000, 412.70406968103867000, 415.77452563436299000, 484.75845883713640000, 544.18959965761815000, 564.87430631950565000, 600.56363499232998000, 673.41348019309464000, 709.38119187347604000, 792.30635102522638000, 829.87329415309910000, 852.39692208621670000, 934.75491104862238000, 944.46173270729923000, 945.80361280243767000, 947.39302128274278000, 975.67007301766762000, 993.56433445168022000, 1029.35246056282430000, 1036.08056628939330000, 1038.29095699164940000, 1038.36523805727170000, 1039.47014007437110000, 1039.88979465518100000, 1045.69943734460660000, 1051.71411198942090000, 1069.46841766150310000, 1088.80571792379190000, 1099.97906621115890000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -201.01830046555924000, -505.66573342661439000, -525.31388992661221000, -671.43061386684803000, -691.02550497367565000, -724.09024998436098000, -736.01007049544489000, -745.80126488012365000, -850.31879516875688000, -869.86809748453231000, -904.52870499568655000, -920.61403854157868000, -923.12884646090231000, -935.67103531391240000, -940.48665969832336000, -947.57679326453297000, -951.40747479277218000, -952.53582730638766000, -966.90078185331151000, -977.65717482463776000, -982.04018400176142000, -1001.00888426726700000, -1002.37039963989800000, -1017.49058898827460000, -1018.78181259286760000, -1018.28568982051730000, -1011.95194349671020000, -990.51023859127270000, -966.44137516407886000, -899.68480491042021000, -872.18574397637337000, -848.55431448109505000, -759.56041746821631000, -748.56053524818572000, -746.46104992857727000, -744.01539831302227000, -694.43692608476749000, -664.27999808622781000, -542.60734658496960000, -512.51902011701748000, -493.12325515231765000, -491.48366647985944000, -487.82218841625269000, -486.90229759386131000, -474.60395139801784000, -457.99372891281649000, -420.04826019215744000, -372.06110432559882000, -354.83924095078743000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -10.47267359991118400, -15.20852776934026300, -16.22034978051193800, -29.73983224383573500, -51.29963218123113900, -57.18002720286105500, -83.58142702119336300, -85.26119925266269200, -122.18502084599396000, -157.23459316911132000, -168.79979734023104000, -196.45788779109463000, -250.28054804916562000, -277.45914955220132000, -339.12360231659193000, -380.73733793482114000, -419.16497532915042000, -565.17295012333227000, -581.97918887205446000, -585.18630253540391000, -588.96820752942529000, -671.52873964652133000, -718.88915649299599000, -890.87763792927728000, -931.52506741427146000, -962.04609904049130000, -964.75318067809167000, -970.63025040008608000, -971.93798677731866000, -991.41640437192461000, -1007.81577295943670000, -1042.87603675131500000, -1092.13027760219960000, -1103.12685175751810000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 22.87555446674134500, 34.29352336385176900, 48.77807298244163500, 58.03940806028131000, 60.68859895135889100, 98.51271960646154500, 140.79005481569405000, 152.65881575808936000, 198.09414367299317000, 200.76348818301281000, 237.01792796166345000, 267.79956246973808000, 280.05978368134197000, 307.73885717123642000, 379.95731652038154000, 417.94173683232350000, 499.48485126645613000, 552.18999302695488000, 583.23227675756414000, 621.67751435754269000, 626.90952959162632000, 627.87221094025381000, 628.77353172824735000, 645.96772497994186000, 652.05373778395551000, 649.58655113615259000, 648.73832466294823000, 645.38146699402887000, 645.27383825885954000, 645.21179458877737000, 645.25522728088617000, 648.64992036962246000, 655.53309800946249000, 665.11275704511752000, 673.82622125085027000, 681.57533324836504000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -240.31515913696219000, -270.35037539585346000, -275.15778409311542000, -280.88630234786319000, -407.21756881249581000, -475.71092839326394000, -702.14425814530330000, -755.91396559698433000, -796.71449500044093000, -799.61738298127602000, -806.14467318067386000, -808.51775011208792000, -846.05634395297750000, -883.77229686522480000, -963.96537026800945000, -1075.61055621686980000, -1101.77659892993730000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 5.13900894187759240, 7.08872401437782160, 33.89129426509484900, 65.78028328311788200, 72.92090770421663100, 92.96719187214732500, 93.93085576985480100, 99.64469100891111000, 98.55120612540480400, 99.40168063601713300, 104.30834760476949000, 134.43045758694694000, 146.85802609242731000, 165.08349312708268000, 165.88511110987869000, 163.83869273755425000, 159.05168504719845000, 157.78830813902886000, 157.34631138714425000, 156.82928997890747000, 146.01377227118545000, 140.72692835182420000, 88.73568756581737200, 76.19973528337492000, 67.67879581129460600, 67.45451036691481800, 67.19051406370918800, 67.17255119422716800, 68.26481908111485100, 67.54870504076697600, 62.15169131017146500, 54.90553610465612200, 52.87696143938891400,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -45.40471629268547800, -113.09605909424697000, -144.08054675530227000, -167.10720402149249000, -396.24827427963316000, -434.71304118765551000, -497.34289943859392000, -520.41219111819021000, -523.52994921043626000, -540.09774256841274000, -547.76971526581326000, -558.84907110612983000, -566.18647410871688000, -568.61769683671571000, -605.13208751227114000, -654.10580833115057000, -666.89265315921125000, -719.91708753563319000, -723.24225554919906000, -799.78557298208864000, -849.98603784390139000, -866.73929249050605000, -901.68267815785737000, -984.54026718033606000, -1021.09397112637960000, -1098.69059795971790000, -1125.90658423126520000, -1155.33967552651980000, -1229.29960497808040000, -1238.94604005938120000, -1240.55952182088160000, -1242.12426802499660000, -1269.77624212018710000, -1292.03920616155190000, -1340.86356333472900000, -1354.54777597064640000, -1361.66381256214390000, -1362.29244765815660000, -1364.80512600361820000, -1365.49318639126340000, -1376.99187947084120000, -1384.00594125814270000, -1412.57768376646190000, -1445.74108835540100000, -1461.67802090289750000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -29.08907919776519400, -296.95548126865555000, -340.87638313882724000, -386.98338079251033000, -401.27969308415089000, -403.07284661034163000, -412.38827671276204000, -417.07942630063809000, -422.43134645633023000, -425.09249707060695000, -425.73109029366316000, -434.86889639297482000, -447.52399660903535000, -452.09684585971729000, -476.62272417549775000, -478.25825378293717000, -529.07645572214290000, -567.28712546350027000, -580.36197559707989000, -613.00482073877731000, -684.82533015086062000, -744.53330627687490000, -878.27629456087459000, -965.76892874073087000, -1032.26469409417880000, -1203.33028073085390000, -1224.54264772414920000, -1227.89930670537860000, -1232.29509157697500000, -1330.36321141709710000, -1381.47755803656970000, -1556.23739177809630000, -1601.15212107726760000, -1634.19175346946370000, -1637.14031077965070000, -1644.26390625361340000, -1645.63667791134780000, -1666.26451205551330000, -1684.75284649254600000, -1722.55064426149490000, -1773.51027112188540000, -1787.50589201825460000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -38.32176945495339000, -53.98881574462206600, -156.36011270000026000, -182.17373546069109000, -203.68496974250900000, -205.73737020279881000, -210.21110505680460000, -211.13660528723702000, -227.33240250136328000, -237.63513132052228000, -240.84716525554487000, -250.13507810037265000, -246.36702282311740000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 224.35045061025036000, 266.79264863697318000, 320.97036265695937000, 349.12438840767078000, 377.76845595337323000, 618.43452544302568000, 672.69655367306495000, 753.58508169972072000, 779.53476863695778000, 782.97551540713084000, 799.81004080826756000, 807.81152952298191000, 816.87570158814117000, 822.78898831625042000, 824.63404790187701000, 851.29603806467253000, 898.33827047935313000, 909.93613955679132000, 943.50048433157326000, 945.66235025863125000, 994.76380239544744000, 1040.13506822976410000, 1055.26131803521620000, 1089.00297312879680000, 1148.24721570205790000, 1177.63482242347140000, 1247.48136296594590000, 1288.83801043864700000, 1321.87157084408750000, 1424.94861827786120000, 1437.15859293824430000, 1438.99819309928940000, 1441.28820231174520000, 1487.91393441986930000, 1511.34235285086740000, 1592.58028219437530000, 1611.56765452826040000, 1623.27408756439740000, 1624.01323008844320000, 1626.35086694354100000, 1626.83368910524840000, 1634.23416266585010000, 1640.62454697285470000, 1656.34585269989380000, 1674.34099305396530000, 1683.36280524305290000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 22.10497768885608800, 70.55827671810766300, 133.04024726720348000, 153.82492792134107000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 61.44275137295257100, 100.65553584270330000, 133.06610186390358000, 256.01550429511548000, 270.61792277847849000, 272.89908750052234000, 275.64828540207429000, 339.41179865488300000, 376.69933771292307000, 487.46564735444701000, 513.52399534756967000, 531.34747152561613000, 532.57177135712391000, 534.96624293633261000, 535.66976642183204000, 545.64608511484971000, 555.99840905373969000, 581.14232296431442000, 614.69832017400290000, 624.35196093369188000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 3.23418614787750200, 47.66356911600042400, 91.77516407397023100, 103.63017416153563000, 140.70163665872161000, 143.11422635022038000, 191.55456047464523000, 230.31648479100599000, 244.65066728898100000, 270.59810525785156000, 361.20314524598717000, 411.71944309447377000, 513.96101043165595000, 577.84343797117299000, 622.17202737078605000, 666.25338523831135000, 671.51139992832668000, 671.87577121466040000, 672.20959915179731000, 674.44236761284856000, 679.48687545664188000, 668.96530710795423000, 667.50506161244482000, 665.07567733211386000, 665.54749713647834000, 667.08241194826064000, 667.24673139102435000, 671.23782035726845000, 669.18168556410660000, 660.32951417559866000, 645.93443684145461000, 645.11712034142147000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -2.09319073614563230, -6.37681742513716810, -7.12282763649592890, -19.00727041012643400, -28.46956653026922300, -49.71352132254684600, -76.56982658841479900, -86.22110716923883400,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 9.97042236767525840, 22.55595774854374700, 25.64975931726121100, 43.64040157789246900, 44.49720508172434600, 65.17879549966059500, 94.84001966961248800, 104.13307616126662000, 128.26548781053830000, 173.49621466436327000, 192.49745248614911000, 238.77054880058913000, 276.64689780657523000, 302.72293188476550000, 388.52849469163920000, 399.83672497367638000, 401.85265070404813000, 404.37947751054287000, 449.74134880845889000, 470.07892296365662000, 566.33775644625007000, 592.57999923574289000, 614.82468054984395000, 616.66278921693697000, 620.58788513653963000, 621.56295387146338000, 635.20137679442269000, 647.88045903476700000, 680.10526860431150000, 727.89408889638651000, 735.48337561200947000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 106.11958425360564000, 174.49321538329349000, 374.07509781696569000, 399.04333302109399000, 402.86641322664997000, 407.15359267566055000, 499.79699293735302000, 539.53775482920116000, 699.22464405733444000, 740.22943996062281000, 769.89745163387022000, 772.58756292458304000, 779.51242990547382000, 781.21829515294530000, 808.81501505433982000, 831.09648298831553000, 878.14610008568923000, 940.69416911843712000, 959.00053383080046000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -2.67875437548409100, -5.52518306272378630, -72.26270902476250100, -111.01119626377704000, -270.17839729506903000, -308.68131909202930000, -335.47020333012995000, -338.29652785845161000, -344.37753972284787000, -345.69243581239971000, -365.30446523999359000, -383.13948000176009000, -419.62377951848526000, -467.67445499969568000, -482.32178983186839000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -4.04503615923393940, -18.12259916778914700, -23.69844903490367500, -30.69939429029375000, -35.65733028651085600, -37.51813832118887900, -63.11049214680064500, -98.35296353237052400, -109.47480309679146000, -148.62591383553482000, -151.13603015684876000, -211.72606317149331000, -255.16395876744195000, -269.26647556010982000, -288.99551948335017000, -344.55693881367108000, -370.12423263665943000, -422.91342454597748000, -456.36421866676665000, -483.20654619291781000, -549.59040403660140000, -559.64506872136224000, -561.25207189886555000, -563.51514809434457000, -613.26474591155318000, -642.14045758420662000, -745.97780601768284000, -768.93458548839203000, -786.14304652092676000, -787.95242536070737000, -792.59276923214168000, -793.93106475799812000, -816.18022638696857000, -834.54032595825242000, -872.04160007965595000, -922.65813481150997000, -936.48727404828708000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1.81811278311459510, -46.67253819508451300, -66.65200056734384800, -128.22206133083480000, -144.35305522524610000, -158.92166279360723000, -159.88081311881433000, -162.84358757971339000, -163.68786561741805000, -175.56217345220475000, -187.17381422068348000, -214.84764694019449000, -254.87652575280543000, -262.40493246415906000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -39.75266802854046200, -177.15089797668296000, -193.26634785958089000, -196.36248707701975000, -200.14140524386349000, -286.01851801438579000, -334.09415366458245000, -516.89016608600105000, -560.19173776234027000, -590.18691434972197000, -592.59407159145030000, -598.33316643464207000, -599.56040225354764000, -619.10627509561459000, -636.83628000044337000, -676.82075782738139000, -728.75905782776931000, -745.53379977627094000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -121.77770097579864000, -186.25891667825772000, -309.28444853675433000, -375.43090135869278000, -428.86091039351169000, -546.11236823932484000, -559.89317405474515000, -561.55060064656664000, -563.71971592848138000, -604.63981235100130000, -631.16952856275122000, -673.64079492514622000, -683.37463320519873000, -690.05707227683808000, -691.19767412902991000, -692.92310351488027000, -693.32303717807815000, -700.61077496190990000, -709.05181799748902000, -728.89177370197694000, -755.42267733946937000, -762.98659706035914000,
197.39805776885407000, 324.11108420782347000, 360.71622910444682000, 574.25699630587371000, 946.25864515499711000, 972.60425969796245000, 1175.36740730566290000, 1208.14627921151440000, 1257.69197435326420000, 1280.58623578375020000, 1301.54177486071650000, 1509.09783115728310000, 1548.44086511148630000, 1587.72259414903280000, 1596.33641372988250000, 1598.23237791392810000, 1605.31401660292070000, 1606.32592337875280000, 1609.70483449848760000, 1611.29402204867260000, 1611.22834902680570000, 1612.10617671888710000, 1616.09858822145040000, 1617.51019605704300000, 1623.24710434542840000, 1623.34944205801370000, 1618.74327645449560000, 1624.99581202942090000, 1627.11154128724640000, 1634.52547235968790000, 1630.48653897496090000, 1628.64499008646790000, 1637.82697980041440000, 1639.41234448932100000, 1643.03636779105200000, 1660.84118773354070000, 1663.32236310486970000, 1664.16964420983250000, 1665.28576590584700000, 1687.11561733282660000, 1700.59454373189400000, 1754.29596412084790000, 1767.40701689556090000, 1777.61834292171810000, 1778.32703789123480000, 1778.99640875283310000, 1779.08943425342430000, 1776.43765383158670000, 1775.97910025419310000, 1776.84954775545360000, 1780.58840595388530000, 1778.34540562128220000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 8.85007776146016840, 18.66767996454239800, 30.03208344723634200, 44.67613587377818600, 49.56173034197130500,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 14.65128941064675900, 15.55538845560227800, 16.11579055637157200, 16.33917925398209500, 19.30157645586948300, 16.11377543905073400, 0.00000000000000000, 0.00000000000000000, -27.69140896351865400,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 51.22218545292967200, 75.53482486250209100, 102.08693115435599000, 346.05052645984028000, 392.49208684420637000, 476.64201470431755000, 509.77112077514738000, 514.18113911218165000, 535.28846978042782000, 544.80015516995525000, 558.60509798731721000, 567.07838604420272000, 569.55417658889485000, 604.45964412633089000, 645.48934226321524000, 655.30171418735381000, 696.82645529762340000, 699.69346803366352000, 765.83335403733588000, 822.76161338212842000, 841.84997821631873000, 885.23273059817802000, 1006.59801779433310000, 1078.34353816743990000, 1233.98571890636530000, 1336.36099630983090000, 1409.12194191548500000, 1568.83064440349450000, 1587.29879562475180000, 1590.07043932108990000, 1593.61306897560100000, 1674.39391281248480000, 1719.65018795363040000, 1896.90309758893340000, 1939.48479253990920000, 1971.57042386567880000, 1974.72391489190520000, 1981.01681896007540000, 1982.25443578419620000, 2000.88728227456550000, 2014.75285991006940000, 2030.35117503727070000, 2055.02775890547990000, 2057.15676910570850000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -26.84018213822632900, -102.42278691843823000, -120.42389182044649000, -133.42829592172177000, -134.62206420789113000, -137.12423093479251000, -137.74831365304138000, -146.92048185484566000, -155.05566011332323000, -179.11042473989929000, -211.51023277059255000, -220.44836737880584000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 71.96266327193194500, 98.45975924954096600, 153.98803260389133000, 252.60775176934797000, 304.47078455299720000, 424.27365152111918000, 519.84575198272023000, 589.94464172856487000, 837.89817200786661000, 868.18896829293362000, 872.96339702866931000, 878.85802422502366000, 1004.35292834318090000, 1063.97607434149150000, 1310.29873668421460000, 1372.51500003589850000, 1417.03843062836840000, 1420.98374445861620000, 1430.40138550925670000, 1432.73705589976070000, 1468.19270954918080000, 1502.67530614557560000, 1582.87298309239120000, 1689.34239146236020000, 1720.69212291213080000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 6.37772053351587690, 7.37101787337114000, 8.83967063646052330, 34.85600570663974200, 43.79664978935660700, 56.48065604781439200, 60.83987461416081300, 63.29857368993045000, 63.50751594673028000, 65.36711164633293000, 65.53182810821284900, 69.46726630922007900, 75.10657842125753800, 89.80652691101316500, 105.90999949549585000, 115.06828427583230000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1.73060056041315400, 29.03081653194620800, 54.68673266897801700, 111.51588779398540000, 189.49329032910200000, 209.17638837438361000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -11.97183822010104700, -56.14166125952052500, -58.91460949821880200, -97.44953588765653800, -123.98954384304461000, -135.33596468094049000, -156.03619875338993000, -189.39332775292519000, -210.10081791373281000, -252.40377239165625000, -281.56283372421899000, -296.09338816393551000, -333.55634774118573000, -340.17665748826556000, -340.81575095272711000, -341.64930658978506000, -355.37135270576380000, -357.62672000309266000, -368.63388787545387000, -374.01996183391623000, -380.53537779952950000, -381.39373078539882000, -383.20752135160711000, -383.49705352792478000, -391.04257006704211000, -397.53294453670509000, -412.81236917994323000, -435.92333525574338000, -439.06995221028586000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 338.47237247948533000, 406.51067552945096000, 504.16698425051567000, 539.45364364200941000, 544.91084100031242000, 566.98127757556836000, 575.01532954773677000, 585.96502495032632000, 592.77740006832664000, 594.72985335247347000, 622.25069861274642000, 658.87498695042973000, 668.97722656170481000, 703.82119678463346000, 705.68588397944529000, 755.30673312786519000, 803.84852157015530000, 820.03598794256834000, 849.96560724643405000, 906.59930390756642000, 948.88659410309833000, 1038.36348025129910000, 1095.01893350212460000, 1137.60136172934130000, 1302.41618721336160000, 1324.39350880210330000, 1327.68402225740280000, 1331.67228848376860000, 1410.14109119239720000, 1453.59322965737010000, 1616.53157028044690000, 1652.75361818540980000, 1681.06694335422120000, 1683.45861560727740000, 1689.01860759059970000, 1690.46000511904960000, 1712.97761979649910000, 1731.21727108903750000, 1769.77689259574840000, 1824.70415816264400000, 1836.04132905010990000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -55.22891133608180800, -67.52587338297750800, -111.57227315160335000, -114.29517355405908000, -184.37038734231010000, -241.13863811366946000, -257.55420707941522000, -298.21388244141127000, -381.17746899175523000, -435.81667082414947000, -571.54795139853024000, -651.40156410941211000, -711.01378149837990000, -861.18484611994688000, -880.55615888106377000, -883.86064660061515000, -888.12516106276939000, -984.02448944452306000, -1034.62993982872400000, -1204.21953604735290000, -1243.09366936579200000, -1268.69201848400640000, -1270.98493000627630000, -1277.22579463311400000, -1278.53978877222720000, -1297.58609180003080000, -1316.83599059865720000, -1360.35461745803170000, -1414.11441829584010000, -1435.14106948796600000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -2.61924418278335080, -59.07108767472670500, -97.02400073145624000, -109.00688828864297000, -131.13623254555935000, -187.67846716876366000, -221.13982656527546000, -296.63084853787558000, -341.71137794206135000, -378.92295102578106000, -488.59572058002709000, -501.76661348861273000, -503.60979022781964000, -506.09378033013263000, -564.59079756940946000, -598.66243588044370000, -689.36702483778026000, -707.57032539778038000, -723.78038930362106000, -724.94076299942208000, -727.08353898607186000, -727.34838590407560000, -730.88805853357724000, -728.11212773558202000, -720.39925704163238000, -715.41762530510562000, -707.14474338176706000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -50.93214401419026400, -163.47117968072723000, -247.29580857366292000, -303.40243586447315000, -496.28704878937276000, -520.72938177445792000, -524.58227471124519000, -529.46689314504545000, -639.47039433115015000, -693.72324774328467000, -891.49963680520887000, -938.93099347558700000, -973.64231354118658000, -976.41709492330676000, -983.21974699913574000, -984.95484257086719000, -1010.99160479595210000, -1034.21153473801090000, -1085.87591370112860000, -1155.82857112725200000, -1174.66078302770420000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -19.69024652111306800, -32.76988245979131200, -34.23963301181465400, -38.67980305321753300, -39.63364037658546800, -53.05728653871259600, -66.94468639932982500, -108.03591709641485000, -159.24404632824030000, -178.65090601389142000,
0.00000000000000000, 0.00000000000000000, 44.22512649424554400, 308.11155237410668000, 770.18525695657661000, 804.34739954643817000, 1082.88468924307540000, 1138.18882511465340000, 1214.30720507874140000, 1247.75439502523300000, 1275.74039247487940000, 1564.49181373203710000, 1625.69798750261270000, 1712.02213605994580000, 1738.60878190836590000, 1742.44912939404050000, 1759.08908080693750000, 1765.32470942191840000, 1773.93895586976920000, 1780.15535872206060000, 1782.14373857221930000, 1809.69919821322420000, 1853.74349378938720000, 1866.50070644339710000, 1905.42288008081070000, 1908.13946582058520000, 1963.16733713257240000, 1994.56615066720840000, 2004.17483345037910000, 2017.15084186237780000, 2039.39622491616820000, 2052.00446653908970000, 2070.25956662546560000, 2074.92053952588000000, 2077.71764821358780000, 2096.54488177423720000, 2099.13415811776390000, 2099.62841058138840000, 2100.37658736655790000, 2124.54573494141500000, 2138.08337842392850000, 2161.65811128209820000, 2169.16035587567830000, 2177.42771461474290000, 2178.24351647866390000, 2180.35376821673440000, 2181.03372476258850000, 2191.63500830214980000, 2201.21220384528490000, 2224.41697595082950000, 2258.65976431186980000, 2264.29421246255740000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -11.68803314312464500, -37.79130287108535700, -88.88218449658280900, -120.57900295477546000, -193.34827408202895000, -239.71790767564121000, -271.09032039780936000, -340.88451676595588000, -349.43033663501438000, -350.86068540453886000, -352.84161211398185000, -390.67959754341376000, -412.80863076165537000, -468.08955445860352000, -482.09973937396313000, -490.86378953775136000, -491.69322468480414000, -493.76900840971444000, -494.23163535019614000, -500.81284411578326000, -511.35279038044780000, -529.08758508654819000, -550.80376878609502000, -559.56470417935361000,
0.00000000000000000, 130.39442125586311000, 164.06444129950825000, 348.96000763867863000, 589.20839852963479000, 609.88084329771095000, 790.29824162037812000, 822.16281836844155000, 868.34700864960882000, 888.77045041465340000, 903.51429179178797000, 998.09335571825034000, 1007.92862327569800000, 1019.03051908521580000, 1024.60139441901970000, 1025.24128823187860000, 1028.39098618229540000, 1030.61685959697820000, 1033.29514721326060000, 1034.96242926379550000, 1035.03753641287900000, 1037.75256221344900000, 1039.08065222798610000, 1039.39545033601730000, 1039.46467760947190000, 1039.85837700626670000, 1048.59333377581580000, 1056.71067480076640000, 1059.32967488111380000, 1066.39950515540070000, 1089.96792286623990000, 1097.29329438121980000, 1113.56129020460460000, 1119.48920427178610000, 1130.65346233142420000, 1160.27460112521570000, 1162.85793373943100000, 1163.37523820924300000, 1164.28389786967640000, 1187.37765808700030000, 1204.05533124410020000, 1276.15050211984180000, 1291.09075890936110000, 1305.18953173847560000, 1306.53498812315980000, 1308.92113302906660000, 1309.47036391550020000, 1317.70813286579510000, 1326.02543446071630000, 1337.09994667460360000, 1357.23194360526800000, 1356.13141747709850000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 50.89065340953038700, 54.16843963972261400, 120.40505960843410000, 154.39218236701359000, 167.01503512764810000, 193.47881280470571000, 259.71946408800511000, 298.48738167113925000, 392.71549444020451000, 444.24919171252969000, 479.51471154903084000, 575.37467889893298000, 587.43021457486918000, 589.09119145934608000, 591.77938924893363000, 647.00360252197902000, 678.52527114522422000, 767.49279083330714000, 785.35326192701609000, 800.98064181860548000, 802.34384495812037000, 804.04180185873065000, 804.59891391725228000, 811.73598861617938000, 811.98473385491548000, 813.41943175307108000, 821.77813750406642000, 815.88494992956510000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 412.61183063150389000, 445.06073587733692000, 692.43177367773535000, 735.48081178477173000, 792.49878184885756000, 821.24871671264225000, 853.56857607113477000, 1119.39365385185900000, 1176.85562652165030000, 1247.47340635847290000, 1274.74145413417090000, 1278.20224250828690000, 1295.15577774923050000, 1300.34523607870280000, 1306.69361842777020000, 1310.46259761712870000, 1311.51597273000580000, 1326.40229231678090000, 1356.33905350974690000, 1364.66770310257830000, 1383.54187127545470000, 1384.58235378845100000, 1409.61956354366200000, 1425.57711517175380000, 1429.44315602648230000, 1437.46964676914220000, 1442.28767526422280000, 1442.49815552267960000, 1452.86471042400350000, 1460.66492632277140000, 1465.53516344912050000, 1472.50883211980200000, 1473.42343313538230000, 1473.43572136818600000, 1473.39553526302010000, 1476.10754882127370000, 1475.54402595544680000, 1525.35511015652900000, 1540.90607255915280000, 1551.54810414854460000, 1552.42981756761560000, 1555.06961112753650000, 1555.75865881199890000, 1566.08409393478020000, 1576.35900174059410000, 1602.07212525523070000, 1634.91666787920870000, 1646.25994589766760000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -28.35381112078047400, -62.60201432322905600, -403.00464369678616000, -458.63399730197563000, -524.36508576059680000, -545.69006923003462000, -548.34148064942974000, -559.18515151539339000, -565.88897760826762000, -572.15171340232098000, -576.11506925839069000, -577.34484140734583000, -595.14774928831264000, -618.78334808855334000, -624.13918459203194000, -639.50703610552171000, -640.78601767493490000, -675.42508227586859000, -691.32075147117996000, -696.38039297876560000, -708.25122323881737000, -745.84814804689063000, -778.54610038974442000, -859.91037977521262000, -894.28625529890689000, -916.35728486627795000, -932.67831699164321000, -934.37944905338816000, -934.90008683899623000, -935.34365064354006000, -948.47770538268639000, -960.88015603751171000, -986.07614991744526000, -993.24679400353966000, -996.71087254720567000, -997.03506320215172000, -996.68384436215399000, -996.48313689988777000, -992.08985431700512000, -991.64974558718814000, -987.91025823974019000, -982.16638069406929000, -981.48397571869054000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 36.73637780013713400, 122.85697980914861000, 189.01815006060036000, 348.88733096603664000, 468.63542755147461000, 547.10118475694571000, 740.96817546307875000, 764.37039420161204000, 767.89067268705696000, 772.15735181993534000, 861.52073565230717000, 905.13791690934784000, 1091.14360335528950000, 1133.21629687528250000, 1164.86751703651540000, 1167.82890976112570000, 1174.14413982437850000, 1175.30076055193740000, 1192.51035991400480000, 1202.85258260949880000, 1229.15787914049540000, 1266.75324750341660000, 1274.36334491738260000};

double lassolsq1[2600] = {
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 900.25399348292717000, 825.36128293231400000, 969.97443921964873000, 894.56280590924018000, 868.29193084863118000, 904.94646637624123000, 781.09493675915394000, 814.45185144284221000, 675.48811446961554000, 723.11707225183272000, 664.52789555753543000, 636.94888281545707000, 427.14740420820613000, 409.92738126737999000, 441.18756109184733000, 550.44879339342492000, 556.81384201318212000, 516.77327053513068000, 517.95566345976806000, 581.34588641085168000, 484.04386708954451000, 463.13555621785491000, 437.24896278520339000, 505.41253625709425000, 447.32443197745476000, 445.92999659959372000, 418.74664805667345000, 507.35678201377237000, 504.58258489466027000, 493.03321847286304000, 497.13440648719154000, 479.59989974437087000, 504.90974472936102000, 509.14177613729743000, 507.60564930058428000, 483.89853529790855000, 483.43860882212914000, 483.89853529790838000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1023.50442838603750000, 955.03074878246616000, 930.73767733668285000, 977.85535983939167000, 951.64815246187720000, 1090.50838412868370000, 1015.82399886921100000, 984.66577148157342000, 1025.05049279181500000, 1179.96506638223540000, 1024.88662113633880000, 941.26208705859869000, 949.91317056732862000, 1250.38308212225370000, 1356.12422020064130000, 1298.94266714560330000, 1502.40900779913930000, 1475.15926597776000000, 1374.22512321923360000, 1365.50664757382810000, 1422.13350319931740000, 1394.41378930077580000, 1401.44932518625640000, 1415.14551994016140000, 1398.71880383597090000, 1403.40331382803900000, 1384.02362689643910000, 1415.33650383842110000, 1409.90038089533640000, 1426.66319519406060000, 1424.90191401278250000, 1470.86989072924670000, 1468.13280918176270000, 1461.75668204613020000, 1468.13280918176270000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -825.12350599270974000, -960.91229511284905000, -830.52047785125148000, -915.07545291619306000, -1052.21297590710580000, -986.73535636620079000, -1007.37814445218120000, -900.49335057614235000, -911.44661961495979000, -959.84955813810939000, -893.03622732343001000, -886.34018328457773000, -872.87087295513754000, -958.40000704428712000, -1103.59478965762060000, -1093.15120321484600000, -1051.03815778831630000, -1260.22963938357220000, -1322.11585990131310000, -1280.26476083392500000, -1413.47277836552120000, -1395.90102052206590000, -1393.23011450182530000, -1390.19900236166040000, -1361.16617808659590000, -1345.78911427019690000, -1347.28350047085970000, -1299.02483664126790000, -1266.86898007796440000, -1275.10575592353280000, -1264.74056487024970000, -1270.88737342138800000, -1292.77611984528130000, -1268.08981359931180000, -1270.50140030230550000, -1274.83446435401150000, -1254.38005058313550000, -1250.25155982490610000, -1254.38005058313550000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -478.28423818557508000, -486.01340403057918000, -495.09345820262951000, -504.33832449758540000, -508.67629713059176000, -528.26850990545745000, -537.05094772216023000, -513.13223434516806000, -529.50400487514025000, -531.10432893661596000, -529.50400487514014000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 131.19675302809580000, 126.15936636257759000, 131.19675302809580000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1004.07802199798080000, -1072.94639967757050000, -899.15073669268270000, -920.38817866495697000, -1009.29778042939570000, -1041.58307254682150000, -1105.11664320622070000, -1124.33890286855440000, -1260.12573789016600000, -1364.72958430324910000, -1372.75428883685890000, -1316.73416287518810000, -1362.41650676492600000, -1360.57815683377930000, -1389.20581186801590000, -1402.90220959970040000, -1410.38267246743040000, -1399.36563575622650000, -1396.15796778986850000, -1419.78326104159120000, -1430.64126718735790000, -1427.62584787271730000, -1424.71256874824010000, -1451.01850759114470000, -1445.72442965845560000, -1451.01850759114470000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -104.29108545400338000, -77.72947294097943400, -94.71625976646635100, -88.12782767314739400, -105.62064934991560000, -95.88239348829209500, -105.62064934991561000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1704.29902929860830000, -1790.22458982157330000, -1857.00891201779400000, -1731.34081680994970000, -1703.39364371819330000, -1419.36927947834400000, -1430.45725504191300000, -1424.59882763021980000, -1387.93680975122110000, -1423.12195580499700000, -1420.85517264370330000, -1406.47287505411400000, -1491.47268161074770000, -1519.45286407010490000, -1558.01400652073740000, -1728.09126166960140000, -1717.44601039570530000, -1676.41978299165340000, -1770.16737082395370000, -1661.84460637527040000, -1644.46658331102190000, -1463.62253062922420000, -1280.09342764099260000, -1264.39530613488910000, -1231.69090306387310000, -1468.25802792410060000, -1413.17564863082680000, -1366.65903843382940000, -1402.95654783184390000, -1404.91374227461850000, -1263.18556061590970000, -1247.80161361772960000, -1181.85651664513600000, -1178.41211134688750000, -1160.08048622044000000, -1187.16767735772530000, -1120.24718186041810000, -1120.74523155868340000, -1134.12498604241250000, -1147.09243278749340000, -1130.45396608341320000, -1109.54925830546020000, -1115.02783833389710000, -1098.42740250077420000, -1095.45145233732320000, -1100.01132773724000000, -1095.45145233732320000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 960.44584101222324000, 1015.77714872243860000, 1021.13109836526640000, 1095.91076781875560000, 1096.63648979368830000, 1063.25143530868190000, 1096.20161901960140000, 1049.22474603628870000, 1105.58030949794100000, 1038.10169348255680000, 1109.18832702289210000, 1131.37715220284350000, 1140.53965557094510000, 1207.31583354600960000, 1283.46919227324020000, 1439.26558545293820000, 1479.47413682104640000, 1340.13413495128540000, 1268.97226838874940000, 1204.01238594841900000, 1219.95304076640950000, 1118.59161786109170000, 1076.15617991093110000, 1180.27841268029280000, 1168.06155113794760000, 1145.63016191030740000, 1136.53004749222460000, 1102.30724517929750000, 1127.21848439133100000, 1076.66378050972340000, 1066.13773272627800000, 1049.46337546308000000, 1042.46087982862170000, 1064.62470817100050000, 1082.07229175205660000, 1077.08751553972210000, 1085.60618143198420000, 1099.97906621115890000, 1093.74945178649250000, 1099.97906621115890000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1802.51878152217610000, -1671.77624091211810000, -1499.75083651628350000, -1389.69651817757450000, -1189.01735115620700000, -1264.04853444862580000, -1129.49668791748080000, -1072.75065586785400000, -1124.59222346701700000, -1120.28423568747760000, -1187.46744490266860000, -1283.23867302068150000, -1327.24435670362800000, -1357.33246896140370000, -1321.52113245684970000, -1367.87952654049790000, -1308.50608521594650000, -1333.60244339363160000, -1289.62366016014470000, -1150.61210382879290000, -1238.68418076332140000, -1305.98784399347730000, -1353.35920233785010000, -1192.55537528621130000, -1038.22857442189430000, -996.34900921312271000, -880.70117164125918000, -815.22097400684618000, -635.44420851604423000, -555.41984865981499000, -660.84348092885807000, -613.78968682421100000, -494.25411878692870000, -495.17464297120591000, -433.81545078758126000, -452.98683048904326000, -472.40255057999809000, -439.03468179868889000, -381.75808261160245000, -378.10231009368556000, -395.08737283614596000, -401.08151892714977000, -404.46375675449923000, -394.43746170416944000, -408.15899553724728000, -364.39684343369015000, -354.83924095078743000, -359.79280812011217000, -354.83924095078743000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -631.29219662377136000, -456.68791742959593000, -357.93234601147708000, -333.46834593529883000, -397.96544082695777000, -401.50239110863112000, -508.06340729439677000, -518.29431527941654000, -549.69692480463561000, -685.10651461819361000, -680.16957151795066000, -769.60141677629338000, -690.28914700260304000, -651.22171288108495000, -657.12840772354753000, -700.55702488742998000, -800.92139791103466000, -1000.44813944321700000, -969.11640688793318000, -1062.77476834957930000, -1039.00875584632330000, -1041.27139943574050000, -1072.62916849323850000, -1118.24360973631790000, -1113.11355649484040000, -1116.31463498748580000, -1114.01378350516800000, -1104.42958123907650000, -1103.38796601881200000, -1096.65352948624880000, -1100.22451853661690000, -1103.12685175751810000, -1104.72251411263890000, -1103.12685175751810000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 791.93900941644438000, 937.73602871529465000, 907.42138881199821000, 921.38705588210712000, 955.37195016520320000, 948.26891252484631000, 820.57867253259883000, 847.62570306514078000, 928.60381741721631000, 888.90117093992308000, 656.77958609740006000, 731.39325209669141000, 822.16059397251172000, 881.31720623413787000, 970.35442741064105000, 940.30688872460894000, 920.00430899977619000, 957.25196807472355000, 891.61946861542265000, 736.28946002946770000, 747.43071536223067000, 771.23024455566292000, 736.02924076357147000, 722.97094410641978000, 697.51081746516365000, 646.32497056329930000, 644.94895432344958000, 628.41423193105175000, 639.33950304349605000, 643.79928768780724000, 649.62095922465164000, 666.99061665919214000, 694.31909198772269000, 681.57533324836504000, 676.05388734027429000, 681.57533324836504000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -956.73648158343781000, -962.22142630880569000, -991.05475104663583000, -962.57066525108792000, -972.98497945520842000, -987.29514688903771000, -1001.48543284862300000, -996.12497175813587000, -1002.94074626274450000, -959.67417770100678000, -954.74714042772871000, -1047.05276282846760000, -1048.86818313150820000, -1096.29779004322450000, -1101.77659892993760000, -1104.15353165275660000, -1101.77659892993730000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 484.20074732142365000, 665.54547050693202000, 636.03748199422887000, 578.53189493667026000, 491.03511115351102000, 415.27155676472410000, 342.35642955240201000, 165.80069752574803000, 82.08253252189602700, 137.00646062959268000, 205.98653204132466000, 380.68338056081166000, 317.76306180719092000, 259.07258794563518000, 172.04589452681151000, 143.50870604314184000, 144.78078181994272000, 128.68600697295355000, 91.52620870735475500, 95.30458260992767800, 97.57708973407675000, 101.23892642944527000, 20.00411386944880800, 20.19657191002558200, 24.60971238878280300, 55.08806372249787100, 61.18028611274745300, 65.36697412102054700, 74.16607526439888400, 63.51347650098367800, 52.87696143938891400, 53.05299917457848800, 52.87696143938891400,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1199.33705348795870000, -1218.51820344774980000, -1166.91316667323100000, -936.01764271575166000, -997.55703779590692000, -927.42619434251912000, -1008.59802294936330000, -1040.48182095448190000, -1024.53616625788300000, -1097.09776717123670000, -1154.81167668520150000, -1215.63268443818720000, -1250.18392913676170000, -1389.68895491755730000, -1425.46390408309910000, -1441.56740720338440000, -1415.61729187808190000, -1572.44449372798750000, -1580.44648791551640000, -1686.02047389373730000, -1606.04136428119980000, -1607.50512062604160000, -1625.79540790891560000, -1661.91391396089260000, -1523.78378334914510000, -1498.85794089641850000, -1335.07329517801780000, -1447.74046829710260000, -1449.78702930879600000, -1461.15483388777060000, -1480.83172916427070000, -1428.32652344649250000, -1393.61403953018230000, -1458.32366249736170000, -1405.40856846430920000, -1415.68068224042260000, -1397.63181522206990000, -1396.95355727739750000, -1422.00959985530950000, -1434.65507960422200000, -1439.11650516948270000, -1423.52945386819190000, -1461.67802090289770000, -1454.21957521990430000, -1461.67802090289750000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1000.43704293398460000, -999.88671413470149000, -903.47971573160248000, -763.36039071159769000, -723.57297996965519000, -691.22254846707835000, -725.56787064679486000, -788.26487748203772000, -739.69288302773509000, -673.16667903524024000, -641.39645694982232000, -640.15872701141666000, -651.00874890879663000, -719.85679361627638000, -870.95005026648619000, -899.88594174870570000, -1117.46046716229010000, -1142.76746143675970000, -1158.48260894590000000, -1289.44470345113220000, -1271.96913855810230000, -1565.64274435985680000, -1567.99153660318070000, -1638.18793795371700000, -1692.86178565314960000, -1713.30657287762390000, -1713.17647401324280000, -1727.75736643889970000, -1755.38634770943420000, -1769.55572314639330000, -1763.25607246919050000, -1787.26704620411010000, -1801.80436241789810000, -1801.19055546907480000, -1799.71517940415860000, -1806.44205840601310000, -1783.62382046859760000, -1777.71165359683890000, -1788.93269854115370000, -1787.50589201825460000, -1786.53850306342540000, -1787.50589201825460000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -209.94364013291244000, -171.00765788195173000, -291.69330026599403000, -297.49361704238089000, -312.41349044617971000, -318.90075829219103000, -312.06164590999651000, -304.16528308221359000, -314.83433275165254000, -295.68994246278402000, -246.36702282311751000, -252.50960653102084000, -246.36702282311740000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1327.18984465525180000, 1345.43444542693780000, 1205.71045392255060000, 1278.52029241134050000, 1334.25650751666900000, 1249.98702933119850000, 1367.76420063766590000, 1413.88793950241440000, 1364.53946957248060000, 1335.88419919176680000, 1365.77744877908140000, 1440.92632218915110000, 1354.19933002110340000, 1374.02940286779150000, 1447.74659853660930000, 1450.28395540329350000, 1654.74294899630970000, 1589.04114565317740000, 1483.14836795170620000, 1502.97572958930960000, 1563.27091743187040000, 1723.45916285049200000, 1724.08711935445760000, 1788.21289539342000000, 1632.57809131702170000, 1581.77582346319630000, 1607.68135725479600000, 1606.68186299425970000, 1650.04094842295580000, 1732.23923989984110000, 1718.41936120053790000, 1712.94290190876110000, 1713.79557710128030000, 1696.72463079264210000, 1686.33171250522420000, 1699.97550191216460000, 1696.39191764662700000, 1682.44424628521010000, 1664.76739766942160000, 1679.57028780324780000, 1675.36561361138390000, 1674.21711088121170000, 1676.63370149701630000, 1683.36280524305290000, 1678.94159311321780000, 1683.36280524305290000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 146.66424034206889000, 153.82492792134107000, 149.01425756967677000, 153.82492792134107000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 378.30423830902049000, 402.02286726204676000, 455.04638941427078000, 622.54907546101742000, 606.98941865423421000, 612.59953913108870000, 602.79836796680377000, 624.97307573290095000, 655.20394962561136000, 633.89690498756386000, 629.93716341158370000, 621.43622111792183000, 600.07610087336332000, 589.47958209446972000, 606.38596670105449000, 599.54569443261107000, 614.33268356537747000, 624.35196093369188000, 623.27717644928873000, 624.35196093369188000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1095.48182710796730000, 1045.81349754300410000, 801.05733650421951000, 797.79188990726459000, 736.73699541657777000, 765.06237636213029000, 752.40710975859599000, 814.09911355779775000, 878.45423517722884000, 808.29271552110777000, 1101.91340579691250000, 1106.42409784379220000, 1041.22280013391110000, 1068.80772353536550000, 1062.55100601168350000, 797.66758654006958000, 792.63149168793586000, 726.13625022904000000, 711.93458116751367000, 684.44169451049549000, 717.16484334664767000, 655.05596508367546000, 660.98155504447948000, 652.79635595238221000, 691.56226796830083000, 702.02679485097553000, 683.76365920333046000, 692.80069767227883000, 657.59557869909202000, 645.11712034142124000, 642.25422138698480000, 645.11712034142147000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -117.50563592051499000, -103.89929234255436000, -82.10967399506425600, -83.21600733693506400, -81.78862635114953200, -86.22110716923883400, -83.43585359161645000, -86.22110716923883400,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 233.96579902690939000, 224.92215839591671000, 206.80511804363931000, 332.89413455143153000, 265.37494322745732000, 304.63467289620797000, 541.55951886297328000, 515.03703680426020000, 628.34829722065899000, 543.26442487862403000, 453.80417770154230000, 477.40182386070467000, 567.74314047832900000, 561.77329666941409000, 644.32981409292370000, 660.32551592362256000, 702.05494405153343000, 705.06776113861417000, 652.89191623599913000, 621.98243658847275000, 693.59036683626823000, 709.81469964868404000, 727.26040883583619000, 718.01075150269435000, 709.94792889376515000, 719.57411819801109000, 708.88643937892107000, 719.32577588631545000, 735.48337561200935000, 740.11167904247225000, 735.48337561200947000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 921.69481948103157000, 853.74582077127968000, 969.06343173225400000, 974.19481457595691000, 972.18175459473491000, 917.32098001502322000, 914.69520575522245000, 836.36575011673688000, 910.32811128370804000, 923.41442920782856000, 919.85439874303563000, 920.91247021465358000, 937.16626285639575000, 952.68706766154298000, 957.91334149191664000, 956.65024991595180000, 959.00053383080046000, 956.68507802141164000, 959.00053383080046000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -401.58640991031416000, -344.24557111460348000, -371.14293331835842000, -400.42778618427968000, -480.59484518779470000, -480.68942594853826000, -470.87460255479465000, -494.13183663628854000, -482.81988544408802000, -477.86208918097782000, -471.26346240150042000, -483.63794326213042000, -482.32178983186839000, -479.95899049741240000, -482.32178983186839000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -654.05963126143740000, -491.40246044381871000, -464.88547790168440000, -445.71504933794887000, -497.83933152165628000, -665.94924686776710000, -638.06797372247092000, -665.02611806204163000, -760.70623835174547000, -778.09787860376616000, -798.22583902777978000, -913.25042487748487000, -909.37009858999602000, -892.82665840691698000, -697.82974026076135000, -798.78016297570798000, -721.72794836116077000, -695.14833377081402000, -713.44814408442460000, -749.86959458701062000, -747.49224009333398000, -791.25756526742828000, -800.55951861430071000, -832.81753763249696000, -836.06549765924797000, -857.81623228677347000, -883.24908976461415000, -871.49179392837107000, -873.12320243116881000, -887.71630858352682000, -898.23638658402740000, -928.45276359234674000, -936.38700369136200000, -937.99758780347076000, -936.48727404828730000, -935.59865253488761000, -936.48727404828708000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -218.17057935969953000, -247.55053800759671000, -215.88073903541505000, -209.61667905641792000, -216.41672187691938000, -232.55868096132264000, -212.76557054678452000, -230.29509982085432000, -248.55231724732766000, -239.71615378382529000, -252.60420879850057000, -262.40493246415906000, -265.11022544136870000, -262.40493246415906000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -434.67250603295344000, -586.75893916210146000, -564.49101793715852000, -657.42515401705271000, -649.82652598050367000, -670.61429612488837000, -693.17621130246232000, -758.54351786610596000, -753.63735228571818000, -741.79751632005969000, -725.31771612787486000, -728.99131513191139000, -722.91869198847019000, -724.70784440989439000, -736.74302357959095000, -745.53379977627094000, -742.03749530354048000, -745.53379977627094000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1117.32930197821610000, -1073.01037314381140000, -943.72955531860896000, -883.79520752472706000, -959.65724581069219000, -895.65937472175733000, -877.33855283139087000, -808.36686794433376000, -821.84090944833417000, -787.89814296150394000, -829.32281259166916000, -729.78711745628141000, -726.85962127515506000, -723.83345653415029000, -754.08714065977006000, -732.20480479753121000, -733.52324315276746000, -739.98463935476855000, -756.61622232918000000, -762.98659706035903000, -762.20551284089163000, -762.98659706035914000,
2677.88291006687950000, 2263.85679908056320000, 2424.07454608089940000, 2275.52320244851760000, 2370.18343358526770000, 2279.19707878907500000, 2172.09010714461100000, 2041.20071402222420000, 2066.78965657289560000, 2036.35143210368640000, 2001.29304828602490000, 2053.76350558833250000, 2052.40415080115830000, 1908.38410914625770000, 1790.52468891005330000, 1902.90317513471700000, 1843.39478202350030000, 1686.39266738357670000, 1810.00650242326360000, 1759.43911364382320000, 1589.04929070148500000, 1631.82744200521940000, 1680.29364411257440000, 1700.16589266779100000, 1715.48517534379880000, 1649.73136321222520000, 1565.41210589482560000, 1719.16352219254100000, 1720.66112128492300000, 1788.16032383510610000, 1597.46763185742410000, 1603.31984475175500000, 1685.17868278866060000, 1651.59656277636510000, 1679.03894991249130000, 1713.92045537079070000, 1720.47705101735100000, 1790.34280971274170000, 1798.10243392280970000, 1784.87936863674460000, 1801.27008469287740000, 1825.28836740383460000, 1825.97938650861760000, 1829.23148416231130000, 1817.40241592983220000, 1794.23552919916320000, 1788.44009569756280000, 1762.11073293705160000, 1773.39519828011660000, 1778.34540562128110000, 1781.54427464458720000, 1778.34540562128220000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 56.66488284666346000, 73.98885280856542600, 49.56173034197129800, 48.42000378120486200, 49.56173034197130500,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 88.70622290032810000, 65.40477851133492500, 28.87409182393774600, 38.79358227810560300, 35.30668382453364300, -1.84915353238552790, -27.69140896351865400, 0.00000000000000000, -27.69140896351865400,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 887.69751211086316000, 878.12226592157731000, 988.71982194319162000, 986.25635106763389000, 987.38371088887527000, 1163.56807462237340000, 1256.62725187614410000, 1222.84632055853810000, 1244.90522123832350000, 1297.40869315644180000, 1376.96135949813420000, 1356.96378072482280000, 1405.67685422941960000, 1388.64541481777910000, 1305.21686869736870000, 1229.85819959596690000, 1364.46167381282020000, 1438.78858790586380000, 1531.61510069554920000, 1680.14239304051330000, 1685.86558488042620000, 1784.22985555889590000, 1998.77807215635900000, 2064.99436341398090000, 2036.63553059135670000, 2123.15960221340950000, 2131.95998717580820000, 2044.95008794413250000, 2012.71871215650960000, 2002.81074093394140000, 2015.18024073697300000, 2036.16633959269100000, 2057.67414081304880000, 2131.22855774939810000, 2129.71442690072170000, 2133.74722805041120000, 2148.59823218127080000, 2124.28317331419790000, 2106.65619493988020000, 2101.55599357101120000, 2092.88395557771810000, 2057.15676910570850000, 2061.33652288133540000, 2057.15676910570850000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -227.31236933291305000, -202.34175965456922000, -200.84209986834350000, -199.15904860844853000, -200.44297317295738000, -194.08939376995133000, -200.47935164128364000, -196.47546279386214000, -200.89654806587063000, -220.44836737880578000, -219.79350013127507000, -220.44836737880584000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1155.77244513603730000, 1270.06155597972630000, 1304.67016683537510000, 1058.83925818521520000, 1017.69585881082990000, 1042.09941157381240000, 1254.35897933265730000, 1286.33669679372020000, 1577.09080848540180000, 1565.94738887815330000, 1583.94914134361600000, 1580.30908123589230000, 1566.37473766037420000, 1509.30772016091740000, 1635.93328519553320000, 1650.46018381293920000, 1642.08208370519670000, 1638.51686664654930000, 1644.80654492769350000, 1667.51206842672240000, 1659.75093243826340000, 1696.98117095449810000, 1720.69212291213080000, 1716.56213839501770000, 1720.69212291213080000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 153.29060339469723000, 155.28824265402741000, 183.60696273732543000, 151.36868652575615000, 110.57527539483570000, 73.24870577577992500, 80.31426507535923100, 75.72606668552639100, 75.02798388268709600, 107.70328800761395000, 82.08866316442377800, 90.72947615391386500, 106.88351882056121000, 115.06828427583227000, 110.02697971730234000, 115.06828427583230000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 175.68569709373000000, 176.52720477243068000, 199.25516615499794000, 209.17638837438366000, 209.42883046187208000, 209.17638837438361000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -712.97434248724790000, -766.30453448228116000, -773.76058318958133000, -543.61515577110822000, -523.70126829807714000, -637.03196379605515000, -584.99586349166384000, -462.09303315244824000, -494.87207819166213000, -470.56094729258700000, -505.66292300163974000, -440.44606912932989000, -445.23995163650227000, -492.67766239531221000, -435.98658031625888000, -440.84107278887780000, -416.82475784463048000, -374.47229924299410000, -383.18518456255123000, -398.08173018151695000, -413.46754386816770000, -428.72081628210515000, -424.50088275797697000, -412.60001283172488000, -431.80915001238560000, -434.10553328408105000, -439.06995221028586000, -441.83183665143576000, -439.06995221028586000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1226.68679668015220000, 1278.04505688204130000, 1301.34726808175970000, 1334.94923764520670000, 1421.85181052725030000, 1308.97711551219340000, 1210.70667774333810000, 1235.06237456598230000, 1227.83141601452230000, 1254.11134723885360000, 1240.53364317898420000, 1247.76674705602250000, 1260.50670900328150000, 1264.04291164003780000, 1186.38873836478980000, 1329.82753785726690000, 1534.92298089261730000, 1535.78478933781750000, 1470.18079019539100000, 1369.58856162791470000, 1530.42519821225370000, 1499.79755600150610000, 1530.44077327802510000, 1560.63323584791280000, 1793.75787225767340000, 1830.64831492001670000, 1817.69199759564090000, 1806.26948809211650000, 1761.55917293167430000, 1778.14189298231740000, 1831.93340330446610000, 1814.57213989277530000, 1824.17662834374730000, 1815.32846293571610000, 1815.59924080218180000, 1835.34522701250420000, 1834.63478324817040000, 1833.99581934315640000, 1836.04132905010990000, 1838.74674834252370000, 1836.04132905010990000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -943.26939707998258000, -787.56577295983584000, -819.75074574565576000, -816.23917751852184000, -995.71620080856030000, -1096.10957287215570000, -983.38884612318691000, -1140.78216696444160000, -1059.41766200962120000, -1187.21987061126470000, -1271.51685620033050000, -1265.11136544822100000, -1303.22679264603310000, -1308.87093090855570000, -1326.78069750511800000, -1375.94960444382150000, -1395.59545179908200000, -1413.50419165355240000, -1412.60745392481040000, -1428.41422065998290000, -1416.76012805828900000, -1398.07885866323700000, -1397.40939807165430000, -1419.30740169702560000, -1410.61878062177830000, -1400.48860762130380000, -1425.30717904571410000, -1435.14106948796580000, -1427.85853687749230000, -1435.14106948796600000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -677.84142541475535000, -712.68260597907010000, -668.62233451859709000, -638.84504881307782000, -589.71056847341742000, -649.92000853742695000, -681.30343943963044000, -685.93954546402324000, -688.17488542368346000, -748.59847578706899000, -815.54933799889420000, -805.16244855031312000, -778.08710643958420000, -801.68456577446386000, -826.56637099606485000, -853.14714162285713000, -809.27701441044553000, -788.89182313702020000, -805.71414753913734000, -788.92039144294529000, -775.86669227735013000, -753.97005253343048000, -750.01204381448429000, -712.47004484178524000, -707.14474338176706000, -714.14403172309994000, -707.14474338176706000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -751.35555249800632000, -743.83721770531156000, -891.52459921637478000, -860.78943048714041000, -1071.30965646630580000, -1083.76653334313100000, -1098.33718949800320000, -1110.72854877662210000, -1132.11483437654870000, -1098.94360463472530000, -1152.95680256436710000, -1150.82602600144830000, -1149.09065987779420000, -1129.41046463038330000, -1138.09119463061050000, -1159.36176498802680000, -1151.66186153241100000, -1165.05343800309290000, -1174.66078302770420000, -1173.71252165874580000, -1174.66078302770420000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -107.65453259516394000, -98.88089442329771800, -115.27740089934152000, -139.76619618000086000, -135.51068298192084000, -125.58196282686170000, -145.19874804811710000, -178.65090601389139000, -172.33580986788110000, -178.65090601389142000,
0.00000000000000000, 0.00000000000000000, 2537.10646404782980000, 2410.47853593795390000, 2538.88226158635920000, 2498.59560620283810000, 2452.09030016303630000, 2543.70869118935020000, 2457.34566941063350000, 2351.88357399057120000, 2210.25404452370460000, 2322.22921927049130000, 2409.71643594809670000, 2416.69662304044410000, 2337.97296079235280000, 2359.57140412432450000, 2318.51501919910470000, 2258.71648418716310000, 2284.59101811011620000, 2359.65245447885900000, 2453.65833339339360000, 2428.75978899784200000, 2561.94354140015050000, 2613.49025420676250000, 2531.21399175794980000, 2608.45559547794440000, 2600.29180096725620000, 2467.45500303183140000, 2429.03460006353040000, 2286.04558955318770000, 2221.25568306536020000, 2225.39413515491830000, 2164.40147967921620000, 2110.74214678509910000, 2105.50531039105950000, 2152.67214238471620000, 2158.77898735616330000, 2173.23019106233140000, 2189.40840894004580000, 2232.78589134558430000, 2239.19748355274940000, 2192.82352423084150000, 2202.67591338378770000, 2219.21507437516270000, 2223.22445695162010000, 2228.39646360947340000, 2249.38104261177930000, 2248.91114979601480000, 2255.17871002909030000, 2264.29421246255650000, 2267.41420418080540000, 2264.29421246255740000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -528.48884189207081000, -578.71512971715629000, -506.55806925480562000, -556.47649072584841000, -568.62084793987174000, -596.08874244203287000, -582.75715345543267000, -548.95316562159860000, -546.28609831004462000, -563.86157845767525000, -588.56867133483070000, -560.13486890602280000, -578.09274347438395000, -541.17003539420671000, -544.68889550888491000, -535.16167580487638000, -537.42586471142602000, -541.02699351069896000, -540.73359307012504000, -536.36950506648463000, -570.74429728945256000, -559.56470417935361000, -556.35568302789045000, -559.56470417935361000,
0.00000000000000000, 2126.49558766746850000, 2061.97567989776370000, 1822.01165393965830000, 1508.81625572186200000, 1635.11666928219960000, 1677.17595325469120000, 1631.98101618756600000, 1622.55019834701350000, 1562.97112388709160000, 1395.84339585053000000, 1246.28640081522490000, 1133.91315613246750000, 1109.65664010495680000, 1150.19012566203330000, 1128.06863051025450000, 1134.28208452998430000, 1206.73825846198700000, 1192.06389185122880000, 1190.38754070687950000, 1060.40268320861540000, 1098.74829583551420000, 1060.43536795729510000, 1057.82823049988020000, 1040.57771443051300000, 1141.35123025026180000, 1149.72853155341590000, 1178.96370443536670000, 1175.13199534538830000, 1212.90374339736260000, 1282.64339462426440000, 1198.03245987762970000, 1197.45566717966610000, 1165.04780633147560000, 1241.56392955305250000, 1248.58037219363220000, 1222.36584722501360000, 1240.40981634714420000, 1272.41292079893130000, 1290.80175321246970000, 1328.62265339949450000, 1371.45914402346030000, 1357.83492185540990000, 1376.45177050003510000, 1380.71953736841620000, 1363.24490436367820000, 1364.67750648445800000, 1362.21478323790390000, 1372.89256857458800000, 1356.13141747709800000, 1362.37884796109480000, 1356.13141747709850000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 869.11110707179569000, 899.15799140064928000, 887.30681280407543000, 666.26284457375596000, 725.15004685561871000, 741.87324932788795000, 801.24706649887071000, 831.62725824560732000, 878.65174006752568000, 840.30810553726508000, 829.85731926968765000, 861.14992847173460000, 865.13343021126036000, 836.43615184397618000, 911.67055762113728000, 894.32210903769464000, 913.96398092685922000, 885.10640311836687000, 865.14320193714821000, 879.96922405551550000, 877.50689861472711000, 842.69805537311004000, 860.59824971826572000, 850.29585721912281000, 813.38638754403348000, 815.88494992956510000, 823.91510678669852000, 815.88494992956510000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1991.98174862367020000, 2054.34210270330910000, 1908.43345626856170000, 1829.54506794362620000, 1723.62119907872510000, 1770.31624756473090000, 1932.79935414693640000, 1816.96807231761930000, 1912.91285542238390000, 1823.93490189427140000, 1889.46702568729390000, 1834.33149949903550000, 1865.12423053441260000, 1710.95917949046860000, 1683.02537977994190000, 1661.80927608990190000, 1667.26126056417680000, 1660.83815069324990000, 1837.70027009473480000, 1852.34587870099650000, 1687.00094303531500000, 1652.81121025669400000, 1699.50573324055520000, 1665.90938975382690000, 1600.38492320957470000, 1603.79823831771300000, 1481.67580579647760000, 1445.39269889799430000, 1506.32523956762380000, 1520.61298361311310000, 1513.91816143054070000, 1493.29855237421910000, 1494.49156730032810000, 1475.26562790357680000, 1468.61345405469480000, 1488.25314770126850000, 1471.33501348061440000, 1591.20455234918680000, 1610.37850420415090000, 1605.33824639874340000, 1601.04492936302790000, 1615.16803237795490000, 1625.01979232167970000, 1621.86989391562110000, 1634.25704435056880000, 1646.25994589766720000, 1643.31363515864470000, 1646.25994589766760000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -964.34485381850811000, -1206.22441007367500000, -1296.28442080400740000, -1171.21635321021450000, -1060.93592731932110000, -1026.43635365213530000, -974.40840623010752000, -923.74335239485663000, -1096.32670216009000000, -943.40635161826401000, -945.58166635907401000, -992.66284327813298000, -995.10764159492055000, -998.82648367904426000, -937.74639614623709000, -886.59151222716321000, -970.49820362964670000, -1076.48358109512720000, -930.72103183676268000, -920.09868596103024000, -954.24396663943628000, -1053.20884204523780000, -1228.21127105372060000, -1279.50758161715590000, -1158.47983430299310000, -1135.62023886672160000, -981.33415485446210000, -973.56558366138370000, -1012.43104687791080000, -988.12702254897613000, -1007.29782449458310000, -1053.51538468619810000, -1019.38484353642850000, -1025.28095807802560000, -1014.22005545692300000, -1014.90999239380610000, -988.68787902693111000, -976.30858780282767000, -968.35402328289558000, -989.16977842120002000, -981.48397571869077000, -980.69791293794117000, -981.48397571869054000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 798.00430596423359000, 826.90626405702869000, 1098.87249202368030000, 1173.33586631022310000, 1388.95171721302900000, 1326.61324423005040000, 1318.91942231408940000, 1303.44817319149300000, 1292.11418877735720000, 1279.88523485461520000, 1261.72958095242260000, 1230.91930247649750000, 1337.04009192964490000, 1321.17201620719650000, 1324.84859025209790000, 1331.11148578084180000, 1317.91877523414470000, 1291.56102009264400000, 1285.48961515570410000, 1261.12993765951210000, 1274.36334491738260000, 1276.36480098479570000, 1274.36334491738260000};

double nnlasso1[1250] = {
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 180.90306477422399000, 252.94887147070628000, 484.01065923904144000, 525.57591645497632000, 532.27363706604694000, 617.41844165786722000, 688.86224989427706000, 753.48114601068676000, 788.46160978909813000, 814.81081203574024000, 988.31894035143546000, 1033.68918527131450000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 25.96501018837485100,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 7.12502752196399760, 82.21257129925322700, 161.82161090790876000, 238.08542891115513000, 299.12458144263923000, 343.66745967951954000, 609.02171951748039000, 680.76293379639606000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 369.71359349861126000, 382.50221096175642000, 410.10556512526773000, 511.05732707556109000, 513.64658051104800000, 556.18028618000665000, 734.92140911190188000, 783.37158835758953000, 986.11646813263360000, 1020.52872222098090000, 1023.97629473951840000, 1047.75638787276310000, 1065.65853156775550000, 1079.25779661505070000, 1076.95478997634020000, 1076.55381171089150000, 1078.36342297214400000, 1079.32827674483110000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 2.32297934719664400, 40.79266392344968000, 235.40579870179340000, 304.37247795002258000, 567.83923521037332000, 614.32218068521433000, 620.43192010067685000, 692.97173060130274000, 756.23781734274655000, 813.57717388082540000, 843.91532948481370000, 865.75429548389968000, 1011.34512563036970000, 1054.48281459408010000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 18.75125367466831200, 69.38309015301307200, 70.69304321219853200, 88.92533270364016600, 174.88382950659928000, 213.36706897925120000, 382.48677191559682000, 412.19705702744778000, 415.11240914256251000, 445.28970794283663000, 466.67601765963502000, 481.39792924975518000, 492.04682354856760000, 499.53827825531027000, 533.21986277450742000, 540.80255913489793000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 295.29146243916642000, 440.66240555664785000, 514.40946152516096000, 723.43656045692092000, 732.14360882403321000, 751.69606191720516000, 830.58584576439921000, 832.65486084921793000, 864.92067292268064000, 994.56948077127231000, 1038.86230930009310000, 1215.63593410416770000, 1247.80653030128220000, 1252.20105391129780000, 1303.51198170819450000, 1340.23559941063080000, 1371.24308361682480000, 1387.15388429005860000, 1395.22014749806680000, 1425.53436405980850000, 1434.35091645769900000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 26.04624395906332900, 148.72064740736232000, 201.38138934879893000, 388.56742208606408000, 418.29909279590544000, 422.56886411190987000, 477.43961191469896000, 533.52786870068780000, 580.76931352982672000, 609.92773556592601000, 627.94403729833653000, 730.09099592189477000, 755.23544804519747000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 229.67924044633557000, 267.75202882094720000, 272.05968197881731000, 323.42851632722784000, 360.38585988484732000, 386.72528082381638000, 398.15459846792220000, 406.71225181780443000, 452.68668407977430000, 466.03172158683134000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 9.46365370589991710, 27.74222650359413600, 122.96849658713963000, 125.26332673457753000, 160.79723404526294000, 330.26200427504847000, 392.70987948148689000, 584.79564482486035000, 620.36337482006923000, 626.19628291728964000, 711.64949867010739000, 789.14529680871783000, 851.15027683591165000, 905.89100029219560000, 947.28462522156906000, 1175.33443300290920000, 1233.17871305601600000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 98.46754826192292900, 179.04830044964422000, 239.44140966421941000, 276.28788690813991000, 303.61146189495577000, 462.04340437851283000, 510.38277478678941000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 20.58821430147270300, 153.76175327513522000, 191.25261949140173000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
197.39805776885407000, 324.11108420782347000, 579.85133441223877000, 980.46977776585038000, 1295.09690440060060000, 1478.98071173773290000, 1588.08524859266590000, 1814.34848457791260000, 1825.46766638359550000, 1848.97273366032870000, 1939.40324761197850000, 1941.62329173029890000, 1980.27642262188940000, 2133.44508068367300000, 2189.80613867846390000, 2354.39004400550860000, 2380.85005843363430000, 2385.93416881422400000, 2441.38809840612380000, 2492.50495654498130000, 2534.07335891593310000, 2565.84326620539880000, 2587.81667365174600000, 2696.33168646097560000, 2720.98168139471910000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 48.71516278570112500, 89.65096766656525100, 324.27794298289183000, 383.49229418707677000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 158.46650791720094000, 246.60147987716311000, 440.98352388015172000, 448.58516662353605000, 466.45983096381889000, 540.13155692286739000, 541.93609676848394000, 570.37049704995263000, 704.24866985273945000, 757.59155952184551000, 975.44085790565725000, 1010.17255214241520000, 1016.18550139374460000, 1086.26994047343310000, 1152.24674215497980000, 1211.14298479966060000, 1254.07332733744310000, 1286.68975380709250000, 1455.13760571077840000, 1500.35254828027090000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 25.73607029905888800, 29.77641089658154500, 94.03818415748627000, 146.63063929364171000, 192.64482639338055000, 222.87378998969646000, 242.85957458694074000, 353.39568399434830000, 383.24852912165210000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 160.00882677232335000, 164.28977411977320000, 232.63958460546758000, 525.79863454085637000, 621.88112702137971000, 1002.63031861209610000, 1071.14464809401760000, 1081.97098053184910000, 1226.79595096680800000, 1339.50945132712970000, 1427.75122341759400000, 1482.59836174796210000, 1519.19321289108730000, 1719.83288036636080000, 1771.49572167531940000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 177.71406214641522000, 230.25783918148900000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 108.64999255679551000, 367.54978348878183000, 377.74883335222609000, 400.52970669442544000, 500.76622591393794000, 503.00622646659417000, 535.94001722111102000, 676.79519644699178000, 717.06702033518570000, 868.91031559523594000, 892.92607821333718000, 896.68423145771760000, 936.91442722866759000, 968.68061478488278000, 1003.64254997473680000, 1035.69870635445090000, 1058.61958531776850000, 1178.09731499875580000, 1206.07074340578580000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 51.65330895205340800, 91.05388355139814400, 118.61790697795125000, 269.09516463061652000, 307.97418950616657000,
0.00000000000000000, 0.00000000000000000, 308.97691968987618000, 796.88866141144229000, 1198.62431169338790000, 1412.17285008652240000, 1542.66951131884890000, 1849.92287174236300000, 1861.73699245006170000, 1891.11078881338880000, 1959.33443528407160000, 1960.88845539421660000, 1981.95551224120000000, 2054.11251914842250000, 2064.70270922061760000, 2118.73000459177590000, 2126.84302282135880000, 2127.62416303191000000, 2129.44809024873620000, 2126.32297277051610000, 2115.18030695785000000, 2112.95294628416290000, 2112.62940384685540000, 2127.45697919709890000, 2131.72026505924620000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 130.39442125586311000, 365.62854953666084000, 645.19166119414911000, 887.17383384186030000, 1026.69031991483390000, 1093.06209142080660000, 1181.10315355587390000, 1185.86822771783590000, 1195.43210347996890000, 1234.56334893295320000, 1235.53735782853050000, 1250.52854714543400000, 1326.59086899142950000, 1355.47117222648350000, 1427.50750217727680000, 1436.93562375442000000, 1438.15834938863370000, 1447.82087299280870000, 1457.24107714472780000, 1470.42261843331270000, 1487.04382296142170000, 1496.77031318215950000, 1547.26532962416920000, 1561.35437962513310000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 47.65689200527660300, 102.33547210021209000, 148.13169672320919000, 183.83695456626546000, 387.59037329511682000, 441.01840414976220000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 434.45099813846497000, 767.90244221479327000, 940.58864239595641000, 1027.45046119030990000, 1256.01785840864250000, 1264.88730460713400000, 1284.15202757714450000, 1327.68749431769720000, 1328.76504506861490000, 1348.24454546549190000, 1450.12027106617010000, 1479.47992544914470000, 1588.96556034040850000, 1607.98930726570730000, 1610.54031338532560000, 1645.12692054496120000, 1666.63518691582520000, 1675.38795210067700000, 1675.24254249188360000, 1674.64036353241140000, 1690.25218865406940000, 1692.22342887858260000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 74.75922991619353300, 341.13812584743448000, 388.58282640738116000, 395.58165962971356000, 497.24314961080898000, 584.64603974713214000, 668.04172420824398000, 727.79221914063385000, 773.53415957029495000, 1000.66259671258710000, 1060.85529297588500000};

double nnlassolsq1[1250] = {
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 812.17355542147766000, 945.61645067717427000, 873.58881519744318000, 891.85014686975842000, 956.34985626516936000, 1008.60491464232930000, 1005.72832164382440000, 1031.66950999226360000, 982.11317915397979000, 994.69796754889353000, 1034.45267036862900000, 1033.68918527131450000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 25.96501018837485100,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 458.25682424245889000, 427.19229796746208000, 514.90194465883565000, 566.40590537197397000, 637.03684456475855000, 647.76363645930326000, 679.57623417400998000, 680.76293379639606000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1410.35308183763480000, 1240.42485576040510000, 1204.00525397016510000, 1320.83786795586460000, 1357.93910844223610000, 1378.26418234735300000, 1358.64769320156640000, 1249.18451917273480000, 1327.95133903721060000, 1323.77048534942450000, 1242.26451605762050000, 1157.01086093934080000, 1145.05774178003030000, 1137.80347786660920000, 1064.20536353450850000, 1073.81631556512710000, 1078.84457689947360000, 1079.32827674483110000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 759.79000767912578000, 784.32788342479989000, 914.51827936237521000, 967.43650556278249000, 1012.05328912713820000, 1023.93122009908850000, 1007.27922861912740000, 1026.24623580143790000, 1036.83423116200540000, 1060.42666753897670000, 1011.86711770479110000, 1014.84987098371160000, 1050.05598094393460000, 1054.48281459408010000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 558.05580230265480000, 475.52435145546565000, 497.83685410873761000, 441.31578036016754000, 474.84039751625352000, 583.35518553740906000, 667.62843312455254000, 674.00493561733640000, 599.70229791285726000, 583.93529105821005000, 561.52812754097158000, 544.77667364302090000, 550.99901772269072000, 550.68276700442607000, 542.17539207358845000, 540.80255913489793000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1332.95280343759010000, 1191.53965130713140000, 1120.76660961025030000, 1311.78888805981230000, 1316.25475180176750000, 1314.04389598379880000, 1463.39710729706960000, 1507.31032421480950000, 1488.54854839636410000, 1446.98562222557440000, 1464.70536276906660000, 1513.68237197861460000, 1531.29474024709750000, 1530.44690290003750000, 1539.25321062583770000, 1503.11141425098320000, 1504.73223030491070000, 1475.23595031815850000, 1450.28887901133070000, 1433.59455061197700000, 1434.35091645769900000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 529.46341341624418000, 576.79924823878957000, 707.67579165122197000, 704.16953942130567000, 680.29542188437256000, 692.91583462350582000, 729.53596008172588000, 782.28932246091495000, 784.14666967452035000, 771.34852813354905000, 750.94211675340011000, 757.25064692477167000, 755.23544804519747000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 616.92637386123556000, 603.25052433632220000, 544.80519808637791000, 559.43578918916228000, 524.29829070951473000, 500.11812501654038000, 461.42721007682815000, 465.13572530926882000, 464.91073413585235000, 466.03172158683134000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 644.33156184547249000, 553.45200694037578000, 886.82223231723913000, 873.55158612183186000, 847.59027285017066000, 921.61798148800972000, 993.10038837065088000, 908.65888058999417000, 933.78722454910644000, 995.51560159961662000, 1104.25292568808940000, 1132.85302655377130000, 1118.08556959302610000, 1208.93521012970720000, 1229.88071201096390000, 1235.97014133995500000, 1233.17871305601600000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 550.86359394748035000, 536.43835334067251000, 499.43749839184568000, 480.26969198232854000, 490.15070269701965000, 504.16855742804177000, 510.38277478678941000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 161.14485328886838000, 189.17099981640749000, 191.25261949140173000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
2677.88291006687950000, 2263.85679908056320000, 2424.07454608089940000, 2512.32651313848240000, 2400.70423703912550000, 2428.78652458049510000, 2485.15584946855280000, 2451.21567655067070000, 2571.39644955499170000, 2525.00164981082300000, 2664.78801638804950000, 2665.52564716848970000, 2727.35725986988060000, 2667.93494157750820000, 2731.67636531406470000, 2631.88419376093130000, 2614.01645918696070000, 2707.84223775153170000, 2696.16379768899060000, 2719.21736785768280000, 2713.02791468659830000, 2741.72122037302780000, 2737.83008678871060000, 2725.18452668437200000, 2720.98168139471910000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 318.40191665712609000, 369.12149697257274000, 386.66244127163873000, 383.49229418707677000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 976.98561811107425000, 971.25780062600904000, 988.11415248205481000, 958.54032526465005000, 980.55280582105797000, 1131.08637477020900000, 1130.35262144196760000, 1119.94552703920040000, 1171.42339648133450000, 1270.44431180814060000, 1342.74230035051510000, 1316.22923095668650000, 1396.90439559862060000, 1408.26356845941610000, 1444.86566171554590000, 1464.69496991048250000, 1491.73536230864350000, 1509.36352304338330000, 1499.92586893013280000, 1500.35254828027090000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 252.52305476825879000, 285.59663159107305000, 389.28034896334185000, 379.88758729274110000, 390.73876173635597000, 390.22109212333066000, 379.30339965018487000, 382.78590955930832000, 383.24852912165210000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1443.51326281290880000, 1560.20251421000760000, 1553.69256183022640000, 1548.79212291189650000, 1545.64380693675890000, 1644.58660820543310000, 1674.89487085830680000, 1767.45644560778120000, 1892.17500323106470000, 1839.41399132776840000, 1807.63753667894960000, 1786.23168348235160000, 1769.02786127794660000, 1773.18056119202310000, 1771.49572167531940000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 224.96609951727686000, 230.25783918148900000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1001.98327564179010000, 1096.27967252802390000, 1061.95069164500520000, 1055.73009106997760000, 1304.80947569398630000, 1233.41588944101340000, 1172.47846580477930000, 1168.31654359001800000, 1104.25106395873330000, 1124.92335666703230000, 1104.55366240152940000, 1134.63733693863580000, 1121.74670756047590000, 1109.56933997839130000, 1154.15585392493380000, 1213.16133320986960000, 1215.10142791692740000, 1209.86501013601760000, 1206.07074340578580000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 274.02401435253785000, 309.17515127884764000, 306.79869978857448000, 309.10526240335457000, 307.97418950616657000,
0.00000000000000000, 0.00000000000000000, 2537.10646404782980000, 2662.53139509821950000, 2610.33310325493450000, 2515.20441130500060000, 2615.62872711783120000, 2714.75442082299510000, 2654.28565634814230000, 2735.93014137833600000, 2506.58770033414520000, 2467.61659149248680000, 2389.13583902346320000, 2305.90808276039930000, 2166.51961789299320000, 2209.82189090236990000, 2198.33517052885190000, 2177.08322625520170000, 2137.82788110445740000, 2112.46251763068360000, 2067.21043809418370000, 2100.62229530327610000, 2110.42056548468330000, 2131.39945361981380000, 2131.72026505924620000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 2126.49558766746850000, 2061.97567989776370000, 1714.16550066427290000, 1737.50504116237330000, 1747.32783214861300000, 1638.77876519419460000, 1428.91391157011660000, 1505.53257294304920000, 1470.49860252686470000, 1548.45307701753900000, 1553.13795319849960000, 1540.27558723972080000, 1592.01422868639750000, 1633.13410149104560000, 1548.96324289186920000, 1520.01649961632190000, 1515.57705557027680000, 1492.21405173068570000, 1499.02136795481600000, 1527.16997294121100000, 1579.05867908204030000, 1563.17348708310670000, 1560.69134878743810000, 1561.35437962513310000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 259.02373448286687000, 337.73015779777432000, 401.65923213294155000, 427.59831060768516000, 441.76596322836809000, 441.01840414976220000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 2095.67428610462230000, 1939.65888163229260000, 1832.55601627726130000, 1741.63876375950740000, 1899.37061436610360000, 1859.89288378236530000, 1838.22445953513940000, 1676.90550818455470000, 1680.12811945821590000, 1724.74086361594500000, 1805.62082250927980000, 1761.75146435311040000, 1773.56212283060240000, 1775.62710699038100000, 1772.06108935997760000, 1804.03048409341550000, 1762.02819637756370000, 1713.06915022424620000, 1674.43755605368370000, 1670.52926145367130000, 1694.40318568360200000, 1692.22342887858260000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 793.51438283639675000, 790.26214616001926000, 806.66687902313515000, 838.72327512589652000, 964.31333545125585000, 972.29349500889907000, 1027.06532903068860000, 1058.57048403964790000, 1085.81638635355440000, 1061.05332364893320000, 1060.85529297588500000};



// Data from file x13.txt and y13.txt
double x2[5000] = {
-14074.4194118023, 3633.80195532272, 6031.29155379607, 5887.25925537132, -3430.70743721526, -6560.86332396419, -12041.7916399995, -6131.323951836, -1948.09551731409, 11551.88825044, 5314.69539939044, -12918.3719626566, -4129.58259604954, 1989.92720351500, 12637.5094545768, -405.001205905332, -8491.70327650958, 127.841278852560, 13033.0754555777, 11307.1392900841, -689.098560283329, 32.6716015182633, 8459.7988244877, 13499.4227848558, -8177.4428882636, 6689.55361113379, 15072.2341128806, 13221.0755122019, 1247.58700173498, 10012.5624545638, 10789.0025225012, 4504.23965204022, -10332.292013858, 580.544118718438, 3272.56329033831, 1397.22581461413, -11724.971135212, -2152.81702683171, 21508.3929571954, -6944.43965504488, 619.49343260631, -2019.99145374412, -7852.76569568993, 6247.5186153465, -8280.35714496285, 5968.79653936196, 7745.60865131806, -11313.6815122230, -8692.1151402557, 2202.81379923662,
-9232.49638314718, -21520.2331526078, -3297.72711873837, 514.440126654894, 3716.65824076188, 4551.56523238511, -6071.23676750082, -2233.37630340177, -3695.51991360918, 10528.1107828990, 13439.4820183708, -11730.3994794363, 4507.04518184803, 8626.04414155993, 1132.05882579099, -9671.17813939653, -18104.2790432186, -3103.33985978510, 5915.1024894252, -1403.39671157511, -1509.93574861294, 5423.06899220274, 15200.3170046740, -450.898302520011, -8680.27939766264, 5074.1024818683, -645.456342351692, 5167.37965784962, -8942.32928410807, -12638.7576723992, -16657.5171204491, -20612.1067602316, -23674.035542856, 9396.16211939658, 1627.97173899752, -11268.4371467462, -6060.38575188719, -5586.80694901302, -961.990416729739, 23043.1338914372, 2727.48566540901, 462.56639554413, -3235.40804710849, -5942.05808241255, 2976.82855123380, -3637.2657826087, 1282.97975273633, -1562.04801553391, -8787.40718404826, -3849.35878143602,
-5460.50484904639, -8239.6303485994, 677.295021054508, -9603.81680632572, -14507.7719748815, -16832.3563665747, 10909.9720982742, 3128.47287779298, -1101.73767922685, 2720.74966719693, -22374.0288724253, 18198.4334026684, -21752.7963104273, -1866.63493846870, -18014.2086874138, 131.626060516165, -6755.56544643636, -12171.8725338975, -2568.53392266695, -29264.4027208234, 6003.10418360675, -24227.9361372885, 4221.46143104339, 4362.46649392212, 7987.58731517287, -2890.2133713655, -3282.81264998603, 14603.8517089803, -20737.5930254397, 10975.8189140962, -2327.54397167907, 1727.26641268321, -1856.13222049841, -12915.8563393034, 11656.3005544602, 835.679695542468, -5860.29892725596, -2724.99823255574, 2871.59251728707, 9909.0986784341, -10191.8068156335, -12804.2062921321, 16968.7580977392, -9919.44747147553, 418.789592410291, 4608.35175641308, -2697.13672767563, 9922.75244567166, -8414.40176608676, 4223.65310059802,
-19352.3797568840, -18259.6194251737, 8170.04363515171, 3708.6415048916, -21720.0160207889, 398.459385528202, -6117.60648799121, -5739.2113665142, 1336.56676568992, 6488.71150404167, 4286.21063754965, 14237.8124715771, 5729.36889890576, 7552.88215375052, -11850.5881758873, 16023.0340139576, -2108.79065823742, 3673.81898113495, -3153.5171211938, 5830.7400065744, -9626.9323386362, 14697.1228358476, 1499.9129753872, -30535.7876579256, -8265.83422485992, 8566.29043623729, -1297.72018626187, 3837.63873467753, -4251.48877473072, -23866.7484356324, 4759.75419539711, -4252.93766377299, 11695.9094709479, -6328.72977966472, -4475.43123354704, 1654.39841182747, -12437.8775883232, -9785.45333083541, 11854.9740447423, 7897.31252197162, 6627.51087821639, -12692.6705541097, 5915.7598481252, -2021.82397686129, -7457.21709337862, -13474.5412898248, 9874.35153630728, 9926.45821793813, 5514.81282776335, -10170.1475539347,
-3521.7563369501, 5208.86818323788, 10888.1234208023, -11124.4303924591, -5671.56183042895, 259.758114732713, -2024.22905328712, 1332.60151005926, 1059.14306814200, -10848.582990424, -17066.3647738829, -13864.0275420806, -1382.98227296868, 8189.89274921326, -16492.9582259010, -6931.85984077054, 22533.2440562436, -8666.92870549327, -15154.2108346941, -11358.8521711162, -22424.1822313074, 14104.2423218902, -10912.2435354724, -6851.09613307015, -16659.1263429693, -9433.68112875413, 21225.416706535, -1878.26244150929, -594.265252295094, -3440.05697653405, 6861.79405116195, 9915.2850112925, 18314.0703570518, 8936.92738169878, 10244.8206938262, 10690.2327491145, -6339.22263160233, 4617.25493978444, 8961.57089249644, -8300.55153558407, -9589.04370090624, -14235.3675557819, 5715.15861050195, -264.484865632882, -6594.76325498775, -857.336322327913, -2850.73930154473, -5357.3022077612, 5125.76909024188, 4946.06928058575,
11516.1028017775, -3327.39762291684, 7038.999976361, 9936.74183932263, -11579.1138014859, 17576.1907657132, -11787.7986971618, -5315.59810838943, 5953.80540075927, 5028.81838987888, 10637.442020426, 892.587936353275, -3067.68978000127, -15370.9654747467, -11086.558130201, 9484.27258222025, 12867.9288727382, 8555.8058297481, 2199.00394651871, -15222.3882565064, -16741.1917430364, 16429.5737310404, -1393.88618182124, 3927.71245256394, -4920.16073081394, 10968.4234759012, 6209.09096106327, -1151.12626882579, 9786.70014820763, 15863.6971732521, 3712.57948537512, -4166.73469337672, -3764.95555302931, -1185.17626572937, -2033.94111402632, 3600.20728938389, 21551.1789375979, -5325.62816652899, 28000.5888212824, 4737.17500369894, -21972.6732623978, 2139.96258202828, 5279.95666852493, -11466.7235401370, 5332.69140331118, 1098.85843381367, 3196.76887953001, 5365.33397829468, 159.009954982825, -5316.88673130963,
13409.3493599058, 693.526007647363, 15789.6403837863, 247.694613783117, -3861.68649780529, 794.80683216105, -3247.35968693701, -14047.9159571554, -5221.55195956472, 1001.41236932442, 8439.51954689835, 13629.5892094815, 9231.00294833894, -4094.16478438147, -523.398516064211, -7066.54041237112, 3933.41012242094, -1504.87246047581, 16104.8538470527, 8599.8870082851, 6483.67209803639, 10760.5392300859, 8756.27188308401, 12965.3440457703, 14740.2337269809, 2010.01111368824, 10229.3535542681, 7924.32034150977, -16603.7198148352, -4975.20566365859, 22740.4170654475, 6905.42752822708, -1313.15061603013, 5694.96949167916, -17634.6873107706, -61.4150760060933, -6480.4973735788, -5052.60458114241, -4890.0321679732, -1483.76860054233, -7513.75664044593, -9044.36468232502, 13524.2190829111, -5509.06153241924, 5689.80050543513, 4237.68333646427, 13549.0970744024, -16559.6831103300, -3253.79670945061, 8392.24581528236,
37.3591029904941, -4201.07204256797, 3508.94449072085, 7433.24038169486, -11610.0220097205, -12637.4834502623, 4855.51467564584, 20033.5324537648, -15424.3208388677, 16957.0856918856, -3577.75949976764, -3033.60613083993, -1362.20681135063, -8845.55119257694, 15302.3441067593, -1467.06209622046, 5027.04065331396, 10515.2021593699, -4882.28737823645, -2432.74486970190, -3571.71736404339, 18889.3824314083, 6517.33835213388, -6107.7698931835, 1330.82424682304, 10759.9500959014, 14804.8377548804, -3731.87849522674, -2229.82903714024, 3258.30334343913, 1754.88019060029, 10537.8684760925, 9050.89940836585, 1363.82883471530, -8240.82558385006, -13927.5101225258, -5141.1283801052, -11815.8009142212, 9752.44570091789, -1743.09632575403, -7207.51598800509, -2803.6248814112, -11664.7737023791, -8596.03601161704, -7789.36401641304, 7439.45290827725, 5288.10981534009, 1646.81877389344, -15658.3661671355, -8544.66891461172,
15623.9312489549, 4347.92056755300, 9432.99348400728, 976.29101338861, 6919.99881668712, 7521.23888857702, 12461.2772564465, -2872.56135882667, -16118.8545605761, 11564.5224467137, 11153.0542337003, -14987.3503472867, 4248.9156120628, -1986.23913055177, 6802.12213535785, -3923.61194390757, -7381.01497610353, -5687.12920632083, -2778.2142174008, 309.252122215804, 3715.53145398213, -5726.42390725284, 10885.4145333346, 301.51793029874, -6032.40828909773, -5375.61339850888, 5243.37214194639, 14490.1823891101, 707.008320757038, -6787.90416632662, -1545.28137915037, 11742.0547130203, -544.897609701446, 2139.70958293971, 4623.93736659915, 4723.46044639314, 18702.0280683677, 630.046016222415, -14769.0806906901, -8045.69415849747, 14262.6324148622, -9736.9679844116, -4246.30562447828, 1332.64573379217, 4005.0540813438, -3892.49094257752, 2220.81043621348, 19994.3704651405, 2248.5036376045, 1776.35497274047,
-220.370042270786, -8314.92175759936, -15499.5097067234, 4792.37131795258, -2582.42968140829, 18218.9692896103, -8202.3662596703, 9415.37583331694, -4625.43744880662, -2556.27723261042, -10323.7716817885, 17326.6486291596, -15056.1415020914, 9619.16054158023, -3598.60643546588, 6397.86276551298, 1748.97143611958, 1446.84403922387, 4025.34400681809, -8009.29252832566, 9649.32557244028, -912.465603172158, -3914.10637669478, -9703.3653720284, -13196.6909887174, 7876.51640534574, 6072.36608823942, 3928.42145344923, -4070.6206384263, -24295.3354283621, -4525.17376403390, 11036.9326836531, -3245.57452945292, 11917.1166617452, 7164.66605448951, 8188.60979762971, -7121.95481435674, -2512.41523078387, -6519.81021176285, -9881.0807482779, 6759.26942290706, 10329.4865398649, -3617.15806884469, 19031.5661375682, 3902.10766232933, 10292.3723414631, 1151.00366404681, 11188.5161567149, -16417.9965309327, -17158.1594729180,
-8680.03977251632, -14742.8691012547, -13351.9157889633, 1587.88544168702, 5942.79569858482, -12413.3514217232, 18670.0446504877, 11425.1698076315, 8806.72125922628, 16108.3825981880, -4302.85046300238, -2562.69473683686, 547.266708953103, 5142.23497570271, 980.557437294136, -2877.82879798062, 7015.09586586602, -6319.90231123033, -18982.0396470584, 14623.7919065413, 7788.04332942975, -5422.79982509859, 13338.9332734046, 14447.3321451737, -19602.2105351548, -8661.54158549023, -375.769799059446, 26980.4631547206, -5521.00256343476, 6099.66055971207, 4595.21538104577, 6359.06665901927, -8468.90194955564, -5182.48910487823, 3480.97911236368, -2642.12603546745, -3516.12643746661, -2243.14106275783, 5100.61048053959, 10645.7745460681, 9307.73849110332, -3713.91191362753, 2799.97792507826, -7605.66321478983, -11590.6434599327, 8482.49231951159, -10970.4356523399, -8753.85834365475, -11915.4713822276, -180.253324645941,
-1377.08816172438, 15047.2665341115, 15774.5789592316, 5241.06891934836, -350.91973529221, -11961.2195204667, 19059.3898224913, -3792.70608264536, 8807.8780623286, 1855.26191351788, 3366.50909793013, -6521.48531701403, 5655.60393438685, 17726.2157866576, -1974.87765879942, -4925.89997131385, -10758.5654293006, 123.609004432200, 18614.0920860410, 2098.15997061092, -9290.03884620592, -600.191454489582, 19703.8124200070, -9111.82845337026, -19224.6647852714, 19290.0019294212, 4995.27740759455, 11593.7487677776, -1732.40398533955, 615.191533706111, -9601.03295219405, 7910.37382784958, 3451.00331351383, -2305.55676024296, 13302.0145122534, -4441.29618896888, 441.631789519864, -2885.35534239224, 2359.89914269162, -14432.6533141323, -2467.21315430780, -8499.77320192584, 3152.24093180021, 5040.43525816287, 5649.52169941242, 6454.09869960764, 6918.28062793127, 11989.9945785445, 7976.45419160386, -21186.5065752577,
-4746.24311257093, -1580.23818347278, 18856.0100916507, -21871.7696588049, -2427.46317086761, 4468.25256682474, 14552.2037858047, -7297.72820771111, 2803.53969432022, 5308.02248843203, 5611.03439980259, 3444.19581653846, -7352.42419919215, -4257.44419348132, 21.0932012477519, -3435.13752415524, 11187.3148644399, 137.202380280912, 6476.32612346181, 5096.03820289726, -3509.25087909736, -10431.1268367800, 6542.6161698549, -15259.5104839897, -20037.3854236619, -5911.43834722094, -7579.48249158452, 9689.48978953391, 521.657353038855, 1351.21067991655, -1425.36984840693, 10620.8277042432, 1325.15905039827, 3880.81274829206, -2974.77060548095, 20539.1167985507, 11704.0465529700, 9587.33483869306, -2050.8698043214, 15500.444856237, 9601.400338098, 10055.6626121071, -7113.68124616809, -2695.42915516347, 2878.88597788418, -17794.0999678826, -2991.17261335167, -31.8481157547430, 4390.09527815195, -15622.2103325906,
-106.699778197227, 8603.75019128609, -7817.19716912969, 640.343002765042, -8370.6020459209, -10779.9277454384, -5940.88150170207, 20883.8721888812, -5632.35856396787, 964.434480172566, -1439.73238462008, -45.7935664341983, -5240.44099450825, -12356.2590368191, -7454.22322084695, 7435.04095665511, 15332.5352666712, 16900.8359367322, 3523.21770913312, -10597.6757385610, -15640.7083264811, 20457.3442190961, 3263.4261668452, 6120.57343355441, -15352.4677641094, 4917.24168709625, -963.54339202154, 6677.80162259754, 1414.02596084830, 6675.70576272392, -18411.4059251712, -209.980679343764, 9391.0162838601, 15660.3575712473, -8375.39550949402, 8313.39510696638, -7051.66461349715, -776.102697448429, -6287.68223010561, 4217.43323520102, 19010.2125291185, -11829.2439536487, -13534.8004704925, 6436.3715347361, 27909.8298946163, -12734.4077488539, 6658.76093142795, -7189.84116665828, -4351.91578472049, -3999.19867148297,
-3332.43890473479, 13379.5799533408, -9742.00280887583, 4529.09837687731, -3529.74431823179, -5873.51810053065, -5654.92737265857, -11575.9706720954, -2706.34556005849, 7199.04627097792, -7211.8880933953, -23155.1326224299, 2807.02019651439, 1983.86415931832, -6157.29863604861, 5819.85505617688, -14194.9534605315, 4533.20300736042, 5203.96838501822, -17846.8902172397, 2893.58912659503, 5905.67879063395, 15347.3090853726, -5265.14879862735, 16577.3706779457, 2266.61439973014, 6069.37890390664, 10929.9335357131, -4610.88277715551, 6433.5091281287, -2092.95755402676, 511.283524612654, 1336.7987603252, 2095.50592728242, -5318.83240319186, 669.624771685949, 10135.0231739531, -15851.4744466701, 13943.4744438038, -10249.6709568964, -17738.147679934, 10051.4600377465, 9656.83564044034, -3955.49584998143, 2209.51690076540, 11746.6647633667, 1120.81240040051, -3623.63392908076, 21147.6637677159, -9960.17270881715,
13169.2095030808, -704.938960470186, 6061.71462768718, -1703.26408217144, -441.72870482873, 8995.17977105125, 18804.9316502294, 7546.25198672673, -5246.04286362541, -15289.9701503929, -2572.53480463563, 10710.7642396432, -5436.33690878322, 1384.52187677221, 8159.03566167166, -12245.8955966341, 12745.9090447262, 5380.9639822388, -7405.73796007027, 17819.5554338293, 9115.23024544591, 5533.91234850879, -5018.96650823667, 4015.8305645591, -17569.2024400831, -3049.90739517078, 655.317468396818, 8026.48853584091, -4935.67384150414, 14279.2651338917, -14841.9266114536, -9408.70060420634, -22748.1268558498, 3424.37200394381, -3735.39151155217, 20253.2889549556, 21778.0267677121, -12073.8107077872, 5227.52929837219, 5478.04726152306, 8992.49257502155, -9596.67404169989, -6711.30785410951, 13772.621377972, 4861.70843590954, -28835.2025588839, 19392.2546698811, -5661.82193256797, -2849.35354118917, -2191.43697451348,
-6921.72557547665, -2937.19997635596, 12916.7712778798, 9961.70535587175, -3436.00746981035, -2205.85414286749, -12491.3494460215, -18786.4461438029, -1840.16700789059, 2177.78590456200, -7133.64362132584, -17322.2268073057, -7894.56906352137, 13333.7890906265, -4690.20379546767, 7342.11924888829, -3049.78287397450, -715.528895822421, -9340.11166957791, -9710.96249863288, -14331.8019119779, -3405.46387985950, 4156.46923379818, -12104.5328744092, 1307.78377694105, 13071.9684757615, 1248.30769425117, -9186.52761245645, 20787.6601980098, 12936.0298633581, 486.300827933627, 5548.96177014983, 3245.33904445088, 167.644186996675, 5347.75571980563, -15318.3641587391, -859.396549310083, 5829.25984112833, 6835.879425136, -2015.96870009366, 21342.0991369934, 13047.0505637514, -17820.7743766164, 43.0547284589691, -26069.1843218313, -12199.4915793899, -4290.55632521187, -23316.2906007520, -6508.790886443, -6661.03479532506,
4531.45516324653, 12653.5800230572, 16862.4630221606, -2853.48297558765, -19480.7780222259, 285.844125717493, -3903.40269182093, 8340.93760329627, 6239.32941098311, 18937.6045611476, -5932.68856282738, 4779.93363129948, -12868.2801768682, -3937.26871364294, 18073.2117510169, -14663.1975728603, -13432.8584901765, 4113.69352516046, -13192.83359967, 15616.0865534846, 13125.8628970504, -3711.33927306298, 1580.37262705535, -13460.5584081301, 13283.3564930520, -20559.3391780032, -7715.43293539173, -3041.04087781222, 1089.41556306632, -2162.73996028268, 8319.31285600567, 15658.987993439, -2877.23625069851, -2418.66024132810, -3040.30731108522, 3935.02524360382, -7834.25657435732, -6508.5870864682, -24948.5896757214, 947.581566642788, -13528.8367674794, 4599.71165445558, -6271.34512714105, 18507.1215182302, 16354.8756330651, -10094.0092519228, 736.138851603937, -1152.26727016344, -15429.0848171911, 11011.9924897166,
5154.1825161767, -5157.5750819618, -1789.70460681474, 544.685667337899, 3585.0553832032, -6753.67343061741, -6872.50618731474, -9261.603415298, -3109.53747693574, -7467.49888156207, 3105.72124973545, 7723.81971552402, 12517.7692851729, 9293.50325890997, 10560.1712810918, 12620.5356769474, 22789.7341729825, 30508.7635839832, -6233.52698894688, 8338.77864351294, 3886.12338127115, 9173.17620676998, -18523.2778889325, 6898.94505596023, -9544.6357947127, -2751.92115764258, 6630.08246088623, 6965.31165180398, 21004.7780038187, -2504.27152947754, -12612.7481910147, 17363.0862645296, -3493.52966514262, 9663.17661409087, 12443.3363986693, -9887.0188409268, 8063.85257355487, 7646.51964543066, 5526.99245432635, 7034.2590222327, -7069.89618842414, -9393.15630421762, 11399.6617354905, 10038.4496897064, -10824.3694544793, -9057.51121321297, 10256.9615264348, -19521.4150571210, -20724.1262218690, -10598.9641594253,
5832.90768285214, 6767.17190344548, 15426.6396990147, 2004.48706573718, 12972.9272976583, 5680.35117425746, -5602.75342148067, 6653.95217318698, -4462.4166423524, 2484.68377770947, -15631.724283976, 1799.70880133174, 9679.2318743629, -3828.31297667445, -11612.5078397336, 4760.76694296355, -10008.0113176405, -6049.67795242737, 8524.78377650631, 16143.5433406248, 19933.9883046955, 17050.6777206771, 719.930311505094, 839.050544074815, 716.12544436117, -5266.90722827989, -13834.5627691039, -6054.98898379287, 4472.16442858732, 9929.40697732942, -15247.6784401202, 12738.0542778964, -7461.98038844489, -11067.0978981147, -14458.2138445931, 10714.6753126324, -6781.60563647249, -4925.52051222458, 14571.7565231335, 3008.0841053771, 4036.78517257054, -7748.84927378356, 11529.9789572945, 2642.22136782756, 5323.21042739208, -5105.03177590985, -6773.36050926331, -4824.65935345691, 1373.80447540381, 4215.87563805314,
7237.31414052494, -7425.99368857543, -830.941793380968, 5053.04779975801, 1308.12684122704, 2053.76067486141, -10658.9932459183, 5232.23559028387, -8153.7346095028, 2775.09716718647, -18940.0659278968, -239.597786244306, -2950.50608218613, 27140.0899707307, -6286.5368294516, -8689.95756062922, 606.357092285643, -96.3911255375029, -14432.333323079, -1499.14154797499, 2256.43101718944, -2494.86653683197, 8007.65274261232, 4843.34114599576, 280.225660824247, -5101.88539080268, -15414.4169193052, -2862.25371031216, -179.530028180391, -3859.60781880094, 28419.5734516532, -19327.1004417031, 17663.9024367784, 790.361942729392, 6485.4691631578, 11923.0881560708, 3111.8367803101, 3704.23080825662, -4828.42128476212, -11818.8540828544, -4019.54545988883, 696.5106863063, 6826.23664616037, 1950.56733704068, -9230.21035695294, 2984.35470508255, 11571.7575659464, 6832.37528415018, 5736.61575226131, -4225.4544480404,
-2609.97443223534, 10089.9527647336, -2147.40775425426, -16113.5401655746, -8659.4795320767, 22636.8544245754, 1318.13628548912, 12740.3375041228, 2233.46759825508, 10736.6889969719, 13428.1124189685, -16415.4371050223, 2878.85098102236, 10643.9774467996, 6025.92892778344, -4943.40384726214, 13945.1644709776, -5871.62055396337, 20094.2197524749, 6794.26272028619, -11316.5867083522, 14961.4294295941, -14888.8464995243, -4942.45572664734, -9863.63897051268, 19993.4002528498, -2710.57399109406, -13013.0053102581, 7184.00020642401, 5061.04270194157, 5394.89022392604, -14993.6325731486, -24263.5138422241, 17016.9327563843, 14025.2582710807, -4732.99303226965, 3104.05683948499, 4300.34082547929, -7769.1435107066, -10727.4041348049, -9162.30669952086, 24273.6014442304, 2885.07369531021, 19713.0867358712, 6296.06008803422, -2022.10958850377, -4534.2878131923, 11544.0062667376, -11885.6899383609, -13278.0211180068,
3586.30498869924, -8044.30266552172, 8069.13204916797, 3888.93958882226, 10991.7461856717, 2807.59956571497, 1565.04502078971, 14086.0747129282, -7130.05094061164, -23815.6109390185, -8022.28293550044, -1494.86579717686, 9377.9605388613, 12740.6911194917, 7193.07096055018, -2118.00709178296, 16563.9113937091, -7727.47614373698, -1455.17640370668, 12817.3231929893, 1570.04161627371, -21719.7190264687, -7280.34452273637, 2013.43627366811, 8518.7757694946, -554.44035161336, 11002.8615375155, 13914.2334244388, 7549.31016648368, -262.244736863053, -390.794308121378, 5695.06445569697, 3455.78018500778, -2970.90660662763, 3254.20203399182, -4189.77911480181, -6044.16078981267, -1020.60112254486, -17123.4201431448, -371.435946687123, 5849.7466165982, -8008.35067323702, -6846.38280312693, -5608.92454521511, 1797.94966749007, -7459.52552420414, 6890.50269770665, 17719.6328859951, 1220.05307330123, -2815.29214608004,
-7518.73152304827, 4187.04812778012, 19300.6338171197, 3105.7658953641, 13799.7146205858, 10055.1647514737, -3564.64002464916, 4304.66999825196, 1697.50402601194, -18023.8926010851, 14252.6834438491, 6499.8773139637, 75.1564037425645, 15220.3129725864, -6410.47644685135, -22490.1845322480, -1319.62714774383, -10752.7587226790, -3814.33230149981, -15008.1967410518, 2140.26753842747, 4406.56322229559, 12320.0858652165, 8719.73602569939, 3732.99536148139, 11903.4941129839, 15383.1320854914, -9712.6478642162, 8387.89601224373, 12444.6495498291, 12041.0304318124, -7168.97166037246, 9914.50053586787, -10216.9836372151, -13538.1327433352, -3849.69368365058, -9443.26872805976, -4899.46339848102, 16302.3752852875, 11554.5314034596, 11820.6153378644, -10302.5293719841, 10936.0460309229, -6825.2939926584, 7433.55842079751, -6175.89853582912, 12868.2174842207, -2669.94051247473, -5332.3331512996, 4586.73747195503,
22241.1939700748, 6950.49927910391, 12797.6281189433, 11559.5862056274, 3404.38428127394, 668.245449483421, -81.4239757780352, -17911.5408110213, -9707.86099857813, 26198.3010843117, -5699.90699972228, 5040.14540172379, -990.87661742067, -4206.30887426993, -6904.56566920892, -8906.14225782754, -6790.59940971143, -3086.80326584726, -4142.43255231937, -4655.55676531654, 4359.07697226972, -3786.24188231679, -11450.9861516119, -13100.8746573506, 4119.71311238142, -6461.13232897203, 3776.26248771041, -7511.01191556062, -4417.6164913587, -7987.38907848706, -2548.0572830915, 5548.65042583754, 551.846277445556, 3805.59408870270, 1737.19360640855, 3721.19395893541, 9794.49073440206, -9235.97857571313, 1959.66482861463, -6194.94605348141, 5673.04522764065, 8616.47731849783, 10671.7759601996, 1515.76042240006, -5380.66373211665, 13086.5592881370, 7210.06396674962, -8287.44747315733, 3112.08459293535, 3888.4358029969,
-2701.41660930345, 17630.8871487346, 10751.0707880259, -2894.31670804185, 7980.28800601454, 6614.89563595969, -14090.9687861212, 1312.40205318394, -29.7452537930627, 5912.76990084620, 3670.75019049027, 2225.16838868996, 11083.1367928983, 14091.4536692825, 497.971100377404, -4901.6344091053, 1676.21267549162, -670.926219571422, 14154.3634138716, 9968.18381966933, 1362.07525752192, 5173.61081708951, -8808.85272808653, -3164.26569252636, 2843.45717692208, 4580.90014800344, -7170.70721021885, 10732.0304680026, 17589.4160501588, 537.528584770039, -13412.8559884294, 3263.7160761559, 3474.64807792421, -16159.3825614606, -7960.87031963535, -11770.7572113586, 5974.79055042428, -12618.9271455794, -7250.31409499597, 93.4224473524885, -13419.3063274056, -1614.44808974287, -18110.3401968237, 9766.06643452104, -4061.61126381968, -9131.2898627192, -12323.4338451410, 12719.7098997349, -16487.9820981269, -11095.1604988605,
-8942.73732890706, -3322.65758846357, 15973.0199708199, -4131.64539002400, 1923.66560088059, 11617.3191529204, -1627.57436919103, 2521.86388862490, 34316.4783846974, 18755.6704162542, 4074.77687613178, 9633.14947818775, 5245.11158452532, -3948.21970480151, -470.684452422569, 18397.8146568003, 6323.26417880036, 14306.3669115777, -4745.23340520863, 692.657973926925, 2524.77682169528, -2720.16264833690, 7751.12995368051, -1231.24386452047, -16244.2092372554, 629.725663720947, 14704.9037617940, -8127.84303324977, 13768.8538115261, 21553.6594636089, 9874.13455062964, -10815.9275555485, 19702.8761093351, 11996.6773307624, -2771.25330802717, -507.194195468242, -2851.88708752454, -18940.7557320814, 5230.41060556634, 6732.6635191676, 6498.35666032127, -3286.58114097813, -4809.43524630324, 1310.86301494772, -8530.9768812439, -14433.5832237972, -5892.80809041138, -5056.82799303576, -700.006841449657, 3224.99831673669,
-8608.89280504034, 3753.07260453864, 13888.1875237074, 1616.80068010496, 5801.12190510132, 10503.8896291577, 5851.63230750488, 22723.9592752944, 2110.53768429176, -1377.14721432363, 6690.9083290471, -5264.73913331734, -8053.68969061089, -4622.99851533508, 12289.8851623688, 6135.84848155591, 6512.28105611184, 15827.7871858459, -4500.91390589821, -2161.89252618282, 15099.8845888484, 6236.18820882479, 2987.14597822465, 7871.18588236552, 5272.81899869195, 16767.3699521099, 12712.9043981873, -16533.5710644417, 3605.7894049571, 3883.87683014002, 12862.3773492336, 11416.8991404797, 21436.9354426802, 14401.1724624378, -11416.2443892451, -15111.8246487789, 7299.07829234825, -2140.96249282054, -7636.72476415107, 17153.0534133637, 1744.45354521611, 2128.05537983021, 13726.5026408572, -2175.64104459568, 15259.9186779150, -12760.1234394669, -3045.43439018697, -1407.65885554656, -530.783858581546, -701.984494376865,
7308.43653778791, -3495.69701944689, -1995.45724123300, -13025.7497020718, -20029.2047891436, 2671.67806236893, 15197.2258902774, 13928.7912683742, -10942.3666944411, 21118.3072905004, -9905.02123907552, -10129.6146829581, -16052.036255332, -8411.49748617216, -5473.93189694599, -27188.2892358938, 1447.03927548939, 1192.42814958698, 5941.69655841085, 19999.4035386230, -1792.17884052219, -9468.3952937043, -3644.27470200421, 6703.92065351086, -1470.28633865411, 2374.77518553993, 3405.75198089937, 20543.9335513826, -3706.97307717369, 6634.4300196703, 5511.4888210319, 11843.8410357984, -14455.1768310587, -3471.46276096265, -7025.31409311869, 8190.5153357627, 2616.31764699835, -1793.24477177016, -6608.61714054912, 14472.4625938163, 3568.73795747388, 3239.84519618505, -16942.5777646787, -782.566275454647, 12560.403226535, -1588.60236135276, -11192.8326378533, -14937.3373418094, 8358.68021737025, 7715.69776738566,
18925.3086863413, -17236.0781649127, 16650.0873878902, 6235.41233902937, 1475.18143011332, -5804.11985589998, 1294.24451265504, -3061.03919755023, 11635.9443171025, 12501.4037603293, 1627.37287671513, 5007.39308332098, 9717.87104697755, 9112.36351947317, -3900.34695897693, 2973.1604853757, 1042.67698278401, -2615.43248554077, 321.253449562084, -3710.3536174045, -2446.13037090491, -24906.4522780625, 2714.56661284737, 3895.83648603703, 3625.79721243694, 5146.02282816619, -10792.6122994535, -6738.24183586965, 9289.44578450983, -14810.9814092583, -9077.26159510833, -5720.1375611728, -9438.54843716343, -7753.40118871582, -155.312879800284, -1215.13685711208, 7480.00604926963, 7833.42699535481, 14625.2511055318, 10819.6559694697, 4124.27682039508, 10719.6045062743, -8095.12699967845, -3803.99468609454, -16900.6621301636, 13091.2658736918, -6751.48865782101, 11252.8759407280, -7856.59798444344, 418.838163470697,
-8313.10368065455, 7669.54711890237, -10431.3919835404, -1855.08531709394, -3251.16499731540, -22519.0612613001, -17873.5751509262, -5596.96446517115, 3553.26243929464, 17641.6099872733, -1616.44059573253, -5621.46593217296, 17769.4762090134, -9206.60482981022, -2663.01861334235, -1524.06526524291, -2887.94714490896, 3469.66005370088, -22531.5065298466, 14574.9421281890, -4317.65829229467, -861.226365642414, 8182.53208477944, 21014.9281355778, -20117.1140803169, 1453.62055862828, 3840.93518076986, 11049.9478643834, 23939.3501545620, 8401.06083160192, -2029.17507700954, 9879.18581100565, -6096.35393569692, 6528.24549333772, -1805.13775878006, -7408.1476978146, -18408.6559398850, 1914.20921395912, -4223.1821700965, -20572.1429441649, -3750.54185173232, 11349.7844779538, -3459.61656913885, 2468.34508912123, 12283.6851039063, -3228.74958235021, -4160.08104028780, -6131.82024879619, 15233.8611561181, -3511.60019508616,
-12073.0364774013, 2764.01927427792, 2190.79420322158, -20333.9821497156, 4609.79571452386, -11799.6787477762, -8551.45865182603, 10401.3842501181, 1765.60679464428, 9100.88498099612, 5394.16503085704, 2878.29728757419, 5366.85041154595, -3927.54742875026, -3451.16784220135, -12074.3447026404, 440.301931218512, 12025.4745283881, 9863.48547921814, -12641.0787946621, -15422.8961673873, 13770.9269704549, -17472.7558426343, 2341.98551814774, -2345.51625349174, -10269.1192726779, -1249.67588601833, -10802.3997022077, -7248.91135960377, -7576.75530649092, -10259.2457554114, 18332.0021968550, 25437.0400214815, -10439.9160148276, -10673.8853958968, -12922.4621503122, 8864.49367162315, 11842.5307257995, 1045.11633283864, -58.8028178260518, -6898.67704407164, 1565.93817963533, 5157.94988432542, 11818.3027783487, 5282.21958761811, 4035.02309757120, -3503.95821209507, -3218.16218218333, -3508.21058908555, 15514.6024386562,
6403.5341474568, -5495.82148568112, -13556.0977132680, -14105.3389446012, 582.568638415379, 15913.9913074445, 3876.98098294364, -3414.14553469421, -5673.03349413901, -6881.15535926044, 15532.1221158632, -13208.6466613998, 6201.53790453508, 13405.5786822137, 11467.9584883408, 15328.9406543377, 14725.0207522746, -3402.43912019826, 7947.94903750089, -10408.2559873998, 1052.949969288, -1901.61416144801, -1995.64800491387, -9559.40412746538, 5737.78516643015, -21374.6175842642, -4471.18920828728, 22451.8259574757, -3249.17599376353, 6993.39672248324, -9735.70957422247, 1432.27345433208, 14622.2378991318, 4635.13859397584, 1903.86345702419, -10512.2394703250, -2314.60524030151, -10433.1125958257, 19392.8440611295, 1336.17663605750, 3508.56147421719, 1448.49862149925, -5466.02069804191, 2268.68676978826, -2618.98361950604, 4113.43455580844, -5460.10731891783, -6713.34983404288, 5472.05996747563, 6047.52060719601,
-7594.28771906998, -16472.0216328205, -14029.9835553679, -15334.5402062043, 2109.34836725132, -9100.2337539871, -4373.82898841701, -10400.2473672988, 2213.51689628770, 7909.06832035646, -6362.06758194715, 6761.94539097549, -16646.9838216942, 9650.94536662046, -21359.2705220884, -14164.0542281098, 2329.35707605467, -4876.65535303503, 7717.57508903473, 2699.95225715663, 13901.2442274127, 5282.05862466318, 7972.99487256397, 2405.07975271674, 25803.4779203914, 21349.4509551713, 14667.3178480004, 8680.41950047045, 15819.3996818742, -976.193111823369, 16869.1488280051, -5220.07601685771, -7646.20141447969, 3228.34041856081, 14156.7832349681, -108.015366939866, -2270.95223340089, 5839.16961750884, -10196.4592808051, -11542.9648215535, -11797.4435180347, -9960.64100595216, 9630.54008841517, 942.11967235481, 1068.19343048479, 16266.0516601663, -9785.4320843496, -3206.19149884378, -2477.71207283381, 14667.0053325119,
15328.0114338024, 25495.7642755863, 7673.81057979097, 998.926514712448, -12245.5919572161, 7016.96855599966, -14518.6045031013, 4890.34392956722, 5560.92692690183, 6388.87505612981, 14722.4791636230, -10328.4162660577, -3853.66916442966, -7286.310334152, 22842.7729087224, -3173.39018432416, -15604.3911507406, 626.566571478026, 4552.08746392122, 9599.97544122767, 2527.86998011441, 11687.1601547555, -4520.43068905871, 29666.6288797557, -22391.3660364243, 1914.52241727809, -5826.72210411864, -7079.74574466672, 11371.3139770059, -5324.4519553587, 3723.12447384546, -15405.3057495928, -6355.45403227159, -11510.7909509793, 5909.22824909029, -1172.31662942279, -4873.91295709128, 1345.63345660545, -7283.30195301883, 3337.27486686903, -17081.6261119916, 13250.6267370657, -7751.77622848133, -17175.2841758897, -8997.2307234188, 3984.74955684108, 10483.6993376590, 19544.6671689976, 5953.14138852212, 21551.5024697464,
-12169.2154436959, 523.769285672481, -6183.05072779205, 12839.7194471679, 7509.39052617431, 6383.70603749364, 2920.69884960875, -8898.60765824348, 263.755583774284, 17266.4070255727, -8901.40363027796, -12292.0300023830, 10226.2761887365, 10633.8586538023, 298.762609152623, 2979.19051265482, 12433.0829285377, -4472.54254499939, 17173.7285824610, -10588.6730434306, 4205.10172809967, -11662.3588552552, 8717.57333184774, -3793.30043308701, -3968.68010562443, -4536.76272014879, -1230.61094979020, 6736.86726988361, 7042.12216220786, 10671.0367360801, 9677.22572903746, -6950.82405866272, 13183.8174401360, 2068.99600175191, 20955.4498233337, 8941.14774510135, 11104.6656402368, 11961.3099953893, 18451.4414173123, 11744.4901236345, 13712.0664819595, -641.391241500788, 108.646627508924, 81.8423869687173, 23860.9640066941, -519.423227931103, 2977.29567165184, -12932.9652366606, 1187.33174839865, -16128.6934958750,
-18755.0058604434, 8579.95868438166, 10635.4820469752, -7517.7138132557, -17984.3540790225, 4828.63023038753, 8348.12454137214, 2874.00888507638, 7173.55139213106, -16165.0054396078, 5686.8906594077, 6989.34484859451, -14622.3438107447, 10237.1364066256, 17836.8287405893, -14653.4547595736, 9639.69006543788, 2535.34058737507, 8070.27409940991, -12003.7619755559, -15288.3681778066, -16473.4345557102, 13216.8059017228, -10602.8657577889, -23290.5329664834, -54.8892837106462, 15702.9156251000, -234.751093469529, 6808.74607133373, -3893.06610706112, -13934.9066902691, 10296.3576212622, 14702.1801603088, -10130.1960237038, -8206.99503750834, 11379.2071374801, -10535.5689964893, 18169.7678948296, -10159.9192209177, 12475.6019061832, 16559.0715994532, -2262.33795385613, -2014.12525537717, 21008.5180201803, 8135.26740792343, 3245.43176194110, 3083.79927921828, -9920.8517043901, 1699.7735361129, 10358.4964396017,
-3698.69038464183, 10036.6911416952, -10020.9751842422, 13877.4067095129, -11279.6445138184, 6397.1977147343, -1206.08486912147, 497.596388137271, -5647.66680076743, -1886.69615364288, -143.120073894037, 1509.82744563210, -820.994336874737, -9596.1240079627, 7487.85488387103, 12105.7975028898, 5468.48534569864, -16007.6974115765, -16969.7457297610, 7710.55729995835, 2666.92673293158, 10279.6168351579, 4490.79465044616, -14837.058662515, -554.726340412586, -3249.64700639798, -13984.3911082003, 6622.98236269664, 3235.84262466057, 3618.29005956219, -5443.80206330563, -3048.39793439704, 6080.04392415096, 611.265295352759, 13155.2740481414, 19817.4268295478, -11138.9386537775, 4561.34604386539, 5399.68873670015, -9915.55940448566, 24969.3199923854, -11585.1313236571, 13643.3317921935, -8199.99371686104, 344.504802329061, -8915.14734165276, 10098.4381775300, -14073.0431149482, -1460.12881800945, -1356.37386590865,
-17749.5388056318, 2029.70864398996, -3110.43965073291, 7246.15068420523, -12770.7012538254, 4928.49750534918, 12229.3357098924, -13431.3124751608, -3686.85602294325, -1971.90043842235, 3790.84560415192, -2625.39472202786, -710.475663132841, 27141.959917122, 6153.70425922017, 5317.10620382464, 2397.22386385408, 449.898257524012, 9804.30224881425, 2704.43012207507, 2312.51742709390, 9911.4699424566, -4124.44477778057, -2943.35508081382, 6400.15841051196, -13715.7362037172, -5170.67182389893, -214.170707192519, 6169.37266766103, -1227.38038757961, -5734.51950066137, -2416.10456907112, -18098.3694941316, -3637.84590856335, -3840.58226858792, 8645.35028576193, 2778.44201210398, -17955.0776598604, -6601.81822332569, 14706.6011837890, -9380.48201782848, 3682.36809829024, -7999.27622261673, -1385.43382308125, 1344.90694332351, -1268.76567970415, -2797.84530033112, 12697.8825528766, -9191.94685751374, 10656.0460758268,
-18487.1615107488, -5616.38571790237, 9634.72280146902, 7203.91746183858, 7422.6824821296, -7818.8707605418, 8269.37417691614, 9637.68637150225, 3220.56029083138, 11825.2396237999, -7551.24074666119, -7665.3176322476, -8294.10629635545, 1371.25032579793, 15590.5309340093, 314.966633865644, 5887.11028033729, 1179.50108936756, 11966.2681018619, -17685.2462805084, -14256.1803290326, -3758.19499944331, -3223.61804949992, 10205.3551655701, 10147.4725655298, 6169.64547311632, 18838.4422500580, 4951.14663726375, -8848.63724391692, 7041.9056454881, 18388.8320410831, 15186.9855757712, -3574.9354217748, 17583.1148246676, 25118.9099215809, -5628.40895297951, -17639.1125479097, -14322.3122905454, 2977.48343041834, 978.053594990597, -93.5478567745282, 4777.02783543723, 12247.4952797497, -11051.1501908329, -10535.3283618644, -8012.68451079174, 7727.13026688474, -6985.53714258419, -7952.8044007955, -4705.19864019713,
2319.56973180013, -8151.68337743053, 8978.86714611503, 1701.88424866388, 7553.87010668583, 13804.9017391522, 947.890381252575, 12995.7308519052, -26068.6990499283, -1096.90312100208, -2679.25911555101, 11248.0929947467, 3493.77211830056, -8675.86307831641, 1815.40257725277, 8426.83151043378, 7824.63864770473, 4214.15281384394, 2993.30879532845, 19423.9880473509, 1366.39542845116, 3916.17905643392, -3147.64619202361, 10156.8809117048, -10605.4142132577, -4065.55175532775, -876.33737208944, -701.135258896167, 4295.76666816711, 12281.3427443441, 24765.0963507958, 16725.7777778328, -2038.05542987599, -2707.06525002463, -1548.73109151633, -3445.80710678152, -10009.8043037813, -12336.9154150194, 7891.8839172101, -5288.19109282464, 1593.02382777047, -1359.67224598764, -16986.8252839487, 11967.0247350324, -16.5210849328178, -7022.37862687025, 5208.51663682038, 4069.98416838259, -76.1101304467642, 15348.6056211151,
6139.82834625202, 11978.7707432898, 13157.5992481304, -16002.0598440492, 6030.75360581993, -6113.40061112925, -6963.13766117125, -4290.38851725723, -3952.13543572483, -7559.8343791125, -20239.7752021651, 2214.02176362756, 3262.80720785004, 7535.76726931433, -1366.61332930921, -5229.83699883033, 4819.81127035226, -9536.3365708929, 16862.6884225510, 1015.64923925902, -8505.64308655642, 2861.16563884289, -11329.8807207244, -522.230325514619, -15533.6705775793, 1537.19669880467, -3261.11843848348, 22342.9625628134, -2356.60519248183, -18043.9534920224, 10121.8286734935, -2436.27183522330, -6740.39181549904, 7209.33604209766, -7291.51106501516, 12550.1195942363, -8168.96227043815, 8424.49331144871, -19482.7854644762, 546.07533792878, -4944.97936202408, -11562.9073834944, 214.867854620500, -17371.6398221136, -2056.065190684, 12329.597076509, 1919.801523656, 3325.15444867827, -11922.3429750133, 7588.21530224924,
27784.8211258327, -25496.8961388045, 14565.7133824085, 5339.67195391609, -944.496995718828, -20218.8622755186, 12694.3798406492, 2302.87783787943, 21927.2948428843, 4220.44081397735, -1967.00669012749, -7676.34092462823, 7110.78037773174, -636.727055382475, 2277.75042900443, -3551.03370592930, 2457.87091149655, -2410.42312651483, 11936.9714917226, -1073.20188790824, -1112.63440180495, -5267.58857336598, 3749.61465964466, -2317.4818476762, 9308.60499990833, 3913.50891555719, -4272.73296318799, -11662.9034811802, -373.5375009831, -5771.08745429851, -1452.26460937659, 6819.86911492013, 3671.90546864365, -22919.8181908694, 14120.8738838803, -2769.71252178987, 4028.17735188489, 19031.2103159375, 11194.9322959428, -10599.6324480942, -5160.02776276085, -2941.06858635378, -1857.43403979805, -5613.8755425492, -92.5822771135903, -14281.9732737480, -13875.6814863587, -16244.8992661079, 747.154748309371, 6103.47612342512,
14453.2029841621, 1973.45736759806, 8972.96311115186, -5471.66034668301, -892.456336754075, -4.44111285020727, -8052.18381668173, 20824.2482232917, -1003.17853543713, -12524.6156621257, 2044.50037239708, -20322.3859340120, -14941.5777766, 5495.21844346543, -16964.7065573803, -14494.9508964343, 11364.05987061, 19125.3433402016, -995.49350838029, 5812.06861811265, -1295.92458129854, 23264.2092402054, 12377.3022976314, -8853.39252459723, 4167.52979539385, -14017.7186945561, -13810.4197514065, -11813.2513336585, 14373.5448022378, 11944.0459110832, -9090.94315469206, 15374.5706550973, -7356.68088616719, 8112.99959276729, -29345.6102674256, -4164.82226175116, -6796.61171322477, 11568.3250422468, -9941.14389361136, 4256.42547265394, 1263.79155614656, -12162.8204537295, 1044.57825972751, -4616.74237873993, 7731.17340680005, 11903.6878114573, 9631.23192294195, -4438.15812014779, 1669.62559570375, 8552.43918956,
-1725.30665279438, 5075.44261002958, -14323.8163814671, 735.341423903, -10666.2054371110, -7284.27164451260, -2739.34631427138, 5419.86803942119, 6283.86121407418, 9748.56904985267, 10749.1159421427, -14272.5978649708, -11771.6475387956, 10699.8536336372, -14068.6728844710, 3857.60430098825, 24533.2895135075, -14763.5402302756, -984.888802661217, 9693.58136479903, -7076.85576595533, -16159.4757973698, -24830.4877927826, -13143.2051443210, -4259.98178681863, 8611.52775149094, -15646.6441750398, -10284.2554963046, 7640.94166752795, 5668.71766406885, -3266.74659041031, -52.8742218220219, -5807.92016486235, 1033.09688904890, -11012.5734022144, 3213.3495604028, 7300.59302057022, -4120.83941543436, 15834.1189761054, -22019.4124759884, 692.706699861677, 16152.0921352433, 2871.14092111833, 8108.5466967285, 11376.8552277415, 18309.0152646129, 23887.391862081, 16814.8674765169, -4811.62762836863, 6809.43554425368,
-2184.69388809168, -8126.02349024447, -18349.7079060461, -15626.5983570689, 18798.2862916604, -93.2271819505798, -9898.8267516395, 10340.7940814296, -26245.4955225843, 21279.5425417787, -5673.49538864543, 21272.2736176921, -14679.1857951386, -12486.4539424865, 4375.41597827429, -6106.35372485283, 15903.6452058009, -18057.1094943402, 4663.83692257819, -22432.9861077045, -163.306769140450, 968.40614189535, 15285.3649291758, 14101.6368512297, -1106.09885765533, -76.5618102526758, 19398.3271437751, 12755.0185507828, 7907.71640849404, -9987.08382990818, 140.456089206244, 23332.8146849461, -8105.54854125702, -13928.2627364325, -19852.7808654170, -16034.5415294836, -2675.01998004467, -14813.0861545651, -244.653959932561, -3835.01735467314, -22830.5726738373, -3658.31783226429, 20008.5736253386, -3341.35703001649, -6827.28800128402, 2727.49057611003, -3259.43581707353, -4812.21338988377, -6625.95576436594, 2362.01868208737,
-8057.76846139324, -3189.09795221476, 3934.03977755841, -15429.7685525852, 11369.7705258318, 12837.7966635428, 2178.36988959942, -7210.32604097877, -3975.58978817017, 4102.91725877216, 7081.7855755943, -1996.92717850073, 8568.7317855853, -17526.6834497276, 5604.95243079938, -9921.9460341698, -13439.9962639903, 28942.8713362748, 16242.0344116947, 8609.75119796477, 5968.98742816911, -4736.00022816276, -14460.8540049671, 3034.01340256805, 12659.4880310455, 3038.28536085765, 2872.33242610595, 854.869788519531, -14098.6303156366, 23003.7776558415, -6489.25148042236, -6255.21777884447, 4448.74513942813, 5445.48161600373, 5612.17961434775, -8452.81769838877, -1984.90033767952, -13620.2545263187, -7855.3508184479, 9161.87256304997, 10092.2661552300, -11205.8014669005, 16543.4102637322, 6251.2587588598, 6328.4999002291, -4536.02205343184, -5840.8874416717, 4536.39105137295, 6692.54873140687, 6530.4728229779,
4523.1659895431, -186.426961673410, 15067.2111224673, 9196.2011912799, -5663.64734502514, 12739.5291936286, -4945.49628609068, 4102.48871055629, -13970.2674106817, -7747.45724476394, 1697.69261053462, 5642.67061457703, 7019.5496388095, -6558.09680870499, 18849.6764595138, -8220.44364066523, 14548.9760664319, -12620.1179207026, -11863.8577967152, 9569.5847368391, 16430.6751591622, 4213.22791078117, 9242.8208908629, 22465.2316896907, 4622.74479029937, 3431.43805782399, 11331.3242157343, 5575.54091159815, 6293.69224438421, -3535.91465131450, -4553.85886191331, 6785.57577184985, -2878.33425496237, -4764.7099350961, -7046.44569984585, 12395.6361586351, -4667.15657523169, 2742.87802198223, 4864.64331526647, -20929.1221406771, -18518.9739157520, 15232.8229129075, -1770.91311387853, 12487.4166896084, -4025.03740214686, -14702.5196360446, 5740.53907424228, 2713.90377688638, -12616.8550954911, -15601.1441932057,
15688.4689059708, -9050.78447044253, -20976.3447364441, 11519.7289210513, -3806.88670937225, 5013.08278967333, -10438.8581817069, 3939.82872016644, 5849.35392620746, 17458.3351054229, -11617.7843000465, -6507.07653257882, 20460.9962814474, 11463.0779683833, -8641.42377165598, 1388.91245574318, 11942.0306221325, -16297.5201009901, 17330.5365232456, 22512.5055430616, -4478.24032857292, -24739.0724235055, -1520.76391428522, -8653.42817637038, 23337.0427176410, 14793.7931622917, 2464.59619494334, 2729.37950375311, 1515.52581552648, 4467.524982687, -3566.56074139217, 2735.12427976157, -11571.5443901514, -16053.0297542157, 5058.09067048372, -10098.8800388391, -7992.42738955285, -5886.27540099031, 7739.53068853393, 7373.07863429739, 3560.42317386844, -2130.62618005013, 12979.2155227936, 1937.81080382669, -2296.98552347365, 3968.68039502403, 914.343018102512, -22924.3855985897, -21445.3365853774, -5443.00253363421,
-2339.3594995713, -7942.980604843, -12235.560540878, -12862.8644544098, 17347.3803032216, 8125.99335634954, 5659.27571239323, -9172.90189003072, 12488.4545501417, -7664.11114229676, 10895.5763602738, -10160.0555771796, 6389.32651277644, 6016.21310250928, 8349.52605316369, -4601.30087151770, 8966.1975971903, 7727.83090954106, 25158.1512784427, -2826.10990895078, 2199.33765831678, -5220.34112871121, 6448.74832872305, -9761.95602070466, 18134.1897168855, -1330.37616702836, 22764.7717975817, 1635.03318550069, 10036.9648980134, -9058.63325081233, 9814.90072201002, -2172.06830355933, 646.698115738045, 10177.2287870949, 1838.06321366529, -4234.65651972841, -1743.35763175525, -19877.7492267636, -6170.67417652084, -11625.6475068775, 8310.4128755642, 12985.4218616191, 26171.4919666103, 6582.94189358222, 11325.4828573386, 4843.29699688264, -6774.64402405598, 30096.0405129824, -18168.214375696, -8681.22136303931,
-8382.154745327, -6361.12871923819, -2642.20160044395, 14217.6043858376, 9481.800972982, -499.446213391707, 15084.9745527882, -3747.5469279073, 2660.82517625666, 13242.740944466, 1988.33517290742, -775.45117287642, 8267.06938578735, -5081.09894112288, 3707.34219981031, 4113.93515857202, -476.378328615873, 15885.8836889151, -14825.8665612571, 4162.92511246065, -3857.57156821044, -5856.33612430699, -16257.4985701924, -1393.08567157419, 3185.43487227262, 4569.48495810427, -12239.3336777105, -349.145736093723, 6852.29904394688, 195.141058029168, 30.9072356160740, -3200.10552234029, 574.701341355785, -21276.6277143625, 9669.30001637568, 4209.39950059855, 9146.49917870333, -3790.32423714415, -2675.67987916167, 2852.79480456229, 8834.41701288647, -9719.81590382286, 26023.0037800933, 7828.4462417386, -17428.5848586873, -7010.85843974959, -4767.38970717493, 11594.9041298532, -8188.64767259435, -385.267683853602,
-10734.7227140366, -965.974139359387, -15115.7110943000, -13830.5211588684, 6469.30001713564, -5098.23930200337, -3911.2066056486, -11537.4753862859, 4916.74728172073, -4578.60652243515, -8160.19090747427, -4247.83300041832, 6796.67064179395, -2331.23852626966, -1452.23291060948, 8315.51792217513, -14299.7240104371, 8891.47580444454, 32018.865485044, 3275.45308838208, -10128.1583604814, -8767.01286501251, -7538.97292871356, 19846.4347007809, -12384.3040597742, 2186.36362916592, -11119.2434402000, 10986.0952181548, -2783.16361032254, -1016.76298723965, 9658.78968050625, 1616.71406372482, -3306.12779227756, 5290.0114543527, 2299.5528803551, -7812.42724628173, -4100.21350090574, 11211.8629269798, 10274.3054034862, -9154.71903861894, 5103.74087269409, 8733.43326349252, 10516.6267333610, 12087.0187471928, -3688.43387290923, 4736.23865762245, -608.999760976708, -7949.21892521911, 3569.20403493761, -750.532976228211,
8329.19477808897, -7282.91391722517, 10203.0392450148, 7402.86096732243, 4499.10636947552, 9150.29115133719, -9324.7425535115, -10964.8487261021, -20848.2269875718, -12237.8951091888, 5894.07391908006, -4506.7503349767, 5780.27926296393, 7716.12624168089, -4932.50615244614, 9181.86525220139, 1523.80992530131, -9263.48928466346, -9240.48855318897, -10803.5282787791, 6665.29301830174, -21664.8652172958, 2940.96449743122, 3207.37977768196, -1421.84374759353, 19029.3856384477, 6845.43660267141, -1016.41593312946, 8642.93457238017, -2160.76644758380, 9114.87849567085, 22926.5516232084, -3901.83088606116, -1000.33212325758, -19527.8969417946, 3037.7966017527, 1258.36297053107, 8369.69294968728, 5098.03314728668, 3119.58395190397, -7031.04315192316, 25257.7936964786, 2271.21284105929, -273.569965139325, -2934.97316927042, 5434.48302111705, 5433.83544246333, -30393.8089053133, -1937.09689601355, -1962.36300996866,
1332.46572950018, 2297.38153713431, 12434.0307094456, 3958.17823923535, 4634.28408076968, -3413.81599761019, 3357.38224088576, 3102.94649098358, 832.205986683457, -3308.0378065476, 1334.43705472089, -6816.86244068524, 21056.3850551603, 5769.49301332013, 16086.0673400696, 8727.52079010175, -673.020534543354, 4916.96927517003, 11204.2872610592, 1234.30432416664, 2822.76100841703, 14088.3366974754, 8787.5088254636, -5002.29993420177, 19261.0578362573, -3786.20880757285, -9157.70442986647, -845.558598833359, -7104.80969516455, 1540.66905250714, 6718.90188094325, -17865.0062102084, -2550.61854475230, -10438.6766640418, -12003.3470456748, 10111.9458210409, 12804.5971376955, -1241.03310029735, 3827.68934493899, -6581.64714102469, 21481.1600300664, -15439.2818421905, -9019.75060451238, 10399.3166717434, -3783.11595434844, -16701.0572313137, -12897.0247736305, 9453.9331363776, 13289.1056272308, 16897.5014411167,
-3437.90340328047, -15198.8946425669, -10873.8908263870, 6338.02619958787, -922.046665554167, 13312.5325456611, -12031.9970167405, 12501.2053654130, 5513.60923635455, 10509.0001218889, -2295.44561374777, 24004.4155430521, 2739.28710262259, -3665.99107296991, 8075.64906223118, -17896.0011383455, -737.874109066905, -3089.49733629217, 9100.91006760448, -3407.22742222544, 1762.20879223133, 14903.6019843227, -5359.37199824248, 988.275291927005, -7685.31096726442, -15995.2857969334, 5837.9401380596, -2556.28020521936, 8223.68412147613, -15984.2569623874, 1594.16901333561, 5352.48530928692, 3079.31209477985, 2150.42486043398, 1679.86512075659, 8604.05694380534, -2451.44323389697, -10760.7968418589, 5001.83617297657, 3680.45362644461, -2973.63781368101, -12615.1097485595, 2203.82350172657, -1696.18785516569, 16047.7572622753, -8834.71390043259, 2666.28480650753, -79.5651983459897, 1076.14777006042, 1398.1626146692,
24564.7738587259, -2075.06795334178, 2450.51768328869, -10043.5970179776, -9064.43985340359, 116.665045458613, -5808.1149164718, 9821.20355783381, -3532.52913290783, -9175.10902533637, 5158.56781375831, 7217.64652714136, -777.275956200249, -6377.32198520371, 21155.2679749916, 655.591766637272, -13165.3664198440, 6780.63088140039, -21386.7733812541, 6447.58570138883, -17342.9327207286, -11508.3708521522, 15821.8713196270, 10075.8162534947, -6300.23304034984, -15560.7248435414, -8091.64437383075, 12211.8610548379, 81.4298175374506, -3674.08724205144, -1356.83546920585, -282.496428592228, -3148.20168271974, 4584.70214807421, 14915.2074165675, -10636.0154184027, 371.291581239402, 16504.1330201755, -10094.4678342254, 1475.02370862728, -3743.30252493972, 4939.46758558375, -4535.08943987404, 10189.766490127, 4905.95697960591, -11860.0834584132, 5791.3840441046, 16397.6181530108, 2655.21863954482, -4613.90611335118,
14374.7779965781, -2121.76363721618, 12302.9326223675, -3275.95289458159, 1450.79249429552, 5770.89482533472, -11461.0724806099, -7597.90152993072, -14673.6040052345, -12918.1336694401, 6312.95352047767, -8639.98635814912, -11698.4182473592, 3111.37307340298, 9302.36870317086, -2807.87985010687, 6491.13510635404, 25949.2811230247, 5285.00258513191, 12362.6386236943, 2935.82532837678, -780.611967092762, -460.217374179147, -1624.10516050929, 8372.97043675193, 2735.18786866919, -2794.44005920913, -3116.73284577985, -3344.22759939557, 5833.52279755257, 2834.6219658695, -663.785138107979, -8949.41826367715, 14259.9322492688, 6368.7814594128, 15590.7788998868, -2093.12756534005, 3198.15873135748, -1331.90532581814, 2329.72540505164, -6075.73517047332, 9245.45334480515, -3158.05151879958, -9894.72256043087, -2484.82095717642, -10132.3317852207, -9540.41653528937, -7160.44321834201, -9657.32715048552, 3336.64714762912,
7348.79081436387, -5455.78250535974, 11060.4780671429, 4318.0344673306, 5311.82345725708, 1757.59455415222, -9270.41461676699, 6862.99953392814, -32197.2218694961, -9864.1152729741, -6313.46329228814, 1494.64776810514, -21605.5269323666, -5131.3981193525, -4740.724377092, -16004.8808023164, -2629.10170914597, 8112.8852513844, 11285.6294364595, -1299.99319390602, 3582.02094746262, -2908.15543718768, -22647.4214155469, 710.679649550066, -17854.3066506625, -2110.81903926631, 1056.47405107052, -1069.67847131832, 4520.99225697842, -9769.8249303585, 5224.04419094937, -1442.79754940020, 2867.06751206281, 3678.46460721311, -10021.2323039383, 6381.62517762395, 4665.31103540778, 13709.0329241385, -2036.11794828193, -2190.03476224205, 7657.89353343485, -2414.17041131950, -5616.33603528233, 8210.75009034523, -1053.91306529258, -20168.7546998194, -1050.90820212520, 1294.79708698366, 2489.584596971, 3312.98486723494,
8759.16409065358, -9885.53459929984, 3540.95260175048, -2980.11045527994, 2599.00206435107, -22900.4688462083, 4330.29146438233, 1328.09416697586, -4758.72572399564, -5900.48375514442, -892.43632109162, 12431.3136496926, -20008.8567579670, 2839.42230446179, 80.3008029773396, 4662.46989941452, 18066.6949239028, 15634.8444680223, -19497.8283336322, -8454.69214310817, -9523.95202957394, 7517.64877899688, 4862.03927939575, -14469.6893300380, -12518.6942698095, 4286.12933981304, -13968.9619344556, -376.370866921531, -2504.13086620723, -1064.87515690177, 806.574268078193, 11055.3806631760, -7085.42584654678, -8294.55206451706, 725.198434265978, 5872.36474892696, 21307.9066680794, -4300.80433271691, -1151.70552527538, -10657.9772776398, 12298.3853250818, 11022.975147271, -16461.5789488243, 10091.5116927097, 5448.10120377598, 568.08190938961, 10028.3594318967, -2.1104870033397, -2592.92198874359, -17245.3776414125,
1408.44289598372, 8782.1845714968, -6432.08133052588, -162.896596671465, -14963.4385123422, 3202.32680949118, 2445.63263154179, 5295.22471457304, -9996.60370742597, 9860.61990362874, 1184.14662868531, 3755.60331409585, -7027.82476882124, 6060.62438649082, 1214.00492624616, 1849.82456718816, 5673.1005475786, -11257.7188590048, -7600.16789198027, 6061.17431027172, 4678.87023616372, -11922.7151768079, 7210.93623981605, 3267.86352345176, -6976.99225196774, -15175.1097899923, 8464.15214924942, -2790.92180448566, 11498.5585347595, 14701.4580378933, -24889.1788917294, -2555.16993123844, -14534.5213725461, 3516.77441563435, 16742.2932659679, 2779.35616356943, -246.373145052807, 5825.11528089748, 6516.84943448525, -6405.91800158337, 1461.47333603424, -6553.14953240108, 8525.97256965415, -1101.37937774824, 3806.09336142238, -1078.16806954923, -2152.43804602276, 5514.7976916849, 3941.21075039588, 7118.97202065454,
7957.13923769203, 3274.97658242542, -5976.02800397169, -8103.1991005134, -8551.92042662971, 5372.51664728311, -1132.14170464660, -1002.92136623372, -5795.60621164288, -11440.9563277108, -9615.30018063736, -11689.6902370663, -7696.36619471512, -11132.9878069202, 20753.5332238369, -5882.29314585498, 10259.54066259, 9033.89256627678, 13179.9194951845, 1278.28365468782, -18839.5299252571, 7112.7959149018, -6059.20818982168, -4319.72326313722, -2169.9048287173, -9898.5215286492, -728.119098061599, -5071.73210903969, 14289.6621625319, -1299.64834913043, 2824.36549080579, 12658.4397572540, -29735.5584726741, 9052.52832867524, 19017.6955114104, 16576.6257279493, 3778.68551973954, -9709.30855408648, -8054.24630212912, 10909.6548621479, 3261.34398967672, 7381.22390300277, 6588.69305019734, 8766.81781965085, -7016.6298349586, -22186.6284415711, -11925.9155666769, 18731.6522273720, -7750.94498176761, 609.071113073338,
12298.0512943676, 13455.9570395703, -406.918688154961, 5171.64216790581, -7308.50911673492, 11300.1479239411, 4579.30974591655, -2836.88249890232, 1401.12708463360, 17698.1548592952, 3587.89094476384, -10364.0318801353, -761.262371696815, 11278.9142717977, -11598.5922335537, 15753.0853518553, -20925.5302855426, 13180.3353345072, -0.629615038354308, -4481.27966237191, 13399.6350487033, -21573.4207313441, 22486.7117661463, -17355.8456598287, -7789.44241588174, -6953.49801525617, 6735.11675618276, 7300.99117247437, -2905.00849345486, -220.234411454211, 3668.03264134414, 14197.6628224985, 8740.13022561725, 7278.71264282569, -6629.74167508417, -15013.5243948368, -2490.08949252284, 5922.06132513731, 8584.45077891257, 4617.19734137099, 1037.02570535959, 3022.76674815107, -14109.5046468779, -1234.13021302798, -7314.56941042713, 6916.16062326221, 12477.6329962114, -2200.46085106934, -4133.89195561617, -11184.7629032705,
-1334.31244661455, 6540.27035965774, -3630.96936953556, 2710.95213371643, -8261.0721260759, -297.478319512604, 22499.4508828467, -6549.46266346478, 16174.2018893917, 741.153655221452, -4081.32233050196, -17272.3116833150, -2332.50239543994, -13543.7797069792, -8369.9075504021, 3034.10189117123, -13137.0591381390, 21605.7080310494, 436.433050426716, -77.3334662374863, 15536.7556813893, -11373.0316453630, 2005.18982498744, 11775.8667829385, -330.255603389848, -13422.7532190934, 12555.3388721678, -5487.5905480454, 17819.6635523547, 1256.90491563481, -8913.046482179, 8972.65890994906, -5641.87664592103, 7560.57044017331, 7536.19471156112, 9694.71092853633, -4671.12560516711, 8298.45913949278, -15548.0429305018, -9319.40625398471, -882.306994941436, -20421.0723889914, -3164.1582526466, -21075.6730725161, 15434.4670233829, -5149.60300991419, -1723.91939850781, 2970.50744900321, 360.810237030275, 18083.2939139972,
5340.50609123777, 12547.5712090586, 11076.8931954321, 1605.54067810081, 18856.1778079073, -12966.5141507661, 3302.54255469743, -1159.65970452220, -14070.2835373608, -25091.6162450751, 8318.70328447604, 224.482994292723, 14322.7302264053, 13706.2755644683, 20231.2466667602, 13291.2072824806, 16505.8046642899, -12581.5033397702, -5975.35698881844, -3658.79556457886, 10503.4055601811, -7915.83942573386, -1874.86035132681, 1434.99709686340, -892.224907514519, 4737.12948439488, -3074.97633573025, -18717.7118895514, 4188.43932208477, -9911.79652888577, 340.733654580441, 3207.36361518162, 477.617457914147, 10965.7086504209, 3902.37060139673, -6860.56937710634, 391.713044998223, -2216.14593974948, -1779.30687055153, -3201.34944990274, 11299.2501925413, -3572.28232961092, 206.759639494766, -5790.01659573925, 1446.33006186453, 25354.2020290693, -8767.09257679007, 5914.9178618916, -1300.98354194517, -5705.05939219907,
2571.56169458065, 2375.48569508133, -10250.0688060331, 10674.3299626671, -3445.55716166821, -4400.76147291829, 10036.4941050590, -8053.99753985213, -6540.0046175913, 2689.05442645629, 1296.35634159831, -7549.56339969035, 6020.49023988468, 6613.207423864, -3473.56690750845, 9559.34757907365, -5379.24747449882, -13845.5496202140, -17700.7616025158, -4776.14521924333, 874.709118523304, 8447.80127899809, 5344.09849664679, -2200.90555427225, 3276.54736738338, -2922.83227226481, 9722.22626700043, 1369.24379533674, 3005.73236301317, 6259.05194973603, -5134.66375480376, -8367.00382863428, -1290.63825262297, 13825.0515740548, 15345.4244405023, 11761.3411115763, -5636.504105487, -2057.86239172429, 7572.99445106909, 13609.4532840710, -2284.71519754754, -7151.46150985693, 5834.97412223876, 17666.2102011527, -4349.38563931955, 8502.12994842052, 8225.80454245704, 1577.07996623212, 12206.7236380030, -7624.17034982978,
17394.5282154758, -18660.4884348156, 6523.24246618719, 4241.14804994987, -12554.5814394878, -8196.95876410751, 3620.42412804126, 9492.40625062049, -1420.52361937290, 16616.0781541368, -10790.0180555875, 13400.4226904208, 19905.9364512552, -1912.96434856765, 11237.1966973195, 12476.6995798691, -8419.40148418557, 29543.7186774575, 4062.10752806934, 12513.2463553329, 6265.50784823614, 11026.1210605009, 4246.37688156087, -9876.54807481653, 361.685700389729, 3654.64855992458, 2414.46426286116, -8986.62101247373, 15088.7041897523, -233.842274083266, 1301.99919048554, 13477.2244389297, 478.335855847366, -4444.73746960155, 13886.7311217322, 6090.48625612187, -8146.79566971167, -11342.1231648716, 14422.6170170118, 14605.3409792938, 2364.69496082028, 14767.7543601637, -7945.12892677062, 9269.16762443798, 4426.65974880984, -7900.28597323907, -776.036199080848, 7978.77605582009, 3770.19879572997, -3222.71768715377,
-8238.18288183001, -216.284980090429, 7291.96906063515, -10057.1314082890, 18710.5788053903, -15936.1168345813, 4963.47031746002, -23899.8612810232, -7601.82584065442, -6169.6264579, 4505.26299508888, -10227.8847837682, -7611.80839981728, -4466.2607616239, 10556.4527499309, -12952.5988230902, -17002.3540293043, 15884.2630712396, -3332.32744988624, 3105.38102432696, 2952.94118107348, 7130.21151188432, 22005.3622592493, 1219.11436712381, 13918.7629958614, -4886.63114389677, 3191.87339979484, 15720.7391771403, -19823.4379787204, -200.408414020116, 958.695334403445, -18021.7149579041, 8621.15698882847, 9614.01667353822, 7785.3606793938, 8372.38404166333, -25091.9714650131, -2247.27090492773, 4264.98980826755, -3749.36470370589, 2752.65244332574, 3924.99680810817, 14898.509165717, -11070.9003865487, -6999.75690772483, 18048.2033836886, -7645.48820047045, 4066.68956029014, 4252.14102874874, -2839.80776695304,
1402.14651072666, -211.233032301259, 10040.1936872854, -1509.7714475296, 17722.6136406511, 3636.59504012589, -13284.1910196530, 15962.9717339718, -13652.2981452095, 2775.07873051824, 7111.84501852032, 4129.94553132172, -3521.96393535587, 9550.39873938631, -4185.54998496641, -6629.70934079752, 21621.8586190150, -5804.15639798272, -1294.96920374981, 1023.52495111036, -6061.07255463984, 6834.477551394, -3631.5674353929, 6993.18204770781, -10670.6301160822, 10452.3578810841, -7997.70037861774, -10001.2310188278, 9388.14279749837, 2550.63607186423, -1657.20461582087, -5028.13019046408, -9708.6905198419, 5640.38204424633, -411.204959911389, 3647.11724833411, -563.877829422916, -18651.1314772002, -5190.61843218038, 13639.6228392462, -5248.6056299238, 15775.1362152160, 7504.88554248953, 9348.64115187753, -3012.26830749360, -6128.53533448637, -2527.90104862330, 7741.30459924865, -4099.33283693431, 2964.92554659359,
-1093.18544870211, 10289.9376007964, -7512.49941223127, -15318.3143875477, 4145.80329284592, -7331.62174750463, -1389.00160703773, 20626.6949717778, -15543.6457497873, -14370.8139415015, 4680.65784301271, -3808.91833550447, 10990.9286318541, -8013.64450142558, -3377.40284564387, 15121.8950516891, 5693.06986334379, -19175.8904262266, 5334.82946420261, 8046.76960327969, 21.5924381039454, -13406.7973172010, -14097.9805608691, 16800.0256640516, 8595.45549142406, 7475.62284549507, -11420.8484192942, -3040.14835439188, 21143.5418979607, 7344.88750441672, -1197.72043991283, 17907.3612496870, -5404.28581583334, -18293.1853808379, 9868.46639067002, -5557.68728692184, 5155.02075956379, 18826.1226646256, -14140.7347968519, 7422.16483489343, 6291.73762777326, -6969.3561547115, 13075.3646323839, -4884.84370852641, 17193.1845195976, 6520.1473224242, 3274.12175508825, -10295.4422075402, -10892.2190833722, 970.146905596133,
-4791.2962978966, -20869.4655573679, -8597.96036336491, 11167.6608150207, 5056.46494699153, -12017.7971431120, -5473.1467532724, 6695.29697282063, -7943.69982089992, 10396.5750899132, -10260.4377055042, -2877.52433239381, 7778.17932195165, 17350.2454531490, 23063.651372909, -814.14306573847, 9288.78589926647, -2080.9055368762, 4122.11775077987, 743.352465268036, -7547.81524801371, 655.625391399961, -13025.6120670887, -2077.75289541995, 13229.6837891537, -24180.4702212527, -12028.2618597866, -4225.26731936786, 10696.9812964429, -3633.85054281383, 2222.32335690944, -265.275842173738, -7497.08120977134, -1251.08967340841, -15099.9047344733, -239.440787268309, -7702.41910705304, -3085.89115527075, 8500.5757491657, 9416.71251359534, 3766.34573816448, -12059.5356434256, -1460.42947354032, 11174.0449908952, 4850.31543859503, 840.126966087189, -1299.12586899751, 12144.4110779495, -8960.06390628002, -18232.7492579533,
5451.42762062874, 11339.4188966078, 4450.98220118550, -14664.1101664399, -22588.0562044254, -8782.11079367878, -1996.09131130431, 3851.30486578908, -4140.25702320187, 6756.83607909454, 15467.5666805891, 2055.06632525211, 3683.81496668765, 10536.8165737604, -25392.1842591163, 4652.39366119599, -598.420135003948, -6731.2412521569, -7781.49835147643, -6374.23018311761, 14083.7236429183, -12447.8543672218, -5829.3335814064, 6579.03218105743, -870.55817121321, 14952.6999962986, 2728.74517915537, -654.399797082746, 4853.99402874224, -9091.59742338493, 1768.84765026235, 1865.85813054162, -1384.59335448703, -10732.3047859749, -5545.67632187801, 7617.77356786575, -13594.2951174736, 7930.01103885239, -6683.41219527163, -6288.22045453894, -11269.1839918449, 11670.6022631706, 3301.64599319464, 5400.27805470533, 3126.59035227067, 4176.061143704, -1851.57819102858, 7187.67007137446, -1444.17489105574, 2786.73605543451,
6149.14464686487, 2919.20414707069, 2646.03241745896, -12970.3087016556, -3921.11602095744, -4709.59762684048, 52.4028379108259, 7406.36034533427, -4910.96845351053, 7846.6563782129, 4797.77380993568, 13527.3252596006, 26940.1481097399, -4056.33821063643, 8273.58963147657, -14575.9424040589, -4366.21833979145, -3712.44439024236, 696.492046633223, -3427.82902496586, 10979.5793803648, 199.984437379812, -14347.0114899594, -6093.3048878094, 7400.68773044884, 12474.1850870948, -12625.5020964697, -7407.7112403296, -10825.6565353261, -7787.00549724846, 8966.65952544392, -5379.48917379143, 25493.8557070440, 3582.72172852261, 4400.6643267335, -2158.40118384991, -13067.6829206014, 362.036738628932, -11982.8957381894, -5076.70730436192, -5379.89108178757, 20816.9069903138, -11985.2235672407, -1352.58193356004, -11566.6273526779, 740.206663671062, -3613.65156816817, 17669.0831459186, -17260.5920856405, -26750.9510485574,
870.173360171281, 6960.30456499343, 18458.1615580830, -7366.9321454719, -4722.74833517248, -1764.50143951859, 9424.79830706902, 235.381411084355, 3115.76232262189, 11382.2273254489, 6121.98024479014, 6764.93211292946, -25234.6826085369, -3986.24086616985, 959.73221273119, 11172.1466495437, 6916.83386068587, 7233.22965266813, 15198.3612638218, -12403.5709924817, -20996.2493663083, -4909.97267925864, 10264.5836035706, 3834.19645414586, 6654.95206436396, -4635.28551225581, 6285.83245378119, 11291.2519809487, 7153.32039748838, -3873.53336036949, -1355.21872363814, -2840.14383810365, 13335.5170943876, -21223.7169996582, -3997.03231649216, 7673.43076160664, -4130.64308341973, -16618.8887889726, -5354.08334368258, 3538.38357797204, 10788.9589429336, -9785.93336171476, -3579.33436805972, 7490.91819725297, -15312.4965976145, 3132.29795744269, -2425.58669182686, -4871.20345715674, 9423.32272828046, 8115.40171156318,
-1585.81072956663, 1050.26449268737, -310.589893549741, 16532.1747491741, -26292.0145763335, -6781.47560304824, 6798.83472952854, 4042.36891582918, 4952.61952294971, -588.264188061927, 13508.7889892979, -12619.6451597910, 9206.2473949106, -1509.68353959869, -9457.03140132092, 12400.8196468633, -2839.18425341581, 5961.01681690717, -13251.1972623259, -3229.77051888078, -9327.47334120202, 13828.5272388422, 3616.36189701715, 9177.0293946986, 7674.0376060299, -6744.53219835702, -9004.95915875847, -18422.5358914789, -16704.9944526976, -1815.11096532622, 1868.20001552393, -2141.70004469546, -17835.8300326774, -16641.6433327883, -12383.3097290207, -1283.16055456134, -13460.6364277222, -3474.62821263067, 21534.1536219111, 3257.37145870596, 3715.08273100413, 13255.7006440326, -21249.8999749144, 3210.67096633696, -15884.1429091165, -14860.5421508606, -12047.7351130902, -10048.3381935575, 13911.4123238399, 2307.62689906430,
-2867.25201120895, 5537.49197006231, -1165.86406013457, 923.955679919836, -8278.30265993827, -6878.30867709288, 2149.33423092754, 8509.26508816816, -2115.63150143023, 6391.94491327279, 3980.92031527272, 12179.0380487818, 14191.2439941056, 9916.45847303672, -6793.72863531957, 12826.0149137418, 6801.21106469022, -9106.85388141205, 12007.4644664021, -8785.67778825209, 9228.01225168307, -1195.16311983343, -8693.4083021153, -16872.8154650196, -2089.02206644329, 4058.25481168462, 2844.69954188631, -23434.2694640531, -172.906336626072, -369.411445685802, 14393.5241630838, -14728.4099910038, 5183.27968203086, 6923.91690562966, -2798.53189739542, 19024.6009740052, -2811.79459641138, -13971.6997495657, 9452.9897618083, -22771.8703040054, 2462.21954975830, 278.832408861206, 950.855323756221, -1113.61413280157, -8303.34688745993, 11764.3205174715, -9324.24060551505, 19730.2123997418, 5778.72105318111, -10774.6969903570,
8122.59942031461, 1036.64989533697, -1841.31795601375, -6468.71072445937, 1144.95386851747, -6898.35120562062, -6522.65483305367, -1922.90144612318, -11868.6665109465, 3628.05229900272, 18109.3487024763, -2724.38335518756, -9264.86670665884, 6152.8739280167, 15303.8511709092, 19408.7587142275, 9078.09225372883, 10184.6710177425, 2738.13524251607, -21581.4318074948, -8346.9578835662, -5597.96992421553, 646.111278255467, -4727.57464366776, 20985.0505856699, 793.12026463303, 2648.93949795153, -7914.99497608689, 11335.8570200965, 18348.6568520131, -346.784277777162, 6435.01499044879, 7524.22990274229, -10240.3551352806, 5952.47573564111, 18128.5538057114, -2233.80597926249, 14352.9435232728, -9500.02738878344, 736.845655412494, -9310.01024772141, -836.593377986239, -8700.82740575313, -21575.977609518, 3871.24272683304, -9019.8075682113, -1915.84288471572, -2057.3417794461, -1479.22026736405, 13254.7650711076,
14680.6889827044, 12414.8124989749, -22141.8474966610, 12685.9277094182, 17998.3991383143, -6745.47729086409, -12953.6514959078, -9152.45461753173, 5554.39050586149, -16382.4999109415, -5207.24612621083, 6262.70501150022, 6341.84570824446, 3491.46299895382, 5670.14277610517, -7909.33162255962, 2242.81658286686, 5173.31179663535, 3148.33578857185, -9965.08379776903, -5388.90326017284, 1954.05432836792, -11165.2731445241, 21797.2053522149, -3706.74027828368, 784.353695324618, -4637.58852590151, -8971.89230282781, 6781.17277414046, 19386.9380528009, -188.525466762222, -1987.42243590713, 13729.0394938931, -6837.83673487973, 6265.01421678353, -13144.5184896155, -16994.1682487154, -15485.4496848270, -2871.72006216287, 8615.64570463846, -10306.7483616882, 969.845797026834, -13652.1335716891, -6934.84701632713, 10448.9809362869, -2993.99817924643, 10069.4184961968, 25532.9160559845, -20875.4894659869, 1614.55195116881,
-8707.06012631616, -2455.80291500762, -1424.40090769177, -5182.89295416087, 11611.1987966678, -1424.34097199963, -2033.02253896361, -18622.3664297760, 1399.76291547982, -8657.93135073558, -1694.55196248983, 12751.2507682732, 1607.84624282931, 15983.4317626514, -5134.30110202185, -464.590311282627, 6769.0487407279, 9309.04709938363, 3804.91523940686, -4435.11492214255, 9449.80413850764, -10285.2741847586, 5909.0193188647, -11357.9590602495, -4551.49204051461, -4378.01713465494, -13877.7723511645, 31763.1894629222, -2988.57105168547, 973.96483459746, -13178.1444256398, -3630.52934173025, -10210.1806363129, -1447.47668294138, 9786.05058683501, -9320.98422889968, 12422.9032839947, -3295.4592496302, -6429.76435200846, 10705.0615632126, -10194.3193048688, -2911.74843827469, -5948.20285357157, -4438.02674199079, 12428.2475523011, -1784.31406814076, -7730.54806177523, 17550.8441638723, 10307.5300929407, -19080.2453747755,
-13573.1416768268, 8269.0781818255, -25158.3184615304, -1477.79595426449, 13817.5762648757, -9305.82463186206, 13371.3996542715, 5125.2689246578, -10302.8819612115, -1023.53029404331, 1932.3846936649, -1314.42163551838, 3956.89446113356, -12624.8313018058, 6045.83685827672, 4894.24205980846, -1915.51333118174, -19198.3778348153, 16326.793732061, -5732.31880042781, 4627.78598945078, -2858.24430206945, -3112.15922203257, 6902.44421934362, -11584.3685420523, 2527.81101200979, 6628.67557469404, 15113.836219234, -13671.4742625129, 2161.90050274806, -15439.3937312868, 3652.50931517573, 3654.78230994856, 11253.1212507671, 794.346275942446, 3235.30124362069, 17285.8627156981, 5127.24817795974, 4580.70121511968, 29901.1659522169, 4159.18600478486, 14153.6799118850, -7735.74978026204, -4009.07976866637, 1365.02242144469, 5592.52091463591, 25799.2665741855, -19521.9942727036, 6900.0564550659, 926.55709078037,
9680.8531844459, -9019.2552450294, -21488.2009698305, -17459.2360100109, 5254.23293070175, 8991.87686687666, -23131.0444633735, -8049.96636473338, 8161.48899759514, 123.674819913845, 21700.6069335059, 9404.38617085524, 15476.7230154925, 6460.78218282586, -1750.21585133108, 5557.51792975371, 19078.5679404864, -14009.6762053869, 635.004767640901, -9208.88231309226, 1052.84438750167, 13498.5070079300, 6041.27560041442, -2469.66501088662, -6832.17181610464, -2849.83999629242, -8856.27565868422, 13623.3472595605, -13327.1077545446, -7866.39456056121, -6432.00913457451, -9719.76253121295, -8202.77117068419, -3608.13233693183, -9620.95790974833, -4040.36000941892, -19522.6966579922, 12773.2259613075, -12018.2432339404, 7483.3540278847, 6649.64771884623, 15061.5421378227, 17622.3654984312, -7707.96756012519, 6918.39617948634, 3123.44209113208, -920.989781200711, 20988.1070758586, 542.194214829813, 2495.49701578823,
-8108.7761714134, 5051.29612350411, -10313.4064399417, 40.0573568716957, 18925.6624848960, 7214.55674919538, 13449.6346068075, -1257.42746420855, 1339.16146617833, 3505.57739364257, -1832.37536695732, -4278.23779796568, 1235.08368875852, 10116.0847839834, 2755.35615672383, -3095.01415301939, 6114.70447644131, -18220.8495824216, -3731.65800600948, 17237.5961408082, 14183.4151937203, 5533.72997160350, -20942.0098815219, 8716.44824434553, -3120.57345060258, 880.428158534969, -19093.4899515035, -341.616546327761, -6569.21358747865, -14305.0799598413, 13076.5389061471, 14293.7996295090, -12618.7602398518, -5190.02512052543, 117.014581358396, -7489.59940116474, -685.140285126897, 10577.1622886682, -10623.4864112829, 171.365439249805, 796.231242034616, 5093.79355829099, -1776.93167107657, 9473.51690808323, 6909.282397085, 4082.16692455254, -10181.9836276789, -15795.1364937523, 507.84221968442, 3256.63435050477,
-1903.74363053652, 13464.6659125176, -2588.32476794848, -11126.1522439495, -3953.20464296604, 9578.1189568280, 13405.9300680636, 12309.7324274083, -17529.3472968451, -8992.04379525032, 1378.24319502404, 16403.6566328085, 15081.8475730980, -12010.2683063153, 17369.0976986168, 17958.4219652289, 20199.1646256755, -12519.442878104, -6543.16525944971, 5488.37461961139, 9885.5322467597, -12581.4872819190, 14268.8379132364, -7945.76100577485, 1561.39259054027, 18436.5273838856, 835.585070871726, 13053.4119139609, -13626.3358586076, 1227.98540211022, 19972.4392586773, -4100.58520552532, -8387.503928818, -8012.22097846615, 10679.2352118634, -16389.3693503299, 29377.7520082178, -5672.36225666593, -801.40970371223, -15489.5367387213, -11983.9808745672, -28760.5514306478, -14812.1927598568, -10757.4835168139, -8119.82160673633, 60.5246317676079, -8106.44457938892, -5832.97490605066, 11388.1103000451, 9618.19882513866,
7742.81456562816, 8348.62706726283, 10018.6467666975, -6200.7697068176, -820.427857662738, -19320.0719991882, -7592.47235774002, 2185.83629077375, -1697.24013047498, 19415.5536905080, 1418.07701968731, -12189.112827141, -2257.48879271114, 3424.50131096443, -7479.2051739676, 8351.65867480534, 12588.0270775320, 3017.52841316601, 5849.73259746271, -8914.83949521208, -8314.72600596726, 17465.2555648754, 11309.8056668150, 2694.34941397672, -22020.0031571689, -353.875614770615, 9892.19162029286, 3755.26289432779, -2529.84593187126, 11820.4179686021, -8156.51305387858, -2802.32701525091, 630.16834778829, 10037.4318381748, -2613.00977084047, 465.289632288037, 746.239687670552, -1773.53615235399, 4968.27278675187, 21823.0330752497, 14726.7869245402, 8234.07298212286, -766.257692574966, 818.8348589182, 1797.50768866749, 4672.92760451222, -1984.87138572485, -8927.19860036806, 3231.4273208268, 12793.8727910967,
499.162492953856, -5335.19523285458, -2908.49911386011, -887.265956320791, -8199.33491790568, -4084.62305293396, -8470.15341707081, -21075.8284578880, 4399.75444728105, -17396.7358288171, -2180.51931667469, -524.535616297178, -9539.50930661585, 13259.1398984719, -17238.813279428, 5698.27398114562, 8410.21092278627, 6938.7796398726, -296.65044572318, 3791.55597805729, -3901.54171842998, 9941.39603517978, -6336.09921845875, 22433.1338613820, 4513.89094827974, -4530.77733474143, 11163.6404331812, 25009.8397529595, 15929.6376388094, -88.8040784127595, -8063.83421123788, -7330.13242797338, 9948.3209582328, -3016.19564234377, 13169.9955437807, 16525.1200135765, -7381.32344241621, 2924.64881590523, 1429.20854500588, -6339.42477420784, 14944.7984593981, 15149.2022325133, -13111.5332917088, 5795.83393700226, -2049.80691387713, -12131.7149924829, -16194.7178586218, 3677.97856609905, -15238.0401719970, 7108.91636230562,
-2446.29729537955, 24638.5801913936, -18131.7441359773, 524.210428864929, 8739.56518548069, -6138.68062393817, 880.966340173836, 13968.4617737262, -968.449704532704, 5214.67282970117, 1604.81186056803, 15931.0021727921, 1458.34066366955, -10.7528623443427, 10175.0429731329, -1588.71013054772, 14677.525376797, 5779.26252883833, -7667.86387515334, -23530.7703006624, 8703.13995241938, 5332.8267585551, 1189.19705746717, -8231.1364388531, 9863.33609090578, 485.857632980555, 5727.56314493289, 5498.71471695534, -5677.62305348045, 10901.0735189260, 12960.1422916968, 4238.75058172329, 12931.2200193454, -17571.1021926510, -13716.5317961597, -4317.8018994946, -2952.22286653732, -2161.68999521274, 19.8643032231453, -7867.34517531093, -10511.2738132667, -804.067361753163, -13660.9550800583, -2970.07589350208, -12448.7333045957, 23978.2652817946, -605.003280455481, 2718.39201399908, -1104.13040557954, 3050.08760325941,
14149.981628185, 1813.50759933254, 21464.8080903026, -13936.3904747668, -4016.76632703281, 1453.51333087843, 15389.7866699984, -10810.6478396529, 2697.52248816318, -2618.02796555883, -10134.2795188956, -11153.5322578008, -10006.6034979213, -12227.6778918416, 10396.5845974841, -5090.56589175311, 4039.33349861336, -2738.30902688679, 4048.9840429216, -5652.21561621134, -6991.60038595148, -1305.71245229254, -10318.4726872081, -3944.52715663267, 4640.65541151596, -8371.402919595, -7286.02631447571, 4678.62621018417, -14963.8923569693, -8632.99445469344, 320.172454336261, 3532.660451181, 4358.03004784815, -4939.59650976355, -2484.86898429518, 19930.6825008687, -11898.2656220972, -3476.81485351443, -9365.47115251977, 11053.8594713815, 10678.386218594, 6663.05616030977, 10950.7504362576, 2901.05644204233, 11189.7706996186, 8823.01974648183, 5958.56925556395, 2792.63552725565, 602.549950472156, -29206.2881870094,
-3747.42553807461, 3848.68952961567, -12795.2266021709, -1172.07731555008, -3312.72221058407, 6239.07449786619, -1898.13704905728, 22380.3266238657, -5514.07211578047, 2694.95745960434, 5181.14241207722, 13227.5915280794, 16757.5220223717, -5616.08182176591, 478.231514480881, -6408.3382836002, 14532.0381489016, 15725.4342712646, -3482.83168584695, -18316.0867629972, -6237.95692769941, 7767.21704453006, -12167.8794874429, -2435.38787471398, -3316.17415504247, 21481.3700852766, -12572.1024794261, -1936.28558093938, 6761.02978009964, -293.056234988559, -13093.8545190273, 7273.09753306125, 7666.94201914419, -12091.2000650057, 9200.63361410997, 2092.28484870195, 556.514642563844, 5955.02898644944, 10565.2533305181, -4120.69026235900, -88.3895138487253, -10656.4284223639, -860.016115850172, 3309.35454478037, 9531.45192541075, 7162.02848785316, -13536.2173995466, -5654.35166291688, -16751.8007749922, 10548.2496005528,
5930.86605049723, -10232.963734385, -10500.8077770670, -1119.78485889428, 9929.47189292636, 1222.38816706342, 9321.82150245617, -27621.004284061, -340.280605958103, -12082.3399176575, 18712.1205077998, 18595.1519323452, 24812.0629811865, 6277.78485897626, -5085.08482586716, 11691.5543307902, -1393.14515306988, -8711.44265862037, -15245.0659466197, 530.42064211529, -11393.6210027641, -5946.65362073309, -10273.2542767089, -4280.40179617457, -11228.0907195044, -4010.35664082834, 1152.68719876998, 2220.18114203726, 5723.84493197905, 14773.8796238486, -11890.4504081555, 21292.3421429678, 530.145134992962, 11985.5119394852, 17353.0411394935, -13221.1836458348, -343.813292491449, 26176.5645311217, -25762.2669122369, 10302.9141864910, 9559.39525741, -1689.58369815190, -16780.4415032877, -2159.51837665543, 3563.12122662761, -4553.70617592929, -14788.7522348027, 9581.39729505083, -5783.5339947889, -9156.30644569513,
1352.03838096133, 9825.64829697775, -9490.19598542457, 17017.4606318522, -7901.48218280634, 24975.422392501, -282.076712829217, 16156.7765890383, 15055.2938401572, 13489.8776307939, -4164.61272730232, -12252.324502415, 2482.56333339756, 15002.2461725211, 12814.1638899810, -10143.5812581871, 4123.11003812767, 877.134291163007, 13512.5367253923, -4143.15744226026, -4046.40740554801, -8485.5151837887, 1085.92249920054, 12706.0410426215, -10994.2708187817, 9138.20076702297, 12724.8438812764, -6395.18821501588, 4842.55651615138, 9745.14269955672, -126.456048114338, 2617.35096899981, 3683.14595119968, 11396.5048543729, 9860.2545540414, 6241.89637024964, 2109.4261771271, 10627.8682481365, -5511.61977876198, 19698.8337876911, 1365.51725565072, 1453.97666149543, 11666.2898316780, 5095.01208066219, -23528.7642733546, 11652.2540825845, 6289.70390563242, 2739.89203241301, 12821.1203061877, 277.53562662643,
6178.87710045174, -7290.21275139985, -17206.928573547, 10977.3876029831, 14915.0630264116, 6430.56441252111, 11189.7910985560, 1959.12163655427, 8833.91034676727, -5669.01871868972, -3753.59934262085, 9814.56997174558, -6033.6238034536, 10042.8547244149, -5612.07343245404, 17953.4944773377, -12356.6288364569, -12114.4710108544, -1223.23455212241, -19232.3010274457, 11995.9347475766, 4722.20214010961, -12868.8034609628, 7393.34147043082, 21115.5382763536, -221.89843279481, 141.930785132493, 12061.5702580872, -6432.34288965837, 6068.43816007588, 8664.93484268631, 17302.4940259004, -5095.99168622565, 1720.59371001208, 5516.30037883238, -6254.54566864521, 14299.5162607289, 21356.4634158494, -3015.51431185193, 7728.9567282121, -9081.05406035526, -3287.48836441931, 9129.54812293533, -9317.28985694054, -1663.88312018078, -1953.42438351675, 6629.76224637274, 8337.24535509002, 548.119156642188, 1356.98700876843,
19616.0335714434, -1598.42345981719, 8215.31013233977, -5885.4724402281, -3058.69280032529, 15933.3297118756, 12591.9599111168, -1817.50428857891, 14331.1995174765, 18294.0571661354, 8326.7814641654, 8417.89541019886, 5815.80401674772, -30232.3422252395, 3228.64544528975, -3119.62204582133, 8872.11318658863, 8927.21084456249, -7967.20308162453, 622.073299616128, 4344.62619720144, 5473.71070787955, -1378.99254040802, 13948.8345045135, -15013.7441063496, 11026.8269941341, 7221.6490156492, 5095.61060659492, -5569.99177049253, -4002.60215259715, -3668.19819863878, -11820.0724216493, 8689.53380382167, -9005.2112540301, -11633.8680558700, -6057.32538953058, -12146.8501180463, 15147.6167315753, -19373.6566476015, 22377.9639292447, -199.604002534101, -6518.85785913235, -3652.35979095755, -2174.99382751408, -9941.51480993802, 17406.1264455278, -6865.15068262363, -681.643488924807, 15553.5483735042, -12300.8886987527,
19297.1219826014, 1525.34870245464, 8146.86381006694, -10811.5263175077, -3552.79105149626, -3437.44836553505, 22878.4459844581, 2529.63420407902, 240.829183856598, 1534.61385807804, 5497.10485346407, 10555.9147688131, 11047.9413114377, 2185.05164045392, -821.362932984686, -1037.99083837386, 873.83041817599, 11448.2791495514, 357.885169789797, -14108.0454576156, -14314.645010039, 18120.1679259895, -3836.93419070033, -8040.57561129296, -10656.3872750737, -8336.06193175646, 9088.422838918, 3616.12509788648, 16651.779922721, 11430.0112291599, 8360.5124547085, 1818.64260959882, -2790.39462433533, -3813.56085588447, 13122.6111856188, 5866.09659612888, -7149.87772250953, -8700.92010057076, -6809.80533056054, -7558.92058148071, 12810.1244348618, -14497.1705928804, -8997.52884430076, 8585.70512135442, -3558.2978817889, -1268.3862965383, 6681.82366565953, 2489.64510516459, 11035.2717534510, -8896.6890558838,
1596.75298442794, 2571.26964915778, 7628.91023763226, -5661.7301077477, 3835.23833320199, 9176.73712447676, -82.9415468787401, -3112.543781385, 11613.6405832768, -17980.9338784586, 5630.09170255668, 3453.53027457, -2950.36243974644, 25834.6968168648, 6299.35440754674, -208.537958255283, -6976.7959685937, 3740.99381103420, -1157.65677108975, -2386.23830948676, 1162.06315048246, 6278.05383646916, 9115.99173937638, -6307.16648351315, -6630.71186200316, 17941.3076235093, 11634.7200793692, 3937.17753053746, -17476.9623433269, -18175.6133449573, -2954.1401261261, 3266.33010692895, 10681.9619744331, -6287.06488385286, -3229.15702457168, 5110.69327621202, -2327.68515186892, 14814.5140383604, 2234.45569139033, -14516.4842070781, -15247.7317175165, -8720.6495509836, 7792.63334360171, 217.027294446135, 1288.88795015333, 6170.79437290389, 7312.73247977751, -1.02676488586798, 6956.90536219973, 2279.28647736184,
-15407.7556540822, 8004.12710402016, 4838.10612531755, -11204.2094989908, 11526.9847965256, 7085.04474404985, 2838.08786643185, 2904.86497324621, -6817.44156706266, 3883.74360501529, 488.547463468517, 699.748000770016, -2833.29275041196, -7505.77925965498, 2747.54027941363, -8687.57953078989, -9425.15831579333, -5286.80644507134, -8651.59617447997, 5966.3831276732, 8638.14076272292, 3361.22518816628, -2739.55775828961, -5718.97363285607, 6189.32957061673, 14476.5252667979, -13842.2496950959, -2719.31323395984, 24720.3776140758, 333.807416632189, 12639.8118848771, -13896.1848420063, 10128.3552224146, 3827.21646585832, 8820.15487796654, 6887.88723354013, 12282.3530878621, 1662.65886807093, -10992.9790879053, 17992.3858176848, 412.080221757159, -300.118665583263, 2036.36050590423, -22316.9283387168, 18064.344816314, 3185.74655963389, 11681.9023623216, -3576.40393221225, 7337.6029908888, 9884.6132800097,
-547.376596230633, -13632.0251862393, 15031.6843837798, -21372.9595817440, -5144.84490983775, -2294.91751715198, -16227.4752078538, 4885.95713869583, -19164.6363969031, -13343.0188922776, 2779.32132949581, 9334.56160370779, -9461.9418593066, -10643.4191593911, 7678.17350615184, 3113.9199500606, 10425.9662914243, 3106.18873957861, 25680.1171272414, 12124.0322678322, 9582.13586002731, -8831.67638316781, -4285.80220135698, -2068.86534540428, 1940.07351911742, 5692.94983040935, -2124.34053158822, 3751.06968464063, 491.441255919294, -622.005389581128, 21038.4824311250, 7533.91874006232, -2534.89462503908, 15196.9974321333, 9134.59599412813, 6230.0459793877, 6675.63173630276, -1723.15202019016, 1020.99793970373, -3875.79571696216, -1705.05644479415, 6815.52588811758, 3856.78608307620, -6453.31895255843, -9312.48932038034, 4104.35301216396, -504.194592519362, 3285.45661101966, -5094.13056156275, -13059.4006884894,
6387.71896894504, 1174.03077291784, 3348.90257103928, -9075.4277567119, 5386.24347386883, 6153.64005616867, 4051.57870867174, 13479.8979620965, -7076.4566951149, 3281.32447007392, 4140.33118498744, -12646.3857296335, -15103.6650743244, -4343.77364740812, 12957.1511420164, 20706.6005647054, -12554.3966491702, 7252.71147379896, -5887.16898019051, -4177.17599588598, -8141.3397948805, -6837.69310806854, -8054.6567570843, 13445.6870841029, -16540.0296966512, -14750.3187909660, 18.5272653805329, 25.2844692913064, -4359.06954833541, 14792.2641034960, 17219.8910477816, -6191.8340199118, 12434.2866265277, 218.343987385593, -9356.57066588413, -5057.07984096303, -2069.59860014120, 1827.81223212214, 2996.80000772190, 11110.3660783635, 1362.98948589649, -16026.3510387888, 11436.9558537469, -683.269948582214, 1512.30951841797, -533.538228582489, -4661.42777515711, -7353.68977510378, 14569.5381391438, 2835.0340101205,
24102.3380409153, 22539.159073794, -1626.91910053914, 570.976940551568, 6000.63232886786, 9324.29251351043, 7644.70883551903, -8540.74631336772, -16747.2744569160, 21183.2195591192, -88.0485065332465, -1476.47704097697, 1162.44845697916, -12128.4141668030, 8108.70777431862, -7972.75855157866, 5166.93030173073, 12381.4617133338, 790.251320901392, -3776.22114894905, 267.141041443248, 14277.8023966700, 3099.01852017088, -1759.43954778463, -2437.19972032214, 2203.67148438419, -16503.6525978646, 10907.9328249162, 12668.2999311642, 13680.3803855063, 20255.2330005634, 11051.2094379159, 9270.76841592127, 14981.3950231861, 1003.6584906943, 27102.1730506881, -12048.1870644307, 8756.20161575105, -6995.23434445674, -8477.38694510913, 12711.6861401278, -17900.2587773055, -6766.03432516462, 8720.40174149204, -13237.7828805565, -1803.89028246709, -6036.61012787971, 1823.22196007060, -9265.83823074158, -17220.6632835306,
4594.62866986987, -15169.5451787126, -4362.05437016344, 2583.01440454623, 5127.65378562239, 3142.01262674569, 3351.50768795731, 4688.90741371809, 3330.83343819179, -14000.6071589519, -9291.07176594588, 13617.2317120551, 568.203543620507, 11897.8913620738, 4890.2039901981, 2436.22467255119, 7657.67961822862, -8288.41378322289, 14301.1728967365, 8593.32389702003, 3609.68536281701, -16344.6580918691, 5068.83341876966, 19065.4610550503, -4195.82214999446, 2131.72831770264, -3811.27566845937, -12975.5360644592, -3583.91935102744, 20319.2716683428, 10687.110898718, -12362.9209656599, -3291.89921377146, 6747.04780336679, 8671.82295643323, 3441.38916588748, -6860.952896018, -5083.26417624942, 15147.8937588975, 6047.68825459946, 7265.64109361389, 11056.6288490609, 9917.55295039088, 3145.3156707136, -14759.0717907614, 1693.66135751946, -12390.4594209747, 13435.2118718935, 4584.47728628697, -760.395882755086,
7294.48849917043, 11384.5266804831, -17937.8487755861, 3756.76791776286, 10631.2420900374, 2043.69590589162, 11308.3085879061, 13627.8613984081, -1917.10609366101, 1498.18229981858, 2907.63640771586, 112.922875714753, -8194.29049533099, 29.5525445245867, -492.444468321699, 10579.8908345331, 10095.3091241569, 48.7469206219277, 11674.3725060184, 7211.09630401027, 10953.2537150696, 1700.54822715859, -10211.3535250699, -1292.50397157766, 11319.8875955786, -2698.04717268383, 4383.84913505775, -1250.01720978777, 2570.97529082764, -2273.29556830771, -16319.1793716962, 4529.75756201902, -5511.05552374934, -15431.2767000359, -6094.87622791879, -6097.99876565799, 20535.1647602680, 4388.88659763544, -21966.5015843358, -1640.03443754713, 2570.93305795789, -4902.74069399003, -20117.7358062183, 6836.83925149843, 2766.84348104059, 22738.6027728654, -10792.1020875637, -7925.90653490651, -8317.17429129551, -1000.41507224620,
1341.78606311751, 412.553012956788, -3324.95052186621, 4334.7449503077, 10169.3478059893, -7267.41157384354, -13164.31062202, 5321.55556934208, 15356.8087355698, 7388.64321053067, -52.5991811067553, -2099.98422707884, -4475.24632468798, 7558.63518231627, 7836.74002061796, -12179.7007742993, 11677.9871013435, -5462.04811821025, -8759.79938363689, 805.34304905866, -4928.33611315770, 14017.0853404559, 8344.55648124063, 6398.41237322935, -4613.74518630331, 2566.99935325764, -6942.8297595063, -8548.31397061294, -2332.27649687267, 3217.93906304901, 4307.92567586193, -10637.3320468352, -7129.06579547393, -2072.60455284516, 9816.30275506274, -9320.20798695213, -1822.74974943199, -13898.7010928669, -7359.16216948058, -9681.1010131844, 5869.06001421346, 1955.10921019470, 10513.6621697872, -13646.8868779371, -14773.0834752413, -13757.60863241, -3672.00369533503, 10141.8161857139, 9256.03135197002, -13153.1490254070};

double y2[100] = {
59222305.0599619, -60485686.2745677, -3420158.85320719, 48274230.7468772, 26299560.3743166, -35330795.0269971, 49044489.5345209, 49242047.0143661, 82124459.3266337, 76892180.6657918, 30070295.8627113, 82669832.9086654, 88496271.7849554, -87834349.3299173, -76351128.093263, -6301557.21526601, 61657410.0881203, 22388628.7181635, 71836988.2817706, -47445468.7706105, -7128221.87136625, 33898094.1990993, 65898232.2541901, 6003991.388132, -13076115.0017139, 12341031.8297821, 162523651.688945, 55144152.1396195, -90755180.255785, 25224769.991074, -131483692.409564, -104136310.599107, 71492629.3498717, 2360784.37518178, 1899105.51190492, 36314002.4346552, 31031153.8402360, 2217346.63700698, 11270076.4149653, 183930284.60632, 117926290.105005, 59633947.7289459, 68098475.5263067, -94294771.9407073, -137013019.557699, 34843360.1743757, -6148908.83790408, -20304726.8008089, 10588486.3965331, 216670363.89637, -2978299.46423691, 16629509.3092496, -45080901.9134796, 73030152.5568353, 12653209.3691734, 32265514.1003408, 69546573.7218128, -31616307.211227, 32167890.9981638, -31050867.8058777, 207445163.075712, 111481489.700574, 7874515.57252855, 114534427.094726, -44442539.2070899, 138345859.254424, 9737455.3578135, 1271488.00407608, -54745203.6934193, -27502131.6568125, -80712821.1884907, 52632166.9143767, 98622487.3089059, -79523093.901844, 108045006.996104, 42801734.4060988, 28601111.3228483, 3911122.24573916, -77446011.7373623, -11965767.7120992, -57675685.3014879, 171452557.622937, 26621134.3807004, -4354750.548063, 37795002.0738783, 13196334.3437323, -63465440.8267063, 34486909.0006338, 49405698.5326055, -2120722.11206831, -53447968.8720425, 147289272.442235, 1288630.07751486, -75168216.5707248, 192264106.827819, 2587531.1244956, 140840358.1813, 124035505.084937, -44015958.3680397, 70034386.8618026};

double lars2[2500] = {
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 90.33902020867478200, 122.70798506974135000, 243.20530461583570000, 246.40231341803522000, 405.80632090818909000, 429.07655234109262000, 490.52835871922827000, 515.77707458381542000, 539.27929008058049000, 596.25436477379185000, 710.03161360472473000, 839.24164717965198000, 847.90009262147464000, 880.70866141670604000, 966.13404101197796000, 976.26163475660917000, 988.60031162580265000, 1020.48691328642580000, 1030.82951058862730000, 1097.66524888450270000, 1106.10947751183720000, 1119.89375484433820000, 1121.10880761880140000, 1138.17532157283770000, 1140.91709749475420000, 1166.59836835119490000, 1169.79739937354840000, 1190.88260565313680000, 1195.61816829744700000, 1207.82604164872100000, 1238.48630275539740000, 1259.12074320191120000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 70.56698000315188300, 79.51362112605178800, 95.76822514326364900, 97.16659597350107400, 117.48939865754279000, 120.55881565069100000, 170.53192438099842000, 176.28797484502655000, 215.14729348108835000, 232.33273478954578000, 266.84643050855777000, 355.00549015592071000, 426.28744142280397000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 43.35874943415483800, 108.87299898439686000, 125.35798573060281000, 157.24553687756946000, 202.51882826967875000, 278.39172144009297000, 338.33163700212924000, 352.99375315154583000, 353.34330940607066000, 361.31088139914101000, 412.28818144063860000, 431.15151999575085000, 496.64461352688886000, 498.33207609597059000, 555.22998775280394000, 562.49368767662020000, 572.78134167361486000, 577.59068676987795000, 581.02102960440538000, 579.41923013635630000, 581.98500811289318000, 597.75912429168875000, 598.12636160567808000, 599.25583182906939000, 599.45742902140705000, 598.65951162466354000, 597.94427181510332000, 599.44246965321861000, 602.04628054370698000, 616.64196623472424000, 619.15682362299844000, 619.92946627204617000, 620.03441749016451000, 622.13677677876308000, 621.79768345643367000, 611.42685568980278000, 610.07789754477005000, 599.33847084595084000, 599.41238846026988000, 601.46002454003406000, 596.31870531231209000, 593.95022096418302000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -59.77235596102511300, -85.64454387667339600, -110.70291411292055000, -153.81175400394116000, -239.35022266063285000, -332.48393291949037000, -339.28919970800933000, -375.98076682115550000, -467.70965360991090000, -477.70942977287217000, -487.71112584101650000, -513.77789911521165000, -520.51926126634487000, -561.11859439703551000, -567.37035013414061000, -584.58329608621489000, -585.69800662102227000, -602.84049670821071000, -606.46015799046870000, -641.00131374421073000, -645.90078562908650000, -692.25941740796304000, -709.36619409107504000, -740.78716135690229000, -811.67389239546674000, -890.70987302035007000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 77.43548218503639200, 182.52616104972708000, 189.27056947775759000, 208.71398593467313000, 259.99983911054267000, 264.56472116943951000, 270.18426338145230000, 272.39325977369265000, 268.61220831467261000, 254.99790671359543000, 252.22845665739757000, 250.57812927429555000, 250.86331527645541000, 255.26591992225264000, 254.82728012573381000, 261.64405191834891000, 262.01607029894780000, 270.89234713823043000, 278.62697134501292000, 296.27382736906412000, 333.48089735111824000, 359.17793171235968000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 5.73605847073728100, 6.77922744964299360, 19.06823949719247600, 20.67860101443924100, 37.09458163225870200, 43.46043270536780100, 55.41684668310790600, 65.74099337975793800, 92.59916798784028900,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 21.46848522513756000, 72.48166545023818200, 87.86605276335753000, 94.84972434646145700, 111.22855340110628000, 147.58851000748251000, 194.82577948630751000, 200.19803463239799000, 204.25554211091378000, 209.48389351802629000, 211.25400083051613000, 212.88014249877762000, 210.32720235545384000, 212.25729587898468000, 230.78580890886946000, 233.29446190962685000, 238.29990676496078000, 239.28863848826444000, 254.03738718408664000, 256.51824186358277000, 289.01344814642312000, 292.74575251794943000, 314.92186532776196000, 319.18955975744041000, 332.21979062323470000, 346.40059317612986000, 368.70790891238187000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -4.32906103020914300, -37.29551692051062900, -40.98705939290096000, -71.55443074954067100, -79.03615683579259600, -96.48888952563874000, -137.86049737600487000, -187.46326866300180000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 32.05697400441985000, 95.21815068453725000, 217.39022772903553000, 361.15310779189110000, 370.85146617653368000, 413.82863043712501000, 525.69288883855359000, 538.19692585630128000, 553.88732549287693000, 593.82087390135700000, 603.70401018541213000, 666.89442043021552000, 675.04027322404283000, 687.20952597554867000, 687.91765722314210000, 697.80472683091352000, 698.90670300371335000, 706.94050377419114000, 707.37251403315827000, 714.82073268857675000, 719.99167040154202000, 731.66901251077070000, 757.81485472126644000, 770.00851563783601000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -109.66767836674514000, -126.22353622673802000, -163.10419940618556000, -176.50018715113379000, -192.10030692718473000, -236.06762056511008000, -307.17932273889056000, -394.63522249158916000, -401.37720335206797000, -427.90444620775452000, -495.01957758796800000, -503.05674395259382000, -513.75229380909343000, -540.77747568340828000, -549.95081792120754000, -604.49392174785794000, -612.73572269492195000, -626.74968960590672000, -627.74162084111333000, -642.12606634297697000, -643.78240499834192000, -650.95858981054926000, -650.75393328761061000, -645.89554501794851000, -643.23964356947636000, -638.56809629039788000, -633.12709620959413000, -619.18136083599859000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -71.37329466746894000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 107.34513286933682000, 169.53219223222445000, 181.55885814462616000, 181.90083238313545000, 188.59198981507120000, 246.66071196901086000, 271.47100854877431000, 361.98945197785207000, 364.52809459270782000, 472.75205507192078000, 489.31813950114719000, 521.45718273628449000, 530.68653076233545000, 539.38085635263099000, 547.04213799338413000, 554.88621838720883000, 573.50422479258532000, 576.01686372378379000, 568.36084550995679000, 549.34831267649690000, 548.32731690382445000, 546.71190285694422000, 530.79847848876102000, 526.62925960932716000, 529.33619602982355000, 528.22825964190497000, 525.84957716782765000, 525.71849727166000000, 523.79851514610766000, 523.18591060406561000, 525.71059231779691000, 526.61431987581682000, 528.57882442627727000, 531.45065920261561000, 536.51548220254620000, 539.83844259872103000, 544.92860898909771000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 7.08422765979233660, 20.95578559669958800, 21.65099939154539400, 32.33564745771620600, 33.41068733487295400, 36.41510397646560900, 36.62556766643616200, 37.16599964707209800, 39.55418913795691100, 46.86396118445325200, 56.73970165654311200, 71.57836425441198000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 2.90582509699859460, 23.11534220878538900, 28.71057415149519800, 37.34323145103820000, 51.40005049169870700, 69.22622341627932500,
0.00000000000000000, 328.06190151981588000, 381.29503088332945000, 748.46322696054222000, 788.71308231663465000, 913.63963503026889000, 964.50794243408802000, 1138.46568971196760000, 1181.87404537410910000, 1238.81212789135880000, 1253.59384474984810000, 1277.27188725215680000, 1313.36638676770490000, 1369.68203357772150000, 1402.42175312007630000, 1408.71279115982630000, 1408.86472858486600000, 1411.05171479862290000, 1429.31865495236680000, 1435.10470065274940000, 1461.24789255885480000, 1461.85831279155400000, 1481.67528290441920000, 1482.04623360394110000, 1484.13635737795470000, 1484.81661191826540000, 1490.09376769737010000, 1502.69105200044600000, 1517.92024743714410000, 1520.99611134414480000, 1521.72755879890220000, 1525.02068233446110000, 1533.85664126476540000, 1535.59442496860360000, 1536.45962527241550000, 1544.19398368213520000, 1545.54321059167410000, 1541.23834638102330000, 1539.46527540477310000, 1532.51400833134110000, 1532.00003536148100000, 1523.43884935976960000, 1522.94312641041730000, 1509.89034197297590000, 1509.07723254992110000, 1502.06505116988430000, 1499.17330244691060000, 1494.22600188969750000, 1479.40319056712130000, 1480.45656837916090000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 45.91288168902228500, 113.88157849905518000, 218.61206693712768000, 303.95186182918445000, 322.29384006850057000, 322.83930087781420000, 333.71183299383858000, 426.75185475324486000, 460.56755111990265000, 578.51590637552806000, 581.73791461549195000, 714.16584321020412000, 733.94763696274958000, 789.15193430916429000, 812.00858067185152000, 829.50708806256671000, 867.10142882972912000, 947.13671320186450000, 1047.08225381890340000, 1053.16426474856440000, 1074.76345717591880000, 1126.25106826039270000, 1131.09381662364380000, 1138.78657937767840000, 1151.16867119598710000, 1152.70934915869130000, 1156.21097077416830000, 1155.82090347039160000, 1156.52237035279360000, 1156.76095305637140000, 1160.49850276547390000, 1160.85384573716990000, 1165.55349987203070000, 1166.07168805320880000, 1169.91533893820970000, 1171.31946291358260000, 1174.19085695189390000, 1178.03189413564770000, 1194.01384179025100000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 13.65814964925465700, 14.07288967622387300, 24.21311513140698300, 105.13005453803142000, 133.64751884535616000, 225.37347132650206000, 228.12484200861039000, 329.18251244504643000, 346.21561520312923000, 380.67151722157132000, 394.02907452734610000, 402.58176270652604000, 409.31781292750139000, 424.09027078216127000, 454.73011539694267000, 455.46276289795929000, 471.11606752192785000, 513.71448588692704000, 518.74574182799802000, 525.92846254350729000, 541.77763857664502000, 548.83189296722571000, 598.94624422534184000, 606.75214969984597000, 621.61156046803683000, 623.18453146317233000, 646.54599290498629000, 651.45885106124490000, 700.08496150940505000, 705.04297998776565000, 744.04610235753057000, 757.06198323624290000, 788.22766124337295000, 857.75989625749810000, 918.31556233320907000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.99221268716260191, 51.21183990305507200, 58.94594160840566100, 75.28997800172560100, 79.27699487343456000, 76.76693070888649100, 70.14498202723002900, 63.55797095530467500, 60.51468696352415600, 59.58307926711096800, 62.07448496444966700, 75.43618038191537800, 77.77416956373950500, 81.14454694469361600, 84.69110607527683500, 85.67412508354009000, 98.60879244193488100, 101.58617570181453000, 108.15893670763998000, 108.71101167477045000, 117.56539837869215000, 118.74795297691887000, 139.10204934190227000, 141.79504949632548000, 159.85556542929444000, 170.15247230182862000, 190.87633058999236000, 230.69333660551692000, 267.36333710564725000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 54.98394235372808900, 226.42873061215624000, 285.95446038232075000, 459.06025986696545000, 508.48772331972214000, 578.16284182491029000, 600.58747355493722000, 637.55592246591880000, 693.05635901570759000, 794.28984346310392000, 858.10733180169620000, 873.15588575956087000, 873.64673331311747000, 886.00445499236764000, 997.05704863812650000, 1036.73683715995120000, 1166.82453634088730000, 1170.42329394595840000, 1332.94415183190290000, 1358.56209637191840000, 1411.43372176181540000, 1432.81042614746340000, 1447.36622571194040000, 1482.59960842407350000, 1546.54500982704420000, 1635.67393196530360000, 1642.22120387656990000, 1670.54585192670790000, 1739.30177464283590000, 1748.22244880431030000, 1761.00938871224210000, 1791.91646734934870000, 1803.54363949632420000, 1877.86723211166010000, 1888.63104001771260000, 1909.62636348893510000, 1911.51787508726330000, 1938.78719792071230000, 1943.31211935629220000, 1975.54928619581010000, 1978.64290697990050000, 1999.84722362367730000, 2004.33780683650870000, 2015.43563523504350000, 2030.88113924492750000, 2035.78299671550550000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -50.51607690360815200, -67.89038211452441400, -160.51196347542762000, -175.56358811078175000, -200.52552582787749000, -202.44698297515876000, -230.85599051164311000, -235.60717943758749000, -267.46524796362996000, -270.61999662901599000, -295.52510593795500000, -308.78384442709961000, -341.23245297690084000, -398.05159444140202000, -443.79062541272941000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 62.88832553461004000, 217.21532884381122000, 234.96864098452551000, 257.52816262140919000, 333.91359202797935000, 360.12039009139329000, 508.81256716174818000, 530.20847019634323000, 568.93386898906317000, 572.15387362488025000, 618.50416275182113000, 626.91665893987931000, 681.97636407745802000, 687.58666159299844000, 731.46215413740276000, 746.67923477926672000, 781.77176249315016000, 859.22461786612462000, 914.55206815876443000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -36.14503372489376400, -40.09714264611371700, -45.12818644343416000, -59.28214743267411500, -61.74089444054467900, -85.74483935472667900, -89.96539457277850700, -99.42811333302375900, -100.28262799877164000, -112.66949298797095000, -114.53163580146710000, -139.50943517528898000, -142.01326797550507000, -163.00576691737805000, -171.96700027311903000, -191.96797774608530000, -234.05103406285318000, -257.83750848190198000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 19.81425179011610600, 49.96008027663264500, 94.65084880797921600, 173.94816060751035000, 253.52991042387617000, 273.91422388719900000, 274.54695928371342000, 291.26589742893856000, 431.13983955064771000, 481.60302165733526000, 656.63997232403540000, 661.54932151673870000, 892.28446856318465000, 928.46588521638034000, 1017.00285301449750000, 1051.96228943603300000, 1077.14847755242860000, 1131.09480902732090000, 1237.72732016549750000, 1374.73458579275190000, 1384.38123296040590000, 1417.45387658402840000, 1499.66276265466580000, 1507.88093744253140000, 1519.54282039768710000, 1543.07428668937450000, 1550.04612409965080000, 1597.23449901232740000, 1604.93372710134370000, 1626.41560142808730000, 1627.87602195622940000, 1650.35403254500720000, 1654.22836615266740000, 1690.67669529724870000, 1694.18657397273480000, 1721.47123238228050000, 1727.72365546965190000, 1742.65662443570050000, 1775.65588448531070000, 1806.82430506934450000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -76.13223476380504500, -352.65448557904921000, -422.24473284327632000, -521.92622394529224000, -548.29704612285946000, -582.65683919829701000, -628.37496354720770000, -691.99824662369736000, -732.20835472779970000, -739.92955401905442000, -740.20439847671435000, -744.30267328873242000, -788.52927314268481000, -802.86096879783838000, -859.98611119919303000, -861.48735411021903000, -947.71597903494524000, -958.43004975199949000, -982.62435235640271000, -990.77147628322848000, -997.77789637375031000, -1027.44805604084540000, -1101.43122708425400000, -1199.55387587988710000, -1206.75815437922480000, -1237.77008856464230000, -1317.96640369619830000, -1328.39844976878410000, -1342.14017818373960000, -1365.67922631311080000, -1373.47914788361750000, -1428.64492451511050000, -1435.79052798172350000, -1447.44649198565410000, -1448.78606819047310000, -1467.64827181070630000, -1469.74303974211880000, -1472.57226285431280000, -1471.80809222494830000, -1460.41151375585900000, -1459.33596687558720000, -1463.13638808769750000, -1475.41400956072220000, -1478.39286322330080000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -56.06180775833102100, -173.02939351318159000, -323.90886429416025000, -333.57698420988044000, -384.07590586197222000, -513.75304527215030000, -530.40433533519979000, -552.68818277216678000, -609.73261227911337000, -627.34592567756795000, -723.02689801622466000, -737.45155758036094000, -766.32788657503795000, -768.57197714116148000, -801.18649897223793000, -807.03236325230603000, -838.01234532613000000, -841.03205932013407000, -858.99093112474532000, -863.18418813617609000, -875.27693354404778000, -893.15917230626189000, -902.47612453738429000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -87.27153072197072000, -93.31092677063897200, -120.07372254436052000, -186.03743480699251000, -194.48196623391689000, -206.19911555579577000, -228.69541860194877000, -238.71516879355127000, -315.88020146811448000, -328.28746352406637000, -354.56830197377781000, -356.41371762233308000, -384.42745280744811000, -388.15344360160105000, -419.70535814261967000, -422.55908570815518000, -441.07749723703722000, -448.86217312781514000, -462.73835669497248000, -482.30144142149311000, -486.34041594603747000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 219.78535200881655000, 276.26887679027703000, 373.05235715851296000, 394.38706182485328000, 428.03276385690225000, 491.44454585018707000, 586.10030346716326000, 648.66705295858117000, 661.20803126439898000, 661.60636306945980000, 666.93265758771645000, 728.92786057659407000, 746.07410358236871000, 814.63289463586318000, 816.45921714230224000, 898.64973164720595000, 907.32029152894688000, 932.02509758573603000, 939.51908892767324000, 940.23219472098037000, 945.48100482594884000, 966.35600872191765000, 1003.99149838152860000, 1005.61721275943480000, 1016.96260737678130000, 1043.18358055320890000, 1046.80962246955120000, 1051.24533015823540000, 1044.33249383961860000, 1041.23206508217210000, 1033.84706734334760000, 1032.61420068422690000, 1032.05360693682450000, 1031.77696551040980000, 1026.91188213524540000, 1025.61427190013230000, 1012.33999232138730000, 1011.04055414751170000, 1000.69493613498130000, 1001.73808095323530000, 998.67746397319888000, 1001.22532270454210000, 1009.23379400832780000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -19.14628283813488700, -20.49729084085332400, -40.95429060319843700, -46.11303032240923700, -93.57604278766699200, -98.91374644996314200, -145.35299829891173000, -159.81005497665947000, -186.07883975146584000, -244.30010545099668000, -303.47588295219288000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 7.28150167612342170, 31.59909636511290300, 92.62199667685079900, 100.51455820189626000, 109.87118675554159000, 135.39647877228813000, 145.18406396441335000, 201.61442045607797000, 209.38817483311308000, 218.50328021063495000, 219.46852856318580000, 233.14207337733777000, 234.97829699157901000, 257.08874184654422000, 259.09460324461139000, 269.99718568440932000, 272.88583973946197000, 280.70534825639419000, 295.61356570758159000, 305.43328932091896000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -60.76184012805443000, -67.36725242498843600, -120.45702884720265000, -138.87339430315859000, -179.04392024108213000, -273.93707248926609000, -345.21177943848937000,
130.24806091415982000, 455.92540165373339000, 517.01098785762952000, 889.57360690614723000, 929.94674058947317000, 1055.60460066310880000, 1104.35130195979010000, 1265.68972835711910000, 1303.40933734715370000, 1360.10934851704500000, 1376.36727641609240000, 1401.71922409453990000, 1449.36064816020830000, 1517.27264751904180000, 1573.48684890469640000, 1586.06312035100770000, 1586.46715716143330000, 1595.83002323959230000, 1681.30165971360200000, 1708.32086146059940000, 1805.65965491866130000, 1808.46124478325170000, 1944.21597454487870000, 1964.22918874872380000, 2010.64572641141150000, 2027.72324052598670000, 2042.84681716868770000, 2090.54391727314580000, 2180.84427850626210000, 2306.64631775245240000, 2314.92078801474600000, 2346.91318092750820000, 2427.23601089238450000, 2436.36885127287540000, 2448.62469406092710000, 2476.20233814509540000, 2485.94291179641960000, 2552.67419446692160000, 2562.72048401248460000, 2579.81296748380460000, 2580.93059955941180000, 2596.97728033404060000, 2599.67065710337370000, 2619.19402995104880000, 2621.05395984540880000, 2632.54114153817230000, 2639.36743580468330000, 2654.33764278915210000, 2699.12177801758530000, 2721.18192463505370000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 18.07096289994384400, 161.44622659960598000, 213.19922034244138000, 394.07517914880526000, 399.04163861298463000, 631.14230458242935000, 661.63805676411528000, 736.40390777216749000, 768.07384021706628000, 800.80821379142992000, 864.25636767469837000, 978.03765945212695000, 1097.81580513198630000, 1104.43308144999200000, 1138.54723764131400000, 1222.84270871716740000, 1233.74541788812010000, 1246.88284327384460000, 1278.56269377938700000, 1285.48371151665970000, 1324.52689057727480000, 1330.33201095970660000, 1342.12825385471840000, 1342.75790550747980000, 1353.00935495870980000, 1355.48792252730780000, 1372.06303468000420000, 1374.48002229940110000, 1397.57002941422160000, 1403.91058863234280000, 1417.33844718901100000, 1452.57205985236280000, 1471.31289243032850000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -16.92072843665642200, -51.85049168761617700, -122.25499891779668000, -181.00750582977815000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 19.84993434521544800, 106.32368456227741000, 108.52687483999416000, 202.59718384305160000, 220.64768870737916000, 257.66705316444188000, 275.80317508598284000, 296.40169223061508000, 321.83110208172877000, 357.97169929211748000, 388.64938414385449000, 391.62276027161141000, 387.42337858523200000, 384.64533905627098000, 383.92829895823616000, 382.06587806040568000, 380.34738460426632000, 380.50133781949125000, 389.60294982631427000, 390.23630258319133000, 388.56188116602334000, 388.41455892712611000, 385.23821882092642000, 384.21951793662447000, 390.30865892152497000, 391.06450339888210000, 397.89007343712973000, 398.62299880312719000, 405.31460670991322000, 415.55193423135444000, 418.83852416851806000,
0.00000000000000000, 0.00000000000000000, 61.45289176755488800, 486.75385617363412000, 537.08032155154910000, 725.01000503474279000, 787.79674684952704000, 983.95328708018883000, 1047.24724593139900000, 1128.04129036137310000, 1151.55639076861280000, 1184.37244669415350000, 1229.53964360633970000, 1302.85577393681770000, 1348.68594588403580000, 1360.42976458299470000, 1360.72461056471890000, 1369.70127786511650000, 1448.46341163006970000, 1473.19208937836080000, 1549.88364583128960000, 1552.10017048693250000, 1654.37708599477080000, 1664.63745761479250000, 1691.16747057221260000, 1701.92347285553270000, 1707.60358858303110000, 1720.62335679463240000, 1749.99908828158230000, 1800.51588558608050000, 1802.29797468714510000, 1822.92556839480560000, 1866.90897930336520000, 1870.93600529992320000, 1876.87797743657670000, 1895.35591723021780000, 1902.66822292643250000, 1949.36198236096970000, 1956.12249626829730000, 1971.94793302475680000, 1973.26155441128410000, 1993.83225100776780000, 1996.78889164110980000, 2024.02171988319760000, 2026.73427146531160000, 2051.79577045274980000, 2061.16365761727680000, 2082.11443483501670000, 2131.28301152521090000, 2156.22778061928970000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -13.61526049908530900, -111.13109582713419000, -123.28579414744118000, -142.55312633548064000, -144.40239876396939000, -171.59669265018269000, -176.78930910457692000, -225.59222199510279000, -230.63739302906703000, -263.30258581309164000, -273.87782755459557000, -299.29243875850113000, -346.27248663144258000, -397.14771766798992000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1.77201645619822630, -28.20719387283483600, -32.31056919550508900, -69.93689586280640900, -73.78343120097119400, -104.68621021994849000, -118.27226894808251000, -150.88873388781488000, -217.06233794216161000, -269.34970629431734000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -152.44382657824016000, -194.72680177882197000, -298.98674030541719000, -327.87800350970269000, -350.77967283072167000, -355.93652216157386000, -364.65306553309534000, -378.69379562382727000, -395.14654101848265000, -400.31578925277557000, -400.31168467168305000, -400.25876034526470000, -402.71760451298024000, -439.00016863597051000, -452.41962644135413000, -505.88121569495991000, -507.23624647552208000, -604.51138999989098000, -617.89349663609460000, -659.07466316769501000, -676.68147017714966000, -697.60362627710435000, -751.24984271543804000, -846.05452833075026000, -947.50510132564420000, -954.55030172427576000, -984.17290086776620000, -1066.18213859958790000, -1076.55228178745370000, -1091.35768003869130000, -1137.13544106960060000, -1149.70870318792480000, -1214.09924918029010000, -1224.42787960678670000, -1243.35085838973260000, -1244.56362029629600000, -1262.83245589467720000, -1266.09380598136840000, -1292.67923727489640000, -1295.83074384052000000, -1321.91782963645820000, -1326.46912853399040000, -1337.36998831539430000, -1357.50926397943570000, -1359.62124558989190000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -6.99501162262295310, -29.11394904732022200, -35.86971366743956200, -55.50104219992101700, -60.54218042790743200, -72.53244250370619300, -73.28178052395159600, -84.18387946814392800, -85.86954186267827500, -78.39945156664499800, -77.22706891939849100, -65.11038390115621200, -58.06517634880100300, -44.11873269470421400, -0.03152266526322847, 36.62551091264456500,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 52.43847147302932400, 87.22199138099406900,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 62.64191467219561800, 171.69119193422435000, 252.09734024022075000, 268.65738836953670000, 269.10126544748039000, 281.85728451679194000, 395.72632739360023000, 433.80365969045374000, 564.52529178160137000, 568.13235633119143000, 729.52102821143183000, 747.21217517139087000, 798.05655737075642000, 817.54595872837297000, 833.05578812300405000, 854.81933411165267000, 883.27104817126371000, 903.40614356334356000, 903.87334197773475000, 917.67850036888410000, 949.03210556351792000, 954.87136438038669000, 961.47195661374371000, 980.82133953096422000, 989.11186671661596000, 1049.37337471582120000, 1057.28400996434680000, 1070.20029966707010000, 1070.71401258849030000, 1078.87781568111860000, 1080.63322113843150000, 1099.83739184100270000, 1102.68189883552100000, 1124.38584311454880000, 1134.95828484570820000, 1155.40912271346520000, 1192.96925625080120000, 1232.75015919849870000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -19.37786951345085000, -38.02336932073374200, -78.88745378086906600, -148.10558284631023000, -214.75592146133303000, -218.55640330388087000, -237.54465354161800000, -292.44738672350485000, -296.68974573601531000, -301.44203764130333000, -318.83080402923582000, -322.90668485006086000, -335.60810395186496000, -337.23773817421772000, -342.65080030652064000, -343.00246963958153000, -347.74700688805797000, -349.88763871450760000, -368.90048992297739000, -371.12228788996453000, -395.60565372909440000, -404.03537292542512000, -419.12475410488275000, -462.18198436645537000, -484.41084333846027000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -20.53785320751624300, -29.41428224016109300, -47.34725161998596800, -88.33861165805143400, -123.80266372004924000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -11.48373433893571200, -25.79326193788689600, -45.99911157492140700, -52.27823031040484400, -102.24086594050586000, -109.24598308097875000, -122.24833519206641000, -123.16449304009615000, -137.58355113167642000, -139.59739432364151000, -162.71420339422932000, -166.14924314022437000, -189.27053850883016000, -196.92372530642675000, -208.30442213800194000, -216.46860911484390000, -231.89083557055008000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -364.07521181431974000, -413.17329809410626000, -568.02741676761377000, -623.94424615693686000, -789.27882884793200000, -830.50263687486631000, -892.81661061817988000, -909.76048321175517000, -928.02296192003587000, -957.15517080354755000, -1001.69918045839290000, -1031.36974596696720000, -1037.82880938568180000, -1038.06579362433900000, -1045.84187470679190000, -1102.19772925724670000, -1124.97765169471540000, -1189.24555291572300000, -1191.06384863614770000, -1288.01297673547200000, -1304.11919661336790000, -1354.88619972115410000, -1377.93134310601320000, -1397.21426293714380000, -1430.06508428630740000, -1493.09352955758140000, -1570.47405443849520000, -1576.75218130397960000, -1610.64616719851780000, -1696.18460610206060000, -1706.41252818708060000, -1720.16850267312610000, -1752.85694106315400000, -1762.63054219960030000, -1823.96996261154980000, -1833.25057356891010000, -1852.21104983599590000, -1853.55787022050870000, -1873.35498046543690000, -1876.28262818145960000, -1897.65956541388050000, -1899.58055293746880000, -1914.92278156023960000, -1919.07953421798920000, -1929.35082367170820000, -1951.90776341882290000, -1963.43489132382890000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -0.32803343440700417, -6.91709934833832210, -68.25005631288942700, -89.83612196025330800, -160.69601720538077000, -162.49008064270512000, -235.15752043963491000, -249.20035329075270000, -290.54352106104943000, -306.87136530122217000, -318.89764085964504000, -339.82411180336408000, -396.11162082843322000, -454.92797824803660000, -458.38673091380946000, -475.83065274364861000, -525.33039423064679000, -531.52899448375933000, -539.51363740403451000, -563.64353768001251000, -571.53140974941618000, -637.75483881142213000, -646.86041133613651000, -664.92688072323074000, -666.74032745368334000, -692.17722018844302000, -696.62991073301328000, -747.23924879575884000, -752.90648400168368000, -794.06763700466422000, -806.66339590015843000, -834.76937438791151000, -895.43920404394930000, -944.28045692604815000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -104.09056725792594000, -106.76099845864626000, -242.72145512723961000, -261.31203451112384000, -291.67739784904967000, -303.67411215587452000, -312.51613852615941000, -349.21047805837696000, -412.30710078877519000, -485.33598411608688000, -490.06273387768618000, -500.11353272784743000, -527.88357797060439000, -532.14755774609091000, -537.15165555879071000, -549.13699149441061000, -551.73450319855976000, -576.86364552931434000, -578.91637402350807000, -579.57041649470420000, -579.48891433392930000, -577.86772974250448000, -576.99157288118738000, -569.05594949788610000, -568.25976541404816000, -555.24077390204968000, -548.22988619623607000, -532.21268225028939000, -504.95274475367842000, -472.40622198618780000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 66.24180220580902300, 85.83034410500965800, 119.58729440650322000, 181.19787318365778000, 262.49172483628990000, 321.14345173253270000, 335.15115485180064000, 335.58843035151040000, 350.05543079783780000, 460.29766289995837000, 498.03004458242867000, 622.26463554217833000, 625.71935567868320000, 761.69672630697323000, 781.43495329372865000, 827.94278251465460000, 848.48828499385786000, 859.54732816786429000, 876.55589213940220000, 909.17627479746022000, 939.30721546767631000, 940.21977422079851000, 948.33792914844639000, 968.07104373245397000, 970.40524605718144000, 971.73055930222256000, 967.46731522049504000, 965.88076612043869000, 959.45565374594355000, 957.55303433208996000, 953.33166374308166000, 952.92372089241883000, 946.92015563856864000, 946.45148991060171000, 940.69584844630060000, 939.97287232098029000, 937.29097379668019000, 936.70219503551323000, 937.17022969439802000, 951.47243334500683000, 972.97166666522435000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -105.62047293524826000, -126.57839370687697000, -127.18973763276276000, -136.50659193393361000, -216.30795509399530000, -244.38853657830381000, -343.97866704147526000, -346.71385702428626000, -470.60998020644416000, -494.38599123650278000, -559.79278799442352000, -588.21855837632199000, -610.63102824405109000, -672.75837264353800000, -793.00577211990503000, -954.86423469971430000, -964.76240051877073000, -998.16624468981058000, -1080.25178236311740000, -1090.23586117216410000, -1102.92966062592020000, -1132.78058024211900000, -1141.37368322920040000, -1201.56105159449180000, -1210.54040858514170000, -1229.76774140744780000, -1230.81835660136930000, -1246.77284365435370000, -1249.31509565449460000, -1263.50594260312100000, -1264.69818565361920000, -1271.58525634789500000, -1273.08644518708180000, -1277.61422387317410000, -1283.65383956960950000, -1289.94154047079270000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 19.31984785208251800, 55.27579978889598100, 90.50556338780984300};

double larslsq2[2500] = {
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 959.66593451659242000, 962.24470945807161000, 1004.10042119294090000, 971.97115224759693000, 1028.27168817504640000, 1019.96839001698370000, 1065.47602396593400000, 1078.54696858061150000, 1180.92313127284820000, 1279.57093157667870000, 1300.34491985732890000, 1251.21839539085860000, 1257.69964334062840000, 1242.85145501424290000, 1247.66541962731000000, 1246.96970764697330000, 1231.53616396391730000, 1269.67714001640800000, 1281.43521961882130000, 1281.45182873010090000, 1259.75863264362370000, 1240.09691044492820000, 1257.28426460419970000, 1250.29276894226340000, 1248.30436163968940000, 1267.73577155553470000, 1283.71876626129440000, 1269.53059601201740000, 1243.20837839622230000, 1251.28894184188330000, 1262.30576205719310000, 1259.12074320191120000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 264.61382134121448000, 242.30455330795073000, 237.51339239262063000, 253.88718527196940000, 250.99884097621782000, 240.77881276254945000, 367.33489707204222000, 381.26789912676935000, 360.09286702286664000, 405.03845614501751000, 389.72330424152841000, 423.49483295860352000, 426.28744142280397000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 975.83967365189312000, 1008.90765566803550000, 916.54200500427271000, 1129.56696903780020000, 1027.21959568823190000, 1089.61739103553080000, 1206.94336983192280000, 1294.52792284762810000, 1098.94417897086280000, 1090.70289810357300000, 902.83964903967046000, 920.39995687224632000, 910.20879258987293000, 881.30576574443000000, 777.41373353081156000, 746.93796399099631000, 669.03339665865008000, 684.78642078398263000, 674.67425788220658000, 560.20844157473209000, 595.29709726957742000, 648.05374081214291000, 615.50750551786928000, 611.72298650859943000, 600.12182098258654000, 577.33137719859258000, 583.86193587230161000, 611.15071824426673000, 665.13777055584285000, 656.77754671979767000, 664.91656439250278000, 626.66714880170230000, 631.79668855262412000, 635.94810096165656000, 608.51639964191963000, 570.58469506388258000, 562.03986518976524000, 559.28032219571480000, 600.15522623049128000, 608.75009054955922000, 592.32449783716459000, 593.95022096418302000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -619.00695835204101000, -662.31103768343405000, -794.83198843855780000, -670.82703887722982000, -683.15156926858822000, -629.43396102268105000, -661.37880472975837000, -780.98431021733973000, -770.01512862025959000, -745.00097035676197000, -684.63423071686725000, -717.48681772152418000, -683.86544910974612000, -672.75965306343198000, -681.12579536060514000, -734.68550099058427000, -710.62773780152986000, -715.45706476115402000, -748.23159858336953000, -777.03051635409543000, -820.37690988453085000, -865.17748976874918000, -881.28137241529112000, -852.65319444486499000, -866.74464339578128000, -890.70987302035007000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 479.19590423424540000, 517.60010962878471000, 508.47978113637714000, 423.33149018286502000, 429.01959666354492000, 386.58288819858763000, 380.82726761101316000, 289.65631959068975000, 176.99565842099392000, 217.56096067176753000, 201.83620887563657000, 236.18676479157477000, 282.82516498879392000, 284.18856903459914000, 237.64705495973115000, 288.48970925344059000, 275.26409513179539000, 304.00093170799357000, 356.35636037085550000, 359.10078502392906000, 362.38646622716448000, 359.17793171235968000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 43.41875309911144900, 47.63707501847248700, 67.46455030999209200, 78.02552386272739700, 98.32632241971641900, 107.43428603212269000, 97.98449236796575700, 73.76165540905398600, 92.59916798784028900,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 566.60928983536644000, 549.76476900545754000, 430.76943303201654000, 285.51387091702026000, 307.66401747264018000, 336.23576963146257000, 345.43836069098484000, 454.46397186201483000, 249.04253365826082000, 226.71466248274834000, 258.56853096036855000, 244.89719881605257000, 190.37626058016494000, 259.02431598292702000, 281.73597608308739000, 278.94130913466034000, 281.94893183044150000, 350.09945846791345000, 350.92841367738242000, 353.68599165767586000, 416.98533857222628000, 425.65762885624184000, 397.63894588826696000, 362.07791111095611000, 378.61047697113810000, 357.41742855467561000, 368.70790891238187000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -173.88559431016608000, -167.12327194998224000, -172.44735516380860000, -185.57097371694701000, -154.22403694418946000, -158.62472245656969000, -170.00142814019372000, -187.46326866300180000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 907.25786474715585000, 852.72621252883096000, 851.25862824777164000, 819.53054337569995000, 829.86953534891609000, 888.21294215061982000, 894.35731894989476000, 872.42673895663995000, 862.81515054631882000, 905.89708973499717000, 843.17677544337027000, 840.65698629760539000, 823.26025338279078000, 793.32916843102623000, 767.28054439426194000, 762.75724199438537000, 742.06785465141900000, 738.57903725367339000, 722.75692227027037000, 742.60264865537761000, 771.95719818594637000, 773.24309671126309000, 778.12713524220612000, 770.00851563783601000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -537.91495248923650000, -546.61992563950241000, -508.16242368839272000, -475.08402973698998000, -618.00571901663318000, -763.37879950407557000, -676.12992098926895000, -673.48196678183706000, -720.47151954836204000, -720.71361731657919000, -716.20695249857886000, -717.88821062951183000, -724.33666587421487000, -751.97625033978409000, -772.22495936834332000, -754.47790878914520000, -762.70155239563690000, -748.95580927028573000, -738.91102194965276000, -736.62382469228180000, -708.65629760033278000, -679.21967941465130000, -643.46586678473864000, -627.77371738555928000, -616.54906476649364000, -621.93628931665967000, -628.90007154288162000, -619.18136083599859000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -71.37329466746894000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1255.06895953494950000, 1070.70812627039390000, 953.85644388540879000, 911.32931864463171000, 801.13453321614566000, 805.45250461057844000, 914.96255086655003000, 933.57927509420063000, 940.67914334704471000, 895.36167679631956000, 909.97420816570263000, 822.15245860175662000, 736.39993171850779000, 776.74828535528263000, 638.92583794916948000, 595.58385415682130000, 632.86637744317397000, 694.93870853335739000, 483.85329380620942000, 486.68983102932270000, 521.03635273023929000, 514.90606236705696000, 406.43684633480916000, 425.60724136249843000, 536.77979730164816000, 508.06851534123729000, 505.10673134001331000, 511.02788865170453000, 511.18530687805702000, 499.19200021671679000, 535.65323705183766000, 558.79715210981396000, 535.90644232557042000, 560.31126788638312000, 554.54744323358420000, 542.41999660580450000, 544.92860898909771000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 135.98713196591495000, 141.92005502424408000, 99.56617987207596300, 102.52780681996411000, 75.51682384725239700, 48.24703001210328800, 44.12043441644544100, 39.18181531608130500, 63.55438682585910500, 72.88846879113509700, 64.41200416667454900, 71.57836425441198000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 106.38577407957395000, 98.49700487262646200, 84.94006232537861900, 68.07752167634240000, 62.32056509158275800, 69.22622341627932500,
0.00000000000000000, 2589.65975253239870000, 2295.08977789138540000, 2186.32823203981980000, 2082.77922356951190000, 1954.62344549393490000, 2147.37285411577840000, 2216.41504312203600000, 2115.42180989337110000, 2021.02741544246960000, 1963.03076064889320000, 1999.26737980303600000, 1970.86577624768280000, 1971.80350783791410000, 1876.86527305819820000, 1812.69453683151460000, 1732.94611680930230000, 1611.25954302338120000, 1605.10031254639900000, 1585.17430823242080000, 1626.33228719955380000, 1600.39465311472210000, 1559.05964590534810000, 1491.46563887112480000, 1503.69171066653300000, 1499.97883947845750000, 1634.16761065659010000, 1653.77348773866990000, 1596.93425772634530000, 1530.80327859955420000, 1556.34657214815180000, 1561.37036172072950000, 1562.97678929129800000, 1582.04495304351600000, 1553.49452905326510000, 1604.63712987381880000, 1578.23557561642540000, 1529.40072342438380000, 1507.20290195272420000, 1471.89681255867030000, 1474.39718425919820000, 1467.19664761008330000, 1503.52712276136780000, 1458.48615991483710000, 1480.12142178833640000, 1475.90955777517570000, 1470.11256782765120000, 1476.61244839380610000, 1467.88758899387150000, 1480.45656837916090000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1445.89742966269140000, 1352.00309995403750000, 1338.38036705200780000, 1540.64274511561260000, 1500.13195539575530000, 1486.30311671078490000, 1329.03865698589470000, 1322.07034322495700000, 1337.62738551458280000, 1323.31527502850300000, 1312.98043598780150000, 1231.29085472654450000, 1236.25894816179860000, 1305.64744097662810000, 1321.46151759102620000, 1307.24117652989300000, 1317.97992267216410000, 1362.38575305857280000, 1365.75130514874290000, 1341.02256023485510000, 1313.17653559797370000, 1295.93574743768360000, 1260.53928115994310000, 1290.24916295114830000, 1247.93333431172070000, 1190.04065791500620000, 1165.83981721217740000, 1148.72333253587070000, 1162.63937821473060000, 1183.49979878500290000, 1185.05211306512070000, 1174.77158031880840000, 1184.06157207045770000, 1184.52499641202550000, 1184.25218789942140000, 1185.43025819004150000, 1184.41369502625430000, 1181.01593359169740000, 1194.01384179025100000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 890.72217359695446000, 898.71025704912142000, 952.50086716255942000, 883.78885653870748000, 873.28991010481002000, 804.58825858647072000, 852.55503739423955000, 723.80809892683385000, 778.73049667588339000, 703.04349596491693000, 691.75633912738022000, 636.08228935108855000, 490.10497706187630000, 500.73457820973431000, 552.42302051312663000, 490.13857378912428000, 643.89810812045346000, 654.10357758251337000, 653.22996723914787000, 667.34884315867203000, 665.63717717583756000, 719.75959822115840000, 736.75193701408330000, 748.78653011841027000, 751.19021168179825000, 799.47320681059250000, 800.01772302688323000, 843.88099333608341000, 891.58321586549482000, 881.60401930336445000, 889.52806499182657000, 887.86555446188447000, 899.18480453113204000, 911.77836127706678000, 918.31556233320907000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 226.17726904397423000, 247.31719002027873000, 255.33494541457173000, 228.20599656794136000, 168.14381385499411000, 8.23861632927581590, -9.27373331556071530, 29.38241895220844700, 50.81139838655835900, 15.49058968548671400, 89.57475859266678200, 119.47153087540610000, 140.26804143588515000, 147.50380980759343000, 112.40706913924605000, 109.49311062052290000, 134.17686329522837000, 155.76192609577717000, 165.47544266953591000, 170.58409448995781000, 175.73376468590163000, 165.06512353431927000, 219.26009379510478000, 237.69604466551709000, 227.22143627437114000, 273.63161474758942000, 264.65813995826409000, 261.62652243215723000, 267.36333710564725000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1822.76316747309530000, 1655.03814221178410000, 1670.13452614341690000, 1531.73041998310490000, 1571.48348319877910000, 1535.35950962948190000, 1676.84009880973620000, 1764.80508074087700000, 1704.05536543327640000, 1876.66851356160330000, 1782.91042187709900000, 1839.50532750835620000, 1920.62088416336560000, 2017.29307658748210000, 2065.70942428884380000, 2065.89052875986270000, 1988.27928244137090000, 1987.16999009017560000, 1967.58067750863600000, 2009.06848993209470000, 1906.10457632818980000, 1909.27686212906560000, 1844.76021375792630000, 1905.16253162065440000, 1878.31451304230180000, 1919.85498585224470000, 1952.10005057036620000, 1983.19488079976280000, 1965.89660865996300000, 1986.66986010728400000, 2012.77107906702580000, 2033.45183117123070000, 2085.27516541473780000, 2082.24410048917530000, 2084.48670235875530000, 2092.71206854404140000, 2123.50657361050710000, 2117.93139080118090000, 2120.53992617795030000, 2102.50497149034160000, 2088.81048769209060000, 2078.93949660659930000, 2049.46608717325990000, 2054.94651433472110000, 2042.88050066194570000, 2035.78299671550550000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -445.29356969188859000, -488.87748516666289000, -415.20509760157097000, -449.43933338568837000, -418.20133219210231000, -417.79178989061302000, -417.48727419779408000, -421.69721550305968000, -392.92797680758679000, -382.96441518475990000, -388.42136556394968000, -442.02802209650753000, -456.75713071774811000, -442.19346338921531000, -443.79062541272941000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 757.05313460988680000, 725.82171965014550000, 709.51027823982758000, 701.70193224819593000, 930.85718216904434000, 995.12270316559693000, 917.69002359949752000, 919.52318082668205000, 906.63130676483047000, 933.03169884622878000, 922.99962771573814000, 956.40928561441604000, 898.81125632013629000, 887.37614695631987000, 895.11809702300445000, 899.60384358079602000, 906.70941425828210000, 919.39648430736270000, 914.55206815876443000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -155.26608677585648000, -145.73603544662876000, -144.18426239141581000, -169.89377000616363000, -121.31742238890791000, -151.75148566496728000, -166.76160320947113000, -181.94594347421372000, -196.05124608232546000, -194.04426508489848000, -187.46626936872281000, -237.87644281088527000, -231.17778468880542000, -241.30795815500926000, -262.02324283095879000, -263.17616140425724000, -266.74467759526732000, -257.83750848190198000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 970.78373763532750000, 969.17256519191642000, 908.74034773825122000, 1021.78738452123420000, 1406.77880911605690000, 1582.90178447735550000, 1624.16681514044900000, 1821.80242995208660000, 1777.13830417726990000, 1790.43989024122290000, 1761.93228492101410000, 1775.73793141605370000, 1793.29467720872090000, 1847.20637293212460000, 1845.36130045082250000, 1831.17492086848530000, 1764.76716142585290000, 1778.08688781833190000, 1790.97140763266770000, 1811.57223851028900000, 1840.95183813576020000, 1782.51154271590780000, 1770.59373351544200000, 1727.55071444939810000, 1749.15329691900730000, 1726.97006470060610000, 1718.97682945289850000, 1726.99426908144760000, 1745.02703144590830000, 1813.74418021411570000, 1791.55075032218910000, 1798.02198488395900000, 1805.97456947499110000, 1834.21668525438580000, 1819.17760204578890000, 1823.24322944434430000, 1790.55761010267470000, 1795.82150590878900000, 1801.29247410880570000, 1806.82430506934450000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1846.47124830953730000, -2066.15667869288840000, -1918.86488292469700000, -1891.35039101773050000, -1813.94398919976920000, -1630.36235467864160000, -1461.17883258631330000, -1372.25226434858470000, -1314.90806910142490000, -1235.74972688263030000, -1326.44556559524200000, -1119.47956943058330000, -1214.11916212484930000, -1174.57458018151010000, -1220.70983559984440000, -1202.19804436695400000, -1284.43482022217970000, -1230.48823504524720000, -1208.98804472823870000, -1172.36313002389350000, -1189.06310948516530000, -1383.28982982317230000, -1485.27993809134270000, -1512.41076987065960000, -1547.73276836984160000, -1580.08153015371450000, -1582.26466336827140000, -1607.24445799360930000, -1612.70067186366900000, -1549.63425553811570000, -1562.47469885036410000, -1580.34115276271500000, -1565.81021172143910000, -1549.09009803352710000, -1598.91732643032400000, -1591.56239553617340000, -1551.78891204509340000, -1483.71424567332970000, -1444.59505114333140000, -1417.90218367504100000, -1448.52721914110130000, -1476.66678139053150000, -1484.95229444296930000, -1478.39286322330080000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -728.42533185127354000, -779.89520351296369000, -804.97702923763791000, -791.16388296465323000, -941.48579091034605000, -941.12233535910582000, -975.48919534907350000, -991.43421104269851000, -1055.52845072597620000, -1054.12430287022520000, -986.13282174488074000, -999.91919706595684000, -1018.13839383586170000, -1020.07550421508650000, -1015.44565844222890000, -1035.99759946325250000, -960.01701385591059000, -948.56772977885316000, -925.97766854702672000, -905.32447793086840000, -918.32995118276699000, -907.05159340925104000, -902.47612453738429000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -365.53042783310548000, -379.15228293425611000, -415.48293976643333000, -403.43014573047685000, -420.20220014996005000, -436.89772997454600000, -404.50151159115518000, -481.49814948037465000, -528.07053257734674000, -554.04702268908545000, -583.74533006767126000, -563.23627261877152000, -568.46201831374151000, -534.08949709703722000, -543.96239824947850000, -524.18377853526044000, -510.15132236699139000, -527.09455838368342000, -512.14083361192195000, -497.49968447753366000, -486.34041594603747000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1581.71077237228680000, 1491.01353798667260000, 1702.66365735467120000, 1418.32949185542470000, 1453.96407589339240000, 1646.55705623317700000, 1598.15055152383390000, 1555.34521864637260000, 1466.53241118445640000, 1511.24511615767960000, 1154.52871616263110000, 1325.50394023435050000, 1190.78714122258450000, 1247.55579705012700000, 1230.94750363485600000, 1219.59993611623100000, 1127.48840962322670000, 1163.16509817939300000, 1106.55303773257170000, 959.70099503288873000, 1008.43131985475420000, 1074.66230628564540000, 1123.98950641789320000, 1082.56139704056340000, 1142.19369949895530000, 1129.59849333404580000, 1143.73282497390910000, 1138.57985066616490000, 990.30945093534331000, 966.10730440990767000, 1013.53961640179390000, 1010.18125518689420000, 1027.16505632061940000, 1000.77273799467240000, 994.95100654390251000, 974.79071189969886000, 960.06352308014800000, 964.76598790553408000, 962.10569707717673000, 1012.22120297967470000, 987.78094772461463000, 1003.20471280649840000, 1009.23379400832780000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -186.10778249824369000, -171.90975293935816000, -175.34533263839057000, -248.16562712785188000, -280.49381083057835000, -288.99583474530618000, -318.57178417464678000, -305.09677513662484000, -279.60189147479679000, -289.53126196345755000, -303.47588295219288000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 351.91104695486541000, 300.01804902370060000, 293.73156544042240000, 311.48077332543573000, 294.09357597834673000, 334.87378189477533000, 382.34158398541166000, 356.78802193795048000, 350.83754160736368000, 297.98981429440818000, 327.64748035486389000, 322.96961198205639000, 306.89775208470650000, 344.16359841514367000, 330.52575557119206000, 310.66390657118586000, 301.91547438019523000, 308.54463757827597000, 307.19551791618653000, 305.43328932091896000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -300.05275212462527000, -302.59397966387746000, -318.48232529646873000, -323.94933292636921000, -322.06043993364659000, -347.65802255327287000, -345.21177943848937000,
3004.96696470083360000, 2701.08453329286520000, 2713.11096155281350000, 2348.56367699896420000, 2227.97638202916690000, 2102.68222469721330000, 2237.88149918714320000, 2265.44199657537960000, 2114.61391107622740000, 2139.05401227474570000, 2156.65378427090760000, 2174.75575992473520000, 2317.19945068026120000, 2243.38120686572890000, 2388.10786425631750000, 2393.65386464791300000, 2448.27464391062220000, 2452.95434879592180000, 2503.79003544721630000, 2409.10360899743860000, 2420.31741556216180000, 2444.28880444749120000, 2474.33199264124730000, 2472.41686848061680000, 2444.92230070416190000, 2408.36480897373990000, 2455.74192533088900000, 2662.58737426426570000, 2649.35186981333250000, 2707.75692513365080000, 2706.54700067736890000, 2700.04698007639670000, 2691.95121802911940000, 2680.48741307128970000, 2689.92962856902430000, 2691.71854320055580000, 2721.96132138211260000, 2736.17353962906510000, 2745.52035467068030000, 2728.86470235127580000, 2706.18775861951280000, 2702.39499434691920000, 2705.16226940408300000, 2696.08053773494110000, 2687.28831468608090000, 2675.38842237780640000, 2707.96852985411900000, 2707.63510036550130000, 2733.91384592360420000, 2721.18192463505370000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1672.37870995824640000, 1541.13769648941090000, 1555.48925126059840000, 1536.23862544286730000, 1526.19156201622310000, 1537.48480224188420000, 1436.00470197356480000, 1435.91876357235510000, 1473.96655256285090000, 1694.50307426823430000, 1625.20622013118100000, 1568.37194182374810000, 1479.71966815777640000, 1417.62519894081740000, 1515.10117699338980000, 1500.65031455340000000, 1525.17213418164510000, 1505.54523207323590000, 1526.13718334930630000, 1453.18303370631770000, 1431.88879797603750000, 1435.96058658965900000, 1444.99513515782180000, 1413.32529431432950000, 1420.35564181049990000, 1452.56609294323630000, 1437.33876851402420000, 1460.55187700429860000, 1483.69594314127240000, 1467.63027053680660000, 1465.14478163099280000, 1479.94448176259860000, 1471.31289243032850000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -186.96620809941263000, -176.20866368559339000, -176.95111806686279000, -181.00750582977815000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 534.68718450238566000, 652.37279586305669000, 608.54620866970174000, 569.93744312801209000, 678.99706185451521000, 604.02297690304715000, 680.04010602684662000, 858.77044701315026000, 626.81248435900238000, 545.48085115172933000, 486.46294008986325000, 532.35104798342013000, 341.07037169915282000, 375.48991824173396000, 364.76199469894107000, 345.39672681969171000, 366.91755038965937000, 384.23169234569093000, 414.63078948913824000, 401.76063716593109000, 373.96040926482777000, 371.90361090283233000, 364.37144159604304000, 344.32001335903885000, 414.28877697722885000, 417.98104012934886000, 423.34950501412288000, 405.98855909118492000, 429.13830459862578000, 423.50514785232463000, 418.83852416851806000,
0.00000000000000000, 0.00000000000000000, 2270.75794032273010000, 2152.27222045311870000, 2155.11780959527140000, 2290.98420156930300000, 2247.80667448376150000, 2199.46003522767930000, 2408.45830522648110000, 2237.98974493152580000, 2280.14520556434350000, 2185.00602775255170000, 2052.30778814016090000, 2086.74478138382030000, 2012.82810720822750000, 2114.56419341340420000, 1989.62887852061160000, 2191.47100535753410000, 2206.38664958455460000, 2114.56672722555140000, 2034.16189374209350000, 2055.14577346606170000, 2053.76376878215430000, 1925.17504011685420000, 1939.38424250848360000, 1941.66454710569970000, 1862.67881007907730000, 1876.77274953919120000, 1902.40992046313500000, 1961.58500156524630000, 1886.64329023654520000, 2050.61408651062630000, 2011.86250913206640000, 1978.57741297245480000, 1993.86929513542800000, 2039.75895069510370000, 2079.84862549855920000, 2077.76164645409930000, 2079.13518291620360000, 2109.95062921244830000, 2120.48396019952000000, 2128.97021762591430000, 2112.59177186059200000, 2131.26943148247760000, 2123.33151664007260000, 2145.27536484738310000, 2155.30658250860010000, 2156.70412895965090000, 2169.48128085254800000, 2156.22778061928970000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -343.51904687949400000, -379.28257155991110000, -344.44976426443878000, -310.57021371273606000, -351.65719734765764000, -350.24798732862104000, -380.16875756132561000, -417.78675575266823000, -410.30204034119589000, -385.14401971150755000, -380.15410645213620000, -389.77443168383718000, -382.77052343590594000, -397.14771766798992000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -200.36845257809304000, -201.87151809824167000, -193.02765994644801000, -218.11604916567589000, -210.76321052908602000, -219.95382648699609000, -254.80586333797245000, -267.01101985348868000, -268.47153707264169000, -269.34970629431734000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1422.72265862800550000, -1177.95290618268840000, -945.04553952515187000, -949.21861333200320000, -665.40276973452194000, -603.43546427090564000, -630.43960697752243000, -634.46050762748723000, -571.05771089419534000, -475.22529861919185000, -400.04810721045260000, -287.37156897662800000, -627.81269092221510000, -788.14508341765111000, -800.47300712113099000, -843.47098400477455000, -814.76374197518749000, -984.36638168554623000, -957.70006903916590000, -1044.36871626331820000, -1069.12047450014710000, -1268.80818390048880000, -1394.64256551558060000, -1337.93201692228690000, -1270.97283839084320000, -1287.99583504600450000, -1311.14878556416940000, -1336.45514022064440000, -1353.74364123278450000, -1382.86073838928310000, -1494.88352510485400000, -1454.36440773850930000, -1391.16197825405270000, -1412.36515709386090000, -1408.36507772134430000, -1380.48233124588340000, -1382.84848372663920000, -1393.83125543121490000, -1397.37738477410790000, -1408.05970729940690000, -1419.22287114114510000, -1372.20757336611930000, -1376.17961281476460000, -1373.15514042446100000, -1359.62124558989190000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -144.71959333200797000, -201.97097189818135000, -199.56487970718629000, -109.48375894403651000, -152.26952034446754000, -177.09123098591505000, -157.26286306460099000, -155.80456942765807000, -151.89195871084837000, -48.98090999734164800, -35.47710377165628900, -19.91505055415363400, 12.73589477817238300, 5.53388665560330930, 34.21911536329904600, 36.62551091264456500,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 93.17706899358985600, 87.22199138099406900,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 1203.73047956790470000, 1337.63556639078180000, 1417.29290575543220000, 1332.06808616182660000, 1215.88774404892890000, 1449.60807260850490000, 1491.48122323634170000, 1421.39529158711340000, 1389.98308506549440000, 1386.76433351835360000, 1359.73641925703900000, 1196.43651434075950000, 1273.76037405851640000, 1251.94620287981000000, 1256.49614464503380000, 1115.83507839100120000, 1030.88777794506810000, 967.60542356539736000, 925.98559083356986000, 1070.06060082045450000, 1052.36233057190270000, 1110.95330657525550000, 1091.43082636504620000, 1132.03460357037970000, 1189.99500882175380000, 1215.08197215037010000, 1201.22402818663200000, 1182.83433505882820000, 1128.28771910060250000, 1132.50943406769810000, 1149.38726774708150000, 1175.46682491727870000, 1203.97823596790660000, 1205.34173122739680000, 1241.20642493681930000, 1228.21891517581160000, 1222.14911447346190000, 1232.75015919849870000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -451.29217479753947000, -547.07197875678287000, -568.98081564477104000, -507.23170903658644000, -427.26565472341872000, -398.43115819574177000, -447.13800793453055000, -473.38708211236599000, -410.08695160187784000, -395.00977564189583000, -454.72206910922091000, -421.66708063652578000, -370.53478293268466000, -366.89017091719427000, -389.85437391938615000, -382.41535206230378000, -378.91596187681421000, -433.72986431233107000, -443.77647287118378000, -450.24320281044049000, -486.92880679366192000, -488.75014448674114000, -472.84649984292378000, -495.63244782778042000, -484.41084333846027000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -97.14421217022160700, -118.61828064950910000, -111.19284010989490000, -120.18413406749148000, -123.80266372004924000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -318.44110949294611000, -307.53313734433578000, -203.90556726795489000, -204.42405565890382000, -239.62936731200580000, -236.70941138616496000, -235.63286136505661000, -225.84169048224879000, -232.30869482847135000, -218.47368361969404000, -253.75230087932403000, -288.47516634731454000, -275.51315767615046000, -273.83470610833484000, -248.82237938464820000, -222.81123348945465000, -231.89083557055008000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1789.82780116590240000, -1991.71738211320640000, -1858.39065037301430000, -1924.20483733509240000, -1813.79374294020360000, -1717.06913407300390000, -1748.88588332878020000, -1722.96836909199330000, -1484.88602646177540000, -1487.82909099078480000, -1477.95944349536420000, -1461.33700699470680000, -1452.60037789462130000, -1543.55139752571970000, -1757.70384065081090000, -1644.50670079984660000, -1715.80845357728300000, -1595.07310473124950000, -1603.73043673238480000, -1666.59489307954530000, -1713.09810552980550000, -1829.86605188021210000, -1891.58569960451790000, -1923.66534375342440000, -1824.05334286844600000, -1820.10556665942680000, -1817.19620234993540000, -1873.89253820985780000, -1984.76985465993240000, -1978.08858760278390000, -1979.80235277165120000, -1991.00948683509050000, -2008.31343217989960000, -1999.44922236382310000, -1992.64263047851300000, -2002.11834061269750000, -2017.55225881036900000, -2004.50101046335910000, -2003.41091760235260000, -1990.94994146943190000, -1981.84573876312400000, -1967.98924386053730000, -1972.14941870134700000, -1960.85297217442800000, -1965.91902974139820000, -1969.43188385635060000, -1963.43489132382890000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -700.02088908839085000, -610.11366655108816000, -658.45338262983398000, -649.70249160795390000, -608.14952452226044000, -569.65709379275222000, -518.92055321239707000, -605.78448669303145000, -677.35326977971795000, -670.80350432640432000, -647.23203323236498000, -590.80060209423607000, -688.14949214913872000, -642.45963504700387000, -622.08762826380939000, -668.37762491370995000, -688.46376897199184000, -697.21604428543310000, -696.72304113642406000, -752.21601036744335000, -762.65804022081966000, -819.85767545660065000, -812.54322111756744000, -822.47207359089020000, -869.98000759607692000, -859.28337262894479000, -871.02864691098421000, -946.54780553227022000, -954.72358943830818000, -947.59907139582958000, -933.24493588047801000, -934.83326780280322000, -942.57261015914298000, -944.28045692604815000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -761.38323241135356000, -712.82178382395693000, -773.64082739718140000, -733.37530759358833000, -575.77799284343916000, -571.06947891315701000, -553.91600846326537000, -789.29502810534518000, -739.67286468328973000, -718.18324099134270000, -713.77724956995110000, -611.05480530214288000, -619.40367607779797000, -646.12268125233504000, -635.67719279421169000, -642.80105174829191000, -614.67336113843078000, -645.96438775464037000, -616.26732847621508000, -585.27386884394139000, -570.35466582878507000, -567.21745408604988000, -542.67509663433043000, -537.80405599615017000, -539.90668646879374000, -506.67983001841264000, -477.77371362306769000, -475.18766925705182000, -483.77494168439449000, -472.40622198618780000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 976.27157612070482000, 1025.96706062904350000, 1148.91081038406150000, 1303.49956666018620000, 1131.67776065513020000, 1171.08756084756620000, 1234.66190700704210000, 1268.29379208549900000, 1674.43814618317400000, 1521.15197854761820000, 1476.67487480909310000, 1406.75921124987240000, 1409.77640181516650000, 1292.68214681685710000, 1282.63999073810830000, 1263.07348740761540000, 1306.42802000228520000, 1161.47490359398600000, 1080.54392729091000000, 1078.42141067446890000, 1035.37751755193450000, 983.41068759515952000, 1037.94657141214880000, 1033.10430409993230000, 1032.79789617687150000, 997.82461348747745000, 934.15053939603115000, 927.43797940900049000, 941.78771951583747000, 922.93342863718715000, 916.52000844056545000, 907.20405728563117000, 907.48009112449870000, 928.09523770101316000, 918.02911070077948000, 914.22681739116433000, 927.28747055911276000, 930.78524132795303000, 938.83654315299350000, 962.58358326628002000, 972.97166666522435000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1636.20624634422870000, -1472.40039724194910000, -1431.18174705405360000, -989.41876567805093000, -984.23163451021730000, -972.69972908763259000, -972.85277157884991000, -967.47180377783161000, -954.41868134142260000, -1098.12089136683040000, -1171.74363701962370000, -1221.80197982213460000, -1222.52326702107190000, -1417.86742091120370000, -1416.88832054265690000, -1470.93811254935580000, -1433.23724774714150000, -1366.87972074839880000, -1350.77624119532560000, -1357.10781537306250000, -1352.85751126983680000, -1366.06217940497440000, -1349.58837088687850000, -1367.06577801488790000, -1373.92663083567820000, -1397.43602196174130000, -1348.56468594187090000, -1351.58489650162550000, -1348.88759714151890000, -1319.39201684287600000, -1307.15540380064610000, -1297.27408587045330000, -1288.17269736467050000, -1293.73418084420790000, -1288.34591899382550000, -1289.94154047079270000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 88.10304987100866500, 83.20939535862670800, 90.50556338780984300};

double lasso2[2600] = {
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 90.33902020867478200, 122.70798506974135000, 243.20530461583570000, 246.40231341803522000, 405.80632090818909000, 429.07655234109262000, 490.52835871922827000, 515.77707458381542000, 539.27929008058049000, 596.25436477379185000, 710.03161360472473000, 839.24164717965198000, 847.90009262147464000, 880.70866141670604000, 966.13404101197796000, 976.26163475660917000, 988.60031162580265000, 1020.48691328642580000, 1030.82951058862730000, 1097.66524888450270000, 1106.10947751183720000, 1119.89375484433820000, 1121.10880761880140000, 1138.17532157283770000, 1140.91709749475420000, 1166.59836835119490000, 1169.79739937354840000, 1190.88260565313680000, 1195.61816829744700000, 1207.82604164872100000, 1238.48630275539740000, 1238.50404703243270000, 1249.66659754230860000, 1259.12074320191120000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 70.56698000315188300, 79.51362112605178800, 95.76822514326364900, 97.16659597350107400, 117.48939865754279000, 120.55881565069100000, 170.53192438099842000, 176.28797484502655000, 215.14729348108835000, 232.33273478954578000, 266.84643050855777000, 355.00549015592071000, 355.06678799892046000, 391.51615553109650000, 426.28744142280385000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 43.35874943415483800, 108.87299898439686000, 125.35798573060281000, 157.24553687756946000, 202.51882826967875000, 278.39172144009297000, 338.33163700212924000, 352.99375315154583000, 353.34330940607066000, 361.31088139914101000, 412.28818144063860000, 431.15151999575085000, 496.64461352688886000, 498.33207609597059000, 555.22998775280394000, 562.49368767662020000, 572.78134167361486000, 577.59068676987795000, 581.02102960440538000, 579.41923013635630000, 581.98500811289318000, 597.75912429168875000, 598.12636160567808000, 599.25583182906939000, 599.45742902140705000, 598.65951162466354000, 597.94427181510332000, 599.44246965321861000, 602.04628054370698000, 616.64196623472424000, 619.15682362299844000, 619.92946627204617000, 620.03441749016451000, 622.13677677876308000, 621.79768345643367000, 611.42685568980278000, 610.07789754477005000, 599.33847084595084000, 599.41238846026988000, 601.46002454003406000, 596.31870531231209000, 596.31666856978268000, 596.88922365709197000, 593.95022096418279000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -59.77235596102511300, -85.64454387667339600, -110.70291411292055000, -153.81175400394116000, -239.35022266063285000, -332.48393291949037000, -339.28919970800933000, -375.98076682115550000, -467.70965360991090000, -477.70942977287217000, -487.71112584101650000, -513.77789911521165000, -520.51926126634487000, -561.11859439703551000, -567.37035013414061000, -584.58329608621489000, -585.69800662102227000, -602.84049670821071000, -606.46015799046870000, -641.00131374421073000, -645.90078562908650000, -692.25941740796304000, -709.36619409107504000, -740.78716135690229000, -811.67389239546674000, -811.74185819951049000, -855.48639414955380000, -890.70987302035030000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 77.43548218503639200, 182.52616104972708000, 189.27056947775759000, 208.71398593467313000, 259.99983911054267000, 264.56472116943951000, 270.18426338145230000, 272.39325977369265000, 268.61220831467261000, 254.99790671359543000, 252.22845665739757000, 250.57812927429555000, 250.86331527645541000, 255.26591992225264000, 254.82728012573381000, 261.64405191834891000, 262.01607029894780000, 270.89234713823043000, 278.62697134501292000, 296.27382736906412000, 333.48089735111824000, 333.50299512972612000, 346.12441573341084000, 359.17793171235968000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 5.73605847073728100, 6.77922744964299360, 19.06823949719247600, 20.67860101443924100, 37.09458163225870200, 43.46043270536780100, 55.41684668310790600, 65.74099337975793800, 65.76408966347528900, 82.89054557243440500, 92.59916798784033200,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 21.46848522513756000, 72.48166545023818200, 87.86605276335753000, 94.84972434646145700, 111.22855340110628000, 147.58851000748251000, 194.82577948630751000, 200.19803463239799000, 204.25554211091378000, 209.48389351802629000, 211.25400083051613000, 212.88014249877762000, 210.32720235545384000, 212.25729587898468000, 230.78580890886946000, 233.29446190962685000, 238.29990676496078000, 239.28863848826444000, 254.03738718408664000, 256.51824186358277000, 289.01344814642312000, 292.74575251794943000, 314.92186532776196000, 319.18955975744041000, 332.21979062323470000, 346.40059317612986000, 346.41977601713586000, 359.63965866596737000, 368.70790891238170000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -4.32906103020914300, -37.29551692051062900, -40.98705939290096000, -71.55443074954067100, -79.03615683579259600, -96.48888952563874000, -137.86049737600487000, -137.90315253390477000, -170.63940693043602000, -187.46326866300174000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 32.05697400441985000, 95.21815068453725000, 217.39022772903553000, 361.15310779189110000, 370.85146617653368000, 413.82863043712501000, 525.69288883855359000, 538.19692585630128000, 553.88732549287693000, 593.82087390135700000, 603.70401018541213000, 666.89442043021552000, 675.04027322404283000, 687.20952597554867000, 687.91765722314210000, 697.80472683091352000, 698.90670300371335000, 706.94050377419114000, 707.37251403315827000, 714.82073268857675000, 719.99167040154202000, 731.66901251077070000, 757.81485472126644000, 757.82534047676506000, 764.07869540792728000, 770.00851563783624000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -109.66767836674514000, -126.22353622673802000, -163.10419940618556000, -176.50018715113379000, -192.10030692718473000, -236.06762056511008000, -307.17932273889056000, -394.63522249158916000, -401.37720335206797000, -427.90444620775452000, -495.01957758796800000, -503.05674395259382000, -513.75229380909343000, -540.77747568340828000, -549.95081792120754000, -604.49392174785794000, -612.73572269492195000, -626.74968960590672000, -627.74162084111333000, -642.12606634297697000, -643.78240499834192000, -650.95858981054926000, -650.75393328761061000, -645.89554501794851000, -643.23964356947636000, -638.56809629039788000, -633.12709620959413000, -633.11510378399043000, -627.17950637857314000, -619.18136083599859000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -0.06137639238468912, -47.58194498657538000, -71.37329466746896900,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 107.34513286933682000, 169.53219223222445000, 181.55885814462616000, 181.90083238313545000, 188.59198981507120000, 246.66071196901086000, 271.47100854877431000, 361.98945197785207000, 364.52809459270782000, 472.75205507192078000, 489.31813950114719000, 521.45718273628449000, 530.68653076233545000, 539.38085635263099000, 547.04213799338413000, 554.88621838720883000, 573.50422479258532000, 576.01686372378379000, 568.36084550995679000, 549.34831267649690000, 548.32731690382445000, 546.71190285694422000, 530.79847848876102000, 526.62925960932716000, 529.33619602982355000, 528.22825964190497000, 525.84957716782765000, 525.71849727166000000, 523.79851514610766000, 523.18591060406561000, 525.71059231779691000, 526.61431987581682000, 528.57882442627727000, 531.45065920261561000, 536.51548220254620000, 539.83844259872103000, 539.84281981083006000, 538.08732876826923000, 544.92860898909771000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 7.08422765979233660, 20.95578559669958800, 21.65099939154539400, 32.33564745771620600, 33.41068733487295400, 36.41510397646560900, 36.62556766643616200, 37.16599964707209800, 39.55418913795691100, 46.86396118445325200, 56.73970165654311200, 56.75246194149722400, 72.50328746711815600, 71.57836425441200800,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 2.90582509699859460, 23.11534220878538900, 28.71057415149519800, 37.34323145103820000, 51.40005049169870700, 51.41537984127172200, 61.19285214823689500, 69.22622341627932500,
0.00000000000000000, 328.06190151981588000, 381.29503088332945000, 748.46322696054222000, 788.71308231663465000, 913.63963503026889000, 964.50794243408802000, 1138.46568971196760000, 1181.87404537410910000, 1238.81212789135880000, 1253.59384474984810000, 1277.27188725215680000, 1313.36638676770490000, 1369.68203357772150000, 1402.42175312007630000, 1408.71279115982630000, 1408.86472858486600000, 1411.05171479862290000, 1429.31865495236680000, 1435.10470065274940000, 1461.24789255885480000, 1461.85831279155400000, 1481.67528290441920000, 1482.04623360394110000, 1484.13635737795470000, 1484.81661191826540000, 1490.09376769737010000, 1502.69105200044600000, 1517.92024743714410000, 1520.99611134414480000, 1521.72755879890220000, 1525.02068233446110000, 1533.85664126476540000, 1535.59442496860360000, 1536.45962527241550000, 1544.19398368213520000, 1545.54321059167410000, 1541.23834638102330000, 1539.46527540477310000, 1532.51400833134110000, 1532.00003536148100000, 1523.43884935976960000, 1522.94312641041730000, 1509.89034197297590000, 1509.07723254992110000, 1502.06505116988430000, 1499.17330244691060000, 1494.22600188969750000, 1479.40319056712130000, 1479.40409640354410000, 1478.26124162221030000, 1480.45656837916160000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 45.91288168902228500, 113.88157849905518000, 218.61206693712768000, 303.95186182918445000, 322.29384006850057000, 322.83930087781420000, 333.71183299383858000, 426.75185475324486000, 460.56755111990265000, 578.51590637552806000, 581.73791461549195000, 714.16584321020412000, 733.94763696274958000, 789.15193430916429000, 812.00858067185152000, 829.50708806256671000, 867.10142882972912000, 947.13671320186450000, 1047.08225381890340000, 1053.16426474856440000, 1074.76345717591880000, 1126.25106826039270000, 1131.09381662364380000, 1138.78657937767840000, 1151.16867119598710000, 1152.70934915869130000, 1156.21097077416830000, 1155.82090347039160000, 1156.52237035279360000, 1156.76095305637140000, 1160.49850276547390000, 1160.85384573716990000, 1165.55349987203070000, 1166.07168805320880000, 1169.91533893820970000, 1171.31946291358260000, 1174.19085695189390000, 1178.03189413564770000, 1178.04563757140890000, 1191.67294416541680000, 1194.01384179025150000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 13.65814964925465700, 14.07288967622387300, 24.21311513140698300, 105.13005453803142000, 133.64751884535616000, 225.37347132650206000, 228.12484200861039000, 329.18251244504643000, 346.21561520312923000, 380.67151722157132000, 394.02907452734610000, 402.58176270652604000, 409.31781292750139000, 424.09027078216127000, 454.73011539694267000, 455.46276289795929000, 471.11606752192785000, 513.71448588692704000, 518.74574182799802000, 525.92846254350729000, 541.77763857664502000, 548.83189296722571000, 598.94624422534184000, 606.75214969984597000, 621.61156046803683000, 623.18453146317233000, 646.54599290498629000, 651.45885106124490000, 700.08496150940505000, 705.04297998776565000, 744.04610235753057000, 757.06198323624290000, 788.22766124337295000, 857.75989625749810000, 857.81197019270712000, 898.41796414614930000, 918.31556233320896000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.99221268716260191, 51.21183990305507200, 58.94594160840566100, 75.28997800172560100, 79.27699487343456000, 76.76693070888649100, 70.14498202723002900, 63.55797095530467500, 60.51468696352415600, 59.58307926711096800, 62.07448496444966700, 75.43618038191537800, 77.77416956373950500, 81.14454694469361600, 84.69110607527683500, 85.67412508354009000, 98.60879244193488100, 101.58617570181453000, 108.15893670763998000, 108.71101167477045000, 117.56539837869215000, 118.74795297691887000, 139.10204934190227000, 141.79504949632548000, 159.85556542929444000, 170.15247230182862000, 190.87633058999236000, 230.69333660551692000, 230.72487042149007000, 254.19764641678114000, 267.36333710564725000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 54.98394235372808900, 226.42873061215624000, 285.95446038232075000, 459.06025986696545000, 508.48772331972214000, 578.16284182491029000, 600.58747355493722000, 637.55592246591880000, 693.05635901570759000, 794.28984346310392000, 858.10733180169620000, 873.15588575956087000, 873.64673331311747000, 886.00445499236764000, 997.05704863812650000, 1036.73683715995120000, 1166.82453634088730000, 1170.42329394595840000, 1332.94415183190290000, 1358.56209637191840000, 1411.43372176181540000, 1432.81042614746340000, 1447.36622571194040000, 1482.59960842407350000, 1546.54500982704420000, 1635.67393196530360000, 1642.22120387656990000, 1670.54585192670790000, 1739.30177464283590000, 1748.22244880431030000, 1761.00938871224210000, 1791.91646734934870000, 1803.54363949632420000, 1877.86723211166010000, 1888.63104001771260000, 1909.62636348893510000, 1911.51787508726330000, 1938.78719792071230000, 1943.31211935629220000, 1975.54928619581010000, 1978.64290697990050000, 1999.84722362367730000, 2004.33780683650870000, 2015.43563523504350000, 2030.88113924492750000, 2030.88535452361040000, 2039.45850926375940000, 2035.78299671550550000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -50.51607690360815200, -67.89038211452441400, -160.51196347542762000, -175.56358811078175000, -200.52552582787749000, -202.44698297515876000, -230.85599051164311000, -235.60717943758749000, -267.46524796362996000, -270.61999662901599000, -295.52510593795500000, -308.78384442709961000, -341.23245297690084000, -398.05159444140202000, -398.09092703386915000, -434.18951779134198000, -443.79062541272958000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 62.88832553461004000, 217.21532884381122000, 234.96864098452551000, 257.52816262140919000, 333.91359202797935000, 360.12039009139329000, 508.81256716174818000, 530.20847019634323000, 568.93386898906317000, 572.15387362488025000, 618.50416275182113000, 626.91665893987931000, 681.97636407745802000, 687.58666159299844000, 731.46215413740276000, 746.67923477926672000, 781.77176249315016000, 859.22461786612462000, 859.27219587572358000, 899.22450705098458000, 914.55206815876465000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -36.14503372489376400, -40.09714264611371700, -45.12818644343416000, -59.28214743267411500, -61.74089444054467900, -85.74483935472667900, -89.96539457277850700, -99.42811333302375900, -100.28262799877164000, -112.66949298797095000, -114.53163580146710000, -139.50943517528898000, -142.01326797550507000, -163.00576691737805000, -171.96700027311903000, -191.96797774608530000, -234.05103406285318000, -234.07148888414440000, -248.45866203459141000, -257.83750848190203000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 19.81425179011610600, 49.96008027663264500, 94.65084880797921600, 173.94816060751035000, 253.52991042387617000, 273.91422388719900000, 274.54695928371342000, 291.26589742893856000, 431.13983955064771000, 481.60302165733526000, 656.63997232403540000, 661.54932151673870000, 892.28446856318465000, 928.46588521638034000, 1017.00285301449750000, 1051.96228943603300000, 1077.14847755242860000, 1131.09480902732090000, 1237.72732016549750000, 1374.73458579275190000, 1384.38123296040590000, 1417.45387658402840000, 1499.66276265466580000, 1507.88093744253140000, 1519.54282039768710000, 1543.07428668937450000, 1550.04612409965080000, 1597.23449901232740000, 1604.93372710134370000, 1626.41560142808730000, 1627.87602195622940000, 1650.35403254500720000, 1654.22836615266740000, 1690.67669529724870000, 1694.18657397273480000, 1721.47123238228050000, 1727.72365546965190000, 1742.65662443570050000, 1775.65588448531070000, 1775.68268730029490000, 1800.30296465312240000, 1806.82430506934450000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -76.13223476380504500, -352.65448557904921000, -422.24473284327632000, -521.92622394529224000, -548.29704612285946000, -582.65683919829701000, -628.37496354720770000, -691.99824662369736000, -732.20835472779970000, -739.92955401905442000, -740.20439847671435000, -744.30267328873242000, -788.52927314268481000, -802.86096879783838000, -859.98611119919303000, -861.48735411021903000, -947.71597903494524000, -958.43004975199949000, -982.62435235640271000, -990.77147628322848000, -997.77789637375031000, -1027.44805604084540000, -1101.43122708425400000, -1199.55387587988710000, -1206.75815437922480000, -1237.77008856464230000, -1317.96640369619830000, -1328.39844976878410000, -1342.14017818373960000, -1365.67922631311080000, -1373.47914788361750000, -1428.64492451511050000, -1435.79052798172350000, -1447.44649198565410000, -1448.78606819047310000, -1467.64827181070630000, -1469.74303974211880000, -1472.57226285431280000, -1471.80809222494830000, -1460.41151375585900000, -1459.33596687558720000, -1463.13638808769750000, -1475.41400956072220000, -1475.41657118117290000, -1479.34906479462460000, -1478.39286322330080000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -56.06180775833102100, -173.02939351318159000, -323.90886429416025000, -333.57698420988044000, -384.07590586197222000, -513.75304527215030000, -530.40433533519979000, -552.68818277216678000, -609.73261227911337000, -627.34592567756795000, -723.02689801622466000, -737.45155758036094000, -766.32788657503795000, -768.57197714116148000, -801.18649897223793000, -807.03236325230603000, -838.01234532613000000, -841.03205932013407000, -858.99093112474532000, -863.18418813617609000, -875.27693354404778000, -893.15917230626189000, -893.16718427934836000, -907.44015361829634000, -902.47612453738429000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -87.27153072197072000, -93.31092677063897200, -120.07372254436052000, -186.03743480699251000, -194.48196623391689000, -206.19911555579577000, -228.69541860194877000, -238.71516879355127000, -315.88020146811448000, -328.28746352406637000, -354.56830197377781000, -356.41371762233308000, -384.42745280744811000, -388.15344360160105000, -419.70535814261967000, -422.55908570815518000, -441.07749723703722000, -448.86217312781514000, -462.73835669497248000, -482.30144142149311000, -482.30491467695094000, -488.06039366018871000, -486.34041594603747000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 219.78535200881655000, 276.26887679027703000, 373.05235715851296000, 394.38706182485328000, 428.03276385690225000, 491.44454585018707000, 586.10030346716326000, 648.66705295858117000, 661.20803126439898000, 661.60636306945980000, 666.93265758771645000, 728.92786057659407000, 746.07410358236871000, 814.63289463586318000, 816.45921714230224000, 898.64973164720595000, 907.32029152894688000, 932.02509758573603000, 939.51908892767324000, 940.23219472098037000, 945.48100482594884000, 966.35600872191765000, 1003.99149838152860000, 1005.61721275943480000, 1016.96260737678130000, 1043.18358055320890000, 1046.80962246955120000, 1051.24533015823540000, 1044.33249383961860000, 1041.23206508217210000, 1033.84706734334760000, 1032.61420068422690000, 1032.05360693682450000, 1031.77696551040980000, 1026.91188213524540000, 1025.61427190013230000, 1012.33999232138730000, 1011.04055414751170000, 1000.69493613498130000, 1001.73808095323530000, 998.67746397319888000, 1001.22532270454210000, 1001.23220946911470000, 1003.04793122016440000, 1009.23379400832780000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -19.14628283813488700, -20.49729084085332400, -40.95429060319843700, -46.11303032240923700, -93.57604278766699200, -98.91374644996314200, -145.35299829891173000, -159.81005497665947000, -186.07883975146584000, -244.30010545099668000, -244.35099277175863000, -283.95288613842388000, -303.47588295219288000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 7.28150167612342170, 31.59909636511290300, 92.62199667685079900, 100.51455820189626000, 109.87118675554159000, 135.39647877228813000, 145.18406396441335000, 201.61442045607797000, 209.38817483311308000, 218.50328021063495000, 219.46852856318580000, 233.14207337733777000, 234.97829699157901000, 257.08874184654422000, 259.09460324461139000, 269.99718568440932000, 272.88583973946197000, 280.70534825639419000, 295.61356570758159000, 295.62201003136414000, 300.59525431410793000, 305.43328932091902000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -60.76184012805443000, -67.36725242498843600, -120.45702884720265000, -138.87339430315859000, -179.04392024108213000, -273.93707248926609000, -273.99836410262373000, -313.79958751529580000, -345.21177943848949000,
130.24806091415982000, 455.92540165373339000, 517.01098785762952000, 889.57360690614723000, 929.94674058947317000, 1055.60460066310880000, 1104.35130195979010000, 1265.68972835711910000, 1303.40933734715370000, 1360.10934851704500000, 1376.36727641609240000, 1401.71922409453990000, 1449.36064816020830000, 1517.27264751904180000, 1573.48684890469640000, 1586.06312035100770000, 1586.46715716143330000, 1595.83002323959230000, 1681.30165971360200000, 1708.32086146059940000, 1805.65965491866130000, 1808.46124478325170000, 1944.21597454487870000, 1964.22918874872380000, 2010.64572641141150000, 2027.72324052598670000, 2042.84681716868770000, 2090.54391727314580000, 2180.84427850626210000, 2306.64631775245240000, 2314.92078801474600000, 2346.91318092750820000, 2427.23601089238450000, 2436.36885127287540000, 2448.62469406092710000, 2476.20233814509540000, 2485.94291179641960000, 2552.67419446692160000, 2562.72048401248460000, 2579.81296748380460000, 2580.93059955941180000, 2596.97728033404060000, 2599.67065710337370000, 2619.19402995104880000, 2621.05395984540880000, 2632.54114153817230000, 2639.36743580468330000, 2654.33764278915210000, 2699.12177801758530000, 2699.14074830922120000, 2714.21181567704840000, 2721.18192463505470000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 18.07096289994384400, 161.44622659960598000, 213.19922034244138000, 394.07517914880526000, 399.04163861298463000, 631.14230458242935000, 661.63805676411528000, 736.40390777216749000, 768.07384021706628000, 800.80821379142992000, 864.25636767469837000, 978.03765945212695000, 1097.81580513198630000, 1104.43308144999200000, 1138.54723764131400000, 1222.84270871716740000, 1233.74541788812010000, 1246.88284327384460000, 1278.56269377938700000, 1285.48371151665970000, 1324.52689057727480000, 1330.33201095970660000, 1342.12825385471840000, 1342.75790550747980000, 1353.00935495870980000, 1355.48792252730780000, 1372.06303468000420000, 1374.48002229940110000, 1397.57002941422160000, 1403.91058863234280000, 1417.33844718901100000, 1452.57205985236280000, 1452.58817574976230000, 1462.83178485115240000, 1471.31289243032920000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -16.92072843665642200, -51.85049168761617700, -122.25499891779668000, -122.30552225337499000, -158.78764388952385000, -181.00750582977824000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 19.84993434521544800, 106.32368456227741000, 108.52687483999416000, 202.59718384305160000, 220.64768870737916000, 257.66705316444188000, 275.80317508598284000, 296.40169223061508000, 321.83110208172877000, 357.97169929211748000, 388.64938414385449000, 391.62276027161141000, 387.42337858523200000, 384.64533905627098000, 383.92829895823616000, 382.06587806040568000, 380.34738460426632000, 380.50133781949125000, 389.60294982631427000, 390.23630258319133000, 388.56188116602334000, 388.41455892712611000, 385.23821882092642000, 384.21951793662447000, 390.30865892152497000, 391.06450339888210000, 397.89007343712973000, 398.62299880312719000, 405.31460670991322000, 415.55193423135444000, 415.55476048499077000, 413.76099231696378000, 418.83852416851806000,
0.00000000000000000, 0.00000000000000000, 61.45289176755488800, 486.75385617363412000, 537.08032155154910000, 725.01000503474279000, 787.79674684952704000, 983.95328708018883000, 1047.24724593139900000, 1128.04129036137310000, 1151.55639076861280000, 1184.37244669415350000, 1229.53964360633970000, 1302.85577393681770000, 1348.68594588403580000, 1360.42976458299470000, 1360.72461056471890000, 1369.70127786511650000, 1448.46341163006970000, 1473.19208937836080000, 1549.88364583128960000, 1552.10017048693250000, 1654.37708599477080000, 1664.63745761479250000, 1691.16747057221260000, 1701.92347285553270000, 1707.60358858303110000, 1720.62335679463240000, 1749.99908828158230000, 1800.51588558608050000, 1802.29797468714510000, 1822.92556839480560000, 1866.90897930336520000, 1870.93600529992320000, 1876.87797743657670000, 1895.35591723021780000, 1902.66822292643250000, 1949.36198236096970000, 1956.12249626829730000, 1971.94793302475680000, 1973.26155441128410000, 1993.83225100776780000, 1996.78889164110980000, 2024.02171988319760000, 2026.73427146531160000, 2051.79577045274980000, 2061.16365761727680000, 2082.11443483501670000, 2131.28301152521090000, 2131.30446240460470000, 2148.93440318190230000, 2156.22778061928920000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -13.61526049908530900, -111.13109582713419000, -123.28579414744118000, -142.55312633548064000, -144.40239876396939000, -171.59669265018269000, -176.78930910457692000, -225.59222199510279000, -230.63739302906703000, -263.30258581309164000, -273.87782755459557000, -299.29243875850113000, -346.27248663144258000, -346.31623602198573000, -378.54812373612219000, -397.14771766798975000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -1.77201645619822630, -28.20719387283483600, -32.31056919550508900, -69.93689586280640900, -73.78343120097119400, -104.68621021994849000, -118.27226894808251000, -150.88873388781488000, -217.06233794216161000, -217.10730167897233000, -249.81427443859340000, -269.34970629431734000,
0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, 0.00000000000000000, -152.44382657824016000, -194.72680177882197000, -298.98674030541719000, -327.87800350970269000, -350.77967283072167000, -355.93652216157386000, -364.65306553309534000, -378.69379562382727000, -395.14654101848265000, -400.31578925277557000, -400.31168467168305000, -400.25876034526470000, -402.71760451298024000, -439.00016863597051000, -452.41962644135413000, -505.88121569495991000, -507.23624647552208000, -604.51138999989098000, -617.89349663609460000, -659.07466316769501000, -676.68147017714966000, -697.60362627710435000, -751.24984271543804000, -846.05452833075026000, -947.50510132564420000, -954.55030172427576000, -984.17290086776620000, -1066.18213859958790000, -1076.55228178745370000, -1091.35768003869130000, -1137.13544106960060000, -1149.70870318792480000, -1214.0