use strict;
use warnings;
use utf8;

use Test::More;
use Test::TypeTiny;

use Types::XSD;

sub mk_type { "Types::XSD"->get_type($_[0])->parameterize(%{$_[1]}) }

subtest "Type atomic/hexBinary is restricted by facet maxLength with value 1." => sub {
	my $type = mk_type('HexBinary', {'maxLength' => '1'});
	should_pass("71", $type, 0);
	should_pass("76", $type, 0);
	should_pass("77", $type, 0);
	should_pass("67", $type, 0);
	should_pass("79", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet maxLength with value 29." => sub {
	my $type = mk_type('HexBinary', {'maxLength' => '29'});
	should_pass("6f", $type, 0);
	should_pass("636b647679747573", $type, 0);
	should_pass("6f7774697171766977747769697065", $type, 0);
	should_pass("686e75626463777362686a726472747078746d656f75", $type, 0);
	should_pass("767261756d6e6f726f707462687963777068676870786c6277756c686a", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet maxLength with value 7." => sub {
	my $type = mk_type('HexBinary', {'maxLength' => '7'});
	should_pass("6f", $type, 0);
	should_pass("7774", $type, 0);
	should_pass("6a766f", $type, 0);
	should_pass("66646c68", $type, 0);
	should_pass("7676726d68", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet maxLength with value 6." => sub {
	my $type = mk_type('HexBinary', {'maxLength' => '6'});
	should_pass("68", $type, 0);
	should_pass("7568", $type, 0);
	should_pass("626b71", $type, 0);
	should_pass("79757774", $type, 0);
	should_pass("6e6e6a666f", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet maxLength with value 74." => sub {
	my $type = mk_type('HexBinary', {'maxLength' => '74'});
	should_pass("71", $type, 0);
	should_pass("6f6f6f697479676d63786c617769736e796b6b", $type, 0);
	should_pass("76796d7664777762686d6c766c726163737377626a686f767761637471636162796b706261", $type, 0);
	should_pass("6362696e6a666e6871726f657373756a71656e796470756866756765766a70706172696264687763716e77776276686876676e736a7762", $type, 0);
	should_pass("696e6d6f6f72706c7170666269637373746d736c6b746e75666e6b72626167766d70646371726f6a636173786c70627274636971786c6a78706e6a726574636b6c6f6b676871677073", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet minLength with value 1." => sub {
	my $type = mk_type('HexBinary', {'minLength' => '1'});
	should_pass("73", $type, 0);
	should_pass("7176616c65796e636b6968706d78727068686f", $type, 0);
	should_pass("726d78636362786866667365666376686568766d78616165736e67756a746f746c79757262", $type, 0);
	should_pass("696267697273796f6275786162616b636e777272706e627262696a726372766975626a6f6d61706c6979656b747962677563726f6e756d", $type, 0);
	should_pass("70736e68776c76636a727873726f6b6e716e6f696979676e777365716473616f647461756b706b7666686f69786c6178777577626f71716568666f626f7968776c62786b7074677864", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet minLength with value 28." => sub {
	my $type = mk_type('HexBinary', {'minLength' => '28'});
	should_pass("72707761716a6571706564686a6873726b7472656c6f616b6d6c6b77", $type, 0);
	should_pass("6e72676a6a6e61776b6f676c76616a7776676e7279616e70656b6d6b677466686374746b6c776e", $type, 0);
	should_pass("696e7270626562767870696464776773686963716b626c6762706d726573786579736c63697573646e63786778696c73776b", $type, 0);
	should_pass("77726365726371756f76706c66686e786a6761766f6879766d7069737376686171646d6466707562676f717879646a7971777765676c6c6478706c6867", $type, 0);
	should_pass("637366746e7564657066636f6e667161636472617368776b67646e6b6e7470627963696162696c6b7175746e626c6f706b787778716e766e646c6168726b726675716b6165746361", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet minLength with value 2." => sub {
	my $type = mk_type('HexBinary', {'minLength' => '2'});
	should_pass("7965", $type, 0);
	should_pass("70786a7071636169626270636f786374666c6962", $type, 0);
	should_pass("75696a7571746d757878626a6e666f6f70776c6374616f6f65646f79797762726a6469676970", $type, 0);
	should_pass("77767578746e646d6b667861717375667965646f6f7679686863636a6e6a756277797979726c61626d6e666a64726b677767666866617765", $type, 0);
	should_pass("69766a63617879686a6b786f70716a7978687471636c6d79666b646767766d646471617970746d726c776971686c79617579666c6d626d75686d746d6562666878756162736363716f6c", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet minLength with value 48." => sub {
	my $type = mk_type('HexBinary', {'minLength' => '48'});
	should_pass("6669726d66716874726b6a7669776f636c77687462677072796d67726373616f6d6a62676e71737662786d706e657361", $type, 0);
	should_pass("7076647968747279656174736a766a68726d7167796f67666c73656f7261756c6e716576796a68756e62646d67786f7776656a616572", $type, 0);
	should_pass("6a6562666d64656f7979716d737769706e63677064707474636f7471626e6b637973666d6e6a626879776f6b65716e62646d6a6470686f79636d7165", $type, 0);
	should_pass("6c6361646e766f616369686a6a6363786967746164646f6d6e616a6d69636d69636161636c79746a6b61666175736f676675696363786f756f6e667978706a797761", $type, 0);
	should_pass("78796276646a6f61646b6c6d6d70746c686e6c636971757273746e766e63696d6171677571696c666a6874626c74696365797975756875657377726674626d69706976766c6c7376", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet minLength with value 74." => sub {
	my $type = mk_type('HexBinary', {'minLength' => '74'});
	should_pass("6c6e6f6f636375616170726576757375616b70776c6564737366636c66776e706c6669746d6c6d666d67766b6a6a776e6b79756e6367756e7864676778706e6874757078757179687179", $type, 0);
	should_pass("6e6a72616d72637170627874706c6e63716878746d6d636e776b646467716b7677676a6f71646762656b64617678776875656a63716f6d656e686e72656f7379667078756f61746e6c64", $type, 0);
	should_pass("736f6463647962746d797378787866646a6e65767472776961766270696176746c797172776679636f65646c7871666a637765736f64766e6275676c766c6e706178777570637168776c", $type, 0);
	should_pass("616b6f6a686d756a74756e7861746f757172766672766f66636c76657162637565687177767671796f6b7269686c6b6268726b6868726d6e736c74777166726c76626272786c76626264", $type, 0);
	should_pass("736b6d74726669796777796164756b706973786c747574746f6a786671766672736d736866697168776663626b7073686465716f64766c677275696676776479726263706a6a79616b6f", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet length with value 1." => sub {
	my $type = mk_type('HexBinary', {'length' => '1'});
	should_pass("63", $type, 0);
	should_pass("77", $type, 0);
	should_pass("78", $type, 0);
	should_pass("77", $type, 0);
	should_pass("65", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet length with value 16." => sub {
	my $type = mk_type('HexBinary', {'length' => '16'});
	should_pass("73756e6d646279637070646378667371", $type, 0);
	should_pass("696a7372617365727177786e76626274", $type, 0);
	should_pass("6e67676f66736a677468677077746668", $type, 0);
	should_pass("616c6b6b636377696e7265646e6e7678", $type, 0);
	should_pass("6c777676726b78736e61736a64766973", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet length with value 41." => sub {
	my $type = mk_type('HexBinary', {'length' => '41'});
	should_pass("776c6a7870627864747264616e76637377706464696c736e6a637372756c736c696a66786c65796e6f", $type, 0);
	should_pass("6e7066747876756f6e71636d6a65656a746278707574706c6f7872746370676268686f6e7979767670", $type, 0);
	should_pass("7976726a686e70676d756a786c67756367667672747563767563797375706c6e7263796c6d796f746f", $type, 0);
	should_pass("74626c6575637874666f62716b6d7377636a7673626f70676a656e6f7862646569756d6b616d617972", $type, 0);
	should_pass("6f7470776c63616d6771636e756c6e716f64736f62677868726672736e77766d6d7272646562766365", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet length with value 68." => sub {
	my $type = mk_type('HexBinary', {'length' => '68'});
	should_pass("61647361677962727668716261676e776777676764666a697478706f656f6d646d72696f7474796b74627672716470636d71617073617767626e697569746164776d6870", $type, 0);
	should_pass("6c71686d646d64687679646a686761737563666f696f73696f63787976696267706763616d786d647170767470706466726169636d7161716e78786974796a7767726565", $type, 0);
	should_pass("7675776d67747075716a677377686d6c6c617768616a77786574657972656973646e6c6a626c757172717374757576776b7968766d6d736875776d6273696e79636b7663", $type, 0);
	should_pass("68637564617068786a696a6762686c6c6d74776b7273647564656e726372666c6e6c63636c6e77787870616a6966656971746f74746f6572787870726d6874776f786268", $type, 0);
	should_pass("7262656f6e6c6467666a6f7568676f746668756f6f6f716766666a63736a7265687273676b636663756472696567686678736f7074636b67666f71736272756170706467", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet length with value 74." => sub {
	my $type = mk_type('HexBinary', {'length' => '74'});
	should_pass("71617165766675796f7077626377736e796f62757475776a6363686e6570727665706379666c6d637074756e647075637775616871676161746b786a65687867616e747874786b617170", $type, 0);
	should_pass("6f6d636d71766b6679676b6e7169727276636a747961716464797066626d6474707671616a61707163796e75706f6561646b64676a6e7778746c6b7874767063706a6976777065767577", $type, 0);
	should_pass("787372716871736f6f616178707273707874687562696177616f6c637677686e72636d676f6a6b786c776e64666d7378796679656a64706d676d72616d7973746668736b65626964716e", $type, 0);
	should_pass("7367786779776e6476666369717977766e76796f6e79636d706a686d6b616a676a6272687979646775776e6863776b62746a706f77726672706e78716a666f626476776674756b786f6e", $type, 0);
	should_pass("6174786a656d70627377707072676773717375746676787272646975616b71766a73646f6a696f736f67616f746a6e7272626b616b636d6b706469767574757772736a64726e716f6765", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet pattern with value [0-9A-F]{56}." => sub {
	my $type = mk_type('HexBinary', {'pattern' => qr/(?ms:^[0-9A-F]{56}$)/});
	should_pass("756765786D706E686D61746C736A66696F6870727272707864666579", $type, 0);
	should_pass("6164696771616D657769787078716767647573626D65686570687579", $type, 0);
	should_pass("6C6C716F636879677467686871776571686161616E6D78636B686563", $type, 0);
	should_pass("6B6C6365756F73647967646E766366776F6F6B68706C6D71656F7072", $type, 0);
	should_pass("687565777368706D646B6B6D6C6F65716A6D6A62776D747267666B69", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet pattern with value [0-9A-F]{66}." => sub {
	my $type = mk_type('HexBinary', {'pattern' => qr/(?ms:^[0-9A-F]{66}$)/});
	should_pass("6564757662646E6B76686F77747473656B7876726F7062616A6B70677272736867", $type, 0);
	should_pass("6E6776726D7468796B766A766B6872796C6A7063666C68616F616B6272766D6B6A", $type, 0);
	should_pass("686463686A7665776B746F756A616673626E6C69796278747176677861756A6378", $type, 0);
	should_pass("656B6B6C7379727171746970697473726B626F6C71677373637976786E736B6776", $type, 0);
	should_pass("707574686276776574756F63756977616A797869707968676C7276757174756468", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet pattern with value [0-9A-F]{18}." => sub {
	my $type = mk_type('HexBinary', {'pattern' => qr/(?ms:^[0-9A-F]{18}$)/});
	should_pass("686163626B6E726F61", $type, 0);
	should_pass("66666F7062616A7269", $type, 0);
	should_pass("6C706B737361767170", $type, 0);
	should_pass("7561746E7175666A61", $type, 0);
	should_pass("6661656273726E6C63", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet pattern with value [0-9A-F]{46}." => sub {
	my $type = mk_type('HexBinary', {'pattern' => qr/(?ms:^[0-9A-F]{46}$)/});
	should_pass("616B6374737472717274636768616E66746C77726F6771", $type, 0);
	should_pass("71686674766B73656B6E6772617378686D77746E696D66", $type, 0);
	should_pass("626467696F686C71616B6D7872766B666E796D6D6D6779", $type, 0);
	should_pass("6B78696E627863716F696D676371786D797264736D686C", $type, 0);
	should_pass("756A756779636D61626B626676726E666566757362656A", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet pattern with value [0-9A-F]{60}." => sub {
	my $type = mk_type('HexBinary', {'pattern' => qr/(?ms:^[0-9A-F]{60}$)/});
	should_pass("746A71716F6E6F796E7463657773706177746A746173616274706671616A", $type, 0);
	should_pass("6A6F6F67676273756B726A696D6F6E61726E796969767061756262726279", $type, 0);
	should_pass("69706467776169706D7871727879636E6D69626271797962776B67686D61", $type, 0);
	should_pass("6672626F676B666A6977666876747279757376786F686D616D76676C7171", $type, 0);
	should_pass("626679666F666A78626B77656275626C6E6970667662776D737462646276", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet enumeration." => sub {
	my $type = mk_type('HexBinary', {'enumeration' => ['727172736a736b646368616575787074747667686c72746869626667767662746a76636d64786b62646a646e797068617567697063706a776674796b','696a66756d766e','786c6c716971787963','7772796b687870626e75736e68796966656372706b6373657064726e65706170766177716e61746263727777747361706577','7871646d6161686f6a747877697365686c67616d616171','6762736c6268707277727578686b75736d6b6873656e736970687664776d786576786d62637465716d79','747879637369666c796970646e6b6e616c65777064646d687967716d6e726c6e7064676b6e6871686f65616f6c676b7379696c6e7578766b646c7678756e62','636b6b686471656b6d656166616975717369656464636571786969636f6a747765617364706f7667666164727071766e67717771796b647274796f7771716f7373666e','6e74696b776161']});
	should_pass("747879637369666c796970646e6b6e616c65777064646d687967716d6e726c6e7064676b6e6871686f65616f6c676b7379696c6e7578766b646c7678756e62", $type, 0);
	should_pass("636b6b686471656b6d656166616975717369656464636571786969636f6a747765617364706f7667666164727071766e67717771796b647274796f7771716f7373666e", $type, 0);
	should_pass("747879637369666c796970646e6b6e616c65777064646d687967716d6e726c6e7064676b6e6871686f65616f6c676b7379696c6e7578766b646c7678756e62", $type, 0);
	should_pass("696a66756d766e", $type, 0);
	should_pass("786c6c716971787963", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet enumeration." => sub {
	my $type = mk_type('HexBinary', {'enumeration' => ['696b70746c7777656b6b686b786961737561746a6a666262646161666e617376626b6d70796c6f72786d66786d70657267706971746966636f','70796171746777756779647270757175746f6177636a77647766786e6e626a6c6474796c656f666874','6e','687873626a6373726f7171677270677771676c6566746b687268797867736d62716763736d6b746474686b696a7772686167676671766a6a676e6869667670796a667078726368','71746474','78787167726d70666773646363637167666a76716c746d65746265786f68666e706b6972696f7071776e626975656c767661636e756a6a6962617261','6b68796c66626a647371616e797170636e636d6973736677706272676a746b','776a6b6e6c796261626e627468767771716577787967636c706c6166']});
	should_pass("78787167726d70666773646363637167666a76716c746d65746265786f68666e706b6972696f7071776e626975656c767661636e756a6a6962617261", $type, 0);
	should_pass("696b70746c7777656b6b686b786961737561746a6a666262646161666e617376626b6d70796c6f72786d66786d70657267706971746966636f", $type, 0);
	should_pass("71746474", $type, 0);
	should_pass("70796171746777756779647270757175746f6177636a77647766786e6e626a6c6474796c656f666874", $type, 0);
	should_pass("78787167726d70666773646363637167666a76716c746d65746265786f68666e706b6972696f7071776e626975656c767661636e756a6a6962617261", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet enumeration." => sub {
	my $type = mk_type('HexBinary', {'enumeration' => ['66656a78736c737670696577636f6f7374736e666f716b6b6d70706372636670756376717174637271636f766174716877676c7677616b6b616b66686b796e6e','716f6a676d716c6a7962627064746c6d6f6b','7869716779776174636276726362707274646f6672636874796c77716f796d67776463706664686d79727972696a6768686c746a706d776d67757266756373777278616d616d6a74','687976636d666667656c66736a716c766d736a65786174746472716a6c6d6f6d7062746e756c6f70676f72696475716f716e676c6f6b6e646a72756e677662636a6c616a6e756c76','6f6d6861766564716d69696172637775646c7068616c767770636963697972766d696e746c69796a70796e6479706e786d71736569616f65727377776e736c65676e6f70727567','6b6a64797669616f6e68637177706f666a696a6464696c6864716d726b646461706d686b70747279666f70676d796d70736f6b62746d72746f75','697869686d6d726979716e736d6d6c716e61756f626c72656a6a6176696772737564787364757971736a7470617074766b797074736b6b6c7869656e656968616f6b63736778656975','676365686b6f746a','736967716f73666c706f79716e68676764696378']});
	should_pass("66656a78736c737670696577636f6f7374736e666f716b6b6d70706372636670756376717174637271636f766174716877676c7677616b6b616b66686b796e6e", $type, 0);
	should_pass("7869716779776174636276726362707274646f6672636874796c77716f796d67776463706664686d79727972696a6768686c746a706d776d67757266756373777278616d616d6a74", $type, 0);
	should_pass("716f6a676d716c6a7962627064746c6d6f6b", $type, 0);
	should_pass("66656a78736c737670696577636f6f7374736e666f716b6b6d70706372636670756376717174637271636f766174716877676c7677616b6b616b66686b796e6e", $type, 0);
	should_pass("697869686d6d726979716e736d6d6c716e61756f626c72656a6a6176696772737564787364757971736a7470617074766b797074736b6b6c7869656e656968616f6b63736778656975", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet enumeration." => sub {
	my $type = mk_type('HexBinary', {'enumeration' => ['6a75666c716d666b72696c706e6173787067617568747268616a6166637973716a716e72766a62616864706a73616f6e686873666465716d726f64','64756572756677727068687376727365796679757174776b6c67686b656f67657570797976','656b6472646f6a6163776e71','6b64636963626276647477686f706770756a7068776870696c62746a63786f6b6e6a746672626c63637376776c6b73786e6b7372616266616875646175646f6167656f636e63697274','64616c6a716d72626b76796479706871726c7461716f67767362667264776f67','6873616774666a696269777162716f78766863727777797765656f74','63696877766e6a636270666f696c72686a','7561656b6979666475666e726d737662746c626d776a77766978676563646c6a6c6b6a7977716b686c7062616a6b716367','6b70686a6c6f676e626a61626565697378796d6d70756c7274627270776e6f7272776f646c']});
	should_pass("656b6472646f6a6163776e71", $type, 0);
	should_pass("64756572756677727068687376727365796679757174776b6c67686b656f67657570797976", $type, 0);
	should_pass("6b64636963626276647477686f706770756a7068776870696c62746a63786f6b6e6a746672626c63637376776c6b73786e6b7372616266616875646175646f6167656f636e63697274", $type, 0);
	should_pass("6b64636963626276647477686f706770756a7068776870696c62746a63786f6b6e6a746672626c63637376776c6b73786e6b7372616266616875646175646f6167656f636e63697274", $type, 0);
	should_pass("63696877766e6a636270666f696c72686a", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet enumeration." => sub {
	my $type = mk_type('HexBinary', {'enumeration' => ['6d6f63686e7463706a67747172716b75656966746273697579687666706c6c72726e69706f6b67716d766f626b6c757171777363796b646e666468736f6f6b696464','666a6272766176786b6c69636d76686e6d68697968746a6264796c74656c6f78796c616973','6761737571766c716873746d72','657575657662737270776a626a70716d6878796e77627878647167786c6862657867796576686d6c63696567787261666d','6f6b66687469687477677775706a61','646f76676367746c6e6d636663696670796a6f616e6862676b656c786275666975616472687463706d77','6b696767676c64707177726b77777865796d63656b6b6369626a66646d6d72676877707162786765757471706c75796c6b75676b6561756b6579706c647269696c766e','776f64796e716c686d78776666626c6f','726565637367796b6d77696d66716c6e6a63757375716d6568676179667674757561766a686e6c7161756664676271676c626f63656c626c7261767168796c747265786b']});
	should_pass("6761737571766c716873746d72", $type, 0);
	should_pass("6d6f63686e7463706a67747172716b75656966746273697579687666706c6c72726e69706f6b67716d766f626b6c757171777363796b646e666468736f6f6b696464", $type, 0);
	should_pass("6b696767676c64707177726b77777865796d63656b6b6369626a66646d6d72676877707162786765757471706c75796c6b75676b6561756b6579706c647269696c766e", $type, 0);
	should_pass("6f6b66687469687477677775706a61", $type, 0);
	should_pass("657575657662737270776a626a70716d6878796e77627878647167786c6862657867796576686d6c63696567787261666d", $type, 0);
	done_testing;
};

subtest "Type atomic/hexBinary is restricted by facet whiteSpace with value collapse." => sub {
	my $type = mk_type('HexBinary', {'whiteSpace' => 'collapse'});
	should_pass("657570736465656376746b73687578756e70706769717479776a61787476686877707472626269726e727970706b6b616e736e6d6e736b6777756d786f626a78696276736d6777", $type, 0);
	should_pass("75656e7472726f756176676767676763746a6f726a726d6967776e716b6e776e676e7375706a686569697978726c6d706e737871626b786f716a63786f6b78746d68796d706676", $type, 0);
	should_pass("6a686275666f766e746e786e6d657765716365776f7164636e6d696865757873656f6c72776c627673676a686b686a77646761636177767468667276726171676f71686579636f", $type, 0);
	should_pass("6471726971796f71756a6f6876796576776d756b706e6b73646e6d7962796b6c67736a7363746a63796272676c646d72647771786b77626b77717563646c6561706a7578756964", $type, 0);
	should_pass("6d6e6b6664616f6f6b676e646d6c67776a6d6e6a6a6d736a73726e62747079656b6765706f67776e6778746479736273736b626b6f76797170766d7264656c6573646b696a6864", $type, 0);
	done_testing;
};

done_testing;

