use strict;
use warnings;
use utf8;

use Test::More;
use Test::TypeTiny;

use Types::XSD;

sub mk_type { "Types::XSD"->get_type($_[0])->parameterize(%{$_[1]}) }

subtest "Type atomic/token is restricted by facet maxLength with value 0." => sub {
	my $type = mk_type('Token', {'maxLength' => '0'});
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet maxLength with value 919." => sub {
	my $type = mk_type('Token', {'maxLength' => '919'});
	should_pass("", $type, 0);
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts fromlrd", $type, 0);
	should_pass("the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on theqvhpwdz", $type, 0);
	should_pass("information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domkjkzjglkrlwizdgdaw", $type, 0);
	should_pass("ains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed to accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related tasks: Provide technical leadership byjbmjshidnoxpmtyo", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet maxLength with value 834." => sub {
	my $type = mk_type('Token', {'maxLength' => '834'});
	should_pass("", $type, 0);
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more acew", $type, 0);
	should_pass("dvanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a wayrqubye", $type, 0);
	should_pass("that allows computers to exchange and automatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XMLvmesshpypdqyersu", $type, 0);
	should_pass("documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed to accelerate the adoption of these standards by addressing market needs and directiocfcrsvtxltxhvq", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet maxLength with value 670." => sub {
	my $type = mk_type('Token', {'maxLength' => '670'});
	should_pass("", $type, 0);
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital librarybdb", $type, 0);
	should_pass("Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alikdrdwx", $type, 0);
	should_pass("e particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex docuqnewftihq", $type, 0);
	should_pass("ments The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespreadvfcganfbzmbpferfk", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet maxLength with value 1000." => sub {
	my $type = mk_type('Token', {'maxLength' => '1000'});
	should_pass("", $type, 0);
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing commujgd", $type, 0);
	should_pass("nity has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certainxxtyripih", $type, 0);
	should_pass("processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processohfmjlsewictictbyzoq", $type, 0);
	should_pass("rs and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed to accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provide tesnzocbkousxtoplnkosxnovdlihsiukytsw", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet minLength with value 0." => sub {
	my $type = mk_type('Token', {'minLength' => '0'});
	should_pass("", $type, 0);
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing commuqkg", $type, 0);
	should_pass("nity has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certainjrwtvkxkz", $type, 0);
	should_pass("processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processosejjuewomjzhcvibrny", $type, 0);
	should_pass("rs and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed to accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provide tespwazobgdywpuwpexwmmrwxftxzyhrynwag", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet minLength with value 305." => sub {
	my $type = mk_type('Token', {'minLength' => '305'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Intmjv", $type, 0);
	should_pass("ernet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certain processes A set of related technhqoerxiiv", $type, 0);
	should_pass("ologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulahewjbspmdpbuitr", $type, 0);
	should_pass("te and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed to accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related taskswtpbmjmjvlsmu", $type, 0);
	should_pass(": Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provide test frameworks for XML DOM XSL-FO XSLT/Xpath and XML Schemas Partner with industry participants to build robust test suites for XML DOM XSL-FO XSLT/Xpath and XML Schemas Develop in-house tools to aid in automating test generation for XML-based languages Work with industry to ensure that these tests are used as metrology tools and that the results of the tests are fed back into both the standards process and the development process As chair of the OASIS XML Conformance Subcommittee NIST/ITL led the development of the widely used XML test suite NIST/ITL has further developed in cooperation with OASIS and W3C robust testing resources for related XML technologies including XML Schemas DOM and XSL Developdyjlwzxkedyoebbvhhpyxdniocbwekohkjriydphdldjnsujoztacrjqfvzhugrncnacdbvvpxb", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet minLength with value 39." => sub {
	my $type = mk_type('Token', {'minLength' => '39'});
	should_pass("The advent of Internet-enabled browsers", $type, 0);
	should_pass("and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet languagktej", $type, 0);
	should_pass("e called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rpqvjmjpnq", $type, 0);
	should_pass("ich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in beta versions owvbputcqgjirrhrepks", $type, 0);
	should_pass("f popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed to accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provide test frameworks for XML DOM XSL-FO XSLT/Xpath and XML Schemas Partner with industry partdjwwslylzqxffbmvlifrnieywcvwkiwwxiqupdlheruj", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet minLength with value 202." => sub {
	my $type = mk_type('Token', {'minLength' => '202'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML withpuhu", $type, 0);
	should_pass("more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describesbgmomi", $type, 0);
	should_pass("information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL definesqdktbjfuxqkhzgu", $type, 0);
	should_pass("methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed to acihwpjrpmqlrhfji", $type, 0);
	should_pass("celerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provide test frameworks for XML DOM XSL-FO XSLT/Xpath and XML Schemas Partner with industry participants to build robust test suites for XML DOM XSL-FO XSLT/Xpath and XML Schemas Develop in-house tools to aid in automating test generation for XML-based languages Work with industry to ensure that these tests are used as metrology tools and that the results of the tests are fed back into both the standards process and the development process As chair of the OASIS XMLvvnpsrihgdzmwoevgonbfhxwccydmzrgcxopbxsvcqyrxyzlmtubpltdnnyqbcjxbimghue", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet minLength with value 1000." => sub {
	my $type = mk_type('Token', {'minLength' => '1000'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex dochrespcimyeaoelg", $type, 0);
	should_pass("cuments The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed tohsnaqxsbzjdjsqsgcmenel", $type, 0);
	should_pass("accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provide test frameworks for XML DOM XSL-FO XSLT/Xpath and XML Schemas Partner with industry participants to build robust test suites for XML DOM XSL-FO XSLT/Xpath and XML Schemas Develop in-house tools to aid in automating test generation for XML-based languages Work with industry to ensure that these tests are used as metrology tools and that the results of the tests are fed back into both the standards process and the development process As chair of the OASIS Xsmkvphruqvoefeblqmgjldgdwjfhvwocsefnqfdltvzectqluuyajpwpstwwqruxujmioec", $type, 0);
	should_pass("ML Conformance Subcommittee NIST/ITL led the development of the widely used XML test suite NIST/ITL has further developed in cooperation with OASIS and W3C robust testing resources for related XML technologies including XML Schemas DOM and XSL Developers and users utilize these tools to exercise both the appropriate W3C Recommendation and the associated implementations Errors and ambiguities raised as a result of these tools are fed back into the development process for correction in future revisions An industry s ability to use electronic commerce EC effectively depends primarily on that industry s ability to create manipulate and transmit intelligent information among partners and throughout the industry The eXtensible Markup Language XML which is already targeted as the enabling technology for EC is the primary standard by which industries are defining the structure and semantics of their information XML is a base recommendation coupled with a set of emerging spjsjzivtiqshkciivvedhe", $type, 0);
	should_pass("ecifications and related vocabularies based upon the XML syntax In the simplest sense the benefits of XML will only be achieved if organizations of a significant number are using the same XML documents Therefore these XML documents must be available for partners to discover and retrieve A registry/repository is a mechanism used to discover and retrieve documents templates software i e objects and resources over the Internet A registry is the mechanism used to discover the object The registry provides information about the object including the location of the object A repository is where the object resides A user retrieves an object from a repository Although XML is a recent newcomer in the electronic commerce landscape supply chains in many industries as well as industry consortiums and standards organizations are using XML to define their own vocabularies for business relationships and transactions The vocabularies business templates and business processesdvrdbvqevgvfpjrdpjzfofqtpavag", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet length with value 0." => sub {
	my $type = mk_type('Token', {'length' => '0'});
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet length with value 295." => sub {
	my $type = mk_type('Token', {'length' => '295'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-geneixp", $type, 0);
	should_pass("ration Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language tuwnhxp", $type, 0);
	should_pass("hat describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manaduy", $type, 0);
	should_pass("ipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheetcqylqany", $type, 0);
	should_pass("Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured informationdrjyfzhfhn", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet length with value 662." => sub {
	my $type = mk_type('Token', {'length' => '662'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange andwynpoolvq", $type, 0);
	should_pass("automatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voixvcrloalxqyotfsk", $type, 0);
	should_pass("ce-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortiumwaotlmkrpytcio", $type, 0);
	should_pass("was formed to accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provide test frameworks for XML DOM XSL-FO XSLT/Xpath and XML Schemas Partner with industry participants to build robust test suites for XMLohkjfhkqrmhomvezqsoejqfdquiboikkumcbxefytllkjk", $type, 0);
	should_pass("DOM XSL-FO XSLT/Xpath and XML Schemas Develop in-house tools to aid in automating test generation for XML-based languages Work with industry to ensure that these tests are used as metrology tools and that the results of the tests are fed back into both the standards process and the development process As chair of the OASIS XML Conformance Subcommittee NIST/ITL led the development of the widely used XML test suite NIST/ITL has further developed in cooperation with OASIS and W3C robust testing resources for related XML technologies including XML Schemas DOM and XSL Developers and users utilize these tools to exercise both tafycrkcrydnjnjslthgvpixrhkjrnsbio", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet length with value 979." => sub {
	my $type = mk_type('Token', {'length' => '979'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods fobuxycesnxtwypgqn", $type, 0);
	should_pass("r creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Sjrdpqjkvpoynnfefoei", $type, 0);
	should_pass("tandards OASIS consortium was formed to accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provide test frameworks for XML DOM XSL-FO XSLT/Xpath and XML Schemas Partner with industry participants to build robust test suites for XML DOM XSL-FO XSLT/Xpath and XML Schemas Develop in-house tools to aid in automating test generation for XML-based languages Work with industry to ensure that these tests are used as metrology tools and that the results of the tests are fed back into both the standardjbosdwwzdftmjmcbidisoxqxiprxmirifldwxrkpvhxggroanbbnqotpuerztkcipmabnbp", $type, 0);
	should_pass("s process and the development process As chair of the OASIS XML Conformance Subcommittee NIST/ITL led the development of the widely used XML test suite NIST/ITL has further developed in cooperation with OASIS and W3C robust testing resources for related XML technologies including XML Schemas DOM and XSL Developers and users utilize these tools to exercise both the appropriate W3C Recommendation and the associated implementations Errors and ambiguities raised as a result of these tools are fed back into the development process for correction in future revisions An industry s ability to use electronic commerce EC effectively depends primarily on that industry s ability to create manipulate and transmit intelligent information among partners and throughout the industry The eXtensible Markup Language XML which is already targeted as the enabling technology for EC is the primary standard by which industries are defining the structure and semanticsgysgujpwlpynhfujnkkdvml", $type, 0);
	should_pass("of their information XML is a base recommendation coupled with a set of emerging specifications and related vocabularies based upon the XML syntax In the simplest sense the benefits of XML will only be achieved if organizations of a significant number are using the same XML documents Therefore these XML documents must be available for partners to discover and retrieve A registry/repository is a mechanism used to discover and retrieve documents templates software i e objects and resources over the Internet A registry is the mechanism used to discover the object The registry provides information about the object including the location of the object A repository is where the object resides A user retrieves an object from a repository Although XML is a recent newcomer in the electronic commerce landscape supply chains in many industries as well as industry consortiums and standards organizations are using XML to define their own vocabularies frxopjjdtgkppellghxyughqtnt", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet length with value 1000." => sub {
	my $type = mk_type('Token', {'length' => '1000'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex dotsfbhegyrrjhkyxr", $type, 0);
	should_pass("cuments The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed tojxhfhffyrmqiqexonwouxb", $type, 0);
	should_pass("accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provide test frameworks for XML DOM XSL-FO XSLT/Xpath and XML Schemas Partner with industry participants to build robust test suites for XML DOM XSL-FO XSLT/Xpath and XML Schemas Develop in-house tools to aid in automating test generation for XML-based languages Work with industry to ensure that these tests are used as metrology tools and that the results of the tests are fed back into both the standards process and the development process As chair of the OASIS Xyplsindndoyiwhhwovllwhamovxmdkthwbxnhqwxgyzjtvpygvopyiejjhswseiujdjeqss", $type, 0);
	should_pass("ML Conformance Subcommittee NIST/ITL led the development of the widely used XML test suite NIST/ITL has further developed in cooperation with OASIS and W3C robust testing resources for related XML technologies including XML Schemas DOM and XSL Developers and users utilize these tools to exercise both the appropriate W3C Recommendation and the associated implementations Errors and ambiguities raised as a result of these tools are fed back into the development process for correction in future revisions An industry s ability to use electronic commerce EC effectively depends primarily on that industry s ability to create manipulate and transmit intelligent information among partners and throughout the industry The eXtensible Markup Language XML which is already targeted as the enabling technology for EC is the primary standard by which industries are defining the structure and semantics of their information XML is a base recommendation coupled with a set of emerging spaypbxeuhirlmueandfmkd", $type, 0);
	should_pass("ecifications and related vocabularies based upon the XML syntax In the simplest sense the benefits of XML will only be achieved if organizations of a significant number are using the same XML documents Therefore these XML documents must be available for partners to discover and retrieve A registry/repository is a mechanism used to discover and retrieve documents templates software i e objects and resources over the Internet A registry is the mechanism used to discover the object The registry provides information about the object including the location of the object A repository is where the object resides A user retrieves an object from a repository Although XML is a recent newcomer in the electronic commerce landscape supply chains in many industries as well as industry consortiums and standards organizations are using XML to define their own vocabularies for business relationships and transactions The vocabularies business templates and business processesrkcvylgrdcppyycrfjwbwchymditf", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet pattern with value \\d{1,5}\\s([A-Z][a-z]{1,20}\\s){4}Street\\s([A-Z][a-z]{1,20}\\s){2},\\s[A-Z]{2}\\s15464." => sub {
	my $type = mk_type('Token', {'pattern' => qr/(?ms:^\d{1,5}\s([A-Z][a-z]{1,20}\s){4}Street\s([A-Z][a-z]{1,20}\s){2},\s[A-Z]{2}\s15464$)/});
	should_pass("47 On And Build Are Street Use Soc , SD 15464", $type, 0);
	should_pass("5397 Xml Newcomers Program Technology Street The The , PA 15464", $type, 0);
	should_pass("7764 Templates Into The Be Street Been Technologies , DE 15464", $type, 0);
	should_pass("224 And And Approach Nist Street Also Chairing , ID 15464", $type, 0);
	should_pass("3 Older The And Technologies Street The Specifications , OR 15464", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet pattern with value \\d{1,5}\\s([A-Z][a-z]{1,20}\\s){4}Street\\s([A-Z][a-z]{1,20}\\s){3},\\s[A-Z]{2}\\s19851-1515." => sub {
	my $type = mk_type('Token', {'pattern' => qr/(?ms:^\d{1,5}\s([A-Z][a-z]{1,20}\s){4}Street\s([A-Z][a-z]{1,20}\s){3},\s[A-Z]{2}\s19851-1515$)/});
	should_pass("289 Them And Means Aid Street Appropriate Needed Well , OR 19851-1515", $type, 0);
	should_pass("7782 To Devices Pervasive Computed Street Information And Will , AZ 19851-1515", $type, 0);
	should_pass("3 To Interoperability Nist And Street Its Revolution Oasis , ID 19851-1515", $type, 0);
	should_pass("234 Implementations Registry Data Tools Street Original Although Discovery , SD 19851-1515", $type, 0);
	should_pass("5 Object The To Measurement Street Software Collaborating With , NJ 19851-1515", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet pattern with value \\d{1,5}\\s([A-Z][a-z]{1,20}\\s){4}Street\\s([A-Z][a-z]{1,20}\\s){3},\\s[A-Z]{2}\\s13653." => sub {
	my $type = mk_type('Token', {'pattern' => qr/(?ms:^\d{1,5}\s([A-Z][a-z]{1,20}\s){4}Street\s([A-Z][a-z]{1,20}\s){3},\s[A-Z]{2}\s13653$)/});
	should_pass("3243 Organizations Are Developed In Street Suites The For , MA 13653", $type, 0);
	should_pass("59353 And Work Product Tools Street Is Well Base , NC 13653", $type, 0);
	should_pass("47724 Object And Organization The Street Within Specifications Global , KS 13653", $type, 0);
	should_pass("58 To Markup Ec And Street The Of Be , FL 13653", $type, 0);
	should_pass("333 Tests Competence That Technical Street Each Ensure Certain , NJ 13653", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet pattern with value \\d{1,5}\\s([A-Z][a-z]{1,20}\\s){3}Street\\s([A-Z][a-z]{1,20}\\s){2},\\s[A-Z]{2}\\s13573." => sub {
	my $type = mk_type('Token', {'pattern' => qr/(?ms:^\d{1,5}\s([A-Z][a-z]{1,20}\s){3}Street\s([A-Z][a-z]{1,20}\s){2},\s[A-Z]{2}\s13573$)/});
	should_pass("224 Assuring Discovery Areas Street Assuring Provided , NE 13573", $type, 0);
	should_pass("1 The Impact Joint Street Of Testing , KS 13573", $type, 0);
	should_pass("323 Java More And Street And Efforts , OK 13573", $type, 0);
	should_pass("535 The In Software Street High Effective , MA 13573", $type, 0);
	should_pass("896 Be Environments Compatibility Street Web The , PA 13573", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet pattern with value \\d{1,5}\\s([A-Z][a-z]{1,20}\\s){2}Street\\s([A-Z][a-z]{1,20}\\s){2},\\s[A-Z]{2}\\s13926-1478." => sub {
	my $type = mk_type('Token', {'pattern' => qr/(?ms:^\d{1,5}\s([A-Z][a-z]{1,20}\s){2}Street\s([A-Z][a-z]{1,20}\s){2},\s[A-Z]{2}\s13926-1478$)/});
	should_pass("4 Specification Repository Street As Of , MD 13926-1478", $type, 0);
	should_pass("2547 And Of Street Testing Will , AZ 13926-1478", $type, 0);
	should_pass("4353 Ec Improved Street Information Use , WY 13926-1478", $type, 0);
	should_pass("464 Pervasive For Street And Profile , GA 13926-1478", $type, 0);
	should_pass("32 Dom For Street Can Software , VT 13926-1478", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet enumeration." => sub {
	my $type = mk_type('Token', {'enumeration' => ['be','key','has','information','shift','discover','provide','user','commerce']});
	should_pass("commerce", $type, 0);
	should_pass("provide", $type, 0);
	should_pass("be", $type, 0);
	should_pass("provide", $type, 0);
	should_pass("shift", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet enumeration." => sub {
	my $type = mk_type('Token', {'enumeration' => ['maintained','Develop','networks','file','the']});
	should_pass("networks", $type, 0);
	should_pass("networks", $type, 0);
	should_pass("the", $type, 0);
	should_pass("file", $type, 0);
	should_pass("file", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet enumeration." => sub {
	my $type = mk_type('Token', {'enumeration' => ['Computing','compatibility','standardization','engineering','contains','areas']});
	should_pass("contains", $type, 0);
	should_pass("standardization", $type, 0);
	should_pass("compatibility", $type, 0);
	should_pass("contains", $type, 0);
	should_pass("standardization", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet enumeration." => sub {
	my $type = mk_type('Token', {'enumeration' => ['pico-cellular','to','techniques','is','visibly','as','syntax','was']});
	should_pass("as", $type, 0);
	should_pass("syntax", $type, 0);
	should_pass("as", $type, 0);
	should_pass("was", $type, 0);
	should_pass("syntax", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet enumeration." => sub {
	my $type = mk_type('Token', {'enumeration' => ['through','manufacturers','these','this','and']});
	should_pass("manufacturers", $type, 0);
	should_pass("these", $type, 0);
	should_pass("this", $type, 0);
	should_pass("and", $type, 0);
	should_pass("this", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet whiteSpace with value collapse." => sub {
	my $type = mk_type('Token', {'whiteSpace' => 'collapse'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defi", $type, 0);
	should_pass("ning data known as HTML has led to the creation of the world s first digital lib", $type, 0);
	should_pass("rary Using the simplicity of HTML with more advanced concepts from the publishin", $type, 0);
	should_pass("g community has led to the creation of a second-generation Internet language cal", $type, 0);
	should_pass("led the Extensible Markup Language XML which is rapidly becoming one of the most", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet minLength with value 211." => sub {
	my $type = mk_type('Token', {'minLength' => '211'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a first-", $type, 0);
	should_fail("generation language for defining data known as HTML has led to the creation of the world s first digitsp", $type, 0);
	should_fail("al library Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet lr", $type, 0);
	should_fail("anguage called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in thjacbb", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet minLength with value 735." => sub {
	my $type = mk_type('Token', {'minLength' => '735'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplcwy", $type, 0);
	should_fail("icity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronictmmnfi", $type, 0);
	should_fail("commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitmbmzmkembccb", $type, 0);
	should_fail("ting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Rtuqudpjofoqvsg", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet minLength with value 360." => sub {
	my $type = mk_type('Token', {'minLength' => '360'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data", $type, 0);
	should_fail("known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing community has led to tprtq", $type, 0);
	should_fail("he creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involvedlmedx", $type, 0);
	should_fail("in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulatepegpixg", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet minLength with value 297." => sub {
	my $type = mk_type('Token', {'minLength' => '297'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a first-generation language fo", $type, 0);
	should_fail("r defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepoew", $type, 0);
	should_fail("ts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML iuknm", $type, 0);
	should_fail("s being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automatbmhs", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet minLength with value 1000." => sub {
	my $type = mk_type('Token', {'minLength' => '1000'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing commmfq", $type, 0);
	should_fail("unity has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certagduvgnuc", $type, 0);
	should_fail("in processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML prwfukctoygndmkdhqrzn", $type, 0);
	should_fail("ocessors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed to accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provrbqmfztmpdxcwdsojiermqhxxobdghgspc", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet maxLength with value 0." => sub {
	my $type = mk_type('Token', {'maxLength' => '0'});
	should_fail("T", $type, 0);
	should_fail("he advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing communbwa", $type, 0);
	should_fail("ity has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certaineovkdduzm", $type, 0);
	should_fail("processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML procesbfywxwjjuvtxpxchrdg", $type, 0);
	should_fail("sors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed to accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provide tobfmavhfsxdagbpnbrpawklqbcvellzrfd", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet maxLength with value 576." => sub {
	my $type = mk_type('Token', {'maxLength' => '576'});
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It isjqqrrmcko", $type, 0);
	should_fail("a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents ouuxofoudkgcpgxc", $type, 0);
	should_fail("n a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed to accelerate the adoption of these standards byvonaqslsivfxlhe", $type, 0);
	should_fail("addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provide test frameworks for XML DOM XSL-FO XSLT/Xpath and XML Schemas Partner with industry participants to build robust test suites for XML DOM XSL-FO XSLT/Xpath and XML Schemas Develop in-house tools to aid in automating test generation for XML-based languages Work with industry to ensure that these tests are used as metrology tools and that the results of the tests are fed back into both the standardspqymicffkqurzkcpntuwruntghaekdsscosmheucameafcuijrnfntbpenbsjfohefqii", $type, 0);
	should_fail("process and the development process As chair of the OASIS XML Conformance Subcommittee NIST/ITL led the development of the widely used XML test suite NIST/ITL has further developed in cooperation with OASIS and W3C robust testing resources for related XML technologies including XML Schemas DOM and XSL Developers and users utilize these tools to exercise both the appropriate W3C Recommendation and the associated implementations Errors and ambiguities raised as a result of these tools are fed back into the development process for correction in future revisions An industry s ability to use electronic commerce EC effectively depends primarily on that industry s ability to create manipulate and transmit intelligent information among partners and throughout the industry The eXtensible Markup Language XML which is already targeted as the enabling technology for EC is the primary standard by which industries are defining the structure and semantics of their informationpwieyxtfmjfkpdcyoghktflql", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet maxLength with value 664." => sub {
	my $type = mk_type('Token', {'maxLength' => '664'});
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and aurymgkzqwf", $type, 0);
	should_fail("tomatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologievmdefnafttxygwrwo", $type, 0);
	should_fail("s to define manipulate and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed to accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the followingvqbbveiuflyxto", $type, 0);
	should_fail("related tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provide test frameworks for XML DOM XSL-FO XSLT/Xpath and XML Schemas Partner with industry participants to build robust test suites for XML DOM XSL-FO XSLT/Xpath and XML Schemas Develop in-house tools to aid in automating test generation for XML-based languages Work with industry to ensure that these tests are used as metrology tools and that the results of the tests are fed back into both the standards process and the development process As chair of the OASIS XML Conformance Subcommittee NIST/ITL led the development of the widely used XML test suite NIST/ITL has further developed in cooperation with OASIS and W3Cmmvydclqztgqerqzilfqjqxyaiugysfpzjvvvekfjmgkqkowrxexqxtvfktrejuhigocyhez", $type, 0);
	should_fail("robust testing resources for related XML technologies including XML Schemas DOM and XSL Developers and users utilize these tools to exercise both the appropriate W3C Recommendation and the associated implementations Errors and ambiguities raised as a result of these tools are fed back into the development process for correction in future revisions An industry s ability to use electronic commerce EC effectively depends primarily on that industry s ability to create manipulate and transmit intelligent information among partners and throughout the industry The eXtensible Markup Language XML which is already targeted as the enabling technology for EC is the primary standard by which industries are defining the structure and semantics of their information XML is a base recommendation coupled with a set of emerging specifications and related vocabularies based upon the XML syntax In the simplest sense the benefits of XML will only be achieved if organizations of a sigyxsbibrmfmqtiyiewzejmstd", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet maxLength with value 720." => sub {
	my $type = mk_type('Token', {'maxLength' => '720'});
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it canhtlbcrkpvsm", $type, 0);
	should_fail("be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processors and supplocooxfkbxywfprjyyei", $type, 0);
	should_fail("ort for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed to accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts incgibodzisxcurebzqdo", $type, 0);
	should_fail("luding OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provide test frameworks for XML DOM XSL-FO XSLT/Xpath and XML Schemas Partner with industry participants to build robust test suites for XML DOM XSL-FO XSLT/Xpath and XML Schemas Develop in-house tools to aid in automating test generation for XML-based languages Work with industry to ensure that these tests are used as metrology tools and that the results of the tests are fed back into both the standards process and the development process As chair of the OASIS XML Conformance Subcommittee NIST/ITL led the development of the widely used XML test suite NIST/ITL has further developed in cooperation with OASIS and W3C robust testing resources for related XML technologies including XML Schemas DOM and XSL Developers and users utilize these tools to exeuabukjvndntfmqqzncfotsokpralxmrpismqkjmcrsjabsfpbbjkdkhmpxkajostpxs", $type, 0);
	should_fail("rcise both the appropriate W3C Recommendation and the associated implementations Errors and ambiguities raised as a result of these tools are fed back into the development process for correction in future revisions An industry s ability to use electronic commerce EC effectively depends primarily on that industry s ability to create manipulate and transmit intelligent information among partners and throughout the industry The eXtensible Markup Language XML which is already targeted as the enabling technology for EC is the primary standard by which industries are defining the structure and semantics of their information XML is a base recommendation coupled with a set of emerging specifications and related vocabularies based upon the XML syntax In the simplest sense the benefits of XML will only be achieved if organizations of a significant number are using the same XML documents Therefore these XML documents must be available for partners to discover and retrieve Awjvhmsrcdhtokcfsffqydrl", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet maxLength with value 1000." => sub {
	my $type = mk_type('Token', {'maxLength' => '1000'});
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex doczwkgcpmvlpsrotns", $type, 0);
	should_fail("uments The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed to accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following relateylltkrqhqfffnxjfsttvejpe", $type, 0);
	should_fail("d tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provide test frameworks for XML DOM XSL-FO XSLT/Xpath and XML Schemas Partner with industry participants to build robust test suites for XML DOM XSL-FO XSLT/Xpath and XML Schemas Develop in-house tools to aid in automating test generation for XML-based languages Work with industry to ensure that these tests are used as metrology tools and that the results of the tests are fed back into both the standards process and the development process As chair of the OASIS XML Conformance Subcommittee NIST/ITL led the development of the widely used XML test suite NIST/ITL has further developed in cooperation with OASIS and W3C robust testing resources for related XML technologies including XML Schemas DOM and XSL Developers and users utilize these tools to exercise both the appropriate W3C Recommendation and the associated implementations Errors and ambiguities raised as a result of these tools are fed back into the development process for correction in future revisions An industry s ability to use electronic commerce EC effectively depends primarily on that industry s ability to create manipulate and transmit intelligent information among partners and throughout the industry The eXtensible Marinfwlbfxrhfgxkpmeqgxjcpwdaoerengdfemxuckfchlrzifqvlvvimapvbeliqlatcqytcdvfnmmemypkgc", $type, 0);
	should_fail("kup Language XML which is already targeted as the enabling technology for EC is the primary standard by which industries are defining the structure and semantics of their information XML is a base recommendation coupled with a set of emerging specifications and related vocabularies based upon the XML syntax In the simplest sense the benefits of XML will only be achieved if organizations of a significant number are using the same XML documents Therefore these XML documents must be available for partners to discover and retrieve A registry/repository is a mechanism used to discover and retrieve documents templates software i e objects and resources over the Internet A registry is the mechanism used to discover the object The registry provides information about the object including the location of the object A repository is where the object resides A user retrieves an object from a repository Although XML is a recent newcomer in the electronic commerce landscape supply chains in many industries as well as industry consortiums and standards organizations are using XML to define their own vocabularies for business relationships and transactions The vocabularies business templates and business processes used by these groups to transact business must be accessible by all partners at any time Furthermore newcomers to the supply chain or business partnerships must be able to discover these documents and retrieve them A registry and repository can be used to provide this service A series of registries and repositories can link many organizations and industries acting as a web of registries for discovery Standards are needed to ensure interoperability of these registries; additionally a regdnrghtrvrdwuyopobsrtvbscricpynrpiamrdkil", $type, 0);
	should_fail("istry vocabulary must be created for consistency of discovery information among them NIST/ITL is working with the Organization for the Advancement of Structured Information Standards OASIS the prominent industry consortium for defining specifications for the discovery and retrieval of XML-related documents NIST chairs the OASIS Registry/Repository Technical Committee and is a significant contributor NIST/ITL is also working within the ebXML Project a joint project between OASIS and the United Nations body for Trade Facilitation and Electronic Business UN/CEFACT the prominent business-oriented international standards organization for the discovery retrieval and use of business processes and related documents The role of NIST/ITL is to influence the quality correctness and testability of the specifications of both the OASIS and ebXML Registry/Repository Working Groups through our reference implementation of a registry and repository that is conformant to both specifications Additionally NIST/ITL facilitates cross-over discussions between OASIS and ebXML; thus helping to ensure compatibility of the specifications NIST/ITL through its leadership in developing a reference implementation that is compliant to both specifications will help ensure that both specifications are unambiguous complete and testable This work will also contribute to the compatibility of these two specifications An early indication of success is that the draft ebXML specification uses the OASIS specification as its basis The completion of these specifications will allow small- and medium-sized enterprises SMEs to make appropriate choices with regard to EC tools and applications and will allow them access to the emerging supply chain and industry partnership EC models The National Software Reference Library NSRL provides a repository of known software file profiles and file signatures for use by law enforcement organizations in computer forensics investigationsyoiqsimkqtpssjmesezvmqjfqnuasjwxoocwqhdq", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet length with value 0." => sub {
	my $type = mk_type('Token', {'length' => '0'});
	should_fail("T", $type, 0);
	should_fail("he advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing communthx", $type, 0);
	should_fail("ity has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certainncxfhwimh", $type, 0);
	should_fail("processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML proceseefqeindqnirhewxked", $type, 0);
	should_fail("sors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed to accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provide tmkqlxwhyflzefrlduubpselyjdgmnlomec", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet length with value 370." => sub {
	my $type = mk_type('Token', {'length' => '370'});
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML whichpmywafe", $type, 0);
	should_fail("is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and dyppysunp", $type, 0);
	should_fail("isplay context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in betwgsnslnwwfnotqike", $type, 0);
	should_fail("a versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed to accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcomhyxjvkgcdekijygfmlchdwl", $type, 0);
	should_fail("mittees W3C XSL-FO DOM and XML Schema Working Groups Provide test frameworks for XML DOM XSL-FO XSLT/Xpath and XML Schemas Partner with industry participants to build robust test suites for XML DOM XSL-FO XSLT/Xpath and XML Schemas Develop in-house tools to aid in automating test generation for XML-based languages Work with industry to ensure that these tests are used as metrology tools and that the results of the tests are fed back into both the standards process and the development process As chair of the OASIS XML Conformance Subcommittee NIST/ITL led the development of the widely used XML test suite NIST/ITL has further developed in cooperation with OASIS and W3C robust testing resources for related XML technologies including XML Schemas DOM and XSL Developers and users utilize these tools to exercise both the appropriate W3C Recommendation and the associated implementations Errors and ambiguities raised as a result of tlpohkqyqgwskuvnpiergsyebsddnoaiwltexjnrvdtlndlaizvnjfrneqzgoug", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet length with value 780." => sub {
	my $type = mk_type('Token', {'length' => '780'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTdew", $type, 0);
	should_fail("ML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a laejwucj", $type, 0);
	should_fail("nguage that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensibpwcqerqxz", $type, 0);
	should_fail("sible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structureiubnkylfuxijat", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet length with value 645." => sub {
	my $type = mk_type('Token', {'length' => '645'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital ligy", $type, 0);
	should_fail("brary Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages andnsvto", $type, 0);
	should_fail("applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certain processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitinvzilpnffh", $type, 0);
	should_fail("ve methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML processors and support for the related Schema DOM and XSL technologies are available in beta versions of popular webdynirmjmhgckeaml", $type, 0);
	done_testing;
};

subtest "Type atomic/token is restricted by facet length with value 1000." => sub {
	my $type = mk_type('Token', {'length' => '1000'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data known as HTML has led to the creation of the world s first digital library Using the simplicity of HTML with more advanced concepts from the publishing commqsm", $type, 0);
	should_fail("unity has led to the creation of a second-generation Internet language called the Extensible Markup Language XML which is rapidly becoming one of the most popular languages in the world XML is being incorporated into web pages and applications alike particularly in those involved in electronic commerce applications It is a language that describes information in a way that allows computers to exchange and automatically act on the information Consequently it can be used to automate certaadpxjfzr", $type, 0);
	should_fail("in processes A set of related technologies built around this Internet language define a rich set of tools that can be used to define manipulate and display context-rich data In particular XML Schemas define intuitive methods for creating complex documents The Document Object Model DOM defines methods for interacting with XML and HTML permitting the dynamic creation and manipulation of documents The Extensible Stylesheet Language XSL defines methods for transforming and displaying XML documents on a variety of devices from web browsers to print mediums to voice-enabled devices Virtually all application domains are looking to use XML technologies to define manipulate and exchange structured information In addition XML prgqlamlorcnkdgwhfodr", $type, 0);
	should_fail("ocessors and support for the related Schema DOM and XSL technologies are available in beta versions of popular web browsers and application development software The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce As such conformance of these products to the W3C Recommendations is necessary to build interoperable solutions The Organization for the Advancement of Structured Information Standards OASIS consortium was formed to accelerate the adoption of these standards by addressing market needs and directions and recommending guidelines for product interoperability and conformance NIST/ITL is collaborating with industry to solve these problems using the following related tasks: Provide technical leadership by chairing and/or participating in appropriate OASIS and W3C efforts including OASIS XML and XSLT/Xpath Conformance Subcommittees W3C XSL-FO DOM and XML Schema Working Groups Provymqlzmrkqzpbllftnuiaoyyykvbkcmuyiy", $type, 0);
	done_testing;
};

done_testing;

