/*
 * Copyright (C) 2005 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <string.h>
#include <stdlib.h>
#include "translate.h"

#define FAIL							\
  {								\
    g_printerr("failure at %s\n", G_STRLOC);			\
    exit(1);							\
  }

int
main (int argc, char **argv)
{
  const char *str;
  
  if (translate_ascii_strcase_equal("string", "otherstring"))
    FAIL;
  if (! translate_ascii_strcase_equal("string", "sTrInG"))
    FAIL;

  if (translate_ascii_strcase_hash("string") == translate_ascii_strcase_hash("otherstring"))
    FAIL;
  if (translate_ascii_strcase_hash("string") != translate_ascii_strcase_hash("sTrInG"))
    FAIL;

  str = "some string";
  if (translate_ascii_strcasestr(str, "sTrInG") != str + 5)
    FAIL;
  if (translate_ascii_strcasestr(str, "none") != NULL)
    FAIL;
  if (translate_ascii_strcasestr_len(str, 4, "sTriNg") != NULL)
    FAIL;

  if (translate_ascii_strcasecoll("string", "sTrInG") != 0)
    FAIL;
  if (! translate_ascii_strcasecoll("string", "A_lesserstring") < 0)
    FAIL;
  if (! translate_ascii_strcasecoll("string", "Z_greaterstring") > 0)
    FAIL;

  if (translate_utf8_strcasecoll("string-é", "string-É") != 0)
    FAIL;
  if (! translate_utf8_strcasecoll("string-é", "A_lesserstring-é") < 0)
    FAIL;
  if (! translate_utf8_strcasecoll("string-é", "Z_greaterstring-é") > 0)
    FAIL;

  if (translate_utf8_strcmp("string-é", "string-é") != 0)
    FAIL;
  if (! translate_utf8_strcmp("string-é", "a_lesserstring-é") < 0)
    FAIL;
  if (! translate_utf8_strcmp("string-é", "z_greaterstring-é") > 0)
    FAIL;
  
  if (translate_utf8_strcasecmp("string-é", "string-É") != 0)
    FAIL;
  if (! translate_utf8_strcasecmp("string-é", "A_lesserstring-é") < 0)
    FAIL;
  if (! translate_utf8_strcasecmp("string-é", "Z_greaterstring-é") > 0)
    FAIL;

  str = "string-é";
  if (translate_utf8_strpbrk(str, -1, "èé") != str + 7)
    FAIL;
  str = "é-string-è";
  if (translate_utf8_strpbrk(str, 4, "è") != NULL)
    FAIL;

  str = "é-string-é";
  if (translate_utf8_strrpbrk(str, -1, "èé") != str + 10)
    FAIL;
  str = "é-string-è";
  if (translate_utf8_strrpbrk(str, 4, "è") != NULL)
    FAIL;
  
  if (translate_time() < 0)
    FAIL;
  
  if (strcmp(translate_sgml_ref_expand("&lt;tag&gt;"), "<tag>") != 0)
    FAIL;
  if (strcmp(translate_sgml_ref_expand("&#65;&#66;&#67;"), "ABC") != 0)
    FAIL;
  if (strcmp(translate_sgml_ref_expand("&#65&#66&#67"), "ABC") != 0)
    FAIL;
  if (strcmp(translate_sgml_ref_expand("&#x41;&#x42;&#x43;"), "ABC") != 0)
    FAIL;
  if (strcmp(translate_sgml_ref_expand("&#X41;&#X42;&#X43;"), "ABC") != 0)
    FAIL;
  if (strcmp(translate_sgml_ref_expand("&lt;tag&gt; &unknown;"), "<tag> &unknown;") != 0)
    FAIL;
  if (strcmp(translate_sgml_ref_expand("&lt;tag&gt; &unknown end"), "<tag> &unknown end") != 0)
    FAIL;
  g_print("+++ TEST-UTIL PASSED\n");

  return 0;
}
