using System;
using System.Runtime.InteropServices;
 
//------------------------------------------------------------------------------
// <auto-generated />
//
// This file was automatically generated by SWIG (http://www.swig.org).
// Version 4.0.2
//
// Do not make changes to this file unless you know what you are doing--modify
// the SWIG interface file instead.
//------------------------------------------------------------------------------

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html Stochiometry expressions in SBML Level 2 reactions.
 *
 * @section l2-stoichiometries Stoichiometries in SBML Level 2
 *
 * In SBML Level 2, product and reactant stoichiometries can be specified
 * using @em either the 'stoichiometry' attribute or a 'stoichiometryMath'
 * element in a SpeciesReference object.  The 'stoichiometry' attribute is
 * of type @c double and should contain values greater than zero (0).  The
 * 'stoichiometryMath' element is implemented as an element containing a
 * MathML expression.  These two are mutually exclusive; only one of
 * 'stoichiometry' or 'stoichiometryMath' should be defined in a given
 * SpeciesReference instance.  When neither the attribute nor the element
 * is present, the value of 'stoichiometry' in the enclosing
 * SpeciesReference instance defaults to @c 1.
 * 
 * For maximum interoperability, SpeciesReference's 'stoichiometry'
 * attribute should be used in preference to 'stoichiometryMath' when a
 * species' stoichiometry is a simple scalar number (integer or decimal).
 * When the stoichiometry is a rational number, or when it is a more
 * complicated formula, 'stoichiometryMath' must be used.  The MathML
 * expression in 'stoichiometryMath' may also refer to identifiers of
 * entities in a model (except reaction identifiers).  However, the only
 * species identifiers that can be used in 'stoichiometryMath' are those
 * referenced in the enclosing Reaction's list of reactants, products and
 * modifiers.
 * 
 * The 'stoichiometry' attribute and the 'stoichiometryMath' element, when
 * either is used, is each interpreted as a factor applied to the reaction
 * rate to produce the rate of change of the species identified by the
 * 'species' attribute in the enclosing SpeciesReference.  This is the
 * normal interpretation of a stoichiometry, but in SBML, one additional
 * consideration has to be taken into account.  The reaction rate, which is
 * the result of the KineticLaw's 'math' element, is always in the model's
 * @em substance per @em time units.  However, the rate of change of the
 * species will involve the species' @em substance units (i.e., the units
 * identified by the Species object's 'substanceUnits' attribute), and
 * these units may be different from the model's default @em substance
 * units.  If the units @em are different, the stoichiometry must
 * incorporate a conversion factor for converting the model's @em substance
 * units to the species' @em substance units.  The conversion factor is
 * assumed to be included in the scalar value of the 'stoichiometry'
 * attribute if 'stoichiometry' is used.  If instead 'stoichiometryMath' is
 * used, then the product of the model's 'substance' units times the
 * 'stoichiometryMath' units must match the @em substance units of the
 * species.  Note that in either case, if the species' units and the
 * model's default @em substance units are the same, the stoichiometry ends
 * up being a dimensionless number and equivalent to the standard chemical
 * stoichiometry found in textbooks.  Examples and more explanations of
 * this are given in the SBML specification.
 * 
 * The following is a simple example of a species reference for species
 * @c 'X0', with stoichiometry @c 2, in a list of reactants within a reaction
 * having the identifier @c 'J1':
 * @verbatim
 <model>
     ...
     <listOfReactions>
         <reaction id='J1'>
             <listOfReactants>
                 <speciesReference species='X0' stoichiometry='2'>
             </listOfReactants>
             ...
         </reaction>
         ...
     </listOfReactions>
     ...
 </model>
 @endverbatim
 * 
 * The following is a more complex example of a species reference for
 * species @c 'X0', with a stoichiometry formula consisting of
 * a rational number:
 * @verbatim
 <model>
     ...
     <listOfReactions>
         <reaction id='J1'>
             <listOfReactants>
                 <speciesReference species='X0'>
                     <stoichiometryMath>
                         <math xmlns='http://www.w3.org/1998/Math/MathML'> 
                             <cn type='rational'> 3 <sep/> 2 </cn>
                         </math>
                     </stoichiometryMath>
                 </speciesReference>
             </listOfReactants>
             ...
         </reaction>
         ...
     </listOfReactions>
     ...
 </model>
 @endverbatim
 *
 * Additional discussions of stoichiometries and implications for species
 * and reactions are included in the documentation of SpeciesReference
 * class.
 *
 * @section l3-stoichiometries Stoichiometries in SBML Level 3
 *
 * The StoichiometryMath construct is not defined in SBML Level&nbsp;3.
 * Instead, Level&nbsp;3 defines the identifier of
 * SpeciesReference objects as a stand-in for the stoichiometry of the
 * reactant or product being referenced, and allows that identifier to be
 * used elsewhere in SBML models, including (for example) InitialAssignment
 * objects.  This makes it possible to achieve the same effect as
 * StoichiometryMath, but with other SBML objects.  For instance, to
 * produce a stoichiometry value that is a rational number, a model can use
 * InitialAssignment to assign the identifier of a SpeciesReference object
 * to a MathML expression evaluating to a rational number.  This is
 * analogous to the same way that, in Level&nbsp;2, the model would use
 * StoichiometryMath with a MathML expression evaluating to a rational
 * number.
 *
 * In SBML Level 2, the stoichiometry of a reactant or product is a
 * combination of both a <em>biochemical stoichiometry</em> (meaning, the
 * standard stoichiometry of a species in a reaction) and any necessary
 * unit conversion factors. The introduction of an explicit attribute on
 * the Species object for a conversion factor allows Level&nbsp;3 to avoid
 * having to overload the meaning of stoichiometry.  In Level&nbsp;3, the
 * stoichiometry given by a SpeciesReference object in a reaction is a
 * 'proper' biochemical stoichiometry, meaning a dimensionless number free
 * of unit conversions.
 *
 * @see SpeciesReference
 * @see Reaction
 */

public class StoichiometryMath : SBase {
	private HandleRef swigCPtr;
	
	internal StoichiometryMath(IntPtr cPtr, bool cMemoryOwn) : base(libsbmlPINVOKE.StoichiometryMath_SWIGUpcast(cPtr), cMemoryOwn)
	{
		//super(libsbmlPINVOKE.StoichiometryMathUpcast(cPtr), cMemoryOwn);
		swigCPtr = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(StoichiometryMath obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (StoichiometryMath obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  protected override void Dispose(bool disposing) {
    lock(this) {
      if (swigCPtr.Handle != global::System.IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_StoichiometryMath(swigCPtr);
        }
        swigCPtr = new global::System.Runtime.InteropServices.HandleRef(null, global::System.IntPtr.Zero);
      }
      base.Dispose(disposing);
    }
  }

  
/**
   * Creates a new StoichiometryMath object using the given SBML @p level
   * values.
   *
   * @param level a long integer, the SBML Level to assign to this StoichiometryMath.
   *
   * @param version a long integer, the SBML Version to assign to this
   * StoichiometryMath.
   *
   *
 * @throws SBMLConstructorException
 * Thrown if the given @p level and @p version combination are invalid
 * or if this object is incompatible with the given level and version.
 *
 *
   *
   *
 * @note The StoichiometryMath construct exists only in SBML Level&nbsp;2.
 * It is an optional construct available for defining the stoichiometries of
 * reactants and products in Reaction objects.  Note that a different
 * mechanism is used in SBML Level&nbsp;3, where StoichiometryMath is not
 * available.  Please consult the top of this libSBML StoichiometryMath
 * documentation for more information about the differences between SBML
 * Level&nbsp;2 and&nbsp;3 with respect to stoichiometries.
 *
   *
   *
 * @note Attempting to add an object to an SBMLDocument having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * SBMLDocument), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
 *
 *
   */ public
 StoichiometryMath(long level, long version) : this(libsbmlPINVOKE.new_StoichiometryMath__SWIG_0(level, version), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new StoichiometryMath object using the given SBMLNamespaces object
   * @p sbmlns.
   *
   *
 * 
 * The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's SBMLNamespaces facilities is to create an
 * SBMLNamespaces object somewhere in a program once, then hand that object
 * as needed to object constructors that accept SBMLNamespaces as arguments.
 *
 * 
   *
   * @param sbmlns an SBMLNamespaces object.
   *
   *
 * @throws SBMLConstructorException
 * Thrown if the given @p sbmlns is inconsistent or incompatible
 * with this object.
 *
 *
   *
   *
 * @note The StoichiometryMath construct exists only in SBML Level&nbsp;2.
 * It is an optional construct available for defining the stoichiometries of
 * reactants and products in Reaction objects.  Note that a different
 * mechanism is used in SBML Level&nbsp;3, where StoichiometryMath is not
 * available.  Please consult the top of this libSBML StoichiometryMath
 * documentation for more information about the differences between SBML
 * Level&nbsp;2 and&nbsp;3 with respect to stoichiometries.
 *
   *
   *
 * @note Attempting to add an object to an SBMLDocument having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * SBMLDocument), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
 *
 *
   */ public
 StoichiometryMath(SBMLNamespaces sbmlns) : this(libsbmlPINVOKE.new_StoichiometryMath__SWIG_1(SBMLNamespaces.getCPtr(sbmlns)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Copy constructor; creates a copy of this StoichiometryMath.
   *
   * @param orig the object to copy.
   */ public
 StoichiometryMath(StoichiometryMath orig) : this(libsbmlPINVOKE.new_StoichiometryMath__SWIG_2(StoichiometryMath.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates and returns a deep copy of this StoichiometryMath object.
   *
   * @return the (deep) copy of this StoichiometryMath object.
   */ public new
 StoichiometryMath clone() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.StoichiometryMath_clone(swigCPtr);
    StoichiometryMath ret = (cPtr == global::System.IntPtr.Zero) ? null : new StoichiometryMath(cPtr, true);
    return ret;
  }

  
/**
   * Retrieves the mathematical formula within this StoichiometryMath and
   * return it as an AST.
   * 
   * @return the math of this StoichiometryMath, or @c null if the math is not set.
   *
   *
 * @note The StoichiometryMath construct exists only in SBML Level&nbsp;2.
 * It is an optional construct available for defining the stoichiometries of
 * reactants and products in Reaction objects.  Note that a different
 * mechanism is used in SBML Level&nbsp;3, where StoichiometryMath is not
 * available.  Please consult the top of this libSBML StoichiometryMath
 * documentation for more information about the differences between SBML
 * Level&nbsp;2 and&nbsp;3 with respect to stoichiometries.
 *
   */ public new
 ASTNode getMath() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.StoichiometryMath_getMath(swigCPtr);
    ASTNode ret = (cPtr == global::System.IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  
/**
   * Predicate to test whether the math for this StoichiometryMath object
   * is set.
   * 
   * @return @c true if the formula (meaning the @c math subelement) of
   * this StoichiometryMath is set, @c false otherwise.
   *
   *
 * @note The StoichiometryMath construct exists only in SBML Level&nbsp;2.
 * It is an optional construct available for defining the stoichiometries of
 * reactants and products in Reaction objects.  Note that a different
 * mechanism is used in SBML Level&nbsp;3, where StoichiometryMath is not
 * available.  Please consult the top of this libSBML StoichiometryMath
 * documentation for more information about the differences between SBML
 * Level&nbsp;2 and&nbsp;3 with respect to stoichiometries.
 *
   */ public
 bool isSetMath() {
    bool ret = libsbmlPINVOKE.StoichiometryMath_isSetMath(swigCPtr);
    return ret;
  }

  
/**
   * Sets the 'math' expression of this StoichiometryMath instance to a
   * copy of the given ASTNode.
   *
   * @param math an ASTNode representing a formula tree.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   *
   *
 * @note The StoichiometryMath construct exists only in SBML Level&nbsp;2.
 * It is an optional construct available for defining the stoichiometries of
 * reactants and products in Reaction objects.  Note that a different
 * mechanism is used in SBML Level&nbsp;3, where StoichiometryMath is not
 * available.  Please consult the top of this libSBML StoichiometryMath
 * documentation for more information about the differences between SBML
 * Level&nbsp;2 and&nbsp;3 with respect to stoichiometries.
 *
   */ public new
 int setMath(ASTNode math) {
    int ret = libsbmlPINVOKE.StoichiometryMath_setMath(swigCPtr, ASTNode.getCPtr(math));
    return ret;
  }

  
/**
   * Calculates and returns a UnitDefinition object that expresses the
   * units returned by the math expression in this StoichiometryMath
   * object.
   *
   * The units are calculated based on the mathematical expression in the
   * StoichiometryMath and the model quantities referenced by
   * <code>&lt;ci&gt;</code> elements used within that expression.  The
   * StoichiometryMath::getDerivedUnitDefinition() method returns the
   * calculated units.
   *
   * Note that the functionality that facilitates unit analysis depends 
   * on the model as a whole.  Thus, in cases where the object has not 
   * been added to a model or the model itself is incomplete,
   * unit analysis is not possible and this method will return @c null.
   * 
   * @return a UnitDefinition that expresses the units of the math, 
   * or @c null if one cannot be constructed.
   *
   * @warning <span class='warning'>Note that it is possible the 'math'
   * expression in the StoichiometryMath instance contains literal numbers or
   * parameters with undeclared units.  In those cases, it is not possible to
   * calculate the units of the overall expression without making
   * assumptions.  LibSBML does not make assumptions about the units, and
   * StoichiometryMath::getDerivedUnitDefinition() only returns the units as
   * far as it is able to determine them.  For example, in an expression
   * <em>X + Y</em>, if <em>X</em> has unambiguously-defined units and
   * <em>Y</em> does not, it will return the units of <em>X</em>.  When using
   * this method, <strong>it is critical that callers also invoke the
   * method</strong> StoichiometryMath::containsUndeclaredUnits() <strong>to
   * determine whether this situation holds</strong>.  Callers should take
   * suitable action in those situations.</span>
   *
   * @see containsUndeclaredUnits()
   */ public
 UnitDefinition getDerivedUnitDefinition() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.StoichiometryMath_getDerivedUnitDefinition__SWIG_0(swigCPtr);
    UnitDefinition ret = (cPtr == global::System.IntPtr.Zero) ? null : new UnitDefinition(cPtr, false);
    return ret;
  }

  
/**
   * Predicate returning @c true if the math
   * expression of this StoichiometryMath object contains literal numbers
   * or parameters with undeclared units.
   * 
   * The StoichiometryMath::getDerivedUnitDefinition() method returns what
   * libSBML computes the units of the Stoichiometry to be, to the extent
   * that libSBML can compute them.  However, if the expression contains
   * literal numbers or parameters with undeclared units, libSBML may not
   * be able to compute the full units of the expression and will only
   * return what it can compute.  Callers should always use
   * StoichiometryMath::containsUndeclaredUnits() when using
   * StoichiometryMath::getDerivedUnitDefinition() to decide whether the
   * returned units may be incomplete.
   *
   * @return @c true if the math expression of this StoichiometryMath
   * includes numbers/parameters with undeclared units, @c false otherwise.
   *
   * @note A return value of @c true indicates that the UnitDefinition
   * returned by StoichiometryMath::getDerivedUnitDefinition() may not
   * accurately represent the units of the expression.
   *
   * @see getDerivedUnitDefinition()
   */ public
 bool containsUndeclaredUnits() {
    bool ret = libsbmlPINVOKE.StoichiometryMath_containsUndeclaredUnits__SWIG_0(swigCPtr);
    return ret;
  }

  
/**
   * Returns the libSBML type code of this object instance.
   *
   *
 * 
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * @if clike The set of possible type codes for core elements is defined in
 * the enumeration #SBMLTypeCode_t, and in addition, libSBML plug-ins for
 * SBML Level&nbsp;3 packages define their own extra enumerations of type
 * codes (e.g., #SBMLLayoutTypeCode_t for the Level&nbsp;3 Layout
 * package).@endif@if java In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.  @endif@if python In the Python language
 * interface for libSBML, the type codes are defined as static integer
 * constants in the interface class @link libsbml@endlink.@endif@if csharp In
 * the C# language interface for libSBML, the type codes are defined as
 * static integer constants in the interface class
 * @link libsbmlcs.libsbml@endlink.@endif  Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the 
 * <code>@if conly SBase_getPackageName()
 * @else SBase::getPackageName()
 * @endif</code>
 * method on the object.
 *
 * The exception to this is lists:  all SBML-style list elements have the type 
 * @link libsbml#SBML_LIST_OF SBML_LIST_OF@endlink, regardless of what package they 
 * are from.
 *
 *
   *
   * @return the SBML type code for this object:
   * @link libsbml#SBML_STOICHIOMETRY_MATH SBML_STOICHIOMETRY_MATH@endlink (default).
   *
   *
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getPackageName() and getTypeCode()</strong> (or 
 * ListOf::getItemTypeCode()).</span>
 *
 *
   *
   * @see getElementName()
   * @see getPackageName()
   */ public new
 int getTypeCode() {
    int ret = libsbmlPINVOKE.StoichiometryMath_getTypeCode(swigCPtr);
    return ret;
  }

  
/**
   * Returns the XML element name of this object, which for StoichiometryMath, is
   * always @c 'stoichiometryMath'.
   * 
   * @return the name of this element, i.e., @c 'stoichiometryMath'.
   */ public new
 string getElementName() {
    string ret = libsbmlPINVOKE.StoichiometryMath_getElementName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if
   * all the required elements for this StoichiometryMath object
   * have been set.
   *
   * @note The required elements for a StoichiometryMath object are:
   * @li 'math'
   *
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */ public new
 bool hasRequiredElements() {
    bool ret = libsbmlPINVOKE.StoichiometryMath_hasRequiredElements(swigCPtr);
    return ret;
  }

  
/**
   * Finds this StoichiometryMath's SpeciesReference parent and calls
   * unsetStoichiometryMath() on it, indirectly deleting itself.
   *
   * Overridden from the SBase function since the parent is not a ListOf.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public new
 int removeFromParentAndDelete() {
    int ret = libsbmlPINVOKE.StoichiometryMath_removeFromParentAndDelete(swigCPtr);
    return ret;
  }

  
/**
   *
 * Replaces all uses of a given @c SIdRef type attribute value with another
 * value.
 *
 *
 * 

 * In SBML, object identifiers are of a data type called <code>SId</code>.
 * In SBML Level&nbsp;3, an explicit data type called <code>SIdRef</code> was
 * introduced for attribute values that refer to <code>SId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to an identifier', but the effective
 * data type was the same as <code>SIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>SIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 *
 *
 *
 * This method works by looking at all attributes and (if appropriate)
 * mathematical formulas in MathML content, comparing the referenced
 * identifiers to the value of @p oldid.  If any matches are found, the
 * matching values are replaced with @p newid.  The method does @em not
 * descend into child elements.
 *
 * @param oldid the old identifier.
 * @param newid the new identifier.
 *
 *
   */ public new
 void renameSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.StoichiometryMath_renameSIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   *
 * Replaces all uses of a given @c UnitSIdRef type attribute value with
 * another value.
 *
 *
 * 
 * In SBML, unit definitions have identifiers of type <code>UnitSId</code>.  In
 * SBML Level&nbsp;3, an explicit data type called <code>UnitSIdRef</code> was
 * introduced for attribute values that refer to <code>UnitSId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to a unit identifier', but the effective
 * data type was the same as <code>UnitSIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>UnitSIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 *
 *
 *
 * This method works by looking at all unit identifier attribute values
 * (including, if appropriate, inside mathematical formulas), comparing the
 * referenced unit identifiers to the value of @p oldid.  If any matches
 * are found, the matching values are replaced with @p newid.  The method
 * does @em not descend into child elements.
 *
 * @param oldid the old identifier.
 * @param newid the new identifier.
 *
 *
   */ public new
 void renameUnitSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.StoichiometryMath_renameUnitSIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public new
 void replaceSIDWithFunction(string id, ASTNode function) {
    libsbmlPINVOKE.StoichiometryMath_replaceSIDWithFunction(swigCPtr, id, ASTNode.getCPtr(function));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

}

}
