/*
 * @file    TestSyncAnnotation.java
 * @brief   tests for improved syncAnnotation functions
 *
 * @author  Akiya Jouraku (Java conversion)
 * @author  Sarah Keating
 
 * 
 * ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
 *
 * DO NOT EDIT THIS FILE.
 *
 * This file was generated automatically by converting the file located at
 * src/sbml/test/TestSyncAnnotation.cpp
 * using the conversion program dev/utilities/translateTests/translateTests.pl.
 * Any changes made here will be lost the next time the file is regenerated.
 *
 * -----------------------------------------------------------------------------
 * This file is part of libSBML.  Please visit http://sbml.org for more
 * information about SBML, and the latest version of libSBML.
 *
 * Copyright 2005-2010 California Institute of Technology.
 * Copyright 2002-2005 California Institute of Technology and
 *                     Japan Science and Technology Corporation.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.  A copy of the license agreement is provided
 * in the file named "LICENSE.txt" included with this software distribution
 * and also available online as http://sbml.org/software/libsbml/license.html
 * -----------------------------------------------------------------------------
 */

package org.sbml.libsbml.test.annotation;

import org.sbml.libsbml.*;

import java.io.File;
import java.lang.AssertionError;

public class TestSyncAnnotation {

  static boolean equals(String a, String b)
  {
    return a.equals(b);
  }
  
  static void assertTrue(boolean condition) throws AssertionError
  {
    if (condition == true)
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertEquals(Object a, Object b) throws AssertionError
  {
    if ( (a == null) && (b == null) )
    {
      return;
    }
    else if ( (a == null) || (b == null) )
    {
      throw new AssertionError();
    }
    else if (a.equals(b))
    {
      return;
    }

    throw new AssertionError();
  }

  static void assertNotEquals(Object a, Object b) throws AssertionError
  {
    if ( (a == null) && (b == null) )
    {
      throw new AssertionError();
    }
    else if ( (a == null) || (b == null) )
    {
      return;
    }
    else if (a.equals(b))
    {
      throw new AssertionError();
    }
  }

  static void assertEquals(boolean a, boolean b) throws AssertionError
  {
    if ( a == b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertNotEquals(boolean a, boolean b) throws AssertionError
  {
    if ( a != b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertEquals(int a, int b) throws AssertionError
  {
    if ( a == b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertNotEquals(int a, int b) throws AssertionError
  {
    if ( a != b )
    {
      return;
    }
    throw new AssertionError();
  }
  private SBMLDocument d;
  private Model m;

  protected void setUp() throws Exception
  {
    String filename = "../../sbml/annotation/test/test-data/annotationL3_2.xml";
    d = libsbml.readSBML(filename);
    m = d.getModel();
  }

  protected void tearDown() throws Exception
  {
  }

  public void test_SyncAnnotation_deleteCVTerms()
  {
    Compartment c = m.getCompartment(1);
    XMLNode xml = RDFAnnotationParser.deleteRDFCVTermAnnotation(c.getAnnotation());
    String expected = "<annotation>\n"
 + 
    "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "    <jd2:header>\n"
 + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "    </jd2:header>\n"
 + 
    "  </jd2:JDesignerLayout>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG>\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "    <rdf:Description>\n"
 + 
    "      <rdf:other/>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>";
    assertEquals( true, equals(expected,xml.toXMLString()) );
  }

  public void test_SyncAnnotation_deleteModelOnly()
  {
    Compartment c = m.getCompartment(1);
    XMLNode xml = RDFAnnotationParser.deleteRDFHistoryAnnotation(c.getAnnotation());
    String expected = "<annotation>\n"
 + 
    "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "    <jd2:header>\n"
 + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "    </jd2:header>\n"
 + 
    "  </jd2:JDesignerLayout>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "    <rdf:Description>\n"
 + 
    "      <rdf:other/>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>";
    assertEquals( true, equals(expected,xml.toXMLString()) );
  }

  public void test_SyncAnnotation_deleteModelOnly_1()
  {
    Compartment c = m.getCompartment(7);
    XMLNode xml = RDFAnnotationParser.deleteRDFHistoryAnnotation(c.getAnnotation());
    String expected = "<annotation>\n"
 + 
    "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "    <jd2:header>\n"
 + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "    </jd2:header>\n"
 + 
    "  </jd2:JDesignerLayout>\n"
 + 
    "</annotation>";
    assertEquals( true, equals(expected,xml.toXMLString()) );
    xml = RDFAnnotationParser.deleteRDFHistoryAnnotation(null);
    assertTrue( xml == null );
    xml = RDFAnnotationParser.deleteRDFHistoryAnnotation(XMLNode.convertStringToXMLNode("<notannotatio/>"));
    assertTrue( xml == null );
  }

  public void test_SyncAnnotation_modifyBoth_1()
  {
    Compartment c = m.getCompartment(0);
    ModelHistory mh = m.getModelHistory().cloneObject();
    CVTerm cv = m.getCVTerm(0).cloneObject();
    c.setModelHistory(mh);
    c.addCVTerm(cv);
    c.unsetCVTerms();
    String expected = "<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000002\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
    c.unsetModelHistory();
    c.addCVTerm(cv);
    String expected1 = "<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000002\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected1,c.toSBML()) );
    c.setModelHistory(mh);
    c.unsetCVTerms();
    c.addCVTerm(cv);
    String expected2 = "<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000002\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected2,c.toSBML()) );
  }

  public void test_SyncAnnotation_modifyBoth_2()
  {
    Compartment c = m.getCompartment(0);
    ModelHistory mh = m.getModelHistory().cloneObject();
    CVTerm cv = m.getCVTerm(0).cloneObject();
    c.setModelHistory(mh);
    c.unsetModelHistory();
    c.addCVTerm(cv);
    String expected = "<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000002\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  public void test_SyncAnnotation_modifyBoth_3()
  {
    Compartment c = m.getCompartment(0);
    ModelHistory mh = m.getModelHistory().cloneObject();
    CVTerm cv = m.getCVTerm(0).cloneObject();
    c.setModelHistory(mh);
    c.addCVTerm(cv);
    String expected = "<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000002\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  public void test_SyncAnnotation_modifyBoth_4()
  {
    Compartment c = m.getCompartment(1);
    ModelHistory mh = c.getModelHistory().cloneObject();
    CVTerm cv = c.getCVTerm(0).cloneObject();
    c.unsetModelHistory();
    c.unsetCVTerms();
    String expected = "<compartment metaid=\"_000003\" id=\"A\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "      <jd2:header>\n"
 + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "      </jd2:header>\n"
 + 
    "    </jd2:JDesignerLayout>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description>\n"
 + 
    "        <rdf:other/>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
    c.setModelHistory(mh);
    c.addCVTerm(cv);
    c.unsetCVTerms();
    String expected1 = "<compartment metaid=\"_000003\" id=\"A\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "      <jd2:header>\n"
 + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "      </jd2:header>\n"
 + 
    "    </jd2:JDesignerLayout>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "      <rdf:Description>\n"
 + 
    "        <rdf:other/>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected1,c.toSBML()) );
    c.unsetModelHistory();
    c.unsetCVTerms();
    c.addCVTerm(cv);
    String expected2 = "<compartment metaid=\"_000003\" id=\"A\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "      <jd2:header>\n"
 + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "      </jd2:header>\n"
 + 
    "    </jd2:JDesignerLayout>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "      <rdf:Description>\n"
 + 
    "        <rdf:other/>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected2,c.toSBML()) );
    c.unsetModelHistory();
    c.unsetCVTerms();
    c.addCVTerm(cv);
    c.setModelHistory(mh);
    String expected3 = "<compartment metaid=\"_000003\" id=\"A\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "      <jd2:header>\n"
 + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "      </jd2:header>\n"
 + 
    "    </jd2:JDesignerLayout>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "      <rdf:Description>\n"
 + 
    "        <rdf:other/>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected3,c.toSBML()) );
  }

  public void test_SyncAnnotation_modifyCVTerms_1()
  {
    Compartment c = m.getCompartment(4);
    CVTerm cv = c.getCVTerm(0).cloneObject();
    c.unsetCVTerms();
    c.addCVTerm(cv);
    String expected = "<compartment metaid=\"_000012\" id=\"cc\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000012\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  public void test_SyncAnnotation_modifyCVTerms_2()
  {
    m.unsetCVTerms();
    String expected = "<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000001\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG>\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>";
    assertEquals( true, equals(expected,m.getAnnotation().toXMLString()) );
  }

  public void test_SyncAnnotation_modifyCVTerms_3()
  {
    CVTerm cv = m.getCVTerm(0).cloneObject();
    m.unsetCVTerms();
    m.addCVTerm(cv);
    String expected = "<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000001\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG>\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>";
    assertEquals( true, equals(expected,m.getAnnotation().toXMLString()) );
  }

  public void test_SyncAnnotation_modifyCVTerms_4()
  {
    CVTerm cv = m.getCVTerm(0).cloneObject();
    Compartment c = m.getCompartment(0);
    c.addCVTerm(cv);
    String expected = "<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000002\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  public void test_SyncAnnotation_modifyCVTerms_5()
  {
    Compartment c = m.getCompartment(6);
    CVTerm cv = c.getCVTerm(0).cloneObject();
    c.unsetCVTerms();
    c.addCVTerm(cv);
    String expected = "<compartment metaid=\"_000042\" id=\"cc1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000042\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "      <rdf:Description/>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  public void test_SyncAnnotation_modifyHistory_1()
  {
    Compartment c = m.getCompartment(3);
    ModelHistory mh = c.getModelHistory().cloneObject();
    c.unsetModelHistory();
    c.setModelHistory(mh);
    String expected = "<compartment metaid=\"_000004\" id=\"C\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000004\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  public void test_SyncAnnotation_modifyHistory_2()
  {
    m.unsetModelHistory();
    String expected = "<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000001\">\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>";
    assertEquals( true, equals(expected,m.getAnnotation().toXMLString()) );
  }

  public void test_SyncAnnotation_modifyHistory_3()
  {
    ModelHistory mh = m.getModelHistory().cloneObject();
    m.unsetModelHistory();
    m.setModelHistory(mh);
    String expected = "<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000001\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>";
    assertEquals( true, equals(expected,m.getAnnotation().toXMLString()) );
  }

  public void test_SyncAnnotation_modifyHistory_4()
  {
    Compartment c = m.getCompartment(0);
    ModelHistory mh = m.getModelHistory().cloneObject();
    c.setModelHistory(mh);
    String expected = "<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000002\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  public void test_SyncAnnotation_modifyHistory_5()
  {
    Compartment c = m.getCompartment(5);
    ModelHistory mh = c.getModelHistory().cloneObject();
    c.unsetModelHistory();
    c.setModelHistory(mh);
    String expected = "<compartment metaid=\"_000032\" id=\"C1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000032\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "      <rdf:other/>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  public void test_SyncAnnotation_noChanges_1()
  {
    Compartment c = m.getCompartment(1);
    String expected = "<compartment metaid=\"_000003\" id=\"A\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "      <jd2:header>\n"
 + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "      </jd2:header>\n"
 + 
    "    </jd2:JDesignerLayout>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG>\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "      <rdf:Description>\n"
 + 
    "        <rdf:other/>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  public void test_SyncAnnotation_noChanges_2()
  {
    String expected = "<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000001\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG>\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>";
    assertEquals( true, equals(expected,m.getAnnotation().toXMLString()) );
  }

  public void test_SyncAnnotation_stringChangesMetaid()
  {
    Compartment c = new  Compartment(3,1);
    c.setMetaId("_000005");
    c.setId("A");

    String addedAnn = "<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>";

    c.setAnnotation(addedAnn);

    String expected = "<compartment metaid=\"_000005\" id=\"A\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000005\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  public void test_SyncAnnotation_stringChangesMetaid1()
  {
    Model c = new  Model(2,3);
    c.setMetaId("_000005");
    c.setId("A");

    String addedAnn = "<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>";

    c.setAnnotation(addedAnn);

    String expected = "<model metaid=\"_000005\" id=\"A\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000005\">\n"
 + 
    "        <dc:creator rdf:parseType=\"Resource\">\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG>\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</model>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  public void test_SyncAnnotation_stringChangesMetaid2()
  {
    Compartment c = new  Compartment(2,3);
    c.setMetaId("_000005");
    c.setId("A");

    String addedAnn = "<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>";

    c.setAnnotation(addedAnn);

    String expected = "<compartment metaid=\"_000005\" id=\"A\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000005\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  public void test_SyncAnnotation_stringChangesMetaid3()
  {
    Model c = new  Model(3,1);
    c.setMetaId("_000005");
    c.setId("A");

    String addedAnn = "<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>";

    c.setAnnotation(addedAnn);

    String expected = "<model metaid=\"_000005\" id=\"A\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000005\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</model>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  public void test_SyncAnnotation_stringHistoryWhenNotValid()
  {
    Compartment c = new  Compartment(2,3);
    c.setMetaId("_000003");
    c.setId("A");

    String addedAnn = "<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000005\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>";

    c.setAnnotation(addedAnn);

    String expected = "<compartment metaid=\"_000003\" id=\"A\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "      <rdf:Description rdf:about=\"#_000005\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  /**
   * Loads the SWIG-generated libSBML Java module when this class is
   * loaded, or reports a sensible diagnostic message about why it failed.
   */
  static
  {
    String varname;
    String shlibname;

    if (System.getProperty("mrj.version") != null)
    {
      varname = "DYLD_LIBRARY_PATH";    // We're on a Mac.
      shlibname = "libsbmlj.jnilib and/or libsbml.dylib";
    }
    else
    {
      varname = "LD_LIBRARY_PATH";      // We're not on a Mac.
      shlibname = "libsbmlj.so and/or libsbml.so";
    }

    try
    {
      System.loadLibrary("sbmlj");
      // For extra safety, check that the jar file is in the classpath.
      Class.forName("org.sbml.libsbml.libsbml");
    }
    catch (SecurityException e)
    {
      e.printStackTrace();
      System.err.println("Could not load the libSBML library files due to a"+
                         " security exception.\n");
      System.exit(1);
    }
    catch (UnsatisfiedLinkError e)
    {
      e.printStackTrace();
      System.err.println("Error: could not link with the libSBML library files."+
                         " It is likely\nyour " + varname +
                         " environment variable does not include the directories\n"+
                         "containing the " + shlibname + " library files.\n");
      System.exit(1);
    }
    catch (ClassNotFoundException e)
    {
      e.printStackTrace();
      System.err.println("Error: unable to load the file libsbmlj.jar."+
                         " It is likely\nyour -classpath option and CLASSPATH" +
                         " environment variable\n"+
                         "do not include the path to libsbmlj.jar.\n");
      System.exit(1);
    }
  }
}
