/* quiescenceRecord.t.cc
 */
#include "osl/search/quiescenceRecord.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class QuiescenceRecordTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(QuiescenceRecordTest);
  CPPUNIT_TEST(testBestMoves);
  CPPUNIT_TEST_SUITE_END();
public:
  void testBestMoves();
};

CPPUNIT_TEST_SUITE_REGISTRATION(QuiescenceRecordTest);

using namespace osl;
using namespace osl::search;

void QuiescenceRecordTest::testBestMoves()
{
  QuiescenceRecord r;
  CPPUNIT_ASSERT_EQUAL(Move(), r.bestMove());

  BestMoves best_moves;
  CPPUNIT_ASSERT(best_moves.sizeFilled() == 0);
  
  MoveVector moves;
  for (int x=1; x<=9; ++x)
    moves.push_back(Move(Square(x,5), GOLD, BLACK));

  best_moves.add(moves[0]);
  CPPUNIT_ASSERT_EQUAL(moves[0], best_moves[0]);
  
  best_moves.add(moves[1]);
  CPPUNIT_ASSERT_EQUAL(moves[1], best_moves[0]);
  CPPUNIT_ASSERT_EQUAL(moves[0], best_moves[1]);

  MoveVector test;
  test.push_back(moves[2]);
  best_moves.addSecondary(test);
  
  CPPUNIT_ASSERT_EQUAL(moves[1], best_moves[0]); // best move remains
  CPPUNIT_ASSERT_EQUAL(moves[2], best_moves[1]); // inserted here
  CPPUNIT_ASSERT_EQUAL(moves[0], best_moves[2]);

  test.push_back(moves[3]);
  test.push_back(moves[4]);
  best_moves.addSecondary(test);

  CPPUNIT_ASSERT_EQUAL((size_t)4, best_moves.size()); // best move remains
  CPPUNIT_ASSERT_EQUAL(moves[1], best_moves[0]); // best move remains
  CPPUNIT_ASSERT_EQUAL(moves[2], best_moves[1]); // same contents stored
  CPPUNIT_ASSERT_EQUAL(moves[3], best_moves[2]);
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
