/* blockLongEffect.h
 */
#ifndef _MOVE_CLASSIFIER_BLOCK_LONG_EFFECT_H
#define _MOVE_CLASSIFIER_BLOCK_LONG_EFFECT_H

#include "osl/state/numEffectState.h"

namespace osl
{
  namespace move_classifier
  {
    /**
     * 長い利きをブロックする手の判定.
     * @param P - 動かす側のプレイヤー
     * @param T - ブロックする駒の種類(ROOK,BISHOP,LANCE)
     */
    template<Player P,Ptype T>
    struct BlockLongEffect
    {
      /**
       * 相手の長い駒をブロックする手.
       * もともとブロックしている場合も近づくならtrueにする
       * 盤端(相手の駒の前)でのブロックはブロックに入れない
       * 駒を取る手はブロックに入れない
       * 複数の駒をブロックする時は条件を満たすものを探すまで全部調べる
       * @param state - 動かす前の盤面
       * @param ptype - 動かす駒の移動後のptype
       * @param from - 動かす駒の移動前の位置
       * @param to - 動かす駒の移動後の位置
       */
      static bool
#ifdef __GNUC__
	__attribute__ ((pure))
#endif
      isMember(NumEffectState const& state,
	       Ptype /*ptype*/,Square /*from*/,Square to)
      {
	BOOST_STATIC_ASSERT((PtypeFuns<T>::hasLongMove));
	if(!state.pieceAt(to).isEmpty())return false;
	mask_t e1=state.piecesOnBoard(PlayerTraits<P>::opponent).getMask(PtypeFuns<T>::indexNum);
	mask_t e2=state.effectSetAt(to).getMask(PtypeFuns<T>::indexNum)>>8;
	mask_t e3=e1 & e2 & mask_t::makeDirect(PtypeFuns<T>::indexMask);
	while(!e3.none()){
	  int num=e3.takeOneBit()+((PtypeFuns<T>::indexNum)<<5);
	  Piece p=state.pieceOf(num);
	  assert(p.isPiece());
	  assert(p.owner()==PlayerTraits<P>::opponent);
	  assert(unpromote(p.ptype())==T);
	  Offset o=Board_Table.getShortOffset(Offset32(to,p.square()));
	  // EMPTY or Pのpiece or alt(P)のpiece
	  Piece p1=state.pieceAt(to+o);
	  if(! p1.isEdge())
	    return true;
	}
	return false;
      }
    };

    template<Player P>
    struct BlockLongAny
    {
      static bool isMember(const NumEffectState& state,
			   Ptype ptype,Square from,Square to) {
	return BlockLongEffect<P,ROOK>::isMember(state, ptype, from, to)
	  || BlockLongEffect<P,BISHOP>::isMember(state, ptype, from, to)
	  || BlockLongEffect<P,LANCE>::isMember(state, ptype, from, to);
      }
    };
  }
}
#endif /* _MOVE_CLASSIFIER_BLOCK_LONG_EFFECT_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
