#ifndef OSL_CSA_TIME_H
#define OSL_CSA_TIME_H
#include "osl/misc/milliSeconds.h"
#include <string>
#include <cmath>

namespace osl
{
  namespace game_playing
  {
  class CsaTime
  {
    MilliSeconds start, opmove, mymove;
    long mytimeleft, optimeleft;
  public:
    explicit CsaTime(long timeleft) 
      : mytimeleft(timeleft), optimeleft(timeleft)
    {
      mymove = opmove = start = MilliSeconds::now();
    }
    CsaTime(long myTimeLeft, long opTimeLeft) 
      : mytimeleft(myTimeLeft), optimeleft(opTimeLeft)
    {
      mymove = opmove = start = MilliSeconds::now();
    }
    long makeOpMove() {
      opmove = MilliSeconds::now();
      long ret = (long)floor((opmove - mymove).toSeconds());
      if (ret == 0) { ret = 1; }
      optimeleft -= ret;
      return ret;
    }
    long makeMyMove() {
      mymove = MilliSeconds::now();
      long ret = (long)floor((mymove - opmove).toSeconds());
      if(ret == 0) { ret = 1; }
      mytimeleft -= ret;
      return ret;
    }
    long getMyLeft() const { return mytimeleft; }
    long getOpLeft() const { return optimeleft; }
    const std::string getStart() const;
    static const std::string curruntTime();
  };
} // namespace game_playing
} // namespace osl
#endif // OSL_CSA_TIME
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
