#include "osl/move_order/captureSort.h"
#include "osl/move_generator/allMoves.h"
#include "osl/move_action/store.h"
#include "osl/record/record.h"
#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"
#include "osl/container/moveVector.h"
#include "osl/state/numEffectState.h"
#include "osl/oslConfig.h"

#include <string>
#include <fstream>
#include <iostream>
#include <set>
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class CaptureSortTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(CaptureSortTest);
  CPPUNIT_TEST(testOrder);
  CPPUNIT_TEST_SUITE_END();
public:
  void testOrder(const std::string& filename);
  void testOrder();
  bool isSorted(const osl::MoveVector& moves);
  bool hasSameMember(const osl::MoveVector& l, const osl::MoveVector& r);
};

using namespace osl;
using namespace osl::move_generator;
using namespace osl::move_action;

CPPUNIT_TEST_SUITE_REGISTRATION(CaptureSortTest);

bool CaptureSortTest::isSorted(const MoveVector& moves)
{
  MoveVector::const_iterator p=moves.begin();
  for (;(p!=moves.end()) && (p->capturePtype() != PTYPE_EMPTY); ++p)
    ;
  // 一度 取らない手が表れたら，もう取る手はない
  for (; p!=moves.end(); ++p)
  {
    if (p->capturePtype() != PTYPE_EMPTY)
    {
      std::cerr << moves;
      return false;
    }
  }
  return true;
}

bool CaptureSortTest::hasSameMember(const MoveVector& l, const MoveVector& r)
{
  typedef std::set<Move> set_t;
  set_t ls(l.begin(), l.end()), rs(r.begin(), r.end());
  return ls == rs;
}

void CaptureSortTest::testOrder(const std::string& fileName)
{
  Record rec=CsaFile(fileName).getRecord();
  NumEffectState state(rec.getInitialState());
  const vector<osl::Move> moves=rec.getMoves();
  for (unsigned int i=0;i<moves.size();i++)
  {
    MoveVector curMoves;
    {
      Store action(curMoves);
      AllMoves<Store>::generate(state.turn(),state,action);
    }
    curMoves.unique();

    MoveVector sorted = curMoves;
    CaptureSort::sort(sorted.begin(), sorted.end());
    CPPUNIT_ASSERT(isSorted(sorted));
    CPPUNIT_ASSERT(hasSameMember(sorted, curMoves));

    const Move move=moves[i];
    state.makeMove(move);
  }
}

void CaptureSortTest::testOrder(){
  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  int i=0;
  std::string fileName;
  while((ifs >> fileName) && ++i<10){
    if(fileName == "") break;
    testOrder(std::string(OslConfig::testCsaFile(fileName)));
  }
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
