/* progress32.h
 */
#ifndef PROGRESS_PROGRESS32_H
#define PROGRESS_PROGRESS32_H

#include <cassert>
namespace osl
{
  namespace progress
  {
    /**
     * 0-31 の進行度を表現
     */
    class Progress32
    {
      int progress32;
    public:
      explicit Progress32(int value) : progress32(value)
      {
	assert(isValid());
      }
      int value() const { return progress32; }
      bool isValid() const { 
	return (progress32 >= 0) && (progress32 < 32);
      }
    };
    inline bool operator==(Progress32 l, Progress32 r)
    {
      return l.value() == r.value();
    }
    inline bool operator!=(Progress32 l, Progress32 r)
    {
      return ! (l == r);
    }
    inline bool operator<(Progress32 l, Progress32 r)
    {
      return l.value() < r.value();
    }
  } // namespace progress
  using progress::Progress32;
} // namespace osl

#endif /* PROGRESS_PROGRESS32_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
