# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::RU;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20241212130807;

my $formatters = [
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '[0-79]',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                [0-356]2|
                4[29]|
                7|
                8[27]
              )|
              2(?:
                13[03-69]|
                62[013-9]
              )
            )|
            72[1-57-9]2
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                0(?:
                  [356]|
                  4[023]
                )|
                [18]|
                2(?:
                  3[013-9]|
                  5
                )|
                3[45]|
                43[013-79]|
                5(?:
                  3[1-8]|
                  4[1-7]|
                  5
                )|
                6(?:
                  3[0-35-9]|
                  [4-6]
                )
              )|
              2(?:
                1(?:
                  3[178]|
                  [45]
                )|
                [24-689]|
                3[35]|
                7[457]
              )
            )|
            7(?:
              14|
              23
            )4[0-8]|
            71(?:
              33|
              45
            )[1-79]
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{5})(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3-$4',
                  'leading_digits' => '
            [349]|
            8(?:
              [02-7]|
              1[1-8]
            )
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '8',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'geographic' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'mobile' => '9\\d{9}',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(80[39]\\d{7})',
                'toll_free' => '
          8(?:
            0[04]|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{ru} = {"7834", "Республика\ Мордовия",
"771435", "Житикаринский\ р\-н",
"7818", "Архангельская\ обл\.",
"772156", "Шахтинск",
"771039", "Приозерск",
"7845", "Саратовская\ обл\.",
"771041", "Актау\,\ Жезказган",
"7862", "Краснодарский\ край",
"771032", "Каражал",
"7846", "Самарская\ обл\.",
"771131", "Зеленовский\ р\-н",
"7833", "Кировская\ обл\.",
"771335", "Шалкарский\ р\-н",
"771149", "Акжаикский\ р\-н",
"772838", "Коксуский\ р\-н",
"771142", "Акжаикский\ р\-н",
"771630", "Боровое",
"77272956", "Талгар",
"772340", "Зайсанский\ р\-н",
"772771", "Карасайский\ р\-н",
"772545", "Икан",
"7394", "Республика\ Тыва",
"77102", "Жезказган",
"771455", "Костанайский\ р\-н",
"771037", "Актогайский\ р\-н",
"7817", "Вологодская\ обл\.",
"7385", "Алтайский\ край",
"771434", "Денисовский\ р\-н",
"736", "Республика\ Крым",
"771843", "Майский\ р\-н",
"7821", "Республика\ Коми",
"772230", "Урджарский\ р\-н",
"771836", "Щербактинский\ р\-н",
"772544", "Шаульдер",
"77135", "Актюбинская\ область",
"772778", "Уйгурский\ р\-н",
"771454", "Наурзумский\ р\-н",
"7481", "Смоленская\ обл\.",
"771147", "Акжаикский\ р\-н",
"771334", "Мугалжарский\ р\-н",
"772842", "Кербулакский\ р\-н",
"771138", "Казталовский\ р\-н",
"772831", "Панфиловский\ р\-н",
"772644", "Таласский\ р\-н",
"7813", "Ленинградская\ обл\.",
"77213", "Темиртау",
"772438", "Казалинский\ р\-н",
"77222", "Семипалатинск",
"772252", "Абайский\ р\-н",
"7349", "Ямало\-Ненецкий\ АО",
"771233", "Курмангазинский\ р\-н",
"772154", "Бухар\-Жырауский\ р\-н",
"740", "Калининградская\ обл\.",
"7872", "Республика\ Дагестан",
"77145834", "Красногорск",
"771537", "Тимирязевский\ р\-н",
"7814", "Республика\ Карелия",
"772338", "Уланский\ р\-н",
"7426", "Еврейская\ автономная\ обл\.",
"772840", "Кербулакский\ р\-н",
"771648", "Жаркаинский\ р\-н",
"7492", "Владимирская\ обл\.",
"772347", "Жарминский\ р\-н",
"772239", "Урджарский\ р\-н",
"771637", "Коргалжынский\ р\-н",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"771436", "Тарановский\ р\-н",
"77162", "Кокшетау",
"772257", "Шульбинск",
"772351", "Бородулихинский\ р\-н",
"7353", "Оренбургская\ обл\.",
"772533", "Туркестан",
"7474", "Липецкая\ обл\.",
"77106", "Сатпаев",
"772633", "Жамбылский\ р\-н",
"771343", "Иргизский\ р\-н",
"772431", "Жалагашский\ р\-н",
"7345", "Тюменская\ обл\.",
"771030", "Жана\-Аркинский\ р\-н",
"77152", "Петропавловск",
"77187", "Экибастуз",
"771336", "Хромтауский\ р\-н",
"7712302", "Тенгизшевройл",
"77185", "Шалдай",
"771532", "Аккайынский\ р\-н",
"771541", "Мамлютский\ р\-н",
"771539", "Кызылжарский\ р\-н",
"771641", "Астраханский\ р\-н",
"7473", "Воронежская\ обл\.",
"772546", "Шолаккорган",
"771834", "Успенский\ р\-н",
"771639", "Енбекшилдерский\ р\-н",
"771632", "Зерендинский\ р\-н",
"771140", "Бокейординский\ р\-н",
"772342", "Катон\-Карагайский\ р\-н",
"771456", "Качар",
"771443", "Мендыкаринский\ р\-н",
"772237", "Аязог",
"772331", "Глубоковский\ р\-н",
"771333", "Мугалжарский\ р\-н",
"772432", "Шиелийский\ р\-н",
"772439", "Аральский\ р\-н",
"771040", "Жайрем\ \(ГОК\)",
"7873", "Республика\ Ингушетия",
"772643", "Шуский\ р\-н",
"7812", "г\.\ Санкт\-Петербург",
"772543", "Аксумбе",
"771651", "Целиноградский\ р\-н",
"77232", "Усть\-Каменогорск",
"771446", "Узункольский\ р\-н",
"771453", "Аулиекольский\ р\-н",
"7841", "Пензенская\ обл\.",
"7494", "Костромская\ обл\.",
"771433", "Лисаковск",
"772332", "Шемонаихинский\ р\-н",
"772339", "Курчумский\ р\-н",
"772341", "Катон\-Карагайский\ р\-н",
"772536", "Кентау",
"771844", "Иртышский\ р\-н",
"771649", "Жаксынский\ р\-н",
"771631", "Шортандинский\ р\-н",
"771642", "Егиндыкольский\ р\-н",
"771130", "Зеленовский\ р\-н",
"7302", "Забайкальский\ край",
"771542", "Уалихановский\ р\-н",
"772636", "Кордай",
"77242", "Кызылорда",
"771531", "Магжана\ Жумабаева\ р\-н",
"771346", "Темирский\ р\-н",
"7493", "Ивановская\ обл\.",
"772770", "Жамбылский\ р\-н",
"7381", "Омская\ обл\.",
"772437", "Кармакшинский\ р\-н",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"7352", "Курганская\ обл\.",
"772251", "Курчатов",
"7472", "Белгородская\ обл\.",
"771647", "Есильский\ р\-н",
"7486", "Орловская\ обл\.",
"772337", "Серебрянск",
"771538", "Кызылжарский\ р\-н",
"771236", "Махамбетский\ р\-н",
"772830", "Алакольский\ р\-н",
"771638", "Аккольский\ р\-н",
"772144", "Нуринский\ р\-н",
"771547", "Жамбылский\ р\-н",
"771845", "Павлодар",
"7485", "Ярославская\ обл\.",
"7413", "Магаданская\ обл\.",
"772348", "Кокпектинский\ р\-н",
"771833", "Качирский\ р\-н",
"771038", "Сыры\-Шаган",
"771444", "Узункольский\ р\-н",
"7878", "Республика\ Карачаево\-Черкесская",
"77282", "Талдыкорган",
"7863", "Ростовская\ обл\.",
"772757", "Акший",
"7421", "Хабаровский\ край",
"772832", "Аксуский\ р\-н",
"772839", "Саркандский\ р\-н",
"772777", "Райымбекский\ р\-н",
"772634", "Жанатас",
"772725", "Отеген\-Батыр",
"772841", "Аксуский\ р\-н",
"7820", "Вологодская\ обл\.",
"7712303", "Тензиз",
"771235", "Макатский\ р\-н",
"771137", "Чингирлауский\ р\-н",
"772534", "Жетысай",
"772935", "Каракиянский\ р\-н",
"7498", "Московская\ обл\.",
"7877", "Республика\ Адыгея",
"77112", "Уральск",
"7341", "Республика\ Удмуртская",
"77279", "Алматы",
"772759", "Алматинская\ область",
"771031", "Шетский\ р\-н",
"771042", "Акой",
"772752", "Илийский\ р\-н",
"77272", "Алма\-Ата",
"771445", "Алтынсаринский\ р\-н",
"771234", "Индерский\ р\-н",
"771540", "Уалихановский\ р\-н",
"733", "Байконыр",
"772153", "Абайский\ р\-н",
"772146", "Каркаралинск",
"772837", "Алакольский\ р\-н",
"772779", "Райымбекский\ р\-н",
"772535", "Шардара",
"772934", "Жанаозен",
"772772", "Капчагай",
"772330", "Зыряновский\ р\-н",
"77125", "Атырауская\ область",
"772635", "Жуалынский\ р\-н",
"771345", "Байганинский\ р\-н",
"771139", "Таскалинский\ р\-н",
"771141", "Жангалинский\ р\-н",
"771132", "Теректинский\ р\-н",
"771640", "Сандыктауский\ р\-н",
"772834", "Каратальский\ р\-н",
"772639", "Сарысуский\ р\-н",
"771546", "Акжарский\ р\-н",
"772641", "Таласский\ р\-н",
"7495", "Московская\ обл\.",
"772937", "Каракиянский\ р\-н",
"772632", "Меркенский\ р\-н",
"771237", "Жылыойский\ р\-н",
"771342", "Каргалинский\ р\-н",
"771135", "Жанибекский\ р\-н",
"771349", "Шалкарский\ р\-н",
"7831", "Нижегородская\ обл\.",
"771331", "Мартукский\ р\-н",
"772336", "Риддер",
"771451", "Сарыкольский\ р\-н",
"7496", "г\.\ Москва",
"772532", "Абая",
"771646", "Буландинский\ р\-н",
"772539", "Казыгурт",
"772775", "Енбекшиказахский\ р\-н",
"772541", "Мырзакент",
"771633", "Ерейментауский\ р\-н",
"772343", "Курчумский\ р\-н",
"771442", "Федоровский\ р\-н",
"77252", "Шымкент",
"771449", "Тарановский\ р\-н",
"771431", "Рудный",
"772436", "Сырдарьинский\ р\-н",
"77262", "Тараз",
"771533", "Айыртауский\ р\-н",
"7391", "Красноярский\ край",
"7851", "Астраханская\ обл\.",
"771347", "Айтекебийский\ р\-н",
"771232", "Атырауская\ область",
"7483", "Брянская\ обл\.",
"771239", "Макатский\ р\-н",
"7415", "Камчатский\ край",
"772548", "Шаян",
"772774", "Талгарский\ р\-н",
"772637", "Байзакский\ р\-н",
"772932", "Бейнеуский\ р\-н",
"771458", "Костанайская\ область",
"7499", "г\.\ Москва",
"772835", "Текели",
"772537", "Сарыагаш",
"771840", "Баянаульский\ р\-н",
"7416", "Амурская\ обл\.",
"771134", "Сырымский\ р\-н",
"7879", "Ставропольский\ край",
"77273", "Алма\-Ата",
"771447", "Карабалыкский\ р\-н",
"7484", "Калужская\ обл\.",
"77122", "Атырау",
"771438", "Амангельдинский\ р\-н",
"7342", "Пермский\ край",
"77292", "Актау",
"772334", "Уланский\ р\-н",
"772138", "Бухар\-Жырауский\ р\-н",
"771842", "Майский\ р\-он",
"7301", "Республика\ Бурятия",
"771644", "Аршалынский\ р\-н",
"771831", "Железинский\ р\-н",
"7487", "Тульская\ обл\.",
"771544", "Жамбылский\ р\-н",
"772836", "Ескельдинский\ р\-н",
"771230", "Атырауская\ область",
"772147", "Каркаралинский\ р\-н",
"7842", "Ульяновская\ обл\.",
"7865", "Ставропольский\ край",
"772843", "Лепсы",
"7811", "Псковская\ обл\.",
"77245", "Кызылординская\ область",
"7866", "Республика\ Кабардино\-Балкарская",
"771545", "Жамбылский\ р\-н",
"772530", "Темирлановка",
"771136", "Акжаикский\ р\-н",
"772149", "Осакаровский\ р\-н",
"772335", "Зыряновск",
"772131", "Абайский\ р\-н",
"771838", "Майский\ р\-он",
"771340", "Хобдинский\ р\-н",
"771645", "Степногорск",
"772776", "Енбекшиказахский\ р\-н",
"771033", "Шетский\ р\-н",
"7471", "Курская\ обл\.",
"77224", "Эмельтау",
"7351", "Челябинская\ обл\.",
"7869", "г\.\ Севастополь",
"772435", "Жанакорганский\ р\-н",
"771143", "Теректинский\ р\-н",
"771440", "Амангельдинский\ р\-н",
"7382", "Томская\ обл\.",
"771330", "Хромтауский\ р\-н",
"771043", "Жайрем\ \(поселок\)",
"7836", "Республика\ Марий\ Эл",
"771635", "Жаксынский\ р\-н",
"772345", "Жарминский\ р\-н",
"772132", "Нуринский\ р\-н",
"772640", "Мойынкумский\ р\-н",
"772540", "Арыс",
"7844", "Волгоградская\ обл\.",
"7491", "Рязанская\ обл\.",
"771146", "Акжаикский\ р\-н",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"771535", "Габита\ Мусрепова\ р\-н",
"771837", "Аксуский\ р\-н",
"771430", "Аркалык",
"7871", "Республика\ Чеченская",
"7855", "Республика\ Татарстан",
"7347", "Республика\ Башкортостан",
"7395", "Иркутская\ обл\.",
"771133", "Бурлинский\ р\-н",
"772159", "Карагандинская\ область",
"7843", "Республика\ Татарстан",
"77212", "Караганда",
"771036", "Балхаш",
"772773", "Балхашский\ р\-н",
"7427", "Чукотский\ АО",
"772137", "Сарань",
"7384", "Кемеровская\ обл\.",
"771534", "Шал\ Акына\ р\-н",
"772148", "Осакаровский\ р\-н",
"7411", "Республика\ Саха\ \/Якутия\/",
"771832", "Иртышский\ р\-н",
"771841", "Актогайский\ р\-н",
"771839", "Лебяжинский\ р\-н",
"772344", "Тарбагатайский\ р\-н",
"77182", "Павлодар",
"7383", "Новосибирская\ обл\.",
"772833", "Алакольский\ р\-н",
"772638", "Шуский\ р\-н",
"772236", "Бескарагайский\ р\-н",
"771457", "Джангильдинский\ р\-н",
"771144", "Казталовский\ р\-н",
"772547", "Ленгер",
"771348", "Шалкарский\ р\-н",
"7423", "Приморский\ край",
"772931", "Мангистауский\ р\-н",
"771337", "Алгинский\ р\-н",
"771231", "Исатайский\ р\-н",
"772538", "имени\ Турара\ Рыскулова",
"7816", "Новгородская\ обл\.",
"7424", "Сахалинская\ обл\.",
"771034", "Улытауский\ р\-н",
"771448", "Карасуский\ р\-н",
"7848", "Самарская\ обл\.",
"7861", "Краснодарский\ край",
"7815", "Мурманская\ обл\.",
"772256", "Алгабас",
"77274", "Карасайский\ р\-н",
"771437", "Камыстинский\ р\-н",
"772542", "Асыката",
"771238", "Кзылкогинский\ р\-н",
"772531", "Аксукент",
"771636", "Щучинский\ р\-н",
"77142", "Костанай",
"7475", "Тамбовская\ обл\.",
"7390", "Республика\ Хакасия",
"771452", "Карасуский\ р\-н",
"772938", "Тупкараганский\ р\-н",
"772346", "Тарбагатайский\ р\-н",
"772353", "Бородулихинский\ р\-н",
"77149", "Костанай",
"771459", "Костанайская\ область",
"771332", "Уилский\ р\-н",
"7482", "Тверская\ обл\.",
"772433", "Аральский\ р\-н",
"771341", "Хобдинский\ р\-н",
"771145", "Каратобинский\ р\-н",
"771339", "Айтекебийский\ р\-н",
"772631", "Турара\ Рыскулова\ р\-н",
"771536", "Тайыншинский\ р\-н",
"772642", "Мойынкумский\ р\-н",
"771543", "Есильский\ р\-н",
"7343", "Свердловская\ обл",
"77132", "Актобе\/Актюбинск",
"7388", "Республика\ Алтай",
"772333", "Кокпектинский\ р\-н",
"771441", "Карабалыкский\ р\-н",
"77272983", "Каскелен",
"771439", "Джангильдинский\ р\-н",
"771035", "Улытауский\ р\-н",
"7717", "Астана",
"7847", "Республика\ Калмыкия",
"771643", "Атбасарский\ р\-н",};
$areanames{en} = {"772252", "Karaul",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"7813", "Leningrad\ region",
"77213", "Aktau\/Temirtau",
"77222", "Semey",
"772438", "Aiteke\ bi",
"740", "Kaliningrad",
"7872", "Republic\ of\ Daghestan",
"771233", "Ganyushkino",
"772154", "Botakara",
"772840", "Saryozek",
"7426", "Jewish\ Autonomous\ Region",
"771648", "Derzhavinsk",
"7492", "Vladimir",
"771537", "Timiryazevo",
"7814", "Republic\ of\ Karelia",
"77145834", "Krasnogorsk",
"772338", "Bozanbai\/Molodezhnyi",
"771637", "Korgalzhyn",
"772347", "Kalbatau",
"772239", "Makanchi",
"772533", "Turkestan",
"771436", "Taranovskoye",
"77162", "Kokshetau\/Krasni\ Yar",
"772257", "Shulbinsk",
"7346", "Surgut",
"7353", "Orenburg",
"772351", "Borodulikha",
"771343", "Irgiz",
"771030", "Atasu",
"77187", "Ekibastuz",
"77152", "Petropavlovsk",
"772431", "Zhalagash",
"7345", "Tyumen",
"7474", "Lipetsk",
"772633", "Asa",
"77106", "Satpaev",
"771532", "Smirnovo",
"771539", "Beskol",
"771541", "Mamlutka",
"771336", "Khromtau",
"77185", "Shaldai",
"7712302", "Tengizshevroil",
"771456", "Kachar",
"772237", "Ayagoz",
"771443", "Borovskoi",
"772342", "Katon\-Karagai",
"772331", "Glubokoye",
"772546", "Sholakkorgan",
"771834", "Uspenka",
"771639", "Stepnyak",
"771641", "Astrakhanka",
"7473", "Voronezh",
"771632", "Zerenda",
"771140", "Saikhin",
"771041", "Aktau\,\ Zhezkazgan",
"7845", "Saratov",
"771039", "Priozersk",
"771032", "Karazhal",
"7862", "Sochi",
"771435", "Zhitikara",
"7818", "Arkhangelsk",
"7834", "Republic\ of\ Mordovia",
"772156", "Shakhtinsk",
"7846", "Samara",
"772340", "Zaisan",
"771149", "Zelenovsky\ District",
"771335", "Shalkar",
"771131", "Darinskoye",
"7833", "Kirov",
"77272956", "Talgar",
"772838", "Balpyk\ bi",
"771142", "Taipak",
"771630", "Burabay",
"771455", "Zatobolsk",
"77102", "Zhezkazgan",
"772545", "Ikan",
"772771", "Kaskelen",
"7394", "Republic\ of\ Tuva",
"7817", "Vologda",
"771037", "Aktogai",
"771843", "Maisky\ District",
"736", "Simferopol",
"7821", "Komi\ Republic",
"771434", "Denisovka",
"7385", "Altai\ Territory",
"771454", "Karamendy",
"772778", "Chundzha",
"771147", "Akzhaiksky\ District",
"7481", "Smolensk",
"771836", "Sharbakty",
"772544", "Shaulder",
"772230", "Urdzhar",
"77135", "Aktobe\ Region",
"772842", "Kogaly",
"771138", "Zhalpaktal",
"772644", "Karatau",
"772831", "Zharkent",
"771334", "Emba",
"771038", "Shashubai",
"771444", "Uzunkol",
"7878", "Karachayevo\-Cherkessian\ Republic",
"771833", "Terenkol",
"7863", "Rostov",
"772757", "Akshi",
"77282", "Taldykorgan",
"7820", "Cherepovets",
"7421", "Khabarovsk\ Territory",
"772832", "Zhansugurov",
"772841", "Kapal",
"772725", "Otegen\ Batyra",
"772839", "Sarkand",
"772777", "Kegen",
"772634", "Zhanatas",
"772534", "Zhetysai",
"772935", "Zhetybai",
"7498", "Moscow",
"7712303", "Tengizs",
"771235", "Dossor",
"771137", "Chingirlau",
"7341", "Udmurtian\ Republic",
"77112", "Uralsk",
"7877", "Republic\ of\ Adygeya",
"771445", "Ubaganskoye",
"77272", "Almaty",
"77279", "Almaty",
"772759", "Almaty\ Region",
"771031", "Aksu\-Ayuly",
"772752", "Otegen\ Batyra",
"771042", "Zharyk",
"772535", "Shardara",
"772837", "Kabanbai",
"772779", "Narynkol",
"772772", "Kapchagai",
"772934", "Zhanaozen",
"771540", "Kishkenekol",
"771234", "Indernborski",
"772153", "Topar",
"733", "Baikonur",
"772146", "Karkaralinsk",
"771141", "Zhangala",
"771139", "Taskala",
"771345", "Karauylkeldy",
"771132", "Fyodorovka",
"771640", "Balkashino",
"772330", "Zyryanovsky\ District",
"77125", "Atyrau\ Region",
"772635", "Bauyrzhan\ Mamyshuly",
"772643", "Shu",
"7873", "Ingushi\ Republic",
"772432", "Shiyeli",
"771333", "Kandyagash",
"772439", "Aralsky\ District",
"771040", "Zhairem\ \(GOK\)",
"771446", "Uzunkolsky\ District",
"771453", "Auliekol",
"7841", "Penza",
"7494", "Kostroma",
"771651", "Kabanbai\ Batyr",
"7812", "St\ Petersburg",
"772543", "Aqsumbe",
"77232", "Ust\-Kamenogorsk",
"771631", "Shortandy",
"772536", "Kentau",
"771844", "Irtyshsky\ District",
"771649", "Zhaksynsky\ District",
"771642", "Egendykol",
"771130", "Peremetnoye",
"772332", "Shemonaikha",
"771433", "Lisakovsk",
"772341", "Ulken\ Naryn",
"772339", "Kurchum",
"771346", "Shubarkuduk",
"772770", "Uzynagash",
"771542", "Kishkenekol",
"7302", "Chita",
"771531", "Bulayevo",
"77242", "Kyzylorda",
"772636", "Kordai",
"772437", "Zhosaly",
"7381", "Omsk",
"7867", "Republic\ of\ North\ Ossetia",
"772251", "Kurchatov",
"7352", "Kurgan",
"772337", "Serebryansk",
"771538", "Beskol",
"7472", "Belgorod",
"7486", "Orel",
"771647", "Esil",
"7485", "Yaroslavl",
"771547", "Zhambylsky\ District",
"771845", "Pavlodar\ Area",
"7413", "Magadan",
"772348", "Kokpekty",
"772830", "Alakolsky\ District",
"771638", "Akkol",
"771236", "Makhambet",
"772144", "Kiyevka",
"772138", "Gabidena\ Mustafina",
"771842", "Koktobe",
"771831", "Zhelezinka",
"7487", "Tula",
"7301", "Republic\ of\ Buryatia",
"771644", "Arshaly",
"772334", "Tavricheskoye",
"772147", "Egindybulak",
"771230", "Atyrau\ Region",
"771544", "Presnovka",
"772836", "Karabulak",
"772843", "Lepsy",
"7811", "Pskov",
"7842", "Ulyanovsk",
"7865", "Stavropol\ territory",
"7866", "Kabardino\-Balkarian\ Republic",
"77245", "Kyzylorda\ Region",
"772530", "Temirlanovka",
"771136", "Chapayev",
"771545", "Zhambylsky\ District",
"771340", "Khobdinsky\ District",
"771033", "Agadyr",
"7471", "Kursk",
"771645", "Stepnogorsk",
"772776", "Shelek",
"772131", "Abai",
"772335", "Zyryanovsk",
"772149", "Osakarovka",
"771838", "Koktobe",
"7351", "Chelyabinsk",
"77224", "Barshatas",
"771440", "Amangeldy",
"7382", "Tomsk",
"7869", "Sevastopol",
"772435", "Zhanakorgan",
"771143", "Akzhaik",
"771342", "Badamsha",
"771237", "Kulsary",
"7831", "Nizhni\ Novgorod",
"771331", "Martuk",
"771349", "Shalkarsky\ District",
"771135", "Zhanibek",
"772641", "Akkol",
"772834", "Ushtobe",
"772639", "Saudakent",
"771546", "Talshik",
"772632", "Merke",
"7495", "Moscow",
"772937", "Kuryk",
"772532", "Abai",
"7496", "Moscow",
"772541", "Myrzakent",
"771646", "Makinsk",
"772539", "Kazygurt",
"772775", "Esik",
"772336", "Ridder",
"771451", "Sarykol",
"771442", "Fyodorovka",
"772343", "Terekty",
"771431", "Rudny",
"77252", "Shymkent",
"771449", "Taranovskoye",
"771633", "Ereimentau",
"771533", "Saumalkol",
"7391", "Krasnoyarsk\ Territory",
"7851", "Astrakhan",
"772436", "Terenozek",
"77262", "Taraz",
"772932", "Beineu",
"771458", "Kostanai\ Region",
"772774", "Talgar",
"772637", "Sarykemer",
"771232", "Atyrau\ Region",
"7483", "Bryansk",
"771347", "Aitekebisky\ District",
"7415", "Kamchatka\ Region",
"772548", "Shayan",
"771239", "Makat",
"7416", "Amur\ Region",
"771840", "Bayanaul",
"771134", "Zhympity",
"7499", "Moscow",
"772537", "Saryagash",
"772835", "Tekeli",
"7484", "Kaluga",
"77273", "Almaty",
"7879", "Mineranye\ Vody",
"771447", "Karabalyksky\ District",
"77292", "Aktau",
"7342", "Perm",
"771438", "Amangeldy",
"77122", "Atyrau",
"772547", "Lenger",
"771348", "Shalkarsky\ District",
"7423", "Primorie\ territory",
"772236", "Beskaragai",
"771457", "Dzhangildinsky\ District",
"772638", "Tole\ bi",
"771144", "Kaztalovka",
"771337", "Alga",
"772538", "Turara\ Ryskulova",
"771231", "Akkystau",
"772931", "Shetpe",
"771034", "Zhezdy",
"7424", "Sakhalin\ Region",
"771448", "Oktyabrskoye",
"7816", "Veliky\ Novgorod",
"772256", "Kainar",
"7815", "Murmansk",
"77274", "Karassaisky\ District",
"771437", "Kamysty",
"7848", "Tolyatti",
"7861", "Krasnodar\ Territory",
"772346", "Aksuat",
"772353", "Novaya\ Shulba",
"7475", "Tambov",
"7390", "Republic\ of\ Khakassia",
"771452", "Karasu",
"772938", "Fort\ Shevchenko",
"77149", "Kostanai",
"771459", "Kostanai\ Region",
"772542", "Asykata",
"771636", "Shuchinsk",
"77142", "Kostanai",
"772531", "Aksukent",
"771238", "Miyaly",
"771536", "Taiynsha",
"772631", "Kulan",
"772642", "Moiynkum",
"772433", "Aralsk",
"771332", "Uil",
"7482", "Tver",
"771145", "Karatobe\ District",
"771339", "Komsomolskoye",
"771341", "Khobda",
"7388", "Republic\ of\ Altai",
"771543", "Yavlenka",
"77132", "Aktobe\/Kargalinskoye",
"7343", "Ekaterinburg",
"7847", "Republic\ of\ Kalmykia",
"771643", "Atbasar",
"7717", "Astana",
"771035", "Ulytau",
"772333", "Samarskoye",
"77272983", "Kaskelen",
"771439", "Torgai",
"771441", "Karabalyk",
"772345", "Shar",
"772132", "Nurinsky\ District",
"772640", "Moiynkumsky\ District",
"771330", "Khromtau\ District",
"771635", "Zhaksy",
"771043", "Zhairem",
"7836", "Republic\ of\ Marij\ El",
"771535", "Novoishimski",
"771837", "Aksu",
"7835", "Chuvashi\ Republic",
"7844", "Volgograd",
"7491", "Ryazan",
"772540", "Arys",
"771146", "Akzhaiksky\ District",
"7347", "Republic\ of\ Bashkortostan",
"7855", "Naberezhnye\ Chelny",
"7395", "Irkutsk",
"771133", "Aksai",
"7871", "Chechen\ Republic",
"771430", "Arkalyk",
"77212", "Karaganda",
"772773", "Bakanas",
"771036", "Balkhash",
"772159", "Karaganda\ Region",
"7843", "Republic\ of\ Tatarstan",
"771534", "Sergeyevka",
"7384", "Kemerovo",
"7427", "Chukotka\ Autonomous\ District",
"772137", "Saran",
"772344", "Akzhar",
"772148", "Molodezhnoye",
"771832", "Irtyshsk",
"7411", "Republic\ of\ Sakha",
"771839", "Akku",
"771841", "Aktogai",
"7383", "Novosibirsk",
"77182", "Pavlodar",
"772833", "Usharal",};
my $timezones = {
               '' => [
                       'Asia/Almaty',
                       'Asia/Anadyr',
                       'Asia/Aqtobe',
                       'Asia/Irkutsk',
                       'Asia/Kamchatka',
                       'Asia/Krasnoyarsk',
                       'Asia/Magadan',
                       'Asia/Novosibirsk',
                       'Asia/Omsk',
                       'Asia/Sakhalin',
                       'Asia/Vladivostok',
                       'Asia/Yakutsk',
                       'Asia/Yekaterinburg',
                       'Europe/Bucharest',
                       'Europe/Moscow',
                       'Europe/Samara'
                     ],
               '301' => [
                          'Asia/Irkutsk'
                        ],
               '302' => [
                          'Asia/Yakutsk'
                        ],
               '33' => [
                         'Asia/Almaty'
                       ],
               '34' => [
                         'Asia/Yekaterinburg'
                       ],
               '341' => [
                          'Europe/Samara'
                        ],
               '35' => [
                         'Asia/Yekaterinburg'
                       ],
               '36' => [
                         'Europe/Moscow'
                       ],
               '381' => [
                          'Asia/Omsk'
                        ],
               '382' => [
                          'Asia/Novosibirsk'
                        ],
               '383' => [
                          'Asia/Novosibirsk'
                        ],
               '384' => [
                          'Asia/Krasnoyarsk'
                        ],
               '385' => [
                          'Asia/Krasnoyarsk'
                        ],
               '388' => [
                          'Asia/Krasnoyarsk'
                        ],
               '390' => [
                          'Asia/Krasnoyarsk'
                        ],
               '391' => [
                          'Asia/Krasnoyarsk'
                        ],
               '394' => [
                          'Asia/Krasnoyarsk'
                        ],
               '395' => [
                          'Asia/Irkutsk'
                        ],
               '40' => [
                         'Europe/Bucharest'
                       ],
               '411' => [
                          'Asia/Yakutsk'
                        ],
               '413' => [
                          'Asia/Magadan'
                        ],
               '415' => [
                          'Asia/Kamchatka'
                        ],
               '416' => [
                          'Asia/Yakutsk'
                        ],
               '421' => [
                          'Asia/Vladivostok'
                        ],
               '423' => [
                          'Asia/Vladivostok'
                        ],
               '424' => [
                          'Asia/Sakhalin'
                        ],
               '426' => [
                          'Asia/Vladivostok'
                        ],
               '427' => [
                          'Asia/Anadyr'
                        ],
               '47' => [
                         'Europe/Moscow'
                       ],
               '48' => [
                         'Europe/Moscow'
                       ],
               '49' => [
                         'Europe/Moscow'
                       ],
               '7' => [
                        'Asia/Almaty',
                        'Asia/Aqtobe'
                      ],
               '71' => [
                         'Asia/Almaty'
                       ],
               '711' => [
                          'Asia/Aqtobe'
                        ],
               '712' => [
                          'Asia/Aqtobe'
                        ],
               '713' => [
                          'Asia/Aqtobe'
                        ],
               '72' => [
                         'Asia/Almaty'
                       ],
               '729' => [
                          'Asia/Aqtobe'
                        ],
               '79' => [
                         'Asia/Almaty'
                       ],
               '800' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '803' => [
                          'Europe/Moscow'
                        ],
               '804' => [
                          'Europe/Moscow'
                        ],
               '808' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '809' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '81' => [
                         'Europe/Moscow'
                       ],
               '810' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '82' => [
                         'Europe/Moscow'
                       ],
               '83' => [
                         'Europe/Moscow'
                       ],
               '840' => [
                          'Europe/Bucharest',
                          'Europe/Moscow'
                        ],
               '841' => [
                          'Europe/Moscow'
                        ],
               '842' => [
                          'Europe/Samara'
                        ],
               '843' => [
                          'Europe/Moscow'
                        ],
               '844' => [
                          'Europe/Moscow'
                        ],
               '845' => [
                          'Europe/Moscow'
                        ],
               '846' => [
                          'Europe/Samara'
                        ],
               '847' => [
                          'Europe/Moscow'
                        ],
               '848' => [
                          'Europe/Samara'
                        ],
               '851' => [
                          'Europe/Samara'
                        ],
               '855' => [
                          'Europe/Moscow'
                        ],
               '86' => [
                         'Europe/Moscow'
                       ],
               '87' => [
                         'Europe/Moscow'
                       ],
               '9' => [
                        'Europe/Moscow'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;