/* ----- core/invsntrup1277, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_invsntrup1277_checksums[] = {
  "a76fff56bde559a7eae01add3f5446ce57238eb5d56a1ce04aba66fe8ddac009",
  "323564aa131a8f844bc99ffe99f5f151839729573c215eac12ddec35c3d4a721",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_invsntrup1277_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_invsntrup1277_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_invsntrup1277_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_invsntrup1277_CONSTBYTES

static void *storage_core_invsntrup1277_h;
static unsigned char *test_core_invsntrup1277_h;
static void *storage_core_invsntrup1277_n;
static unsigned char *test_core_invsntrup1277_n;
static void *storage_core_invsntrup1277_k;
static unsigned char *test_core_invsntrup1277_k;
static void *storage_core_invsntrup1277_c;
static unsigned char *test_core_invsntrup1277_c;
static void *storage_core_invsntrup1277_h2;
static unsigned char *test_core_invsntrup1277_h2;
static void *storage_core_invsntrup1277_n2;
static unsigned char *test_core_invsntrup1277_n2;
static void *storage_core_invsntrup1277_k2;
static unsigned char *test_core_invsntrup1277_k2;
static void *storage_core_invsntrup1277_c2;
static unsigned char *test_core_invsntrup1277_c2;

#define precomputed_core_invsntrup1277_NUM 4

static const unsigned char precomputed_core_invsntrup1277_h[precomputed_core_invsntrup1277_NUM][crypto_core_OUTPUTBYTES] = {
  {35,244,137,1,79,2,221,242,2,249,116,249,226,253,87,250,171,253,232,10,56,1,193,2,194,243,8,3,91,250,255,4,47,2,193,4,240,9,251,249,241,0,229,1,162,243,34,248,214,242,7,11,25,8,53,248,183,8,218,4,222,5,192,244,81,12,135,248,66,0,104,7,51,252,220,1,164,243,1,11,194,247,60,253,165,3,79,15,148,248,197,11,141,249,24,245,150,14,84,9,219,251,255,247,223,6,197,2,11,3,177,2,133,6,209,7,45,250,214,254,44,12,190,245,133,0,55,5,90,250,156,5,15,253,206,255,220,9,175,242,59,254,58,14,137,252,133,241,70,9,235,240,158,3,144,254,214,243,202,6,102,242,66,12,87,245,149,251,75,248,71,247,244,8,200,13,171,252,21,250,36,241,179,9,219,0,127,255,165,10,20,251,215,2,161,10,244,6,9,255,25,245,19,9,111,8,219,241,224,1,27,11,198,12,22,13,45,2,184,248,81,3,168,5,190,245,224,254,164,240,206,246,115,7,249,247,25,248,120,245,209,250,254,251,128,243,60,246,101,3,205,244,133,7,199,14,32,249,218,12,222,255,146,4,8,243,128,14,182,247,110,11,98,3,76,7,131,252,150,242,59,255,29,246,62,14,86,10,107,241,165,244,56,252,103,241,51,1,180,251,127,4,238,245,109,14,212,12,119,248,9,13,115,255,73,0,53,254,23,10,173,249,217,251,7,14,215,246,203,12,32,248,103,248,32,4,155,2,14,242,11,245,78,246,141,249,112,250,245,249,178,251,231,242,30,252,131,14,30,249,14,247,220,252,78,253,241,8,59,250,107,12,163,1,35,250,166,253,43,4,162,1,193,5,73,248,155,12,138,3,213,11,131,248,207,8,205,249,165,241,150,4,247,247,33,6,251,6,126,0,126,1,90,4,47,2,130,2,125,13,182,243,17,3,151,1,234,252,81,242,184,1,152,6,35,243,242,247,251,243,5,15,180,248,50,6,174,241,85,247,163,11,105,9,2,253,56,6,47,11,169,248,17,5,254,240,128,3,102,2,131,14,23,241,19,6,234,0,151,6,46,254,247,2,82,0,207,253,153,1,12,245,214,252,165,3,171,12,202,248,204,248,250,253,142,244,147,8,53,9,105,246,127,3,128,241,87,241,47,15,210,245,160,7,18,7,109,241,160,247,164,244,235,255,157,255,252,4,103,243,18,254,152,244,0,9,153,9,83,255,170,2,190,240,211,9,23,1,21,3,143,14,34,241,159,5,7,14,134,8,30,245,247,14,80,5,39,254,250,254,173,247,83,242,230,7,6,9,89,2,176,245,56,10,1,4,135,245,190,9,149,8,118,14,74,7,10,10,74,244,152,9,94,249,95,8,60,250,33,243,3,251,22,253,57,11,197,248,34,241,165,9,87,252,239,6,213,240,112,6,8,251,248,13,134,0,219,249,236,6,8,13,245,240,34,14,125,4,220,249,74,10,230,5,196,1,114,254,246,243,249,8,231,250,42,249,235,243,131,11,83,10,10,13,253,244,252,255,156,245,154,1,100,2,203,240,215,10,234,243,53,7,124,1,208,3,76,247,150,14,87,5,169,4,105,251,104,8,180,10,184,250,169,253,185,254,198,4,149,11,53,245,98,254,95,252,217,250,213,240,142,4,34,15,217,5,255,0,98,7,235,249,247,240,128,244,68,247,89,248,83,247,91,11,221,13,145,4,145,246,156,12,13,8,136,10,242,14,69,247,248,11,217,243,95,247,255,13,91,3,224,253,69,248,32,2,168,255,145,14,188,14,202,14,255,9,247,5,168,0,250,13,128,251,225,7,134,250,106,246,231,8,224,1,203,245,224,250,157,242,86,14,61,7,30,248,207,248,112,253,205,13,198,242,103,245,15,247,213,246,115,14,152,11,66,246,185,250,15,10,118,14,139,7,54,253,250,252,137,248,144,255,168,246,146,3,248,251,164,245,242,240,165,253,249,240,196,250,93,241,95,250,53,245,183,12,42,4,241,249,225,255,216,14,41,7,70,14,94,9,121,12,22,9,103,248,25,8,119,5,224,242,255,248,54,3,89,10,42,15,208,7,119,250,223,7,244,10,227,2,86,250,175,247,118,243,22,14,162,241,238,243,51,5,17,250,189,241,149,4,13,11,11,12,123,2,159,1,119,242,108,10,61,13,26,252,221,9,126,249,241,251,232,252,109,246,150,252,118,241,142,247,90,8,58,244,212,12,124,13,253,247,220,10,172,0,170,255,214,11,18,10,193,240,225,240,8,252,252,7,70,8,12,247,189,2,186,241,159,253,253,250,91,4,187,4,150,3,216,10,14,254,155,14,143,1,218,252,129,11,80,10,52,250,15,13,77,247,175,247,253,247,159,253,97,242,165,244,193,248,96,246,84,10,55,2,155,243,199,248,221,251,126,255,139,1,68,255,252,6,68,244,123,242,52,13,135,251,2,10,217,252,155,251,223,249,237,11,189,246,186,7,212,12,172,10,193,246,119,12,41,243,103,251,242,254,2,7,99,4,116,12,99,8,248,0,123,5,239,5,59,243,83,248,208,245,233,12,37,252,77,7,38,13,23,10,56,251,241,8,173,242,3,3,84,6,113,3,242,251,113,9,210,244,146,242,219,2,21,3,132,252,97,255,85,254,229,251,55,3,203,9,217,6,216,9,130,253,56,3,42,4,165,10,47,250,157,245,199,13,228,254,78,241,225,6,107,247,99,249,177,13,42,4,175,5,105,2,227,1,143,246,32,252,235,255,45,242,64,252,155,254,192,7,187,246,78,10,179,9,105,251,183,1,78,251,67,253,235,243,221,1,198,249,162,14,204,0,211,4,124,250,166,251,14,246,29,2,34,251,171,13,10,1,156,9,189,247,240,248,88,248,221,10,196,249,222,254,221,9,216,1,164,253,199,244,6,8,110,249,239,1,41,6,174,8,73,249,61,251,228,12,13,245,108,250,45,243,76,247,153,252,193,253,214,241,219,243,4,8,100,246,31,244,0,13,8,7,101,13,105,252,165,1,21,250,135,251,49,6,156,244,66,246,88,2,192,10,234,243,0,10,8,255,168,245,26,7,17,1,133,241,114,248,68,249,140,11,97,4,9,254,3,245,24,14,147,3,17,15,127,254,185,252,216,253,172,243,152,252,65,4,219,4,176,249,133,11,239,12,29,255,15,243,144,11,72,5,155,254,137,10,2,248,102,4,84,249,179,3,81,11,3,247,45,249,27,7,121,10,181,253,88,5,15,241,164,1,86,14,84,14,223,242,154,254,17,251,173,247,151,0,204,251,130,9,123,14,106,7,214,251,98,11,56,254,69,245,215,14,33,14,208,4,46,5,156,249,17,253,157,252,8,242,30,252,9,246,222,12,38,245,254,6,8,8,51,248,58,241,120,2,54,250,191,241,118,9,217,9,190,251,136,254,70,251,71,5,48,0,82,255,108,12,93,246,2,10,121,12,208,254,30,13,68,245,118,243,238,8,198,1,147,246,180,246,11,12,162,3,250,240,79,242,87,0,104,243,61,246,28,13,144,245,41,6,158,246,48,244,238,251,103,244,112,245,123,253,100,251,31,252,92,10,97,5,183,250,247,6,154,10,64,5,64,9,150,245,8,250,125,249,34,9,139,8,115,6,182,241,223,252,60,4,24,241,36,0,24,5,194,242,9,5,55,6,9,11,217,1,180,246,206,250,143,248,5,254,102,248,248,0,22,247,95,15,130,0,215,245,43,252,28,246,93,248,188,250,118,7,60,248,168,241,20,15,155,245,92,14,94,241,52,11,213,0,229,251,238,3,128,245,224,245,15,244,3,250,216,250,100,8,77,9,220,4,211,9,142,247,208,6,39,11,210,12,181,250,192,246,19,255,122,242,57,245,198,254,234,13,46,14,156,253,59,252,7,244,61,244,96,2,182,255,217,8,76,253,145,8,85,250,73,1,73,249,211,13,93,6,2,249,15,3,252,252,132,9,192,2,66,11,121,6,140,249,73,248,24,11,29,11,142,11,249,9,168,0,86,9,179,10,72,247,88,250,213,244,41,241,16,2,99,249,192,254,190,242,252,247,99,4,127,5,173,242,199,247,199,255,56,8,144,14,46,249,43,248,206,245,128,247,117,12,224,248,251,250,177,0,65,248,113,242,2,252,139,2,113,243,172,11,84,255,95,249,78,241,250,244,238,13,78,246,209,240,255,246,225,6,186,8,132,14,78,11,160,10,86,248,50,251,16,0,251,7,166,6,226,244,70,241,121,8,127,5,248,4,131,247,174,241,169,248,199,2,254,247,68,245,45,4,200,11,33,254,238,7,124,244,72,15,108,243,2,12,170,3,111,0,94,14,13,246,193,1,182,5,49,254,113,249,237,10,186,13,149,9,43,245,224,7,159,255,192,13,54,2,158,253,25,251,69,11,84,0,27,255,244,8,35,4,10,0,152,12,6,254,52,13,36,4,244,4,167,250,42,244,242,9,127,250,50,252,146,3,66,2,24,241,47,253,52,255,17,243,117,9,150,244,111,4,133,11,127,6,31,15,182,248,209,251,178,8,102,253,143,2,199,243,137,241,95,9,248,244,142,4,227,255,46,249,226,241,66,248,254,5,217,8,21,243,43,6,68,11,160,254,7,255,231,247,40,248,248,5,47,3,212,252,46,12,193,7,162,11,206,13,85,4,250,251,179,247,251,247,196,241,193,249,144,4,38,249,174,0,253,255,183,2,72,13,22,13,50,251,0,246,92,252,188,253,144,244,195,240,144,241,229,240,43,249,252,241,42,241,146,7,80,11,162,2,34,4,38,242,174,242,239,12,179,247,234,254,246,254,111,252,173,254,176,3,42,242,104,6,140,6,126,0,86,10,53,252,209,14,42,11,242,13,93,248,212,253,181,241,7,254,231,2,240,9,38,1,34,255,232,7,168,13,4,1,243,3,78,13,224,254,84,11,216,0,78,251,169,241,236,250,11,254,42,254,208,6,89,6,95,11,28,243,128,242,184,11,136,245,29,7,40,243,199,251,25,246,44,12,74,11,39,2,252,248,22,6,168,255,209,244,169,250,103,248,207,252,126,2,31,8,53,255,203,8,175,6,28,241,226,247,64,14,8,250,56,2,106,4,201,241,152,4,163,247,240,253,252,0,216,240,125,243,152,247,87,245,155,253,75,15,80,254,138,253,33,248,33,248,122,242,51,245,153,243,251,5,134,249,156,255,60,249,168,4,171,13,203,255,152,252,112,13,197,12,113,8,210,2,39,12,186,242,114,246,72,7,184,241,12,15,126,9,133,1,91,1,139,247,165,6,31,250,160,8,139,4,167,7,247,252,153,8,48,14,36,12,137,1,115,1,245,246,166,3,68,0,158,2,17,251,216,3,12,4,59,241,196,11,184,9,199,247,230,7,120,246,79,3,96,243,225,7,178,248,167,249,173,11,42,244,50,2,88,9,104,250,110,7,173,247,106,254,1,9,48,6,30,248,6,8,36,249,104,244,83,12,118,255,76,250,145,246,182,1,112,245,89,13,229,6,3,242,197,8,6,2,108,249,159,3,126,9,2,243,66,244,192,254,83,0,237,253,172,10,80,0,40,12,11,254,206,254,231,2,10,252,35,253,191,10,134,3,233,246,11,9,173,242,167,249,230,12,128,247,186,242,143,242,201,3,90,246,208,241,217,11,2,242,187,13,83,14,11,3,179,246,105,243,74,243,187,13,164,1,185,8,0},
  {100,252,164,4,182,241,159,240,57,14,251,3,5,10,235,13,37,0,52,254,188,2,126,254,15,11,124,5,5,1,65,4,9,249,126,10,82,250,14,11,158,12,211,2,151,252,237,241,21,241,249,251,101,3,83,10,167,0,218,9,62,14,168,250,42,2,185,255,70,8,199,251,135,250,7,5,17,252,90,12,205,247,224,254,1,14,66,245,91,10,255,243,30,249,119,5,17,11,31,9,33,247,193,247,208,8,135,10,97,1,109,243,109,251,73,245,88,3,235,244,33,1,199,253,8,4,173,14,163,11,87,5,161,242,77,255,4,13,29,4,14,12,234,5,32,253,141,254,243,3,87,245,130,250,239,7,253,248,175,250,113,10,209,251,101,10,177,8,220,14,75,245,191,250,37,3,12,251,170,13,25,241,99,10,250,244,41,252,124,10,24,245,179,2,12,7,226,11,148,12,84,249,148,9,12,250,106,11,68,12,249,250,252,254,85,249,54,250,170,5,97,5,228,243,202,241,109,251,70,252,151,248,206,248,210,242,180,240,61,0,55,12,122,246,15,9,187,252,86,10,215,9,77,253,233,5,103,4,182,252,236,250,90,245,165,250,172,14,207,8,102,255,250,240,7,12,213,13,210,0,59,10,4,249,152,243,232,5,127,14,155,4,107,242,45,248,104,248,6,252,148,2,138,243,10,12,206,253,101,11,238,8,146,10,166,2,235,9,245,243,36,12,116,251,49,15,191,13,40,255,57,245,17,15,89,6,155,253,53,11,249,245,176,245,235,6,60,4,186,3,143,8,220,255,166,14,68,243,6,251,16,3,50,0,233,245,138,242,105,247,172,240,64,253,112,0,170,240,216,6,245,10,34,252,135,7,227,248,56,9,12,243,212,240,213,251,92,13,236,241,239,11,59,253,163,4,206,245,223,12,15,242,174,251,181,248,211,14,52,1,89,253,30,254,127,12,24,242,35,7,221,253,137,12,67,251,41,15,112,8,213,14,96,6,83,249,123,255,74,1,43,5,170,11,57,7,144,4,238,249,66,9,34,14,102,5,209,246,156,3,3,254,181,251,109,9,57,246,175,12,148,241,226,9,146,245,185,11,75,254,239,240,153,12,188,2,152,2,53,246,192,250,46,251,152,246,120,247,70,241,13,245,226,251,129,3,50,6,38,11,110,10,19,242,77,255,245,1,209,0,57,255,170,254,149,7,127,5,13,12,194,13,130,254,137,7,193,243,156,9,186,7,38,245,27,6,107,8,129,248,137,241,3,6,85,13,111,244,106,4,69,1,47,245,105,12,17,9,139,250,178,247,246,8,234,245,130,13,248,13,227,1,43,0,154,5,33,14,218,9,153,6,234,9,192,0,35,2,44,5,47,15,29,5,127,246,63,2,76,5,55,4,97,6,187,12,63,8,73,8,171,249,55,15,218,9,23,0,242,0,119,3,62,255,120,3,241,8,57,12,156,7,160,251,210,2,145,8,36,247,51,253,85,13,126,2,107,3,255,4,106,0,133,0,66,247,51,244,82,4,34,0,83,255,189,249,27,243,255,247,81,11,219,249,208,247,223,14,74,8,212,10,110,243,35,3,114,250,129,14,153,254,145,14,168,247,54,15,245,2,0,253,246,248,93,11,188,1,167,249,138,255,229,13,42,3,253,1,246,4,55,248,150,9,90,248,46,247,121,254,97,247,45,253,22,15,141,242,170,254,32,247,82,13,26,15,111,12,254,9,21,242,106,242,63,12,153,0,128,5,180,247,228,7,130,244,106,255,199,248,133,7,88,9,130,7,132,254,34,13,219,242,106,251,98,251,67,242,151,6,149,11,99,10,92,9,87,11,134,11,73,245,71,241,77,3,68,251,221,12,118,11,162,7,72,252,198,241,18,253,167,10,28,9,60,5,196,243,136,8,234,9,73,255,182,7,70,9,51,2,138,5,251,8,105,243,18,242,86,6,178,11,198,244,181,11,22,4,212,251,167,6,180,9,109,252,70,247,18,3,73,255,62,251,59,249,85,246,174,255,242,10,0,10,98,1,211,243,178,242,218,255,242,255,70,7,57,250,27,0,86,3,192,240,33,249,50,242,65,255,83,9,21,244,121,242,108,247,189,14,95,251,118,243,208,4,174,244,182,10,119,241,198,249,63,242,3,255,41,250,211,245,92,1,212,251,201,246,28,14,76,248,2,14,187,14,78,241,239,9,62,4,7,243,226,2,86,14,110,241,13,0,146,245,77,10,177,5,166,251,9,1,225,12,88,245,36,248,93,14,127,10,53,247,23,252,179,8,39,5,232,10,211,250,255,241,100,246,12,246,115,254,41,12,46,15,108,252,87,253,148,243,219,250,197,8,149,249,138,5,157,0,96,246,224,6,213,246,67,253,9,2,242,254,52,11,21,241,179,8,153,248,180,11,64,9,168,0,251,3,58,248,80,3,36,3,83,244,152,11,38,252,5,7,196,250,228,245,100,246,222,244,19,2,34,245,213,12,235,13,65,246,31,251,197,4,223,243,88,251,95,250,169,243,12,12,170,248,43,243,197,241,193,1,158,3,189,253,96,2,82,9,242,10,93,251,33,11,125,13,67,248,220,8,35,241,29,2,56,0,84,255,143,6,0,247,33,253,26,251,55,13,140,245,90,251,117,243,68,248,191,240,97,0,193,248,14,8,53,11,244,255,201,0,65,248,148,246,192,243,87,253,71,243,237,7,114,9,121,8,69,242,119,243,190,250,168,8,159,247,206,1,224,6,115,251,81,246,204,2,5,245,181,249,114,243,188,7,75,13,197,0,66,252,250,6,74,0,28,245,202,246,118,255,29,246,19,10,181,13,20,255,221,248,87,243,218,0,85,254,85,11,233,242,8,242,117,3,249,6,251,243,247,3,196,11,203,1,240,8,80,250,32,14,195,13,226,241,229,255,70,251,176,249,122,6,179,249,95,13,47,0,80,249,246,252,190,11,114,249,245,13,190,255,175,249,159,8,169,2,242,2,253,253,79,241,31,5,129,247,193,248,249,245,182,246,112,245,103,244,183,252,120,2,107,247,181,241,246,0,20,3,30,254,144,7,124,241,57,246,242,255,171,250,189,12,120,13,164,252,29,246,28,255,56,12,159,14,126,4,193,11,81,250,32,253,102,9,164,8,111,12,178,240,74,2,220,5,65,13,224,7,7,7,54,6,58,252,98,245,69,243,179,12,141,12,55,248,64,250,117,12,202,249,203,11,0,249,9,246,198,248,16,14,161,9,161,251,66,0,15,243,152,250,184,243,198,245,204,243,240,3,2,12,84,9,217,243,90,0,122,14,148,1,191,12,91,249,188,253,136,12,249,242,17,8,31,1,56,242,136,4,204,246,254,243,201,250,209,9,106,1,220,4,141,10,102,14,113,12,175,244,145,0,207,12,56,15,189,6,26,243,119,246,198,240,65,14,6,4,91,0,202,248,238,2,24,253,24,10,66,246,15,9,55,252,238,242,45,242,176,251,127,12,80,254,28,1,88,242,163,1,219,255,71,1,84,10,122,10,192,11,5,14,223,240,246,8,86,1,146,7,177,11,166,240,255,10,196,7,64,8,84,12,142,14,43,12,175,240,205,9,239,252,146,253,95,255,188,247,223,246,199,8,5,254,209,253,209,11,219,3,44,1,35,5,125,9,48,244,218,247,38,1,224,11,111,1,157,14,245,10,238,254,147,252,198,8,156,246,201,243,96,245,51,14,161,6,167,255,179,254,175,0,91,246,184,8,203,246,5,4,6,245,194,255,237,12,60,252,239,0,61,243,20,253,248,13,154,0,111,5,237,243,47,7,229,1,41,241,158,0,35,13,102,242,234,0,177,11,109,0,72,4,30,12,164,245,248,240,223,7,64,1,248,247,76,15,190,250,103,243,176,9,171,253,156,255,103,12,102,254,28,242,216,250,167,247,240,252,35,248,166,253,36,243,71,245,33,243,68,7,254,245,157,246,235,249,44,244,102,4,210,9,42,5,235,14,247,8,170,8,131,243,120,250,69,253,166,4,103,5,178,6,81,0,43,6,214,0,35,243,61,242,226,14,65,251,67,241,154,6,224,5,70,241,8,6,4,14,5,1,114,252,189,4,3,246,184,1,14,10,125,246,50,250,23,253,186,5,9,253,7,248,102,7,222,12,97,241,241,247,58,2,179,4,50,1,104,250,19,244,253,10,203,1,4,246,9,10,168,5,238,254,42,13,65,245,116,252,228,6,139,14,253,246,205,8,31,9,4,4,186,243,156,8,87,245,236,246,178,247,229,240,182,4,90,3,147,12,183,10,33,249,195,242,139,241,252,5,196,0,185,255,42,0,235,255,129,247,78,254,18,6,174,9,204,242,109,1,198,8,56,5,173,250,246,243,25,247,61,9,94,251,248,241,139,247,116,244,212,13,154,3,248,255,67,11,118,251,62,10,14,250,118,12,113,8,178,246,140,6,42,250,89,10,114,252,5,254,152,243,61,14,155,7,198,1,164,249,167,243,183,249,89,15,227,4,204,0,106,12,3,255,108,254,65,5,146,253,131,9,162,250,229,247,17,250,21,0,96,12,152,248,198,11,52,7,161,7,209,11,78,244,134,10,217,2,187,1,117,245,32,243,191,2,63,246,132,248,25,253,11,243,216,252,229,241,213,241,50,0,19,10,99,15,231,244,171,253,7,2,241,14,48,12,112,8,152,4,242,250,245,241,85,241,94,244,195,250,42,248,172,6,101,12,171,13,99,244,253,11,188,249,59,6,3,2,115,12,169,251,57,5,90,1,97,2,6,11,18,14,126,242,130,251,236,243,206,254,39,244,73,253,240,2,64,4,110,12,100,244,214,3,30,7,83,3,161,248,147,13,38,8,241,11,232,250,76,251,11,11,135,254,172,7,195,14,178,6,152,7,229,241,42,10,200,255,166,247,229,0,151,245,235,249,44,249,33,4,212,249,250,244,220,14,155,242,243,0,91,249,3,241,23,6,44,244,214,245,91,254,149,242,184,248,204,1,181,9,204,247,139,14,195,244,135,8,152,14,163,246,130,243,136,246,221,251,195,242,80,254,234,10,241,14,43,13,178,4,229,7,62,14,87,252,67,0,186,3,154,251,210,4,237,243,180,240,103,241,45,7,234,253,135,241,209,14,113,4,246,250,182,10,158,14,68,242,227,242,18,253,120,250,1,245,101,7,86,8,86,245,70,11,245,6,203,251,232,14,243,9,153,14,227,7,238,7,0,246,18,2,34,246,17,251,211,255,159,244,227,1,167,240,151,250,192,241,184,14,209,245,73,11,200,254,37,254,112,241,79,15,137,254,63,0,192,255,178,4,211,12,48,14,151,11,86,248,40,0,90,254,201,9,135,12,216,10,232,254,94,2,231,1,53,2,59,253,177,13,98,12,178,244,40,246,46,3,211,252,157,2,4,254,80,7,14,248,20,8,168,244,228,249,52,254,168,249,63,1,230,6,163,0,219,9,141,249,12,247,51,11,201,3,92,248,234,244,167,250,2,243,179,243,248,11,203,5,69,2,69,255,190,252,140,250,35,8,216,240,73,4,236,3,173,255,116,246,115,10,183,9,9,13,193,3,209,250,140,241,114,246,106,251,185,12,149,250,58,15,139,250,179,251,243,10,39,15,134,13,80,245,157,255,64,246,30,254,135,253,228,241,6,4,16,3,215,12,83,250,89,254,115,243,157,241,170,255,207,244,172,255,101,246,175,246,66,253,44,9,43,5,47,253,0},
  {146,4,182,8,46,8,168,14,46,14,213,255,63,4,195,251,21,246,107,10,30,248,252,0,80,2,48,243,9,254,119,12,82,245,119,245,24,250,231,5,133,13,252,248,200,3,124,9,122,11,20,252,41,249,145,251,70,14,192,250,24,2,147,6,214,250,117,252,255,253,58,13,117,250,2,4,102,3,57,245,125,8,206,246,147,5,165,255,14,9,10,241,217,253,4,254,18,255,129,246,118,247,108,248,76,1,52,10,119,0,152,245,40,250,121,5,56,8,74,7,78,4,113,5,33,241,181,243,199,240,140,8,25,8,46,243,118,11,91,243,116,1,248,0,46,9,24,244,17,242,123,4,191,8,47,13,20,246,25,10,245,249,55,246,10,11,235,4,250,244,144,14,227,4,181,5,227,6,6,244,231,10,227,11,163,248,179,5,87,1,31,252,162,13,135,244,215,247,40,12,43,252,231,12,64,6,207,7,224,251,21,242,56,7,38,1,106,11,247,12,209,0,23,5,217,246,83,247,171,2,127,14,215,240,49,242,240,9,187,251,247,245,12,241,122,1,15,243,237,245,158,11,155,247,69,1,112,243,219,250,6,254,99,246,67,1,197,0,120,11,70,14,89,6,149,6,14,13,121,6,60,252,24,15,22,249,20,251,109,0,92,11,235,242,183,244,123,11,230,254,154,9,173,11,196,7,21,250,75,248,196,251,160,247,50,12,39,7,215,245,10,9,177,252,101,10,132,250,148,248,196,254,32,5,21,9,79,254,54,2,197,243,173,7,176,253,97,251,38,247,224,251,51,248,69,14,89,8,77,15,141,8,239,8,110,254,22,6,185,247,229,248,232,251,188,242,205,13,51,0,215,247,113,11,143,6,252,12,180,5,125,1,232,7,118,4,108,9,235,244,105,243,205,249,129,250,237,243,50,9,62,15,36,7,168,254,164,7,64,5,105,251,161,11,82,4,195,251,147,10,14,246,20,255,52,241,161,11,79,8,69,3,38,244,1,8,12,3,52,7,191,243,132,12,24,242,222,5,48,4,200,6,98,4,91,251,122,4,55,247,160,9,141,12,2,1,78,254,127,3,189,243,201,6,229,3,61,255,169,6,226,14,211,248,118,10,142,8,7,254,166,11,5,254,104,1,109,10,239,4,13,249,163,243,122,254,246,255,165,0,84,242,189,6,21,3,178,0,35,14,117,242,223,2,180,10,67,6,162,10,168,9,244,240,246,8,213,242,228,11,171,252,65,2,196,246,146,244,164,253,131,3,170,250,227,240,156,10,128,249,73,15,134,243,10,11,188,243,209,249,15,2,193,6,147,251,181,255,137,5,154,243,188,4,182,5,215,242,41,252,59,12,171,240,116,243,205,0,18,242,69,1,245,8,169,249,250,247,99,3,178,14,155,242,1,1,9,245,26,245,24,255,158,245,87,244,59,253,72,249,253,245,87,254,204,10,90,246,209,252,55,241,63,11,55,6,130,248,52,5,228,244,148,9,132,12,246,9,95,7,135,251,35,14,114,252,11,13,247,251,109,248,150,3,32,2,135,3,51,6,28,253,188,4,250,0,52,247,104,246,52,245,188,245,107,255,199,251,158,254,148,253,154,252,167,14,25,13,75,15,108,245,61,245,100,8,167,2,191,10,117,14,47,5,188,10,193,244,39,15,155,251,125,251,121,12,150,242,173,6,145,11,177,242,228,244,12,247,49,248,52,4,192,255,6,246,234,13,219,250,165,4,138,11,177,4,203,245,251,12,81,6,204,253,242,255,79,10,246,253,112,254,41,245,70,251,207,7,172,0,199,8,112,4,197,13,90,11,91,247,244,0,248,11,252,253,61,4,114,11,160,255,207,5,213,2,194,251,172,252,174,14,98,6,38,250,11,6,163,252,126,2,167,1,143,246,184,10,211,252,50,13,129,251,76,15,215,10,195,4,91,14,223,4,206,254,177,246,52,1,51,5,96,254,213,14,230,248,14,7,112,3,140,248,205,255,252,0,121,255,17,3,138,10,21,241,29,4,33,6,57,253,205,249,206,4,217,6,44,255,76,5,255,251,116,251,53,249,198,2,173,255,43,249,122,4,39,14,100,1,150,3,180,254,183,11,126,2,233,3,57,0,14,11,97,4,5,244,143,249,75,14,107,250,173,241,188,5,207,249,167,254,54,13,6,243,120,6,222,1,95,253,122,14,14,6,69,242,195,245,25,0,172,240,225,14,98,253,180,1,221,245,135,1,66,248,119,8,81,254,161,9,145,244,222,251,198,244,165,246,160,3,37,255,205,243,214,246,195,246,242,2,146,251,87,254,61,15,238,249,161,5,198,240,231,10,231,254,147,4,45,250,64,0,44,7,129,243,232,13,85,6,195,240,107,5,71,15,10,1,184,3,202,246,167,1,140,249,39,0,123,2,22,254,125,255,175,245,73,15,196,255,130,243,202,12,130,248,208,6,101,4,82,7,77,14,50,3,200,0,155,246,18,253,116,254,98,0,42,6,187,250,60,247,167,246,2,255,98,242,8,242,118,1,68,247,195,13,179,9,168,3,152,5,0,255,215,1,30,243,131,250,219,254,187,247,250,249,121,14,127,3,101,243,226,7,103,10,161,1,211,249,181,10,122,244,30,254,207,9,22,247,138,2,182,4,135,10,114,247,47,255,236,252,119,12,77,10,225,4,52,250,164,252,207,4,206,250,176,6,223,251,166,12,131,241,239,0,30,4,127,4,55,15,73,5,227,1,229,255,11,250,197,253,209,11,133,241,169,4,48,252,191,254,130,242,60,255,202,251,148,5,10,249,68,243,200,13,57,6,146,13,20,15,92,243,156,2,185,247,175,246,29,9,120,245,103,250,231,249,230,241,62,253,231,240,120,0,136,11,14,7,72,252,126,14,21,2,141,254,59,8,225,8,166,250,136,9,233,14,128,253,12,4,172,7,233,250,228,0,14,244,193,7,24,3,85,247,183,246,197,249,254,10,91,8,72,247,138,248,24,255,76,250,120,12,237,13,9,245,32,249,222,252,191,240,108,14,210,245,177,5,103,8,72,5,17,243,183,7,151,10,137,11,152,0,77,9,245,255,70,242,142,3,97,5,202,13,163,247,31,242,127,11,233,249,155,242,121,247,140,252,91,242,6,12,19,245,48,247,153,1,185,7,84,255,27,248,21,247,64,12,146,247,20,244,144,8,220,245,234,249,96,13,44,247,231,241,148,241,217,0,127,244,249,241,110,4,177,11,156,1,113,247,34,250,226,0,187,246,141,2,149,12,28,11,193,0,208,244,17,6,150,10,42,253,56,11,107,247,222,11,49,11,64,250,71,255,28,245,67,248,139,3,63,4,97,13,140,11,41,9,161,2,64,254,133,253,2,250,130,255,147,251,239,244,76,243,169,12,117,13,210,247,128,11,79,14,189,12,205,11,140,7,199,1,83,252,119,252,53,1,52,246,66,252,100,8,151,10,161,246,136,2,81,1,238,12,213,240,219,242,41,249,56,9,110,1,235,251,130,11,13,253,212,242,161,245,83,6,70,15,174,242,50,4,233,248,254,245,217,3,67,246,114,251,132,9,0,252,205,245,121,250,158,10,76,7,70,245,66,15,60,13,197,14,169,243,172,7,175,250,53,12,2,242,75,6,94,248,176,11,13,246,11,241,149,9,0,250,177,249,148,0,93,245,137,2,30,3,169,9,247,247,117,4,61,252,65,241,112,11,10,14,212,6,81,9,146,252,153,9,152,244,23,248,91,12,63,1,184,255,29,9,233,248,236,13,222,1,108,248,143,4,112,245,125,245,85,248,23,8,35,14,101,250,69,2,160,254,245,248,37,246,120,248,171,242,131,241,31,9,75,10,95,1,232,7,79,0,148,2,221,10,242,5,208,6,4,4,48,246,25,10,113,1,238,245,206,3,75,7,97,241,189,241,133,0,116,1,140,243,213,2,138,247,114,8,202,242,50,3,34,12,35,2,111,249,218,5,240,246,130,12,180,6,20,248,81,13,143,7,240,2,216,245,209,2,64,253,101,9,119,9,59,245,176,10,141,252,29,15,177,247,84,249,41,250,227,248,210,245,129,0,205,241,19,15,52,5,246,14,112,0,248,249,187,14,90,11,68,245,80,241,27,12,92,251,194,5,213,14,221,11,212,5,193,252,84,1,161,244,195,10,65,11,186,247,188,6,199,3,9,8,95,241,223,252,47,244,73,255,153,246,176,5,76,5,135,8,183,247,157,13,3,5,216,10,111,247,124,2,20,0,164,11,131,241,153,5,174,2,13,252,54,3,209,3,157,247,166,9,251,14,117,255,6,245,106,9,185,248,110,4,31,242,61,244,222,243,54,241,31,243,225,245,218,10,124,242,222,252,214,1,173,12,228,247,197,252,153,244,222,11,114,252,211,240,189,252,70,255,152,247,250,250,251,3,185,251,153,247,231,246,19,12,68,245,80,255,120,2,227,4,198,250,117,9,10,1,173,14,189,12,5,2,24,247,153,0,222,2,255,11,139,3,70,246,253,12,222,3,168,13,64,8,23,255,189,11,63,7,192,250,35,252,24,6,236,8,53,248,179,247,118,244,165,11,84,13,150,5,189,1,91,248,1,244,153,253,183,13,73,1,123,247,246,2,57,0,34,249,83,255,59,252,241,244,163,11,212,253,65,251,227,248,235,243,104,7,125,0,130,245,134,250,200,14,130,248,120,254,50,251,228,13,73,251,129,3,33,7,32,10,129,254,191,250,211,248,24,250,92,2,15,243,77,8,71,15,164,6,249,1,220,14,188,245,26,253,76,2,143,8,24,247,211,251,41,7,221,255,224,242,165,248,185,244,144,9,141,252,153,8,155,1,155,11,198,247,62,250,46,12,2,254,58,255,253,2,223,1,4,247,162,240,123,248,71,241,149,251,74,241,63,13,208,10,88,248,37,8,3,242,54,11,127,248,254,10,1,241,116,244,172,254,81,5,103,244,70,241,105,247,172,2,103,252,99,248,218,8,125,11,159,11,186,12,36,242,240,240,219,244,36,5,247,5,100,251,83,241,220,14,119,251,161,253,71,11,149,249,12,9,65,248,183,7,185,245,154,251,61,249,225,11,210,249,136,14,67,1,64,251,172,8,100,13,84,248,120,255,228,251,85,248,171,2,98,4,20,2,152,255,121,10,5,252,102,246,234,249,232,0,9,14,171,246,117,244,99,247,99,11,176,1,222,243,28,4,113,250,168,9,118,251,8,5,206,255,229,247,223,5,191,5,124,245,17,244,190,250,220,2,63,7,89,10,92,245,110,252,28,251,220,247,134,248,31,252,160,240,148,10,243,251,138,5,213,11,180,5,246,10,167,7,17,1,181,249,8,0,68,245,99,255,27,250,218,11,102,247,87,6,232,254,194,255,108,252,241,254,150,247,174,244,238,0,147,242,90,246,147,254,252,14,136,252,134,251,225,5,77,254,35,0,90,255,229,9,11,14,97,0,245,240,165,255,153,252,224,2,252,244,13,0,156,255,5,12,207,247,96,8,66,8,164,3,115,252,129,0,60,247,58,0,73,7,8,249,97,246,26,248,152,249,11,250,225,253,155,13,253,9,147,252,203,244,104,9,50,242,27,247,187,5,176,254,233,1,109,9,194,250,160,8,119,5,73,6,57,12,254,249,183,251,91,244,217,244,135,7,208,241,232,8,176,249,126,7,116,245,31,3,240,8,67,11,27,9,117,246,25,250,18,255,121,8,185,252,198,241,143,252,0},
  {59,246,174,2,216,243,3,1,82,255,191,241,17,242,92,4,230,240,84,253,121,12,92,254,46,241,85,5,238,4,53,242,2,249,159,0,136,242,255,13,69,5,56,14,13,3,19,15,95,8,243,252,137,1,222,251,142,13,82,253,63,3,109,0,29,10,150,251,100,10,69,255,131,243,115,6,111,8,0,241,198,13,67,247,3,248,116,4,134,11,199,246,214,4,219,247,81,15,246,255,76,244,163,240,219,240,60,251,238,7,159,251,135,8,74,245,207,8,198,14,34,242,50,12,26,248,18,248,61,254,177,14,223,7,128,255,241,5,214,240,61,11,84,242,15,254,143,0,134,12,134,6,24,9,216,10,133,250,86,253,241,240,205,249,37,12,97,6,34,2,217,241,162,248,69,0,170,251,79,13,10,10,106,4,59,255,21,246,25,6,155,12,112,243,90,8,27,248,158,9,141,9,45,242,72,246,39,244,4,254,66,252,28,249,205,12,78,7,126,1,164,250,35,2,203,13,109,246,179,242,253,254,214,241,84,254,84,251,85,250,67,255,195,0,252,2,79,1,207,253,2,2,222,13,22,252,20,11,161,2,179,243,191,1,5,254,212,5,18,243,108,248,242,251,27,253,233,248,114,14,20,244,76,247,109,14,187,249,9,4,223,248,217,0,233,0,75,244,116,244,29,0,160,250,58,12,121,249,244,13,73,246,117,2,62,6,65,13,110,242,78,5,158,251,82,244,242,249,25,6,185,8,185,245,229,4,55,11,220,249,36,9,116,242,199,250,153,242,38,13,140,13,239,248,185,11,11,253,165,250,237,8,224,7,244,250,146,255,244,4,126,253,111,3,46,243,130,253,121,243,194,11,21,1,153,14,6,2,164,255,94,255,241,7,151,12,88,6,126,0,220,252,59,13,249,13,97,242,109,3,167,242,132,253,14,251,103,244,14,14,150,11,248,252,173,8,147,1,57,252,125,5,118,8,186,254,230,244,253,10,18,254,53,4,67,12,94,252,12,4,207,250,241,6,5,247,224,12,126,4,210,241,214,252,52,9,211,244,52,11,192,247,50,14,89,254,186,13,58,7,255,251,205,0,15,241,85,9,222,12,247,243,34,241,73,255,43,242,12,250,20,2,54,7,147,10,145,10,11,10,230,251,40,5,197,0,1,3,251,241,163,244,128,9,77,247,241,6,55,251,34,2,98,12,209,12,53,3,28,253,223,12,254,10,206,14,140,11,114,241,4,248,162,13,133,243,165,255,189,5,212,3,200,247,83,11,76,244,126,3,245,241,168,254,67,10,1,253,21,244,98,252,108,253,180,9,166,6,236,5,5,10,198,9,116,14,189,4,211,254,171,240,15,1,255,2,176,14,112,3,76,243,7,241,226,246,16,252,204,247,222,242,32,255,84,247,5,1,123,245,173,249,17,1,196,12,51,9,55,9,44,7,241,245,43,2,231,11,39,13,8,245,59,5,245,248,14,246,184,247,251,9,138,248,133,247,94,9,43,5,95,4,231,242,88,14,11,10,234,242,211,253,36,244,198,7,223,251,33,4,121,244,252,242,126,2,76,242,142,252,167,245,179,2,31,9,24,242,35,13,117,5,73,5,65,9,177,0,217,244,147,249,168,252,113,255,110,242,234,7,19,248,186,246,127,5,8,8,8,242,216,241,36,12,12,247,1,2,64,251,153,5,190,4,20,13,207,251,85,7,223,10,52,4,41,255,101,252,128,241,23,10,112,3,160,3,167,7,98,13,66,2,42,13,160,243,163,246,124,2,215,249,7,7,209,240,194,10,107,254,31,243,191,243,54,0,145,243,111,249,252,10,94,15,10,251,33,14,185,6,253,240,21,6,108,8,133,247,251,12,138,250,92,14,191,11,202,3,123,9,66,4,88,247,254,247,248,2,103,253,31,2,137,3,244,0,230,9,156,255,251,2,17,11,6,254,161,241,241,8,121,4,100,247,47,255,125,253,89,244,90,0,206,254,169,241,155,13,186,14,81,249,78,0,156,242,202,254,138,254,195,243,156,247,228,0,254,246,236,254,223,240,28,252,194,240,47,249,71,5,58,255,231,254,90,251,81,251,185,240,154,10,210,8,88,12,16,250,229,242,141,4,210,244,59,254,243,248,236,9,4,249,219,246,45,2,93,246,229,11,57,1,74,252,188,244,229,12,8,245,208,0,219,252,169,8,95,252,253,240,39,6,134,254,136,14,125,244,210,242,230,14,175,252,178,244,157,11,214,8,124,13,235,14,64,14,129,7,19,9,140,1,179,246,72,14,47,242,130,8,209,255,9,7,252,253,164,0,110,9,153,7,45,254,2,249,172,1,201,11,141,248,46,0,207,0,18,15,119,245,101,248,227,252,204,11,242,1,250,12,55,252,34,4,213,14,25,1,122,255,230,241,162,11,220,5,38,4,69,250,123,255,79,248,8,252,130,251,118,6,172,12,135,252,249,0,25,243,89,243,124,247,181,243,59,14,104,243,82,6,192,243,109,6,110,244,53,244,107,0,23,241,61,252,113,244,26,4,143,6,221,12,217,251,140,6,237,254,7,15,53,247,53,241,107,2,222,252,42,255,138,247,131,2,1,15,51,250,129,0,187,251,68,4,239,1,225,12,144,6,117,245,102,251,89,252,227,14,162,9,79,253,225,252,74,247,14,247,116,7,148,1,51,12,77,0,184,5,2,6,163,8,231,252,183,254,52,253,189,252,129,247,142,252,29,7,77,248,169,242,33,243,228,5,173,250,168,13,8,250,244,11,52,13,56,15,14,11,218,254,160,254,132,0,165,8,211,7,136,4,134,5,244,14,60,255,69,0,234,1,107,254,86,247,107,1,80,8,19,11,100,247,38,2,214,0,115,0,160,10,237,240,250,4,49,245,231,252,214,14,58,9,34,14,206,13,236,254,145,1,38,9,64,243,103,5,1,247,63,2,19,246,115,246,227,247,198,9,19,14,125,3,239,252,3,255,226,3,238,252,162,14,142,8,107,4,175,244,83,4,200,9,87,245,83,245,254,14,17,3,137,253,245,4,45,243,76,7,216,243,171,246,190,244,27,9,230,241,170,255,116,243,53,254,238,4,218,255,19,6,160,246,140,252,199,0,45,255,44,252,186,13,241,5,11,244,166,244,156,3,125,12,69,245,163,242,160,240,26,8,199,8,88,7,181,248,250,251,245,244,238,14,234,249,72,10,210,12,247,243,94,247,164,4,101,250,233,11,6,14,72,2,51,4,21,248,93,8,182,3,173,246,202,248,226,244,145,243,82,10,28,7,110,13,243,252,136,248,100,245,116,241,199,246,209,4,16,13,228,241,70,10,24,11,142,6,7,242,4,241,184,7,12,241,145,6,213,4,55,9,126,3,252,9,200,11,150,12,122,249,57,243,175,250,201,13,155,8,148,7,85,5,69,13,10,241,8,241,149,251,86,11,24,1,232,252,209,245,77,243,232,9,199,253,131,252,138,247,232,8,236,9,248,0,59,3,60,10,181,249,250,252,69,13,41,246,219,3,208,242,60,14,245,245,29,0,72,242,213,254,66,11,46,6,211,9,196,251,249,248,62,9,131,253,144,248,223,14,247,241,161,246,104,14,246,7,60,246,248,0,11,5,19,0,41,241,67,12,240,6,239,246,171,6,217,251,148,249,116,3,130,254,182,0,131,254,200,12,234,253,125,3,190,247,164,255,231,249,107,245,66,3,18,246,9,13,17,13,170,4,208,1,251,8,23,242,148,255,92,3,107,255,7,249,42,241,228,245,63,250,150,0,58,11,43,243,25,243,1,11,111,3,168,255,175,4,213,240,239,248,95,252,227,242,142,241,166,6,13,9,51,1,254,12,81,242,226,10,242,8,40,248,185,252,51,253,54,255,195,241,237,11,37,4,158,245,223,10,207,241,240,247,167,11,170,251,58,2,144,7,219,11,244,8,123,253,121,8,119,10,175,254,176,13,9,8,106,5,34,251,132,244,119,241,240,244,14,13,127,249,7,246,118,12,127,251,59,13,216,7,204,3,62,13,229,248,16,9,106,1,62,14,171,242,211,245,47,252,130,245,106,244,113,3,9,2,86,243,60,251,40,8,61,1,159,0,176,250,182,10,125,11,89,250,20,13,26,251,204,241,212,7,98,247,92,247,4,1,213,1,42,15,46,5,124,254,134,243,249,10,124,248,72,3,203,251,253,7,255,248,34,244,68,14,215,1,11,249,178,241,28,12,204,13,20,11,241,253,109,6,36,2,67,1,220,248,199,255,187,244,151,244,14,252,61,4,168,9,153,250,110,10,113,12,183,14,110,5,32,8,33,2,81,4,186,243,95,2,3,11,128,5,181,12,208,8,147,249,9,11,8,252,51,9,58,5,60,243,235,254,201,243,124,250,198,249,180,252,51,5,172,11,216,250,2,14,0,1,248,250,211,254,31,2,65,248,202,6,194,245,155,254,212,251,34,252,55,245,118,243,163,1,34,248,141,9,199,11,231,253,199,3,122,244,39,6,107,246,200,4,35,11,62,9,145,248,199,8,83,246,92,8,145,244,222,251,139,253,224,255,56,14,231,241,153,248,255,1,158,2,180,248,120,251,187,13,57,247,245,249,246,2,96,15,190,5,29,243,122,3,109,255,67,4,142,245,248,242,73,2,128,3,47,3,149,4,126,245,173,12,152,243,77,252,243,10,235,13,134,251,221,242,237,0,190,245,253,253,221,248,52,253,199,13,34,241,82,248,38,255,135,245,21,254,13,247,189,248,53,5,73,11,132,7,163,244,13,243,41,7,128,252,140,13,45,242,17,255,37,0,47,250,197,243,189,8,205,252,178,2,113,10,224,243,36,244,2,254,42,241,137,253,176,247,87,0,252,244,115,0,73,6,134,247,135,13,183,6,166,11,13,255,136,3,137,248,166,247,111,245,40,252,236,4,209,250,156,7,234,8,117,241,26,3,234,1,103,9,155,241,72,6,252,242,177,13,147,0,147,254,132,242,193,13,187,14,18,0,109,253,87,252,150,254,202,7,120,244,94,242,45,9,154,7,175,251,172,242,67,244,187,2,66,4,53,249,146,8,47,8,233,14,245,255,173,241,144,8,86,4,74,15,211,240,99,244,1,252,121,11,64,249,164,5,160,255,77,250,187,3,145,244,209,10,71,11,124,242,230,245,231,2,118,9,186,4,93,10,21,14,168,10,70,1,63,5,184,14,11,252,0,9,8,10,224,8,20,3,93,14,168,13,72,8,50,245,88,7,27,242,77,6,167,242,250,253,248,11,35,13,253,249,9,5,253,12,208,250,191,8,194,251,86,248,32,12,9,9,189,243,97,251,82,2,5,6,80,8,132,241,205,2,233,253,59,251,125,255,210,12,247,253,225,9,33,254,255,11,179,241,96,242,158,4,2,13,44,3,120,246,36,15,116,4,65,4,119,13,229,247,101,4,133,245,205,10,22,1,176,5,254,255,27,247,160,240,164,14,171,254,19,14,104,252,46,245,255,6,0,247,47,0,6,249,155,1,61,8,224,12,95,249,235,6,177,1,72,250,81,242,13,242,31,11,74,246,192,12,97,0,224,3,198,14,9,5,191,240,40,12,47,254,10,9,94,243,96,245,229,246,147,251,90,253,25,15,56,3,8,0,162,248,216,244,203,3,182,3,224,252,1,251,11,244,230,6,80,243,187,251,59,249,77,4,3,254,163,242,206,254,152,252,164,252,13,3,235,255,214,244,23,248,102,10,0},
} ;

static const unsigned char precomputed_core_invsntrup1277_n[precomputed_core_invsntrup1277_NUM][crypto_core_INPUTBYTES] = {
  {163,85,191,245,248,250,53,42,196,204,248,160,221,219,115,185,171,89,212,202,129,227,223,224,225,50,40,252,77,37,11,83,118,71,20,27,120,25,35,252,0,58,115,96,184,195,215,180,61,33,3,10,74,52,243,136,143,250,2,84,237,150,108,254,224,155,185,96,235,86,131,181,98,73,26,253,80,49,178,143,209,53,210,34,43,180,43,69,174,149,118,19,122,190,119,219,234,201,210,50,7,52,150,177,221,54,29,39,27,75,216,172,240,171,228,169,184,13,103,206,23,123,171,47,203,174,12,245,154,34,78,5,81,17,110,75,217,164,80,50,226,140,142,94,107,52,244,199,80,76,34,77,27,44,144,250,200,206,165,141,42,121,121,38,253,116,170,105,191,10,18,92,214,153,226,252,18,106,134,225,60,36,26,72,212,244,54,205,182,32,121,180,68,99,163,116,140,219,89,229,66,155,129,66,69,55,131,209,232,215,45,28,89,157,107,133,47,101,43,163,34,81,37,254,116,120,53,180,27,79,198,18,131,114,57,90,167,234,35,197,73,146,32,115,191,61,211,96,244,164,217,131,124,234,189,147,234,133,195,222,120,106,86,179,14,151,168,234,19,46,36,35,227,166,246,181,177,93,24,33,39,158,87,78,146,129,106,1,13,153,86,68,58,160,199,103,25,228,113,252,135,41,249,137,255,217,192,154,231,45,182,175,160,233,93,22,179,91,33,8,141,133,47,176,177,161,32,201,204,124,82,6,64,128,241,134,88,6,170,249,232,194,41,209,211,139,84,18,84,99,92,120,106,155,160,131,79,27,234,249,42,180,187,2,94,255,130,44,170,106,114,129,157,160,64,104,168,255,201,200,138,223,199,12,111,172,142,40,10,175,56,186,136,197,169,228,96,34,64,24,90,163,39,109,177,157,16,83,193,57,110,191,16,64,57,100,198,91,82,38,215,21,207,215,170,189,155,192,18,135,251,135,249,225,176,36,83,22,179,117,117,10,64,224,195,160,41,140,207,107,45,66,221,172,182,211,252,122,7,178,1,182,61,18,239,126,140,214,150,120,46,17,30,9,162,95,61,224,130,97,186,192,88,42,202,0,249,18,173,197,188,116,125,59,212,145,76,156,100,145,71,208,93,227,200,15,63,12,27,229,235,240,244,210,213,4,24,165,19,185,66,206,251,94,91,94,48,9,66,4,89,36,99,142,56,91,0,211,165,53,96,89,136,158,116,141,162,81,44,2,212,88,82,141,242,222,237,182,134,134,59,56,192,68,183,244,215,146,112,21,200,225,194,8,205,201,174,129,90,182,106,68,159,152,158,92,62,181,247,50,113,181,248,71,232,178,217,120,25,139,134,60,96,164,208,223,243,119,158,239,21,80,55,171,125,58,20,135,122,166,44,111,121,222,216,232,253,150,241,182,17,62,195,81,88,230,151,96,212,76,226,20,58,251,71,162,98,230,43,92,157,194,110,110,207,252,138,25,67,215,217,8,238,141,185,41,141,212,112,231,125,242,186,93,51,39,63,26,62,64,146,222,237,168,198,215,69,32,175,135,18,15,193,111,160,232,221,238,169,62,94,79,8,99,53,221,16,37,105,70,165,166,203,175,62,157,156,70,90,168,225,142,71,159,50,17,93,74,62,200,209,124,197,86,224,196,19,83,11,4,164,135,10,101,174,236,149,146,204,177,46,146,50,131,105,200,34,19,48,132,90,209,71,143,227,165,59,219,204,222,16,61,143,69,237,124,3,127,134,68,115,153,157,238,196,96,38,63,112,184,119,178,111,221,251,18,113,102,253,23,148,84,166,16,167,72,11,211,21,57,100,252,251,72,35,1,36,5,201,76,67,105,211,206,130,45,89,223,12,163,118,73,19,153,169,155,4,31,151,218,134,40,85,19,24,72,24,183,97,244,156,48,194,167,127,19,159,136,120,95,101,39,135,127,47,147,214,207,113,92,0,40,168,4,58,184,65,95,194,249,7,239,128,249,214,147,247,126,152,71,153,231,159,149,165,192,35,63,195,65,158,90,44,95,244,55,219,74,187,46,2,112,161,168,133,61,105,72,31,218,144,205,57,15,20,94,50,49,100,115,89,240,249,48,255,111,178,192,11,161,60,230,94,84,13,183,167,12,163,71,246,171,44,92,233,159,77,229,201,249,83,87,212,151,143,95,91,122,241,217,109,246,100,177,7,71,117,3,119,214,178,52,191,211,111,132,221,5,113,222,144,63,82,123,88,43,22,254,118,255,79,182,119,91,38,188,105,205,128,5,162,56,227,58,85,197,32,144,154,141,164,164,80,71,72,41,197,246,176,2,255,26,138,98,213,1,191,40,34,251,181,204,241,38,133,61,240,113,18,247,170,219,180,238,9,160,38,13,144,47,24,127,212,114,157,233,223,109,241,241,75,90,230,137,153,156,94,212,247,165,140,180,53,144,27,101,223,16,138,121,164,91,104,141,116,32,10,36,194,55,17,29,126,108,75,183,68,194,163,73,29,182,71,23,209,249,251,25,124,154,75,231,199,238,232,221,245,211,81,155,26,204,101,130,110,202,96,107,38,154,222,66,243,47,117,126,43,126,228,47,210,30,153,125,234,109,36,12,124,87,15,245,66,153,184,48,130,49,221,90,112,130,220,149,142,126,138,168,37,166,50,168,74,153,247,188,229,69,27,149,59,124,12,43,89,198,51,79,165,18,107,179,132,214,164,232,170,238,148,169,129,255,238,69,129,147,134,98,85,144,27,230,6,88,119,130,96,79,21,44,55,29,212,82,79,108,225,38,159,100,89,205,14,137,162,100,246,133,215,78,37,32,139,4,26,150,98,54,37,96,208,201,224,236,97,229,61,240,7,217,199,64,124,26,16,23,21},
  {153,162,97,196,15,154,177,149,1,193,219,15,253,94,119,187,125,228,170,146,163,140,151,56,97,148,170,47,103,13,121,14,76,251,58,221,49,173,29,255,15,218,97,255,167,195,63,31,151,228,214,86,234,42,223,101,98,160,30,149,114,49,86,138,55,17,65,235,65,80,214,234,41,44,108,120,163,5,215,114,172,114,98,130,163,54,100,150,111,94,247,131,93,241,37,169,12,18,150,108,252,35,172,134,61,200,146,149,7,179,69,99,181,222,69,50,87,65,138,152,77,34,109,217,226,115,5,244,124,6,49,68,96,68,60,81,29,16,11,121,112,83,250,102,243,3,238,56,9,154,130,9,91,41,37,31,132,167,185,30,74,158,130,136,240,245,86,185,123,121,128,133,100,190,150,12,177,110,118,96,73,55,93,192,95,49,50,106,43,182,142,188,93,225,174,11,51,173,243,19,208,11,15,153,155,212,245,223,73,86,103,6,221,160,129,61,133,92,12,105,226,98,123,119,148,179,50,144,59,35,205,216,83,60,138,200,9,34,224,9,179,196,224,53,52,200,104,188,70,53,86,1,88,167,212,44,211,125,83,138,164,44,227,1,66,221,228,118,23,39,177,163,221,235,219,105,211,96,228,129,203,31,22,30,225,206,36,56,173,113,139,12,17,56,150,42,0,88,143,219,84,187,148,143,217,107,175,165,173,167,168,161,35,163,122,84,213,187,91,235,64,182,244,97,47,57,9,28,108,201,173,183,82,233,122,1,155,48,34,251,74,29,193,186,165,207,201,240,192,3,163,170,88,144,96,181,87,154,177,255,201,211,153,233,111,71,21,160,49,48,138,95,150,52,157,212,23,156,51,107,11,163,34,171,15,69,195,162,7,48,53,199,143,185,238,228,69,1,62,34,98,215,223,160,75,134,202,153,244,59,190,110,239,79,67,4,85,252,236,6,123,48,185,202,210,55,114,192,6,99,178,126,105,153,164,2,151,20,119,0,179,58,60,101,57,96,147,147,190,129,158,59,168,54,103,153,9,129,35,34,19,240,62,2,142,250,65,67,214,91,81,221,184,117,58,169,39,230,210,242,77,249,193,175,31,118,75,102,5,99,87,231,206,54,208,185,250,178,107,15,5,64,152,223,126,135,241,211,37,153,254,13,180,25,101,161,168,253,86,75,100,227,64,151,46,50,87,137,6,59,61,69,54,11,204,185,76,141,211,143,20,212,165,87,43,218,240,75,143,12,88,167,125,135,66,93,163,120,108,9,2,238,79,223,222,118,59,122,121,253,102,89,200,163,53,149,83,204,158,38,147,0,187,148,243,235,9,78,37,155,141,57,170,248,189,191,8,108,179,169,37,29,75,85,113,128,38,204,125,196,54,205,95,172,206,202,122,112,66,24,205,69,234,246,252,85,162,96,160,148,127,115,101,1,65,106,205,224,229,68,235,26,46,23,247,31,170,42,23,205,173,139,209,185,199,83,80,235,106,2,78,104,179,91,77,129,152,130,250,197,121,100,210,221,54,75,146,16,235,91,202,163,123,169,56,210,243,236,248,175,107,231,64,20,164,200,217,73,151,162,5,67,230,210,102,163,97,227,196,221,82,223,81,132,177,236,101,182,23,73,200,188,81,212,36,175,43,161,135,237,140,196,129,139,235,118,115,82,71,57,227,214,2,254,93,138,186,87,61,139,12,144,129,177,25,66,164,226,107,48,174,170,254,22,215,61,1,91,142,26,148,81,55,71,190,223,85,144,168,67,76,198,217,41,168,9,4,101,105,196,131,35,192,7,223,95,221,170,244,222,114,247,49,252,143,253,40,133,222,151,70,169,93,225,130,38,236,248,236,22,12,186,134,27,195,170,178,103,82,68,140,96,71,35,33,208,254,161,70,255,28,251,219,129,71,229,44,89,96,182,214,237,5,235,251,74,123,183,252,15,136,136,70,238,45,45,223,87,108,130,159,84,31,179,45,32,105,190,199,242,158,86,189,191,199,17,136,180,51,168,255,31,114,18,154,96,94,70,230,17,131,207,75,46,62,126,205,21,2,79,64,157,200,142,223,235,79,182,3,192,176,120,129,10,183,162,25,38,240,128,235,122,169,237,86,251,218,21,142,129,31,242,18,143,95,141,103,232,161,228,65,185,233,43,19,123,146,97,203,18,253,217,127,200,56,163,216,39,18,19,230,79,33,32,11,92,235,209,156,70,229,115,12,123,188,53,13,134,179,106,137,204,168,243,211,72,117,245,15,124,218,51,90,3,69,208,252,217,186,207,190,246,58,47,239,190,176,128,155,104,180,1,129,87,217,68,61,139,249,152,117,6,202,116,165,122,147,137,14,134,216,195,214,201,205,110,183,178,114,101,64,253,177,230,49,78,237,156,225,80,125,133,104,219,185,245,91,111,239,210,82,77,92,243,132,183,41,21,126,29,54,122,145,234,59,54,144,131,150,94,27,201,192,44,3,141,68,174,162,195,72,246,122,57,173,79,234,211,215,59,99,138,230,145,40,204,200,150,190,20,97,157,170,153,145,254,204,3,49,128,221,177,89,46,252,157,75,146,207,212,184,2,9,189,110,40,187,125,245,64,76,73,87,5,39,103,249,84,4,22,87,154,229,70,105,27,216,235,34,129,38,73,128,66,122,152,156,15,27,46,120,74,71,70,60,169,190,64,168,28,179,100,130,31,204,106,230,140,203,187,90,168,179,71,99,185,85,209,41,214,196,9,152,85,7,27,222,233,206,14,75,231,12,225,105,47,0,208,190,209,209,184,46,48,75,115,9,97,191,131,133,91,254,137,172,28,87,151,33,185,153,77,82,34,151,43,11,135,148,120,32,151,132,104,19,211,62,61,114,79,51,239,121,12,170,75,120},
  {191,236,91,143,207,246,63,218,221,239,156,235,115,244,14,121,142,20,97,23,176,42,190,229,39,38,23,172,137,97,157,92,213,78,58,175,43,158,234,40,226,234,82,195,76,158,147,133,52,170,151,1,176,159,185,99,198,183,86,74,129,199,140,74,202,232,230,112,52,35,40,166,119,232,206,46,211,105,218,221,70,88,211,173,237,152,189,66,88,64,254,254,215,2,205,101,15,18,228,66,91,179,144,170,6,23,241,128,17,39,109,60,34,200,200,35,185,140,92,249,153,16,55,240,62,81,231,182,93,178,188,219,96,47,221,139,157,227,126,8,139,240,77,236,189,3,2,140,74,204,185,77,125,223,196,138,63,156,61,151,65,212,8,136,158,186,162,238,151,83,218,176,147,172,138,228,94,232,121,115,204,18,125,177,63,178,18,70,41,119,115,75,86,21,181,70,238,206,164,177,142,73,192,36,93,45,197,82,54,93,192,201,114,119,194,182,8,49,12,38,183,29,199,121,88,215,112,237,41,148,27,31,10,57,171,67,186,149,100,163,25,154,128,36,180,229,206,93,247,215,176,56,199,227,240,59,111,0,150,162,206,159,1,37,3,160,21,68,97,67,88,143,41,82,181,40,35,41,154,118,83,141,102,223,14,139,7,183,165,233,192,232,9,207,51,240,209,202,149,231,14,172,6,224,70,247,190,126,171,23,32,14,138,143,33,128,144,5,198,163,235,0,225,168,99,209,29,179,196,50,179,116,90,45,199,42,42,181,132,33,186,46,94,148,125,139,40,169,7,103,120,166,251,139,215,128,28,130,146,156,208,43,212,169,14,22,149,15,160,52,219,58,237,5,18,0,179,77,7,217,162,170,49,169,189,60,102,156,50,71,173,65,72,24,56,71,209,118,45,183,6,34,200,137,90,5,55,200,9,104,35,130,52,185,155,64,1,236,19,180,51,12,140,167,102,212,193,118,195,67,213,217,255,17,5,4,165,224,24,198,70,100,132,102,122,229,248,62,136,110,211,112,181,46,61,175,164,129,224,106,186,165,4,212,133,251,40,49,185,176,181,253,51,31,177,118,127,192,29,214,29,44,2,36,200,8,3,4,30,131,19,5,113,12,111,46,151,226,130,79,153,122,124,174,228,16,117,87,36,192,58,132,27,225,242,214,174,191,142,109,168,230,84,100,87,32,52,157,161,199,190,247,98,244,125,183,40,145,22,109,5,169,38,87,81,155,198,101,82,180,252,131,44,234,81,146,100,95,127,2,189,177,205,8,7,202,214,80,185,51,22,238,8,65,30,70,57,2,75,5,224,133,218,176,76,243,7,70,30,38,193,152,247,245,141,128,140,162,93,210,63,48,98,248,36,218,69,202,36,79,1,116,252,29,6,39,237,62,255,38,202,213,245,213,200,211,84,55,243,51,199,232,57,246,191,114,94,212,40,84,27,206,118,121,30,186,98,104,175,201,232,72,120,252,127,3,102,102,164,130,232,219,52,196,21,228,81,132,159,245,43,75,233,244,182,11,171,182,190,28,114,13,78,79,239,188,182,170,139,219,54,151,141,252,191,72,182,167,124,223,86,1,29,25,27,57,187,209,121,8,13,249,77,131,164,5,84,58,108,243,85,39,59,255,106,186,191,173,75,130,152,125,168,7,16,118,84,12,222,46,48,2,36,88,133,48,64,20,204,103,168,243,172,39,116,244,226,125,222,169,70,198,5,187,211,25,78,153,112,160,132,85,59,106,27,87,85,82,226,96,201,132,240,79,158,101,45,153,154,219,70,129,34,18,209,154,185,202,174,61,154,140,152,178,238,201,165,131,194,181,167,53,138,234,49,230,10,173,178,152,118,189,123,95,196,185,69,149,132,159,38,48,119,241,124,7,42,233,58,75,230,188,217,109,111,239,141,159,182,48,194,233,241,171,71,120,102,158,221,122,161,220,53,147,162,81,40,16,96,88,204,213,78,96,162,232,147,142,108,48,52,104,0,235,62,62,25,127,17,49,163,157,106,171,5,136,99,143,71,219,42,85,99,186,85,220,197,247,32,45,221,118,197,140,52,236,206,230,100,77,254,178,22,52,16,252,48,102,98,242,151,94,66,30,126,49,144,195,96,229,197,132,148,20,104,158,145,104,149,235,68,68,253,57,237,68,187,149,127,25,121,158,43,79,51,85,207,240,159,1,200,201,112,8,184,221,25,31,39,201,211,48,29,140,86,168,116,204,86,130,38,61,28,192,138,58,145,178,70,235,34,212,94,78,112,53,17,20,200,12,127,163,182,244,67,6,227,41,20,2,96,144,178,190,210,170,157,203,68,85,30,12,56,116,4,65,106,189,131,83,126,230,111,7,165,2,83,188,36,255,172,52,78,247,168,217,222,123,91,153,210,181,97,79,186,110,200,36,38,197,197,57,82,5,213,85,95,51,7,253,202,147,211,39,12,182,46,246,218,91,39,17,9,57,95,196,105,156,151,77,53,43,88,42,150,109,53,37,80,235,128,254,100,173,158,25,16,8,141,200,23,159,89,89,205,126,160,247,24,220,254,44,172,86,104,0,38,172,59,135,228,167,58,153,197,38,130,210,152,243,85,34,40,12,237,40,175,221,239,34,181,89,80,243,130,29,201,127,87,224,147,178,210,112,180,255,8,56,224,58,29,2,93,65,224,134,53,96,126,203,245,255,71,111,32,141,102,153,103,237,212,104,23,97,21,114,228,136,67,202,88,62,156,56,108,238,222,85,250,215,111,25,183,105,187,224,140,161,198,153,105,216,166,247,96,175,7,227,20,238,34,189,53,224,47,167,211,250,125,221,93,181,130,205,177,171,174,110,36,216,95,15,231,64,132,63,21,102,94,228,117,199,229,110,63,189,62},
  {154,108,243,222,154,122,223,223,8,134,191,47,86,85,24,116,217,199,99,63,9,145,47,87,109,43,169,167,196,68,75,166,162,70,1,225,50,150,150,135,44,251,47,46,22,211,114,91,32,255,123,19,62,38,228,49,38,116,104,112,127,236,243,157,235,117,89,232,226,176,211,105,235,130,46,221,126,116,60,116,93,244,79,49,5,245,113,183,147,46,208,1,130,176,42,113,138,116,252,204,166,244,177,210,242,88,114,173,172,101,212,21,221,118,92,65,76,149,213,75,3,254,235,88,156,212,115,7,184,47,65,94,96,170,126,183,165,91,219,146,0,157,14,219,241,86,220,209,71,209,162,108,247,169,70,45,3,73,131,171,97,33,205,161,129,62,250,219,248,213,90,37,55,119,237,181,31,240,140,235,40,193,156,76,130,242,36,121,7,130,123,52,73,120,58,160,43,112,77,0,75,38,56,74,137,97,63,12,45,105,40,81,145,161,131,99,58,168,60,159,57,102,214,161,245,49,231,5,47,150,153,141,221,95,87,113,50,90,75,206,88,242,213,185,248,228,15,18,43,57,31,89,204,207,152,227,247,109,177,182,187,88,227,183,118,230,173,232,255,125,149,9,18,16,68,135,46,37,162,135,76,87,192,77,31,176,29,35,86,33,109,31,14,1,180,13,21,245,152,110,123,64,170,177,131,90,3,136,250,7,203,173,165,69,93,62,118,53,33,193,81,17,96,73,76,122,144,16,143,202,115,21,159,211,58,206,162,168,102,59,180,23,133,158,31,228,31,104,203,99,9,72,38,14,70,154,83,24,148,206,71,59,142,64,254,228,194,73,3,8,50,29,135,117,56,186,107,122,197,165,203,184,49,10,235,114,192,30,39,157,83,30,148,123,249,162,168,121,149,252,204,72,37,225,139,53,57,190,130,211,21,33,212,167,18,54,175,65,171,196,60,45,146,211,96,39,204,74,231,80,29,248,160,214,110,146,183,69,247,152,215,60,233,2,120,39,141,147,10,229,60,114,50,168,153,0,237,4,114,16,185,199,182,62,156,92,91,53,233,232,185,226,147,152,249,192,15,36,14,110,212,147,113,157,160,250,27,159,211,85,193,53,133,63,126,253,172,115,4,104,233,113,138,170,163,163,172,237,43,83,192,92,133,246,174,203,241,26,170,181,196,160,145,254,189,17,46,195,110,139,168,165,152,105,233,35,108,4,93,52,221,204,136,212,29,37,250,30,28,188,82,63,79,65,96,103,119,173,57,168,34,205,252,44,14,118,138,5,183,13,98,195,63,36,22,22,139,58,67,191,68,26,236,79,17,164,16,103,52,238,152,147,42,86,129,74,156,64,121,96,241,36,131,248,8,110,128,94,64,107,91,165,224,214,222,117,119,245,32,138,142,184,131,10,139,105,7,195,88,3,66,52,211,222,27,122,16,145,31,243,221,237,127,148,8,120,171,153,113,124,111,40,131,119,124,105,137,111,173,106,82,33,187,118,212,237,63,193,45,176,108,76,136,153,143,215,123,30,52,223,123,3,200,14,154,19,71,195,4,127,71,63,7,8,60,208,25,240,230,54,165,198,79,37,174,42,72,164,188,52,191,189,252,177,96,173,249,7,223,245,250,97,5,236,14,234,224,215,152,174,75,165,137,152,239,83,251,253,51,115,184,174,186,34,55,20,42,133,219,51,170,15,209,53,6,43,15,72,56,29,83,242,176,195,243,41,175,171,61,8,65,1,204,181,231,97,71,193,92,8,167,136,74,2,216,105,138,247,155,176,55,4,246,50,232,190,123,243,37,104,98,211,19,75,34,53,222,25,218,83,148,141,104,231,175,248,164,61,211,145,162,75,207,116,123,235,255,186,85,202,1,185,184,124,163,123,112,217,174,232,31,111,186,215,248,123,61,79,83,162,143,122,249,58,228,252,234,69,190,89,154,211,196,9,160,71,11,7,39,46,5,211,98,21,75,9,9,107,252,68,42,72,247,98,225,226,122,85,164,199,75,197,198,172,111,73,77,72,217,5,32,160,176,72,104,141,76,34,188,192,226,120,200,108,44,129,122,87,81,11,69,66,16,83,91,170,115,152,85,225,117,80,255,207,252,33,157,247,46,46,124,195,134,172,83,169,204,107,248,181,223,166,94,157,30,128,188,23,209,214,126,76,11,193,35,32,39,31,165,75,83,94,117,114,188,213,115,26,62,46,73,135,138,185,24,111,158,19,255,241,151,153,16,28,66,22,75,165,56,30,196,136,47,127,219,213,80,126,245,188,210,128,14,34,217,101,64,124,21,50,165,165,174,109,88,120,211,132,190,237,118,109,70,200,226,82,134,27,0,16,72,164,116,207,126,162,25,238,217,223,244,115,104,245,161,173,91,111,124,48,36,171,145,143,53,210,233,52,111,229,119,23,203,116,240,234,103,103,29,208,92,157,216,253,135,245,236,65,149,144,192,119,63,130,33,98,24,125,6,255,253,150,220,135,20,26,136,144,116,83,154,112,118,207,72,102,153,30,24,52,102,87,195,47,104,116,201,77,34,34,27,201,161,142,67,226,158,169,224,56,71,87,122,253,79,86,249,154,228,85,104,150,239,84,178,189,253,60,144,31,100,66,255,207,188,25,233,193,164,152,227,0,175,44,64,238,239,116,6,96,104,65,220,180,25,169,14,212,83,241,63,72,210,172,163,12,9,201,115,47,1,173,201,46,62,109,210,221,8,243,7,247,159,160,59,208,192,172,39,237,211,159,31,55,33,228,215,149,11,227,10,59,29,134,84,29,49,148,211,209,128,207,180,90,68,150,141,178,164,45,71,90,233,26,212,176,231,203,251,116,239,227,99,227,94,143,20,189,157,31,53,64,208,198,94,176,98},
} ;

static const unsigned char precomputed_core_invsntrup1277_k[precomputed_core_invsntrup1277_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_invsntrup1277_c[precomputed_core_invsntrup1277_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_invsntrup1277_impl(long long impl)
{
  unsigned char *h = test_core_invsntrup1277_h;
  unsigned char *n = test_core_invsntrup1277_n;
  unsigned char *k = test_core_invsntrup1277_k;
  unsigned char *c = test_core_invsntrup1277_c;
  unsigned char *h2 = test_core_invsntrup1277_h2;
  unsigned char *n2 = test_core_invsntrup1277_n2;
  unsigned char *k2 = test_core_invsntrup1277_k2;
  unsigned char *c2 = test_core_invsntrup1277_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_invsntrup1277_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_invsntrup1277(impl);
    printf("core_invsntrup1277 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_invsntrup1277_implementation(impl),ntruprime_dispatch_core_invsntrup1277_compiler(impl));
  } else {
    crypto_core = ntruprime_core_invsntrup1277;
    printf("core_invsntrup1277 selected implementation %s compiler %s\n",ntruprime_core_invsntrup1277_implementation(),ntruprime_core_invsntrup1277_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");
    }
    checksum_expected(core_invsntrup1277_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_invsntrup1277_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_invsntrup1277_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_invsntrup1277_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_invsntrup1277_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_invsntrup1277_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_invsntrup1277_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_invsntrup1277_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_invsntrup1277_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_invsntrup1277_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_invsntrup1277(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"invsntrup1277")) return;
  storage_core_invsntrup1277_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_invsntrup1277_h = aligned(storage_core_invsntrup1277_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_invsntrup1277_n = callocplus(crypto_core_INPUTBYTES);
  test_core_invsntrup1277_n = aligned(storage_core_invsntrup1277_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_invsntrup1277_k = callocplus(crypto_core_KEYBYTES);
  test_core_invsntrup1277_k = aligned(storage_core_invsntrup1277_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_invsntrup1277_c = callocplus(crypto_core_CONSTBYTES);
  test_core_invsntrup1277_c = aligned(storage_core_invsntrup1277_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_invsntrup1277_h2 = callocplus(maxalloc);
  test_core_invsntrup1277_h2 = aligned(storage_core_invsntrup1277_h2,crypto_core_OUTPUTBYTES);
  storage_core_invsntrup1277_n2 = callocplus(maxalloc);
  test_core_invsntrup1277_n2 = aligned(storage_core_invsntrup1277_n2,crypto_core_INPUTBYTES);
  storage_core_invsntrup1277_k2 = callocplus(maxalloc);
  test_core_invsntrup1277_k2 = aligned(storage_core_invsntrup1277_k2,crypto_core_KEYBYTES);
  storage_core_invsntrup1277_c2 = callocplus(maxalloc);
  test_core_invsntrup1277_c2 = aligned(storage_core_invsntrup1277_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_invsntrup1277 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_invsntrup1277();++impl)
      forked(test_core_invsntrup1277_impl,impl);
    ++test_core_invsntrup1277_h;
    ++test_core_invsntrup1277_n;
    ++test_core_invsntrup1277_k;
    ++test_core_invsntrup1277_c;
    ++test_core_invsntrup1277_h2;
    ++test_core_invsntrup1277_n2;
    ++test_core_invsntrup1277_k2;
    ++test_core_invsntrup1277_c2;
  }
  free(storage_core_invsntrup1277_c2);
  free(storage_core_invsntrup1277_k2);
  free(storage_core_invsntrup1277_n2);
  free(storage_core_invsntrup1277_h2);
  free(storage_core_invsntrup1277_c);
  free(storage_core_invsntrup1277_k);
  free(storage_core_invsntrup1277_n);
  free(storage_core_invsntrup1277_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

