/* ----- encode/953x2115round, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_953x2115round_checksums[] = {
  "bbb31bbccfccf662777eabe951a585b359eaf9916a7eb4657d33356f7cfbb81b",
  "cb28590264fec821fd69bb3c0e81141743256f5cd8111fc3ac369b32bd43d73f",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_953x2115round_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_953x2115round_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_953x2115round_ITEMBYTES

static void *storage_encode_953x2115round_s;
static unsigned char *test_encode_953x2115round_s;
static void *storage_encode_953x2115round_x;
static unsigned char *test_encode_953x2115round_x;
static void *storage_encode_953x2115round_s2;
static unsigned char *test_encode_953x2115round_s2;
static void *storage_encode_953x2115round_x2;
static unsigned char *test_encode_953x2115round_x2;

#define precomputed_encode_953x2115round_NUM 4

static const unsigned char precomputed_encode_953x2115round_s[precomputed_encode_953x2115round_NUM][crypto_encode_STRBYTES] = {
  {82,233,1,95,247,84,69,20,120,128,214,129,28,148,50,169,221,166,109,4,196,54,93,197,112,252,67,132,171,117,175,235,24,212,161,171,197,41,117,106,171,25,179,245,7,122,241,242,208,232,47,204,120,49,220,139,124,218,89,135,31,213,153,86,189,193,65,148,118,210,194,255,89,150,81,250,245,53,251,255,213,91,204,179,100,0,63,133,164,182,101,186,173,232,154,199,83,125,31,132,167,79,196,17,189,153,24,206,41,50,1,196,120,104,162,182,71,24,28,151,152,152,125,165,136,250,6,175,151,255,98,35,167,118,42,6,196,189,227,25,9,234,120,166,209,201,27,103,225,192,254,209,158,89,195,121,110,53,20,198,230,56,107,70,178,233,172,157,137,123,101,144,99,178,64,221,119,218,255,223,234,236,54,235,101,202,217,64,232,229,151,10,105,83,81,7,93,253,38,101,139,44,29,24,116,120,95,2,1,23,173,255,42,55,189,117,56,220,229,93,217,21,11,104,237,184,215,37,116,185,74,104,112,198,137,193,14,157,15,220,71,74,138,98,3,103,144,51,133,165,79,5,70,6,109,250,205,1,213,184,76,44,22,29,144,64,140,16,176,78,147,212,193,160,167,213,139,243,223,205,28,125,31,186,60,41,47,27,221,128,152,52,131,102,118,152,74,91,189,53,67,82,25,206,7,211,166,184,39,49,205,153,196,44,18,178,23,39,254,180,237,207,40,196,232,241,227,169,111,76,232,229,126,22,88,144,247,196,74,120,189,129,19,75,211,221,246,154,26,54,176,231,166,254,211,116,18,238,235,55,128,227,134,16,225,112,12,187,177,40,3,168,57,42,32,36,24,251,166,95,18,180,128,26,24,126,241,68,213,199,237,130,211,247,101,195,181,222,114,53,134,126,215,169,255,17,118,109,55,65,107,151,143,138,233,168,89,110,38,93,3,73,209,209,133,152,211,226,144,169,248,253,91,171,171,105,75,69,192,119,34,135,207,116,85,192,145,126,126,2,223,171,15,26,72,109,161,148,186,113,154,133,227,109,105,16,8,154,87,251,0,221,150,56,207,43,24,239,252,7,73,51,19,165,188,31,207,181,16,217,205,36,58,205,200,226,52,126,173,248,179,148,185,8,175,228,122,172,222,9,228,120,254,220,68,247,111,149,65,124,1,133,98,140,206,120,247,225,211,185,34,152,188,251,182,248,155,152,63,76,171,125,220,220,127,229,224,53,202,240,150,22,156,232,185,4,47,165,28,147,149,78,132,139,96,230,99,75,60,224,177,140,201,167,73,243,223,138,46,216,162,202,175,55,223,250,45,188,172,199,28,90,241,159,103,54,70,186,129,149,110,180,145,78,255,112,205,2,121,94,235,81,132,163,47,213,196,203,79,175,250,255,134,103,119,61,154,15,91,134,118,12,251,207,4,45,159,124,88,151,170,236,41,123,150,113,228,137,151,95,215,246,106,122,176,146,160,93,135,194,116,113,198,219,25,106,253,210,224,186,225,204,120,132,186,110,75,73,164,84,20,89,225,119,167,4,29,113,244,138,89,69,235,120,44,35,219,203,241,183,148,184,124,73,250,201,92,142,128,0,29,255,246,76,40,16,95,178,26,208,200,233,156,118,213,87,43,132,25,28,165,202,72,221,191,8,56,31,76,214,89,8,130,222,26,144,254,53,18,182,77,197,223,120,178,104,70,39,156,164,183,14,193,152,125,107,134,45,215,18,98,149,122,111,224,238,109,36,125,0,117,206,212,146,171,145,127,93,111,235,142,217,189,192,149,92,168,171,47,149,220,104,184,53,134,241,227,143,151,98,143,203,140,255,122,60,137,114,44,218,62,188,146,45,20,108,172,83,143,44,47,57,28,137,92,42,80,167,6,142,106,248,79,238,247,183,245,108,64,70,186,1,83,2,159,178,70,109,103,117,61,34,34,66,140,195,213,61,183,171,118,198,8,31,2,212,161,225,91,18,71,182,188,137,178,198,157,55,118,38,38,173,20,252,160,180,252,184,169,30,166,239,19,0,167,59,46,239,147,65,14,16,57,178,196,159,221,215,152,7,75,101,232,152,77,142,95,37,190,86,102,84,253,28,164,249,140,24,108,113,176,107,35,22,255,200,13,49,160,160,42,40,255,79,51,71,215,58,174,31,111,89,37,72,83,98,159,147,146,175,213,126,129,105,192,73,153,81,111,214,171,16,228,99,61,71,93,12,148,149,198,54,47,211,46,210,114,250,210,16,31,190,182,8,97,109,89,202,214,37,251,205,66,102,10,250,35,105,5,66,55,242,235,122,159,222,135,217,37,224,127,21,106,207,70,163,176,31,19,224,71,108,74,2,128,173,254,224,128,46,117,241,53,144,130,108,71,168,24,1,166,73,220,172,232,104,243,94,254,129,5,147,52,148,251,83,134,130,85,96,231,110,207,222,170,24,114,10,108,241,131,81,201,17,159,217,182,205,226,249,106,95,69,254,130,30,138,155,152,199,157,132,132,8,180,152,154,198,251,4,98,145,27,219,227,41,6,199,90,1,222,145,234,46,177,84,74,207,146,193,45,148,247,213,83,184,52,76,253,23,197,177,162,82,116,134,67,34,35,32,233,40,131,130,35,121,47,70,85,59,150,49,58,136,244,179,242,187,138,86,134,237,138,0,208,79,201,219,197,140,248,141,52,195,244,180,143,192,117,61,31,118,213,89,75,40,86,19,47,201,128,4,191,68,235,245,12,160,70,197,34,162,106,134,239,29,43,198,45,41,172,221,0,200,90,211,223,125,199,159,179,34,179,44,121,87,75,117,119,238,149,143,204,34,247,19,239,222,96,12,48,35,209,142,21,29,54,5,127,130,24,69,67,19,11,236,62,85,183,194,252,213,90,66,55,3,100,99,141,246,107,48,12,87,16,117,77,243,128,145,100,36,92,175,246,9,176,166,99,233,13,123,85,22,235,57,32},
  {254,59,67,218,50,38,20,73,240,5,245,51,203,253,106,122,220,168,229,94,253,177,25,215,110,85,110,175,63,72,241,95,150,9,7,168,200,111,152,101,45,214,183,89,125,198,216,231,191,187,6,105,238,30,202,246,43,165,122,44,102,146,97,124,92,168,93,246,108,186,31,11,225,214,223,138,66,15,99,254,174,45,86,55,47,34,169,132,69,33,123,120,58,186,129,188,219,82,236,171,42,161,66,118,134,252,195,244,25,82,132,192,208,50,164,219,38,14,23,223,164,154,28,190,214,37,212,219,46,100,24,29,63,151,240,169,19,12,116,136,204,226,185,157,232,96,1,129,204,232,12,132,12,29,112,103,78,192,141,146,94,229,133,137,108,136,149,91,3,45,181,217,59,56,103,59,154,29,140,237,146,108,188,217,229,42,246,152,94,255,145,153,115,50,5,60,71,78,183,41,132,13,122,215,98,182,196,148,143,109,51,154,10,114,239,66,223,181,158,146,192,20,223,161,11,87,232,38,170,78,180,93,126,127,234,191,138,255,252,97,222,141,142,242,64,25,61,127,184,14,15,42,104,140,136,101,77,72,187,61,25,116,214,107,95,123,36,148,237,137,60,18,120,196,162,155,97,199,118,159,142,32,163,92,153,41,229,49,28,146,201,247,95,77,26,110,14,113,137,36,1,140,231,161,27,237,40,150,94,236,39,115,125,38,249,240,64,237,179,98,8,251,124,104,245,51,100,54,242,176,174,130,18,90,32,38,139,187,5,206,230,78,190,16,105,92,239,181,137,85,197,78,236,8,201,168,57,251,52,118,147,254,1,18,94,135,4,118,1,39,44,5,139,236,111,163,160,62,85,140,216,148,173,105,157,141,4,250,236,85,117,77,186,237,98,11,2,44,196,153,231,226,250,88,194,22,37,109,237,240,25,32,57,141,72,35,119,159,141,149,84,231,132,116,205,69,36,87,197,234,9,197,63,229,24,76,125,217,8,178,117,212,15,218,240,216,246,74,22,68,139,191,235,162,80,202,84,23,29,235,37,84,117,190,162,118,39,184,222,5,250,28,219,221,198,233,138,81,171,184,234,241,63,188,112,10,254,232,156,20,106,163,33,20,154,114,104,86,62,167,226,226,213,120,93,36,202,243,195,136,223,144,7,143,189,212,173,8,75,2,91,154,136,39,118,224,116,45,76,180,255,224,100,234,89,198,69,135,30,52,215,250,91,181,144,52,82,41,1,251,169,169,175,162,140,250,38,113,153,204,33,231,89,24,134,154,62,133,247,215,34,122,114,167,130,97,151,254,241,65,134,57,97,15,65,224,173,117,152,225,17,57,116,151,93,5,48,149,79,141,104,144,187,120,45,176,59,105,196,177,45,130,56,244,57,178,48,161,159,140,170,146,248,93,83,105,97,226,32,238,13,2,164,44,218,50,44,129,22,99,209,30,50,70,249,53,182,73,26,153,198,114,100,31,157,239,243,174,240,178,136,37,67,16,99,181,82,162,81,42,62,157,188,207,78,214,83,10,35,253,227,224,225,25,138,159,233,207,32,249,211,153,220,207,132,186,160,36,48,194,87,234,8,255,232,31,15,64,48,53,29,99,85,237,158,117,133,28,98,189,32,6,102,9,223,130,91,188,157,27,160,3,168,80,127,20,23,135,146,122,247,23,20,186,148,42,238,129,183,173,240,112,236,247,98,196,160,180,22,241,31,118,34,61,242,191,89,221,234,2,15,53,216,125,111,163,200,39,211,72,13,228,234,201,233,68,133,93,190,125,228,181,45,69,74,99,254,173,29,67,204,40,241,91,170,192,85,148,10,84,4,232,238,37,251,184,231,53,145,238,34,202,121,142,148,168,125,43,49,15,169,204,230,66,75,156,19,182,194,144,92,87,251,33,88,162,201,65,43,215,129,51,41,128,65,121,100,100,138,156,36,115,211,148,99,119,86,23,252,230,219,31,199,166,93,180,65,176,189,137,236,147,220,114,210,108,135,212,99,15,238,82,126,196,118,4,213,56,91,97,34,104,176,28,225,200,14,40,33,12,162,247,156,254,205,173,108,45,30,35,122,127,168,12,65,153,83,166,190,76,134,227,129,155,126,57,90,174,210,46,112,251,161,105,241,17,69,252,151,116,189,100,205,233,170,17,96,0,142,27,209,179,163,184,216,139,90,205,234,9,179,72,101,82,56,114,156,56,26,1,87,38,211,250,249,47,255,255,221,248,11,14,246,152,193,66,219,180,107,204,242,176,94,221,172,238,219,57,161,153,184,87,47,106,56,58,26,205,177,254,245,134,129,150,96,184,96,141,209,30,183,207,117,223,180,161,216,34,62,220,249,194,107,123,52,132,235,15,180,169,29,85,209,8,76,229,9,162,1,2,8,40,75,120,79,14,130,248,58,158,92,169,123,88,30,33,107,67,254,145,187,91,5,96,23,155,194,244,108,16,210,170,30,125,101,243,125,76,200,77,62,72,58,117,144,173,108,189,173,236,200,68,26,174,160,4,229,43,230,202,199,141,7,215,74,111,27,140,103,132,197,158,148,3,113,53,151,37,211,47,109,228,13,77,51,143,40,214,221,81,52,186,144,206,125,90,140,122,32,150,176,9,149,200,198,242,2,12,231,22,51,11,67,85,115,93,187,15,253,23,90,117,77,33,231,3,122,165,22,142,8,178,62,99,156,42,56,69,94,157,187,154,107,122,162,165,182,113,158,46,28,25,63,194,51,11,171,110,52,45,89,217,159,8,231,197,226,252,91,158,230,82,108,238,96,88,200,249,248,48,231,167,89,108,218,195,181,26,61,200,29,111,64,160,235,124,6,143,230,136,202,11,184,83,159,244,188,136,133,46,2,30,198,185,244,211,202,162,84,188,205,156,244,162,29,239,193,139,94,218,240,114,92,189,197,126,48,95,211,167,220,241,55,3,26,44,147,67,245,171,49,157,67,186,84,112,243},
  {62,32,143,20,252,110,50,253,180,229,175,154,8,193,143,195,13,102,145,198,236,153,176,187,177,228,4,233,166,189,208,94,227,73,9,128,178,136,35,53,191,187,246,53,23,199,206,165,1,62,94,106,79,122,140,70,197,28,49,129,23,197,187,128,169,45,163,204,229,110,238,252,233,59,241,177,114,83,148,164,8,149,165,253,135,152,178,214,204,126,150,59,148,146,164,49,165,94,187,176,11,200,26,188,36,41,137,103,57,105,103,0,205,111,208,99,239,92,147,163,194,48,200,108,134,177,225,90,100,29,172,46,134,184,94,42,28,147,248,216,65,138,221,121,10,42,225,195,238,197,175,191,91,48,194,191,161,245,255,56,57,215,156,161,241,11,156,209,251,34,51,248,175,158,156,233,53,190,160,33,24,246,126,97,165,223,43,240,181,172,43,209,52,154,202,34,242,40,79,213,146,37,68,187,243,179,32,230,63,131,205,255,171,30,82,180,104,243,255,79,42,132,139,90,65,153,232,218,48,91,128,207,13,11,220,82,8,241,31,195,242,241,4,86,158,18,23,5,127,94,126,215,151,121,115,207,243,111,90,102,123,95,3,183,204,103,254,164,76,189,16,5,250,209,68,173,114,157,51,16,208,97,214,206,199,179,58,56,144,185,163,78,219,197,117,112,178,1,194,58,127,98,251,136,152,98,240,43,203,185,247,228,194,110,51,179,193,186,185,94,243,40,100,51,31,240,199,214,157,102,66,83,198,129,54,177,164,192,167,149,109,227,239,54,181,35,94,118,162,191,53,192,147,214,151,194,24,81,102,176,114,136,147,197,72,249,107,11,62,221,101,198,229,132,113,194,242,158,187,168,155,162,137,90,105,130,41,227,14,135,4,3,97,135,184,61,239,86,91,168,149,23,143,225,233,12,159,114,83,9,198,238,153,225,83,99,249,248,243,230,253,202,37,171,73,143,170,52,217,115,123,156,220,101,75,245,131,128,170,72,138,71,78,59,37,208,182,88,82,182,15,149,163,187,242,112,18,228,137,230,14,198,155,247,175,130,158,106,141,81,204,9,131,94,251,245,226,182,182,208,212,56,87,103,54,207,85,5,89,127,3,251,201,156,224,243,219,194,225,196,49,113,239,177,201,193,176,90,188,164,1,45,135,165,139,9,150,37,158,135,238,178,74,200,240,53,90,228,189,8,193,116,62,144,102,226,144,171,161,244,235,232,152,110,75,251,229,49,206,77,240,100,2,24,4,30,144,75,10,71,164,223,20,124,230,193,26,218,72,51,153,64,35,8,195,204,176,126,15,78,194,193,79,152,207,223,106,27,230,142,9,206,20,232,59,253,154,27,211,14,237,130,253,230,88,218,205,97,242,33,204,55,77,197,178,12,237,42,82,144,54,80,92,77,161,221,31,53,151,55,164,218,96,30,5,135,156,17,46,213,164,193,101,131,52,123,62,159,69,185,65,245,231,80,112,212,105,207,217,214,233,242,137,4,165,37,121,177,179,2,170,255,32,154,254,100,123,207,222,27,132,56,12,186,2,131,5,217,115,52,252,127,104,230,224,9,21,29,221,119,170,107,171,106,113,224,125,0,154,71,222,129,77,212,234,210,94,204,101,143,154,80,166,129,139,100,191,222,79,14,239,239,100,149,249,31,105,218,176,170,107,37,212,183,167,206,22,74,22,226,16,149,69,237,200,83,163,85,135,32,116,222,236,136,53,39,78,238,46,89,180,172,64,78,90,207,187,192,157,20,134,59,55,59,14,120,144,205,112,30,78,123,84,226,88,26,220,107,235,203,59,187,72,225,128,64,48,85,226,233,192,99,140,153,203,187,193,52,94,134,216,244,184,31,79,27,161,224,201,107,239,20,22,40,99,193,251,64,185,161,5,222,132,28,128,137,52,60,245,210,105,48,57,78,130,38,117,70,139,40,78,224,129,96,76,113,133,169,100,61,96,204,83,118,190,54,13,27,12,48,18,189,188,217,75,63,233,226,18,165,16,65,165,99,96,188,112,231,104,243,179,184,254,221,164,250,205,114,203,185,108,31,207,248,75,228,230,144,37,169,169,168,209,11,195,255,92,114,161,157,14,120,248,175,199,58,161,69,128,186,64,134,13,86,217,179,164,153,249,140,120,185,44,75,74,203,40,169,57,156,26,192,159,76,22,202,230,95,155,162,129,17,7,15,78,170,142,78,111,133,244,110,197,192,255,34,30,23,72,230,10,234,117,225,206,146,148,5,133,172,210,117,184,226,183,109,137,56,254,53,155,254,30,148,28,163,72,63,55,6,137,19,187,255,112,173,83,82,112,59,211,124,131,34,223,20,146,101,175,25,27,54,135,203,144,161,142,63,26,215,249,122,105,150,214,31,165,224,156,46,63,31,19,65,233,134,232,180,91,132,188,210,124,90,120,163,66,130,169,249,175,64,234,216,118,53,139,115,64,149,146,238,33,195,162,83,221,223,27,68,111,26,164,182,193,85,71,48,77,99,117,14,116,118,130,134,47,198,253,146,230,235,83,161,160,183,118,183,162,177,107,243,79,20,214,149,53,128,41,58,116,79,54,197,120,205,164,14,74,6,43,141,30,112,193,2,120,113,180,240,81,36,178,63,65,219,237,253,95,162,167,240,197,186,203,120,98,197,102,82,82,2,91,126,216,37,54,11,183,129,138,235,31,120,47,205,228,221,200,221,74,37,234,209,82,151,128,220,32,43,65,239,31,170,105,164,1,136,176,240,34,208,1,239,150,105,43,11,154,241,161,100,151,236,33,122,62,81,125,59,175,2,180,183,74,244,242,241,242,212,233,10,171,62,210,4,213,238,98,227,42,92,207,156,6,220,238,21,243,4,62,136,124,37,134,57,200,184,125,215,73,185,189,24,244,110,125,229,236,142,1,179,247,216,104,206,69,208,236,66,149,198,149,208,87,97,160,208,87,41,226,5,130,220,192,82,0},
  {150,66,199,170,181,61,15,55,113,132,136,0,246,119,126,171,7,220,131,9,179,97,55,175,33,36,199,134,16,244,36,184,235,154,169,30,2,17,47,253,63,112,41,50,155,159,44,126,89,105,48,37,114,248,51,117,124,27,124,163,80,226,132,180,111,212,32,95,87,147,109,100,218,129,93,179,209,228,210,81,122,54,126,221,77,66,134,236,201,234,82,52,115,116,22,3,230,74,79,123,96,32,76,188,37,91,46,209,142,189,178,118,240,122,178,86,59,135,235,209,222,16,162,236,48,204,238,77,129,54,220,81,46,223,3,171,215,43,143,29,124,195,58,41,247,97,231,196,167,52,49,71,100,23,186,164,104,115,184,6,116,225,210,223,59,168,229,134,224,179,20,131,76,67,35,59,243,166,92,26,193,155,253,0,115,193,214,133,24,219,62,5,94,251,44,207,97,162,138,199,50,191,26,225,214,137,62,248,192,105,187,82,108,168,90,141,225,223,46,152,223,208,249,87,46,155,58,80,127,56,15,48,73,35,74,11,73,108,11,174,112,175,127,57,33,116,186,42,136,87,70,195,136,254,221,84,214,109,80,92,200,195,47,102,230,160,114,245,119,98,109,157,217,170,244,157,83,14,47,139,251,160,33,25,147,4,4,35,29,67,154,92,132,104,145,211,182,133,60,80,139,230,65,91,167,13,60,74,132,179,68,208,131,199,133,216,248,47,112,113,1,8,10,124,200,130,40,108,158,152,222,191,204,200,218,248,199,170,14,104,228,94,94,67,204,248,240,141,140,155,132,47,1,3,56,52,134,72,238,250,65,113,27,243,81,151,127,235,230,201,109,198,80,94,84,34,39,126,38,218,58,37,209,125,95,138,128,212,175,246,10,183,107,144,73,242,213,45,65,172,73,158,141,112,137,246,7,171,148,86,11,165,20,94,121,213,118,7,205,65,76,193,168,108,55,134,156,203,114,206,88,79,14,125,21,103,138,123,95,185,57,73,130,131,187,18,78,143,76,8,183,154,207,143,111,252,95,99,59,20,204,148,172,194,49,132,129,14,211,172,160,106,8,193,101,20,236,102,115,61,125,0,6,130,62,178,55,195,240,85,210,69,76,73,215,171,189,52,242,203,202,213,145,225,209,19,182,21,128,227,74,12,193,11,101,151,123,74,214,14,219,136,114,112,207,142,60,171,17,93,131,245,9,102,182,253,179,213,170,5,31,140,157,175,91,156,38,83,136,60,20,242,198,228,48,44,35,72,77,75,201,236,205,4,127,82,171,136,214,165,156,7,223,125,158,157,21,244,153,36,208,213,32,55,170,106,229,96,112,158,219,145,219,188,175,248,109,74,4,129,42,155,117,82,212,99,230,101,18,58,110,124,200,138,230,128,76,207,59,240,21,121,178,212,152,249,161,219,179,18,37,31,20,207,225,106,228,152,83,198,228,246,175,100,17,56,227,195,64,220,14,46,22,158,190,121,247,173,124,178,214,154,113,174,149,178,157,227,135,194,132,101,10,224,80,26,159,209,196,34,195,145,7,152,131,195,65,86,98,176,49,53,27,153,81,112,4,117,134,70,54,164,135,0,99,179,244,219,32,122,164,129,92,149,18,25,11,172,245,18,11,95,100,184,62,11,179,63,101,57,124,92,204,135,101,226,184,82,224,69,158,137,22,122,47,10,185,249,128,83,218,52,197,215,220,11,39,10,209,159,227,191,215,233,126,25,197,246,51,70,70,156,40,59,78,25,32,58,92,248,17,178,154,1,242,45,95,100,190,141,48,178,169,159,38,131,99,182,255,22,96,110,52,78,189,97,255,36,197,166,20,57,215,109,236,174,130,30,214,190,227,77,251,145,191,77,123,147,33,133,204,114,246,157,7,180,37,242,249,8,161,242,91,77,102,133,99,232,184,23,79,101,19,203,18,55,80,188,107,95,192,221,36,217,93,217,114,5,209,31,57,22,86,211,84,231,77,202,164,170,95,137,207,20,89,176,176,23,13,93,255,181,141,45,148,127,59,96,240,236,22,31,208,48,5,229,146,71,81,38,78,22,212,164,37,182,47,106,23,185,46,120,138,222,129,78,156,113,73,9,117,239,104,221,76,240,95,31,39,131,191,28,203,103,127,165,10,197,210,97,249,201,48,5,35,122,84,7,124,129,144,240,94,128,83,212,3,189,136,239,27,242,111,120,89,18,88,29,213,240,37,229,50,220,29,79,207,220,248,20,62,12,65,36,146,254,5,130,120,46,67,192,26,129,51,228,151,144,93,83,141,106,123,107,165,123,92,3,147,205,254,121,201,153,116,79,14,186,228,19,19,204,120,233,166,211,120,17,86,154,47,119,160,188,210,238,33,98,255,64,190,241,183,115,145,164,214,144,6,5,2,45,222,38,233,213,4,217,107,109,132,108,214,126,76,49,155,193,148,192,194,150,237,164,145,184,253,2,15,159,5,76,136,252,193,170,6,180,51,36,143,77,128,91,72,97,157,132,30,194,163,221,188,243,170,185,5,209,251,46,75,10,56,152,188,76,211,171,38,87,18,189,244,20,100,168,142,108,241,47,104,49,238,176,135,61,187,3,106,149,29,30,242,198,184,25,197,9,93,15,225,228,123,205,141,71,116,149,201,72,102,28,230,250,217,7,72,100,202,212,250,156,193,34,111,117,60,99,149,236,15,234,43,214,248,64,16,174,42,174,31,184,168,14,40,72,172,171,106,57,190,6,103,81,168,29,167,182,20,3,179,111,130,146,96,28,251,149,181,157,15,72,251,89,204,119,13,230,89,45,190,41,127,65,68,207,116,236,160,68,75,147,59,100,183,12,209,133,194,58,196,147,19,135,140,248,200,126,17,207,179,50,11,193,96,165,25,8,92,13,205,115,208,45,19,106,84,244,147,196,51,177,147,70,25,120,124,140,28,144,180,53,245,76,187,225,51,70,140,176,188,0,38,147,201,38,63},
} ;

static const int16_t precomputed_encode_953x2115round_x[precomputed_encode_953x2115round_NUM][crypto_encode_ITEMS] = {
  {-18730,-5154,-24168,-31537,26919,-11908,-2381,31835,18345,25065,-11975,405,23696,21909,-30383,-25000,-20870,18844,30292,22882,-10703,21596,-2061,-24245,-5268,28915,27602,-24090,-13322,15021,-7694,-15012,-24470,9542,15511,22850,4827,2232,-30492,-2949,-22231,-6350,-2399,-8495,19574,2076,-12301,-4130,12045,-30560,-4170,-3962,-21851,-14337,18150,-2099,23771,18588,-19608,18741,8475,-22571,14347,28862,-19313,22859,25720,-12905,-29191,-310,22672,-16305,-22425,-2659,8455,75,10354,13110,-2062,-13978,-27995,-13668,-25795,-1995,-9701,-25808,22882,-25015,7152,16530,25371,-24718,-17224,-23676,15608,-23779,30834,10259,14116,-30126,17617,26441,-22914,11051,-32691,-12064,-25069,14866,-120,-25135,10890,-25646,-26722,21335,-4987,25544,14205,25306,-24711,-15972,18190,17915,-18667,-13453,10706,14230,6603,-15125,16367,-26083,11742,3155,14627,-5009,-25044,26969,-6282,-29925,3579,-28680,-30736,7137,-2576,-28717,12316,-12795,-24905,-7716,-13460,-3311,-26694,26578,28746,13122,-8537,10441,-4690,20850,-30970,4985,-25616,31380,11175,-4197,-17915,3884,8663,14754,-18032,1706,20414,31970,-3161,24061,32024,-397,-24523,-15110,6050,-8229,32310,12158,12408,20171,3026,16818,32463,32315,14726,17293,15085,-29241,15905,-14970,20481,-14536,31567,-662,15094,-22699,30596,21597,17476,-1491,-8144,18550,-21083,-29527,7014,-11556,1956,11421,-31384,-13030,9365,5512,32439,-20892,-32674,25797,-24463,-13882,27661,-10598,-11820,30775,-28260,32116,24559,-8245,-27898,-720,-21915,18764,-2211,-1241,16926,-235,19411,8155,11281,-14699,-14722,-28000,20693,-3996,-22935,30910,-355,7670,-19616,10861,-1491,6963,31213,10863,-5493,10396,-25235,-31227,-2803,28846,-21516,21676,22367,-3453,21832,17585,-5102,14911,-8408,3501,14119,31794,-849,-25728,-28648,-26833,19993,2664,26553,-19236,-28501,-690,-32008,-3458,-28021,-5697,-10200,-18673,23267,-30623,18837,-25584,-19681,9706,18301,-11064,30536,15651,-9143,-10604,-13563,-22292,-4215,11307,-15781,-7589,-14059,4188,22940,20608,26292,6042,-19572,26658,14725,-32575,-20193,22941,-5461,19697,1020,13842,29885,28454,-32630,-12429,-10233,-7445,-25997,5459,-26139,30809,18461,-31517,29886,-30473,13286,590,15499,-26781,13500,-28845,12381,-9999,10049,24605,-26460,-2783,22519,-25166,-14508,29874,16622,-31805,-19080,-24045,-20472,-3738,11875,4807,-7909,-18437,-9450,27286,-15666,-2919,20037,18988,-28862,28330,569,-32389,-26543,-23100,-10992,-21998,-27930,31765,-27760,329,3359,-1955,14184,-2383,-2203,-18227,-30315,31713,20493,-7983,-5935,19060,6079,21367,31746,-8506,10582,-1112,24412,-25392,12094,-28073,-22294,-12583,-22366,4391,-16152,-10329,2812,-26494,-16661,-983,-31206,-31136,-1090,20225,-8695,-8928,23033,-20390,8721,-9164,-6991,-25848,-12597,29281,-16230,13274,18075,-22459,-13821,9344,-21103,-16455,11268,27548,12221,13717,2390,-32636,25036,5512,22896,18392,7018,8490,-32642,-7469,10261,24705,-4505,-23849,-21729,10341,9097,27205,32274,-26785,9643,-11702,-29869,12763,-14440,27997,-21521,12959,11750,-21815,11313,-25917,19989,-14239,-2557,-1761,-28586,-14173,-4131,23622,23568,748,22300,-32163,32411,-16847,28802,23778,25457,-10372,-12949,-3183,-1753,-15296,-10541,10664,-3000,-4264,-29232,10766,28492,-25107,-2824,-29148,-15333,3790,16943,22013,-13368,-18066,29134,-2297,-19973,31250,15978,264,21233,-7140,-28568,-6778,-20977,-24090,26196,3287,-30000,-24461,-26936,-29537,-5749,-26950,27134,21536,22616,10395,87,24085,-32436,-6486,27697,-29500,6676,8117,-17176,29283,-3590,-4141,-27683,-27648,20822,19711,-14822,10315,18630,-17425,20564,13187,7996,-27515,20585,-31516,15155,14636,-3597,-3430,16559,6113,21383,-7073,-19090,30144,4740,-23804,-2083,-2182,5571,-12218,15563,16238,-30885,-584,4601,-17438,22508,21874,25084,23431,-1375,-32523,26352,-21647,9091,26627,15401,3764,-26494,-12101,-25519,-13357,6206,-8535,7803,-2368,-17016,30367,-17961,-26229,18223,-25434,-28055,-11435,26493,-30335,-15399,14203,-862,-26100,-18130,6662,11862,19035,20747,-23668,21695,-4646,27986,11160,-1977,-8023,18615,-336,25382,23997,-1204,-13623,23532,2418,12391,-8455,-10938,10173,-10168,11597,31171,24507,9743,18082,16198,-11231,5824,27838,-44,-10076,5220,23386,4051,-31704,-20968,19840,21878,11677,29581,-21307,21455,-27030,-31033,4116,-18240,12709,-16158,-21739,19144,19143,-8040,-18024,29622,6351,-3173,28757,1937,23002,26596,-8187,-27143,-11893,-9039,-6635,-7617,25520,-8542,4217,-28491,-11260,-25730,13440,31223,20012,28272,31709,10147,4792,19196,6375,29138,-26528,-27026,27135,-29080,30669,-29734,-12214,-9899,-26646,2130,16493,8975,13495,12207,-21191,-13148,-11486,18746,-16590,-24210,7091,16001,-1840,18668,4591,-22883,-26823,3220,433,-16935,-10180,-7194,20742,-1187,-1,-8658,28346,14487,-7280,-31425,-4415,-18586,28790,212,26804,-20843,-8246,-19528,2851,28071,5605,21900,-20284,-8861,30071,-14479,20894,21117,-9141,-18548,-3697,-16882,863,25487,-15638,-31205,-32307,3515,-19316,18600,-31528,6354,-9897,4291,31186,29319,16738,-14151,-11766,-26259,-17830,-26640,-21199,-6425,5316,-1771,-4039,-11190,-12601,-12868,5541,12996,17701,-18020,7303,-3635,-32171,-22596,-15525,-3865,-5784,-11649,26776,-24955,1524,3173,26354,-2859,17286,-6695,-13333,506,-30897,3084,-13565,-18799,5645,30481,8053,27001,-836,-22738,-22332,13846,-28934,-30574,-32203,23922,-27553,2337,-24175,1451,-26442,1458,-25558,3941,4128,-22827,26871,5659,23149,-14043,22761,-6640,27842,-27007,-18880,10323,13768,-19433,28553,-3068,7769,25166,31956,7629,-25672,-1392,2697,-27747,-24297,25359,-23971,-5806,12556,-10848,22846,5743,-15302,-7642,25955,7800,-29544,12352,-13623,13003,-24595,9563,-12336,-18691,7290,-10635,1266,29489,11528,-3930,21307,-15563,31888,-18139,-27106,9166,19501,18811,-9265,22070,-17407,-26854,-31949,4524,-7380,32380,-30616,-26257,16179,-15877,-26710,7319,-4030,-1889,32171,-28589,28050,27408,2944,-24020,-2895,12385,18728,-14777,8781,13495,28046,10137,6504,-22340,32039,14137,-5487,-18598,12827,32263,25480,-8538,11984,-26024,-21213,1913,14833,3826,-8858,-15995,-30659,-3268,-17034,-7017,-16341,-8090,-2789,31217},
  {-22114,-28576,-26855,-29167,-7180,24563,-25110,-5032,16204,21673,-2736,21507,30505,17210,-14905,-21763,-29423,22846,-18819,-626,24301,25452,-3953,7590,-13061,12568,-24457,32538,28542,31846,-5239,15660,31558,25767,20834,14202,3746,-26138,-6470,-4371,5290,-25080,12012,16399,17102,22859,1123,-19680,22318,-20347,31848,6068,1461,13318,-16547,-16769,5111,-24446,9945,5763,-28594,-8906,17036,16326,3312,-695,-25525,4909,-1603,-20160,759,1759,-25016,-1146,-27945,7379,28654,-3196,-1289,-25713,13261,23549,9509,-14800,13816,27077,-26455,-25295,-2404,9762,-27991,-20094,27670,-4155,-9943,-17445,29607,-19337,-29072,24986,25469,17172,-18349,-11889,-28358,-10170,16483,20830,11636,943,29206,18576,-4871,-30255,-17580,15154,-4618,-3566,-17539,-31207,19763,17916,-15663,32360,-5188,-1025,4590,6295,-27327,8854,-28370,-17315,-11354,-12624,24122,2650,-27277,-28498,-9510,26366,-30300,23892,28381,8407,-10408,15198,-17661,-26966,3593,11227,31135,1896,-334,30070,26767,-537,21657,19694,24157,29738,3055,-14176,28072,-20276,30580,6081,-7891,31299,9742,-3183,15257,27049,-23089,2143,-18615,-12469,15523,31094,-8185,-22563,-30012,-4550,-21095,-22199,-25595,-15732,-6041,-26498,6847,-20045,-1792,-16989,15009,-23556,-11280,-6243,-16640,-5862,-29377,-5876,11466,31827,31927,8527,-8396,12601,-32682,16612,-29942,22174,11211,15960,23700,-18494,-6914,30359,-19865,-25838,-4054,-20272,14722,31463,2846,-31512,23121,26626,-3327,4643,13990,29509,28410,26440,-2446,28971,3405,21368,16681,32292,29355,-26985,-22779,27481,-26544,-6736,-12424,-13228,-29838,23019,15824,-17038,-18381,-6618,-24150,30572,-7463,-537,11750,-3267,-14310,-24761,5235,-7802,-20134,17056,24074,28312,25200,-12441,21699,22462,-17382,-6907,4466,-8795,6664,-1166,-26145,895,-13907,32440,-18371,18337,18907,15383,18638,11622,-23613,-12104,4209,-9187,-17093,7794,10866,-4937,-12440,31028,17382,-2947,4885,27819,-16681,-16157,-31111,2555,-26199,-18357,29351,24324,2259,2026,8597,-28556,-14343,25682,26879,13388,15401,-19768,1181,-17754,15570,13398,24702,2532,-13732,-10242,25864,17226,16114,-22579,-1296,23580,24489,27651,14847,6044,21474,6376,23848,-17716,24086,18909,-27776,18236,23071,24306,7205,-19701,25623,15936,-30644,24766,16586,-15833,-32257,-13731,12451,19711,-15957,-14492,14290,17675,23817,23441,30374,28600,-24577,6998,-28851,-25048,19268,17768,22432,30888,-11815,-32070,28971,20666,4638,-23990,11354,-14580,-31439,-18959,-14497,22374,18952,-10264,26167,-3539,26794,-4381,6337,12341,-25380,8447,-15572,17969,30085,-32254,14322,-3947,5181,-26054,-10162,31461,-32001,7650,-23275,-21166,1563,11339,-23093,4124,-28838,-11736,14074,-4808,-1400,-30304,4466,-23678,9826,-19146,-3588,3167,-26553,30088,-4482,13572,-13742,10005,-19164,-24418,-29305,21141,24043,7872,2737,-24905,-18671,23980,99,-23123,-5672,27324,7547,15840,-9598,-14978,-23468,31149,-13957,-23423,-2162,15519,17472,11431,11551,21007,-23826,-20480,13714,26669,8233,-15706,12397,-13823,30705,-25523,-29771,7249,16274,-26560,20829,-2440,-29555,2711,27618,-2552,-22075,4348,23671,-18559,-3720,2031,-23794,31627,-27496,30717,-31522,11016,-12883,-26543,-12558,8860,23595,-30331,-28055,-29092,-1644,11971,10089,7278,-29056,28935,10481,-672,-20168,13723,5352,-1820,-13409,5988,13790,-24611,11223,-30641,-5713,13860,27455,-146,-27829,278,24184,6667,-15427,9394,16512,-3874,1258,-25445,-8694,-8225,20641,9354,-23756,-9658,-23565,-19935,-14836,-8496,13108,-19702,8077,-15543,17816,-20491,-20055,9647,-26284,-12618,20893,-25842,10446,-4688,31830,-10405,-21533,-25735,-19110,9835,8220,-28125,10156,968,24795,-10679,6315,8058,10132,-8081,13508,28333,-8467,-19152,-17082,-9796,23954,5587,23921,5491,-17661,23816,2080,22216,-29102,27942,13417,-1231,-28531,-14518,7096,-7884,-17272,-20410,21049,-13925,10863,-23063,-12008,28788,5146,5700,-18799,31054,28753,15199,-20848,27773,28087,22830,22417,14042,-16892,-4895,31256,12133,-4302,-15328,-19605,14469,-16495,9691,6618,14643,-17190,3881,-6349,8715,-16425,-7656,21241,-11827,7105,-9130,-21229,28965,-13438,10621,-11883,-32397,-4763,-28016,31227,-4105,21228,24484,-27015,-5095,-16588,-250,24881,26513,21832,1282,-25437,-32345,-27512,-3690,-4910,-4395,23604,-3750,23265,22572,-11974,16339,549,7253,31885,-31326,12430,-31220,-25991,12984,20957,10587,-30322,-7567,-2214,-28604,-12295,26699,26645,11753,29685,4714,2666,-11101,12483,21070,19346,21375,12470,4418,1915,-24864,24313,-23971,-6726,-17149,20985,-15095,8381,13501,-2303,-15348,-8703,24941,17363,-17195,-13824,-23488,20619,4119,-11211,14151,-19265,-13537,22946,-20973,-6699,11143,2238,10353,28269,6557,-25342,24560,6902,-23390,1053,-12089,20871,15079,-19070,5522,-32638,-26969,5750,-9417,31518,-27595,-12844,13878,-5129,-9660,-4005,-15593,16237,11741,-15691,13185,-29141,1637,-6006,24987,11787,-23492,-15933,-14586,-21320,-2505,10389,13930,-13577,-30096,18492,360,-24220,-15637,6554,1611,18952,-13547,12951,-1306,30241,1689,22680,27608,24078,24994,-2933,-20295,6582,8943,-17387,-6775,-14674,14951,10319,31289,-25830,-258,29586,-16244,-23508,-18420,-27733,7995,14373,3277,19241,-16977,-29371,9895,-8389,-9955,-13477,-5063,22962,-19172,-4221,-12894,31695,11721,-2222,-14541,-21518,-20997,21977,-30032,14206,-20630,-13895,-3459,11448,-32312,-29134,8426,-28377,26156,18508,-12155,16577,23505,6215,-28823,-29604,-32003,2138,-20494,10679,-25938,-12844,2986,-27751,-14367,14520,-28945,-3704,3748,3547,24224,-24038,-20475,6743,6270,-3195,-19913,12907,128,30976,31219,-1859,7807,-18699,-23489,-10396,-9971,-28419,26844,-22322,-31229,5716,26381,-30988,-23061,16767,29163,11156,-31532,2344,-27067,-21261,32456,-23347,25949,-22844,10240,4397,-8704,7551,-30176,-7725,20109,-1503,-15986,12223,-1931,-10733,-2608,-29864,-10280,-1790,1119,-9723,3058,-31504,-10822,-685,6589,30956,2469,-3977,10688,-25572,-31746,-24613,-24739,15628,21026,-20367,30297,-3336,-31980,-28808,-28011,-11004,-1791,5079,-25566,2292,27454,-13857,14669,28303,5577,-9329,18877,28525,-3440,27939,-7004,-4514,14416,-5904,26543,-23063,14362,-23345},
  {-26126,-17128,-14378,-8208,-26149,-29857,26964,16553,23439,30978,3238,1717,-17415,13469,-29955,-7774,19009,32605,-20602,-8521,22692,-2191,-7879,-13541,1665,19524,21805,19058,20654,-7404,4443,28676,-3233,-26620,328,-13095,-15929,-22502,14476,14813,-7405,-23603,31056,-1106,24436,-17255,5775,-8250,-21085,-18422,-26830,23008,-12549,24783,1982,1779,-22975,6593,-24161,2170,-14212,-3009,31633,-1360,-5615,-26910,-5028,-32614,9591,-16731,20587,32752,-4492,2793,-26705,-12150,24800,31482,28092,17171,-8887,-10301,-22979,8163,8617,-25009,131,16450,27054,11556,30933,26806,20699,-32075,5392,24476,-10236,3553,-18386,-20905,27861,-13353,12041,-16983,-347,-15916,-17484,31028,10530,7550,24113,-20139,-9838,3650,-23350,-21683,2913,12383,-25477,30674,-26406,29495,-8937,211,31807,27778,-25857,-16736,-26402,-2794,513,-2691,-23303,-10383,-19355,4282,31667,16521,5874,18959,-28239,408,21964,6165,-1223,-30624,-9580,14210,23372,-17068,-18802,-12140,-18404,-14982,17234,23972,-1664,-32500,-15068,30916,3408,-19385,7679,-6950,9809,-3289,-27410,-2912,9171,21958,-7814,-1786,31949,2556,29951,5186,15877,988,27119,9571,-19817,-1415,-28427,-31720,-7378,14313,-17817,25478,-16003,12787,-2465,-27681,-11774,16241,2599,15269,19797,19454,14497,1089,28323,-21243,14830,22855,21291,-25648,25402,-22751,12698,-10125,-30701,-2152,4995,-16665,23670,-1902,-17926,-18071,-9665,20862,23785,29060,-28898,2622,-20279,-2565,30921,-17522,-2598,-6321,-22169,-13072,13705,-17783,11787,17792,-30658,15625,32645,14214,22836,25289,4212,-27450,-6566,21394,-10436,21207,15814,-28931,23734,16169,22370,15115,1771,-3678,-11545,-17564,-5791,-1652,-11246,5319,-27075,-7592,28947,10989,27446,24981,-948,708,17183,19908,-19525,-306,-28563,-23606,2568,-21288,-10768,17120,-20624,6525,-6383,3405,-21728,16806,-20320,-20028,11223,-18190,5840,11077,-31317,-27594,-32401,-19143,-21255,-13518,-7550,21504,-5364,1507,25495,1242,-31937,28865,2489,-26255,20832,-17537,9960,-31489,30690,-27531,27151,-32532,-27239,-11124,22064,-21868,-26920,23636,-31587,-32294,1048,-19582,-26406,-25729,23698,-14316,-2511,-12924,-17237,-802,-18005,-18095,20341,28155,8410,5617,16030,11040,-27211,-17678,-13342,31931,3857,-1645,28697,8789,5804,2659,22159,-15669,-6660,427,-3516,31570,-25455,-31136,10254,-19625,-26238,-3313,-14372,-17047,-9926,9471,463,-11295,9594,10467,-29147,-22227,1088,-13629,20372,-28353,-12797,-19888,22660,-27793,-12789,9687,-3630,-27251,-7033,-9159,-7968,16791,27954,20272,-21144,30011,-24611,-31270,28858,27182,24120,24517,4158,17960,-31418,-31860,5345,21488,1850,30193,-24082,-17789,-9155,-20516,-29574,-20241,-2346,-23073,-6872,14229,1045,-20330,24032,9539,-14853,-22491,26515,-1452,26094,-3644,-27369,-14960,-10815,-25286,15727,26358,-27734,-389,32504,4311,28507,22623,10482,287,-14606,-10054,18688,12706,-24574,26441,-23602,-28253,3434,20050,-14528,-22857,21902,15296,24874,-14271,4211,-14454,-26987,-32056,-28046,1843,-10369,32149,26340,-30233,-17419,482,-26859,25113,32556,-12921,-8300,-3088,29104,7949,-2724,-18176,15310,16952,-17982,15017,-11570,18864,-32196,20372,10406,-1271,14238,-20787,9368,3667,-17393,30892,-31707,19512,13344,-7211,15742,5700,-29931,-25090,-11809,12048,20885,-14320,24290,-4627,3482,6323,-13692,-21564,-21745,3053,11439,31278,-722,-5749,16777,-18840,22140,2568,3825,-9869,15709,-1415,-16676,24092,-19250,-21764,6690,-13371,-22955,-10275,290,21548,-25901,3885,-25243,16732,927,-14496,596,18880,5587,8090,12851,-23087,-31698,23754,9265,3246,24874,2225,-19722,7631,-18800,109,-31071,5739,15414,-31336,-18226,31432,19830,-17060,4303,26987,-6721,-23742,10375,-13793,25654,25645,-9527,-30783,14842,-18223,20069,-19788,-2409,15408,-15162,-16777,24003,24188,-11590,-2843,-7261,-12698,24306,32000,6249,-4779,13376,15362,-3650,15166,-10275,6262,-28727,18873,-3368,2849,18002,-12177,-20916,-24124,-30465,19273,24802,30034,-16501,20375,4403,-5970,5365,30483,-16021,-11719,26634,-4286,-2716,-30744,-17000,-2966,18348,26245,-5925,-10558,6410,27908,26762,11838,18734,5386,-16905,-19686,-31507,18301,31678,-31984,31384,-31617,30819,-2555,28253,-19121,6307,-18167,3324,-23919,-19676,14308,-30852,28904,-12399,19239,-22101,28354,-26728,-21717,-17253,-4667,4831,-11220,-23877,-9892,-24125,-5336,3242,17637,7628,-9204,9449,20905,-816,26796,-1410,-25320,10204,32447,12347,32425,-24415,-30,11208,-18984,-10882,-11888,-32312,-3761,7794,-25990,11515,-1773,30808,12582,-1758,-30414,23071,-26698,19212,-20798,19065,-2244,2359,2243,30412,-8723,-11397,-16691,-28596,-3400,-12973,-31123,-1345,13732,-23502,9030,-17599,6263,-19912,-15155,-27319,995,-16227,-4584,-13206,29960,-17732,18660,-17085,23263,4196,-10834,-10072,-11594,-4029,-2608,-5628,-28719,29374,16441,-10384,23554,18136,-31859,8820,-4911,18033,-12964,-16844,24864,13261,-3535,-6145,-7184,25688,3412,32276,-18482,-16486,28565,-23723,26309,15124,-32557,5337,7485,22887,-6329,7090,-9445,30019,-10931,26341,-26266,3428,14349,-30108,12094,-18268,15490,-18138,-15018,23895,-29143,20817,1796,-2504,-3949,16575,-8297,-24120,-27815,23192,14027,24103,-13078,-16821,-7018,-3582,28754,-6549,5407,-5859,-2071,-12232,-6506,32082,11757,-717,6006,31079,-11727,-17544,10078,-9789,4350,15235,16756,10762,-18807,21444,26119,18462,-1647,-30553,-31283,19740,25589,-6110,22017,29861,25600,20068,7016,32614,-16777,20329,5852,20855,32618,-1188,10235,4824,-1238,24043,-21329,29784,-169,30741,-25883,1213,-7073,5885,-32671,27973,25653,-853,31769,-5127,-9758,-3841,-12435,-16566,3356,-28659,7684,-20694,9880,-29011,471,25296,-17039,7728,-5320,7913,-11776,10022,5546,-3719,4747,19378,255,-7612,-21659,-6712,-6986,21586,-24099,-31549,-18742,-6700,-12783,5582,-18911,-9483,25268,-4042,32551,-15069,-15189,2672,10253,32174,13838,-23196,2225,-22696,27055,-13544,-31209,-4316,30573,27342,14942,4239,14946,-10579,26878,32279,-15836,30931,7933,-29883,-5092,-9930,20132,23272,-24257,-22960,-12288,-12856,-19831,-11307,15139,19049,22278,-5110,27741,-22631,1444,-21206,-10861,30769,26000,-7145,-32528,-19485},
  {24885,-27645,-20736,-27235,-17280,4381,12417,-4575,20872,9236,23181,171,-19390,-25760,20797,-32065,-21844,-16691,-2223,-22361,-16583,22450,5614,-7131,-20014,-30073,7768,17255,10418,-3205,28946,18758,-32306,4878,124,30909,22274,17491,-29499,17578,11498,31491,6143,-31833,3532,-20542,-8357,16693,16403,12111,21346,14713,9012,-28044,-21121,-23352,-27088,-13226,-9258,-11599,-22674,5736,-19294,-30385,6815,11404,-27635,-18128,14678,-31794,15587,-30603,20542,685,5760,5721,16234,21568,32719,-353,26620,6881,-21154,-16227,-13658,-2499,-15569,-12685,-864,-19097,-18231,20855,3423,-28740,-24100,-9332,-30229,11541,-1568,8215,30027,25774,-26314,5538,-31040,15013,-27839,27137,19203,-3105,-419,26363,2402,26828,-8255,-14694,-20479,-29572,32358,19888,14170,-29887,-19966,-21450,13748,-31587,26213,-16927,19868,-15820,10931,17886,22419,7504,-9126,20430,28618,-6809,-16067,3810,22353,28341,-7015,13318,-12383,8575,27362,17369,-27659,-19074,-7560,-30989,17170,-20964,-14128,-28535,-7334,10715,-10061,28921,-4694,-6280,-25626,16450,2251,23498,-29350,28785,22271,29170,-22545,8768,-24061,15093,17250,-25599,-7896,32161,-12702,20749,-14672,20612,15621,18232,26972,14952,10686,10537,32623,-12411,-6845,-24877,-26469,10024,15257,2017,2534,8785,1442,32549,-5974,10464,-6780,31254,-17751,13147,-6053,-6457,-25647,30840,9513,-12652,14445,-1810,-18525,10081,-15020,-490,21427,11288,-28238,30134,17067,13525,-26718,-10484,-23695,18537,-5552,7905,-2779,25131,-31875,-15266,-19414,12729,-31354,22640,-12621,19875,-5908,-5366,13647,2893,15133,-30783,17683,-25977,-22951,16959,-22169,-16330,-4604,32750,19880,-20850,14910,-2946,-1292,2812,-5491,23318,30181,-4087,-9337,25909,15624,15533,23819,-1467,-3391,-32448,-6293,883,30426,26751,6700,30807,-4629,-25760,-6925,23399,7347,15823,1033,19257,31624,-13315,26514,-2966,17315,17056,-15004,9973,-16925,28164,-14910,16330,19456,-7816,-25166,-4510,9446,10801,23433,-12490,-23178,10235,-3197,-2091,-23320,-11210,-16700,1640,-20548,-23780,9675,-30626,10587,-32090,-13768,27157,23817,15578,-31722,-27989,31650,2073,-26940,-19129,8236,22946,26083,-20439,-4275,-31019,26421,-15501,596,-12731,-1657,-1465,-26967,-14514,-19360,-5334,17134,17075,427,31418,29453,-1859,-12033,14421,-14655,-15819,-13759,-6888,7614,24640,-604,-3898,-3481,26122,-8343,-32168,8023,-14453,25805,-9632,-28790,2939,-22188,12103,-28788,3811,20827,20508,18120,7969,-22224,29117,-5337,-22419,-27202,-19809,31035,23423,21961,167,-26878,-24162,28431,-18951,19615,12623,31933,4839,-1346,-32064,3212,-21286,-11268,-3808,4681,-31760,-16154,4792,1859,24678,19668,-12989,-13797,16499,-24971,20816,-7399,-12863,2253,13980,-26383,2937,14252,26731,27624,-6126,13908,7314,-1867,-23777,-18854,16589,-12354,-22322,1677,1699,11037,24871,32112,-2826,-16868,6615,-18696,25345,15948,-30261,-15018,-31609,19400,10586,29771,1627,28043,20509,-964,21486,-2309,-23073,-14370,24281,19613,26836,-26800,30501,-30724,4870,1268,-28775,-3569,-3231,14085,-7525,7564,-8147,32557,10406,-12566,-721,9687,32401,9453,20458,-20141,12115,19376,-31785,-11145,28897,-30957,-31723,31147,-11349,22388,6518,30928,-31876,-28984,-1202,-31158,3222,15823,-32698,-29677,-10550,-29156,5850,-10966,31460,-32630,-5809,-26847,29968,9417,16187,-11943,-21475,-9209,22625,7085,-11560,11011,5889,-32074,-22324,4551,-19039,6383,5161,-714,-29953,8406,-6641,32331,-6503,10707,-9151,-3635,-10281,-15470,-28870,-906,17354,6098,18666,-15695,28979,15619,-31259,3507,15093,26503,5090,5033,15991,32324,-29692,24535,-22716,-22966,-5496,7097,-28791,6240,-21716,-15222,-10695,22466,-21760,1282,-10199,-10148,16187,-21410,-13100,-27543,-7603,-9510,10207,22013,27073,-21322,-25174,16175,14627,1736,30564,6918,4576,21809,2459,-30751,25722,13142,-17540,-6752,-28509,25778,20208,-31518,-6496,21558,-32722,19771,10055,22598,-25028,6236,9411,-30453,-2037,-28345,-23252,-22271,-31524,-25083,-13469,8780,28249,1393,12902,11854,15205,1804,10196,23154,17668,27435,15613,-22630,27901,-20103,-1307,-15072,29277,-31995,31773,21202,14941,-4139,-31968,-1225,7607,30335,27287,-21738,562,17975,-29360,1085,10387,28324,-27838,13722,13643,15006,-9658,17563,6185,-28718,16436,18781,-30025,-23911,14761,-28301,6465,-21157,28349,-5750,32171,30544,4580,-22512,-22289,8082,32390,-30364,7036,-2989,-27928,6110,-4725,-11532,-2191,28121,31799,6048,-12834,-18740,11951,-21949,-11174,-21524,15031,-31472,2909,-12258,-19420,1356,18815,-14268,27121,-2343,26320,-5297,-32717,23941,-13158,-32551,-20649,11472,15859,-13936,-11415,-14132,11615,12473,12874,13505,12081,10704,-3816,19319,15697,-3143,-751,15533,12747,32038,-15723,24689,29418,14496,-4352,1381,17942,-24659,-20759,12156,20298,7345,13259,5756,15764,18165,-103,26545,-5061,-2500,20031,29282,-6900,9998,-2819,-13237,-26174,11830,9467,-2380,-1627,18906,31896,-23416,-3673,30301,-6158,1995,30055,-715,-18786,14411,1812,-22327,-5875,32333,7898,-25892,-16469,-23030,-2901,-19735,-19497,30212,4265,-14259,-14613,-19489,11367,-6834,-11700,-28163,-787,-3769,-23429,16412,-16996,26374,-22305,31263,-32396,14629,30565,-20999,-5218,-31798,-18312,-31168,1768,-3122,14483,-4150,-9502,-24687,-9201,10079,-21750,10259,738,30051,-2917,17914,-8094,-10712,-4073,30461,15102,-728,16427,29966,4034,-10487,26,-16972,-14663,-19710,31235,4869,-12406,1284,-567,12107,19801,-20949,-12748,2875,-21017,26022,-2349,-92,-19753,-1344,10251,-4848,12235,12258,5209,-31772,14211,-13295,7459,30146,-30743,8094,342,-27029,-6558,-2035,85,-28024,-8669,24619,-23105,22011,-20991,21635,-8133,18464,-24618,16063,-1715,-3585,4402,-28214,15265,4220,11671,5893,-192,-20980,26163,20433,19320,20467,15739,21307,11560,31519,12759,-13687,2026,6087,-3931,8067,-18610,20818,7227,674,27181,32682,21034,26429,-31750,-14137,20707,24808,14764,22009,-16358,-2537,-3870,8978,-24835,-7444,-19292,-14546,-14695,-10877,32237,9777,-12212,-10714,24080,25486,-6836,-32181,262,-31145,-28861,-7404,19763,21210,-1677,-28117,-3716,26098,-12715,20427,1730,-21047,203,-5768,15140,16319},
} ;

static void test_encode_953x2115round_impl(long long impl)
{
  unsigned char *s = test_encode_953x2115round_s;
  unsigned char *x = test_encode_953x2115round_x;
  unsigned char *s2 = test_encode_953x2115round_s2;
  unsigned char *x2 = test_encode_953x2115round_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_953x2115round_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_953x2115round(impl);
    printf("encode_953x2115round %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_953x2115round_implementation(impl),ntruprime_dispatch_encode_953x2115round_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_953x2115round;
    printf("encode_953x2115round selected implementation %s compiler %s\n",ntruprime_encode_953x2115round_implementation(),ntruprime_encode_953x2115round_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_953x2115round_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_953x2115round_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_953x2115round_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_953x2115round_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_953x2115round_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_953x2115round_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_953x2115round(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"953x2115round")) return;
  storage_encode_953x2115round_s = callocplus(crypto_encode_STRBYTES);
  test_encode_953x2115round_s = aligned(storage_encode_953x2115round_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_953x2115round_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_953x2115round_x = aligned(storage_encode_953x2115round_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_953x2115round_s2 = callocplus(maxalloc);
  test_encode_953x2115round_s2 = aligned(storage_encode_953x2115round_s2,crypto_encode_STRBYTES);
  storage_encode_953x2115round_x2 = callocplus(maxalloc);
  test_encode_953x2115round_x2 = aligned(storage_encode_953x2115round_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_953x2115round offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_953x2115round();++impl)
      forked(test_encode_953x2115round_impl,impl);
    ++test_encode_953x2115round_s;
    ++test_encode_953x2115round_x;
    ++test_encode_953x2115round_s2;
    ++test_encode_953x2115round_x2;
  }
  free(storage_encode_953x2115round_x2);
  free(storage_encode_953x2115round_s2);
  free(storage_encode_953x2115round_x);
  free(storage_encode_953x2115round_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

