/* ----- core/wforcesntrup761, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_wforcesntrup761_checksums[] = {
  "0b92df5bfe9577b28e57102af63b96169a0b22bcff2c4ae8ecd5030228a2e7f7",
  "87aa3f938b26783a0e83c5dab497ffdc4e77e2ae74c457996253a6ee0a7c2d61",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_wforcesntrup761_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_wforcesntrup761_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_wforcesntrup761_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_wforcesntrup761_CONSTBYTES

static void *storage_core_wforcesntrup761_h;
static unsigned char *test_core_wforcesntrup761_h;
static void *storage_core_wforcesntrup761_n;
static unsigned char *test_core_wforcesntrup761_n;
static void *storage_core_wforcesntrup761_k;
static unsigned char *test_core_wforcesntrup761_k;
static void *storage_core_wforcesntrup761_c;
static unsigned char *test_core_wforcesntrup761_c;
static void *storage_core_wforcesntrup761_h2;
static unsigned char *test_core_wforcesntrup761_h2;
static void *storage_core_wforcesntrup761_n2;
static unsigned char *test_core_wforcesntrup761_n2;
static void *storage_core_wforcesntrup761_k2;
static unsigned char *test_core_wforcesntrup761_k2;
static void *storage_core_wforcesntrup761_c2;
static unsigned char *test_core_wforcesntrup761_c2;

#define precomputed_core_wforcesntrup761_NUM 9

static const unsigned char precomputed_core_wforcesntrup761_h[precomputed_core_wforcesntrup761_NUM][crypto_core_OUTPUTBYTES] = {
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,0,1,0,1,0,0,0,0,0,255,0,0,0,1,0,0,0,0,0,1,0,0,0,0,255,255,0,0,1,1,1,0,255,255,0,255,0,0,1,1,255,1,1,0,255,0,0,0,255,1,1,0,0,0,1,0,0,0,0,255,255,1,0,0,1,0,255,0,1,1,0,1,0,0,0,1,0,0,0,0,255,1,255,0,0,255,1,0,255,0,0,0,0,0,0,0,0,0,0,0,255,0,1,255,0,0,0,255,0,0,0,255,0,0,0,255,255,255,255,1,0,0,0,255,255,255,1,0,1,0,1,1,0,0,0,255,1,0,0,0,0,255,1,0,0,0,0,1,255,1,0,0,0,0,255,1,0,0,0,0,0,1,1,0,0,255,255,255,0,0,1,1,0,0,0,0,0,255,0,1,1,0,0,1,0,0,255,0,0,0,1,1,0,1,255,0,0,255,1,1,0,0,0,0,0,1,0,1,0,255,0,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,1,255,1,0,1,255,1,0,0,0,1,0,0,0,0,0,0,1,255,0,1,0,255,0,1,0,0,255,0,0,0,0,1,0,0,255,0,0,0,1,255,0,255,1,1,0,0,1,0,1,0,0,0,0,0,0,1,0,255,255,0,1,1,0,0,0,255,0,0,0,0,1,0,0,0,0,255,0,1,0,0,1,0,255,1,1,0,0,0,0,1,0,0,0,1,0,0,0,255,0,1,1,0,1,0,1,0,0,255,0,0,255,1,255,0,1,0,0,1,1,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,255,255,0,0,255,0,1,1,0,255,0,255,0,0,0,0,0,255,1,0,0,0,1,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,255,0,255,0,1,0,1,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,255,1,0,1,0,0,0,0,0,0,0,0,255,1,0,0,0,1,255,255,255,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,255,255,0,1,1,0,255,255,0,0,0,1,255,0,0,0,1,0,0,0,0,1,0,0,0,1,0,0,255,0,255,1,1,0,255,255,0,0,1,0,0,1,0,255,255,1,0,255,1,0,1,255,1,255,255,0,0,0,0,1,255,255,1,0,255,0,0,1,255,255,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,0,255,0,0,0,255,0,0,1,255,1,0,1,0,255,0,0,1,1,1,1,0,0,0,0,0,1,0,255,0,0,0,0,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,0,0,0,1,255,0,0,255,255,0,1,255,0,0,0,1,0,1,0,0,255,0,0,1,0,1,255,255,0,1,0,0,0,1,0,1,0,0,1,0,0,255,0,0,0,0,0,0,255,0,255,1,255,0,0,1,0,0,0,0,0,0,0,255,1,0,0,0,1,255,0,0,0,255,0,0,0,0,0,0,0,0,1,0,255,0,0,1,1,1,0,1,0,0,0,0,255,0,0,0,0,1,255,255,255,0,0,0,0,0,0,0,0,0,255,0,255,255,0,255,1,255,255,0,0,0,0,0,1,0,0,1,255,255,1,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
} ;

static const unsigned char precomputed_core_wforcesntrup761_n[precomputed_core_wforcesntrup761_NUM][crypto_core_INPUTBYTES] = {
  {112,132,62,111,156,73,163,166,62,119,49,140,50,168,237,201,153,246,61,9,147,205,118,106,61,186,111,130,164,25,175,252,24,36,239,99,197,40,146,51,192,241,161,155,175,222,89,12,34,67,97,196,76,180,138,230,250,252,117,30,252,204,190,208,244,35,33,4,101,252,76,60,53,249,251,211,36,144,155,133,18,153,4,45,78,83,217,105,140,58,248,100,152,185,248,116,113,90,192,14,69,84,193,73,228,104,80,1,117,72,3,99,248,106,224,238,206,143,250,49,134,38,78,248,82,174,2,145,248,8,208,41,12,173,133,43,29,0,131,85,61,127,239,212,154,53,156,26,179,174,238,165,214,114,189,174,250,165,139,213,154,16,132,91,155,39,234,103,118,95,65,104,44,133,65,90,20,110,93,215,7,35,220,216,191,62,228,27,48,249,239,131,55,74,113,189,121,196,219,13,176,205,35,27,0,127,177,163,240,50,12,32,202,115,22,176,239,87,31,121,106,205,192,99,115,202,170,33,101,125,20,14,216,152,202,104,194,8,142,174,57,249,101,110,81,86,54,53,44,91,49,11,14,205,90,114,165,237,57,132,108,219,63,223,55,105,31,136,23,198,134,155,176,122,249,114,254,118,240,160,19,221,165,111,109,57,64,243,193,108,98,38,132,104,152,7,53,171,230,31,124,12,250,247,194,121,162,8,217,159,73,114,44,89,211,105,180,235,55,136,233,79,55,243,30,47,198,43,175,150,255,200,194,199,229,26,78,33,234,221,176,21,136,116,224,69,125,163,113,254,114,21,35,214,103,125,178,180,206,144,182,164,84,59,212,19,64,228,127,187,120,215,232,133,105,163,182,161,100,252,143,59,223,47,68,204,13,186,26,6,130,179,16,39,93,104,12,167,203,181,129,244,38,101,29,195,131,184,246,216,62,115,214,78,142,53,199,189,179,127,207,85,224,228,177,4,63,79,44,185,135,89,61,124,117,245,192,53,171,130,223,134,152,40,41,172,172,118,76,237,54,247,28,169,111,189,87,191,52,23,151,92,132,143,192,90,92,156,97,252,152,201,248,18,136,54,62,60,3,133,37,173,217,154,131,98,168,167,131,110,78,160,215,27,200,23,88,234,167,209,7,21,151,14,98,212,254,110,223,142,45,3,202,233,194,246,31,19,78,212,50,248,47,229,202,102,214,229,56,223,69,21,53,29,148,59,47,45,141,8,124,120,102,39,108,52,60,52,71,212,169,160,207,244,188,68,212,215,203,59,154,140,47,23,68,163,11,246,180,246,59,7,8,51,34,252,103,76,98,186,191,216,134,51,178,233,230,181,71,172,35,108,143,92,163,150,91,181,38,25,170,56,59,238,80,70,113,170,150,98,197,154,229,16,6,77,85,17,229,21,19,41,162,90,69,106,246,209,65,118,174,242,80,187,70,83,70,38,226,101,56,111,111,207,76,138,140,175,80,45,9,84,60,208,64,5,28,116,189,210,43,39,147,20,0,132,68,42,2,167,192,21,61,5,124,5,225,132,238,193,137,249,75,6,233,12,84,168,63,170,138,252,20,28,134,231,233,34,70,192,119,177,125,149,121,147,221,123,167,80,233,166,179,172,246,56,242,15,34,75,171,123,11,63,37,14,148,71,20,11,116,178,163,253,189,151,58,105,77,111,39,183,55,45,198,205,129,121,69,138,128,111,51,139,246,249,215,105,133,207,27},
  {159,111,88,27,32,195,150,173,58,233,171,70,24,30,51,203,32,71,30,81,196,159,52,32,10,113,120,29,194,134,118,158,139,81,175,125,228,181,5,31,194,220,100,131,209,203,254,29,19,101,14,153,232,45,242,221,69,8,99,9,84,203,33,178,178,36,24,136,74,209,217,217,100,97,123,235,39,54,61,105,58,4,247,98,84,142,239,94,67,108,210,94,200,70,187,204,50,35,221,118,78,71,123,27,78,83,87,139,240,182,22,16,243,188,92,150,155,87,4,149,38,6,200,71,253,75,88,21,186,149,202,137,199,214,241,199,81,2,87,41,137,240,176,137,70,97,99,15,169,24,205,75,16,29,122,94,183,146,198,54,197,151,156,147,118,210,130,240,62,240,150,207,177,109,242,67,183,119,51,5,77,86,28,19,246,128,81,230,137,204,69,36,56,2,49,153,78,23,96,187,29,69,158,194,99,186,173,59,95,145,225,192,119,67,246,107,124,219,203,192,150,133,96,189,168,152,246,6,96,135,185,132,34,84,96,243,174,117,3,137,37,45,234,230,61,105,181,196,131,213,42,24,210,23,90,80,206,5,178,153,8,55,29,122,20,236,194,121,225,225,25,217,119,105,171,174,129,236,251,210,112,155,159,6,102,209,42,17,248,239,233,204,123,172,66,168,161,242,236,236,147,99,238,158,10,55,90,85,126,226,144,110,226,34,188,42,113,6,130,41,136,42,158,250,31,63,181,232,80,210,95,18,238,85,47,116,40,121,74,171,117,20,171,104,107,233,216,78,72,44,131,140,14,98,212,198,243,215,14,103,148,235,67,230,92,148,73,152,12,230,27,213,193,9,210,26,173,159,47,152,170,14,138,64,92,234,45,190,59,30,192,163,74,197,216,138,21,186,167,193,200,56,172,11,128,246,167,183,160,81,50,39,174,211,55,226,239,244,113,142,78,96,17,127,227,149,130,42,43,37,108,24,174,89,248,124,80,102,122,130,211,159,231,93,216,102,61,248,41,186,30,99,68,155,149,193,82,208,202,129,141,65,87,71,86,63,237,38,114,220,171,241,6,143,21,230,237,38,226,14,147,129,26,14,237,148,217,142,153,57,171,124,158,3,131,152,248,200,88,145,60,123,29,158,156,25,168,205,233,53,151,229,138,208,19,241,139,21,75,96,42,203,75,230,122,196,57,86,123,102,44,47,246,244,37,28,30,128,187,31,232,159,164,13,85,122,178,24,141,234,156,172,233,221,163,232,51,51,126,67,1,238,201,241,90,231,5,71,204,226,32,27,123,85,118,121,5,106,62,148,23,17,252,29,213,9,35,100,131,147,134,61,219,145,99,116,73,170,188,80,153,138,178,45,167,57,195,10,82,71,214,7,14,172,60,158,22,232,160,78,105,129,24,231,131,210,138,95,201,171,17,85,214,38,26,102,34,47,227,213,57,241,175,243,17,24,98,144,132,251,103,171,178,176,223,112,78,197,238,244,184,70,0,37,77,98,105,167,222,91,101,87,59,117,217,69,27,54,252,185,103,2,4,195,103,156,18,178,59,165,43,165,255,59,53,88,229,183,189,53,165,51,34,14,52,239,198,223,85,114,222,60,0,158,64,77,220,157,96,203,28,96,195,127,131,17,252,198,9,209,172,176,136,142,157,72,161,69,75,86,230,74,90,83,121,26,177,149,135,150,69,55,65,172,244,251,140,201,55,120,238},
  {68,134,165,160,94,100,78,77,18,79,147,165,148,186,170,35,116,112,74,90,233,190,125,112,68,94,110,75,35,144,33,99,57,201,217,63,8,141,149,239,23,208,6,75,212,63,87,187,230,21,87,251,184,37,35,151,57,254,166,234,236,107,35,61,172,92,124,158,105,24,209,61,29,230,116,118,191,117,171,90,141,194,13,114,233,178,235,46,57,87,26,46,48,185,66,110,92,59,77,173,213,251,178,29,47,66,243,95,213,237,168,126,112,7,229,155,78,96,229,75,176,75,159,57,30,29,19,217,192,249,145,154,214,198,173,76,34,159,85,56,120,13,147,114,188,137,200,229,68,147,24,76,255,179,48,12,221,157,121,251,8,205,231,127,133,142,190,46,117,55,57,115,128,59,142,151,39,187,190,203,194,208,246,105,99,64,244,92,121,51,207,62,141,104,57,67,121,35,76,177,15,94,247,250,192,29,199,204,101,111,234,0,209,201,160,223,63,162,79,217,76,169,12,68,88,111,247,149,253,121,25,23,140,86,62,110,250,145,40,203,74,245,213,21,15,47,150,107,4,65,0,82,113,55,233,70,224,228,121,235,159,249,117,115,223,228,55,27,116,225,17,226,16,64,164,160,197,126,67,196,141,206,37,82,106,36,182,137,243,247,50,136,89,114,154,198,50,122,139,191,218,88,176,113,247,182,184,129,114,65,0,90,117,88,124,243,125,45,203,31,116,31,31,192,22,80,148,54,117,32,46,101,132,26,111,16,28,233,85,118,189,91,141,22,90,216,232,128,19,116,89,168,35,218,81,251,211,252,240,55,52,242,24,212,186,249,57,33,123,102,3,40,47,140,128,248,40,222,108,177,60,129,42,77,24,78,217,122,232,19,153,30,18,122,189,237,142,147,194,12,60,15,222,172,171,60,146,85,89,167,51,120,20,237,229,59,200,28,139,137,74,46,199,16,166,29,167,77,128,251,112,171,197,102,133,12,49,85,224,19,235,81,254,95,45,191,59,140,21,76,73,19,118,214,7,139,129,138,162,77,8,250,1,171,116,165,8,149,80,175,83,2,209,42,130,108,144,46,41,98,90,20,114,175,86,221,23,30,62,96,74,68,129,137,180,239,188,194,96,113,24,203,172,97,154,84,93,76,67,154,183,208,125,208,195,98,167,122,36,239,154,242,227,52,137,86,226,175,160,8,128,28,200,133,114,231,104,225,167,216,62,11,107,114,155,113,26,71,128,71,179,91,196,54,52,34,74,53,70,173,80,210,10,241,196,83,146,83,180,219,141,77,184,4,180,182,174,201,222,39,161,111,235,153,231,132,13,247,168,80,220,32,95,196,125,204,21,23,109,235,202,128,155,72,93,103,216,169,74,174,245,151,211,98,188,82,166,161,14,136,200,45,202,80,20,122,175,90,244,254,171,65,59,227,193,242,173,191,160,2,171,22,97,1,46,236,118,118,94,129,227,189,11,127,118,123,159,116,246,3,136,142,254,184,58,113,150,136,92,199,228,23,82,16,91,34,183,77,252,200,107,165,75,156,10,231,207,109,28,89,208,43,203,233,172,34,190,188,98,181,30,198,89,156,158,138,54,84,141,89,217,71,224,210,31,132,27,77,9,255,47,225,146,30,61,235,13,104,9,198,122,219,169,59,233,238,71,158,94,152,127,23,225,59,36,70,246,63,125,181,152,149,229,167,161,154,244,43,141,86,128},
  {144,203,64,107,77,132,138,95,63,10,24,4,200,1,106,163,42,72,197,194,239,41,99,158,183,78,79,109,119,7,55,246,228,33,51,191,15,69,189,238,178,43,63,247,94,220,105,132,225,214,24,180,31,177,23,180,31,182,229,95,36,31,164,120,178,68,43,128,145,49,244,73,232,125,181,23,189,91,120,41,33,62,143,19,212,195,144,249,105,107,92,150,59,24,33,229,68,232,85,21,179,169,204,173,66,207,234,83,249,78,214,233,177,34,75,82,117,200,112,93,250,44,178,75,59,132,210,246,153,54,195,37,201,13,135,231,62,195,242,206,27,161,124,45,46,32,154,10,36,228,66,4,230,40,154,161,116,174,133,127,80,74,222,123,72,222,43,197,176,109,177,111,65,255,31,164,13,134,181,252,90,35,31,73,73,143,26,7,4,27,127,44,143,213,166,48,42,164,136,210,107,104,142,208,194,37,133,190,63,148,84,88,16,153,156,91,223,121,5,193,49,195,40,88,3,81,43,27,219,149,104,26,235,77,95,214,119,100,209,29,79,211,107,131,117,214,183,105,220,224,131,162,78,32,128,145,89,141,206,247,129,191,10,86,136,60,9,91,226,213,144,77,69,242,143,33,42,220,21,170,113,48,53,229,69,178,52,233,173,115,97,0,230,110,172,183,124,167,118,79,244,89,92,228,205,154,95,145,207,100,230,124,76,179,105,54,187,159,55,85,158,154,118,194,155,30,34,225,21,224,174,203,33,239,45,131,205,18,210,130,59,146,114,1,175,201,163,140,169,209,179,68,179,99,209,235,143,98,53,243,12,94,47,95,115,208,6,160,147,51,242,228,197,232,104,91,74,196,158,101,113,35,211,72,82,34,214,185,215,43,221,48,107,43,75,73,238,152,123,36,124,40,63,76,232,56,26,255,127,143,243,69,122,138,225,218,53,27,225,213,176,172,239,54,219,194,77,202,146,111,169,152,127,64,232,207,107,19,10,42,217,156,94,5,111,203,90,172,48,94,185,74,79,200,43,233,116,23,98,29,165,193,51,111,123,13,121,81,141,102,153,104,33,108,91,29,203,187,127,180,8,6,149,77,57,188,69,91,19,50,35,158,186,26,233,234,83,107,59,237,143,205,30,41,173,148,172,146,92,199,204,51,57,120,141,106,201,158,0,35,90,231,121,221,36,18,212,95,90,74,188,109,11,221,56,68,123,185,76,199,122,99,36,76,62,107,41,88,148,79,26,143,81,160,195,158,72,182,97,158,119,63,157,210,151,167,10,34,174,177,86,244,141,121,89,200,130,51,62,101,134,127,105,231,185,243,105,168,146,117,195,201,214,145,220,204,76,100,72,215,196,32,220,227,253,118,145,144,144,64,49,33,86,171,230,187,213,196,89,3,98,4,71,85,154,91,140,32,115,165,42,234,55,128,191,21,159,18,146,34,21,19,130,92,211,34,119,65,248,185,155,77,238,120,147,15,10,112,252,101,94,81,225,191,69,41,151,250,81,37,67,207,14,239,40,208,133,174,224,142,234,122,111,42,51,127,57,88,191,95,127,200,13,159,186,81,52,244,60,193,178,31,15,37,157,154,110,3,222,74,192,34,102,234,86,23,89,176,205,167,38,219,241,6,147,53,227,250,232,237,249,69,16,59,215,41,82,215,138,159,155,161,138,80,134,36,52,111,10,24,43,85,4,106,36,53,44,134,139,23,241},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
  {0,0,1,255,0,255,0,255,1,255,0,1,0,255,0,1,0,0,0,0,0,0,0,0,1,0,255,1,0,1,0,0,255,0,0,255,0,0,0,0,1,255,0,0,0,0,255,255,0,0,0,1,0,0,255,255,0,0,0,1,0,1,0,0,1,255,1,0,0,0,1,0,0,255,0,0,255,0,0,0,0,0,0,255,0,255,0,1,255,1,0,0,255,0,255,0,0,0,0,255,255,0,0,255,255,0,0,0,0,0,0,0,0,0,0,255,1,255,0,1,1,0,0,1,255,255,0,0,0,0,0,0,0,255,0,1,0,0,0,0,0,255,0,0,0,1,0,0,0,0,255,0,255,0,0,0,0,0,255,1,255,0,0,0,1,1,0,255,0,0,1,0,0,255,0,0,255,0,1,255,0,0,0,255,0,0,0,0,1,1,0,255,1,0,1,255,1,0,255,0,0,1,0,0,0,255,0,0,0,0,0,0,0,0,1,255,255,1,0,0,0,0,0,0,255,1,255,0,0,0,0,0,0,255,0,255,0,1,255,255,0,0,0,0,0,0,0,0,255,0,1,0,1,1,255,0,1,0,1,0,0,0,0,1,1,1,0,255,0,255,1,0,0,0,0,0,0,255,255,1,0,0,0,0,0,255,0,0,1,0,255,1,0,0,0,0,0,0,255,0,1,0,0,0,0,255,255,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,255,0,0,0,0,0,1,0,255,1,0,1,0,0,0,0,0,0,0,1,1,0,255,255,0,0,0,0,0,1,0,255,0,0,1,0,0,255,1,0,0,0,0,0,0,1,1,255,1,255,0,1,0,1,0,255,1,0,1,1,0,0,0,1,0,0,0,255,1,0,0,0,255,1,0,0,0,0,1,1,1,255,0,1,255,0,0,0,0,0,0,0,1,0,255,0,1,0,0,0,0,1,0,0,1,0,0,255,0,0,1,255,0,1,0,255,1,255,255,255,0,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,255,1,255,0,0,255,0,0,1,1,1,0,0,0,1,1,1,255,255,0,255,1,0,0,255,1,0,0,1,0,255,255,255,0,0,0,0,0,255,1,0,0,0,255,1,255,1,1,0,1,255,1,0,1,1,0,0,0,0,0,255,0,1,0,255,0,255,0,0,1,255,1,0,255,255,1,255,0,1,0,1,1,0,0,0,1,1,0,255,1,0,0,0,0,0,0,255,0,0,0,0,1,0,0,255,255,0,255,255,0,0,0,255,255,0,0,0,0,255,255,255,1,1,0,255,255,255,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,255,0,0,0,0,0,0,1,1,1,1,0,0,1,0,255,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,255,255,0,255,1,0,255,0,0,0,0,1,255,0,0,0,255,0,0,0,255,0,0,0,1,1,255,0,1,1,0,0,0,1,0,0,255,255,0,0,0,0,1,0,0,0,0,255,0,0,255,0,1,0,0,255,0,1,0,0,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,0,1,0,255,0,255,0,0,0,255,0,0,0,0,0,0,0,1,1,255,0,255},
  {1,0,1,0,1,0,0,0,0,0,255,0,0,0,1,0,0,0,0,0,1,0,0,0,0,255,255,0,0,1,1,1,0,255,255,0,255,0,0,1,1,255,1,1,0,255,0,0,0,255,1,1,0,0,0,1,0,0,0,0,255,255,1,0,0,1,0,255,0,1,1,0,1,0,0,0,1,0,0,0,0,255,1,255,0,0,255,1,0,255,0,0,0,0,0,0,0,0,0,0,0,255,0,1,255,0,0,0,255,0,0,0,255,0,0,0,255,255,255,255,1,0,0,0,255,255,255,1,0,1,0,1,1,0,0,0,255,1,0,0,0,0,255,1,0,0,0,0,1,255,1,0,0,0,0,255,1,0,0,0,0,0,1,1,0,0,255,255,255,0,0,1,1,0,0,0,0,0,255,0,1,1,0,0,1,0,0,255,0,0,0,1,1,0,1,255,0,0,255,1,1,0,0,0,0,0,1,0,1,0,255,0,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,1,255,1,0,1,255,1,0,0,0,1,0,0,0,0,0,0,1,255,0,1,0,255,0,1,0,0,255,0,0,0,0,1,0,0,255,0,0,0,1,255,0,255,1,1,0,0,1,0,1,0,0,0,0,0,0,1,0,255,255,0,1,1,0,0,0,255,0,0,0,0,1,0,0,0,0,255,0,1,0,0,1,0,255,1,1,0,0,0,0,1,0,0,0,1,0,0,0,255,0,1,1,0,1,0,1,0,0,255,0,0,255,1,255,0,1,0,0,1,1,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,255,255,0,0,255,0,1,1,0,255,0,255,0,0,0,0,0,255,1,0,0,0,1,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,255,0,255,0,1,0,1,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,255,1,0,1,0,0,0,0,0,0,0,0,255,1,0,0,0,1,255,255,255,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,255,255,0,1,1,0,255,255,0,0,0,1,255,0,0,0,1,0,0,0,0,1,0,0,0,1,0,0,255,0,255,1,1,0,255,255,0,0,1,0,0,1,0,255,255,1,0,255,1,0,1,255,1,255,255,0,0,0,0,1,255,255,1,0,255,0,0,1,255,255,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,0,255,0,0,0,255,0,0,1,255,1,0,1,0,255,0,0,1,1,1,1,0,0,0,0,0,1,0,255,0,0,0,0,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,0,0,0,1,255,0,0,255,255,0,1,255,0,0,0,1,0,1,0,0,255,0,0,1,0,1,255,255,0,1,0,0,0,1,0,1,0,0,1,0,0,255,0,0,0,0,0,0,255,0,255,1,255,0,0,1,0,0,0,0,0,0,0,255,1,0,0,0,1,255,0,0,0,255,0,0,0,0,0,0,0,0,1,0,255,0,0,1,1,1,0,1,0,0,0,0,255,0,0,0,0,1,255,255,255,0,0,0,0,0,0,0,0,0,255,0,255,255,0,255,1,255,255,0,0,0,0,0,1,0,0,1,255,255,1,0},
  {1,0,0,0,0,0,1,0,1,255,1,0,255,1,1,1,0,0,0,0,255,255,0,1,0,255,255,0,255,0,0,0,255,0,255,1,0,0,255,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,255,0,1,0,0,0,255,1,1,0,0,255,0,0,255,0,255,1,255,0,0,0,1,0,0,255,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,255,0,0,0,1,1,0,255,0,0,0,0,0,1,1,0,1,0,255,0,1,0,0,0,0,1,0,1,1,1,255,255,0,255,0,0,0,0,1,1,0,0,1,0,0,0,255,0,0,0,0,0,1,255,0,0,0,0,0,0,0,0,0,0,255,1,0,1,0,0,255,255,0,255,1,0,0,1,255,0,1,0,0,255,0,0,1,0,255,0,1,1,0,0,0,0,255,0,0,0,0,0,0,255,255,1,0,0,255,0,0,1,1,255,0,0,0,0,1,255,0,0,0,0,0,0,1,255,0,0,0,1,1,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,255,0,0,0,255,0,255,0,0,0,1,255,1,0,1,1,0,0,0,1,255,0,0,0,0,1,255,0,0,0,1,0,255,0,255,255,0,0,0,0,0,0,0,1,0,1,1,0,255,1,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,0,255,255,0,1,0,0,255,255,1,0,0,255,0,1,1,255,0,0,0,0,1,1,0,0,0,0,1,255,1,1,0,1,1,0,0,0,1,1,0,0,255,255,255,0,255,0,1,1,1,255,0,255,0,0,0,0,255,1,0,0,0,1,255,0,0,255,255,0,0,0,0,255,1,0,0,0,0,255,0,255,0,1,0,1,0,0,0,0,0,1,1,1,0,0,0,1,0,255,0,1,0,0,0,0,0,255,0,1,1,255,0,0,1,0,0,0,1,0,1,0,0,255,255,0,0,1,0,1,0,0,0,0,255,255,0,0,0,1,0,0,1,0,0,0,255,1,255,1,1,0,0,0,1,0,255,255,255,1,255,0,255,255,255,0,1,0,255,0,255,1,0,0,0,1,0,0,0,0,0,0,0,0,1,0,255,0,0,255,0,0,0,0,255,1,0,0,1,1,0,0,0,0,255,255,0,1,0,0,0,0,0,255,0,0,1,0,255,0,0,0,0,1,0,1,0,0,255,255,0,1,255,255,255,0,1,255,0,1,1,0,255,255,255,0,0,0,0,0,255,255,0,1,0,0,255,1,255,0,0,1,0,1,255,0,0,0,0,0,0,1,1,0,0,1,1,255,0,255,0,0,255,0,0,0,0,0,0,0,255,0,0,0,1,0,0,1,0,255,0,1,255,255,0,0,255,0,0,0,0,0,1,1,0,0,0,1,255,1,0,255,1,1,1,0,0,0,0,0,0,0,1,0,1,1,255,0,0,0,0,0,255,0,0,0,0,0,0,255,1,0,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,255,0,1,255,0,0,0,0,0,255,0,0,0,0,0,0,0,1,0,0,255,1,1,255,0,1,0,255,0,0,1,0,0,255,0},
} ;

static const unsigned char precomputed_core_wforcesntrup761_k[precomputed_core_wforcesntrup761_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_wforcesntrup761_c[precomputed_core_wforcesntrup761_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
} ;

static void test_core_wforcesntrup761_impl(long long impl)
{
  unsigned char *h = test_core_wforcesntrup761_h;
  unsigned char *n = test_core_wforcesntrup761_n;
  unsigned char *k = test_core_wforcesntrup761_k;
  unsigned char *c = test_core_wforcesntrup761_c;
  unsigned char *h2 = test_core_wforcesntrup761_h2;
  unsigned char *n2 = test_core_wforcesntrup761_n2;
  unsigned char *k2 = test_core_wforcesntrup761_k2;
  unsigned char *c2 = test_core_wforcesntrup761_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_wforcesntrup761_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_wforcesntrup761(impl);
    printf("core_wforcesntrup761 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_wforcesntrup761_implementation(impl),ntruprime_dispatch_core_wforcesntrup761_compiler(impl));
  } else {
    crypto_core = ntruprime_core_wforcesntrup761;
    printf("core_wforcesntrup761 selected implementation %s compiler %s\n",ntruprime_core_wforcesntrup761_implementation(),ntruprime_core_wforcesntrup761_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    {
      long long weight,i,direction;
      for (weight = 0;weight <= nlen;++weight) {
        for (direction = 0;direction < 2;++direction) {
          output_prepare(h2,h,hlen);
          input_prepare(n2,n,nlen);
          input_prepare(k2,k,klen);
          input_prepare(c2,c,clen);
          for (i = 0;i < nlen;++i) {
            n[i] &= ~1;
            if (direction) {
              if (nlen-1-i < weight) n[i] += 1;
            } else {
              if (i < weight) n[i] += 1;
            }
            n2[i] = n[i];
          }
          crypto_core(h,n,k,c);
          checksum(h,hlen);
          output_compare(h2,h,hlen,"crypto_core");
          input_compare(n2,n,nlen,"crypto_core");
          input_compare(k2,k,klen,"crypto_core");
          input_compare(c2,c,clen,"crypto_core");
          double_canary(h2,h,hlen);
          double_canary(n2,n,nlen);
          double_canary(k2,k,klen);
          double_canary(c2,c,clen);
          crypto_core(h2,n2,k2,c2);
          if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic");
        }
      }
    }
    checksum_expected(core_wforcesntrup761_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_wforcesntrup761_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_wforcesntrup761_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_wforcesntrup761_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_wforcesntrup761_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_wforcesntrup761_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_wforcesntrup761_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_wforcesntrup761_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_wforcesntrup761_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_wforcesntrup761_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_wforcesntrup761(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"wforcesntrup761")) return;
  storage_core_wforcesntrup761_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_wforcesntrup761_h = aligned(storage_core_wforcesntrup761_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_wforcesntrup761_n = callocplus(crypto_core_INPUTBYTES);
  test_core_wforcesntrup761_n = aligned(storage_core_wforcesntrup761_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_wforcesntrup761_k = callocplus(crypto_core_KEYBYTES);
  test_core_wforcesntrup761_k = aligned(storage_core_wforcesntrup761_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_wforcesntrup761_c = callocplus(crypto_core_CONSTBYTES);
  test_core_wforcesntrup761_c = aligned(storage_core_wforcesntrup761_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_wforcesntrup761_h2 = callocplus(maxalloc);
  test_core_wforcesntrup761_h2 = aligned(storage_core_wforcesntrup761_h2,crypto_core_OUTPUTBYTES);
  storage_core_wforcesntrup761_n2 = callocplus(maxalloc);
  test_core_wforcesntrup761_n2 = aligned(storage_core_wforcesntrup761_n2,crypto_core_INPUTBYTES);
  storage_core_wforcesntrup761_k2 = callocplus(maxalloc);
  test_core_wforcesntrup761_k2 = aligned(storage_core_wforcesntrup761_k2,crypto_core_KEYBYTES);
  storage_core_wforcesntrup761_c2 = callocplus(maxalloc);
  test_core_wforcesntrup761_c2 = aligned(storage_core_wforcesntrup761_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_wforcesntrup761 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_wforcesntrup761();++impl)
      forked(test_core_wforcesntrup761_impl,impl);
    ++test_core_wforcesntrup761_h;
    ++test_core_wforcesntrup761_n;
    ++test_core_wforcesntrup761_k;
    ++test_core_wforcesntrup761_c;
    ++test_core_wforcesntrup761_h2;
    ++test_core_wforcesntrup761_n2;
    ++test_core_wforcesntrup761_k2;
    ++test_core_wforcesntrup761_c2;
  }
  free(storage_core_wforcesntrup761_c2);
  free(storage_core_wforcesntrup761_k2);
  free(storage_core_wforcesntrup761_n2);
  free(storage_core_wforcesntrup761_h2);
  free(storage_core_wforcesntrup761_c);
  free(storage_core_wforcesntrup761_k);
  free(storage_core_wforcesntrup761_n);
  free(storage_core_wforcesntrup761_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

