/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * RevisionPicker.java
 *
 * Created on Oct 18, 2010, 3:57:00 PM
 */

package org.netbeans.modules.git.ui.repository;

/**
 *
 * @author ondra
 */
public class RevisionDialog extends javax.swing.JPanel {
    private final RevisionInfoPanel panel;

    /** Creates new form RevisionPicker */
    public RevisionDialog (RevisionInfoPanel panel) {
        this.panel = panel;
        initComponents();
    }

    public RevisionDialog () {
        this.panel = new RevisionInfoPanel();
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        org.netbeans.modules.git.ui.repository.RevisionInfoPanel revisionInfoPanel = panel;
        branchesScrollPane = new javax.swing.JScrollPane();

        lblRevision.setLabelFor(revisionField);
        org.openide.awt.Mnemonics.setLocalizedText(lblRevision, org.openide.util.NbBundle.getMessage(RevisionDialog.class, "RevisionDialog.lblRevision.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(btnSelectRevision, org.openide.util.NbBundle.getMessage(RevisionDialog.class, "RevisionDialog.btnSelectRevision.text")); // NOI18N

        lblBranch.setLabelFor(lstBranches);
        org.openide.awt.Mnemonics.setLocalizedText(lblBranch, org.openide.util.NbBundle.getMessage(RevisionDialog.class, "RevisionDialog.lblBranch.text")); // NOI18N

        branchesPanel.setLayout(new java.awt.BorderLayout());

        lstBranches.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        lstBranches.setToolTipText(org.openide.util.NbBundle.getMessage(RevisionDialog.class, "RevisionDialog.lblBranch.TTtext")); // NOI18N
        branchesScrollPane.setViewportView(lstBranches);

        branchesPanel.add(branchesScrollPane, java.awt.BorderLayout.CENTER);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(revisionInfoPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 513, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(lblRevision)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(revisionField)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(btnSelectRevision))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addComponent(lblBranch)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(branchesPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblRevision)
                    .addComponent(revisionField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnSelectRevision))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblBranch)
                    .addComponent(branchesPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 123, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(revisionInfoPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    final javax.swing.JPanel branchesPanel = new javax.swing.JPanel();
    private javax.swing.JScrollPane branchesScrollPane;
    final javax.swing.JButton btnSelectRevision = new javax.swing.JButton();
    final javax.swing.JLabel lblBranch = new javax.swing.JLabel();
    final javax.swing.JLabel lblRevision = new javax.swing.JLabel();
    final javax.swing.JList lstBranches = new javax.swing.JList();
    final javax.swing.JTextField revisionField = new javax.swing.JTextField();
    // End of variables declaration//GEN-END:variables

}
