/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.web.project.ui.customizer;

import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListSelectionModel;

import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;

/**
 *
 * @author  Radko Najman
 */
public class AddFrameworkPanel extends javax.swing.JPanel {

    /** Creates new form AddFrameworkPanel */
    public AddFrameworkPanel(List usedFrameworks) {
	initComponents();
        jListFrameworks.setCellRenderer(new FrameworksListCellRenderer());
	createFrameworksList(usedFrameworks);
        jListFrameworks.getSelectionModel().setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
    }
    
    private void createFrameworksList(List usedFrameworks) {
        List frameworks = WebFrameworks.getFrameworks();
	DefaultListModel<WebFrameworkProvider> model = new DefaultListModel<>();
	jListFrameworks.setModel(model);
        
	for (int i = 0; i < frameworks.size(); i++) {
	    WebFrameworkProvider framework = (WebFrameworkProvider) frameworks.get(i);
	    if (usedFrameworks.size() == 0)
		model.addElement(framework);
	    else {
                boolean isUsed = false;
		for (int j = 0; j < usedFrameworks.size(); j++)
		    if (((WebFrameworkProvider) usedFrameworks.get(j)).getName().equals(framework.getName())) {
                        isUsed = true;
			break;
		    }
                if (!isUsed)
		    model.addElement(framework);
            }
	}

	
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jListFrameworks = new javax.swing.JList();
        jLabel1 = new javax.swing.JLabel();

        jScrollPane1.setViewportView(jListFrameworks);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/web/project/ui/customizer/Bundle"); // NOI18N
        jListFrameworks.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ListFrameworks")); // NOI18N
        jListFrameworks.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ListFrameworks")); // NOI18N

        jLabel1.setLabelFor(jListFrameworks);
        jLabel1.setText(bundle.getString("LBL_Select_Framework")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
            .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 163, Short.MAX_VALUE))
        );

        getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_AddFramework")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JLabel jLabel1;
    public javax.swing.JList jListFrameworks;
    public javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    
    public List<WebFrameworkProvider> getSelectedFrameworks() {
	List<WebFrameworkProvider> selectedFrameworks = new LinkedList<WebFrameworkProvider>();
	DefaultListModel model = (DefaultListModel) jListFrameworks.getModel();
        int[] indexes = jListFrameworks.getSelectedIndices();
        for (int i = 0; i < indexes.length; i++)
	    selectedFrameworks.add((WebFrameworkProvider)model.get(indexes[i]));
        
        return selectedFrameworks;
    }

    public static class FrameworksListCellRenderer extends DefaultListCellRenderer {
	
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof WebFrameworkProvider) {
                WebFrameworkProvider item = (WebFrameworkProvider) value;
                return super.getListCellRendererComponent(list, item.getName(), index, isSelected, cellHasFocus);
            } else 
		return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

}
