/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.javascript2.json.spi;

import java.beans.PropertyChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.filesystems.FileObject;

/**
 *
 * @author Tomas Zezula
 */
public interface JsonOptionsQueryImplementation {
    @CheckForNull
    Result getOptions(@NonNull FileObject file);

    public static interface Result {
        String PROP_COMMENT_SUPPORTED = "commentSupported"; //NOI18N
        @CheckForNull
        Boolean isCommentSupported();
        void addPropertyChangeListener(@NonNull PropertyChangeListener listener);
        void removePropertyChangeListener(@NonNull PropertyChangeListener listener);
    }
}
