/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.maven.model.util;

import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.w3c.dom.Element;

public class ModelImplUtils {

    private ModelImplUtils() {}

    /**
     * Checks whether a component has a given local name.
     * @param c an element in the document
     * @param name a local name
     * @return true if the names match
     */
    public static boolean hasName(DocumentComponent<?> c, String name) { // #198361
        Element peer = c.getPeer();
        return name.equals(peer.getLocalName()) || name.equals(peer.getNodeName());
    }

}
