package de.intarsys.tools.logging;

import java.util.logging.Filter;
import java.util.logging.LogRecord;

/**
 * Only accept log requests within threads that are tagged with the receiver
 * object.
 * 
 */
public class TaggedThreadFilter implements Filter {

	final private ThreadLocal<TaggedThreadFilter> tag = new ThreadLocal<TaggedThreadFilter>();

	public TaggedThreadFilter() {
		//
	}

	public void activate() {
		tag.set(this);
	}

	public void deactivate() {
		tag.remove();
	}

	public boolean isLoggable(LogRecord record) {
		return this == tag.get();
	}
}
