/*
 * Copyright (c) 2007, intarsys consulting GmbH
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * - Neither the name of intarsys nor the names of its contributors may be used
 *   to endorse or promote products derived from this software without specific
 *   prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package de.intarsys.tools.functor;

/**
 * An argument declaration supporting argument reordering/ naming and default
 * values.
 * 
 */
public class ArgumentDeclaration extends DeclarationElement implements
		IArgumentDeclaration {

	final private IFunctor defaultFunctor;

	final private int index;

	public ArgumentDeclaration(Object declarationContext, String name,
			String modifiers, int index, IDeclaration[] nestedDeclarations) {
		super(declarationContext, name, modifiers, nestedDeclarations);
		this.defaultFunctor = new ConstantFunctor(nestedDeclarations);
		this.index = index;
	}

	public ArgumentDeclaration(Object declarationContext, String name,
			String modifiers, int index, IFunctor defaultFunctor) {
		super(declarationContext, name, modifiers);
		this.defaultFunctor = defaultFunctor;
		this.index = index;
	}

	public IFunctorCall accept(IFunctorCall call) throws DeclarationException {
		IArgs currentArgs = call.getArgs();
		DeclaredArgs declaredArgs = null;
		if (currentArgs instanceof DeclaredArgs) {
			declaredArgs = (DeclaredArgs) currentArgs;
		} else {
			declaredArgs = createDeclaredArgs(currentArgs);
			call.setArgs(declaredArgs);
		}
		declaredArgs.declare(call, this);
		return call;
	}

	protected DeclaredArgs createDeclaredArgs(IArgs currentArgs) {
		return DeclaredArgs.createTransparent(currentArgs);
	}

	public IFunctor getDefaultFunctor() {
		return defaultFunctor;
	}

	public int getIndex() {
		return index;
	}

}
