/*
 * Qt wrapper for libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: LGPL v2.1 or LGPL v3
 */
#ifndef QINDICATEINTEREST_H
#define QINDICATEINTEREST_H

// Qt
#include <QMetaType>

namespace QIndicate
{

// Porting note: keep this synced with libindicate/interests.h
enum Interest {
	InterestNone,             /**< We're of no interest */
	InterestServerDisplay,    /**< Displays the server's existance to the user */
	InterestServerSignal,     /**< Will send signals to the server to be displayed */
	InterestIndicatorDisplay, /**< Displays indicators to the user */
	InterestIndicatorSignal,  /**< Will return signals based on individual indicators being responded to */
	InterestIndicatorCount,   /**< Only displays a count of the indicators */
	InterestLast              /**< Makes merges and counting easier */
};

} // namespace

Q_DECLARE_METATYPE(QIndicate::Interest)

#endif /* QINDICATEINTEREST_H */
