with GNAT.OS_Lib;  use GNAT.OS_Lib;
with GNATCOLL.VFS; use GNATCOLL.VFS;
with Ada.Text_IO;  use Ada.Text_IO;

procedure Main is
   DS : constant Character := GNAT.OS_Lib.Directory_Separator;

   procedure Assert (V1, V2 : String; Msg : String);
   procedure Assert (V1, V2 : String; Msg : String) is
   begin
      if V1 /= V2 then
         Put_Line (Msg);
         Put_Line ("Expected: " & V1);
         Put_Line ("Got     : " & V2);
      end if;
   end Assert;

   Folder : Virtual_File;
   F : Virtual_File;
begin

   ------------
   -- Case 1 --
   ------------
   --  Using a directory that is not a full name (and where the .. cannot
   --  be resolved)

   Folder := Create (+".." & DS & ".." & DS & "foo" & DS);

   F := Create_From_Dir
      (Dir => Folder, Base_name => +"file.ads");
   Assert (".." & DS & ".." & DS & "foo" & DS & "file.ads",
           F.Display_Full_Name,
           "With base name and relative directory");
   Assert (".." & DS & ".." & DS & "foo" & DS & "file.ads",
           F.Display_Full_Name (Normalize => True),
           "Normalized with base name and relative directory");

   F := Create_From_Dir
      (Dir => Folder, Base_name => +"file.ads", Normalize => True);
   Assert (".." & DS & ".." & DS & "foo" & DS & "file.ads",
           F.Display_Full_Name,
           "With base name and relative directory");
   Assert (".." & DS & ".." & DS & "foo" & DS & "file.ads",
           F.Display_Full_Name (Normalize => True),
           "Normalized with base name and relative directory");

   ------------
   -- Case 2 --
   ------------

   Folder := Create (+"foo1" & DS & "foo2" & DS & "foo3" & DS & "");

   F := Create_From_Dir
      (Dir => Folder, Base_name => +".." & DS & ".." & DS & "file.ads");
   Assert ("foo1" & DS & "foo2" & DS & "foo3" & DS
           & ".." & DS & ".." & DS & "file.ads",
           F.Display_Full_Name,
           "When file is relative to absolute directory");
   Assert ("foo1" & DS & "file.ads",
           F.Display_Full_Name (Normalize => True),
           "Normalized name when file is relative to absolute directory");

   F := Create_From_Dir (
      Dir => Folder, Base_name => +".." & DS & ".." & DS & "file.ads",
      Normalize => True);
   Assert ("foo1" & DS & "foo2" & DS & "foo3" & DS & ".."
           & DS & ".." & DS & "file.ads",
           F.Display_Full_Name,
           "When file is relative to normalized absolute directory");
   Assert ("foo1" & DS & "file.ads",
           F.Display_Full_Name (Normalize => True),
           "Normalized name when file is relative to normalized absolute"
           & " directory");

   ------------
   -- Case 3 --
   ------------
   --  Using an absolute directory, where the .. can be resolved

   Folder := Create
      (+"" & DS & "foo1" & DS & "foo2" & DS & "foo3" & DS
       & ".." & DS & ".." & DS & "foo" & DS & "");

   F := Create_From_Dir
      (Dir => Folder, Base_name => +"file.ads");
   Assert ("" & DS & "foo1" & DS & "foo2" & DS & "foo3" & DS & ".."
           & DS & ".." & DS & "foo" & DS & "file.ads",
           F.Display_Full_Name,
           "When file is relative to absolute directory with ..");
   Assert ("" & DS & "foo1" & DS & "foo" & DS & "file.ads",
           F.Display_Full_Name (Normalize => True),
           "Normalized name when file is relative to absolute directory"
           & " with ..");

   F := Create_From_Dir
      (Dir => Folder, Base_name => +"file.ads", Normalize => True);
   Assert ("" & DS & "foo1" & DS & "foo" & DS & "file.ads",
           F.Display_Full_Name,
           "When file is relative to normalized absolute directory with ..");
   Assert ("" & DS & "foo1" & DS & "foo" & DS & "file.ads",
           F.Display_Full_Name (Normalize => True),
           "Normalized name when file is relative to normalized absolute"
           & " directory with ..");

end Main;
