with Ada.Strings.Unbounded;  use Ada.Strings.Unbounded;
with Ada.Text_IO;            use Ada.Text_IO;
with DB;                     use DB;
with GNATCOLL.SQL;           use GNATCOLL.SQL;
with GNATCOLL.SQL.Exec;      use GNATCOLL.SQL.Exec;
with GNATCOLL.SQL.Postgres;  use GNATCOLL.SQL.Postgres;
with GNATCOLL.SQL_Fields;    use GNATCOLL.SQL_Fields;

procedure Main is
   use GNATCOLL.SQL.Postgres.DateRanges;
   use GNATCOLL.SQL.Postgres.NumRanges;

   Descr : constant Database_Description := Setup (Database => "testdb");
   DB    : constant Database_Connection := Build_Connection (Descr);

begin

   declare
      Dates1 : constant Date_Range := DateRanges.Create_Range
         (Date_Fields.From_String ("'2015-01-01'"),
          Date_Fields.From_String ("'2015-12-31'"),
          Max_Included => False);
      Num1   : constant Num_Range := NumRanges.Create_Range
         (Expression (0.0),
          Expression (2.0));
      Q : constant SQL_Query := SQL_Insert
         (Values => (Mytable.Id = 1)
            & (Mytable.Dates = Dates1)
            & (Mytable.Values = Num1));
   begin
      Put_Line (To_String (To_String (Q, DB.all)));
   end;

   declare
      Dates2 : constant Date_Range := DateRanges.Create_Min_Unbounded_Range
         (Date_Fields.From_String ("'2015-12-31'"));
      Num2   : constant Num_Range := NumRanges.Create_Range
         (Null_Field_Float, Expression (2.0));
      Q3 : constant SQL_Query := SQL_Insert
         (Values => (Mytable.Id = 2)
            & (Mytable.Dates = Dates2)
            & (Mytable.Values = Num2));
   begin
      Put_Line (To_String (To_String (Q3, DB.all))); 
   end;

   declare
      Dates3 : constant Date_Range := DateRanges.Create_Max_Unbounded_Range
         (Date_Fields.From_String ("'2015-12-31'"));
      Num3   : constant Num_Range := NumRanges.Create_Range
         (Expression(0.0), Null_Field_Float);
      Q4 : constant SQL_Query := SQL_Insert
         (Values => (Mytable.Id = 3)
            & (Mytable.Dates = Dates3)
            & (Mytable.Values = Num3));
   begin
      Put_Line (To_String (To_String (Q4, DB.all))); 
   end;

   declare
      Q5 : constant SQL_Query := SQL_Insert
         (Values => (Mytable.Id = 3)
            & (Mytable.Dates = DateRanges.Empty_Range)
            & (Mytable.Values = NumRanges.Empty_Range));
   begin
      Put_Line (To_String (To_String (Q5, DB.all))); 
   end;

   declare
      Q2 : constant SQL_Query := SQL_Select
         (Lower (Mytable.Dates)
             & Upper (Mytable.Dates)
             & Merge (Mytable.Dates, Mytable.Dates),
          From => Mytable,
          Where => Is_Empty (Mytable.Values)
             and Adjacent_To (Mytable.Values, Mytable.Values)
             and Contains (Mytable.Dates, Mytable.Dates));
   begin
      Put_Line (To_String (To_String (Q2, DB.all))); 
   end;

end Main;
