with Ada.Text_IO;     use Ada.Text_IO;
with GNATCOLL.JSON;   use GNATCOLL.JSON;

procedure Test_Clone is
   Val1, Val2, Val3 : JSON_Value;
begin
   declare
      Arr : JSON_Array;
      Val3 : JSON_Value;
   begin
      Val1 := Create_Object;
      Val1.Set_Field ("C", "C");
      Append (Arr, Create (Integer'(1)));
      Append (Arr, Create ("A"));
      Val3 := Create_Object;
      Val3.Set_Field ("A", Integer'(1));
      Append (Arr, Val3);
      Val1.Set_Field ("A", Arr);
      Val1.Set_Field ("B", "B");

      Put_Line ("Initial values");
      Val2 := Val1;
      Val3 := Val1.Clone;
      Put_Line (Write (Val1));
      Put_Line (Boolean'Image (Val1 = Val2) & " " & Write (Val2));
      Put_Line (Boolean'Image (Val1 = Val3) & " " & Write (Val3));

      Put_Line ("Modifying array has no impact on existing values");
      Set_Element (Arr, 1, Create (Integer'(2)));
      Put_Line (Write (Val1));
      Put_Line (Boolean'Image (Val1 = Val2) & " " & Write (Val2));
      Put_Line (Boolean'Image (Val1 = Val3) & " " & Write (Val3));

      Put_Line ("Removing a field");
      Val1.Unset_Field ("C");
      Put_Line (Write (Val1));
      Put_Line (Boolean'Image (Val1 = Val2) & " " & Write (Val2));
      Put_Line (Boolean'Image (Val1 = Val3) & " " & Write (Val3));

      Put_Line ("Set the field again");
      Val1.Set_Field ("C", "C");
      Put_Line (Write (Val1));
      Put_Line (Boolean'Image (Val1 = Val2) & " " & Write (Val2));
      Put_Line (Boolean'Image (Val1 = Val3) & " " & Write (Val3));

      Put_Line ("Modifying field, was a string");
      Val1.Set_Field ("B", "B2");
      Put_Line (Write (Val1));
      Put_Line (Boolean'Image (Val1 = Val2) & " " & Write (Val2));
      Put_Line (Boolean'Image (Val1 = Val3) & " " & Write (Val3));

      Put_Line ("Modifying field, was an array");
      Val1.Set_Field ("A", Integer'(1));
      Put_Line (Write (Val1));
      Put_Line (Boolean'Image (Val1 = Val2) & " " & Write (Val2));
      Put_Line (Boolean'Image (Val1 = Val3) & " " & Write (Val3));

   end;
end Test_Clone;
