#!/usr/bin/env python

import os
import os.path
import json

TEN_MILL = 10000000

if not os.path.isdir('json'):
    os.makedirs('json')

def save(fname, data):
    with file(fname,'w') as f:
        f.write(json.dumps(data))

# 10 meg
data = []
for x in xrange(3000):
    data.append(
        {
            "a": "b"*1024,
            "c":"d"*2048,
            "e":"f"*512,
        })
save("json/1.json", data)

# 29 meg
data = []
for x in xrange(3):
    data.append( "a"*TEN_MILL);
save("json/2.json", data)

# 57 meg
data = []
for x in xrange(3):
    data.append( {"a"*TEN_MILL:"b"*TEN_MILL} )
save("json/3.json", data)

# 19 meg
# very large float
with file("json/4.json",'w') as f:
    f.write ("[")
    f.write ("1"*TEN_MILL+"."+"3"*TEN_MILL)
    f.write ("]")

# 10 meg
# generate a very large int
with file("json/5.json",'w') as f:
    f.write ("[")
    f.write ("5"*TEN_MILL)
    f.write ("]")

# bad booleans
with file("json/6.json",'w') as f:
    f.write ("[")
    f.write ("tru"+"e"*TEN_MILL)
    f.write (",fals"+"e"*TEN_MILL)
    f.write ("]")
