------------------------------------------------------------------------------
--                                                                          --
--                	        G N A T C O L L                             --
--                                                                          --
--                      Copyright (C) 2008-2014, AdaCore                    --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

package body GNATCOLL.Ravenscar.Sporadic_Server_With_Callback is

   procedure Put_Request
     (In_Par : In_Param;
      CB       : Callback)
   is
   begin

      --  a simple delegation

      My_Sporadic_Task.Put_Request ((In_Par, CB));

   end Put_Request;

   procedure Dispatch (Req : Queue_Item) is
      Out_Par : Out_Param;
   begin

      --  first execute the nominal operation

      Sporadic_Operation (Req.In_Par, Out_Par);

      --  then the callback

      Req.CB.all (Out_Par);

   end Dispatch;

end GNATCOLL.Ravenscar.Sporadic_Server_With_Callback;
