#if   !defined(__UPPERCASECOMMAND_HPP)
#define  __UPPERCASECOMMAND_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__COMMAND_HPP)
#include <corelinux/Command.hpp>
#endif

/**
UpperCaseCommand takes a string and converts it to upper
case. If a reverse command is assigned, it tests it for
a RestoreCaseCommand and assigns the original and restoration
locations accordingly.
*/

DECLARE_CLASS( UpperCaseCommand );

class UpperCaseCommand : public CORELINUX( Command )
{

public:

   //
   // Constructors and destructors
   //

                     /// Default takes string argument

                     UpperCaseCommand( const std::string & );

                     /// Copy constructor

                     UpperCaseCommand( UpperCaseCommandCref );

                     /// Virtual Destructor

   virtual           ~UpperCaseCommand( void );

   //
   // Operator overloads
   //
            /// Assignment operator

            UpperCaseCommandRef  operator=( UpperCaseCommandCref );

            /// Equality operator

            bool operator==( UpperCaseCommandCref ) const;

   //
   // Accessors
   //
            /// Retrieve the original value

            const std::string &  getOriginalValue( void ) const;

            /// Retrieve the new value

            const std::string &  getNewValue( void ) const;
   //
   // Methods supplied as per command interface
   //
            /// Override to set reverse information

   virtual  void  setReverseCommand( CORELINUX(AbstractCommandPtr) );

            /// Execute the upper case routine

   virtual  void  execute( void ) ;

protected:

                     /// Default is an error, need string   

                     UpperCaseCommand( void ) 
                        throw ( CORELINUX( Assertion ) );

protected:

            std::string    *theOriginalValue;
            std::string    *theNewValue;
private:


};

#endif // if !defined(__UPPERCASECOMMAND_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/04 05:41:59 $
   $Locker:  $
*/


