#if !defined (__TYPES_HPP)
#define __TYPES_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   


#if !defined IN_COMMON_HPP
#error Types.hpp is included via Common.hpp only.
#endif

namespace   corelinux
{
   
   /** @name Types
   Type defintions in the hopes to avoid portability
   problems and provide consistent standard naming
   style. Under Construction!!!
   */

   #if !defined( __UNICODE )
   DECLARE_TYPE( char,    Char  );      // non-Unicode character.
   #else
   DECLARE_TYPE( wchar_t, Char );       // Unicode character   
   #endif
   
   DECLARE_TYPE( wchar_t, Wchar );      // Wide character.
   
   // *******************************************
   // Signed Integral Types
   // *******************************************
   
   DECLARE_TYPE( short int, Short );               // 16 bits.
   DECLARE_TYPE( long int,  Long  );               // 32 bits.
   DECLARE_TYPE( int,   Int   );                   // Compiler Depend
   DECLARE_TYPE( unsigned int, UnsignedInt );      //
   
   // *******************************************
   // Unsigned Integral Types
   // *******************************************
   
   DECLARE_TYPE( unsigned char,  Byte   );          // 8 Bits.
   DECLARE_TYPE( unsigned short, Word   );          // 16 Bits.
   DECLARE_TYPE( unsigned long,  Dword  );          // 32 Bits.
   
   // *******************************************
   // Floating Point.
   // *******************************************
   
   DECLARE_TYPE( double, Real );
   
   // *******************************************
   // Define the void pointer type.
   // *******************************************
   
   typedef void * VoidPtr;
   
   // *******************************************
   // Define the NULLPTR
   // *******************************************
   
   #define  NULLPTR  0
   
   // *******************************************
   // Miscellaneous
   // *******************************************
   
   DECLARE_TYPE( size_t, Size    );                 // The size of an object.
   DECLARE_TYPE( Dword,  Index   );                 // Array or loop index.
   DECLARE_TYPE( Long,   Counter );                 // A signed counting type.
   DECLARE_TYPE( Word,   ResID   );                 // Resource or message id.
   
   DECLARE_TYPE( Dword, Count );
   
   // *******************************************
   // Operating System Handles and ids.
   // *******************************************
   
   DECLARE_TYPE( VoidPtr, Handle );
   
   // **********************************************
   // Define MessageID as a Dword for OS::STDMESSAGE
   // message identifiers.
   // **********************************************
   
   DECLARE_TYPE( Dword, MessageID );
   
}

#endif          // !defined __TYPES_HPP

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/05/25 04:26:14 $
   $Locker:  $
*/

