#if   !defined(__PROTOTYPE_HPP)
#define  __PROTOTYPE_HPP

/*
   CoreLinux++ 
   Copyright (C) 1999 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

namespace corelinux
{
   /**
   Specify the kinds of objects to create using a prototypical instance, 
   and create new objects by copying (cloning) this prototype.
   */

   template< class TypeImpl >
      class Prototype : public CoreLinuxObject
      {
      public:

         //
         // Constructors and destructor
         //

                           /// Default constructor

                           Prototype( void )
                              :
                              CoreLinuxObject()
                           {
                              ;  // do nothing
                           }

                           /**
                           Copy constructor
                           @param Prototype const reference
                           */

                           Prototype( const Prototype & aPrototype )
                              :
                              CoreLinuxObject( aPrototype )
                           {
                              ;  // do nothing
                           }

                           /// Virtual destructor

         virtual           ~Prototype( void )
                           {
                              ;  // do nothing
                           }

         //
         // Operator overload
         //

                  /**
                  Assignment operator
                  @param Prototype const reference
                  @return Prototype reference to this instance
                  */

                  Prototype & operator=( const Prototype & aPrototype )
                  {
                     CoreLinuxObject::operator=( aPrototype );
                     return ( *this );
                  }

                  /**
                  Equality operator
                  @param Prototype const reference
                  @return bool if instances are same
                  */

                  bool  operator==( const Prototype & aPrototype ) const
                  {
                     return CoreLinuxObject::operator==( aPrototype );
                  }

         //
         // Pure virtual methods
         //

                  /**
                  clone is used to create a copy of the current
                  prototype instance.
                  @return TypeImpl pointer
                  */

         virtual  TypeImpl *  clone( void ) const = 0 ;
         
   
      };
}

#endif // if   !defined(__PROTOTYPE_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/

