#if   !defined(__BAR_HPP)
#define  __BAR_HPP
/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if !defined(__COMMON_HPP)
#include <Common.hpp>
#endif 

DECLARE_CLASS( Bar );

/**
Class Bar describes the Adaptee target that we want to behave like Foo.

Bar is an class that specifies a screen coordinate system that
is based on that 0,0 (X,Y) is the top left hand corner of the screen. It
does not have a minimum or maximum.
*/

class Bar
{

public:

                     /// Default Constructor

                     Bar( void );

                     /// Constructor with known coordinates

                     Bar( CORELINUX(Int) aX, CORELINUX(Int) aY );

                     /// Copy constructor

                     Bar( BarCref );

                     /// Destructor

   virtual           ~Bar( void );

   //
   // Operator overloads
   //

            /// Assignment operator

            BarRef   operator=( BarCref );

            /// Equality operator

            bool     operator==( BarCref );

   //
   // Accessors
   //

            /// Return the Y coordinate of the point

            CORELINUX(IntCref)  getVertical( void ) const;

            /// Return the X coordinate of the point

            CORELINUX(IntCref)  getHorizontal( void ) const;
                     
   //
   // Mutators
   //
            /// Sets the Y coordinate

            void     setVertical( CORELINUX(Int) );

            /// Sets the X coordinate

            void     setHorizontal( CORELINUX(Int) );


protected:


private:

            ///   Y coordinate storage

            CORELINUX(Int)      theVertical;

            ///   X coordinate storage

            CORELINUX(Int)      theHorizontal;
};

#endif

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.4 $
   $Date: 2000/02/10 14:32:20 $
   $Locker:  $
*/

