#if   !defined(__ABSTRACTFACTORY_HPP)
#define __ABSTRACTFACTORY_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__ALLOCATOR_HPP)
#include <Allocator.hpp>
#endif

#if   !defined(__ALLOCATORNOTFOUNDEXCEPTION_HPP)
#include <AllocatorNotFoundException.hpp>
#endif

#if   !defined(__ALLOCATORALREADYEXISTSEXCEPTION_HPP)
#include <AllocatorAlreadyExistsException.hpp>
#endif

#if   !defined(__ASSOCIATIVEITERATOR_HPP)
#include <AssociativeIterator.hpp>
#endif

#if   !defined(__ITERATOR_HPP)
#include <Iterator.hpp>
#endif

namespace corelinux
{

   /**
   AbstractFactory provides an interface for creating families of
   related or dependent objects without specifying their concrete
   classes.
   @see Allocator, AbstractAllocator, Identifier, 
   Iterator, AssociativeIterator
   */

   template< class UniqueId >
      class AbstractFactory : public CoreLinuxObject
      {
   
      public:
   
         //
         // Constructors and Destructor
         //
   
                           /// Default constructor
   
                           AbstractFactory( void )
                              :
                              CoreLinuxObject()
                           {
                              ;  // do nothing
                           }
   
                           /**
                           Copy Constructor
                           @param AbstractFactory const reference
                           */
   
                           AbstractFactory( const AbstractFactory & )
                              :
                              CoreLinuxObject()
                           {

                           }
   
                           /// Virtual Destructor
   
         virtual           ~AbstractFactory( void ) 
                           {
                              ;  // do nothing
                           }
   
         //
         // Operator overloads
         //
   
                  /**
                  Assignment operator
                  @param AbstractFactory const reference
                  @return AbstractFactory reference
                  */
   
                  AbstractFactory & operator=( const AbstractFactory & )
                  {
                     return ( *this );
                  }
   
                  /**
                  Equality operator
                  @param AbstractFactory const reference
                  @return bool - true if instances are same
                  */
   
                  bool  operator==( const AbstractFactory & aRef ) const
                  {
                     return( this == &aRef );
                  }
   
         //
         // Pure virtual accessors
         //

                  /**
                  Returns the number of total creates
                  for this factory.
                  @return  corelinux::Count 
                  */
   
         virtual  Count getCreateCount( void ) const = 0;
   
                  /**
                  Returns the number of total destroys
                  for this factory.
                  @return  corelinux::Count 
                  */
   
         virtual  Count getDestroyCount( void ) const = 0;
   
   
                  /**
                  Retrieve the allocator identified by argument from
                  the implementation
                  @param Identifier const reference
                  @return Allocator pointer
                  @exception AllocatorNotFoundException
                  */
   
         virtual  AllocatorPtr   getAllocator( UniqueId ) const
                     throw(AllocatorNotFoundException) = 0;
   
         //
         // Pure virtual mutators
         //
   
                  /**
                  Add a allocator to the factory implementation
                  @param Allocator pointer
                  @exception AllocatorAlreadyExistsException
                  */
   
         virtual  void  addAllocator( UniqueId, AllocatorPtr )
                           throw(AllocatorAlreadyExistsException) = 0;
   
                  /**
                  Retrieve and remove the allocator identified by 
                  argument from the implementation
                  @param Identifier const reference
                  @return Allocator pointer
                  @exception AllocatorNotFoundException
                  */
   
         virtual  AllocatorPtr   removeAllocator( UniqueId )
                                    throw(AllocatorNotFoundException) = 0;
   
         //
         // Iterator factory methods
         //
                  /**
                  Interface for creating an Iterator to iterate
                  through the Allocators of an implementation.
                  @return Iterator pointer of type Allocator pointer
                  */
   
         virtual  Iterator<Allocator *> *   createIterator( void ) const = 0;
   
                  /**
                  Interface for returning a created Iterator.
                  @return Iterator pointer of type Allocator pointer
                  */
   
         virtual  void  destroyIterator( Iterator<Allocator *> * ) const = 0;
   
                  /**
                  Interface for creating an AssociativeIterator to iterate
                  through the Identifiers and Allocators of an implementation.
                  @return AssociativeIterator pointer of type 
                  <Identifier,Allocator pointer>
                  */
   
         virtual  AssociativeIterator<UniqueId,Allocator *> *   
                     createAssociativeIterator( void ) const = 0;
   
                  /**
                  Interface for returning a created AssociativeIterator.
                  @return Iterator pointer of type 
                  <Identifier,Allocator pointer>
                  */
   
         virtual  void  destroyAssociativeIterator
                           ( 
                              AssociativeIterator<UniqueId,Allocator *> * 
                           ) const = 0;
   
      };
}

#endif //   if   !defined(__ABSTRACTFACTORY_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/

