/***************************************************************************
 *   Copyright (C) 2003-2007 by Spiros Georgaras <sng@hellug.gr>           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#include <qregexp.h>
#include <qfileinfo.h>
#include "filesdata.h"
//================================
filesData::filesData(){
	mItems=-1;
	files=0;
}
//================================
filesData::~filesData(){
	delete [] files;
}
//================================
int filesData::setItems(int items){
	numOfFiles= items;
	files=new QFileInfo[items];
	if(files==NULL) return -1;
	for(int i=0;i<items;i++) files[i].setCaching(FALSE);
	mItems=items;
	return 0;
}
//================================
int filesData::reSetItems(int items){
	numOfFiles= items;
	if(files)
		delete [] files;
	files=new QFileInfo[items];
	if(files==NULL) return -1;
	for(int i=0;i<items;i++) files[i].setCaching(FALSE);
	mItems=items;
	return 0;
}
//================================
int filesData::items(void){
	return mItems;
}
//================================
int filesData::getType(){
	int first;
  //if(numOfFiles == 1)
	first=whatType(0);
	if(first==0){
		Type=first;
		return first;
	}
	for(int i=1;i<numOfFiles;i++){
		if((whatType(i))!=first){
			if(first==0){
				Type=first;
				return first;
			}else{
				Type=-1;
				return -1;
			}
		}
	}
	Type=first;
	if(first==1){
		bool same=TRUE;
// 		QString fExt=files[0].extension(FALSE).lower(); old impl (could use completeSuffix?)
		QString fExt=files[0].suffix().toLower();
		for(int i=1;i<numOfFiles && same;i++)
// 			if((files[i].extension(FALSE).lower())!=fExt) same=FALSE; old impl (could use completeSuffix?)
			if((files[i].suffix().toLower())!=fExt) same=FALSE;
		if(same) typeExtension=fExt.toLower();
	}
	return first;
}
//================================
bool filesData::canRename(){
	for(int i=0;i<numOfFiles;i++)
		if( !files[i].isWritable() ) return FALSE;
	return TRUE;
}
//================================
bool filesData::samePath(void){
	for(int i=1;i<numOfFiles;i++)
		if(files[0].path()!=files[i].path()) return FALSE;
	return TRUE;
}
//================================
int filesData::whatType(int item){
	if(numOfFiles==0)
		return 0;
	else if(files[item].isFile())
		return 1;
	else if(files[item].isDir())
		return 2;
	else
		return 0;
}




